/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EnumPath;
import com.querydsl.core.types.dsl.NumberPath;
import ext.java.lang.QInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.cyclos.entities.access.AccessClient;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.IdentityProvider;
import org.cyclos.entities.access.OidcAccessToken;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.access.Pin;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.access.QSession;
import org.cyclos.entities.access.Session;
import org.cyclos.entities.access.SessionProperties;
import org.cyclos.entities.access.TrustedDevice;
import org.cyclos.entities.system.ChannelAccessAccessor;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.CustomSessionConfiguration;
import org.cyclos.entities.system.Language;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.DelegatingUserPrincipal;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.ApplicationInitializationListener;
import org.cyclos.impl.BaseGlobalHandlerImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.AccessClientServiceLocal;
import org.cyclos.impl.access.AgreementLogServiceLocal;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.CredentialAccessor;
import org.cyclos.impl.access.DeviceConfirmationServiceLocal;
import org.cyclos.impl.access.FailedAction;
import org.cyclos.impl.access.FailedActionHandler;
import org.cyclos.impl.access.OidcServiceLocal;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.access.PrincipalTypeServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.access.SessionHandler;
import org.cyclos.impl.access.SessionTimeoutHandler;
import org.cyclos.impl.access.StatefulUserSessionData;
import org.cyclos.impl.access.TrustedDeviceServiceLocal;
import org.cyclos.impl.access.UserChannelServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.system.InlineScriptBackgroundTask;
import org.cyclos.impl.users.LocateUserOption;
import org.cyclos.impl.users.LocateUserResult;
import org.cyclos.impl.users.UserLocatorHandler;
import org.cyclos.impl.utils.PushNotificationEventContext;
import org.cyclos.impl.utils.PushNotificationHandler;
import org.cyclos.impl.utils.SharedStorage;
import org.cyclos.impl.utils.cluster.ClusterHandler;
import org.cyclos.impl.utils.cluster.SharedStorageType;
import org.cyclos.impl.utils.conversion.ConversionHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.tasks.BackgroundTaskHandler;
import org.cyclos.impl.utils.tasks.BackgroundTaskScheduling;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.UserStatusException;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.InaccessibleChannelException;
import org.cyclos.model.access.InaccessibleGroupException;
import org.cyclos.model.access.InaccessiblePrincipalException;
import org.cyclos.model.access.InvalidChannelUsageException;
import org.cyclos.model.access.InvalidDeviceConfirmationException;
import org.cyclos.model.access.InvalidNetworkException;
import org.cyclos.model.access.InvalidPinRemovedException;
import org.cyclos.model.access.LoginException;
import org.cyclos.model.access.OperatorWithPendingAgreementsException;
import org.cyclos.model.access.PasswordException;
import org.cyclos.model.access.PasswordStatusException;
import org.cyclos.model.access.RemoteAddressBlockedException;
import org.cyclos.model.access.SecondaryLoginConfirmationField;
import org.cyclos.model.access.UnauthorizedURLException;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.access.passwords.PasswordStatus;
import org.cyclos.model.access.passwordtypes.PasswordTypeVO;
import org.cyclos.model.access.principaltypes.PrincipalTypeVO;
import org.cyclos.model.system.configurations.AllowAccessMode;
import org.cyclos.model.system.languages.BuiltinLanguage;
import org.cyclos.model.system.scripts.CustomScriptException;
import org.cyclos.model.system.scripts.ScriptFunction;
import org.cyclos.model.system.scripts.SessionHandlingScriptFunction;
import org.cyclos.model.users.groups.AdminGroupType;
import org.cyclos.model.users.users.LocateUserException;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.TimeField;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.model.access.login.SessionSource;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.server.utils.LocaleHelper;
import org.cyclos.server.utils.SecureRandomHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SessionHandlerImpl
extends BaseGlobalHandlerImpl
implements SessionHandler,
ApplicationInitializationListener {
    private static final TimeInterval TRUSTED_DEVICE_TIMEOUT = TimeInterval.HALF_DAY;
    private static final int SESSION_ID_SIZE = 32;
    private static final QSession $ = QSession.session;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private SessionTimeoutHandler sessionTimeoutHandler;
    @Autowired
    private BackgroundTaskHandler backgroundTaskHandler;
    @Autowired
    private FailedActionHandler failedActionHandler;
    @Autowired
    private ChannelServiceLocal channelService;
    @Autowired
    private PrincipalTypeServiceLocal principalTypeService;
    @Autowired
    private AccessClientServiceLocal accessClientService;
    @Autowired
    private TrustedDeviceServiceLocal trustedDeviceService;
    @Autowired
    private OidcServiceLocal oidcService;
    @Autowired
    private UserChannelServiceLocal userChannelService;
    @Autowired
    private PasswordHandler passwordHandler;
    @Autowired
    private UserLocatorHandler userLocatorHandler;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private CustomScriptServiceLocal customScriptService;
    @Autowired
    private DeviceConfirmationServiceLocal deviceConfirmationService;
    @Autowired
    private AgreementLogServiceLocal agreementLogService;
    @Autowired
    private ConversionHandler conversionHandler;
    @Autowired
    private PushNotificationHandler pushNotificationHandler;
    @Autowired
    private ClusterHandler clusterHandler;
    private SharedStorage<String, String> pinCreationTokenStorage;

    public AccessClient checkAccessClientAccess(boolean bl, Network network, String string, String string2, String string3) {
        Channel channel = this.getChannelAndCheckUsage(bl, string);
        AccessClient accessClient = this.accessClientService.findForAccess(network, string2, string3);
        this.checkUserAccess((UserPrincipal)accessClient, bl, network, channel, null, null);
        return accessClient;
    }

    public OidcAccessToken checkOidcAccessToken(Network network, String string, String string2) {
        Channel channel = this.getChannelAndCheckUsage(false, BuiltInChannel.OIDC.getInternalName());
        OidcAccessToken oidcAccessToken = this.oidcService.findAccessToken(network, string, string2);
        this.checkUserAccess((UserPrincipal)oidcAccessToken.getAuthorization(), false, network, channel, null, null);
        return oidcAccessToken;
    }

    public SessionHandler.UserCheckResult checkUserAccess(boolean bl, boolean bl2, Network network, String string, String string2, UserLocatorVO userLocatorVO, String string3, Set<Group> set) {
        BasicUser basicUser;
        LocateUserResult locateUserResult;
        if (!ModelHelper.isValid((UserLocatorVO)userLocatorVO) || StringHelper.isBlank((Object)string3)) {
            throw new LoginException();
        }
        Channel channel = this.getChannelAndCheckUsage(bl, string);
        SessionData sessionData = InvocationContext.getSessionData();
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        try {
            locateUserResult = this.locateUser(network, channel, sessionData, userLocatorVO);
        }
        catch (UserStatusException userStatusException) {
            throw new LoginException(userStatusException.getUserStatus());
        }
        BasicUser basicUser2 = basicUser = locateUserResult == null ? null : locateUserResult.getBasicUser();
        if (basicUser == null) {
            TimeInterval timeInterval;
            Integer n = configurationAccessor.getInvalidUsernameAttempts();
            boolean bl3 = this.failedActionHandler.recordGuestFailure(FailedAction.FAILED_PRINCIPAL, string2, userLocatorVO, n, timeInterval = configurationAccessor.getRemoteAddressBlockTime());
            if (bl3) {
                throw new RemoteAddressBlockedException();
            }
            throw new LoginException(UserLocatorHandler.asString((UserLocatorVO)userLocatorVO));
        }
        Consumer<ChannelConfiguration> consumer = channelConfiguration -> {
            PasswordType passwordType;
            PasswordType passwordType2 = passwordType = channelConfiguration == null ? null : channelConfiguration.getAccessPassword();
            if (passwordType == null) {
                throw new LoginException();
            }
            this.checkPassword(bl2, string3, locateUserResult, (ChannelConfiguration)channelConfiguration);
        };
        this.checkUserAccess((UserPrincipal)locateUserResult, bl, network, channel, consumer, set);
        return new SessionHandler.UserCheckResult(channel, locateUserResult);
    }

    public void clearPinCreationToken(Session session) {
        this.pinCreationTokenStorage.remove((Object)session.getSessionToken());
    }

    public void confirmLogin(String string) {
        Session session = this.getSessionData().getSession();
        if (session == null) {
            throw new IllegalActionException("No session for login cofirmation");
        }
        this.passwordHandler.accessor(CredentialUsage.LOGIN_CONFIRMATION).check(string, SecondaryLoginConfirmationField.confirmation());
        session.setPendingLoginConfirmation(false);
    }

    public Session create(SessionHandler.CreateSessionParameters createSessionParameters) {
        SessionData sessionData = createSessionParameters.getSessionData();
        PrincipalType principalType = sessionData.getPrincipalType();
        if (principalType == null) {
            principalType = this.principalTypeService.getUsername();
        }
        SessionDescriptor sessionDescriptor = new SessionDescriptor();
        sessionDescriptor.channel = sessionData.getChannel();
        sessionDescriptor.remoteAddress = sessionData.getRemoteAddress();
        sessionDescriptor.pin = sessionData.getPin();
        sessionDescriptor.identityProvider = sessionData.getIdentityProvider();
        sessionDescriptor.customSessionTimeout = createSessionParameters.getCustomTimeout();
        sessionDescriptor.userPrincipal = sessionData;
        sessionDescriptor.deviceConfirmationId = createSessionParameters.getDeviceConfirmationId();
        sessionDescriptor.deviceId = createSessionParameters.getDeviceId();
        sessionDescriptor.hmac = createSessionParameters.getHmac();
        return this.create(sessionDescriptor);
    }

    public Session getIfValid(String string, String string2) {
        Object object;
        Session session;
        if (string2 == null) {
            return null;
        }
        Channel channel = this.getSessionData().getChannel();
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getDefaultAccessor();
        CustomSessionConfiguration customSessionConfiguration = configurationAccessor.getCustomSessionConfiguration();
        if (customSessionConfiguration != null && customSessionConfiguration.isEnabled() && (session = this.scriptResultToSession(object = this.customScriptService.newAccessor(customSessionConfiguration.getScript(), customSessionConfiguration.getScriptParameters()).bind("sessionToken", (Object)string2).bind("channel", (Object)channel).bind("remoteAddress", (Object)string).run((ScriptFunction)SessionHandlingScriptFunction.RESOLVE), string, string2, channel)) != null) {
            return session;
        }
        object = this.sessionTimeoutHandler.getExpiration(string2);
        if (object == null || (Long)object < System.currentTimeMillis()) {
            return null;
        }
        session = ((DBQuery)this.from(new EntityPath[]{$}).where((Predicate)SessionHandlerImpl.$.sessionToken.eq((Object)string2))).leftFetchHint(new Path[]{$, $.basicUser(), $.basicUser().image()});
        if (!this.cyclosProperties.isSessionsAnyAddress() && string != null) {
            session.where((Predicate)SessionHandlerImpl.$.remoteAddress.eq((Object)string));
        }
        return (Session)session.singleResult((Expression)$);
    }

    public String getPinCreationToken(Session session) {
        String string = session.getSessionToken();
        return string == null ? null : (String)this.pinCreationTokenStorage.get((Object)string);
    }

    public TimeInterval getSessionTimeout(Session session) {
        if (session.isTransient()) {
            return null;
        }
        if (session.getSessionTimeout() != null) {
            return session.getSessionTimeout();
        }
        return this.getSessionTimeout(session.getChannel(), session.getUser());
    }

    @PostConstruct
    public void initialize() {
        this.pinCreationTokenStorage = this.clusterHandler.getSharedStorage(SharedStorageType.PIN_CREATION_TOKENS);
    }

    public boolean invalidate(String string, String string2) {
        long l;
        Channel channel;
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getDefaultAccessor();
        CustomSessionConfiguration customSessionConfiguration = configurationAccessor.getCustomSessionConfiguration();
        if (customSessionConfiguration != null && customSessionConfiguration.isEnabled()) {
            channel = this.getSessionData().getChannel();
            Object object = this.customScriptService.newAccessor(customSessionConfiguration.getScript(), customSessionConfiguration.getScriptParameters()).bind("sessionToken", (Object)string2).bind("channel", (Object)channel).bind("remoteAddress", (Object)string).run((ScriptFunction)SessionHandlingScriptFunction.LOGOUT);
            if (object != null && !Boolean.FALSE.equals(object)) {
                return true;
            }
        }
        channel = this.delete((EntityPath<?>)$).where(new Predicate[]{SessionHandlerImpl.$.sessionToken.eq((Object)string2)});
        if (string != null && !this.cyclosProperties.isSessionsAnyAddress()) {
            channel.where(new Predicate[]{SessionHandlerImpl.$.remoteAddress.eq((Object)string)});
        }
        if ((l = channel.execute()) > 0L) {
            Set<String> set = Collections.singleton(string2);
            this.addCommitListener(set);
        }
        return l > 0L;
    }

    public Session login(String string, String string2, TimeInterval timeInterval, UserLocatorVO userLocatorVO, String string3, Set<Group> set) throws FrameworkException, LoginException, RemoteAddressBlockedException {
        Language language;
        Object object;
        SessionData sessionData = this.getSessionData();
        SessionHandler.UserCheckResult userCheckResult = this.checkUserAccess(true, true, sessionData.getNetwork(), string, string2, userLocatorVO, string3, set);
        BasicUser basicUser = userCheckResult.getUser();
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        if (basicUser.getLocale() == null && !Objects.equals(object = configurationAccessor.getLanguage(), language = configurationAccessor.getDefaultLanguage())) {
            Locale locale = LocaleHelper.mapLocale((BuiltinLanguage)object.getTemplate());
            basicUser.setLocale(locale.toString());
        }
        object = new SessionDescriptor();
        object.channel = userCheckResult.getChannel();
        object.remoteAddress = string2;
        object.customSessionTimeout = timeInterval;
        object.userPrincipal = userCheckResult.getLocateUserResult();
        object.pin = userCheckResult.getLocateUserResult().getPin();
        return this.create((SessionDescriptor)object);
    }

    public void onApplicationInitialization() {
        this.populateSessionTimeout();
    }

    public int purgeExpired() {
        Set set = this.sessionTimeoutHandler.getExpired();
        if (set.isEmpty()) {
            return 0;
        }
        return (Integer)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> this.remove(set));
    }

    public int remove(Collection<String> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return 0;
        }
        MutableInt mutableInt = new MutableInt();
        Iterators.partition(collection.iterator(), (int)10000).forEachRemaining(list -> {
            int n = (int)this.delete((EntityPath<?>)$).where(new Predicate[]{SessionHandlerImpl.$.sessionToken.in(collection)}).execute();
            if (n > 0) {
                this.addCommitListener(collection);
            }
            mutableInt.add(n);
        });
        return mutableInt.intValue();
    }

    public boolean remove(Session session) {
        return this.remove(Collections.singleton(session.getSessionToken())) == 1;
    }

    public String replace(Session session) {
        String string = session.getSessionToken();
        this.addCommitListener(Collections.singleton(string));
        String string2 = this.newToken();
        session.setSessionToken(string2);
        return string2;
    }

    public void setProperties(Session session, SessionProperties sessionProperties) {
        ConfigurationAccessor configurationAccessor;
        CustomSessionConfiguration customSessionConfiguration;
        Pin pin;
        TrustedDevice trustedDevice;
        if (session == null || sessionProperties == null) {
            return;
        }
        SessionProperties sessionProperties2 = session.getProperties();
        SessionSource sessionSource = sessionProperties.getSource();
        if (sessionSource != null && sessionSource != sessionProperties2.getSource()) {
            sessionProperties2.setSource(sessionSource);
            session.setSessionTimeout(sessionSource == SessionSource.LOGIN ? null : TRUSTED_DEVICE_TIMEOUT);
            trustedDevice = this.getSessionData();
            if (session.equals((Object)trustedDevice.getSession())) {
                trustedDevice.ifWraps(StatefulUserSessionData.class, statefulUserSessionData -> statefulUserSessionData.setSessionTimeout(this.getSessionTimeout(session)));
            }
        }
        if ((trustedDevice = sessionProperties.getTrustedDevice()) != null && !trustedDevice.equals((Object)sessionProperties2.getTrustedDevice())) {
            sessionProperties2.setTrustedDevice(trustedDevice);
            if (session.isPersistent() && !trustedDevice.getSessions().contains(session)) {
                trustedDevice.addSession(session);
            }
        }
        if ((pin = sessionProperties.getPin()) != null && !pin.equals((Object)sessionProperties2.getPin())) {
            sessionProperties2.setPin(pin);
        }
        if ((customSessionConfiguration = (configurationAccessor = this.configurationHandler.getDefaultAccessor()).getCustomSessionConfiguration()) != null && customSessionConfiguration.isEnabled()) {
            this.customScriptService.newAccessor(customSessionConfiguration.getScript(), customSessionConfiguration.getScriptParameters()).bind("sessionToken", (Object)session.getSessionToken()).bind("sessionProperties", (Object)sessionProperties2).run((ScriptFunction)SessionHandlingScriptFunction.SET_PROPERTIES);
        }
    }

    public void updateTimeout(String string, TimeInterval timeInterval) {
        Date date = DateHelper.add((Date)new Date(), (ITimeInterval)timeInterval);
        this.sessionTimeoutHandler.set(string, date.getTime());
    }

    private void addCommitListener(Collection<String> collection) {
        InvocationContext.ensure().addCommitListener(false, () -> {
            this.sessionTimeoutHandler.remove(collection);
            CollectionHelper.orEmpty((Collection)collection).stream().map(PushNotificationEventContext::loggedOut).forEach(pushNotificationEventContext -> this.pushNotificationHandler.publish(pushNotificationEventContext, null));
        });
    }

    private void checkConfigurationAccess(boolean bl, BasicUser basicUser) {
        SessionData sessionData = InvocationContext.getSessionData();
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicGroup)basicUser.getUser().getGroup());
        Runnable runnable = () -> {
            String string;
            Set set = configurationAccessor.getFullUrls();
            if (!set.contains(string = sessionData.getRequestData().getBaseUrl())) {
                throw new UnauthorizedURLException();
            }
        };
        AllowAccessMode allowAccessMode = configurationAccessor.getAllowAccessMode();
        if (basicUser.isGlobalAdmin() || basicUser.isNetworkAdmin() || basicUser.isAdmin() && basicUser.getNetwork() == null) {
            if (bl && allowAccessMode == AllowAccessMode.CURRENT_ONLY) {
                runnable.run();
            }
        } else {
            switch (allowAccessMode) {
                case CURRENT_OR_ANCESTORS: {
                    List list;
                    Configuration configuration = (Configuration)this.rawEntityManagerHandler.find(Configuration.class, sessionData.getRequestData().getConfigurationId());
                    if (configurationAccessor.getConfiguration().equals((Object)configuration) || (list = this.configurationHandler.getAncestors(configurationAccessor.getConfiguration())).contains(configuration)) break;
                    throw new UnauthorizedURLException();
                }
                case CURRENT_ONLY: {
                    runnable.run();
                    break;
                }
            }
        }
    }

    private void checkPassword(boolean bl, String string, LocateUserResult locateUserResult, ChannelConfiguration channelConfiguration) {
        try {
            LocateUserResult locateUserResult2 = locateUserResult.getPin() != null ? locateUserResult.getPin() : locateUserResult;
            this.passwordHandler.checkCredential((ChannelAccessAccessor)channelConfiguration, CredentialUsage.ACCESS, (UserPrincipal)locateUserResult2, null, bl, string);
        }
        catch (PasswordStatusException passwordStatusException) {
            throw new LoginException(passwordStatusException.getPasswordStatus());
        }
        catch (InvalidPinRemovedException invalidPinRemovedException) {
            throw new LoginException(PasswordStatus.DISABLED);
        }
        catch (PasswordException passwordException) {
            throw new LoginException();
        }
    }

    private void checkTrustedDeviceLogin(Channel channel, String string, String string2, String string3) {
        channel = this.getChannelAndCheckUsage(true, channel);
        this.trustedDeviceService.checkForLogin(string, string2, string3);
        TrustedDevice trustedDevice = this.getSessionData().getTrustedDevice();
        this.checkUserAccess((UserPrincipal)trustedDevice, true, trustedDevice.getNetwork(), channel, null, null);
    }

    private void checkUserAccess(UserPrincipal userPrincipal, boolean bl, Network network, Channel channel, Consumer<ChannelConfiguration> consumer, Set<Group> set) {
        AdminGroup adminGroup;
        BasicUser basicUser = userPrincipal.getBasicUser();
        Group group = basicUser.getUser().getGroup();
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicGroup)group);
        ChannelConfiguration channelConfiguration = configurationAccessor.getChannelConfiguration(channel);
        if (channelConfiguration == null || !channelConfiguration.isEnabled()) {
            throw new InaccessibleChannelException(false);
        }
        if (!bl && (channelConfiguration.getLoginConfirmation().isDefined() || channelConfiguration.isRequireTrustedDeviceForLogin())) {
            throw new InvalidChannelUsageException();
        }
        if (consumer != null) {
            consumer.accept(channelConfiguration);
        }
        if (network != null && basicUser.isGlobal() && group instanceof AdminGroup && (adminGroup = (AdminGroup)group).getAdminType() != AdminGroupType.GLOBAL && !adminGroup.getManagedNetworks().contains(network)) {
            throw new InvalidNetworkException();
        }
        if (!this.userChannelService.isChannelAccessible(basicUser, channel)) {
            throw new InaccessibleChannelException(true);
        }
        if (!channelConfiguration.getPrincipalTypes().contains(userPrincipal.getPrincipalType())) {
            throw new InaccessiblePrincipalException((PrincipalTypeVO)this.conversionHandler.convert(PrincipalTypeVO.class, (Object)userPrincipal.getPrincipalType()));
        }
        if (set != null && !set.contains(group)) {
            throw new InaccessibleGroupException();
        }
        this.checkConfigurationAccess(bl, basicUser);
        if (basicUser.getStatus() != UserStatus.ACTIVE) {
            throw new LoginException(basicUser.getStatus());
        }
        if (basicUser.isRestrictedOperator() && this.agreementLogService.hasPendingAgreements(basicUser.getUser())) {
            throw new OperatorWithPendingAgreementsException();
        }
    }

    private Session create(SessionDescriptor sessionDescriptor) {
        UserPrincipal userPrincipal;
        TimeInterval timeInterval;
        boolean bl;
        UserPrincipal userPrincipal2 = sessionDescriptor.userPrincipal;
        if (userPrincipal2 == null) {
            throw new IllegalActionException("Error creating session: no principal");
        }
        BasicUser basicUser = userPrincipal2.getBasicUser();
        if (basicUser == null) {
            throw new IllegalActionException("Error creating session: no user");
        }
        PrincipalType principalType = userPrincipal2.getPrincipalType();
        if (principalType == null) {
            throw new IllegalActionException("Error creating session: no principal type");
        }
        if (!sessionDescriptor.channel.isStateful()) {
            throw new IllegalActionException("Error creating session: the channel is not stateful");
        }
        Date date = DateHelper.now();
        Session session = new Session();
        session.getProperties().setSource(userPrincipal2.getTrustedDevice() != null ? SessionSource.TRUSTED_DEVICE : SessionSource.LOGIN);
        session.setCreationDate(date);
        session.setRemoteAddress(sessionDescriptor.remoteAddress);
        session.setChannel(sessionDescriptor.channel);
        session.setPin(sessionDescriptor.pin);
        session.setIdentityProvider(sessionDescriptor.identityProvider);
        TrustedDevice trustedDevice = userPrincipal2.getTrustedDevice();
        boolean bl2 = bl = trustedDevice != null;
        if (trustedDevice != null) {
            this.checkTrustedDeviceLogin(sessionDescriptor.channel, sessionDescriptor.remoteAddress, sessionDescriptor.deviceConfirmationId, sessionDescriptor.hmac);
        } else {
            trustedDevice = this.getTrustedDeviceIfValid(sessionDescriptor.deviceConfirmationId, sessionDescriptor.deviceId, sessionDescriptor.hmac);
        }
        session.initFrom(userPrincipal2);
        Object object = null;
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getDefaultAccessor();
        CustomSessionConfiguration customSessionConfiguration = configurationAccessor.getCustomSessionConfiguration();
        TimeInterval timeInterval2 = timeInterval = bl ? this.getSmallestSessionTimeout(TRUSTED_DEVICE_TIMEOUT, sessionDescriptor.customSessionTimeout) : this.getSmallestSessionTimeout(sessionDescriptor.channel, basicUser, sessionDescriptor.customSessionTimeout);
        if (customSessionConfiguration != null && customSessionConfiguration.isEnabled()) {
            userPrincipal = userPrincipal2 instanceof DelegatingUserPrincipal ? ((DelegatingUserPrincipal)userPrincipal2).getDelegate() : userPrincipal2;
            object = this.customScriptService.newAccessor(customSessionConfiguration.getScript(), customSessionConfiguration.getScriptParameters()).bind("user", (Object)basicUser).bind("principal", (Object)userPrincipal).bind("trusted", (Object)(session.getTrustedDevice() != null ? 1 : 0)).bind("sessionProperties", (Object)session.getProperties()).bind("channel", (Object)sessionDescriptor.channel).bind("sessionTimeout", (Object)timeInterval).bind("remoteAddress", (Object)sessionDescriptor.remoteAddress).run(String.class, (ScriptFunction)SessionHandlingScriptFunction.LOGIN);
        }
        if (object != null) {
            this.fillSessionFromScriptResult(session, object);
        } else {
            userPrincipal = SessionDataFactory.direct((UserPrincipal)userPrincipal2).channel(sessionDescriptor.channel.getInternalName()).build();
            this.invokerHandler.runAs((SessionData)userPrincipal, () -> {
                CredentialAccessor credentialAccessor = this.passwordHandler.accessor(CredentialUsage.LOGIN_CONFIRMATION);
                if (credentialAccessor.isDefined() && !credentialAccessor.canBeUsed() && !credentialAccessor.canActivateCredentials()) {
                    throw new LoginException(credentialAccessor.getAllowedCredentials(), (PasswordTypeVO)this.conversionHandler.convert(PasswordTypeVO.class, (Object)credentialAccessor.getPassword()));
                }
                session.setPendingLoginConfirmation(credentialAccessor.isDefined());
                return null;
            });
            session.setSessionToken(this.newToken());
            if (trustedDevice != null) {
                trustedDevice.addSession(session);
            }
            this.rawEntityManagerHandler.persist((IEntity)session);
            long l = DateHelper.add((Date)date, (ITimeInterval)timeInterval).getTime();
            this.sessionTimeoutHandler.set(session.getSessionToken(), l);
            if (sessionDescriptor.customSessionTimeout != null || bl) {
                session.setSessionTimeout(timeInterval);
            }
        }
        if (session.getPin() == null && this.configurationHandler.getAccessAccessor(session.getBasicUser()).getChannelConfiguration(session.getChannel()).getPinConfiguration() != null) {
            this.pinCreationTokenStorage.set((Object)session.getSessionToken(), (Object)RandomStringUtils.randomAlphanumeric((int)32));
        }
        return session;
    }

    private void fillSessionFromScriptResult(Session session, Object object) {
        if (object instanceof String) {
            session.setSessionToken((String)object);
        } else {
            Session session2 = (Session)this.conversionHandler.convert(Session.class, object);
            session.setSessionToken(session2.getSessionToken());
        }
        session.setPendingLoginConfirmation(false);
    }

    private Channel getChannelAndCheckUsage(boolean bl, Channel channel) {
        if (bl && !channel.isStateful() || !bl && !channel.isStateless() && !this.cyclosProperties.isTestingEnv()) {
            throw new InvalidChannelUsageException();
        }
        return channel;
    }

    private Channel getChannelAndCheckUsage(boolean bl, String string) {
        try {
            Channel channel = this.channelService.load(string);
            return this.getChannelAndCheckUsage(bl, channel);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            throw new LoginException();
        }
    }

    private TimeInterval getSessionTimeout(Channel channel, BasicUser basicUser) {
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicGroup)basicUser.getUser().getGroup());
        ChannelConfiguration channelConfiguration = configurationAccessor.getChannelConfiguration(channel);
        if (channelConfiguration == null || !channelConfiguration.isEnabled()) {
            throw new InaccessibleChannelException();
        }
        TimeInterval timeInterval = this.getSessionTimeout(channelConfiguration);
        return timeInterval;
    }

    private TimeInterval getSessionTimeout(ChannelConfiguration channelConfiguration) {
        TimeInterval timeInterval;
        TimeInterval timeInterval2 = timeInterval = channelConfiguration == null ? null : channelConfiguration.getSessionTimeout();
        if (timeInterval == null) {
            timeInterval = new TimeInterval(Integer.valueOf(20), TimeField.MINUTES);
        }
        return timeInterval;
    }

    private TimeInterval getSmallestSessionTimeout(Channel channel, BasicUser basicUser, TimeInterval timeInterval) {
        TimeInterval timeInterval2 = this.getSessionTimeout(channel, basicUser);
        return this.getSmallestSessionTimeout(timeInterval2, timeInterval);
    }

    private TimeInterval getSmallestSessionTimeout(TimeInterval timeInterval, TimeInterval timeInterval2) {
        return timeInterval.compareTo((ITimeInterval)timeInterval2) < 0 ? timeInterval : timeInterval2;
    }

    private TrustedDevice getTrustedDeviceIfValid(String string, Long l, String string2) {
        if (ObjectHelper.anyIsNull((Object[])new Object[]{string, l, StringHelper.trimToNull((Object)string2)})) {
            return null;
        }
        try {
            return this.deviceConfirmationService.validate(string, l.longValue(), string2);
        }
        catch (InvalidDeviceConfirmationException invalidDeviceConfirmationException) {
            return null;
        }
    }

    private LocateUserResult locateUser(Network network, Channel channel, SessionData sessionData, UserLocatorVO userLocatorVO) throws LoginException, RemoteAddressBlockedException {
        LocateUserResult locateUserResult;
        block7: {
            PrincipalType principalType;
            List list;
            ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
            ChannelConfiguration channelConfiguration = configurationAccessor.getChannelConfiguration(channel);
            if (channelConfiguration == null || !channelConfiguration.isEnabled()) {
                return null;
            }
            if (sessionData.isAdmin()) {
                list = sessionData.getProducts().admin().getLoginUserPrincipalTypes();
                principalType = null;
            } else {
                list = this.principalTypeService.listForLogin(channelConfiguration);
                principalType = channelConfiguration.getDefaultPrincipalType();
            }
            EnumSet<LocateUserOption> enumSet = EnumSet.of(LocateUserOption.FOR_ACCESS);
            locateUserResult = null;
            try {
                locateUserResult = this.userLocatorHandler.locate(network, userLocatorVO, enumSet, (Collection)list, principalType);
            }
            catch (LocateUserException locateUserException) {
                if (network == null) break block7;
                try {
                    locateUserResult = this.userLocatorHandler.locate(null, userLocatorVO, enumSet, (Collection)list, principalType);
                }
                catch (LocateUserException locateUserException2) {
                    // empty catch block
                }
            }
        }
        return locateUserResult;
    }

    private String newToken() {
        String string = null;
        boolean bl = true;
        do {
            string = SecureRandomHelper.randomAlphanumeric((int)32);
        } while (bl = ((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{$}).where((Predicate)SessionHandlerImpl.$.sessionToken.eq((Object)string))).hasResults());
        return string;
    }

    private void populateSessionTimeout() {
        QUser qUser = QUser.user;
        NumberPath numberPath = qUser.group().configuration().id;
        NumberPath numberPath2 = SessionHandlerImpl.$.channel().id;
        QInteger qInteger = SessionHandlerImpl.$.sessionTimeout().amount;
        EnumPath enumPath = SessionHandlerImpl.$.sessionTimeout().field;
        HashMap hashMap = new HashMap();
        LinkedList linkedList = new LinkedList();
        HashMap hashMap2 = new HashMap();
        try (CloseableIterator closeableIterator = ((DBQuery)this.from(new EntityPath[]{$}).innerJoin((EntityPath)$.user(), (Path)qUser)).iterate(new Expression[]{SessionHandlerImpl.$.id, SessionHandlerImpl.$.creationDate, SessionHandlerImpl.$.sessionToken, enumPath, qInteger, numberPath2, numberPath});){
            closeableIterator.forEachRemaining(tuple -> {
                TimeInterval timeInterval;
                String string = (String)tuple.get((Expression)SessionHandlerImpl.$.sessionToken);
                Integer n = (Integer)tuple.get((Expression)qInteger);
                TimeInterval timeInterval2 = timeInterval = n != null ? new TimeInterval(n, (TimeField)tuple.get((Expression)enumPath)) : null;
                if (timeInterval == null) {
                    Pair pair = Pair.create((Object)((Long)tuple.get((Expression)numberPath2)), (Object)((Long)tuple.get((Expression)numberPath)));
                    timeInterval = hashMap.computeIfAbsent(pair, pair2 -> {
                        Channel channel = (Channel)this.rawEntityManagerHandler.find(Channel.class, (Long)pair.getFirst());
                        Configuration configuration = (Configuration)this.rawEntityManagerHandler.find(Configuration.class, (Long)pair.getSecond());
                        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(configuration);
                        ChannelConfiguration channelConfiguration = configurationAccessor.getChannelConfiguration(channel);
                        return this.getSessionTimeout(channelConfiguration);
                    });
                }
                long l = timeInterval.getMilliseconds() / 2L;
                Date date = (Date)tuple.get((Expression)SessionHandlerImpl.$.creationDate);
                if (date.getTime() + l > System.currentTimeMillis()) {
                    hashMap2.put(string, System.currentTimeMillis() + l);
                } else {
                    linkedList.add((Long)tuple.get((Expression)SessionHandlerImpl.$.id));
                }
            });
        }
        this.sessionTimeoutHandler.setAll(hashMap2);
        Lists.partition(linkedList, (int)10000).forEach(list -> {
            String string = "jdbc.update('delete from sessions where id in (' + '" + StringHelper.join((Object[])StringHelper.splitByLength((String)StringHelper.join((Collection)list, (String)","), (int)50000), (String)"' + '") + "' + ')')";
            BackgroundTaskScheduling backgroundTaskScheduling = InlineScriptBackgroundTask.scheduling(String.format("Deleting %s/%s expired sessions at initialization", list.size(), linkedList.size()), string, null);
            this.backgroundTaskHandler.schedule(backgroundTaskScheduling);
        });
    }

    private Session scriptResultToSession(Object object, String string, String string2, Channel channel) {
        if (object instanceof BasicUser || object instanceof LocateUserResult) {
            Session session = new Session();
            session.setSessionToken(string2);
            session.setChannel(channel);
            session.setCreationDate(new Date());
            session.setRemoteAddress(string);
            if (object instanceof BasicUser) {
                session.setUser((BasicUser)object);
            } else if (object instanceof LocateUserResult) {
                LocateUserResult locateUserResult = (LocateUserResult)object;
                session.initFrom((UserPrincipal)locateUserResult);
            }
            return session;
        }
        Session session = (Session)this.conversionHandler.convert(Session.class, object);
        if (session != null) {
            if (session.getUser() == null) {
                throw new CustomScriptException("The script returned a session with no user");
            }
            if (session.getSessionToken() == null) {
                session.setSessionToken(string2);
            }
        }
        return session;
    }

    public static class SessionDescriptor {
        public Channel channel;
        public String remoteAddress;
        public TimeInterval customSessionTimeout;
        public UserPrincipal userPrincipal;
        public Pin pin;
        public IdentityProvider identityProvider;
        public String deviceConfirmationId;
        public Long deviceId;
        public String hmac;
    }
}

