/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.CaseBuilder;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.jpa.impl.AbstractJPAQuery;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.validation.constraints.NotNull;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.NFCToken;
import org.cyclos.entities.access.NFCTokenPrincipalType;
import org.cyclos.entities.access.QNFCToken;
import org.cyclos.entities.access.QToken;
import org.cyclos.entities.access.Token;
import org.cyclos.entities.access.TokenPrincipalType;
import org.cyclos.entities.system.ChannelAccessAccessor;
import org.cyclos.entities.system.ChannelConfiguration;
import org.cyclos.entities.system.ChannelSettingsAccessor;
import org.cyclos.entities.system.ExportFormat;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.QBasicUser;
import org.cyclos.entities.users.QOperator;
import org.cyclos.entities.users.QProductMyTokenType;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.DeviceConfirmationServiceLocal;
import org.cyclos.impl.access.DirectUserSessionData;
import org.cyclos.impl.access.FailedAction;
import org.cyclos.impl.access.FailedActionHandler;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.access.PasswordServiceLocal;
import org.cyclos.impl.access.PinServiceLocal;
import org.cyclos.impl.access.PrincipalTypeServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.access.TokenServiceLocal;
import org.cyclos.impl.system.EntityLogServiceLocal;
import org.cyclos.impl.system.ExportFormatServiceLocal;
import org.cyclos.impl.users.LocateUserResult;
import org.cyclos.impl.utils.BarcodeHandler;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.impl.utils.PermissionHelper;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.CyclosException;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.QueryParseException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.InvalidTokenException;
import org.cyclos.model.access.MaxTokenActivationAttemptsException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.TokenAlreadyInUseException;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.access.devices.DeviceConfirmationBarcodeParams;
import org.cyclos.model.access.devices.DeviceConfirmationVO;
import org.cyclos.model.access.principaltypes.PrincipalTypeInputVO;
import org.cyclos.model.access.principaltypes.PrincipalTypeVO;
import org.cyclos.model.access.principaltypes.TokenPrincipalTypeVO;
import org.cyclos.model.access.principaltypes.TokenType;
import org.cyclos.model.access.tokens.ExternalNFCTagAuthenticateDTO;
import org.cyclos.model.access.tokens.ExternalNFCTagAuthenticateData;
import org.cyclos.model.access.tokens.InitializeNFCTagData;
import org.cyclos.model.access.tokens.InitializeNFCTagResult;
import org.cyclos.model.access.tokens.NFCDeviceActionDTO;
import org.cyclos.model.access.tokens.NFCTagInitializeDTO;
import org.cyclos.model.access.tokens.NFCTagKey;
import org.cyclos.model.access.tokens.NFCTagPersonalizeDTO;
import org.cyclos.model.access.tokens.NFCTagWithChallengeDTO;
import org.cyclos.model.access.tokens.NFCTokenDTO;
import org.cyclos.model.access.tokens.PersonalizeNFCTagData;
import org.cyclos.model.access.tokens.PersonalizeNfcTagConfirmationField;
import org.cyclos.model.access.tokens.TokenActionDTO;
import org.cyclos.model.access.tokens.TokenBarcodeParams;
import org.cyclos.model.access.tokens.TokenDTO;
import org.cyclos.model.access.tokens.TokenData;
import org.cyclos.model.access.tokens.TokenDataParams;
import org.cyclos.model.access.tokens.TokenQuery;
import org.cyclos.model.access.tokens.TokenSearchData;
import org.cyclos.model.access.tokens.TokenStatus;
import org.cyclos.model.access.tokens.TokenVO;
import org.cyclos.model.access.tokens.TokensListData;
import org.cyclos.model.messaging.alerts.UserAlertType;
import org.cyclos.model.messaging.sms.SmsSendingException;
import org.cyclos.model.system.exportformats.ExportFormatContext;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.DatePeriodDTO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.model.utils.SendMedium;
import org.cyclos.model.utils.TimeField;
import org.cyclos.server.utils.CloseableIteratorHelper;
import org.cyclos.server.utils.DataIterator;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.server.utils.ExceptionHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.IDate;
import org.cyclos.utils.MaskHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TokenServiceImpl
extends CRUDServiceImpl<Token, QToken, TokenDTO, TokenData, TokenDataParams>
implements TokenServiceLocal {
    private static final int NFC_TAG_APP_KEY_LEN = 16;
    private static final int MAX_ATTEMPTS_TO_ACTIVATE_TOKEN = 10;
    private static final BidiMap<Class<? extends Token>, Class<? extends TokenDTO>> SUBCLASS_MAPPINGS = new DualHashBidiMap();
    @Autowired
    private FailedActionHandler failedActionHandler;
    @Autowired
    private BarcodeHandler barcodeHandler;
    @Autowired
    private PrincipalTypeServiceLocal principalTypeService;
    @Autowired
    private PinServiceLocal pinService;
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private PasswordHandler passwordHandler;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private PasswordServiceLocal passwordService;
    @Autowired
    private DeviceConfirmationServiceLocal deviceConfirmationService;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private ChannelServiceLocal channelService;
    @Autowired
    private ExportFormatServiceLocal exportFormatService;
    @Autowired
    private EntityLogServiceLocal entityLogService;

    private static byte[] generateSessionKey(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[16];
        byArray4[0] = byArray2[0];
        byArray4[1] = byArray2[1];
        byArray4[2] = byArray2[2];
        byArray4[3] = byArray2[3];
        byArray4[4] = byArray3[0];
        byArray4[5] = byArray3[1];
        byArray4[6] = byArray3[2];
        byArray4[7] = byArray3[3];
        if (TokenServiceImpl.isSymmetric(byArray)) {
            System.arraycopy(byArray4, 0, byArray4, 8, 8);
        } else {
            byArray4[8] = byArray2[4];
            byArray4[9] = byArray2[5];
            byArray4[10] = byArray2[6];
            byArray4[11] = byArray2[7];
            byArray4[12] = byArray3[4];
            byArray4[13] = byArray3[5];
            byArray4[14] = byArray3[6];
            byArray4[15] = byArray3[7];
        }
        return byArray4;
    }

    private static boolean isSymmetric(byte[] byArray) {
        if (byArray.length % 2 != 0) {
            return false;
        }
        int n = byArray.length / 2;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray[n + i]) continue;
            return false;
        }
        return true;
    }

    public TokenServiceImpl() {
        super(Token.class, QToken.token, TokenDTO.class);
    }

    public Long activate(TokenActionDTO tokenActionDTO, UserLocatorVO userLocatorVO) throws MaxTokenActivationAttemptsException, InvalidTokenException {
        DBQuery dBQuery;
        QNFCToken qNFCToken;
        this.validate(tokenActionDTO);
        String string = tokenActionDTO.getTokenValue();
        TokenPrincipalTypeVO tokenPrincipalTypeVO = tokenActionDTO.getTokenType();
        BasicUser basicUser = this.userLocatorHandler.toBasicUserOrCurrent((BasicUserVO)userLocatorVO);
        TokenPrincipalType tokenPrincipalType = (TokenPrincipalType)this.conversionHandler.convert(TokenPrincipalType.class, (Object)tokenPrincipalTypeVO);
        string = MaskHelper.removeMask((String)tokenPrincipalType.getTokenMask(), (String)string);
        if (tokenPrincipalTypeVO.getTokenType() == TokenType.NFC_TAG) {
            qNFCToken = QNFCToken.nFCToken;
            dBQuery = (DBQuery)this.from(new EntityPath[]{qNFCToken, this.$}).where(new Predicate[]{qNFCToken._super.eq((Expression)this.$), qNFCToken.label.eq((Object)tokenActionDTO.getTokenValue())});
        } else {
            dBQuery = (DBQuery)this.from(this.$).where((Predicate)((QToken)this.$).value.eq((Object)string));
        }
        qNFCToken = new QOperator("op");
        dBQuery.where((Predicate)((QToken)this.$).status.in((Object[])new TokenStatus[]{TokenStatus.UNASSIGNED, TokenStatus.PENDING_ACTIVATION}).and((Predicate)((QToken)this.$).user().isNull().or((Predicate)((QToken)this.$).user().eq((Object)basicUser)).or((Predicate)((DBQuery)this.subQuery(new EntityPath[]{qNFCToken}).where(new Predicate[]{qNFCToken.user().id.eq((Object)basicUser.getId()), ((QToken)this.$).user().id.eq((Expression)qNFCToken.id)})).exists())).and((Predicate)((QToken)this.$).activationDeadline.isNull().or(((QToken)this.$).activationDeadline.future())).and((Predicate)((QToken)this.$).type().eq((Object)tokenPrincipalType)));
        Token token = (Token)dBQuery.singleResult((Expression)this.$);
        BasicUser basicUser2 = this.getLoggedBasicUser();
        if (token == null) {
            boolean bl = this.failedActionHandler.recordAndBlockUserIfMaxReached(FailedAction.FAILED_TOKEN_ACTIVATION, basicUser2, Integer.valueOf(10), UserAlertType.MAX_TOKEN_ACTIVATION_ATTEMPTS_REACHED);
            if (bl) {
                throw new MaxTokenActivationAttemptsException();
            }
            throw new InvalidTokenException();
        }
        this.failedActionHandler.clearUserFailures(FailedAction.FAILED_TOKEN_ACTIVATION, basicUser2);
        this.checkMaxTokensLimit(token.getType(), token.getUser() == null ? basicUser : token.getUser(), null);
        if (token.getUser() == null) {
            token.setUser(basicUser);
        }
        TokenStatus tokenStatus = token.getStatus();
        token.setStatus(TokenStatus.ACTIVE);
        this.entityLogService.log((SimpleEntity)token, this.message(AccessKeys.Tokens.STATUS, new Object[0]), TokenDTO.STATUS.getName(), this.getFormatter().format((HasMessageKey)tokenStatus), this.getFormatter().format((HasMessageKey)token.getStatus()), null);
        this.setExpiryAndActivationDate(token);
        this.logExpiryDate(token, null, token.getExpiryDate());
        this.logActivationDate(token, null, token.getActivationDate());
        this.notifyNew(token);
        return token.getId();
    }

    public void activatePending(Long l) {
        Token token = (Token)this.find(l);
        this.activatePending(token);
    }

    public void assign(@NotNull Long l, @NotNull UserLocatorVO userLocatorVO) throws FrameworkException {
        Token token = (Token)this.find(l);
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)userLocatorVO);
        if (!this.canAssign(token) || basicUser == null) {
            throw new IllegalActionException("The token '" + String.valueOf(token) + "' with status " + String.valueOf(token.getStatus()) + " cannot be assigned to " + String.valueOf(basicUser));
        }
        token.setUser(basicUser);
        token.setStatus(TokenStatus.PENDING_ACTIVATION);
        this.logStatus(token, TokenStatus.PENDING_ACTIVATION, TokenStatus.UNASSIGNED);
        this.setActivationDeadline(token);
        this.logActivationDeadline(token, null, token.getActivationDeadline());
        this.notifyNew(token);
    }

    public SerializableInputStream barcode(TokenBarcodeParams tokenBarcodeParams) throws FrameworkException {
        Token token = (Token)this.conversionHandler.convert(Token.class, (Object)tokenBarcodeParams.getToken());
        return this.barcodeHandler.qrcode(token.getValue(), tokenBarcodeParams.getSize());
    }

    public void block(Long l) {
        Token token = (Token)this.find(l);
        if (!this.canBlock(token)) {
            throw new IllegalActionException();
        }
        this.setStatusAndNotify(token, TokenStatus.BLOCKED, true);
    }

    public void cancel(Long l) {
        this.cancel((Token)this.find(l));
    }

    public void cancel(Token token) {
        if (token == null) {
            throw new EntityNotFoundException(Token.class);
        }
        if (!this.canCancel(token)) {
            throw new IllegalActionException();
        }
        this.pinService.relatedEntityRemoved((NetworkedEntity)token, () -> null);
        this.setStatusAndNotify(token, TokenStatus.CANCELED, true);
    }

    public void cancelAll(BasicUser basicUser) {
        try (CloseableIterator closeableIterator = ((DBQuery)this.from(this.$).where(new Predicate[]{((QToken)this.$).user().eq((Object)basicUser), ((QToken)this.$).status.ne((Object)TokenStatus.CANCELED)})).iterate((Expression)this.$);){
            closeableIterator.forEachRemaining(this::cancel);
        }
    }

    public void cancelNFCToken(TokenActionDTO tokenActionDTO) {
        QNFCToken qNFCToken = QNFCToken.nFCToken;
        NFCTokenPrincipalType nFCTokenPrincipalType = (NFCTokenPrincipalType)this.conversionHandler.convert(NFCTokenPrincipalType.class, (Object)tokenActionDTO.getTokenType());
        NFCToken nFCToken = (NFCToken)((DBQuery)this.from(new EntityPath[]{qNFCToken}).where(new Predicate[]{qNFCToken.type().eq((Object)nFCTokenPrincipalType), qNFCToken.value.eq((Object)tokenActionDTO.getTokenValue())})).singleResult((Expression)qNFCToken);
        this.cancel((Token)nFCToken);
    }

    public DeviceConfirmationVO createDeviceConfirmationForPersonalizeNFCTag(@NotNull UserLocatorVO userLocatorVO, @NotNull TokenPrincipalTypeVO tokenPrincipalTypeVO) throws FrameworkException {
        BasicUser basicUser = this.getLoggedBasicUser();
        return this.runAsTagOwner(userLocatorVO, () -> this.deviceConfirmationService.create(PersonalizeNfcTagConfirmationField.confirmation(), basicUser, this.getLoggedBasicUser(), false));
    }

    public SerializableInputStream deviceConfirmationBarcodeForPersonalizeNFCTag(UserLocatorVO userLocatorVO, @NotNull TokenPrincipalTypeVO tokenPrincipalTypeVO, DeviceConfirmationBarcodeParams deviceConfirmationBarcodeParams) throws FrameworkException {
        return this.runAsTagOwner(userLocatorVO, () -> this.deviceConfirmationService.barcode(deviceConfirmationBarcodeParams));
    }

    public long expireTokens() {
        return this.processBatch(this.getIteratorForExpiredTokens(), (T token) -> {
            if (token.getStatus() == TokenStatus.ACTIVATION_EXPIRED) {
                this.setStatusAndNotify((Token)token, TokenStatus.ACTIVATION_EXPIRED, true);
            } else if (token.getStatus() == TokenStatus.EXPIRED) {
                this.setStatusAndNotify((Token)token, TokenStatus.EXPIRED, true);
            }
        });
    }

    public FileInfo exportTokens(@NotNull ExportFormatVO exportFormatVO, @NotNull TokenQuery tokenQuery) throws FrameworkException {
        DataIterator dataIterator = CloseableIteratorHelper.asDataIterator((CloseableIterator)this.getTokenQuery(tokenQuery).export((Expression)this.$));
        ExportFormat exportFormat = (ExportFormat)this.conversionHandler.convert(ExportFormat.class, (Object)exportFormatVO);
        return this.exportFormatService.exportMultiple(exportFormat, ExportFormatContext.TOKENS_SEARCH, (QueryParameters)tokenQuery, dataIterator);
    }

    public Token firstActive(BasicUser basicUser, TokenPrincipalType tokenPrincipalType) throws FrameworkException {
        if (!this.isEnabled(basicUser, tokenPrincipalType)) {
            return null;
        }
        return (Token)((DBQuery)this.from(this.$).where(new Predicate[]{((QToken)this.$).user().eq((Object)basicUser), ((QToken)this.$).type().eq((Object)tokenPrincipalType), ((QToken)this.$).status.eq((Object)TokenStatus.ACTIVE)})).singleResult((Expression)this.$);
    }

    public void generateOnRegistrationTokens(BasicUser basicUser) {
        BooleanPropertiesHolder booleanPropertiesHolder = this.productsHandler.getAccessor(basicUser).member().getMyTokenTypes();
        booleanPropertiesHolder.keys().stream().filter(tokenPrincipalType -> booleanPropertiesHolder.get(tokenPrincipalType).isSet((Path)QProductMyTokenType.productMyTokenType.enable)).filter(TokenPrincipalType::isGenerateOnUserCreation).forEach(tokenPrincipalType -> {
            TokenDataParams tokenDataParams = new TokenDataParams();
            tokenDataParams.setType(new PrincipalTypeVO(tokenPrincipalType.getId()));
            tokenDataParams.setUser(new UserLocatorVO(basicUser.getId()));
            TokenDTO tokenDTO = (TokenDTO)((TokenData)this.getDataForNew(tokenDataParams)).getDto();
            tokenDTO.setValue(MaskHelper.generateValue((String)tokenPrincipalType.getTokenMask()));
            Long l = this.save(tokenDTO);
            Token token = (Token)this.rawEntityManagerHandler.find(Token.class, l);
            this.activatePending(token);
        });
    }

    public InitializeNFCTagData getInitializeNFCTagData() throws FrameworkException {
        InitializeNFCTagData initializeNFCTagData = new InitializeNFCTagData();
        return initializeNFCTagData;
    }

    public byte[] getKeyMask(NFCToken nFCToken) {
        return ByteBuffer.allocate(8).putLong(nFCToken.getId()).array();
    }

    public TokensListData getListData(TokenPrincipalTypeVO tokenPrincipalTypeVO, UserLocatorVO userLocatorVO) throws FrameworkException {
        Object object;
        TokenPrincipalType tokenPrincipalType = (TokenPrincipalType)this.conversionHandler.convert(TokenPrincipalType.class, (Object)tokenPrincipalTypeVO);
        BasicUser basicUser = this.userLocatorHandler.locate(userLocatorVO).getBasicUser();
        TokensListData tokensListData = new TokensListData();
        tokensListData.setType((TokenPrincipalTypeVO)this.conversionHandler.convert(TokenPrincipalTypeVO.class, (Object)tokenPrincipalType));
        tokensListData.setUser((BasicUserVO)this.conversionHandler.convert(BasicUserVO.class, (Object)basicUser));
        DBQuery<?> dBQuery = this.from(this.$);
        if (this.hasPermission(Permission.USER_OPERATORS_VIEW)) {
            object = new QOperator("op");
            dBQuery.where(new Predicate[]{((QToken)this.$).type().eq((Object)tokenPrincipalType), ((QToken)this.$).user().eq((Object)basicUser).or((Predicate)((DBQuery)this.subQuery(new EntityPath[]{object}).where(new Predicate[]{object.user().id.eq((Object)basicUser.getId()), ((QToken)this.$).user().id.eq((Expression)object.id)})).exists())});
        } else {
            dBQuery.where(new Predicate[]{((QToken)this.$).type().eq((Object)tokenPrincipalType), ((QToken)this.$).user().eq((Object)basicUser)});
        }
        if (basicUser.equals((Object)this.getLoggedBasicUser())) {
            dBQuery.where((Predicate)((QToken)this.$).status.in((Object[])new TokenStatus[]{TokenStatus.ACTIVE, TokenStatus.BLOCKED}));
        }
        dBQuery.orderBy(this.getOrderBy((QToken)this.$, basicUser));
        object = dBQuery.list((Expression)this.$);
        tokensListData.setTokens(this.conversionHandler.convertList(TokenVO.class, (Iterable)object));
        tokensListData.setCanActivateNew(!basicUser.isRemoved() && this.canActivateNew(tokenPrincipalType, basicUser));
        tokensListData.setCanCreateNew(!basicUser.isRemoved());
        tokensListData.setMaxPerUser(tokenPrincipalType.getMaximumPerUser());
        return tokensListData;
    }

    public PersonalizeNFCTagData getPersonalizeNFCTagData(TokenPrincipalTypeVO tokenPrincipalTypeVO, UserLocatorVO userLocatorVO) throws FrameworkException {
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)userLocatorVO);
        NFCTokenPrincipalType nFCTokenPrincipalType = (NFCTokenPrincipalType)this.conversionHandler.convert(NFCTokenPrincipalType.class, (Object)tokenPrincipalTypeVO);
        SessionData sessionData = this.getSessionData();
        PersonalizeNFCTagData personalizeNFCTagData = new PersonalizeNFCTagData();
        if (!sessionData.manages(basicUser)) {
            personalizeNFCTagData.setConfirmationPasswordInput(this.passwordHandler.getCredentialInput((ChannelAccessAccessor)this.getPOSChannelConfiguration(basicUser), CredentialUsage.CONFIRMATION, basicUser));
        }
        personalizeNFCTagData.setTokenType((TokenPrincipalTypeVO)this.conversionHandler.convert(TokenPrincipalTypeVO.class, (Object)nFCTokenPrincipalType));
        personalizeNFCTagData.setUser((BasicUserVO)this.conversionHandler.convert(BasicUserVO.class, (Object)basicUser));
        return personalizeNFCTagData;
    }

    public List<TokenType> getReceiveTokenTypes() throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        ChannelSettingsAccessor channelSettingsAccessor = sessionData.getChannelSettingsAccessor();
        Set set = this.conversionHandler.convertSet(PrincipalTypeInputVO.class, (Iterable)channelSettingsAccessor.getPos().getPrincipalTypes());
        ArrayList<TokenType> arrayList = new ArrayList<TokenType>();
        for (PrincipalTypeInputVO principalTypeInputVO : set) {
            TokenType tokenType = principalTypeInputVO.getTokenType();
            if (tokenType == null) continue;
            arrayList.add(tokenType);
        }
        return arrayList;
    }

    public TokenSearchData getSearchData(TokenPrincipalTypeVO tokenPrincipalTypeVO) {
        TokenPrincipalType tokenPrincipalType = (TokenPrincipalType)this.conversionHandler.convert(TokenPrincipalType.class, (Object)tokenPrincipalTypeVO);
        TokenSearchData tokenSearchData = new TokenSearchData();
        tokenSearchData.setGroups(this.groupsHandler.visibles().accessibles().users().sorted());
        tokenSearchData.setType((TokenPrincipalTypeVO)this.conversionHandler.convert(TokenPrincipalTypeVO.class, (Object)tokenPrincipalType));
        tokenSearchData.setExportFormats(this.conversionHandler.convertList(ExportFormatVO.class, (Iterable)this.exportFormatService.listByContext(ExportFormatContext.TOKENS_SEARCH)));
        TokenQuery tokenQuery = (TokenQuery)QueryHelper.newQuery(TokenQuery.class);
        tokenQuery.setType(tokenSearchData.getType());
        tokenSearchData.setQuery((QueryParameters)tokenQuery);
        return tokenSearchData;
    }

    public boolean hasReachedMaxTokensPerUser(TokenPrincipalType tokenPrincipalType, BasicUser basicUser, Token token) {
        int n = tokenPrincipalType.getMaximumPerUser();
        if (n == 0) {
            return true;
        }
        int n2 = ((DBQuery)this.from(this.$).where(new Predicate[]{((QToken)this.$).user().eq((Object)basicUser), ((QToken)this.$).type().eq((Object)tokenPrincipalType), ((QToken)this.$).status.in((Object[])new TokenStatus[]{TokenStatus.BLOCKED, TokenStatus.ACTIVE}), ((QToken)this.$).expiryDate.isNull().or(((QToken)this.$).expiryDate.future()), token == null ? ((QToken)this.$).id.isNotNull() : ((QToken)this.$).id.ne((Object)token.getId())})).count(((QToken)this.$).id);
        return n2 >= n;
    }

    public InitializeNFCTagResult initializeNFCTag(NFCTagInitializeDTO nFCTagInitializeDTO) throws FrameworkException, TokenAlreadyInUseException {
        this.validate((TokenActionDTO)nFCTagInitializeDTO);
        BasicUser basicUser = null;
        if (nFCTagInitializeDTO.getUser() != null) {
            basicUser = this.userLocatorHandler.locate(nFCTagInitializeDTO.getUser()).getBasicUser();
        }
        NFCTokenInitializationResult nFCTokenInitializationResult = this.activateNFCToken(basicUser, (TokenActionDTO)nFCTagInitializeDTO);
        InitializeNFCTagResult initializeNFCTagResult = new InitializeNFCTagResult();
        initializeNFCTagResult.setApplicationMasterKey(Hex.encodeHexString((byte[])nFCTokenInitializationResult.plainAppMasterKey));
        initializeNFCTagResult.setOperationalKey(Hex.encodeHexString((byte[])nFCTokenInitializationResult.plainOperationalKey));
        initializeNFCTagResult.setPiccMasterKey(Hex.encodeHexString((byte[])nFCTokenInitializationResult.plainPiccMasterKey));
        initializeNFCTagResult.setTokenLabel(nFCTokenInitializationResult.tokenLabel);
        return initializeNFCTagResult;
    }

    @Override
    public Token newEntity(TokenDataParams tokenDataParams) {
        TokenPrincipalType tokenPrincipalType = (TokenPrincipalType)this.conversionHandler.convert(TokenPrincipalType.class, (Object)tokenDataParams.getType());
        Object object = ObjectHelper.isOneOf((Object)tokenPrincipalType.getTokenType(), (Object[])new Object[]{TokenType.NFC_DEVICE, TokenType.NFC_TAG}) ? new NFCToken() : new Token();
        BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)tokenDataParams.getUser());
        if (basicUser != null && basicUser.isRemoved()) {
            throw new IllegalActionException();
        }
        object.setType(tokenPrincipalType);
        object.setUser(basicUser);
        return object;
    }

    public void personalizeNFCTag(NFCTagPersonalizeDTO nFCTagPersonalizeDTO) throws FrameworkException, TokenAlreadyInUseException {
        this.validate(nFCTagPersonalizeDTO);
        BasicUser basicUser = this.userLocatorHandler.locate(nFCTagPersonalizeDTO.getUser()).getBasicUser();
        this.doPersonalizeNFCTag(nFCTagPersonalizeDTO, basicUser, nFCTagPersonalizeDTO.getConfirmationPassword(), false, nFCTagPersonalizeDTO.getCyclosChallenge());
    }

    public void personalizeNFCTag(NFCTagWithChallengeDTO nFCTagWithChallengeDTO, BasicUser basicUser) throws FrameworkException, TokenAlreadyInUseException {
        this.validate(nFCTagWithChallengeDTO);
        this.doPersonalizeNFCTag(nFCTagWithChallengeDTO, basicUser, null, true, nFCTagWithChallengeDTO.getChallenge());
    }

    public void removeAll(BasicUser basicUser) {
        CloseableIterator closeableIterator = ((DBQuery)this.from(this.$).where((Predicate)((QToken)this.$).user().eq((Object)basicUser))).iterate((Expression)this.$);
        this.processBatch(closeableIterator, this::remove);
    }

    public void removeDeviceConfirmationForPersonalizeNFCTag(@NotNull UserLocatorVO userLocatorVO, @NotNull TokenPrincipalTypeVO tokenPrincipalTypeVO, String string) throws FrameworkException {
        this.runAsTagOwner(userLocatorVO, () -> {
            this.deviceConfirmationService.remove(string);
            return null;
        });
    }

    public ExternalNFCTagAuthenticateData requestForExternalAuthenticate(ExternalNFCTagAuthenticateDTO externalNFCTagAuthenticateDTO) throws FrameworkException {
        this.validate(externalNFCTagAuthenticateDTO);
        NFCTokenPrincipalType nFCTokenPrincipalType = (NFCTokenPrincipalType)this.conversionHandler.convert(NFCTokenPrincipalType.class, (Object)externalNFCTagAuthenticateDTO.getTokenType());
        NFCTagKey nFCTagKey = (NFCTagKey)ObjectHelper.defaultValue((Object)externalNFCTagAuthenticateDTO.getKeyType(), (Object)NFCTagKey.OPERATIONAL_KEY);
        switch (nFCTagKey) {
            case OPERATIONAL_KEY: {
                QNFCToken qNFCToken = QNFCToken.nFCToken;
                NFCToken nFCToken = (NFCToken)((DBQuery)this.from(new EntityPath[]{qNFCToken}).where((Predicate)qNFCToken.type().eq((Object)nFCTokenPrincipalType).and((Predicate)qNFCToken.value.eq((Object)externalNFCTagAuthenticateDTO.getTokenValue())))).singleResult((Expression)qNFCToken);
                if (nFCToken == null) {
                    throw new EntityNotFoundException(NFCToken.class, externalNFCTagAuthenticateDTO.getTokenValue());
                }
                return this.startExternalAuthenticate(nFCToken, externalNFCTagAuthenticateDTO.getChallenge());
            }
            case PICC_MASTER_KEY: {
                return this.startExternalAuthenticatePicc(nFCTokenPrincipalType, externalNFCTagAuthenticateDTO.getChallenge());
            }
        }
        throw new IllegalArgumentException("Can't complete the external authenticate: unknown NFC key type: " + String.valueOf(externalNFCTagAuthenticateDTO.getKeyType()));
    }

    public void requestNewOTPForPersonalizeNFCTag(UserLocatorVO userLocatorVO, TokenPrincipalTypeVO tokenPrincipalTypeVO, SendMedium sendMedium) throws FrameworkException, SmsSendingException {
        this.runAsTagOwner(userLocatorVO, () -> {
            List list = this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).getOtpSendMediums();
            PermissionHelper.checkContains((Collection)list, (Object)sendMedium);
            this.passwordService.requestNewOTP(sendMedium, null, null);
            return null;
        });
    }

    public Page<TokenVO> search(TokenQuery tokenQuery) throws FrameworkException, QueryParseException {
        DBQuery<?> dBQuery = this.getTokenQuery(tokenQuery);
        return dBQuery.page(TokenVO.class, (QueryParameters)tokenQuery, (Expression)this.$);
    }

    public void setActivationDeadline(@NotNull Long l, DateTime dateTime) throws FrameworkException {
        Token token = (Token)this.find(l);
        if (!this.canChangeActivationDeadline(token)) {
            throw new IllegalActionException("Cannot set the activation deadline for token '" + String.valueOf(token) + "' with status" + String.valueOf(token.getStatus()));
        }
        TokenDTO tokenDTO = this.toDTO(token);
        tokenDTO.setActivationDeadline(dateTime);
        this.validate(tokenDTO);
        Date date = token.getActivationDeadline();
        Date date2 = this.conversionHandler.toDate((IDate)dateTime);
        this.logActivationDeadline(token, date, date2);
        token.setActivationDeadline(date2);
        if (token.getStatus() == TokenStatus.ACTIVATION_EXPIRED && (date2 == null || date2.after(DateHelper.now()))) {
            this.setStatusAndNotify(token, TokenStatus.PENDING_ACTIVATION, true);
        }
    }

    public void setExpiryDate(@NotNull Long l, DateTime dateTime) throws FrameworkException {
        Token token = (Token)this.find(l);
        if (!this.canChangeExpiryDate(token)) {
            throw new IllegalActionException("Cannot set the expiry date for token '" + String.valueOf(token) + "' with status" + String.valueOf(token.getStatus()));
        }
        TokenDTO tokenDTO = this.toDTO(token);
        tokenDTO.setExpiryDate(dateTime);
        this.validate(tokenDTO);
        Date date = token.getExpiryDate();
        Date date2 = this.conversionHandler.toDate((IDate)dateTime);
        this.logExpiryDate(token, date, date2);
        token.setExpiryDate(date2);
        if (token.getStatus() == TokenStatus.EXPIRED && (date2 == null || date2.after(DateHelper.now()))) {
            this.setStatusAndNotify(token, TokenStatus.ACTIVE, true);
        }
    }

    @Override
    public TokenDTO toDTO(Token token) {
        TokenDTO tokenDTO = (TokenDTO)super.toDTO(token);
        String string = token.getType().getTokenMask();
        if (token instanceof NFCToken) {
            tokenDTO.setValue(null);
        } else {
            tokenDTO.setValue(MaskHelper.applyMask((String)string, (String)token.getValue()));
        }
        return tokenDTO;
    }

    @Override
    public Token toEntity(TokenDTO tokenDTO) {
        Token token = (Token)super.toEntity(tokenDTO);
        String string = token.getType().getTokenMask();
        if (!(token instanceof NFCToken)) {
            token.setValue(MaskHelper.removeMask((String)string, (String)tokenDTO.getValue()));
        }
        return token;
    }

    public void unblock(Long l) {
        Token token = (Token)this.find(l);
        if (!this.canUnblock(token)) {
            throw new IllegalActionException();
        }
        this.setStatusAndNotify(token, TokenStatus.ACTIVE, true);
    }

    public void validateNFCChallenge(String string) throws ValidationException {
        Token token = this.getSessionData().getToken();
        if (token instanceof NFCToken) {
            this.validateNFCChallenge((NFCToken)token, string);
        }
    }

    public DeviceConfirmationVO viewDeviceConfirmationForPersonalizeNFCTag(@NotNull UserLocatorVO userLocatorVO, @NotNull TokenPrincipalTypeVO tokenPrincipalTypeVO, String string) throws FrameworkException {
        return this.runAsTagOwner(userLocatorVO, () -> this.deviceConfirmationService.load(string));
    }

    @Override
    protected TokenData getData(Token token) {
        TokenData tokenData = new TokenData();
        tokenData.setDto((EntityDTO)this.toDTO(token));
        tokenData.setCanActivate(this.canActivate(token, false));
        tokenData.setCanAssign(this.canAssign(token));
        tokenData.setCanBlock(this.canBlock(token));
        tokenData.setCanUnblock(this.canUnblock(token));
        tokenData.setCanCancel(this.canCancel(token));
        tokenData.setCanChangeExpiryDate(this.canChangeExpiryDate(token));
        tokenData.setCanChangeActivationDeadline(this.canChangeActivationDeadline(token));
        tokenData.setTokenMask(token.getType().getTokenMask());
        return tokenData;
    }

    @Override
    protected void onAfterSave(Token token, Token token2, Object object) {
        if (token2 == null && token.getUser() != null) {
            this.notifyNew(token);
        }
    }

    @Override
    protected Object onBeforeSave(Token token, Token token2) {
        block19: {
            TokenStatus tokenStatus;
            block18: {
                if (token.isTransient()) {
                    token.setCreationDate(new Date());
                }
                TokenStatus tokenStatus2 = tokenStatus = token2 == null ? token.getStatus() : token2.getStatus();
                if (!token.isTransient() && tokenStatus != TokenStatus.UNASSIGNED) break block18;
                if (token.getUser() == null) {
                    token.setStatus(TokenStatus.UNASSIGNED);
                } else if (token.isActivateNow()) {
                    token.setStatus(TokenStatus.ACTIVE);
                } else {
                    token.setStatus(TokenStatus.PENDING_ACTIVATION);
                }
                switch (token.getStatus()) {
                    case ACTIVE: {
                        token.setActivationDate(DateHelper.now());
                        if (token.getExpiryDate() == null) {
                            this.setExpiryAndActivationDate(token);
                        }
                        break block19;
                    }
                    case PENDING_ACTIVATION: {
                        if (token.getActivationDeadline() == null) {
                            this.setActivationDeadline(token);
                        }
                        token.setActivationDate(null);
                        token.setExpiryDate(null);
                        break block19;
                    }
                    case UNASSIGNED: {
                        token.setUser(null);
                        token.setActivationDate(null);
                        token.setExpiryDate(null);
                        break block19;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            token.setStatus(tokenStatus);
            if (token2.getUser() != null) {
                token.setUser(token2.getUser());
            }
            if (!this.canChangeExpiryDate(token2)) {
                token.setExpiryDate(token2.getExpiryDate());
            }
            if (!this.canChangeActivationDeadline(token2)) {
                token.setActivationDeadline(token2.getActivationDeadline());
            }
            if (token2.getStatus() == TokenStatus.ACTIVATION_EXPIRED && (token.getActivationDeadline() == null || token.getActivationDeadline().after(DateHelper.now()))) {
                this.setStatusAndNotify(token, TokenStatus.PENDING_ACTIVATION, false);
            } else if (token2.getStatus() == TokenStatus.EXPIRED && (token.getExpiryDate() == null || token.getExpiryDate().after(DateHelper.now()))) {
                this.setStatusAndNotify(token, TokenStatus.ACTIVE, false);
            }
        }
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QToken)this.$).type().network());
    }

    @Override
    protected Validator resolveValidator(TokenDTO tokenDTO) {
        boolean bl;
        Object object4;
        BasicUser basicUser;
        String string;
        TokenPrincipalType tokenPrincipalType;
        org.cyclos.impl.utils.validation.Property property;
        TokenStatus tokenStatus;
        Validator validator = new Validator();
        boolean bl2 = tokenDTO instanceof NFCTokenDTO;
        Token token = null;
        if (tokenDTO.isTransient()) {
            tokenStatus = TokenStatus.UNASSIGNED;
            property = bl2 ? NFCTokenPrincipalType.class : TokenPrincipalType.class;
            tokenPrincipalType = (TokenPrincipalType)this.conversionHandler.convert(property, (Object)tokenDTO.getType());
        } else {
            token = (Token)this.find(tokenDTO.getId());
            tokenStatus = token.getStatus();
            tokenPrincipalType = token.getType();
        }
        validator.property((Property)TokenDTO.TYPE, AccessKeys.Tokens.TYPE).required();
        property = validator.property((Property)TokenDTO.VALUE, AccessKeys.Tokens.VALUE);
        if (tokenDTO.isTransient()) {
            property.required();
        }
        if (bl2 && tokenPrincipalType != null) {
            string = ((NFCTokenDTO)tokenDTO).getLabel();
            if (tokenDTO.isTransient() && StringHelper.isNotBlank((Object)string)) {
                basicUser = QNFCToken.nFCToken;
                object4 = (DBQuery)this.from(new EntityPath[]{basicUser}).where((Predicate)basicUser.type().eq((Object)tokenPrincipalType).and((Predicate)basicUser.label.eq((Object)string)));
                String string2 = "nfcLabel_" + SimpleEntity.id((SimpleEntity)tokenPrincipalType) + "_" + string;
                validator.property((Property)NFCTokenDTO.LABEL, AccessKeys.Tokens.LABEL).required().unique(string2, (AbstractJPAQuery)object4).maskValue(tokenPrincipalType.getTokenMask());
            }
        }
        string = tokenDTO.getValue();
        if (tokenDTO.isTransient() && StringHelper.isNotBlank((Object)string) && tokenPrincipalType != null) {
            if (!bl2) {
                string = MaskHelper.removeMask((String)tokenPrincipalType.getTokenMask(), (String)tokenDTO.getValue());
                property.maskValue(tokenPrincipalType.getTokenMask());
            }
            basicUser = (DBQuery)this.from(this.$).where((Predicate)((QToken)this.$).type().eq((Object)tokenPrincipalType).and((Predicate)((QToken)this.$).value.eq((Object)string)));
            object4 = "nfcValue_" + SimpleEntity.id((SimpleEntity)tokenPrincipalType) + "_" + string;
            property.unique((String)object4, (AbstractJPAQuery)basicUser);
        }
        basicUser = tokenStatus != TokenStatus.UNASSIGNED ? token.getUser() : (BasicUser)this.conversionHandler.convert(BasicUser.class, (Object)tokenDTO.getUser());
        boolean bl3 = tokenStatus == TokenStatus.UNASSIGNED && basicUser != null && tokenDTO.isActivateNow();
        boolean bl4 = bl = tokenStatus == TokenStatus.EXPIRED && tokenDTO.getExpiryDate() != null && DateHelper.now().before(this.toDate(tokenDTO.getExpiryDate()));
        if (bl3 || bl) {
            this.checkMaxTokensLimit(tokenPrincipalType, basicUser, null);
        }
        validator.property((Property)TokenDTO.USER, AccessKeys.Tokens.USER).add((object, object2, object3) -> {
            BasicUser basicUser = (BasicUser)this.conversionHandler.convert(BasicUser.class, object3);
            return basicUser != null && !this.isEnabled(basicUser, tokenPrincipalType) ? new ValidationError(AccessKeys.Tokens.ERROR_NOT_ENABLED_TOKEN_TYPE) : null;
        });
        validator.property((Property)TokenDTO.EXPIRY_DATE, AccessKeys.Tokens.EXPIRY_DATE).futureDate();
        if (token == null || token.getActivationDate() == null) {
            validator.property((Property)TokenDTO.ACTIVATION_DEADLINE, AccessKeys.Tokens.ACTIVATION_DEADLINE).futureDate();
        }
        return validator;
    }

    protected void setActivationDeadline(Token token) {
        if (token.getType().getActivation() != null) {
            Date date = DateHelper.add((Date)DateHelper.now(), (ITimeInterval)token.getType().getActivation());
            TimeZone timeZone = this.getSessionData().getConfiguration().getTimeZone();
            date = DateHelper.shiftToEnd((Date)date, (TimeZone)timeZone);
            token.setActivationDeadline(date);
        }
    }

    protected void setExpiryAndActivationDate(Token token) {
        token.setActivationDate(DateHelper.now());
        if (token.getType().getExpiration() != null) {
            Date date = DateHelper.add((Date)DateHelper.now(), (ITimeInterval)token.getType().getExpiration());
            TimeZone timeZone = this.getSessionData().getConfiguration().getTimeZone();
            date = DateHelper.shiftToEnd((Date)date, (TimeZone)timeZone);
            token.setExpiryDate(date);
        }
    }

    @Override
    protected BidiMap<Class<? extends Token>, Class<? extends TokenDTO>> subClassMappings() {
        return SUBCLASS_MAPPINGS;
    }

    private NFCTokenInitializationResult activateNFCToken(BasicUser basicUser, TokenActionDTO tokenActionDTO) {
        NFCTokenPrincipalType nFCTokenPrincipalType = (NFCTokenPrincipalType)this.conversionHandler.convert(NFCTokenPrincipalType.class, (Object)tokenActionDTO.getTokenType());
        boolean bl = basicUser == null;
        QNFCToken qNFCToken = QNFCToken.nFCToken;
        NFCToken nFCToken = (NFCToken)((DBQuery)this.from(new EntityPath[]{qNFCToken}).where((Predicate)qNFCToken.type().eq((Object)nFCTokenPrincipalType).and((Predicate)qNFCToken.value.eq((Object)tokenActionDTO.getTokenValue())))).singleResult((Expression)qNFCToken);
        if (nFCToken != null && nFCToken.isInUse()) {
            throw new TokenAlreadyInUseException((TokenVO)this.conversionHandler.convert(TokenVO.class, (Object)nFCToken));
        }
        if (nFCToken != null) {
            nFCToken.setValue(nFCToken.getValue() + "_" + this.conversionHandler.toDateTime(DateHelper.now()).toString());
        }
        if (!bl) {
            this.checkMaxTokensLimit((TokenPrincipalType)nFCTokenPrincipalType, basicUser, nFCToken);
        }
        String string = this.getNFCTokenLabel(tokenActionDTO);
        nFCToken = new NFCToken();
        nFCToken.setCreationDate(DateHelper.now());
        nFCToken.setType((TokenPrincipalType)nFCTokenPrincipalType);
        nFCToken.setValue(tokenActionDTO.getTokenValue());
        nFCToken.setLabel(StringHelper.isBlank((Object)string) ? this.getNewLabel(nFCTokenPrincipalType) : string);
        nFCToken.setUser(basicUser);
        this.setStatusAndNotify((Token)nFCToken, bl ? TokenStatus.UNASSIGNED : TokenStatus.ACTIVE, false);
        if (!bl) {
            this.setExpiryAndActivationDate((Token)nFCToken);
        }
        this.persist((IEntity)nFCToken);
        this.logEntity(null, nFCToken);
        Pair<byte[], byte[]> pair = this.generateKeys();
        Pair<byte[], byte[]> pair2 = this.encryptKeys((byte[])pair.getFirst(), (byte[])pair.getSecond(), nFCToken);
        nFCToken.setAppMasterKey((byte[])pair2.getFirst());
        nFCToken.setOperationalKey((byte[])pair2.getSecond());
        NFCTokenInitializationResult nFCTokenInitializationResult = new NFCTokenInitializationResult();
        nFCTokenInitializationResult.plainAppMasterKey = (byte[])pair.getFirst();
        nFCTokenInitializationResult.plainOperationalKey = (byte[])pair.getSecond();
        nFCTokenInitializationResult.plainPiccMasterKey = this.principalTypeService.getPiccMasterKey(nFCTokenPrincipalType);
        nFCTokenInitializationResult.tokenLabel = nFCToken.getLabel();
        return nFCTokenInitializationResult;
    }

    private void activatePending(Token token) {
        if (!this.canActivate(token, true)) {
            throw new IllegalActionException();
        }
        this.setStatusAndNotify(token, TokenStatus.ACTIVE, true);
        this.setExpiryAndActivationDate(token);
        this.logExpiryDate(token, null, token.getExpiryDate());
        this.logActivationDate(token, null, token.getActivationDate());
    }

    private boolean canActivate(Token token, boolean bl) {
        if (bl ? token.getStatus() != TokenStatus.PENDING_ACTIVATION || token.getUser() == null : token.getStatus() != TokenStatus.UNASSIGNED && token.getStatus() != TokenStatus.PENDING_ACTIVATION && token.isPersistent()) {
            return false;
        }
        return token.getUser() == null || !this.hasReachedMaxTokensPerUser(token.getType(), token.getUser(), null);
    }

    private boolean canActivateNew(TokenPrincipalType tokenPrincipalType, BasicUser basicUser) {
        if (basicUser.isOperator() ? !this.hasPermission(Permission.MY_OPERATORS_MANAGE_OPERATORS) : !basicUser.equals((Object)this.getLoggedBasicUser())) {
            return false;
        }
        return !this.hasReachedMaxTokensPerUser(tokenPrincipalType, basicUser, null);
    }

    private boolean canAssign(Token token) {
        return token.isTransient() || token.getStatus() == TokenStatus.UNASSIGNED;
    }

    private boolean canBlock(Token token) {
        return token.isPersistent() && token.getStatus() == TokenStatus.ACTIVE;
    }

    private boolean canCancel(Token token) {
        return token.isPersistent() && token.getStatus() != TokenStatus.CANCELED;
    }

    private boolean canChangeActivationDeadline(Token token) {
        return token.isPersistent() && ObjectHelper.isOneOf((Object)token.getStatus(), (Object[])new Object[]{TokenStatus.PENDING_ACTIVATION, TokenStatus.ACTIVATION_EXPIRED});
    }

    private boolean canChangeExpiryDate(Token token) {
        return ObjectHelper.isOneOf((Object)token.getStatus(), (Object[])new Object[]{TokenStatus.ACTIVE, TokenStatus.BLOCKED, TokenStatus.EXPIRED});
    }

    private boolean canUnblock(Token token) {
        return token.isPersistent() && token.getStatus() == TokenStatus.BLOCKED;
    }

    private void checkMaxTokensLimit(TokenPrincipalType tokenPrincipalType, BasicUser basicUser, NFCToken nFCToken) {
        if (this.hasReachedMaxTokensPerUser(tokenPrincipalType, basicUser, (Token)nFCToken)) {
            throw new ValidationException(this.message(AccessKeys.Tokens.ERROR_MAX_TOKENS_REACHED, new Object[0]));
        }
    }

    private <DTO extends TokenActionDTO> void doPersonalizeNFCTag(DTO DTO, BasicUser basicUser, String string, boolean bl, String string2) throws FrameworkException, TokenAlreadyInUseException {
        SessionData sessionData = this.getSessionData();
        if (!bl && !sessionData.manages(basicUser)) {
            this.runAsTagOwner(new UserLocatorVO(basicUser.getId()), () -> {
                this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(string, PersonalizeNfcTagConfirmationField.confirmation());
                return null;
            });
        }
        NFCTokenPrincipalType nFCTokenPrincipalType = (NFCTokenPrincipalType)this.conversionHandler.convert(NFCTokenPrincipalType.class, (Object)DTO.getTokenType());
        QNFCToken qNFCToken = QNFCToken.nFCToken;
        NFCToken nFCToken = (NFCToken)((DBQuery)this.from(new EntityPath[]{qNFCToken}).where((Predicate)qNFCToken.type().eq((Object)nFCTokenPrincipalType).and((Predicate)qNFCToken.value.eq((Object)DTO.getTokenValue())))).singleResult((Expression)qNFCToken);
        if (nFCToken == null) {
            throw new EntityNotFoundException(NFCToken.class, DTO.getTokenValue());
        }
        if (nFCToken.isInUse()) {
            throw new TokenAlreadyInUseException((TokenVO)this.conversionHandler.convert(TokenVO.class, (Object)nFCToken));
        }
        this.validateNFCChallenge(nFCToken, string2);
        nFCToken.resetChallenge();
        if (!bl) {
            this.checkMaxTokensLimit((TokenPrincipalType)nFCTokenPrincipalType, basicUser, nFCToken);
        }
        nFCToken.setUser(basicUser);
        nFCToken.setStatus(TokenStatus.ACTIVE);
        this.notifyNew((Token)nFCToken);
        this.setExpiryAndActivationDate((Token)nFCToken);
    }

    private Pair<byte[], byte[]> encryptKeys(byte[] byArray, byte[] byArray2, NFCToken nFCToken) {
        byte[] byArray3 = this.getKeyMask(nFCToken);
        String string = Base64.getEncoder().encodeToString(byArray);
        String string2 = Base64.getEncoder().encodeToString(byArray2);
        return Pair.create((Object)this.applicationHandler.encrypt(string, byArray3), (Object)this.applicationHandler.encrypt(string2, byArray3));
    }

    private Pair<byte[], byte[]> generateKeys() {
        byte[] byArray = new byte[16];
        byte[] byArray2 = new byte[16];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(byArray);
        secureRandom.nextBytes(byArray2);
        return Pair.create((Object)byArray, (Object)byArray2);
    }

    private CloseableIterator<Token> getIteratorForExpiredTokens() {
        DBQuery dBQuery = (DBQuery)this.from(this.$).where((Predicate)((QToken)this.$).status.in((Object[])new TokenStatus[]{TokenStatus.ACTIVE, TokenStatus.BLOCKED}).and((Predicate)((QToken)this.$).expiryDate.isNotNull().and(((QToken)this.$).expiryDate.future().not())).or((Predicate)((QToken)this.$).status.eq((Object)TokenStatus.PENDING_ACTIVATION).and((Predicate)((QToken)this.$).activationDeadline.isNotNull().and(((QToken)this.$).activationDeadline.future().not()))));
        return dBQuery.iterate((Expression)this.$);
    }

    private String getNewLabel(NFCTokenPrincipalType nFCTokenPrincipalType) {
        String string;
        DBQuery dBQuery;
        if (nFCTokenPrincipalType.getTokenType() != TokenType.NFC_TAG) {
            throw new IllegalArgumentException("Invalid token principal type. It must be " + String.valueOf(TokenType.NFC_TAG) + " but is " + String.valueOf(nFCTokenPrincipalType.getTokenType()));
        }
        QNFCToken qNFCToken = QNFCToken.nFCToken;
        do {
            string = MaskHelper.generateValue((String)nFCTokenPrincipalType.getTokenMask(), (boolean)true);
        } while ((dBQuery = (DBQuery)this.from(new EntityPath[]{qNFCToken}).where((Predicate)qNFCToken.label.eq((Object)string).and((Predicate)qNFCToken.type().eq((Object)nFCTokenPrincipalType)))).hasResults());
        return string;
    }

    private String getNFCTokenLabel(TokenActionDTO tokenActionDTO) {
        if (tokenActionDTO instanceof NFCDeviceActionDTO) {
            return ((NFCDeviceActionDTO)tokenActionDTO).getLabel();
        }
        if (tokenActionDTO instanceof NFCTagInitializeDTO) {
            return ((NFCTagInitializeDTO)tokenActionDTO).getLabel();
        }
        return null;
    }

    private OrderSpecifier<?>[] getOrderBy(QToken qToken, BasicUser basicUser) {
        OrderSpecifier[] orderSpecifierArray = new OrderSpecifier[basicUser == null ? 3 : 4];
        int n = 0;
        if (basicUser != null) {
            orderSpecifierArray[n++] = ((NumberExpression)new CaseBuilder().when((Predicate)qToken.user().eq((Object)basicUser)).then((Number)1).otherwise((Object)2)).asc();
        }
        orderSpecifierArray[n++] = qToken.user().name.asc();
        orderSpecifierArray[n++] = qToken.creationDate.desc();
        orderSpecifierArray[n] = qToken.id.asc();
        return orderSpecifierArray;
    }

    private ChannelConfiguration getPOSChannelConfiguration(BasicUser basicUser) {
        return this.configurationHandler.getAccessor(basicUser).getChannelConfiguration(this.channelService.getPos());
    }

    private DBQuery<?> getTokenQuery(TokenQuery tokenQuery) {
        String string;
        User user;
        QOperator qOperator;
        Object object;
        DatePeriodDTO datePeriodDTO;
        QBasicUser qBasicUser = QBasicUser.basicUser;
        DBQuery dBQuery = (DBQuery)this.from(this.$).leftJoin((EntityPath)((QToken)this.$).user(), (Path)qBasicUser);
        DatePeriodDTO datePeriodDTO2 = tokenQuery.getActivation();
        TokenPrincipalType tokenPrincipalType = (TokenPrincipalType)this.conversionHandler.convert(TokenPrincipalType.class, (Object)tokenQuery.getType());
        if (tokenPrincipalType != null) {
            dBQuery.where((Predicate)((QToken)this.$).type().eq((Object)tokenPrincipalType));
        }
        if (QueryHelper.useParameter((Object)datePeriodDTO2)) {
            dBQuery.where(((QToken)this.$).activationDate.period((DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)datePeriodDTO2)));
        }
        if (QueryHelper.useParameter((Object)(datePeriodDTO = tokenQuery.getExpiry()))) {
            dBQuery.where(((QToken)this.$).expiryDate.period((DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)datePeriodDTO)));
        }
        boolean bl = this.hasPermission(Permission.USER_OPERATORS_VIEW);
        Set set = this.conversionHandler.convertSet(Group.class, (Iterable)tokenQuery.getGroups());
        Set set2 = this.conversionHandler.convertSet(User.class, (Iterable)tokenQuery.getBrokers());
        if (!set.isEmpty() || !set2.isEmpty()) {
            object = QUser.user;
            qOperator = new QOperator("op");
            user = bl ? ((DBQuery)this.subQuery(new EntityPath[]{object}).where(new Predicate[]{object.id.eq((Expression)qBasicUser.id), set.isEmpty() ? object.id.isNotNull() : object.group().in((Collection)set), set2.isEmpty() ? object.id.isNotNull() : ((QUser)object.brokers.any()).in((Collection)set2)})).exists().or((Predicate)((DBQuery)this.subQuery(new EntityPath[]{qOperator}).where(new Predicate[]{qOperator.id.eq((Expression)qBasicUser.id), set.isEmpty() ? qOperator.id.isNotNull() : qOperator.user().group().in((Collection)set), set2.isEmpty() ? qOperator.id.isNotNull() : ((QUser)qOperator.user().brokers.any()).in((Collection)set2)})).exists()) : ((DBQuery)this.subQuery(new EntityPath[]{object}).where(new Predicate[]{object.id.eq((Expression)qBasicUser.id), set.isEmpty() ? object.id.isNotNull() : object.group().in((Collection)set), set2.isEmpty() ? object.id.isNotNull() : ((QUser)object.brokers.any()).in((Collection)set2)})).exists();
            string = qBasicUser.isNull();
            if (!QueryHelper.useParameter((Object)tokenQuery.getStatuses()) || tokenQuery.getStatuses().contains(TokenStatus.UNASSIGNED)) {
                dBQuery.where((Predicate)string.or((Predicate)user));
            } else {
                dBQuery.where((Predicate)user);
            }
        }
        if (QueryHelper.useParameter((Object)(object = tokenQuery.getStatuses()))) {
            dBQuery.where((Predicate)((QToken)this.$).status.in((Collection)object));
        }
        qOperator = tokenQuery.getUser();
        user = null;
        if (QueryHelper.useParameter((Object)qOperator)) {
            string = new QOperator("op");
            user = (User)this.conversionHandler.convert(User.class, (Object)qOperator);
            if (bl) {
                dBQuery.where((Predicate)qBasicUser.eq((Object)user).or((Predicate)((DBQuery)this.subQuery(new EntityPath[]{string}).where(new Predicate[]{string.user().eq((Object)user), qBasicUser.id.eq((Expression)((QOperator)string).id)})).exists()));
            } else {
                dBQuery.where((Predicate)qBasicUser.eq((Object)user));
            }
        }
        if (QueryHelper.useParameter((Object)(string = tokenQuery.getValue())) && tokenPrincipalType != null) {
            if (tokenPrincipalType.getTokenType().isNFC()) {
                QNFCToken qNFCToken = QNFCToken.nFCToken;
                ((DBQuery)dBQuery.leftJoin((EntityPath)qNFCToken)).on((Predicate)((QToken)this.$).id.eq((Expression)qNFCToken.id));
                dBQuery.where((Predicate)qNFCToken.label.eq((Object)string).or((Predicate)qNFCToken.value.eq((Object)string)));
            } else {
                dBQuery.where((Predicate)((QToken)this.$).value.eq((Object)MaskHelper.removeMask((String)tokenPrincipalType.getTokenMask(), (String)string)));
            }
        }
        dBQuery.orderBy(this.getOrderBy((QToken)this.$, (BasicUser)(bl ? user : null)));
        return dBQuery;
    }

    private Validator getValidator(boolean bl) {
        Validator validator = new Validator();
        validator.property((Property)TokenActionDTO.TOKEN_TYPE, AccessKeys.Tokens.TYPE).required();
        if (bl) {
            validator.property((Property)TokenActionDTO.TOKEN_VALUE, AccessKeys.Tokens.VALUE).required();
        }
        return validator;
    }

    private Validator getValidator(TokenActionDTO tokenActionDTO, Property<String, ?> property, boolean bl) {
        Validator validator = this.getValidator(bl);
        validator.property(property, AccessKeys.Tokens.CHALLENGE).required().add((object, object2, object3) -> {
            try {
                Hex.decodeHex((char[])((String)object3).toCharArray());
                return null;
            }
            catch (DecoderException decoderException) {
                return new ValidationError(AccessKeys.Tokens.ERROR_INVALID_HEXA_CHALLENGE);
            }
        });
        return validator;
    }

    private boolean isEnabled(BasicUser basicUser, TokenPrincipalType tokenPrincipalType) {
        if (basicUser == null || tokenPrincipalType == null) {
            return false;
        }
        return this.productsHandler.getAccessor(basicUser).member().getMyTokenTypes().isSet((Object)tokenPrincipalType, (Path)QProductMyTokenType.productMyTokenType.enable);
    }

    private void logActivationDate(Token token, Date date, Date date2) {
        this.entityLogService.log((SimpleEntity)token, this.message(AccessKeys.Tokens.ACTIVATION_DATE, new Object[0]), TokenDTO.ACTIVATION_DATE.getName(), this.getFormatter().format(date), this.getFormatter().format(date2), null);
    }

    private void logActivationDeadline(Token token, Date date, Date date2) {
        if (date2 != null) {
            this.entityLogService.log((SimpleEntity)token, this.message(AccessKeys.Tokens.ACTIVATION_DEADLINE, new Object[0]), TokenDTO.ACTIVATION_DEADLINE.getName(), this.getFormatter().format(date), this.getFormatter().format(date2), null);
        }
    }

    private void logExpiryDate(Token token, Date date, Date date2) {
        if (date2 != null) {
            this.entityLogService.log((SimpleEntity)token, this.message(AccessKeys.Tokens.EXPIRY_DATE, new Object[0]), TokenDTO.EXPIRY_DATE.getName(), this.getFormatter().format(date), this.getFormatter().format(date2), null);
        }
    }

    private void logStatus(Token token, TokenStatus tokenStatus, TokenStatus tokenStatus2) {
        this.entityLogService.log((SimpleEntity)token, this.message(AccessKeys.Tokens.STATUS, new Object[0]), TokenDTO.STATUS.getName(), this.getFormatter().format((HasMessageKey)tokenStatus2), this.getFormatter().format((HasMessageKey)tokenStatus), null);
    }

    private void notifyNew(Token token) {
        if (token.getUser() == null) {
            throw new IllegalStateException("Cannot notify new for unassigned token");
        }
        if (token.getStatus() == TokenStatus.PENDING_ACTIVATION) {
            this.notificationHandler.user(token.getUser()).personal().newTokenPendingActivation(token, token.getType());
        } else {
            this.notificationHandler.user(token.getUser()).personal().newToken(token, token.getType());
        }
    }

    private byte[] rotate(byte[] byArray, boolean bl) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        if (bl) {
            System.arraycopy(byArray, 1, byArray2, 0, n - 1);
        } else {
            System.arraycopy(byArray, 0, byArray2, 1, n - 1);
        }
        byArray2[bl ? n - 1 : 0] = bl ? byArray[0] : byArray[n - 1];
        return byArray2;
    }

    private <T> T runAsTagOwner(UserLocatorVO userLocatorVO, Callable<T> callable) {
        LocateUserResult locateUserResult = this.userLocatorHandler.locate(userLocatorVO);
        SessionData sessionData = this.getSessionData();
        DirectUserSessionData directUserSessionData = SessionDataFactory.direct((UserPrincipal)locateUserResult).channel(BuiltInChannel.POS).accessChannel(BuiltInChannel.POS).basedOn(sessionData).build();
        try {
            return (T)this.invokerHandler.runAs((SessionData)directUserSessionData, () -> callable.call());
        }
        catch (Exception exception) {
            ExceptionHelper.throwWithType((Throwable)exception, CyclosException.class);
            return null;
        }
    }

    private void setStatusAndNotify(Token token, TokenStatus tokenStatus, boolean bl) {
        if (token.getStatus() == tokenStatus) {
            return;
        }
        TokenStatus tokenStatus2 = token.getStatus();
        token.setStatus(tokenStatus);
        if (bl) {
            this.logStatus(token, tokenStatus, tokenStatus2);
        }
        if (token.getUser() != null) {
            this.notificationHandler.user(token.getUser()).personal().tokenStatusChanged(token, token.getType(), tokenStatus);
        }
    }

    private ExternalNFCTagAuthenticateData startExternalAuthenticate(NFCToken nFCToken, String string) throws FrameworkException {
        byte[] byArray = nFCToken.getOperationalKey();
        byArray = Base64.getDecoder().decode(this.applicationHandler.decrypt(byArray, this.getKeyMask(nFCToken)));
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            cipher.init(2, (Key)secretKeySpec, new IvParameterSpec(new byte[16]));
            byte[] byArray2 = Hex.decodeHex((char[])string.toCharArray());
            byte[] byArray3 = cipher.doFinal(byArray2);
            byte[] byArray4 = new byte[16];
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.nextBytes(byArray4);
            byte[] byArray5 = this.rotate(byArray3, true);
            byte[] byArray6 = new byte[byArray4.length + byArray5.length];
            System.arraycopy(byArray4, 0, byArray6, 0, byArray4.length);
            System.arraycopy(byArray5, 0, byArray6, byArray4.length, byArray5.length);
            cipher.init(1, (Key)secretKeySpec, new IvParameterSpec(byArray2));
            byArray6 = cipher.doFinal(byArray6);
            byte[] byArray7 = new byte[16];
            System.arraycopy(byArray6, 16, byArray7, 0, byArray7.length);
            nFCToken.setOperationalKeyIv(byArray7);
            nFCToken.setChallenge(byArray4);
            nFCToken.setChallengeExpiration(DateHelper.add((Date)DateHelper.now(), (ITimeInterval)new TimeInterval(Integer.valueOf(5), TimeField.MINUTES)));
            ExternalNFCTagAuthenticateData externalNFCTagAuthenticateData = new ExternalNFCTagAuthenticateData();
            externalNFCTagAuthenticateData.setCyclosChallenge(Hex.encodeHexString((byte[])byArray6));
            externalNFCTagAuthenticateData.setSessionKey(Hex.encodeHexString((byte[])TokenServiceImpl.generateSessionKey(byArray, byArray4, byArray3)));
            return externalNFCTagAuthenticateData;
        }
        catch (DecoderException decoderException) {
            throw new IllegalArgumentException("Error decoding HEXA value: " + decoderException.getMessage(), decoderException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalArgumentException("Error (AES) ciphering/deciphering data: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    private ExternalNFCTagAuthenticateData startExternalAuthenticatePicc(NFCTokenPrincipalType nFCTokenPrincipalType, String string) {
        byte[] byArray = this.principalTypeService.getPiccMasterKey(nFCTokenPrincipalType);
        byte[] byArray2 = Arrays.copyOf(byArray, 24);
        int n = 0;
        int n2 = 16;
        while (n < 8) {
            byArray2[n2++] = byArray[n++];
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, "DESede");
        try {
            Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding");
            cipher.init(2, (Key)secretKeySpec, new IvParameterSpec(new byte[8]));
            byte[] byArray3 = Hex.decodeHex((char[])string.toCharArray());
            byte[] byArray4 = cipher.doFinal(byArray3);
            byte[] byArray5 = new byte[8];
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.nextBytes(byArray5);
            byte[] byArray6 = this.rotate(byArray4, true);
            byte[] byArray7 = new byte[byArray5.length + byArray6.length];
            System.arraycopy(byArray5, 0, byArray7, 0, byArray5.length);
            System.arraycopy(byArray6, 0, byArray7, byArray5.length, byArray6.length);
            cipher.init(1, (Key)secretKeySpec, new IvParameterSpec(byArray3));
            byArray7 = cipher.doFinal(byArray7);
            byte[] byArray8 = new byte[8];
            System.arraycopy(byArray7, 8, byArray8, 0, byArray8.length);
            ExternalNFCTagAuthenticateData externalNFCTagAuthenticateData = new ExternalNFCTagAuthenticateData();
            externalNFCTagAuthenticateData.setCyclosChallenge(Hex.encodeHexString((byte[])byArray7));
            externalNFCTagAuthenticateData.setSessionKey(Hex.encodeHexString((byte[])TokenServiceImpl.generateSessionKey(byArray, byArray5, byArray4)));
            return externalNFCTagAuthenticateData;
        }
        catch (DecoderException decoderException) {
            throw new IllegalArgumentException("Error decoding HEXA value: " + decoderException.getMessage(), decoderException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IllegalArgumentException("Error (TDES) ciphering/deciphering data: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    @Override
    private void validate(ExternalNFCTagAuthenticateDTO externalNFCTagAuthenticateDTO) {
        this.validate(this.getValidator((TokenActionDTO)externalNFCTagAuthenticateDTO, (Property<String, ?>)ExternalNFCTagAuthenticateDTO.CHALLENGE, false), externalNFCTagAuthenticateDTO, "externalNFCTagAuthenticateDTO");
    }

    @Override
    private void validate(NFCTagPersonalizeDTO nFCTagPersonalizeDTO) {
        Validator validator = this.getValidator((TokenActionDTO)nFCTagPersonalizeDTO, (Property<String, ?>)NFCTagPersonalizeDTO.CYCLOS_CHALLENGE, true);
        validator.property((Property)NFCTagPersonalizeDTO.USER, AccessKeys.Tokens.USER).required();
        this.validate(validator, nFCTagPersonalizeDTO, "NFCTagPersonalizeDTO");
    }

    @Override
    private void validate(NFCTagWithChallengeDTO nFCTagWithChallengeDTO) {
        this.validate(this.getValidator((TokenActionDTO)nFCTagWithChallengeDTO, (Property<String, ?>)NFCTagWithChallengeDTO.CHALLENGE, true), nFCTagWithChallengeDTO, "NFCTagWithChallengeDTO");
    }

    @Override
    private void validate(TokenActionDTO tokenActionDTO) {
        this.validate(this.getValidator(true), tokenActionDTO, "tokenActionDTO");
    }

    private void validateNFCChallenge(NFCToken nFCToken, String string) throws ValidationException {
        if (nFCToken instanceof NFCToken) {
            NFCToken nFCToken2 = nFCToken;
            try {
                byte[] byArray = Hex.decodeHex((char[])string.toCharArray());
                byte[] byArray2 = nFCToken2.getOperationalKey();
                byArray2 = Base64.getDecoder().decode(this.applicationHandler.decrypt(byArray2, this.getKeyMask(nFCToken2)));
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, "AES");
                Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
                cipher.init(2, (Key)secretKeySpec, new IvParameterSpec(nFCToken2.getOperationalKeyIv()));
                byte[] byArray3 = cipher.doFinal(byArray);
                byte[] byArray4 = this.rotate(byArray3, false);
                Date date = nFCToken2.getChallengeExpiration();
                byte[] byArray5 = nFCToken2.getChallenge();
                if (date.before(DateHelper.now())) {
                    throw new ValidationException("The challenge has expired");
                }
                if (byArray5.length != byArray4.length) {
                    throw new ValidationException(String.format("Expected and received challenges are not of the same length (%s and %s)", byArray5.length, byArray4.length));
                }
                for (int i = 0; i < byArray4.length; ++i) {
                    if (byArray5[i] == byArray4[i]) continue;
                    throw new ValidationException(String.format("Expected and received challenges are not equal (%s and %s)", String.valueOf(Hex.encodeHex((byte[])byArray5)), string));
                }
            }
            catch (GeneralSecurityException | DecoderException throwable) {
                throw new ValidationException(throwable.getMessage());
            }
        }
    }

    static {
        SUBCLASS_MAPPINGS.put(Token.class, TokenDTO.class);
        SUBCLASS_MAPPINGS.put(NFCToken.class, NFCTokenDTO.class);
    }

    private static class NFCTokenInitializationResult {
        private byte[] plainAppMasterKey;
        private byte[] plainPiccMasterKey;
        private byte[] plainOperationalKey;
        private String tokenLabel;

        private NFCTokenInitializationResult() {
        }
    }
}

