/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Stream;
import org.cyclos.entities.access.PasswordType;
import org.cyclos.entities.system.ChannelAccessAccessor;
import org.cyclos.entities.system.CredentialsConfiguration;
import org.cyclos.entities.system.ICredentials;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.model.access.CredentialUsage;

public class UserCredentials
implements ICredentials {
    private static final Map<CredentialUsage, UserCredentials> EMPTY = new EnumMap<CredentialUsage, UserCredentials>(CredentialUsage.class);
    private ChannelAccessAccessor channelAccessAccessor;
    private CredentialUsage usage;
    private BasicUser user;
    private PasswordType password;
    private boolean device;
    private boolean totp;

    public static UserCredentials empty(CredentialUsage credentialUsage) {
        return EMPTY.get(credentialUsage);
    }

    public UserCredentials(CredentialUsage credentialUsage, ChannelAccessAccessor channelAccessAccessor, BasicUser basicUser) {
        this.usage = credentialUsage;
        this.channelAccessAccessor = channelAccessAccessor;
        this.user = basicUser;
        CredentialsConfiguration credentialsConfiguration = channelAccessAccessor.getCredentials(credentialUsage);
        this.password = credentialsConfiguration.getPassword();
        this.device = credentialsConfiguration.isDevice();
        this.totp = credentialsConfiguration.isTotp();
    }

    private UserCredentials(CredentialUsage credentialUsage) {
        this.usage = credentialUsage;
    }

    public ChannelAccessAccessor getChannelAccessAccessor() {
        return this.channelAccessAccessor;
    }

    public PasswordType getPassword() {
        return this.password;
    }

    public CredentialUsage getUsage() {
        return this.usage;
    }

    public BasicUser getUser() {
        return this.user;
    }

    public boolean isDevice() {
        return this.device;
    }

    public boolean isTotp() {
        return this.totp;
    }

    static {
        Stream.of(CredentialUsage.values()).forEach(credentialUsage -> EMPTY.put((CredentialUsage)credentialUsage, new UserCredentials((CredentialUsage)credentialUsage)));
    }
}

