/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import java.util.Calendar;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.StopWatch;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.banking.AccountVerificationHandler;
import org.cyclos.impl.utils.tasks.SimpleRecurringTask;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.utils.RecurringTaskFirstExecution;
import org.cyclos.model.utils.RecurringTaskRecurrence;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.WeekDay;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;

@Component
public class AccountBalanceVerificationRecurringTask
extends SimpleRecurringTask {
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private AccountVerificationHandler accountVerificationHandler;

    @Override
    public RecurringTaskFirstExecution getFirstExecution() {
        return RecurringTaskFirstExecution.NEXT;
    }

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.ACCOUNT_BALANCE_VERIFICATION;
    }

    @Override
    public String getNotesForLogging() {
        Set set = this.cyclosProperties.getAccountsVerificationBalanceCheckDays();
        if (set.isEmpty()) {
            return "Disabled";
        }
        if (set.size() != WeekDay.values().length) {
            return set.stream().map(WeekDay::toShortString).collect(Collectors.joining(","));
        }
        return "Always";
    }

    @Override
    public RecurringTaskRecurrence getRecurrence() {
        return RecurringTaskRecurrence.NEXT_DAY;
    }

    @Override
    protected long execute() throws Throwable {
        if (!this.shouldCheckBalances()) {
            return 0L;
        }
        SessionData sessionData = SessionDataFactory.system();
        TransactionLevel transactionLevel = TransactionLevel.READ_WRITE;
        return (Long)this.invokerHandler.runAsInTransaction(sessionData, transactionLevel, this::fixInconsistencies);
    }

    @Override
    protected boolean isRunInTransaction() {
        return false;
    }

    private long fixInconsistencies(TransactionStatus transactionStatus) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        List list = this.accountVerificationHandler.fixInconsistentBalances();
        if (list.isEmpty()) {
            this.getLogger().info("No inconsistent account balances found in {}", (Object)stopWatch);
        } else {
            StringBuilder stringBuilder = new StringBuilder().append(list.size()).append(" inconsistent account balances fixed in ").append(stopWatch).append(":");
            list.forEach(inconsistentBalance -> stringBuilder.append("\n * ").append(inconsistentBalance));
            this.getLogger().warn((CharSequence)stringBuilder);
        }
        return list.size();
    }

    private boolean shouldCheckBalances() {
        Set set = this.cyclosProperties.getAccountsVerificationBalanceCheckDays();
        WeekDay weekDay = WeekDay.fromCalendar((int)Calendar.getInstance().get(7));
        return set.contains(weekDay);
    }
}

