/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountLocator;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.banking.AccountHandler;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.LocateAccountOwnerResult;
import org.cyclos.impl.utils.conversion.BaseEntityConverter;
import org.cyclos.impl.utils.validation.validations.RequiredValidation;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.IEntity;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccountConverter
extends BaseEntityConverter<Account> {
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private AccountHandler accountHandler;

    public AccountConverter() {
        super(Account.class);
    }

    @Override
    protected void fill(Object object, Account account, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
    }

    @Override
    protected Account instantiate(Class<Account> clazz, Object object, InvocationContext.ConversionContext conversionContext) {
        if (object instanceof AccountLocator) {
            AccountLocator accountLocator = (AccountLocator)object;
            return this.accountService.load(accountLocator);
        }
        if (object instanceof AccountVO) {
            AccountVO accountVO = (AccountVO)object;
            if (accountVO.getId() != null) {
                return this.find(Account.class, accountVO.getId());
            }
            Account account = null;
            if (StringHelper.isNotBlank((Object)accountVO.getNumber())) {
                account = this.accountService.findByNumber(accountVO.getNumber());
            } else if (RequiredValidation.isValid((Object)accountVO.getType())) {
                AccountType accountType = (AccountType)this.conversionHandler.convert(AccountType.class, accountVO.getType());
                LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locateOrCurrent((AccountOwner)accountVO.getOwner(), true);
                account = this.accountService.load(locateAccountOwnerResult.getInternalAccountOwner(), accountType, true);
            }
            if (account == null) {
                throw new EntityNotFoundException(Account.class);
            }
            this.entityManagerHandler.checkAccess((IEntity)account);
            return account;
        }
        return super.instantiate(clazz, object, conversionContext);
    }
}

