/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalUnit;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.cyclos.archive.model.ArchivedAccountHistoryEntry;
import org.cyclos.archive.model.ArchivedAccountHistoryFilter;
import org.cyclos.archive.model.ArchivedTransfer;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountBalance;
import org.cyclos.entities.banking.AccountBalanceLimitLog;
import org.cyclos.entities.banking.AccountFee;
import org.cyclos.entities.banking.AccountFeeLog;
import org.cyclos.entities.banking.AccountLocator;
import org.cyclos.entities.banking.AccountPaymentAmountLimitLog;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.AmountReservation;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.CustomAmountReservation;
import org.cyclos.entities.banking.DirtyAccountBalance;
import org.cyclos.entities.banking.ExternalPayment;
import org.cyclos.entities.banking.ExternalPaymentAmountReservation;
import org.cyclos.entities.banking.GeneratedTransferType;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.banking.IAccount;
import org.cyclos.entities.banking.IUserAccount;
import org.cyclos.entities.banking.InitialCreditTransfer;
import org.cyclos.entities.banking.Installment;
import org.cyclos.entities.banking.InstallmentAmountReservation;
import org.cyclos.entities.banking.OrderAmountReservation;
import org.cyclos.entities.banking.PaymentTransfer;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.PendingAuthorizationAmountReservation;
import org.cyclos.entities.banking.PendingUserAccount;
import org.cyclos.entities.banking.QAccount;
import org.cyclos.entities.banking.QAccountBalance;
import org.cyclos.entities.banking.QAccountBalanceLimitLog;
import org.cyclos.entities.banking.QAccountPaymentAmountLimitLog;
import org.cyclos.entities.banking.QChargebackTransfer;
import org.cyclos.entities.banking.QClosedAccountBalance;
import org.cyclos.entities.banking.QDirtyAccountBalance;
import org.cyclos.entities.banking.QOrderAmountReservation;
import org.cyclos.entities.banking.QPendingAuthorizationAmountReservation;
import org.cyclos.entities.banking.QPendingUserAccount;
import org.cyclos.entities.banking.QSystemAccount;
import org.cyclos.entities.banking.QTransaction;
import org.cyclos.entities.banking.QTransfer;
import org.cyclos.entities.banking.QUserAccount;
import org.cyclos.entities.banking.QUserAccountVisibilitySettings;
import org.cyclos.entities.banking.ScheduledPayment;
import org.cyclos.entities.banking.ScheduledPaymentAmountReservation;
import org.cyclos.entities.banking.ScheduledPaymentInstallment;
import org.cyclos.entities.banking.SystemAccount;
import org.cyclos.entities.banking.SystemAccountType;
import org.cyclos.entities.banking.Ticket;
import org.cyclos.entities.banking.TicketAmountReservation;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.banking.TransferFee;
import org.cyclos.entities.banking.TransferFeeTransfer;
import org.cyclos.entities.banking.TransferFilter;
import org.cyclos.entities.banking.TransferStatusFlow;
import org.cyclos.entities.banking.TransferSummary;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.banking.Voucher;
import org.cyclos.entities.banking.VoucherAmountReservation;
import org.cyclos.entities.banking.VoucherChargeback;
import org.cyclos.entities.banking.VoucherConfiguration;
import org.cyclos.entities.banking.VoucherPack;
import org.cyclos.entities.banking.VoucherPackAmountReservation;
import org.cyclos.entities.banking.VoucherRedeem;
import org.cyclos.entities.banking.VoucherTopUp;
import org.cyclos.entities.banking.VoucherTransaction;
import org.cyclos.entities.banking.VoucherTransactionAmountReservation;
import org.cyclos.entities.banking.VoucherType;
import org.cyclos.entities.banking.VoucherUnblockAmountReservation;
import org.cyclos.entities.marketplace.Order;
import org.cyclos.entities.system.AccountNumberConfiguration;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.CustomScript;
import org.cyclos.entities.system.ExportFormat;
import org.cyclos.entities.system.LinkedEntityTypeMapping;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.MemberProduct;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.OperatorGroup;
import org.cyclos.entities.users.OperatorGroupAccountType;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.QProductTransferStatusFlow;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.entities.utils.DecimalRange;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.entities.utils.UserPrincipals;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.ArchiveHandler;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.AccessClientServiceLocal;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.access.PinServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AccountFeeLogServiceLocal;
import org.cyclos.impl.banking.AccountFeeServiceLocal;
import org.cyclos.impl.banking.AccountHistoryEntry;
import org.cyclos.impl.banking.AccountLockKey;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.AccountTypeServiceLocal;
import org.cyclos.impl.banking.BuildTransQueryParams;
import org.cyclos.impl.banking.BuildTransferQueryParams;
import org.cyclos.impl.banking.ChargebackDescriptionFiller;
import org.cyclos.impl.banking.ExternalPaymentServiceLocal;
import org.cyclos.impl.banking.GetTransferSummaryParameters;
import org.cyclos.impl.banking.LocateAccountOwnerResult;
import org.cyclos.impl.banking.NativeAccountStatus;
import org.cyclos.impl.banking.PaymentRequestServiceLocal;
import org.cyclos.impl.banking.RateHandler;
import org.cyclos.impl.banking.RatesData;
import org.cyclos.impl.banking.RecurringPaymentServiceLocal;
import org.cyclos.impl.banking.RestrictedOperatorAccessibleAccounts;
import org.cyclos.impl.banking.ScheduledPaymentServiceLocal;
import org.cyclos.impl.banking.TicketServiceLocal;
import org.cyclos.impl.banking.TransactionAuthorizationServiceLocal;
import org.cyclos.impl.banking.TransactionCustomFieldServiceLocal;
import org.cyclos.impl.banking.TransferFeeServiceLocal;
import org.cyclos.impl.banking.TransferQueryHandler;
import org.cyclos.impl.banking.TransferServiceLocal;
import org.cyclos.impl.banking.TransferStatusFlowServiceLocal;
import org.cyclos.impl.banking.VoucherServiceLocal;
import org.cyclos.impl.locks.LockHandler;
import org.cyclos.impl.locks.LockType;
import org.cyclos.impl.marketplace.AdDeliveryMethodServiceLocal;
import org.cyclos.impl.marketplace.AdServiceLocal;
import org.cyclos.impl.marketplace.OrderServiceLocal;
import org.cyclos.impl.messaging.AlertServiceLocal;
import org.cyclos.impl.search.TransferSearchHandler;
import org.cyclos.impl.search.UserSearchHandler;
import org.cyclos.impl.sql.AccountStatusUpdateParams;
import org.cyclos.impl.sql.AccountStatusUpdateResult;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.CustomScriptAccessor;
import org.cyclos.impl.system.CustomScriptServiceLocal;
import org.cyclos.impl.system.ExportFormatServiceLocal;
import org.cyclos.impl.users.AdminProductAccessor;
import org.cyclos.impl.users.MemberProductAccessor;
import org.cyclos.impl.users.OperatorServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.TransactionFeedbackServiceLocal;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.users.UserStatusServiceLocal;
import org.cyclos.impl.utils.BooleanPropertiesHolder;
import org.cyclos.impl.utils.PushNotificationEventContext;
import org.cyclos.impl.utils.PushNotificationHandler;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.conversion.ConversionHandlerInternal;
import org.cyclos.impl.utils.conversion.VOFiller;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.formatting.PredefinedPeriodDataValueFormatter;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.validation.Property;
import org.cyclos.impl.utils.validation.PropertyValidation;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BasePropertyValidation;
import org.cyclos.impl.utils.validation.validations.ValidationErrors;
import org.cyclos.model.Bean;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.EntityVO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.INamedEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.LockAcquisitionException;
import org.cyclos.model.NestedProperty;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.QueryParseException;
import org.cyclos.model.RetryException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.channels.ChannelVO;
import org.cyclos.model.access.clients.AccessClientDetailedVO;
import org.cyclos.model.access.clients.AccessClientStatus;
import org.cyclos.model.access.devices.CreateDeviceConfirmationParams;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.InsufficientBalanceException;
import org.cyclos.model.banking.TransSearchContext;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.accountfees.AccountFeeLogVO;
import org.cyclos.model.banking.accounts.AccountBalanceHistoryParams;
import org.cyclos.model.banking.accounts.AccountBalanceHistoryVO;
import org.cyclos.model.banking.accounts.AccountBalanceLimitDTO;
import org.cyclos.model.banking.accounts.AccountBalanceLimitLogVO;
import org.cyclos.model.banking.accounts.AccountBalanceLimitVO;
import org.cyclos.model.banking.accounts.AccountBalanceLimitsOverviewQuery;
import org.cyclos.model.banking.accounts.AccountHistoriesOverviewData;
import org.cyclos.model.banking.accounts.AccountHistoriesOverviewQuery;
import org.cyclos.model.banking.accounts.AccountHistoriesOverviewStatusVO;
import org.cyclos.model.banking.accounts.AccountHistoryData;
import org.cyclos.model.banking.accounts.AccountHistoryEntryVO;
import org.cyclos.model.banking.accounts.AccountHistoryOverviewEntryVO;
import org.cyclos.model.banking.accounts.AccountHistoryQuery;
import org.cyclos.model.banking.accounts.AccountHistoryStatusVO;
import org.cyclos.model.banking.accounts.AccountLimitsOverviewData;
import org.cyclos.model.banking.accounts.AccountLimitsOverviewQuery;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.AccountPaymentAmountLimitDTO;
import org.cyclos.model.banking.accounts.AccountPaymentAmountLimitLogVO;
import org.cyclos.model.banking.accounts.AccountPaymentAmountLimitVO;
import org.cyclos.model.banking.accounts.AccountPaymentAmountLimitsOverviewQuery;
import org.cyclos.model.banking.accounts.AccountPermissionsData;
import org.cyclos.model.banking.accounts.AccountStatusIndicator;
import org.cyclos.model.banking.accounts.AccountStatusVO;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.AccountWithCurrencyVO;
import org.cyclos.model.banking.accounts.AccountWithHistoryStatusVO;
import org.cyclos.model.banking.accounts.AccountWithStatusVO;
import org.cyclos.model.banking.accounts.ArchivedAccountHistoryData;
import org.cyclos.model.banking.accounts.ArchivedAccountHistoryEntryVO;
import org.cyclos.model.banking.accounts.ArchivedAccountHistoryQuery;
import org.cyclos.model.banking.accounts.ArchivedAccountHistoryVO;
import org.cyclos.model.banking.accounts.ArchivedTransferData;
import org.cyclos.model.banking.accounts.ArchivedTransferVO;
import org.cyclos.model.banking.accounts.BalanceEntryVO;
import org.cyclos.model.banking.accounts.BaseTransferQuery;
import org.cyclos.model.banking.accounts.ChangeAccountLimitsConfirmationField;
import org.cyclos.model.banking.accounts.DefaultAccountHistoryPeriod;
import org.cyclos.model.banking.accounts.ITransSearchData;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.accounts.TransferDirection;
import org.cyclos.model.banking.accounts.TransferSearchData;
import org.cyclos.model.banking.accounts.UserAccountBalanceLimitData;
import org.cyclos.model.banking.accounts.UserAccountPaymentAmountLimitData;
import org.cyclos.model.banking.accounts.UserWithBalanceOrderBy;
import org.cyclos.model.banking.accounts.UserWithBalanceQuery;
import org.cyclos.model.banking.accounts.UserWithBalanceSearchData;
import org.cyclos.model.banking.accounts.UserWithBalanceVO;
import org.cyclos.model.banking.accounts.UsersWithBalancesOverview;
import org.cyclos.model.banking.accounttypes.AccountTypeLimitType;
import org.cyclos.model.banking.accounttypes.AccountTypeNature;
import org.cyclos.model.banking.accounttypes.AccountTypeVO;
import org.cyclos.model.banking.accounttypes.AccountTypeWithCurrencyVO;
import org.cyclos.model.banking.accounttypes.AccountTypeWithDefaultYellowBalanceRangeVO;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.rates.HasRates;
import org.cyclos.model.banking.rates.RateVisibility;
import org.cyclos.model.banking.transactions.AbstractTransQuery;
import org.cyclos.model.banking.transactions.AbstractTransactionQuery;
import org.cyclos.model.banking.transactions.ITransactionSearchData;
import org.cyclos.model.banking.transactions.PaymentCreationType;
import org.cyclos.model.banking.transactions.PerformTransactionDTO;
import org.cyclos.model.banking.transactions.TransactionOrderBy;
import org.cyclos.model.banking.transferfees.TransferFeePhase;
import org.cyclos.model.banking.transferfees.TransferFeeVO;
import org.cyclos.model.banking.transferfilters.TransferFilterVO;
import org.cyclos.model.banking.transferfilters.TransferFilterWithAccountTypeVO;
import org.cyclos.model.banking.transfers.TransferNature;
import org.cyclos.model.banking.transferstatus.TransferStatusFlowWithStatusesVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.banking.vouchers.VoucherStatus;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.messaging.alerts.UserAlertType;
import org.cyclos.model.system.exportformats.ExportFormatContext;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.system.fields.CustomFieldType;
import org.cyclos.model.system.fields.CustomFieldValueVO;
import org.cyclos.model.system.fields.ICustomFieldValue;
import org.cyclos.model.system.fields.LinkedEntityType;
import org.cyclos.model.system.fields.LinkedEntityVO;
import org.cyclos.model.system.scripts.LoadValuesScriptFunction;
import org.cyclos.model.users.addresses.UserAddressResult;
import org.cyclos.model.users.operators.OperatorVO;
import org.cyclos.model.users.products.AccountAccessibility;
import org.cyclos.model.users.products.AccountProfileVisibility;
import org.cyclos.model.users.products.AccountVisibility;
import org.cyclos.model.users.users.AbstractUserSearchData;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.OperatorGroupAccountAccess;
import org.cyclos.model.users.users.UserAccountData;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.AmountSummaryVO;
import org.cyclos.model.utils.DatePeriodDTO;
import org.cyclos.model.utils.DecimalRangeDTO;
import org.cyclos.model.utils.FieldSelector;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.HasDisplay;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.PeriodPreselectorOptionData;
import org.cyclos.model.utils.PeriodPreselectorOptionType;
import org.cyclos.model.utils.PredefinedPeriodData;
import org.cyclos.model.utils.TimeField;
import org.cyclos.model.utils.TimeIntervalDTO;
import org.cyclos.security.banking.AccountServiceSecurity;
import org.cyclos.server.model.app.FrontendDashboardAccountVO;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.server.utils.CloseableIteratorAdapter;
import org.cyclos.server.utils.CloseableIteratorHelper;
import org.cyclos.server.utils.DataIterator;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.IDate;
import org.cyclos.utils.MaskHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.TranslationMessageSpecification;
import org.cyclos.utils.coercion.CoercionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.web.client.ResourceAccessException;

@Service
public class AccountServiceImpl
extends BaseServiceImpl
implements AccountServiceLocal {
    private static final String UPDATE_STATUSES_ATTR = "updateStatuses";
    private static final int MAX_NUMBER_ATTEMPTS = 10;
    private static final QClosedAccountBalance cb = QClosedAccountBalance.closedAccountBalance;
    private static final QAccountBalance ab = QAccountBalance.accountBalance;
    private static final QDirtyAccountBalance db = QDirtyAccountBalance.dirtyAccountBalance;
    private static final QAccount a = QAccount.account;
    private static final QPendingUserAccount p = QPendingUserAccount.pendingUserAccount;
    private static QTransfer t = QTransfer.transfer;
    private static final int[] LAST_MONTHS = new int[]{1, 3, 12};
    private static final int MONTHS_IN_PERIOD_PRESELECTOR = 3;
    private static final int YEARS_IN_PERIOD_PRESELECTOR = 3;
    private static final Comparator<UserAccount> ACCOUNT_TYPE_COMPARATOR = Comparator.comparing(UserAccount::getType);
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private TransactionAuthorizationServiceLocal transactionAuthorizationService;
    @Autowired
    private OperatorServiceLocal operatorService;
    @Autowired
    private TransferServiceLocal transferService;
    @Autowired
    private TransferFeeServiceLocal transferFeeService;
    @Autowired
    private AlertServiceLocal alertService;
    @Autowired
    private AdServiceLocal adService;
    @Autowired
    private AdDeliveryMethodServiceLocal deliveryMethodService;
    @Autowired
    private OrderServiceLocal orderService;
    @Autowired
    private NativeQueryHandler nativeQueryHandler;
    @Autowired
    private UserSearchHandler userSearchHandler;
    @Autowired
    private UserServiceLocal userService;
    @Autowired
    private UserStatusServiceLocal userStatusService;
    @Autowired
    private AccountFeeServiceLocal accountFeeService;
    @Autowired
    private AccountFeeLogServiceLocal accountFeeLogService;
    @Autowired
    private RateHandler rateHandler;
    @Autowired
    private TransferStatusFlowServiceLocal transferStatusFlowService;
    @Autowired
    private AccessClientServiceLocal accessClientService;
    @Autowired
    private ChannelServiceLocal channelService;
    @Autowired
    private CustomScriptServiceLocal customScriptService;
    @Autowired
    private TransactionFeedbackServiceLocal transactionFeedbackService;
    @Autowired
    private ScheduledPaymentServiceLocal scheduledPaymentService;
    @Autowired
    private TicketServiceLocal ticketService;
    @Autowired
    private RecurringPaymentServiceLocal recurringPaymentService;
    @Autowired
    private PaymentRequestServiceLocal paymentRequestService;
    @Autowired
    private ExternalPaymentServiceLocal externalPaymentService;
    @Autowired
    private PasswordHandler passwordHandler;
    @Autowired
    private TransactionCustomFieldServiceLocal transactionCustomFieldService;
    @Autowired
    private LockHandler lockHandler;
    @Autowired
    private PinServiceLocal pinService;
    @Autowired
    private ExportFormatServiceLocal exportFormatService;
    @Autowired
    private TransferQueryHandler transferQueryHandler;
    @Autowired
    private TransferSearchHandler transferSearchHandler;
    @Autowired
    private ConversionHandlerInternal conversionHandlerInternal;
    @Autowired
    private AccountTypeServiceLocal accountTypeService;
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private ArchiveHandler archiveHandler;
    @Autowired
    private AccountServiceSecurity accountServiceSecurity;
    @Autowired
    @Lazy
    private VoucherServiceLocal voucherService;
    @Autowired
    private PushNotificationHandler pushNotificationHandler;

    private static String allAccountsKey(User user) {
        return "userAccounts_" + user.getId();
    }

    private static String persistedAccountsKey(User user) {
        return "persistedAccounts_" + user.getId();
    }

    public boolean accountNumberExistsOrIsReserved(AccountNumberConfiguration accountNumberConfiguration, String string) {
        if (accountNumberConfiguration == null || !accountNumberConfiguration.isEnabled()) {
            return false;
        }
        QPendingUserAccount qPendingUserAccount = QPendingUserAccount.pendingUserAccount;
        boolean bl = ((DBQuery)this.from(new EntityPath[]{qPendingUserAccount}).where((Predicate)qPendingUserAccount.number.equalsIgnoreCase(string))).hasResults();
        if (bl) {
            return true;
        }
        boolean bl2 = this.doGetAccountByNumber(string) != null;
        return bl2;
    }

    public AccountServiceLocal.AdjustAccountsResult adjustAccounts(User user, boolean bl) {
        IUserAccount iUserAccount2;
        Object object4;
        MemberProductAccessor memberProductAccessor;
        UserAccountType userAccountType2;
        Object object2;
        AbstractCollection abstractCollection;
        AccountServiceLocal.AdjustAccountsResult adjustAccountsResult;
        boolean bl2 = POSSIBLE_STATUSES_TO_OWN_ACCOUNTS.contains(user.getStatus());
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor((BasicUser)user);
        List list = bl2 ? productsAccessor.member().getUserAccounts() : Collections.emptyList();
        AccountNumberConfiguration accountNumberConfiguration = this.configurationHandler.getAccessor((BasicUser)user).getAccountNumberConfiguration();
        boolean bl3 = accountNumberConfiguration != null && accountNumberConfiguration.isEnabled();
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        HashSet hashSet3 = new HashSet(list);
        Map<UserAccountType, IUserAccount> map = this.persistedAccounts(user);
        List list2 = CollectionHelper.filterByType(map.values().stream(), UserAccount.class).collect(Collectors.toList());
        if (!list2.isEmpty()) {
            adjustAccountsResult = list2.stream().map(UserAccount::getType).collect(Collectors.toSet());
            this.delete((EntityPath<?>)p).where(new Predicate[]{p.user().eq((Object)user), p.type().in((Collection)adjustAccountsResult)}).execute();
        }
        map.forEach((userAccountType, iUserAccount) -> {
            if (list.contains(userAccountType)) {
                hashSet3.remove(userAccountType);
                if (!iUserAccount.isActive()) {
                    hashSet2.add(userAccountType);
                }
            } else if (iUserAccount.isActive()) {
                hashSet.add(userAccountType);
            }
        });
        adjustAccountsResult = new AccountServiceLocal.AdjustAccountsResult();
        Set set = list.stream().map(AccountType::getCurrency).collect(Collectors.toSet());
        adjustAccountsResult.setCanceledOrders(this.orderService.cancelOrdersNotInCurrencies(user, set));
        adjustAccountsResult.setDisabledAds(this.adService.disableNotInCurrencies(user, set));
        adjustAccountsResult.setDisabledDeliveryMethods(this.deliveryMethodService.disableNotInCurrencies(user, set));
        boolean bl4 = CollectionHelper.isNotEmpty(hashSet);
        boolean bl5 = CollectionHelper.isNotEmpty(hashSet2);
        if (bl4 || bl5) {
            Object object3;
            abstractCollection = new HashSet();
            object2 = new HashSet();
            userAccountType2 = new HashSet();
            memberProductAccessor = new HashSet();
            if (bl4) {
                for (Object object4 : hashSet) {
                    iUserAccount2 = map.get(object4);
                    if (iUserAccount2 instanceof UserAccount) {
                        this.disposeAccount((UserAccount)iUserAccount2);
                        ((HashSet)object2).add(iUserAccount2.getId());
                        continue;
                    }
                    memberProductAccessor.add(iUserAccount2.getId());
                }
                object3 = hashSet.stream().map(AccountType::getCurrency).filter(currency -> !set.contains(currency)).collect(Collectors.toSet());
                adjustAccountsResult.setDisposedCurrencies(CollectionHelper.sort((Collection)object3));
                adjustAccountsResult.setDisposedAccounts(CollectionHelper.sort(hashSet));
            }
            if (bl5) {
                for (Object object4 : hashSet2) {
                    iUserAccount2 = map.get(object4);
                    if (iUserAccount2 instanceof UserAccount) {
                        ((HashSet)abstractCollection).add(iUserAccount2.getId());
                        continue;
                    }
                    userAccountType2.add(iUserAccount2.getId());
                }
                adjustAccountsResult.setActivatedAccounts(CollectionHelper.sort(hashSet2));
            }
            object3 = QUserAccount.userAccount;
            if (CollectionHelper.isNotEmpty(abstractCollection)) {
                this.update((EntityPath<?>)object3).where(new Predicate[]{((QUserAccount)object3).id.in(abstractCollection)}).set((Path)((QUserAccount)object3).active, (Object)true).execute();
            }
            if (CollectionHelper.isNotEmpty((Iterable)object2)) {
                this.update((EntityPath<?>)object3).where(new Predicate[]{((QUserAccount)object3).id.in((Collection)object2)}).set((Path)((QUserAccount)object3).active, (Object)false).execute();
            }
            object4 = QPendingUserAccount.pendingUserAccount;
            if (CollectionHelper.isNotEmpty((Iterable)userAccountType2)) {
                this.update((EntityPath<?>)object4).where(new Predicate[]{object4.id.in((Collection)userAccountType2)}).set((Path)object4.active, (Object)true).execute();
            }
            if (CollectionHelper.isNotEmpty((Iterable)memberProductAccessor)) {
                this.update((EntityPath<?>)object4).where(new Predicate[]{object4.id.in((Collection)memberProductAccessor)}).set((Path)object4.active, (Object)false).execute();
            }
        }
        abstractCollection = new ArrayList();
        if (CollectionHelper.isNotEmpty(hashSet3)) {
            object2 = hashSet3.iterator();
            while (object2.hasNext()) {
                boolean bl6;
                userAccountType2 = (UserAccountType)object2.next();
                memberProductAccessor = productsAccessor.member(userAccountType2);
                boolean bl7 = bl6 = bl && memberProductAccessor.getInitialCreditType() != null && BigDecimalHelper.isPositive((BigDecimal)memberProductAccessor.getInitialCredit());
                if (bl6) {
                    object4 = this.createAccount(user, userAccountType2, true);
                    if (object4.getNumber() == null) continue;
                    ((ArrayList)abstractCollection).add((String)object4.getNumber());
                    continue;
                }
                if (!bl3) {
                    object2.remove();
                    continue;
                }
                if (map.containsKey(userAccountType2) || !StringHelper.isNotBlank((Object)(object4 = this.generateNumber((AccountType)userAccountType2, (InternalAccountOwner)user)))) continue;
                iUserAccount2 = new PendingUserAccount(user, userAccountType2, (String)object4);
                this.persist((IEntity)iUserAccount2);
                ((ArrayList)abstractCollection).add(object4);
                map.put(userAccountType2, iUserAccount2);
            }
            adjustAccountsResult.setCreatedAccounts(CollectionHelper.sort(hashSet3));
        }
        if (bl3) {
            map.values().forEach(iUserAccount -> {
                if (StringHelper.isBlank((Object)iUserAccount.getNumber())) {
                    String string = this.generateNumber((AccountType)iUserAccount.getType(), (InternalAccountOwner)user);
                    this.updateNumber((IUserAccount)iUserAccount, string);
                    abstractCollection.add(string);
                }
            });
            adjustAccountsResult.setNewAccountNumbers(abstractCollection);
        }
        if (CollectionHelper.isNotEmpty((Iterable)adjustAccountsResult.getCreatedAccounts()) || CollectionHelper.isNotEmpty((Iterable)adjustAccountsResult.getNewAccountNumbers())) {
            this.userSearchHandler.index((NetworkedEntity)user);
        }
        return adjustAccountsResult;
    }

    public void applyQueryConstraints(AbstractTransQuery abstractTransQuery) {
        Serializable serializable;
        Date date;
        Date date2 = this.applicationHandler.getApplication().getArchivingDate();
        if (abstractTransQuery == null || date2 == null || abstractTransQuery instanceof AbstractTransactionQuery) {
            return;
        }
        DatePeriod datePeriod = (DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)abstractTransQuery.getPeriod());
        Date date3 = date = datePeriod == null ? null : datePeriod.getBegin();
        if (date != null) {
            serializable = this.getSessionData().getConfiguration().getTimeZone().toZoneId();
            LocalDate localDate = LocalDate.ofInstant(date.toInstant(), (ZoneId)serializable);
            LocalDate localDate2 = LocalDate.ofInstant(date2.toInstant(), (ZoneId)serializable);
            if (localDate2.equals(localDate)) {
                date = date2;
            }
        }
        serializable = datePeriod == null ? null : datePeriod.getEnd();
        this.checkInRetentionWindow(date);
        this.checkInRetentionWindow((Date)serializable);
        if (date == null) {
            if (abstractTransQuery.getPeriod() == null) {
                abstractTransQuery.setPeriod((DatePeriodDTO)this.conversionHandler.convert(DatePeriodDTO.class, (Object)DatePeriod.begginingAt((Date)date2)));
            } else {
                abstractTransQuery.getPeriod().setBegin(this.conversionHandler.toDateTime(date2));
            }
        } else if (!date.equals(datePeriod.getBegin())) {
            abstractTransQuery.getPeriod().setBegin(this.conversionHandler.toDateTime(date));
        }
    }

    public void checkActive(Account account) throws IllegalActionException {
        if (!this.isActive((IAccount)account)) {
            throw new IllegalActionException();
        }
    }

    public void checkActive(AccountOwner accountOwner) throws IllegalActionException {
        UserStatus userStatus;
        if (accountOwner instanceof User && !POSSIBLE_STATUSES_TO_OWN_ACCOUNTS.contains(userStatus = ((User)accountOwner).getStatus())) {
            throw new IllegalActionException();
        }
    }

    public void checkAvailableBalance(Account account, BigDecimal bigDecimal) throws InsufficientBalanceException, LockAcquisitionException {
        this.doCheckAvailableBalance(account, bigDecimal, false);
    }

    public SystemAccount createSystemAccount(SystemAccountType systemAccountType) {
        SystemAccount systemAccount = new SystemAccount();
        systemAccount.setCreationDate(DateHelper.now());
        systemAccount.setType((AccountType)systemAccountType);
        systemAccount.setNumber(this.generateNumber((AccountType)systemAccountType, (InternalAccountOwner)SystemAccountOwner.instance()));
        if (systemAccountType.getLimitType() == AccountTypeLimitType.LIMITED) {
            systemAccount.setCreditLimit(systemAccountType.getCreditLimit());
            systemAccount.setUpperCreditLimit(systemAccountType.getUpperCreditLimit());
        }
        this.persist((IEntity)systemAccount);
        systemAccountType.setAccount(systemAccount);
        return systemAccount;
    }

    public ExternalPaymentAmountReservation dereserveAmount(ExternalPayment externalPayment) {
        ExternalPaymentAmountReservation externalPaymentAmountReservation = externalPayment.getAmountReservation();
        if (externalPaymentAmountReservation == null) {
            throw new IllegalActionException("The given external payment has no amount reservation: " + String.valueOf(externalPayment));
        }
        if (externalPayment.getAmountDereservation() != null) {
            throw new IllegalActionException("The amount reserved by the given external payment was already dereserved: " + String.valueOf(externalPayment));
        }
        ExternalPaymentAmountReservation externalPaymentAmountReservation2 = new ExternalPaymentAmountReservation();
        externalPaymentAmountReservation2.setExternalPayment(externalPayment);
        this.fill((AmountReservation)externalPaymentAmountReservation2, externalPaymentAmountReservation.getAccount(), externalPaymentAmountReservation.getAmount().negate());
        this.persist((IEntity)externalPaymentAmountReservation2);
        externalPayment.getAmountReservations().add(externalPaymentAmountReservation2);
        return externalPaymentAmountReservation2;
    }

    public OrderAmountReservation dereserveAmount(Order order) {
        OrderAmountReservation orderAmountReservation = this.getAmountReservation(order);
        if (orderAmountReservation == null) {
            throw new IllegalActionException("The given order has no amount reservation: " + String.valueOf(order));
        }
        if (this.getAmountDereservation(order) != null) {
            throw new IllegalActionException("The amount reserved by the given order was already dereserved: " + String.valueOf(order));
        }
        OrderAmountReservation orderAmountReservation2 = new OrderAmountReservation();
        orderAmountReservation2.setOrder(order);
        this.fill((AmountReservation)orderAmountReservation2, orderAmountReservation.getAccount(), orderAmountReservation.getAmount().negate());
        this.persist((IEntity)orderAmountReservation2);
        return orderAmountReservation2;
    }

    public InstallmentAmountReservation dereserveAmount(ScheduledPaymentInstallment scheduledPaymentInstallment) throws FrameworkException, IllegalActionException {
        if (scheduledPaymentInstallment.getAmountDereservation() != null) {
            throw new IllegalActionException("The given scheduled payment already reserved its amount");
        }
        InstallmentAmountReservation installmentAmountReservation = new InstallmentAmountReservation();
        ScheduledPayment scheduledPayment = scheduledPaymentInstallment.getScheduledPayment();
        this.fill((AmountReservation)installmentAmountReservation, scheduledPayment.getFrom(), scheduledPaymentInstallment.getAmount().negate());
        installmentAmountReservation.setInstallment((Installment)scheduledPaymentInstallment);
        this.persist((IEntity)installmentAmountReservation);
        scheduledPaymentInstallment.setAmountDereservation(installmentAmountReservation);
        return installmentAmountReservation;
    }

    public TicketAmountReservation dereserveAmount(Ticket ticket) {
        PaymentTransferType paymentTransferType = (PaymentTransferType)ticket.getType();
        if (!paymentTransferType.isReserveApprovedTicketAmount() || ticket.getAmountReservations().isEmpty()) {
            return null;
        }
        if (ticket.getAmountReservations().size() != 1) {
            throw new IllegalActionException("The given ticket amount was already dereserved");
        }
        TicketAmountReservation ticketAmountReservation = new TicketAmountReservation();
        this.fill((AmountReservation)ticketAmountReservation, ticket.getFrom(), ticket.getAmount().negate());
        ticketAmountReservation.setTicket(ticket);
        this.persist((IEntity)ticketAmountReservation);
        return ticketAmountReservation;
    }

    public PendingAuthorizationAmountReservation dereserveAmountForAuthorization(BasePayment basePayment) throws FrameworkException {
        if (!basePayment.isPendingAuthorization()) {
            throw new IllegalActionException("The given transaction is not pending authorization");
        }
        if (this.getAmountDereservationForAuthorization(basePayment) != null) {
            throw new IllegalActionException("The given transaction already dereserved it's amount");
        }
        PendingAuthorizationAmountReservation pendingAuthorizationAmountReservation = this.getAmountReservationForAuthorization(basePayment);
        if (pendingAuthorizationAmountReservation == null) {
            throw new IllegalActionException("There was no amount reserved for this transaction");
        }
        PendingAuthorizationAmountReservation pendingAuthorizationAmountReservation2 = new PendingAuthorizationAmountReservation();
        this.fill((AmountReservation)pendingAuthorizationAmountReservation2, basePayment.getFrom(), pendingAuthorizationAmountReservation.getAmount().negate());
        pendingAuthorizationAmountReservation2.setTransaction(basePayment);
        this.persist((IEntity)pendingAuthorizationAmountReservation2);
        return pendingAuthorizationAmountReservation2;
    }

    public VoucherAmountReservation dereserveAmountIfNeeded(Voucher voucher) throws FrameworkException, InsufficientBalanceException {
        VoucherPackAmountReservation voucherPackAmountReservation = voucher.getPack().getAmountReservation();
        if (voucherPackAmountReservation == null) {
            return null;
        }
        BigDecimal bigDecimal = voucher.getAmountDereservations().stream().map(AmountReservation::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (!BigDecimalHelper.isZero((BigDecimal)bigDecimal)) {
            throw new IllegalActionException("The given voucher already dereserved its amount");
        }
        VoucherAmountReservation voucherAmountReservation = new VoucherAmountReservation();
        this.fill((AmountReservation)voucherAmountReservation, voucherPackAmountReservation.getAccount(), voucher.getBalance().negate());
        voucherAmountReservation.setVoucher(voucher);
        this.persist((IEntity)voucherAmountReservation);
        voucher.getAmountDereservations().add(voucherAmountReservation);
        return voucherAmountReservation;
    }

    public FileInfo exportAccountBalanceLimitsOverview(@NotNull ExportFormatVO exportFormatVO, @NotNull AccountBalanceLimitsOverviewQuery accountBalanceLimitsOverviewQuery) throws FrameworkException {
        ExportFormat exportFormat = (ExportFormat)this.conversionHandler.convert(ExportFormat.class, (Object)exportFormatVO);
        QUserAccount qUserAccount = QUserAccount.userAccount;
        DBQuery<UserAccount> dBQuery = this.createAccountBalanceLimitsQuery(accountBalanceLimitsOverviewQuery, qUserAccount);
        DataIterator dataIterator = CloseableIteratorHelper.asDataIterator((CloseableIterator)(dBQuery == null ? CloseableIteratorHelper.empty() : dBQuery.export((Expression)qUserAccount)));
        return this.exportFormatService.exportMultiple(exportFormat, ExportFormatContext.BALANCE_LIMITS_OVERVIEW, (QueryParameters)accountBalanceLimitsOverviewQuery, dataIterator);
    }

    public FileInfo exportAccountHistoriesOverview(@NotNull ExportFormatVO exportFormatVO, @NotNull AccountHistoriesOverviewQuery accountHistoriesOverviewQuery) throws FrameworkException {
        ExportFormat exportFormat = (ExportFormat)this.conversionHandler.convert(ExportFormat.class, (Object)exportFormatVO);
        DataIterator dataIterator = this.transferSearchHandler.exportEntities((QueryParameters)accountHistoriesOverviewQuery);
        return this.exportFormatService.exportMultiple(exportFormat, ExportFormatContext.TRANSFERS_OVERVIEW, (QueryParameters)accountHistoriesOverviewQuery, dataIterator, null);
    }

    public FileInfo exportAccountHistory(@NotNull ExportFormatVO exportFormatVO, @NotNull AccountHistoryQuery accountHistoryQuery) throws FrameworkException {
        this.checkAccountHistoryQuery(accountHistoryQuery);
        ExportFormat exportFormat = (ExportFormat)this.conversionHandler.convert(ExportFormat.class, (Object)exportFormatVO);
        DataIterator dataIterator = this.transferSearchHandler.exportAccountHistory(accountHistoryQuery);
        return this.exportFormatService.exportMultiple(exportFormat, ExportFormatContext.ACCOUNT_HISTORY, (QueryParameters)accountHistoryQuery, dataIterator);
    }

    public FileInfo exportAccountPaymentAmountLimitsOverview(@NotNull ExportFormatVO exportFormatVO, @NotNull AccountPaymentAmountLimitsOverviewQuery accountPaymentAmountLimitsOverviewQuery) throws FrameworkException {
        ExportFormat exportFormat = (ExportFormat)this.conversionHandler.convert(ExportFormat.class, (Object)exportFormatVO);
        QUserAccount qUserAccount = QUserAccount.userAccount;
        DBQuery<UserAccount> dBQuery = this.createAccountPaymentAmountLimitsQuery(accountPaymentAmountLimitsOverviewQuery, qUserAccount);
        DataIterator dataIterator = CloseableIteratorHelper.asDataIterator((CloseableIterator)(dBQuery == null ? CloseableIteratorHelper.empty() : dBQuery.export((Expression)qUserAccount)));
        return this.exportFormatService.exportMultiple(exportFormat, ExportFormatContext.PAYMENT_AMOUNT_LIMITS_OVERVIEW, (QueryParameters)accountPaymentAmountLimitsOverviewQuery, dataIterator);
    }

    public FileInfo exportArchivedAccountHistory(@NotNull ExportFormatVO exportFormatVO, @NotNull ArchivedAccountHistoryQuery archivedAccountHistoryQuery) throws FrameworkException {
        QueryHelper.applyExport((QueryParameters)archivedAccountHistoryQuery);
        ExportFormat exportFormat = (ExportFormat)this.conversionHandler.convert(ExportFormat.class, (Object)exportFormatVO);
        ArchivedAccountHistoryVO archivedAccountHistoryVO = this.searchArchivedAccountHistory(archivedAccountHistoryQuery);
        HashMap<String, ArchivedAccountHistoryVO> hashMap = new HashMap<String, ArchivedAccountHistoryVO>();
        hashMap.put("archivedAccountHistory", archivedAccountHistoryVO);
        DataIterator dataIterator = CloseableIteratorHelper.asDataIterator((CloseableIterator)new CloseableIteratorAdapter(archivedAccountHistoryVO.getEntries().iterator()));
        return this.exportFormatService.exportMultiple(exportFormat, ExportFormatContext.ARCHIVED_ACCOUNT_HISTORY, (QueryParameters)archivedAccountHistoryQuery, dataIterator, hashMap);
    }

    public FileInfo exportArchivedTransfer(@NotNull ExportFormatVO exportFormatVO, @NotNull Long l) throws FrameworkException {
        ExportFormat exportFormat = (ExportFormat)this.conversionHandler.convert(ExportFormat.class, (Object)exportFormatVO);
        ArchivedTransferVO archivedTransferVO = this.loadArchivedTransfer(l);
        return this.exportFormatService.exportSingle(exportFormat, ExportFormatContext.ARCHIVED_TRANSFER, (Object)archivedTransferVO);
    }

    public FileInfo exportUsersWithBalances(@NotNull ExportFormatVO exportFormatVO, @NotNull UserWithBalanceQuery userWithBalanceQuery) throws FrameworkException {
        userWithBalanceQuery.setIgnoreProfileFieldsInList(false);
        userWithBalanceQuery.setAttribute("export", (Object)true);
        ExportFormat exportFormat = (ExportFormat)this.conversionHandler.convert(ExportFormat.class, (Object)exportFormatVO);
        DataIterator dataIterator = this.userSearchHandler.exportWithBalances(userWithBalanceQuery);
        HashMap<String, List> hashMap = new HashMap<String, List>();
        hashMap.put("profileFields", this.profileFieldHandler.getProfileFieldsForExport());
        return this.exportFormatService.exportMultiple(exportFormat, ExportFormatContext.USERS_WITH_BALANCES, (QueryParameters)userWithBalanceQuery, dataIterator, hashMap);
    }

    public void fillTransSearchData(ITransSearchData iTransSearchData, Account account, InternalAccountOwner internalAccountOwner, ExportFormatContext exportFormatContext, TransSearchContext transSearchContext) {
        Object object;
        Object object2;
        iTransSearchData.setArchivingDate(this.conversionHandler.toDateTime(this.applicationHandler.getApplication().getArchivingDate()));
        iTransSearchData.setPreselectedPeriods(this.resolvePreselectedPeriods(!(iTransSearchData instanceof ITransactionSearchData)));
        if (internalAccountOwner == null && account != null) {
            internalAccountOwner = account.getOwner();
        }
        SessionData sessionData = this.getSessionData();
        if (internalAccountOwner == null && sessionData.isMember() && !sessionData.hasPermission(Permission.USER_ACCOUNTS_VIEW)) {
            internalAccountOwner = sessionData.getLoggedUser();
        }
        if (sessionData.isAdmin() || sessionData.isSystem()) {
            iTransSearchData.setManagedGroups(this.groupsHandler.visibles().accessibles().basicUsers().sorted());
            iTransSearchData.setChannels(this.channelService.list());
        }
        if (exportFormatContext != null) {
            iTransSearchData.setExportFormats(this.conversionHandler.convertList(ExportFormatVO.class, (Iterable)this.exportFormatService.listByContext(exportFormatContext)));
        }
        ProductsAccessor productsAccessor = sessionData.getProducts();
        if (account == null) {
            object2 = CollectionHelper.orEmpty(internalAccountOwner == null ? productsAccessor.grantedAccountTypes() : this.listVisibleTypes(internalAccountOwner));
            iTransSearchData.setAccountTypes(this.conversionHandler.convertList(AccountTypeWithCurrencyVO.class, (Iterable)object2));
            object = new HashSet();
            if (internalAccountOwner == null || internalAccountOwner instanceof SystemAccountOwner) {
                object.addAll(productsAccessor.admin().getSystemTransferFilters());
            }
            if (internalAccountOwner == null || internalAccountOwner.equals((Object)sessionData.getLoggedUser())) {
                object.addAll(productsAccessor.member().getMyTransferFilters());
            }
            if (internalAccountOwner == null || internalAccountOwner instanceof User && sessionData.isManagerOf((BasicUser)((User)internalAccountOwner))) {
                object.addAll(productsAccessor.userManagement().getUserTransferFilters());
            }
            Comparator<TransferFilter> comparator = Comparator.comparing(TransferFilter::getAccountType).thenComparing(NamedEntity::getName);
            iTransSearchData.setTransferFilters(new ArrayList());
            object.stream().filter(arg_0 -> AccountServiceImpl.lambda$fillTransSearchData$3((List)object2, arg_0)).sorted(comparator).map(this.conversionHandler.convertingFunction(TransferFilterWithAccountTypeVO.class, new Object[0])).forEach(iTransSearchData.getTransferFilters()::add);
        } else {
            if (account instanceof UserAccount) {
                object2 = (UserAccount)account;
                object = object2.getUser();
                iTransSearchData.setAccessClients(this.conversionHandler.convertList(AccessClientDetailedVO.class, (Iterable)this.accessClientService.listVisible((User)object, new AccessClientStatus[0])));
            }
            if (account instanceof SystemAccount) {
                object2 = this.filterTransferFiltersForAccount(account, productsAccessor.admin().getSystemTransferFilters());
            } else if (account.getOwner().equals((Object)sessionData.getLoggedUser())) {
                object = (UserAccount)account;
                object2 = this.filterTransferFiltersForAccount(account, this.productsHandler.getAccessor((BasicUser)object.getUser()).member().getMyTransferFilters());
            } else if (sessionData.manages((BasicUser)((User)account.getOwner()))) {
                object2 = this.filterTransferFiltersForAccount(account, productsAccessor.userManagement().getUserTransferFilters());
            } else {
                throw new IllegalArgumentException();
            }
            iTransSearchData.setTransferFilters(this.conversionHandler.convertList(TransferFilterVO.class, (Iterable)object2));
        }
        if (internalAccountOwner instanceof User && this.productsHandler.getAccessor((BasicUser)(object2 = (User)internalAccountOwner)).member().hasPermission(Permission.MY_OPERATORS_ENABLE) && this.permission((BasicUser)object2).my(new Permission[]{Permission.MY_OPERATORS_ENABLE}).user(new Permission[]{Permission.USER_OPERATORS_VIEW}).granted()) {
            iTransSearchData.setOperators(this.conversionHandler.convertList(OperatorVO.class, (Iterable)this.operatorService.list((User)object2)));
        }
        if (iTransSearchData instanceof TransferSearchData) {
            object2 = (TransferSearchData)iTransSearchData;
            object = this.getVisibleFlows(account);
            object2.setTransferStatusFlows(this.conversionHandler.convertList(TransferStatusFlowWithStatusesVO.class, (Iterable)object));
        }
        if (transSearchContext != null) {
            object2 = this.transactionCustomFieldService.listVisible((AccountOwner)internalAccountOwner);
            iTransSearchData.setFieldsForList(this.conversionHandler.convertList(CustomFieldDetailedVO.class, (Iterable)object2.stream().filter(transactionCustomField -> transactionCustomField.getContextsToShowInList().contains(transSearchContext)).collect(Collectors.toList())));
            iTransSearchData.setFieldsForSearch(this.conversionHandler.convertList(CustomFieldDetailedVO.class, (Iterable)object2.stream().filter(transactionCustomField -> transactionCustomField.getContextsToShowInSearch().contains(transSearchContext)).collect(Collectors.toList())));
        }
    }

    public Account findByNumber(String string) throws FrameworkException {
        Account account;
        AccountNumberConfiguration accountNumberConfiguration = this.getConfiguration().getAccountNumberConfiguration();
        if (accountNumberConfiguration == null || !accountNumberConfiguration.isEnabled()) {
            return null;
        }
        String string2 = accountNumberConfiguration.getMask();
        if (StringHelper.isNotBlank((Object)string2)) {
            string = MaskHelper.removeMask((String)string2, (String)string);
        }
        if ((account = this.doGetAccountByNumber(string)) == null) {
            throw new EntityNotFoundException(Account.class);
        }
        return account;
    }

    public String generateNumber(AccountType accountType, InternalAccountOwner internalAccountOwner) throws FrameworkException {
        String string;
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(accountType.getNetwork());
        AccountNumberConfiguration accountNumberConfiguration = configurationAccessor.getAccountNumberConfiguration();
        if (accountNumberConfiguration == null || !accountNumberConfiguration.isEnabled()) {
            return null;
        }
        int n = 0;
        do {
            string = this.doGenerateNumber(accountNumberConfiguration, accountType, internalAccountOwner);
            if (++n < 50) continue;
            throw new RetryException("Couldn't generate an unique account number");
        } while (this.accountNumberExistsOrIsReserved(accountNumberConfiguration, string));
        return string;
    }

    public AccountBalanceHistoryVO getAccountBalanceHistory(@NotNull AccountBalanceHistoryParams accountBalanceHistoryParams) throws FrameworkException {
        TimeField timeField;
        int n;
        Date date;
        Date date2;
        Account account = (Account)this.conversionHandler.convert(Account.class, (Object)accountBalanceHistoryParams.getAccount());
        if (account == null) {
            throw new EntityNotFoundException(Account.class);
        }
        Date date3 = new Date();
        DatePeriod datePeriod = (DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)accountBalanceHistoryParams.getPeriod());
        TimeZone timeZone = this.getSessionData().getConfiguration().getTimeZone();
        TimeIntervalDTO timeIntervalDTO = ModelHelper.isValid((TimeIntervalDTO)accountBalanceHistoryParams.getInterval()) ? accountBalanceHistoryParams.getInterval() : null;
        Date date4 = date2 = datePeriod == null ? null : datePeriod.getBegin();
        if (date2 == null) {
            if (timeIntervalDTO == null) {
                timeIntervalDTO = ModelHelper.timeInterval((int)1, (TimeField)TimeField.MONTHS);
            }
            date2 = (Date)DateHelper.periodIncluding((ITimeInterval)timeIntervalDTO, (TimeZone)timeZone, (Date)new Date()).getFirst();
            date2 = DateHelper.subtract((Date)date2, (ITimeInterval)new TimeInterval(Integer.valueOf(timeIntervalDTO.getAmount() * 4), timeIntervalDTO.getField()));
        }
        date2 = DateHelper.shiftToBegin((Date)date2, (TimeZone)timeZone);
        Date date5 = date = datePeriod == null ? null : datePeriod.getEnd();
        if (date == null || date.after(date3)) {
            date = date3;
        }
        if ((date = DateHelper.shiftToEnd((Date)date, (TimeZone)timeZone)).before(date2)) {
            throw new ValidationException();
        }
        if (!ModelHelper.isValid((TimeIntervalDTO)timeIntervalDTO)) {
            double d = DateHelper.daysBetween((Date)date2, (Date)date);
            timeIntervalDTO = d > 180.0 ? ModelHelper.timeInterval((int)1, (TimeField)TimeField.MONTHS) : (d > 61.0 ? ModelHelper.timeInterval((int)1, (TimeField)TimeField.WEEKS) : (d > 2.0 ? ModelHelper.timeInterval((int)1, (TimeField)TimeField.DAYS) : ModelHelper.timeInterval((int)1, (TimeField)TimeField.HOURS)));
        }
        if ((n = (timeField = timeIntervalDTO.getField()).compareTo((Enum)TimeField.HOURS)) < 0) {
            throw new ValidationException("intervalUnit", this.getFormatter().format(new TranslationMessageSpecification(GeneralKeys.Errors.GREATER_THAN, new Object[]{BankingKeys.Accounts.INTERVAL_UNIT, TimeField.HOURS})));
        }
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date2);
        int n2 = DateHelper.getCalendarField((TimeField)timeField);
        if (n2 == 3) {
            n2 = 5;
        }
        date2 = DateUtils.truncate((Calendar)calendar, (int)n2).getTime();
        if (n > 0) {
            date2 = DateHelper.shiftToBegin((Date)date2, (TimeZone)timeZone);
        }
        ArrayList<Date> arrayList = new ArrayList<Date>(61);
        ZoneId zoneId = timeZone.toZoneId();
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(date2.toInstant(), zoneId);
        ZonedDateTime zonedDateTime2 = ZonedDateTime.ofInstant(date.toInstant(), zoneId);
        TemporalUnit temporalUnit = DateHelper.getTemporalUnit((TimeField)timeField);
        int n3 = (Integer)ObjectHelper.defaultValue((Object)timeIntervalDTO.getAmount(), (Object)1);
        while (zonedDateTime.isBefore(zonedDateTime2)) {
            arrayList.add(Date.from(zonedDateTime.toInstant()));
            if (arrayList.size() > 61) {
                String string = this.message(BankingKeys.Accounts.MAXIMUM_BALANCE_DATAPOINTS, date2, date, timeIntervalDTO, 61);
                throw new ValidationException(string);
            }
            zonedDateTime = zonedDateTime.plus(n3, temporalUnit);
        }
        if (zonedDateTime.isBefore(ZonedDateTime.now())) {
            arrayList.add(Date.from(zonedDateTime.toInstant()));
        }
        AccountHistoryQuery accountHistoryQuery = new AccountHistoryQuery();
        accountHistoryQuery.setAccount(account.toVORef());
        accountHistoryQuery.setPeriod((DatePeriodDTO)this.conversionHandler.convert(DatePeriodDTO.class, (Object)datePeriod));
        AccountBalanceHistoryVO accountBalanceHistoryVO = new AccountBalanceHistoryVO();
        accountBalanceHistoryVO.setAccount((AccountWithCurrencyVO)this.conversionHandler.convert(AccountWithCurrencyVO.class, (Object)account));
        accountBalanceHistoryVO.setInterval(timeIntervalDTO);
        accountBalanceHistoryVO.setBalances(this.doGetAccountBalanceHistory(account, arrayList));
        accountBalanceHistoryVO.setStatus(this.getAccountHistoryStatus(account, accountHistoryQuery));
        return accountBalanceHistoryVO;
    }

    public AccountLimitsOverviewData getAccountBalanceLimitsOverviewData() {
        return this.getAccountLimitsOverviewData(ExportFormatContext.BALANCE_LIMITS_OVERVIEW);
    }

    public AccountHistoriesOverviewData getAccountHistoriesOverviewData() {
        AccountHistoriesOverviewData accountHistoriesOverviewData = new AccountHistoriesOverviewData();
        this.fillTransSearchData((ITransSearchData)accountHistoriesOverviewData, null, null, ExportFormatContext.TRANSFERS_OVERVIEW, TransSearchContext.TRANSFERS_OVERVIEW);
        AccountHistoriesOverviewQuery accountHistoriesOverviewQuery = this.newQuery(AccountHistoriesOverviewQuery.class, accountHistoriesOverviewData.getFieldsForSearch());
        for (PeriodPreselectorOptionData periodPreselectorOptionData : accountHistoriesOverviewData.getPreselectedPeriods()) {
            if (!periodPreselectorOptionData.isDefaultOption()) continue;
            accountHistoriesOverviewQuery.setPeriod(periodPreselectorOptionData.getPeriod());
            break;
        }
        accountHistoriesOverviewQuery.setOrderBy(TransactionOrderBy.DATE_DESC);
        accountHistoriesOverviewData.setQuery((QueryParameters)accountHistoriesOverviewQuery);
        accountHistoriesOverviewData.setImmediatelyFetchOverview(!this.getConfiguration().isSkipTotalCount());
        return accountHistoriesOverviewData;
    }

    public AccountHistoriesOverviewStatusVO getAccountHistoriesOverviewStatus(AccountHistoriesOverviewQuery accountHistoriesOverviewQuery) {
        this.applyQueryConstraints((AbstractTransQuery)accountHistoriesOverviewQuery);
        return this.transferSearchHandler.getStatus(accountHistoriesOverviewQuery);
    }

    public AccountHistoryData getAccountHistoryData(AccountVO accountVO, RateVisibility rateVisibility) {
        Object object;
        OperatorGroupAccountAccess operatorGroupAccountAccess;
        Account account = (Account)this.conversionHandler.convert(Account.class, (Object)accountVO);
        AccountType accountType = account.getType();
        AccountHistoryData accountHistoryData = new AccountHistoryData();
        this.fillTransSearchData((ITransSearchData)accountHistoryData, account, null, ExportFormatContext.ACCOUNT_HISTORY, null);
        accountHistoryData.setCurrency((CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)accountType.getCurrency()));
        accountHistoryData.setAccount((AccountVO)this.conversionHandler.convert(AccountVO.class, (Object)account));
        accountHistoryData.setTransactionNumberMask(accountType.getCurrency().getTransactionNumberPattern());
        accountHistoryData.setShowDescriptionInFilters(accountType.isShowDescriptionInHistoryFilters());
        accountHistoryData.setShowDescriptionInList(accountType.isShowDescriptionInHistoryList());
        accountHistoryData.setCanSearchArchive(account.getArchivingDate() != null);
        List list = this.transactionCustomFieldService.listVisible((AccountOwner)account.getOwner());
        if (!list.isEmpty()) {
            operatorGroupAccountAccess = new ArrayList(list);
            operatorGroupAccountAccess.retainAll(accountType.getCustomFieldsForSearch());
            accountHistoryData.setFieldsForSearch(this.conversionHandler.convertList(CustomFieldDetailedVO.class, (Iterable)operatorGroupAccountAccess));
            object = Collections.singletonMap("account", account);
            this.customFieldValueHandler.fillValuesFromScript(TransactionCustomField.class, LoadValuesScriptFunction.FILTER, (Map)object, (Collection)accountHistoryData.getFieldsForSearch());
            ArrayList arrayList = new ArrayList(list);
            arrayList.retainAll(accountType.getCustomFieldsForList());
            accountHistoryData.setFieldsForList(this.conversionHandler.convertList(CustomFieldDetailedVO.class, (Iterable)arrayList));
        }
        accountHistoryData.setCanFilterByDirection((operatorGroupAccountAccess = this.operatorService.accountAccess(account)) == null || operatorGroupAccountAccess != OperatorGroupAccountAccess.INCOMING_PAYMENTS && operatorGroupAccountAccess != OperatorGroupAccountAccess.OUTGOING_PAYMENTS);
        object = this.newQuery(AccountHistoryQuery.class, accountHistoryData.getFieldsForSearch());
        object.setOrderBy(TransactionOrderBy.DATE_DESC);
        object.setAccount(accountHistoryData.getAccount());
        for (PeriodPreselectorOptionData periodPreselectorOptionData : accountHistoryData.getPreselectedPeriods()) {
            if (!periodPreselectorOptionData.isDefaultOption()) continue;
            object.setPeriod(periodPreselectorOptionData.getPeriod());
            break;
        }
        accountHistoryData.setQuery((QueryParameters)object);
        return accountHistoryData;
    }

    public AccountHistoryStatusVO getAccountHistoryStatus(Account account, AccountHistoryQuery accountHistoryQuery) {
        if (account == null) {
            throw new IllegalArgumentException("Account is required for the query");
        }
        this.applyQueryConstraints((AbstractTransQuery)accountHistoryQuery);
        AccountHistoryStatusVO accountHistoryStatusVO = this.doGetAccountStatus(AccountHistoryStatusVO.class, account, null, RateVisibility.PARAM_NO_UNLIMITED, true, null);
        if (accountHistoryStatusVO != null) {
            Object object;
            Date date;
            Set set = CollectionHelper.orEmpty((Set)this.getConfiguration().getAccountStatusIndicators());
            DatePeriodDTO datePeriodDTO = accountHistoryQuery.getPeriod();
            Date date2 = datePeriodDTO == null ? null : this.conversionHandler.toDate((IDate)datePeriodDTO.getBegin());
            Date date3 = date = datePeriodDTO == null ? null : this.conversionHandler.toDate((IDate)datePeriodDTO.getEnd());
            if (date2 != null) {
                accountHistoryStatusVO.setBeginDate(this.conversionHandler.toDateTime(date2));
                if (set.contains(AccountStatusIndicator.BALANCE_AT_BEGIN)) {
                    accountHistoryStatusVO.setBalanceAtBegin(this.getBalance(account, date2));
                }
            }
            if (date != null) {
                accountHistoryStatusVO.setEndDate(this.conversionHandler.toDateTime(date));
                if (set.contains(AccountStatusIndicator.BALANCE_AT_END)) {
                    object = new Date(date.getTime() + 1L);
                    accountHistoryStatusVO.setBalanceAtEnd(this.getBalance(account, (Date)object));
                }
            }
            if (date2 != null && date != null) {
                object = accountHistoryQuery.getDirection();
                if (object == null) {
                    AccountHistoryQuery accountHistoryQuery2;
                    AmountSummaryVO amountSummaryVO = null;
                    AmountSummaryVO amountSummaryVO2 = null;
                    if (set.contains(AccountStatusIndicator.TOTAL_INCOME) || set.contains(AccountStatusIndicator.NET_INFLOW)) {
                        accountHistoryQuery2 = new AccountHistoryQuery();
                        accountHistoryQuery.copyPropertiesTo((Bean)accountHistoryQuery2);
                        accountHistoryQuery2.setDirection(TransferDirection.CREDIT);
                        amountSummaryVO = this.getAmountSummary(accountHistoryQuery2, account);
                    }
                    if (set.contains(AccountStatusIndicator.TOTAL_OUTFLOW) || set.contains(AccountStatusIndicator.NET_INFLOW)) {
                        accountHistoryQuery2 = new AccountHistoryQuery();
                        accountHistoryQuery.copyPropertiesTo((Bean)accountHistoryQuery2);
                        accountHistoryQuery2.setDirection(TransferDirection.DEBIT);
                        amountSummaryVO2 = this.getAmountSummary(accountHistoryQuery2, account);
                    }
                    if (set.contains(AccountStatusIndicator.TOTAL_INCOME)) {
                        accountHistoryStatusVO.setIncoming(amountSummaryVO);
                    }
                    if (set.contains(AccountStatusIndicator.TOTAL_OUTFLOW)) {
                        accountHistoryStatusVO.setOutgoing(amountSummaryVO2);
                    }
                    if (set.contains(AccountStatusIndicator.NET_INFLOW) && amountSummaryVO != null && amountSummaryVO2 != null) {
                        accountHistoryStatusVO.setNetInflow(amountSummaryVO.getSum().subtract(amountSummaryVO2.getSum()));
                    }
                } else if (object == TransferDirection.CREDIT) {
                    if (set.contains(AccountStatusIndicator.TOTAL_INCOME)) {
                        accountHistoryStatusVO.setIncoming(this.getAmountSummary(accountHistoryQuery, account));
                    }
                } else if (set.contains(AccountStatusIndicator.TOTAL_OUTFLOW)) {
                    accountHistoryStatusVO.setOutgoing(this.getAmountSummary(accountHistoryQuery, account));
                }
            }
        }
        return accountHistoryStatusVO;
    }

    public AccountWithHistoryStatusVO getAccountHistoryStatus(AccountHistoryQuery accountHistoryQuery) throws FrameworkException {
        Account account = (Account)this.conversionHandler.convert(Account.class, (Object)accountHistoryQuery.getAccount());
        AccountHistoryStatusVO accountHistoryStatusVO = this.getAccountHistoryStatus(account, accountHistoryQuery);
        AccountWithHistoryStatusVO accountWithHistoryStatusVO = (AccountWithHistoryStatusVO)this.conversionHandler.convert(AccountWithHistoryStatusVO.class, (Object)account);
        accountWithHistoryStatusVO.setStatus(accountHistoryStatusVO);
        return accountWithHistoryStatusVO;
    }

    public Set<Long> getAccountIdsWithTransactions(Set<UserAccountType> set, User user) {
        if (CollectionHelper.isEmpty(set)) {
            return Collections.emptySet();
        }
        QTransfer qTransfer = QTransfer.transfer;
        QUserAccount qUserAccount = QUserAccount.userAccount;
        DBQuery dBQuery = (DBQuery)this.from(new EntityPath[]{qTransfer}).where((Predicate)qTransfer.from().eq((Expression)qUserAccount._super));
        DBQuery dBQuery2 = (DBQuery)this.from(new EntityPath[]{qTransfer}).where((Predicate)qTransfer.to().eq((Expression)qUserAccount._super));
        return ((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qUserAccount}).where(new Predicate[]{qUserAccount.user().eq((Object)user), qUserAccount.type().in(set), dBQuery.exists().or((Predicate)dBQuery2.exists())})).set((Expression)qUserAccount.id);
    }

    public AccountLimitsOverviewData getAccountPaymentAmountLimitsOverviewData() {
        return this.getAccountLimitsOverviewData(ExportFormatContext.PAYMENT_AMOUNT_LIMITS_OVERVIEW);
    }

    public List<AccountWithStatusVO> getAccountsSummary(InternalAccountOwner internalAccountOwner, DateTime dateTime) {
        Date date = this.conversionHandler.toDate((IDate)dateTime);
        return this.doGetAccountsWithStatus(internalAccountOwner, date, null, true, this.accountHandler.toAccountOwnerVO(internalAccountOwner));
    }

    public AccountStatusVO getAccountStatus(Account account, Date date, RateVisibility rateVisibility) {
        return this.doGetAccountStatus(AccountStatusVO.class, account, date, rateVisibility, false, null);
    }

    public AccountStatusVO getAccountStatus(AccountVO accountVO, DateTime dateTime, RateVisibility rateVisibility) {
        Account account = (Account)this.conversionHandler.convert(Account.class, (Object)accountVO);
        return this.getAccountStatus(account, this.conversionHandler.toDate((IDate)dateTime), rateVisibility);
    }

    public List<AccountWithStatusVO> getAccountsWithStatus(InternalAccountOwner internalAccountOwner, Date date, Date date2, boolean bl) throws FrameworkException {
        return this.doGetAccountsWithStatus(internalAccountOwner, date, date2, bl, this.accountHandler.toAccountOwnerVO(internalAccountOwner));
    }

    public AccountWithStatusVO getAccountWithStatus(AccountVO accountVO, DateTime dateTime) throws FrameworkException {
        Account account = (Account)this.conversionHandler.convert(Account.class, (Object)accountVO);
        return this.toAccountWithStatus(account, this.conversionHandler.toDate((IDate)dateTime), null, false);
    }

    public OrderAmountReservation getAmountDereservation(Order order) {
        QOrderAmountReservation qOrderAmountReservation = QOrderAmountReservation.orderAmountReservation;
        return (OrderAmountReservation)((DBQuery)this.from(new EntityPath[]{qOrderAmountReservation}).where(new Predicate[]{qOrderAmountReservation.order().eq((Object)order), qOrderAmountReservation.amount.lt((Number)0)})).singleResult((Expression)qOrderAmountReservation);
    }

    public PendingAuthorizationAmountReservation getAmountDereservationForAuthorization(BasePayment basePayment) {
        QPendingAuthorizationAmountReservation qPendingAuthorizationAmountReservation = QPendingAuthorizationAmountReservation.pendingAuthorizationAmountReservation;
        return (PendingAuthorizationAmountReservation)((DBQuery)this.from(new EntityPath[]{qPendingAuthorizationAmountReservation}).where(new Predicate[]{qPendingAuthorizationAmountReservation.transaction().eq((Object)basePayment), qPendingAuthorizationAmountReservation.amount.lt((Number)0)})).singleResult((Expression)qPendingAuthorizationAmountReservation);
    }

    public OrderAmountReservation getAmountReservation(Order order) {
        QOrderAmountReservation qOrderAmountReservation = QOrderAmountReservation.orderAmountReservation;
        return (OrderAmountReservation)((DBQuery)this.from(new EntityPath[]{qOrderAmountReservation}).where(new Predicate[]{qOrderAmountReservation.order().eq((Object)order), qOrderAmountReservation.amount.gt((Number)0)})).singleResult((Expression)qOrderAmountReservation);
    }

    public PendingAuthorizationAmountReservation getAmountReservationForAuthorization(BasePayment basePayment) {
        QPendingAuthorizationAmountReservation qPendingAuthorizationAmountReservation = QPendingAuthorizationAmountReservation.pendingAuthorizationAmountReservation;
        return (PendingAuthorizationAmountReservation)((DBQuery)this.from(new EntityPath[]{qPendingAuthorizationAmountReservation}).where(new Predicate[]{qPendingAuthorizationAmountReservation.transaction().eq((Object)basePayment), qPendingAuthorizationAmountReservation.amount.gt((Number)0)})).singleResult((Expression)qPendingAuthorizationAmountReservation);
    }

    public ArchivedAccountHistoryData getArchivedAccountHistoryData(@NotNull AccountVO accountVO) throws FrameworkException {
        Account account = (Account)this.conversionHandler.convert(Account.class, (Object)accountVO);
        Date date = account.getArchivingDate();
        if (date == null) {
            throw new IllegalActionException("Account not archived");
        }
        ArchivedAccountHistoryData archivedAccountHistoryData = new ArchivedAccountHistoryData();
        archivedAccountHistoryData.setArchivingDate(this.toDateTime(date));
        archivedAccountHistoryData.setAccount((AccountVO)this.conversionHandler.convert(AccountVO.class, (Object)account));
        archivedAccountHistoryData.setCurrency((CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)account.getCurrency()));
        archivedAccountHistoryData.setShowDescriptionInList(account.getType().isShowDescriptionInHistoryList());
        archivedAccountHistoryData.setFieldsForList(this.conversionHandler.convertList(CustomFieldDetailedVO.class, this.getFieldsForList(account)));
        archivedAccountHistoryData.setExportFormats(this.conversionHandler.convertList(ExportFormatVO.class, (Iterable)this.exportFormatService.listByContext(ExportFormatContext.ARCHIVED_ACCOUNT_HISTORY)));
        ArchivedAccountHistoryQuery archivedAccountHistoryQuery = new ArchivedAccountHistoryQuery();
        archivedAccountHistoryQuery.setAccount(new AccountVO(account.getId()));
        archivedAccountHistoryData.setQuery((QueryParameters)archivedAccountHistoryQuery);
        return archivedAccountHistoryData;
    }

    public ArchivedTransferData getArchivedTransferData(@NotNull Long l) throws FrameworkException {
        ArchivedTransferData archivedTransferData = new ArchivedTransferData();
        archivedTransferData.setTransfer(this.loadArchivedTransfer(l));
        archivedTransferData.setExportFormats(this.conversionHandler.convertList(ExportFormatVO.class, (Iterable)this.exportFormatService.listByContext(ExportFormatContext.ARCHIVED_TRANSFER)));
        return archivedTransferData;
    }

    public BigDecimal getAvailableBalance(Account account, Date date) {
        AccountStatusVO accountStatusVO = this.getAccountStatus(account, date, RateVisibility.NOT);
        if (accountStatusVO == null) {
            throw new IllegalActionException();
        }
        return accountStatusVO.getAvailableBalance();
    }

    public BigDecimal getAverageBalance(Account account, BigDecimal bigDecimal, DatePeriod datePeriod, boolean bl, BigDecimal bigDecimal2) throws FrameworkException {
        Date date;
        Date date2 = datePeriod == null ? null : datePeriod.getBegin();
        Date date3 = date = datePeriod == null ? null : datePeriod.getEnd();
        if (account == null || date2 == null || date == null) {
            throw new IllegalArgumentException("account and period are required");
        }
        if (date2.after(date)) {
            throw new IllegalArgumentException("Begin date should be before end date");
        }
        if (account.isTransient()) {
            return BigDecimal.ZERO;
        }
        date = DateHelper.add((Date)date, (TimeField)TimeField.HOURS, (int)12);
        Date date4 = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        ArrayList<String> arrayList = new ArrayList<String>();
        Date date5 = date2;
        while (!date5.after(date)) {
            arrayList.add(simpleDateFormat.format(date5));
            if (!(date5 = DateHelper.add((Date)date5, (TimeField)TimeField.DAYS, (int)1)).after(date4)) continue;
        }
        int n = (int)Math.floor(DateHelper.daysBetween((Date)date2, (Date)date));
        if (bigDecimal == null) {
            bigDecimal = BigDecimal.ZERO;
        }
        if (!BigDecimalHelper.isPositiveOrZero((BigDecimal)bigDecimal2)) {
            bigDecimal2 = BigDecimal.ZERO;
        }
        BigDecimal bigDecimal3 = (BigDecimal)((DBQuery)this.from(new EntityPath[]{a}).where((Predicate)a.eq((Object)account))).singleResult((Expression)a.balanceSum(Expressions.constant((Object)bigDecimal), Expressions.constant((Object)StringHelper.join(arrayList, (String)",")), Expressions.constant((Object)bl), Expressions.constant((Object)bigDecimal2)));
        BigDecimal bigDecimal4 = BigDecimalHelper.zeroWhenNull((BigDecimal)bigDecimal3).divide(new BigDecimal(n), account.getCurrency().getPrecision(), RoundingMode.HALF_UP);
        return bigDecimal4;
    }

    public BigDecimal getBalance(Account account, Date date) {
        Object object;
        NativeAccountStatus nativeAccountStatus;
        if (account.isTransient()) {
            return BigDecimalHelper.round((BigDecimal)BigDecimal.ZERO, (int)account.getCurrency().getPrecision());
        }
        if (date == null && (nativeAccountStatus = (NativeAccountStatus)(object = InvocationContext.ensure()).getAttribute((Object)this.statusCacheKey(account))) != null) {
            return nativeAccountStatus.getBalance();
        }
        object = (BigDecimal)((DBQuery)this.from(new EntityPath[]{a}).where((Predicate)AccountServiceImpl.a.id.eq((Object)account.getId()))).singleResult((Expression)(date == null ? a.balance() : a.balance(Expressions.constant((Object)date))));
        return BigDecimalHelper.round((BigDecimal)object, (int)account.getCurrency().getPrecision());
    }

    public AccountBalanceLimitLog getBalanceLimitLog(Account account, Date date) {
        if (account instanceof SystemAccount) {
            return this.getBalanceLimitLog((SystemAccount)account, date);
        }
        return this.doGetBalanceLimitLog((UserAccount)account, date);
    }

    public BigDecimal getCreditLimit(Account account, Date date) {
        BigDecimal bigDecimal = null;
        AccountBalanceLimitLog accountBalanceLimitLog = this.getBalanceLimitLog(account, date);
        if (accountBalanceLimitLog != null) {
            bigDecimal = accountBalanceLimitLog.getCreditLimit();
        }
        if (bigDecimal == null && account.getType().getLimitType() == AccountTypeLimitType.LIMITED) {
            return BigDecimal.ZERO;
        }
        return bigDecimal;
    }

    public BigDecimal getCurrentAvailableBalance(Account account, NativeAccountStatus nativeAccountStatus) {
        BigDecimal bigDecimal = this.getBalanceLimitLog(account, null).getCreditLimit();
        if (bigDecimal == null) {
            return null;
        }
        BigDecimal bigDecimal2 = nativeAccountStatus.getBalance();
        BigDecimal bigDecimal3 = nativeAccountStatus.getReserved().add(this.getCurrentReservedAmountByAccountFees(account));
        return this.availableBalance(bigDecimal2, bigDecimal, bigDecimal3);
    }

    public FrontendDashboardAccountVO getFrontendDashbordAcccount(Account account, int n) {
        Comparable<Date> comparable;
        ZonedDateTime zonedDateTime;
        SessionData sessionData = this.getSessionData();
        TimeZone timeZone = sessionData.getConfiguration().getTimeZone();
        LinkedList<Date> linkedList = new LinkedList<Date>();
        ZonedDateTime zonedDateTime2 = ZonedDateTime.now(timeZone.toZoneId());
        ZonedDateTime zonedDateTime3 = zonedDateTime = zonedDateTime2.with(TemporalAdjusters.firstDayOfMonth()).truncatedTo(ChronoUnit.DAYS).minus(1L, ChronoUnit.NANOS);
        boolean bl = zonedDateTime2.getDayOfMonth() >= 3;
        for (int i = 0; i < (bl ? 5 : 6); ++i) {
            comparable = Date.from(zonedDateTime3.toInstant());
            linkedList.addFirst((Date)comparable);
            zonedDateTime3 = zonedDateTime3.with(TemporalAdjusters.firstDayOfMonth()).truncatedTo(ChronoUnit.DAYS).minus(1L, ChronoUnit.NANOS);
        }
        linkedList.add(null);
        List<BalanceEntryVO> list = this.doGetAccountBalanceHistory(account, linkedList);
        comparable = ((BalanceEntryVO)CollectionHelper.last(list)).getAmount();
        if (!bl) {
            list = list.subList(0, list.size() - 1);
        }
        FrontendDashboardAccountVO frontendDashboardAccountVO = new FrontendDashboardAccountVO();
        frontendDashboardAccountVO.setAccount((AccountWithCurrencyVO)this.conversionHandler.convert(AccountWithCurrencyVO.class, (Object)account));
        frontendDashboardAccountVO.setBalance((BigDecimal)comparable);
        frontendDashboardAccountVO.setBalanceHistory(list);
        if (n > 0) {
            frontendDashboardAccountVO.setLastTransfers(this.lastAccountHistoryEntries(account, n));
        }
        return frontendDashboardAccountVO;
    }

    public List<TransferStatusFlow> getManagedFlows(Account account) {
        return this.getTransferStatusFlows(account, true);
    }

    public NativeAccountStatus getNativeAccountStatus(Account account, Date date) {
        InvocationContext invocationContext;
        boolean bl;
        Supplier<NativeAccountStatus> supplier = () -> (NativeAccountStatus)this.nativeQueryHandler.getAccountStatuses(Collections.singleton(account), date).get(account);
        if (date == null && (bl = (invocationContext = InvocationContext.ensure()).hasLock(AccountLockKey.of(account)))) {
            return (NativeAccountStatus)invocationContext.getAttribute((Object)this.statusCacheKey(account), supplier);
        }
        return supplier.get();
    }

    public String getOwnerName(Account account) {
        if (account == null) {
            return null;
        }
        if (account instanceof SystemAccount) {
            return this.getTranslatedName((NamedEntity)account.getType());
        }
        return this.getFormatter().format((AccountOwner)account.getOwner());
    }

    public AccountPermissionsData getPermissions(Account account) throws FrameworkException {
        AdminProductAccessor adminProductAccessor;
        SessionData sessionData = this.getSessionData();
        ProductsAccessor productsAccessor = sessionData.getProducts();
        AccountPermissionsData accountPermissionsData = new AccountPermissionsData();
        accountPermissionsData.setAccount((AccountWithCurrencyVO)this.conversionHandler.convert(AccountWithCurrencyVO.class, (Object)account));
        List list = null;
        List list2 = null;
        List list3 = null;
        List list4 = null;
        List list5 = null;
        List list6 = null;
        List list7 = null;
        if (account.getNature() == AccountTypeNature.SYSTEM) {
            adminProductAccessor = productsAccessor.admin();
            list = adminProductAccessor.getSystemToSystemPayments();
            list2 = adminProductAccessor.getSystemToUserPayments();
            list7 = adminProductAccessor.getSystemToUserExternalPayments();
        } else if (account.getOwner().equals((Object)sessionData.getLoggedUser())) {
            adminProductAccessor = productsAccessor.member();
            list = adminProductAccessor.getSystemPayments();
            list2 = adminProductAccessor.getUserPayments();
            list3 = adminProductAccessor.getSelfPayments();
            list4 = adminProductAccessor.getReceivePosPaymentTypes();
            list5 = adminProductAccessor.getMyPaymentRequestsSendToSystem();
            list6 = adminProductAccessor.getMyPaymentRequestsSendToUser();
            list7 = adminProductAccessor.getMyExternalPaymentTypes();
        } else {
            adminProductAccessor = productsAccessor.userManagement();
            list = adminProductAccessor.getSystemPaymentsAsUser();
            list2 = adminProductAccessor.getUserPaymentsAsUser();
            list3 = adminProductAccessor.getSelfPaymentsAsUser();
            list5 = adminProductAccessor.getUserPaymentRequestsSendToSystem();
            list6 = adminProductAccessor.getUserPaymentRequestsSendToUser();
            list7 = adminProductAccessor.getExternalPaymentsAsUser();
        }
        adminProductAccessor = account.getType();
        accountPermissionsData.setSystemPayments(this.toVOs((AccountType)adminProductAccessor, list));
        accountPermissionsData.setUserPayments(this.toVOs((AccountType)adminProductAccessor, list2));
        accountPermissionsData.setSelfPayments(this.toVOs((AccountType)adminProductAccessor, list3));
        accountPermissionsData.setReceivePayments(this.toVOs((AccountType)adminProductAccessor, list4));
        accountPermissionsData.setSendPaymentRequestsToSystem(this.toVOs((AccountType)adminProductAccessor, list5));
        accountPermissionsData.setSendPaymentRequestsToUser(this.toVOs((AccountType)adminProductAccessor, list6));
        accountPermissionsData.setExternalPayments(this.toVOs((AccountType)adminProductAccessor, list7));
        accountPermissionsData.setVisible(this.accountServiceSecurity.hasVisibility(account));
        return accountPermissionsData;
    }

    public AccountPermissionsData getPermissions(@NotNull AccountVO accountVO) {
        Account account = (Account)this.conversionHandler.convert(Account.class, (Object)accountVO);
        return this.getPermissions(account);
    }

    public RestrictedOperatorAccessibleAccounts getRetrictedOperatorAccessibleAccounts() {
        SessionData sessionData = this.getSessionData();
        if (!sessionData.isRestrictedOperator()) {
            return null;
        }
        Operator operator = sessionData.getLoggedOperator();
        HashSet hashSet = new HashSet(sessionData.getProducts().member().getUserAccounts());
        OperatorGroup operatorGroup = operator.getGroup();
        HashSet<UserAccountType> hashSet2 = new HashSet<UserAccountType>();
        HashSet<UserAccountType> hashSet3 = new HashSet<UserAccountType>();
        HashSet<UserAccountType> hashSet4 = new HashSet<UserAccountType>();
        HashSet<UserAccountType> hashSet5 = new HashSet<UserAccountType>();
        for (OperatorGroupAccountType operatorGroupAccountType : operatorGroup.getAccountTypes()) {
            if (!hashSet.contains(operatorGroupAccountType.getAccountType())) continue;
            UserAccountType userAccountType = operatorGroupAccountType.getAccountType();
            switch (operatorGroupAccountType.getAccess()) {
                case ALL_PAYMENTS: {
                    hashSet2.add(userAccountType);
                    break;
                }
                case INCOMING_PAYMENTS: {
                    hashSet4.add(userAccountType);
                    break;
                }
                case OUTGOING_PAYMENTS: {
                    hashSet5.add(userAccountType);
                    break;
                }
                case OWN_PAYMENTS: {
                    hashSet3.add(userAccountType);
                    break;
                }
            }
        }
        hashSet4.addAll(hashSet2);
        hashSet5.addAll(hashSet2);
        return new RestrictedOperatorAccessibleAccounts(hashSet3, hashSet4, hashSet5);
    }

    public BigDecimal getUpperCreditLimit(Account account, Date date) {
        return this.getBalanceLimitLog(account, date).getUpperCreditLimit();
    }

    public UserAccountBalanceLimitData getUserAccountBalanceLimitData(AccountVO accountVO) {
        UserAccountBalanceLimitData userAccountBalanceLimitData = new UserAccountBalanceLimitData();
        userAccountBalanceLimitData.setEditable(this.hasPermission(Permission.USER_ACCOUNT_LIMIT_MANAGE));
        UserAccount userAccount = (UserAccount)this.conversionHandler.convert(UserAccount.class, (Object)accountVO);
        AccountBalanceLimitLog accountBalanceLimitLog = this.doGetBalanceLimitLog(userAccount, null);
        AccountBalanceLimitDTO accountBalanceLimitDTO = (AccountBalanceLimitDTO)this.conversionHandler.convert(AccountBalanceLimitDTO.class, (Object)userAccount);
        accountBalanceLimitDTO.setCreditLimitFromProduct(accountBalanceLimitLog.isCreditLimitFromProduct());
        accountBalanceLimitDTO.setCreditLimit(accountBalanceLimitLog.getCreditLimit().abs().negate());
        accountBalanceLimitDTO.setUpperCreditLimitFromProduct(accountBalanceLimitLog.isUpperCreditLimitFromProduct());
        accountBalanceLimitDTO.setUpperCreditLimit(accountBalanceLimitLog.getUpperCreditLimit());
        MemberProductAccessor memberProductAccessor = this.productsHandler.getAccessor((BasicUser)userAccount.getUser()).member(userAccount.getType());
        userAccountBalanceLimitData.setProductsCreditLimit(ModelHelper.currencyAmount((CurrencyVO)accountBalanceLimitDTO.getCurrency(), (BigDecimal)memberProductAccessor.getDefaultCreditLimit()));
        userAccountBalanceLimitData.setProductsUpperCreditLimit(ModelHelper.currencyAmount((CurrencyVO)accountBalanceLimitDTO.getCurrency(), (BigDecimal)memberProductAccessor.getDefaultUpperCreditLimit()));
        userAccountBalanceLimitData.setDto(accountBalanceLimitDTO);
        List list = this.conversionHandler.convertList(AccountBalanceLimitLogVO.class, (Iterable)userAccount.getAccountBalanceLimitLog());
        list.forEach(accountBalanceLimitLogVO -> {
            if (accountBalanceLimitLogVO.getCreditLimit() != null) {
                accountBalanceLimitLogVO.setCreditLimit(accountBalanceLimitLogVO.getCreditLimit().abs().negate());
            }
        });
        userAccountBalanceLimitData.setAccountLimitLog(list);
        userAccountBalanceLimitData.setConfirmationPasswordInput(this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).getCredentialInput());
        return userAccountBalanceLimitData;
    }

    public UserAccountPaymentAmountLimitData getUserAccountPaymentAmountLimitData(@NotNull AccountVO accountVO) throws FrameworkException {
        UserAccountPaymentAmountLimitData userAccountPaymentAmountLimitData = new UserAccountPaymentAmountLimitData();
        userAccountPaymentAmountLimitData.setEditable(this.hasPermission(Permission.USER_ACCOUNT_PAYMENT_LIMIT_MANAGE));
        userAccountPaymentAmountLimitData.setConfirmationPasswordInput(this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).getCredentialInput());
        UserAccount userAccount = (UserAccount)this.conversionHandler.convert(UserAccount.class, (Object)accountVO);
        AccountPaymentAmountLimitDTO accountPaymentAmountLimitDTO = (AccountPaymentAmountLimitDTO)this.conversionHandler.convert(AccountPaymentAmountLimitDTO.class, (Object)userAccount);
        accountPaymentAmountLimitDTO.setMaxLimit(userAccount.getPaymentAmountLimit());
        accountPaymentAmountLimitDTO.setMaxPerDayLimit(userAccount.getPaymentAmountPerDayLimit());
        accountPaymentAmountLimitDTO.setMaxPerWeekLimit(userAccount.getPaymentAmountPerWeekLimit());
        accountPaymentAmountLimitDTO.setMaxPerMonthLimit(userAccount.getPaymentAmountPerMonthLimit());
        accountPaymentAmountLimitDTO.setMaxPerYearLimit(userAccount.getPaymentAmountPerYearLimit());
        accountPaymentAmountLimitDTO.setMaxLimitFromProduct(userAccount.isPaymentAmountLimitFromProduct());
        accountPaymentAmountLimitDTO.setMaxPerDayLimitFromProduct(userAccount.isPaymentAmountPerDayLimitFromProduct());
        accountPaymentAmountLimitDTO.setMaxPerWeekLimitFromProduct(userAccount.isPaymentAmountPerWeekLimitFromProduct());
        accountPaymentAmountLimitDTO.setMaxPerMonthLimitFromProduct(userAccount.isPaymentAmountPerMonthLimitFromProduct());
        accountPaymentAmountLimitDTO.setMaxPerYearLimitFromProduct(userAccount.isPaymentAmountPerYearLimitFromProduct());
        userAccountPaymentAmountLimitData.setDto(accountPaymentAmountLimitDTO);
        MemberProductAccessor memberProductAccessor = this.productsHandler.getAccessor((BasicUser)userAccount.getUser()).member(userAccount.getType());
        userAccountPaymentAmountLimitData.setProductsMaxLimit(memberProductAccessor.getDefaultPaymentAmountLimit());
        userAccountPaymentAmountLimitData.setProductsMaxPerDayLimit(memberProductAccessor.getDefaultPaymentAmountPerDayLimit());
        userAccountPaymentAmountLimitData.setProductsMaxPerWeekLimit(memberProductAccessor.getDefaultPaymentAmountPerWeekLimit());
        userAccountPaymentAmountLimitData.setProductsMaxPerMonthLimit(memberProductAccessor.getDefaultPaymentAmountPerMonthLimit());
        userAccountPaymentAmountLimitData.setProductsMaxPerYearLimit(memberProductAccessor.getDefaultPaymentAmountPerYearLimit());
        List list = this.conversionHandler.convertList(AccountPaymentAmountLimitLogVO.class, (Iterable)userAccount.getAccountPaymentAmountLimitLog());
        userAccountPaymentAmountLimitData.setAccountPaymentAmountLimitLogs(list);
        return userAccountPaymentAmountLimitData;
    }

    public List<AccountBalanceLimitVO> getUserAccountsBalanceLimits(UserLocatorVO userLocatorVO) {
        User user = this.userLocatorHandler.locate(userLocatorVO).getUser();
        List list = this.listVisible((InternalAccountOwner)user);
        ArrayList<AccountBalanceLimitVO> arrayList = new ArrayList<AccountBalanceLimitVO>();
        for (UserAccount userAccount : list) {
            AccountBalanceLimitVO accountBalanceLimitVO = (AccountBalanceLimitVO)this.conversionHandler.convert(AccountBalanceLimitVO.class, (Object)userAccount);
            AccountBalanceLimitLog accountBalanceLimitLog = this.doGetBalanceLimitLog(userAccount, null);
            accountBalanceLimitVO.setCreditLimit(accountBalanceLimitLog.getCreditLimit().negate());
            accountBalanceLimitVO.setCreditLimitFromProduct(accountBalanceLimitLog.isCreditLimitFromProduct());
            accountBalanceLimitVO.setUpperCreditLimit(accountBalanceLimitLog.getUpperCreditLimit());
            accountBalanceLimitVO.setUpperCreditLimitFromProduct(accountBalanceLimitLog.isUpperCreditLimitFromProduct());
            arrayList.add(accountBalanceLimitVO);
        }
        return arrayList;
    }

    public List<UserAccountData> getUserAccountsData(User user) {
        ArrayList<UserAccountData> arrayList = new ArrayList<UserAccountData>();
        Map map = this.getProfileAccounts(user);
        if (CollectionHelper.isNotEmpty(map)) {
            BiFunction<AccountProfileVisibility, Account, UserAccountData> biFunction = (accountProfileVisibility, account) -> {
                UserAccountData userAccountData = null;
                if (accountProfileVisibility != AccountProfileVisibility.HIDDEN) {
                    userAccountData = new UserAccountData();
                    userAccountData.setAccount((AccountVO)this.conversionHandler.convert(AccountVO.class, account));
                    userAccountData.setCurrency((CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)account.getCurrency()));
                }
                if (accountProfileVisibility == AccountProfileVisibility.ALL || accountProfileVisibility == AccountProfileVisibility.BALANCE) {
                    userAccountData.setStatus(this.getAccountStatus((Account)account, null, RateVisibility.NOT));
                }
                if (accountProfileVisibility == AccountProfileVisibility.ALL || accountProfileVisibility == AccountProfileVisibility.ACTIVITY) {
                    TransferSummary transferSummary = this.transferService.getTransferSummary(new GetTransferSummaryParameters(null, account, null));
                    TransferSummary transferSummary2 = this.transferService.getTransferSummary(new GetTransferSummaryParameters(account, null, null));
                    ZoneId zoneId = this.getSessionData().getConfiguration().getTimeZone().toZoneId();
                    ZonedDateTime zonedDateTime = ZonedDateTime.now(zoneId).minusDays(30L).truncatedTo(ChronoUnit.DAYS);
                    DatePeriod datePeriod = DatePeriod.begginingAt((Date)Date.from(zonedDateTime.toInstant()));
                    TransferSummary transferSummary3 = this.transferService.getTransferSummary(new GetTransferSummaryParameters(null, account, datePeriod));
                    TransferSummary transferSummary4 = this.transferService.getTransferSummary(new GetTransferSummaryParameters(account, null, datePeriod));
                    userAccountData.setTransactionsInPeriod(transferSummary3.add(transferSummary4).getCount());
                    userAccountData.setTransactionsAllTime(transferSummary.add(transferSummary2).getCount());
                    userAccountData.setPaidInPeriod(transferSummary4.getAmount());
                    userAccountData.setPaidAllTime(transferSummary2.getAmount());
                    userAccountData.setReceivedInPeriod(transferSummary3.getAmount());
                    userAccountData.setReceivedAllTime(transferSummary.getAmount());
                }
                return userAccountData;
            };
            map.keySet().forEach(accountProfileVisibility -> ((List)map.get(accountProfileVisibility)).forEach(account -> {
                UserAccountData userAccountData = (UserAccountData)biFunction.apply((AccountProfileVisibility)accountProfileVisibility, (Account)account);
                if (userAccountData != null) {
                    arrayList.add(userAccountData);
                }
            }));
        }
        return arrayList;
    }

    public List<AccountPaymentAmountLimitVO> getUserAccountsPaymentAmountLimits(@NotNull UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = this.userLocatorHandler.locate(userLocatorVO).getUser();
        ArrayList<AccountPaymentAmountLimitVO> arrayList = new ArrayList<AccountPaymentAmountLimitVO>();
        List list = this.listVisible((InternalAccountOwner)user);
        for (UserAccount userAccount : list) {
            AccountPaymentAmountLimitVO accountPaymentAmountLimitVO = (AccountPaymentAmountLimitVO)this.conversionHandler.convert(AccountPaymentAmountLimitVO.class, (Object)userAccount);
            accountPaymentAmountLimitVO.setMaxLimitFromProduct(userAccount.isPaymentAmountLimitFromProduct());
            accountPaymentAmountLimitVO.setMaxPerDayLimitFromProduct(userAccount.isPaymentAmountPerDayLimitFromProduct());
            accountPaymentAmountLimitVO.setMaxPerWeekLimitFromProduct(userAccount.isPaymentAmountPerWeekLimitFromProduct());
            accountPaymentAmountLimitVO.setMaxPerMonthLimitFromProduct(userAccount.isPaymentAmountPerMonthLimitFromProduct());
            accountPaymentAmountLimitVO.setMaxPerYearLimitFromProduct(userAccount.isPaymentAmountPerYearLimitFromProduct());
            MemberProductAccessor memberProductAccessor = this.productsHandler.getAccessor((BasicUser)user).member(userAccount.getType());
            accountPaymentAmountLimitVO.setMaxLimit(accountPaymentAmountLimitVO.isMaxLimitFromProduct() ? memberProductAccessor.getDefaultPaymentAmountLimit() : userAccount.getPaymentAmountLimit());
            accountPaymentAmountLimitVO.setMaxPerDayLimit(accountPaymentAmountLimitVO.isMaxPerDayLimitFromProduct() ? memberProductAccessor.getDefaultPaymentAmountPerDayLimit() : userAccount.getPaymentAmountPerDayLimit());
            accountPaymentAmountLimitVO.setMaxPerWeekLimit(accountPaymentAmountLimitVO.isMaxPerWeekLimitFromProduct() ? memberProductAccessor.getDefaultPaymentAmountPerWeekLimit() : userAccount.getPaymentAmountPerWeekLimit());
            accountPaymentAmountLimitVO.setMaxPerMonthLimit(accountPaymentAmountLimitVO.isMaxPerMonthLimitFromProduct() ? memberProductAccessor.getDefaultPaymentAmountPerMonthLimit() : userAccount.getPaymentAmountPerMonthLimit());
            accountPaymentAmountLimitVO.setMaxPerYearLimit(accountPaymentAmountLimitVO.isMaxPerYearLimitFromProduct() ? memberProductAccessor.getDefaultPaymentAmountPerYearLimit() : userAccount.getPaymentAmountPerYearLimit());
            arrayList.add(accountPaymentAmountLimitVO);
        }
        return arrayList;
    }

    public UsersWithBalancesOverview getUsersWithBalancesOverview(UserWithBalanceQuery userWithBalanceQuery) throws FrameworkException, QueryParseException {
        return this.userSearchHandler.getBalancesOverview(userWithBalanceQuery);
    }

    public UserWithBalanceSearchData getUserWithBalanceSearchData() throws FrameworkException {
        UserWithBalanceSearchData userWithBalanceSearchData = new UserWithBalanceSearchData();
        SessionData sessionData = this.getSessionData();
        boolean bl = sessionData.isBroker();
        this.userService.fill((AbstractUserSearchData)userWithBalanceSearchData, bl);
        if (sessionData.isAdmin()) {
            userWithBalanceSearchData.setGroups(this.groupsHandler.visibles().users().basic().sorted());
        }
        List list = this.userStatusService.getStatusesForUserSearch(bl);
        list.retainAll(POSSIBLE_STATUSES_TO_OWN_ACCOUNTS);
        userWithBalanceSearchData.setStatuses(list);
        userWithBalanceSearchData.setAccountTypes(this.conversionHandler.convertList(AccountTypeWithDefaultYellowBalanceRangeVO.class, (Iterable)this.getProducts().userManagement().getUserAccountsAccess()));
        UserWithBalanceQuery userWithBalanceQuery = (UserWithBalanceQuery)QueryHelper.newQuery(UserWithBalanceQuery.class);
        AccountTypeWithDefaultYellowBalanceRangeVO accountTypeWithDefaultYellowBalanceRangeVO = (AccountTypeWithDefaultYellowBalanceRangeVO)CollectionHelper.first((Iterable)userWithBalanceSearchData.getAccountTypes());
        if (accountTypeWithDefaultYellowBalanceRangeVO != null) {
            userWithBalanceQuery.setAccountType((AccountTypeVO)accountTypeWithDefaultYellowBalanceRangeVO);
            userWithBalanceQuery.setYellowBalanceRange(accountTypeWithDefaultYellowBalanceRangeVO.getDefaultYellowBalanceRange());
        }
        if (sessionData.getConfiguration().isSkipTotalCount()) {
            userWithBalanceQuery.setOrderBy(UserWithBalanceOrderBy.ALPHABETICALLY_ASC);
        } else {
            userWithBalanceQuery.setOrderBy(UserWithBalanceOrderBy.BALANCE_ASC);
        }
        userWithBalanceQuery.setIgnoreProfileFieldsInList(true);
        if (bl) {
            userWithBalanceQuery.setBrokers(Collections.singleton(new UserVO(sessionData.getLoggedUser().getId())));
        }
        HashSet hashSet = new HashSet();
        userWithBalanceSearchData.getSimpleProfileFields().forEach(profileField -> {
            if (profileField instanceof CustomFieldDetailedVO) {
                hashSet.add((CustomFieldDetailedVO)profileField);
            }
        });
        userWithBalanceSearchData.getAdvancedProfileFields().forEach(profileField -> {
            if (profileField instanceof CustomFieldDetailedVO) {
                hashSet.add((CustomFieldDetailedVO)profileField);
            }
        });
        userWithBalanceQuery.setProfileFields(new HashSet(this.customFieldValueHandler.resolveDefaultSearchValues(hashSet)));
        userWithBalanceSearchData.setQuery((QueryParameters)userWithBalanceQuery);
        userWithBalanceSearchData.setImmediatelyFetchOverview(!sessionData.getConfiguration().isSkipTotalCount());
        userWithBalanceQuery.setUserStatus(EnumSet.of(UserStatus.ACTIVE, UserStatus.BLOCKED));
        userWithBalanceSearchData.setExportFormats(this.conversionHandler.convertList(ExportFormatVO.class, (Iterable)this.exportFormatService.listByContext(ExportFormatContext.USERS_WITH_BALANCES)));
        return userWithBalanceSearchData;
    }

    public Map<UserAccountType, Boolean> getVisibilitySettings(BasicUser basicUser) {
        return (Map)InvocationContext.ensure().getAttribute((Object)("accountVisibilitySettings_" + basicUser.getId()), () -> {
            QUserAccountVisibilitySettings qUserAccountVisibilitySettings = QUserAccountVisibilitySettings.userAccountVisibilitySettings;
            return ((DBQuery)((DBQuery)this.from(new EntityPath[]{qUserAccountVisibilitySettings}).where((Predicate)qUserAccountVisibilitySettings.user().eq((Object)basicUser))).select(new Expression[]{qUserAccountVisibilitySettings.accountType(), qUserAccountVisibilitySettings.visible}).limit(Long.MAX_VALUE)).stream().collect(Collectors.toMap(tuple -> (UserAccountType)tuple.get((Expression)qUserAccountVisibilitySettings.accountType()), tuple -> (Boolean)tuple.get((Expression)qUserAccountVisibilitySettings.visible)));
        });
    }

    public List<TransferStatusFlow> getVisibleFlows(Account account) {
        return this.getTransferStatusFlows(account, false);
    }

    public boolean hasTransfers(Account account) {
        return account.isPersistent() && ((DBQuery)this.from(new EntityPath[]{t}).where((Predicate)t.from().eq((Object)account).or((Predicate)t.to().eq((Object)account)))).hasResults();
    }

    @PostConstruct
    public void initialize() {
        UserPrincipals.inializeAccountLoader(this::load);
    }

    public boolean isActive(IAccount iAccount) {
        if (iAccount == null) {
            return false;
        }
        if (iAccount instanceof IUserAccount) {
            IUserAccount iUserAccount = (IUserAccount)iAccount;
            User user = iUserAccount.getUser();
            if (!POSSIBLE_STATUSES_TO_OWN_ACCOUNTS.contains(user.getStatus())) {
                return false;
            }
            if (this.productsHandler.getAccessor((BasicUser)user).member(iUserAccount.getType()).getUserAccounts().isEmpty()) {
                return false;
            }
        }
        return true;
    }

    public boolean isUserAccountVisibleBySettings(UserAccountType userAccountType, MemberProductAccessor memberProductAccessor, Map<UserAccountType, Boolean> map) {
        AccountVisibility accountVisibility = memberProductAccessor.getAccountVisibility();
        if (accountVisibility == AccountVisibility.ALWAYS_VISIBLE) {
            return true;
        }
        Boolean bl = map.get(userAccountType);
        return bl == null ? accountVisibility.shouldBeVisible() : bl.booleanValue();
    }

    public <A extends Account> List<A> listVisible(InternalAccountOwner internalAccountOwner) {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isSystem()) {
            return this.listAll(internalAccountOwner);
        }
        if (internalAccountOwner instanceof BasicUser && !sessionData.manages((BasicUser)internalAccountOwner)) {
            return Collections.emptyList();
        }
        if (internalAccountOwner instanceof SystemAccountOwner && !sessionData.isAdmin()) {
            return Collections.emptyList();
        }
        LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locate((AccountOwner)internalAccountOwner);
        if (sessionData.isSelf((BasicUser)locateAccountOwnerResult.getUser())) {
            Object object;
            User user = locateAccountOwnerResult.getUser();
            ProductsAccessor productsAccessor = sessionData.getProducts();
            Map<UserAccountType, MemberProductAccessor> map = productsAccessor.member().getUserAccounts().stream().map(userAccountType -> Pair.create((Object)userAccountType, (Object)productsAccessor.member(userAccountType))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (memberProductAccessor, memberProductAccessor2) -> memberProductAccessor));
            if (productsAccessor.product().hasPermission(Permission.MY_ACCOUNT_VISIBILITY_ENABLE)) {
                object = this.getVisibilitySettings(sessionData.getLoggedBasicUser());
                map.entrySet().removeIf(entry -> !this.isUserAccountVisibleBySettings((UserAccountType)entry.getKey(), (MemberProductAccessor)entry.getValue(), (Map<UserAccountType, Boolean>)object));
                if (map.isEmpty()) {
                    return Collections.emptyList();
                }
            }
            object = map.entrySet().stream().filter(entry -> ((MemberProductAccessor)entry.getValue()).getAccountAccessibility() == AccountAccessibility.ONLY_IF_TRANSACTIONS).map(Map.Entry::getKey).collect(Collectors.toSet());
            Set<Long> set = this.getAccountIdsWithTransactions((Set<UserAccountType>)object, user);
            Map<UserAccountType, IUserAccount> map2 = this.persistedAccounts(user);
            return map.keySet().stream().filter(map.keySet()::contains).map(userAccountType -> this.resolveAccount(user, (UserAccountType)userAccountType, map2)).filter(userAccount -> this.accountServiceSecurity.doHasAccess((Account)userAccount, false, (Collection)set)).sorted(ACCOUNT_TYPE_COMPARATOR).collect(Collectors.toList());
        }
        List<A> list = this.listAll(internalAccountOwner);
        return list.stream().filter(account -> this.accountServiceSecurity.doHasAccess(account, false, null)).collect(Collectors.toList());
    }

    public List<Currency> listVisibleCurrencies(InternalAccountOwner internalAccountOwner) {
        if (internalAccountOwner == null) {
            return Collections.emptyList();
        }
        return this.listVisibleTypes(internalAccountOwner).stream().map(AccountType::getCurrency).distinct().sorted().collect(Collectors.toList());
    }

    public List<Currency> listVisibleOrGrantedCurrencies(User user) {
        if (user == null) {
            return Collections.emptyList();
        }
        if (this.getSessionData().isSelf((BasicUser)user)) {
            return this.listVisibleCurrencies((InternalAccountOwner)user);
        }
        return this.productsHandler.getAccessor((BasicUser)user).grantedCurrencies();
    }

    public <A extends AccountType> List<A> listVisibleTypes(InternalAccountOwner internalAccountOwner) {
        if (internalAccountOwner == null) {
            return Collections.emptyList();
        }
        SessionData sessionData = this.getSessionData();
        LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locate((AccountOwner)internalAccountOwner);
        if (locateAccountOwnerResult.isUser() && sessionData.isSelf((BasicUser)locateAccountOwnerResult.getUser())) {
            return this.listVisible(internalAccountOwner).stream().map(Account::getType).sorted().collect(Collectors.toList());
        }
        return this.accountTypeService.listAccessible(locateAccountOwnerResult.getInternalAccountOwner());
    }

    public <A extends Account> A load(AccountLocator accountLocator) throws FrameworkException {
        return this.load(accountLocator.getOwner(), accountLocator.getType());
    }

    public <A extends Account> A load(InternalAccountOwner internalAccountOwner, AccountType accountType) {
        return this.load(internalAccountOwner, accountType, false);
    }

    public <A extends Account> A load(InternalAccountOwner internalAccountOwner, AccountType accountType, boolean bl) {
        return (A)this.doLoad(internalAccountOwner, accountType, bl, false);
    }

    public <A extends Account> A load(InternalAccountOwner internalAccountOwner, String string) {
        try {
            AccountType accountType = (AccountType)this.entityManagerHandler.find(AccountType.class, string);
            return this.load(internalAccountOwner, accountType);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            Account account;
            Account account2 = account = internalAccountOwner != null && "account".equals(string) ? (Account)CollectionHelper.first(this.listVisible(internalAccountOwner)) : null;
            if (account == null) {
                throw entityNotFoundException;
            }
            return (A)account;
        }
    }

    public AccountWithCurrencyVO load(Long l) {
        Account account = this.find(Account.class, l);
        return (AccountWithCurrencyVO)this.conversionHandler.convert(AccountWithCurrencyVO.class, (Object)account);
    }

    public void makeBalanceDirty(Account account, Transfer transfer) {
        DirtyAccountBalance dirtyAccountBalance = new DirtyAccountBalance();
        dirtyAccountBalance.setAccount(account);
        dirtyAccountBalance.setTransfer(transfer);
        this.rawEntityManagerHandler.getEntityManager().persist((Object)dirtyAccountBalance);
    }

    public ChargebackDescriptionFiller newChargebackDescriptionFiller() {
        return new ChargebackDescriptionFillerImpl();
    }

    public <Q extends AbstractTransQuery> Q newQuery(Class<Q> clazz, List<CustomFieldDetailedVO> list) {
        AbstractTransQuery abstractTransQuery = (AbstractTransQuery)QueryHelper.newQuery(clazz);
        abstractTransQuery.setCustomValues(this.customFieldValueHandler.resolveDefaultSearchValues(list));
        return (Q)abstractTransQuery;
    }

    public VOFiller<AccountVO> newVOFiller() {
        return new VOFiller<AccountVO>(AccountVO.class){

            protected List<AccountVO> fetch(Set<Long> set) {
                return ((DBQuery)AccountServiceImpl.this.from(new EntityPath[]{a}).leftFetchHint(new Path[]{a, a.user(), a.user().image()}).where((Predicate)AccountServiceImpl.a.id.in(set))).list(AccountVO.class, (Expression)a);
            }
        };
    }

    public VoucherTransactionAmountReservation processReservationIfNeeded(VoucherTransaction voucherTransaction) throws FrameworkException, InsufficientBalanceException {
        boolean bl = voucherTransaction instanceof VoucherRedeem;
        boolean bl2 = voucherTransaction instanceof VoucherTopUp;
        Voucher voucher = voucherTransaction.getVoucher();
        VoucherConfiguration voucherConfiguration = voucher.getConfiguration();
        SystemAccountType systemAccountType = (SystemAccountType)ObjectHelper.ifType((Object)voucherConfiguration.getRedeemType().getFrom(), SystemAccountType.class);
        if (systemAccountType == null || systemAccountType.getLimitType() == AccountTypeLimitType.UNLIMITED) {
            return null;
        }
        if (bl ? !this.voucherService.hasAmountReservation(voucher) : (bl2 ? !voucherConfiguration.isReserveAmount() : ((VoucherChargeback)voucherTransaction).getChargebackOf().getAmountReservation() == null)) {
            return null;
        }
        if (voucherTransaction.getAmountReservation() != null) {
            throw new IllegalActionException("The given voucher transaction already has a reservation");
        }
        VoucherTransactionAmountReservation voucherTransactionAmountReservation = new VoucherTransactionAmountReservation();
        this.fill((AmountReservation)voucherTransactionAmountReservation, (Account)systemAccountType.getAccount(), voucherTransaction.getAmount());
        voucherTransactionAmountReservation.setVoucherTransaction(voucherTransaction);
        this.persist((IEntity)voucherTransactionAmountReservation);
        voucherTransaction.setAmountReservation(voucherTransactionAmountReservation);
        return voucherTransactionAmountReservation;
    }

    public void reactivateAccounts(long l, long l2) {
        BasicGroup basicGroup = this.find(BasicGroup.class, l2);
        Set set = this.groupsHandler.flatten(Collections.singleton(basicGroup));
        if (set.isEmpty()) {
            return;
        }
        QUserAccount qUserAccount = QUserAccount.userAccount;
        QUser qUser = QUser.user;
        this.update((EntityPath<?>)qUserAccount).set((Path)qUserAccount.active, (Object)true).where(new Predicate[]{qUserAccount.type().id.eq((Object)l), qUserAccount.user().id.in((SubQueryExpression)((DBQuery)this.subQuery(new EntityPath[]{qUser}).where(new Predicate[]{qUser.group().in((Collection)set), qUser.status.in((Collection)POSSIBLE_STATUSES_TO_OWN_ACCOUNTS)})).select((Expression)qUser.id)), qUserAccount.active.isFalse().or((Predicate)qUserAccount.active.isNull())}).execute();
        QPendingUserAccount qPendingUserAccount = QPendingUserAccount.pendingUserAccount;
        this.update((EntityPath<?>)qPendingUserAccount).set((Path)qPendingUserAccount.active, (Object)true).where(new Predicate[]{qPendingUserAccount.type().id.eq((Object)l), qPendingUserAccount.user().id.in((SubQueryExpression)((DBQuery)this.subQuery(new EntityPath[]{qUser}).where(new Predicate[]{qUser.group().in((Collection)set), qUser.status.in((Collection)POSSIBLE_STATUSES_TO_OWN_ACCOUNTS)})).select((Expression)qUser.id)), qPendingUserAccount.active.isFalse().or((Predicate)qPendingUserAccount.active.isNull())}).execute();
    }

    public void removeLastClosedAccountBalances(Transfer transfer) {
        Account account = transfer.getFrom();
        Account account2 = transfer.getTo();
        this.lockHandler.lock(AccountLockKey.of(account));
        this.lockHandler.lock(AccountLockKey.of(account2));
        this.delete((EntityPath<?>)cb).where(new Predicate[]{AccountServiceImpl.cb.date.gt((Comparable)transfer.getDate()).and((Predicate)cb.account().in((Object[])new Account[]{account, account2}))}).execute();
        this.delete((EntityPath<?>)ab).where(new Predicate[]{ab.account().in((Object[])new Account[]{account, account2})}).execute();
        this.delete((EntityPath<?>)db).where(new Predicate[]{db.account().in((Object[])new Account[]{account, account2})}).execute();
    }

    public <A extends Account> A require(InternalAccountOwner internalAccountOwner, AccountType accountType) {
        return (A)this.doLoad(internalAccountOwner, accountType, false, true);
    }

    public VoucherAmountReservation reReserveAmountIfNeeded(Voucher voucher) {
        VoucherPackAmountReservation voucherPackAmountReservation = voucher.getPack().getAmountReservation();
        if (voucherPackAmountReservation == null) {
            return null;
        }
        BigDecimal bigDecimal = voucher.getAmountDereservations().stream().map(AmountReservation::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (BigDecimalHelper.isZero((BigDecimal)bigDecimal)) {
            return null;
        }
        VoucherAmountReservation voucherAmountReservation = new VoucherAmountReservation();
        this.fill((AmountReservation)voucherAmountReservation, voucherPackAmountReservation.getAccount(), bigDecimal.negate());
        voucherAmountReservation.setVoucher(voucher);
        this.persist((IEntity)voucherAmountReservation);
        voucher.getAmountDereservations().add(voucherAmountReservation);
        return voucherAmountReservation;
    }

    public CustomAmountReservation reserveAmount(Account account, BigDecimal bigDecimal) throws InsufficientBalanceException {
        return this.reserveAmount(account, bigDecimal, false);
    }

    public CustomAmountReservation reserveAmount(Account account, BigDecimal bigDecimal, boolean bl) throws InsufficientBalanceException {
        if (BigDecimalHelper.isZero((BigDecimal)bigDecimal)) {
            return null;
        }
        CustomAmountReservation customAmountReservation = new CustomAmountReservation();
        this.fill((AmountReservation)customAmountReservation, account, bigDecimal, bl);
        this.persist((IEntity)customAmountReservation);
        return customAmountReservation;
    }

    public ExternalPaymentAmountReservation reserveAmount(ExternalPayment externalPayment) throws InsufficientBalanceException {
        if (externalPayment.getAmountReservation() != null) {
            throw new IllegalActionException("The given external payment already reserved its amount");
        }
        TransferType transferType = externalPayment.getType();
        if (transferType == null) {
            throw new IllegalActionException("The given external payment has no payment type set");
        }
        BigDecimal bigDecimal = externalPayment.getAmount();
        if (BigDecimalHelper.isZero((BigDecimal)bigDecimal)) {
            return null;
        }
        Account account = externalPayment.getFrom();
        ExternalPaymentAmountReservation externalPaymentAmountReservation = new ExternalPaymentAmountReservation();
        this.fill((AmountReservation)externalPaymentAmountReservation, account, bigDecimal, transferType.isIgnoreAccountLimits());
        externalPaymentAmountReservation.setExternalPayment(externalPayment);
        this.persist((IEntity)externalPaymentAmountReservation);
        externalPayment.getAmountReservations().add(externalPaymentAmountReservation);
        return externalPaymentAmountReservation;
    }

    public OrderAmountReservation reserveAmount(Order order) throws InsufficientBalanceException {
        if (this.getAmountDereservation(order) != null) {
            throw new IllegalActionException("The given order already reserved its amount");
        }
        PaymentTransferType paymentTransferType = order.getPaymentType();
        if (paymentTransferType == null) {
            throw new IllegalActionException("The given order has no payment type set");
        }
        BigDecimal bigDecimal = order.getTotal();
        if (BigDecimalHelper.isZero((BigDecimal)bigDecimal)) {
            return null;
        }
        Object a = this.load((InternalAccountOwner)order.getBuyer(), paymentTransferType.getFrom());
        OrderAmountReservation orderAmountReservation = new OrderAmountReservation();
        this.fill((AmountReservation)orderAmountReservation, (Account)a, bigDecimal, paymentTransferType.isIgnoreAccountLimits());
        orderAmountReservation.setOrder(order);
        this.persist((IEntity)orderAmountReservation);
        return orderAmountReservation;
    }

    public ScheduledPaymentAmountReservation reserveAmount(ScheduledPayment scheduledPayment) throws FrameworkException, InsufficientBalanceException, IllegalActionException {
        if (scheduledPayment.getAmountReservation() != null) {
            throw new IllegalActionException("The given scheduled payment already reserved its amount");
        }
        ScheduledPaymentAmountReservation scheduledPaymentAmountReservation = new ScheduledPaymentAmountReservation();
        this.fill((AmountReservation)scheduledPaymentAmountReservation, scheduledPayment.getFrom(), scheduledPayment.getAmount(), scheduledPayment.getType().isIgnoreAccountLimits());
        scheduledPaymentAmountReservation.setScheduledPayment(scheduledPayment);
        this.persist((IEntity)scheduledPaymentAmountReservation);
        scheduledPayment.setAmountReservation(scheduledPaymentAmountReservation);
        return scheduledPaymentAmountReservation;
    }

    public TicketAmountReservation reserveAmount(Ticket ticket) {
        PaymentTransferType paymentTransferType = (PaymentTransferType)ticket.getType();
        if (!ticket.shouldBeApproved() || !paymentTransferType.isReserveApprovedTicketAmount()) {
            return null;
        }
        if (!ticket.getAmountReservations().isEmpty()) {
            throw new IllegalActionException("The given ticket amount was already reserved");
        }
        TicketAmountReservation ticketAmountReservation = new TicketAmountReservation();
        this.fill((AmountReservation)ticketAmountReservation, ticket.getFrom(), ticket.getAmount(), false);
        ticketAmountReservation.setTicket(ticket);
        this.persist((IEntity)ticketAmountReservation);
        ticket.getAmountReservations().add(ticketAmountReservation);
        return ticketAmountReservation;
    }

    public PendingAuthorizationAmountReservation reserveAmountForAuthorization(PerformTransactionDTO performTransactionDTO, BasePayment basePayment) throws FrameworkException, InsufficientBalanceException, IllegalActionException {
        if (!basePayment.isPendingAuthorization()) {
            throw new IllegalActionException("The given transaction is not pending authorization");
        }
        if (this.getAmountReservationForAuthorization(basePayment) != null) {
            throw new IllegalActionException("The given transaction's amount was already reserved");
        }
        TransferType transferType = basePayment.getType();
        Account account = basePayment.getFrom();
        Account account2 = basePayment.getTo();
        BigDecimal bigDecimal = basePayment.getAmount();
        PaymentTransfer paymentTransfer = new PaymentTransfer();
        paymentTransfer.setTransaction((Transaction)basePayment);
        paymentTransfer.setType(transferType);
        paymentTransfer.setAmount(bigDecimal);
        paymentTransfer.setFrom(account);
        paymentTransfer.setTo(account2);
        for (TransferFee transferFee : transferType.getTransferFees()) {
            TransferFeeTransfer transferFeeTransfer = this.transferFeeService.buildTransfer(performTransactionDTO, transferFee, (Transfer)paymentTransfer, TransferFeePhase.AUTHORIZATION);
            if (transferFeeTransfer == null) continue;
            BigDecimal bigDecimal2 = transferFeeTransfer.getAmount();
            if (transferFee.isDeductAmount() || !transferFeeTransfer.getFrom().equals((Object)account)) continue;
            bigDecimal = bigDecimal.add(bigDecimal2);
        }
        PendingAuthorizationAmountReservation pendingAuthorizationAmountReservation = new PendingAuthorizationAmountReservation();
        this.fill((AmountReservation)pendingAuthorizationAmountReservation, account, bigDecimal, transferType.isIgnoreAccountLimits());
        pendingAuthorizationAmountReservation.setTransaction(basePayment);
        this.persist((IEntity)pendingAuthorizationAmountReservation);
        return pendingAuthorizationAmountReservation;
    }

    public VoucherUnblockAmountReservation reserveAmountForUnblocking(Voucher voucher) {
        if (voucher.getStatus() != VoucherStatus.BLOCKED || voucher.getUnblockAmountReservation() != null) {
            throw new IllegalActionException("Cannot reserve amount for unblocking voucher " + String.valueOf(voucher));
        }
        SystemAccountType systemAccountType = (SystemAccountType)voucher.getConfiguration().getRedeemType().getFrom();
        if (systemAccountType.getLimitType() == AccountTypeLimitType.LIMITED) {
            VoucherUnblockAmountReservation voucherUnblockAmountReservation = new VoucherUnblockAmountReservation();
            this.fill((AmountReservation)voucherUnblockAmountReservation, (Account)systemAccountType.getAccount(), voucher.getAmount(), voucher.getConfiguration().getRedeemType().isIgnoreAccountLimits());
            voucherUnblockAmountReservation.setVoucher(voucher);
            this.persist((IEntity)voucherUnblockAmountReservation);
            return voucherUnblockAmountReservation;
        }
        return null;
    }

    public VoucherPackAmountReservation reserveAmountIfNeeded(VoucherPack voucherPack) throws InsufficientBalanceException {
        if (voucherPack.getAmountReservation() != null) {
            throw new IllegalActionException("The given voucher pack already reserved its amount");
        }
        VoucherType voucherType = voucherPack.getType();
        VoucherConfiguration voucherConfiguration = voucherType.getConfiguration();
        SystemAccountType systemAccountType = (SystemAccountType)voucherConfiguration.getRedeemType().getFrom();
        if (systemAccountType.getLimitType() == AccountTypeLimitType.LIMITED) {
            VoucherPackAmountReservation voucherPackAmountReservation = new VoucherPackAmountReservation();
            this.fill((AmountReservation)voucherPackAmountReservation, (Account)systemAccountType.getAccount(), voucherPack.getTotalAmount(), voucherConfiguration.getRedeemType().isIgnoreAccountLimits());
            voucherPackAmountReservation.setVoucherPack(voucherPack);
            this.persist((IEntity)voucherPackAmountReservation);
            voucherPack.setAmountReservation(voucherPackAmountReservation);
            return voucherPackAmountReservation;
        }
        return null;
    }

    public List<PeriodPreselectorOptionData> resolvePreselectedPeriods(boolean bl) {
        Object object;
        ConfigurationAccessor configurationAccessor = this.getSessionData().getConfiguration();
        TimeZone timeZone = configurationAccessor.getTimeZone();
        DefaultAccountHistoryPeriod defaultAccountHistoryPeriod = configurationAccessor.getDefaultAccountHistoryPeriod();
        PredefinedPeriodData object2 = null;
        ArrayList<PredefinedPeriodData> arrayList = new ArrayList<PredefinedPeriodData>();
        PredefinedPeriodData predefinedPeriodData = DateHelper.getToday((TimeZone)timeZone);
        if (defaultAccountHistoryPeriod == DefaultAccountHistoryPeriod.TODAY) {
            object2 = predefinedPeriodData;
        }
        arrayList.add(predefinedPeriodData);
        PredefinedPeriodData predefinedPeriodData2 = DateHelper.getThisWeek((TimeZone)timeZone);
        if (defaultAccountHistoryPeriod == DefaultAccountHistoryPeriod.CURRENT_WEEK) {
            object2 = predefinedPeriodData2;
        }
        arrayList.add(predefinedPeriodData2);
        for (int date : LAST_MONTHS) {
            Object object3;
            object = DateHelper.getLastMonthsRange((int)date, (TimeZone)timeZone);
            switch (defaultAccountHistoryPeriod) {
                case LAST_MONTH: {
                    object3 = 1;
                    break;
                }
                case LAST_3_MONTHS: {
                    object3 = 3;
                    break;
                }
                case LAST_12_MONTHS: {
                    object3 = 12;
                    break;
                }
                default: {
                    object3 = null;
                }
            }
            if (object3 != null && (Integer)object3 == date) {
                object2 = object;
            }
            arrayList.add((PredefinedPeriodData)object);
        }
        PredefinedPeriodData predefinedPeriodData3 = DateHelper.getPresentMonth((TimeZone)timeZone);
        if (defaultAccountHistoryPeriod == DefaultAccountHistoryPeriod.CURRENT_MONTH) {
            object2 = predefinedPeriodData3;
        }
        arrayList.addAll(DateHelper.createPeriodRange((PredefinedPeriodData)predefinedPeriodData3, (int)-3));
        PredefinedPeriodData predefinedPeriodData4 = DateHelper.getPresentYear((TimeZone)timeZone);
        if (defaultAccountHistoryPeriod == DefaultAccountHistoryPeriod.CURRENT_YEAR) {
            object2 = predefinedPeriodData4;
        }
        arrayList.addAll(DateHelper.createPeriodRange((PredefinedPeriodData)predefinedPeriodData4, (int)-3));
        PredefinedPeriodData predefinedPeriodData5 = new PredefinedPeriodData();
        if (defaultAccountHistoryPeriod == DefaultAccountHistoryPeriod.ALL_TIME) {
            object2 = predefinedPeriodData5;
        }
        arrayList.add(predefinedPeriodData5);
        Date date = this.applicationHandler.getApplication().getArchivingDate();
        object = new ArrayList();
        for (PredefinedPeriodData predefinedPeriodData6 : arrayList) {
            Pair pair = DateHelper.createPeriod((PredefinedPeriodData)predefinedPeriodData6, (TimeZone)timeZone);
            DatePeriod datePeriod = new DatePeriod(pair);
            if (bl && datePeriod != null && datePeriod.getBegin() != null && date != null && date.after(datePeriod.getBegin())) continue;
            PeriodPreselectorOptionData periodPreselectorOptionData = new PeriodPreselectorOptionData();
            periodPreselectorOptionData.setName(PredefinedPeriodDataValueFormatter.instance().format(null, predefinedPeriodData6, this.getFormatter()));
            periodPreselectorOptionData.setType(predefinedPeriodData6.getYear() == null ? PeriodPreselectorOptionType.CUSTOM : PeriodPreselectorOptionType.PRESELECTED);
            periodPreselectorOptionData.setPeriod((DatePeriodDTO)this.conversionHandler.convert(DatePeriodDTO.class, (Object)datePeriod));
            periodPreselectorOptionData.setDefaultOption(predefinedPeriodData6.equals((Object)object2));
            object.add(periodPreselectorOptionData);
        }
        return object;
    }

    public Page<AccountBalanceLimitVO> searchAccountBalanceLimitsOverview(AccountBalanceLimitsOverviewQuery accountBalanceLimitsOverviewQuery) {
        QUserAccount qUserAccount = QUserAccount.userAccount;
        DBQuery<UserAccount> dBQuery = this.createAccountBalanceLimitsQuery(accountBalanceLimitsOverviewQuery, qUserAccount);
        if (dBQuery == null) {
            return PageImpl.empty();
        }
        Page page = QueryHelper.page(dBQuery, (SessionData)this.getSessionData(), (QueryParameters)accountBalanceLimitsOverviewQuery, (Expression)qUserAccount);
        return this.conversionHandler.convertPage(AccountBalanceLimitVO.class, (Iterable)page);
    }

    public Page<AccountHistoryOverviewEntryVO> searchAccountHistoriesOverview(AccountHistoriesOverviewQuery accountHistoriesOverviewQuery) {
        this.applyQueryConstraints((AbstractTransQuery)accountHistoriesOverviewQuery);
        return this.transferSearchHandler.search((QueryParameters)accountHistoriesOverviewQuery);
    }

    public Page<AccountHistoryEntryVO> searchAccountHistory(AccountHistoryQuery accountHistoryQuery) {
        this.checkAccountHistoryQuery(accountHistoryQuery);
        this.applyQueryConstraints((AbstractTransQuery)accountHistoryQuery);
        return this.transferSearchHandler.searchAccountHistory(accountHistoryQuery);
    }

    public Page<AccountPaymentAmountLimitVO> searchAccountPaymentAmountLimitsOverview(@NotNull AccountPaymentAmountLimitsOverviewQuery accountPaymentAmountLimitsOverviewQuery) throws FrameworkException {
        QUserAccount qUserAccount = QUserAccount.userAccount;
        DBQuery<UserAccount> dBQuery = this.createAccountPaymentAmountLimitsQuery(accountPaymentAmountLimitsOverviewQuery, qUserAccount);
        if (dBQuery == null) {
            return PageImpl.empty();
        }
        Page page = QueryHelper.page(dBQuery, (SessionData)this.getSessionData(), (QueryParameters)accountPaymentAmountLimitsOverviewQuery, (Expression)qUserAccount);
        return this.conversionHandler.convertPage(AccountPaymentAmountLimitVO.class, (Iterable)page);
    }

    public ArchivedAccountHistoryVO searchArchivedAccountHistory(@NotNull ArchivedAccountHistoryQuery archivedAccountHistoryQuery) throws FrameworkException {
        LocalDate localDate;
        DateTime dateTime;
        NestedProperty nestedProperty;
        Account account = (Account)this.conversionHandler.convert(Account.class, (Object)archivedAccountHistoryQuery.getAccount());
        final Date date = account.getArchivingDate();
        if (account != null && date == null) {
            throw new IllegalActionException("Account not archived");
        }
        final ZoneId zoneId = this.getSessionData().getConfiguration().getTimeZone().toZoneId();
        Validator validator = new Validator();
        validator.property((org.cyclos.model.Property)ArchivedAccountHistoryQuery.ACCOUNT, BankingKeys.Transfers.ACCOUNT).required();
        validator.property((org.cyclos.model.Property)ArchivedAccountHistoryQuery.PERIOD, GeneralKeys.Ui.PERIOD).required().period();
        if (account != null) {
            nestedProperty = NestedProperty.nested((org.cyclos.model.Property)ArchivedAccountHistoryQuery.PERIOD, (org.cyclos.model.Property)DatePeriodDTO.END);
            validator.property((org.cyclos.model.Property)nestedProperty, GeneralKeys.Ui.PERIOD_END).add((PropertyValidation)new BasePropertyValidation(GeneralKeys.Errors.LESS_EQUALS, new Object[]{this.getFormatter().formatAsDate(date)}){

                protected boolean isValid(Object object, Object object2, Object object3) {
                    DateTime dateTime = (DateTime)object3;
                    return !dateTime.toOffsetDateTime(zoneId).atZoneSameInstant(ZoneOffset.UTC).toLocalDate().isAfter(LocalDate.ofInstant(date.toInstant(), ZoneOffset.UTC));
                }
            });
        }
        this.validate(validator, archivedAccountHistoryQuery, "searchArchivedAccountHistory");
        nestedProperty = new ArchivedAccountHistoryFilter();
        nestedProperty.setCurrentPage(((Integer)ObjectHelper.defaultValue((Object)archivedAccountHistoryQuery.getCurrentPage(), (Object)0)).intValue());
        nestedProperty.setPageSize(((Integer)ObjectHelper.defaultValue((Object)archivedAccountHistoryQuery.getPageSize(), (Object)40)).intValue());
        nestedProperty.setSkipTotalCount(archivedAccountHistoryQuery.isSkipTotalCount());
        nestedProperty.setAccountId(account.getId());
        DatePeriodDTO datePeriodDTO = archivedAccountHistoryQuery.getPeriod();
        DateTime dateTime2 = datePeriodDTO == null ? null : datePeriodDTO.getBegin();
        DateTime dateTime3 = dateTime = datePeriodDTO == null ? null : datePeriodDTO.getEnd();
        if (dateTime2 != null) {
            nestedProperty.setBegin(ZonedDateTime.of(dateTime2.toLocalDateTime(), zoneId).toOffsetDateTime());
        }
        if (dateTime != null) {
            localDate = dateTime.toLocalDateTime().toLocalDate().plusDays(1L);
            nestedProperty.setEnd(ZonedDateTime.of(localDate, LocalTime.MIDNIGHT, zoneId).toOffsetDateTime());
        }
        try {
            localDate = this.archiveHandler.accountHistory((ArchivedAccountHistoryFilter)nestedProperty);
        }
        catch (ResourceAccessException resourceAccessException) {
            this.getLogger().error("Error connecting to the archive application to search the history", (Throwable)resourceAccessException);
            throw new ValidationException(this.message(BankingKeys.Accounts.ERROR_ARCHIVE_SERVER_NOT_AVAILABLE, new Object[0]));
        }
        VOFiller<AccountVO> vOFiller = this.newVOFiller();
        ArchivedAccountHistoryVO archivedAccountHistoryVO = new ArchivedAccountHistoryVO();
        archivedAccountHistoryVO.setBalanceAtBegin(localDate.getBalanceAtBegin());
        archivedAccountHistoryVO.setBalanceAtEnd(localDate.getBalanceAtEnd());
        List list = CollectionHelper.orEmpty((List)localDate.getPageItems());
        List list2 = Collections.emptyList();
        if (!list.isEmpty()) {
            List<TransactionCustomField> list3 = this.getFieldsForList(account);
            FormatterImpl formatterImpl = this.getFormatter();
            list2 = list.stream().map(archivedAccountHistoryEntry -> this.toArchivedEntryVO(zoneId, formatterImpl, (ArchivedAccountHistoryEntry)archivedAccountHistoryEntry, list3, vOFiller)).collect(Collectors.toList());
        }
        vOFiller.fill();
        archivedAccountHistoryVO.setEntries((Page)new PageImpl(list2, localDate.getPageSize(), localDate.getCurrentPage(), (Integer)CoercionHelper.coerce(Integer.class, (Object)localDate.getTotalCount()), localDate.isHasNextPage()));
        return archivedAccountHistoryVO;
    }

    public Page<UserWithBalanceVO> searchUsersWithBalances(UserWithBalanceQuery userWithBalanceQuery) throws FrameworkException {
        if (userWithBalanceQuery.getAddressResult() == UserAddressResult.ALL_LOCATED_ADDRESSES) {
            QueryHelper.applyMaxResultsOnMap((QueryParameters)userWithBalanceQuery);
        }
        return this.userSearchHandler.searchWithBalances(userWithBalanceQuery);
    }

    public void sendStatusPushNotification(Account account) {
        if (account == null || !account.isPersistent()) {
            return;
        }
        Long l = account.getId();
        this.pushNotificationHandler.publish(PushNotificationEventContext.accountStatus((Long)l), SimpleEntity.id((SimpleEntity)account.getNetwork()), () -> {
            Account account = (Account)this.rawEntityManagerHandler.find(Account.class, l);
            return this.toAccountWithStatus(account, null, null, false);
        });
    }

    public void setBalanceLimit(AccountBalanceLimitDTO accountBalanceLimitDTO) {
        this.setBalanceLimit(accountBalanceLimitDTO, true);
    }

    public void setPaymentAmountLimit(@NotNull AccountPaymentAmountLimitDTO accountPaymentAmountLimitDTO) throws FrameworkException {
        UserAccount userAccount = this.requireUserAccount(accountPaymentAmountLimitDTO.getAccount());
        if (this.ignorePaymentAmountLimitsSave(accountPaymentAmountLimitDTO, userAccount)) {
            return;
        }
        this.lockHandler.lock(AccountLockKey.of((Account)userAccount));
        boolean bl = accountPaymentAmountLimitDTO.isMaxLimitFromProduct();
        BigDecimal bigDecimal = bl ? null : accountPaymentAmountLimitDTO.getMaxLimit();
        boolean bl2 = accountPaymentAmountLimitDTO.isMaxPerDayLimitFromProduct();
        BigDecimal bigDecimal2 = bl2 ? null : accountPaymentAmountLimitDTO.getMaxPerDayLimit();
        boolean bl3 = accountPaymentAmountLimitDTO.isMaxPerWeekLimitFromProduct();
        BigDecimal bigDecimal3 = bl3 ? null : accountPaymentAmountLimitDTO.getMaxPerWeekLimit();
        boolean bl4 = accountPaymentAmountLimitDTO.isMaxPerMonthLimitFromProduct();
        BigDecimal bigDecimal4 = bl4 ? null : accountPaymentAmountLimitDTO.getMaxPerMonthLimit();
        boolean bl5 = accountPaymentAmountLimitDTO.isMaxPerYearLimitFromProduct();
        BigDecimal bigDecimal5 = bl5 ? null : accountPaymentAmountLimitDTO.getMaxPerYearLimit();
        Validator validator = new Validator();
        if (!bl) {
            validator.property((org.cyclos.model.Property)AccountPaymentAmountLimitDTO.MAX_LIMIT, BankingKeys.Accounts.PAYMENT_AMOUNT_LIMITS).required().positiveNonZero();
        }
        if (!bl2) {
            validator.property((org.cyclos.model.Property)AccountPaymentAmountLimitDTO.MAX_PER_DAY_LIMIT, BankingKeys.Accounts.PAYMENT_AMOUNT_LIMITS_PER_DAY).required().positiveNonZero();
        }
        if (!bl3) {
            validator.property((org.cyclos.model.Property)AccountPaymentAmountLimitDTO.MAX_PER_WEEK_LIMIT, BankingKeys.Accounts.PAYMENT_AMOUNT_LIMITS_PER_WEEK).required().positiveNonZero();
        }
        if (!bl4) {
            validator.property((org.cyclos.model.Property)AccountPaymentAmountLimitDTO.MAX_PER_MONTH_LIMIT, BankingKeys.Accounts.PAYMENT_AMOUNT_LIMITS_PER_MONTH).required().positiveNonZero();
        }
        if (!bl5) {
            validator.property((org.cyclos.model.Property)AccountPaymentAmountLimitDTO.MAX_PER_YEAR_LIMIT, BankingKeys.Accounts.PAYMENT_AMOUNT_LIMITS_PER_YEAR).required().positiveNonZero();
        }
        this.validate(validator, accountPaymentAmountLimitDTO, "paymentAmountLimit");
        CreateDeviceConfirmationParams createDeviceConfirmationParams = ChangeAccountLimitsConfirmationField.confirmation((AccountVO)userAccount.toVORef());
        this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(accountPaymentAmountLimitDTO.getConfirmationPassword(), createDeviceConfirmationParams);
        userAccount.setPaymentAmountLimit(bigDecimal);
        userAccount.setPaymentAmountPerDayLimit(bigDecimal2);
        userAccount.setPaymentAmountPerWeekLimit(bigDecimal3);
        userAccount.setPaymentAmountPerMonthLimit(bigDecimal4);
        userAccount.setPaymentAmountPerYearLimit(bigDecimal5);
        AccountPaymentAmountLimitLog accountPaymentAmountLimitLog = new AccountPaymentAmountLimitLog();
        accountPaymentAmountLimitLog.setAccount((Account)userAccount);
        accountPaymentAmountLimitLog.setBy(this.getLoggedBasicUser());
        accountPaymentAmountLimitLog.setMaxLimit(bigDecimal);
        accountPaymentAmountLimitLog.setMaxPerDayLimit(bigDecimal2);
        accountPaymentAmountLimitLog.setMaxPerWeekLimit(bigDecimal3);
        accountPaymentAmountLimitLog.setMaxPerMonthLimit(bigDecimal4);
        accountPaymentAmountLimitLog.setMaxPerYearLimit(bigDecimal5);
        accountPaymentAmountLimitLog.setModifiedAt(new Date(System.currentTimeMillis()));
        accountPaymentAmountLimitLog.setDescription(accountPaymentAmountLimitDTO.getDescription());
        this.persist((IEntity)accountPaymentAmountLimitLog);
    }

    public boolean shouldAdjustAccountsWhenAssigning(MemberProduct memberProduct) {
        boolean bl;
        if (memberProduct == null || memberProduct.getUserAccount() == null) {
            return false;
        }
        AccountNumberConfiguration accountNumberConfiguration = this.configurationHandler.getAccessor(memberProduct.getNetwork()).getAccountNumberConfiguration();
        boolean bl2 = bl = accountNumberConfiguration != null && accountNumberConfiguration.isEnabled();
        if (bl) {
            return true;
        }
        boolean bl3 = memberProduct.getInitialCreditType() != null && BigDecimalHelper.isPositive((BigDecimal)memberProduct.getInitialCredit());
        return bl3;
    }

    public AccountWithStatusVO toAccountWithStatus(Account account, Date date, Date date2, boolean bl) throws FrameworkException {
        AccountWithStatusVO accountWithStatusVO = (AccountWithStatusVO)this.conversionHandler.convert(AccountWithStatusVO.class, (Object)account);
        NativeAccountStatus nativeAccountStatus = this.getNativeAccountStatus(account, date);
        Map<Account, Pair<NativeAccountStatus, AccountWithStatusVO>> map = Collections.singletonMap(account, Pair.create((Object)nativeAccountStatus, (Object)accountWithStatusVO));
        this.setStatus(account, date, date2, bl, false, this.accountHandler.toAccountOwnerVO(account.getOwner()), map);
        return accountWithStatusVO;
    }

    public void updateBalance(Account account, BigDecimal bigDecimal, Long[] longArray) {
        this.updateStatus(account, bigDecimal, null, longArray);
    }

    @Override
    protected void persist(IEntity iEntity) {
        super.persist(iEntity);
        if (iEntity instanceof Account) {
            Account account = (Account)iEntity;
            AccountBalance accountBalance = new AccountBalance();
            accountBalance.setAccount(account);
            accountBalance.setBalance(BigDecimal.ZERO);
            accountBalance.setReserved(BigDecimal.ZERO);
            this.rawEntityManagerHandler.getEntityManager().persist((Object)accountBalance);
            this.rawEntityManagerHandler.getEntityManager().flush();
        }
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(QAccount.account.type().currency().network(), true);
    }

    private void applyCommonFilters(DBQuery<UserAccount> dBQuery, AccountLimitsOverviewQuery accountLimitsOverviewQuery, QUserAccount qUserAccount, List<UserAccountType> list) {
        Set set;
        Set set2;
        dBQuery.where((Predicate)qUserAccount.user().status.in((Collection)POSSIBLE_STATUSES_TO_OWN_ACCOUNTS));
        UserAccountType userAccountType = (UserAccountType)this.conversionHandler.convert(UserAccountType.class, (Object)accountLimitsOverviewQuery.getAccountType());
        if (userAccountType != null) {
            dBQuery.where((Predicate)qUserAccount.type().eq((Object)userAccountType));
        } else {
            dBQuery.where((Predicate)qUserAccount.type().in(list));
        }
        Currency currency = (Currency)this.conversionHandler.convert(Currency.class, (Object)accountLimitsOverviewQuery.getCurrency());
        if (currency != null) {
            dBQuery.where((Predicate)qUserAccount.type().currency().eq((Object)currency));
        }
        if (CollectionHelper.isNotEmpty((Iterable)(set2 = this.groupsHandler.flattenVOs((Collection)accountLimitsOverviewQuery.getGroups())))) {
            dBQuery.where((Predicate)qUserAccount.user().group().in((Collection)set2));
        }
        this.visibility(dBQuery, qUserAccount.user()).onlySelf();
        User user = (User)this.conversionHandler.convert(User.class, (Object)accountLimitsOverviewQuery.getUser());
        if (user != null) {
            dBQuery.where((Predicate)qUserAccount.user().eq((Object)user));
        }
        if (CollectionHelper.isNotEmpty((Iterable)(set = this.conversionHandler.convertSet(User.class, (Iterable)accountLimitsOverviewQuery.getBrokers())))) {
            dBQuery.where((Predicate)((QUser)qUserAccount.user().brokers.any()).in((Collection)set));
        }
    }

    private BigDecimal availableBalance(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3) {
        BigDecimal bigDecimal4;
        BigDecimal bigDecimal5 = bigDecimal4 = bigDecimal2 == null ? null : bigDecimal.add(bigDecimal2.abs()).subtract(bigDecimal3);
        if (BigDecimalHelper.isNegative(bigDecimal4)) {
            bigDecimal4 = BigDecimal.ZERO;
        }
        return bigDecimal4;
    }

    private void checkAccountHistoryQuery(AccountHistoryQuery accountHistoryQuery) {
        Account account = (Account)this.conversionHandler.convert(Account.class, (Object)accountHistoryQuery.getAccount());
        if (account == null) {
            throw new IllegalArgumentException("Account is required for the query");
        }
    }

    private void checkInRetentionWindow(Date date) {
        if (date != null && this.isOutRetentionWindow(date)) {
            throw new ValidationException(this.message(BankingKeys.Accounts.ERROR_BEFORE_ARCHIVING_DATE, this.applicationHandler.getApplication().getArchivingDate()));
        }
    }

    private UserAccount createAccount(User user, UserAccountType userAccountType, boolean bl) {
        Object object;
        this.lockHandler.lock(LockType.ACCOUNT_CREATION.key(Long.valueOf(user.getId() + 44L + userAccountType.getId())));
        Map<UserAccountType, IUserAccount> map = this.persistedAccounts(user, true);
        IUserAccount iUserAccount = map.get(userAccountType);
        if (iUserAccount instanceof UserAccount) {
            UserAccount userAccount = (UserAccount)iUserAccount;
            if (userAccount.getType() != userAccountType) {
                userAccount.setType((AccountType)userAccountType);
            }
            if (userAccount.getUser() != user) {
                userAccount.setUser(user);
            }
            return userAccount;
        }
        PendingUserAccount pendingUserAccount = (PendingUserAccount)ObjectHelper.ifType((Object)iUserAccount, PendingUserAccount.class);
        String string = pendingUserAccount != null && StringHelper.isNotBlank((Object)pendingUserAccount.getNumber()) ? pendingUserAccount.getNumber() : this.generateNumber((AccountType)userAccountType, (InternalAccountOwner)user);
        UserAccount userAccount = new UserAccount();
        userAccount.setCreationDate(DateHelper.now());
        userAccount.setType((AccountType)userAccountType);
        userAccount.setUser(user);
        userAccount.setNumber(string);
        userAccount.setActive(pendingUserAccount == null || pendingUserAccount.isActive());
        this.persist((IEntity)userAccount);
        if (pendingUserAccount != null) {
            object = BigDecimalHelper.zeroWhenNull((BigDecimal)pendingUserAccount.getCreditLimit());
            if (!BigDecimalHelper.isZero((BigDecimal)object) || pendingUserAccount.getUpperCreditLimit() != null || !pendingUserAccount.isUpperCreditLimitFromProduct()) {
                AccountBalanceLimitDTO accountBalanceLimitDTO = new AccountBalanceLimitDTO();
                accountBalanceLimitDTO.setAccount(userAccount.toVORef());
                accountBalanceLimitDTO.setCreditLimit((BigDecimal)object);
                accountBalanceLimitDTO.setCreditLimitFromProduct(pendingUserAccount.isCreditLimitFromProduct());
                accountBalanceLimitDTO.setUpperCreditLimit(pendingUserAccount.getUpperCreditLimit());
                accountBalanceLimitDTO.setUpperCreditLimitFromProduct(pendingUserAccount.isUpperCreditLimitFromProduct());
                this.doSetBalanceLimit(userAccount, accountBalanceLimitDTO, false, false);
            }
            this.remove((IEntity)pendingUserAccount);
        }
        object = InvocationContext.get();
        map.put(userAccountType, (IUserAccount)userAccount);
        object.setAttribute((Object)new AccountLocator((InternalAccountOwner)user, (AccountType)userAccountType), (Object)userAccount);
        if (bl) {
            this.insertInitialCredit(userAccount);
        }
        return userAccount;
    }

    private DBQuery<UserAccount> createAccountBalanceLimitsQuery(AccountBalanceLimitsOverviewQuery accountBalanceLimitsOverviewQuery, QUserAccount qUserAccount) {
        BigDecimal bigDecimal;
        Object object;
        Boolean bl;
        Boolean bl2;
        List list = this.getProducts().userManagement().getUserAccountsAccess();
        if (list.isEmpty()) {
            return null;
        }
        QAccountBalanceLimitLog qAccountBalanceLimitLog = QAccountBalanceLimitLog.accountBalanceLimitLog;
        QAccountBalanceLimitLog qAccountBalanceLimitLog2 = new QAccountBalanceLimitLog("l1");
        DBQuery dBQuery = (DBQuery)((DBQuery)this.selectFrom(qUserAccount).leftJoin((EntityPath)qAccountBalanceLimitLog)).on((Predicate)qAccountBalanceLimitLog.account().eq((Expression)qUserAccount._super).and((Predicate)qAccountBalanceLimitLog.modifiedAt.eq((Expression)((JPAQuery)((JPAQuery)new JPAQuery().from((EntityPath)qAccountBalanceLimitLog2)).where((Predicate)qAccountBalanceLimitLog2.account().eq((Expression)qUserAccount._super))).select((Expression)qAccountBalanceLimitLog2.modifiedAt.max()))));
        this.applyCommonFilters((DBQuery<UserAccount>)dBQuery, (AccountLimitsOverviewQuery)accountBalanceLimitsOverviewQuery, qUserAccount, list);
        User user = (User)this.conversionHandler.convert(User.class, (Object)accountBalanceLimitsOverviewQuery.getChangedBy());
        if (user != null) {
            bl2 = new QAccountBalanceLimitLog("accountBalanceLimitLog3");
            bl = bl2.by().eq((Object)user);
            if (user.isBroker()) {
                bl = bl.or((Predicate)bl2.by().operatorUserId.eq((Object)user.getId()));
            }
            dBQuery.where((Predicate)((DBQuery)this.subQuery(new EntityPath[]{bl2}).where(new Predicate[]{qUserAccount.accountBalanceLimitLog.contains((Expression)bl2), bl})).exists());
        }
        if ((bl2 = accountBalanceLimitsOverviewQuery.getPersonalizedNegativeLimit()) != null) {
            if (bl2.booleanValue()) {
                dBQuery.where((Predicate)qAccountBalanceLimitLog.creditLimitFromProduct.isFalse());
            } else {
                dBQuery.where((Predicate)qAccountBalanceLimitLog.creditLimitFromProduct.isTrue().or((Predicate)qAccountBalanceLimitLog.creditLimitFromProduct.isNull()));
            }
            bl = accountBalanceLimitsOverviewQuery.getNegativeLimitRange();
            if (QueryHelper.useParameter((Object)bl)) {
                Object object2;
                object = bl.getMin();
                bigDecimal = bl.getMax();
                if (BigDecimalHelper.isNegative((BigDecimal)object)) {
                    object2 = object;
                    object = bigDecimal == null ? null : bigDecimal.abs();
                    bigDecimal = object2 == null ? null : ((BigDecimal)object2).abs();
                }
                object2 = new DecimalRange((BigDecimal)object, bigDecimal);
                dBQuery.where(qAccountBalanceLimitLog.creditLimit.range((DecimalRange)object2));
            }
        }
        if ((bl = accountBalanceLimitsOverviewQuery.getPersonalizedPositiveLimit()) != null) {
            if (bl.booleanValue()) {
                dBQuery.where((Predicate)qAccountBalanceLimitLog.upperCreditLimitFromProduct.isFalse());
            } else {
                dBQuery.where((Predicate)qAccountBalanceLimitLog.upperCreditLimitFromProduct.isTrue().or((Predicate)qAccountBalanceLimitLog.upperCreditLimitFromProduct.isNull()));
            }
            object = accountBalanceLimitsOverviewQuery.getPositiveLimitRange();
            if (QueryHelper.useParameter((Object)object)) {
                bigDecimal = (DecimalRange)this.conversionHandler.convert(DecimalRange.class, object);
                if (bigDecimal.getMax() == null) {
                    dBQuery.where((Predicate)qAccountBalanceLimitLog.upperCreditLimit.isNull().or(qAccountBalanceLimitLog.upperCreditLimit.range((DecimalRange)bigDecimal)));
                } else {
                    dBQuery.where(qAccountBalanceLimitLog.upperCreditLimit.range((DecimalRange)bigDecimal));
                }
            }
        }
        return dBQuery;
    }

    private DBQuery<UserAccount> createAccountPaymentAmountLimitsQuery(AccountPaymentAmountLimitsOverviewQuery accountPaymentAmountLimitsOverviewQuery, QUserAccount qUserAccount) {
        Boolean bl;
        Boolean bl2;
        Boolean bl3;
        Boolean bl4;
        Boolean bl5;
        List list = this.getProducts().userManagement().getUserAccountsAccess();
        if (list.isEmpty()) {
            return null;
        }
        QAccountPaymentAmountLimitLog qAccountPaymentAmountLimitLog = QAccountPaymentAmountLimitLog.accountPaymentAmountLimitLog;
        QAccountPaymentAmountLimitLog qAccountPaymentAmountLimitLog2 = new QAccountPaymentAmountLimitLog("l1");
        DBQuery dBQuery = (DBQuery)((DBQuery)this.selectFrom(qUserAccount).leftJoin((EntityPath)qAccountPaymentAmountLimitLog)).on((Predicate)qAccountPaymentAmountLimitLog.account().eq((Expression)qUserAccount._super).and((Predicate)qAccountPaymentAmountLimitLog.modifiedAt.eq((Expression)((JPAQuery)((JPAQuery)new JPAQuery().from((EntityPath)qAccountPaymentAmountLimitLog2)).where((Predicate)qAccountPaymentAmountLimitLog2.account().eq((Expression)qUserAccount._super))).select((Expression)qAccountPaymentAmountLimitLog2.modifiedAt.max()))));
        this.applyCommonFilters((DBQuery<UserAccount>)dBQuery, (AccountLimitsOverviewQuery)accountPaymentAmountLimitsOverviewQuery, qUserAccount, list);
        User user = (User)this.conversionHandler.convert(User.class, (Object)accountPaymentAmountLimitsOverviewQuery.getChangedBy());
        if (user != null) {
            bl5 = new QAccountPaymentAmountLimitLog("accountPaymentAmountLimitLog3");
            bl4 = bl5.by().eq((Object)user);
            if (user.isBroker()) {
                bl4 = bl4.or((Predicate)bl5.by().operatorUserId.eq((Object)user.getId()));
            }
            dBQuery.where((Predicate)((DBQuery)this.subQuery(new EntityPath[]{bl5}).where(new Predicate[]{qUserAccount.accountPaymentAmountLimitLog.contains((Expression)bl5), bl4})).exists());
        }
        if ((bl5 = accountPaymentAmountLimitsOverviewQuery.getPersonalizedMaxLimit()) != null) {
            dBQuery.where((Predicate)(bl5 != false ? qAccountPaymentAmountLimitLog.maxLimit.isNotNull() : qAccountPaymentAmountLimitLog.maxLimit.isNull()));
            bl4 = accountPaymentAmountLimitsOverviewQuery.getMaxLimitRange();
            if (QueryHelper.useParameter((Object)bl4)) {
                dBQuery.where(qAccountPaymentAmountLimitLog.maxLimit.range(new DecimalRange(bl4.getMin(), bl4.getMax())));
            }
        }
        if ((bl4 = accountPaymentAmountLimitsOverviewQuery.getPersonalizedMaxPerDayLimit()) != null) {
            dBQuery.where((Predicate)(bl4 != false ? qAccountPaymentAmountLimitLog.maxPerDayLimit.isNotNull() : qAccountPaymentAmountLimitLog.maxPerDayLimit.isNull()));
            bl3 = accountPaymentAmountLimitsOverviewQuery.getMaxPerDayLimitRange();
            if (QueryHelper.useParameter((Object)bl3)) {
                dBQuery.where(qAccountPaymentAmountLimitLog.maxPerDayLimit.range(new DecimalRange(bl3.getMin(), bl3.getMax())));
            }
        }
        if ((bl3 = accountPaymentAmountLimitsOverviewQuery.getPersonalizedMaxPerWeekLimit()) != null) {
            dBQuery.where((Predicate)(bl3 != false ? qAccountPaymentAmountLimitLog.maxPerWeekLimit.isNotNull() : qAccountPaymentAmountLimitLog.maxPerWeekLimit.isNull()));
            bl2 = accountPaymentAmountLimitsOverviewQuery.getMaxPerWeekLimitRange();
            if (QueryHelper.useParameter((Object)bl2)) {
                dBQuery.where(qAccountPaymentAmountLimitLog.maxPerWeekLimit.range(new DecimalRange(bl2.getMin(), bl2.getMax())));
            }
        }
        if ((bl2 = accountPaymentAmountLimitsOverviewQuery.getPersonalizedMaxPerMonthLimit()) != null) {
            dBQuery.where((Predicate)(bl2 != false ? qAccountPaymentAmountLimitLog.maxPerMonthLimit.isNotNull() : qAccountPaymentAmountLimitLog.maxPerMonthLimit.isNull()));
            bl = accountPaymentAmountLimitsOverviewQuery.getMaxPerMonthLimitRange();
            if (QueryHelper.useParameter((Object)bl)) {
                dBQuery.where(qAccountPaymentAmountLimitLog.maxPerMonthLimit.range(new DecimalRange(bl.getMin(), bl.getMax())));
            }
        }
        if ((bl = accountPaymentAmountLimitsOverviewQuery.getPersonalizedMaxPerYearLimit()) != null) {
            dBQuery.where((Predicate)(bl != false ? qAccountPaymentAmountLimitLog.maxPerYearLimit.isNotNull() : qAccountPaymentAmountLimitLog.maxPerYearLimit.isNull()));
            DecimalRangeDTO decimalRangeDTO = accountPaymentAmountLimitsOverviewQuery.getMaxPerYearLimitRange();
            if (QueryHelper.useParameter((Object)decimalRangeDTO)) {
                dBQuery.where(qAccountPaymentAmountLimitLog.maxPerYearLimit.range(new DecimalRange(decimalRangeDTO.getMin(), decimalRangeDTO.getMax())));
            }
        }
        return dBQuery;
    }

    private void disposeAccount(UserAccount userAccount) throws IllegalActionException {
        this.lockHandler.lock(AccountLockKey.of((Account)userAccount));
        UserAccountType userAccountType = userAccount.getType();
        Runnable runnable = () -> {
            BigDecimal bigDecimal = this.getBalance((Account)userAccount, null);
            if (BigDecimalHelper.isPositive((BigDecimal)bigDecimal) && userAccountType.getDisposePositiveType() == null) {
                throw new ValidationException(this.message(BankingKeys.Accounts.DISPOSE_VALIDATION_POSITIVE_BALANCE, this.dataTranslationHandler.getName((NamedEntity)userAccount.getType()), userAccountType.withCurrency(bigDecimal)));
            }
            if (BigDecimalHelper.isNegative((BigDecimal)bigDecimal) && userAccountType.getDisposeNegativeType() == null) {
                throw new ValidationException(this.message(BankingKeys.Accounts.DISPOSE_VALIDATION_NEGATIVE_BALANCE, this.dataTranslationHandler.getName((NamedEntity)userAccount.getType()), userAccountType.withCurrency(bigDecimal)));
            }
            if (!BigDecimalHelper.isZero((BigDecimal)bigDecimal)) {
                this.transferService.insertBalanceDisposal(userAccount, bigDecimal);
            }
        };
        runnable.run();
        userAccount.setActive(false);
        this.transactionAuthorizationService.cancelAll(userAccount);
        this.transactionFeedbackService.cancelAll(userAccount);
        this.scheduledPaymentService.cancelAll(userAccount);
        this.recurringPaymentService.cancelAll(userAccount);
        this.ticketService.cancelAll(userAccount);
        this.paymentRequestService.cancelAll(userAccount);
        this.externalPaymentService.cancelAll(userAccount);
        this.orderService.cancelWithReservedAmount(userAccount);
        this.pinService.relatedEntityRemoved((NetworkedEntity)userAccount, () -> null);
        runnable.run();
    }

    private NativeAccountStatus doCheckAvailableBalance(Account account, BigDecimal bigDecimal, boolean bl) {
        BigDecimal bigDecimal2;
        this.lockHandler.lock(AccountLockKey.of(account));
        NativeAccountStatus nativeAccountStatus = this.getNativeAccountStatus(account, null);
        if (!bl && (bigDecimal2 = this.getCurrentAvailableBalance(account, nativeAccountStatus)) != null && BigDecimalHelper.compareTo((BigDecimal)bigDecimal2, (BigDecimal)bigDecimal) < 0) {
            throw new InsufficientBalanceException();
        }
        return nativeAccountStatus;
    }

    private String doGenerateNumber(AccountNumberConfiguration accountNumberConfiguration, AccountType accountType, InternalAccountOwner internalAccountOwner) {
        String string = accountNumberConfiguration.getMask();
        CustomScript customScript = accountNumberConfiguration.getScript();
        CustomScriptAccessor customScriptAccessor = null;
        if (customScript != null) {
            customScriptAccessor = this.customScriptService.newAccessor(accountNumberConfiguration.getScript(), accountNumberConfiguration.getScriptParameters()).bind("type", (Object)accountType).bind("owner", (Object)internalAccountOwner);
        }
        String string2 = null;
        for (int i = 0; i < 10 && string2 == null; ++i) {
            if (customScript == null) {
                if (string == null) {
                    string = "#########";
                }
                string2 = MaskHelper.generateValue((String)string);
            } else {
                string2 = (String)customScriptAccessor.run(String.class);
                if (string != null) {
                    string2 = MaskHelper.removeMask((String)string, (String)string2);
                }
            }
            Account account = this.doGetAccountByNumber(string2);
            if (account == null) continue;
            string2 = null;
        }
        return string2;
    }

    private List<BalanceEntryVO> doGetAccountBalanceHistory(Account account, List<Date> list) {
        OperatorGroupAccountAccess operatorGroupAccountAccess = this.operatorService.accountAccess(account);
        if (operatorGroupAccountAccess != null && operatorGroupAccountAccess != OperatorGroupAccountAccess.ALL_PAYMENTS) {
            AccountBalanceHistoryVO accountBalanceHistoryVO = new AccountBalanceHistoryVO();
            accountBalanceHistoryVO.setAccount((AccountWithCurrencyVO)this.conversionHandler.convert(AccountWithCurrencyVO.class, (Object)account));
            accountBalanceHistoryVO.setBalances(Collections.emptyList());
            return Collections.emptyList();
        }
        list.removeIf(this::isOutRetentionWindow);
        return this.nativeQueryHandler.getAccountBalanceHistory(account.getId(), list);
    }

    private Account doGetAccountByNumber(String string) {
        String string2 = "account:" + string;
        return (Account)InvocationContext.ensure().getAttribute((Object)string2, () -> {
            PendingUserAccount pendingUserAccount;
            Account account = (Account)((DBQuery)this.from(new EntityPath[]{a}).where((Predicate)AccountServiceImpl.a.number.equalsIgnoreCase(string))).singleResult((Expression)a);
            if (account == null && (pendingUserAccount = (PendingUserAccount)((DBQuery)this.from(new EntityPath[]{p}).where((Predicate)AccountServiceImpl.p.number.equalsIgnoreCase(string))).singleResult((Expression)p)) != null) {
                account = this.resolveAccount(pendingUserAccount.getUser(), pendingUserAccount.getType(), Collections.singletonMap(pendingUserAccount.getType(), pendingUserAccount));
            }
            return account;
        });
    }

    private <VO extends AccountStatusVO> VO doGetAccountStatus(Class<VO> clazz, Account account, Date date, RateVisibility rateVisibility, boolean bl, NativeAccountStatus nativeAccountStatus) {
        BigDecimal bigDecimal;
        this.checkInRetentionWindow(date);
        OperatorGroupAccountAccess operatorGroupAccountAccess = this.operatorService.accountAccess(account);
        if (operatorGroupAccountAccess != null && operatorGroupAccountAccess != OperatorGroupAccountAccess.ALL_PAYMENTS) {
            return null;
        }
        if (nativeAccountStatus == null) {
            nativeAccountStatus = this.getNativeAccountStatus(account, date);
        }
        Set set = this.getConfiguration().getAccountStatusIndicators();
        AccountBalanceLimitLog accountBalanceLimitLog = this.getBalanceLimitLog(account, date);
        BigDecimal bigDecimal2 = accountBalanceLimitLog.getCreditLimit();
        BigDecimal bigDecimal3 = accountBalanceLimitLog.getUpperCreditLimit();
        int n = account.getCurrency().getPrecision();
        BigDecimal bigDecimal4 = nativeAccountStatus.getBalance();
        BigDecimal bigDecimal5 = nativeAccountStatus.getReserved();
        if (date == null) {
            bigDecimal5 = bigDecimal5.add(this.getCurrentReservedAmountByAccountFees(account));
        }
        if ((bigDecimal = this.availableBalance(bigDecimal4, bigDecimal2, bigDecimal5)) == null) {
            bigDecimal5 = null;
        }
        RatesData ratesData = this.rateHandler.getRates(account, bigDecimal4, date, rateVisibility == null ? RateVisibility.NOT : rateVisibility);
        AccountStatusVO accountStatusVO = (AccountStatusVO)ClassHelper.instantiate(clazz);
        accountStatusVO.setAccountId(account.getId());
        if (!bl || set.contains(AccountStatusIndicator.BALANCE)) {
            accountStatusVO.setBalance(BigDecimalHelper.round((BigDecimal)bigDecimal4, (int)n));
        }
        if (!bl || set.contains(AccountStatusIndicator.RESERVED_AMOUNT)) {
            accountStatusVO.setReservedAmount(BigDecimalHelper.round((BigDecimal)bigDecimal5, (int)n));
        }
        if (!bl || set.contains(AccountStatusIndicator.AVAILABLE_BALANCE)) {
            accountStatusVO.setAvailableBalance(BigDecimalHelper.round((BigDecimal)bigDecimal, (int)n));
        }
        if (!bl || set.contains(AccountStatusIndicator.CREDIT_LIMIT)) {
            accountStatusVO.setCreditLimit(BigDecimalHelper.round((BigDecimal)bigDecimal2, (int)n));
        }
        if (!bl || set.contains(AccountStatusIndicator.UPPER_CREDIT_LIMIT)) {
            accountStatusVO.setUpperCreditLimit(BigDecimalHelper.round((BigDecimal)bigDecimal3, (int)n));
        }
        if (!bl || set.contains(AccountStatusIndicator.NEGATIVE_SINCE)) {
            accountStatusVO.setNegativeSince(this.conversionHandler.toDateTime(account.getNegativeSince()));
        }
        if (!bl || set.contains(AccountStatusIndicator.VIRTUAL_RATED_BALANCE)) {
            accountStatusVO.setRateBalanceCorrection(BigDecimalHelper.round((BigDecimal)ratesData.getRateBalanceCorrection(), (int)3));
            accountStatusVO.setVirtualRatedBalance(BigDecimalHelper.round((BigDecimal)ratesData.getVirtualRatedBalance(), (int)3));
        }
        if (!bl || set.contains(AccountStatusIndicator.A_RATE) || set.contains(AccountStatusIndicator.D_RATE)) {
            this.rateHandler.copy((HasRates)ratesData, (HasRates)accountStatusVO);
            if (bl && !set.contains(AccountStatusIndicator.A_RATE)) {
                accountStatusVO.setARate(null);
            }
            if (bl && !set.contains(AccountStatusIndicator.D_RATE)) {
                accountStatusVO.setDRate(null);
            }
        }
        return (VO)accountStatusVO;
    }

    private List<AccountWithStatusVO> doGetAccountsWithStatus(InternalAccountOwner internalAccountOwner, Date date, Date date2, boolean bl, InternalAccountOwner internalAccountOwner2) throws FrameworkException {
        this.checkInRetentionWindow(date);
        internalAccountOwner = this.accountHandler.locateOrCurrent((AccountOwner)internalAccountOwner, true).getInternalAccountOwner();
        List list = this.listVisible(internalAccountOwner);
        InvocationContext.ConversionContext conversionContext = InvocationContext.getConversionContext();
        FieldSelector fieldSelector = this.getSessionData().getRequestData().getFields();
        if (fieldSelector.includes(AccountWithStatusVO.STATUS.getName())) {
            Map map = this.nativeQueryHandler.getAccountStatuses(list, date);
            Map<Account, Pair<NativeAccountStatus, AccountWithStatusVO>> map2 = list.stream().collect(Collectors.toMap(account -> account, account -> Pair.create((Object)((NativeAccountStatus)map.get(account)), (Object)this.conversionHandlerInternal.convert(AccountWithStatusVO.class, account, new Object[]{AccountWithStatusVO.OWNER}, conversionContext))));
            for (Account account2 : list) {
                this.setStatus(account2, date, date2, bl, true, internalAccountOwner2, map2);
            }
            return list.stream().map(account -> (AccountWithStatusVO)((Pair)map2.get(account)).getSecond()).collect(Collectors.toList());
        }
        return list.stream().map(account -> {
            AccountWithStatusVO accountWithStatusVO = this.conversionHandlerInternal.convert(AccountWithStatusVO.class, account, new Object[]{AccountWithStatusVO.OWNER}, conversionContext);
            accountWithStatusVO.setOwner(internalAccountOwner2);
            return accountWithStatusVO;
        }).collect(Collectors.toList());
    }

    private AccountBalanceLimitLog doGetBalanceLimitLog(UserAccount userAccount, Date date) {
        AccountBalanceLimitLog accountBalanceLimitLog;
        AccountBalanceLimitLog accountBalanceLimitLog2 = accountBalanceLimitLog = date == null ? null : this.getLastBalanceLimitLog((Account)userAccount, date);
        if (accountBalanceLimitLog == null) {
            accountBalanceLimitLog = new AccountBalanceLimitLog();
            accountBalanceLimitLog.setAccount((Account)userAccount);
            accountBalanceLimitLog.setCreditLimitFromProduct(userAccount.isCreditLimitFromProduct());
            accountBalanceLimitLog.setCreditLimit(userAccount.getCreditLimit());
            accountBalanceLimitLog.setUpperCreditLimitFromProduct(userAccount.isUpperCreditLimitFromProduct());
            accountBalanceLimitLog.setUpperCreditLimit(userAccount.getUpperCreditLimit());
        } else if (accountBalanceLimitLog.isPersistent()) {
            this.detach((IEntity)accountBalanceLimitLog);
        }
        if (accountBalanceLimitLog.isUpperCreditLimitFromProduct() || accountBalanceLimitLog.isCreditLimitFromProduct()) {
            MemberProductAccessor memberProductAccessor = this.productsHandler.getAccessor((BasicUser)userAccount.getUser()).member(userAccount.getType());
            if (accountBalanceLimitLog.isCreditLimitFromProduct()) {
                accountBalanceLimitLog.setCreditLimit(BigDecimalHelper.zeroWhenNull((BigDecimal)memberProductAccessor.getDefaultCreditLimit()));
            }
            if (accountBalanceLimitLog.isUpperCreditLimitFromProduct()) {
                accountBalanceLimitLog.setUpperCreditLimit(memberProductAccessor.getDefaultUpperCreditLimit());
            }
        }
        return accountBalanceLimitLog;
    }

    private Account doLoad(InternalAccountOwner internalAccountOwner, AccountType accountType, boolean bl, boolean bl2) {
        if (internalAccountOwner == null || accountType == null) {
            throw new EntityNotFoundException();
        }
        LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locate((AccountOwner)internalAccountOwner);
        if (locateAccountOwnerResult.isSystem()) {
            if (!(accountType instanceof SystemAccountType)) {
                throw new EntityNotFoundException(SystemAccount.class);
            }
            return ((SystemAccountType)accountType).getAccount();
        }
        if (!(accountType instanceof UserAccountType)) {
            throw new EntityNotFoundException(UserAccount.class);
        }
        return this.resolveUserAccount(locateAccountOwnerResult.getUser(), (UserAccountType)accountType, bl, bl2);
    }

    private void doSetBalanceLimit(UserAccount userAccount, AccountBalanceLimitDTO accountBalanceLimitDTO, boolean bl, boolean bl2) {
        BigDecimal bigDecimal;
        Property property;
        Validator validator = new Validator();
        boolean bl3 = accountBalanceLimitDTO.isCreditLimitFromProduct();
        BigDecimal bigDecimal2 = bl3 ? null : accountBalanceLimitDTO.getCreditLimit();
        boolean bl4 = accountBalanceLimitDTO.isUpperCreditLimitFromProduct();
        BigDecimal bigDecimal3 = bl4 ? null : accountBalanceLimitDTO.getUpperCreditLimit();
        User user = userAccount.getUser();
        UserAccountType userAccountType = userAccount.getType();
        MemberProductAccessor memberProductAccessor = this.productsHandler.getAccessor((BasicUser)user).member(userAccountType);
        if (!bl3) {
            property = validator.property((org.cyclos.model.Property)AccountBalanceLimitDTO.CREDIT_LIMIT, BankingKeys.Accounts.CREDIT_LIMIT);
            property.required();
            bigDecimal = memberProductAccessor.getIndividualCreditLimit();
            if (bigDecimal2 != null && bigDecimal != null) {
                if (BigDecimalHelper.isZero((BigDecimal)bigDecimal) && !BigDecimalHelper.isZero((BigDecimal)accountBalanceLimitDTO.getCreditLimit())) {
                    property.invalid(BankingKeys.AccountTypes.CREDIT_LIMIT_OPTION_CANNOT_GO_NEGATIVE);
                } else if (BigDecimalHelper.compareTo((BigDecimal)bigDecimal2.abs(), (BigDecimal)bigDecimal.abs()) == 1) {
                    property.invalid(ValidationErrors.lessEquals((Comparable)bigDecimal.abs().negate()));
                }
            }
        }
        if (bigDecimal3 != null) {
            property = validator.property((org.cyclos.model.Property)AccountBalanceLimitDTO.UPPER_CREDIT_LIMIT, BankingKeys.Accounts.UPPER_CREDIT_LIMIT);
            property.positiveOrZero((HasCurrency)userAccount);
        }
        this.validate(validator, accountBalanceLimitDTO, "accountBalanceLimit");
        if (bigDecimal2 != null) {
            bigDecimal2 = bigDecimal2.abs();
        }
        if (bl) {
            this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(accountBalanceLimitDTO.getConfirmationPassword(), ChangeAccountLimitsConfirmationField.confirmation((AccountVO)userAccount.toVORef()));
        }
        userAccount.setCreditLimit(bigDecimal2);
        userAccount.setUpperCreditLimit(bigDecimal3);
        userAccount.setUpperCreditLimitFromProduct(bl4);
        property = new AccountBalanceLimitLog();
        property.setAccount((Account)userAccount);
        property.setBy(this.getLoggedBasicUser());
        property.setCreditLimitFromProduct(bl3);
        property.setCreditLimit(BigDecimalHelper.positive((BigDecimal)bigDecimal2));
        property.setUpperCreditLimitFromProduct(bl4);
        property.setUpperCreditLimit(bigDecimal3);
        property.setModifiedAt(new Date(System.currentTimeMillis()));
        property.setDescription(accountBalanceLimitDTO.getDescription());
        this.persist((IEntity)property);
        if (bl2) {
            if (bl3 || bl4) {
                if (bl3) {
                    bigDecimal2 = BigDecimalHelper.zeroWhenNull((BigDecimal)memberProductAccessor.getDefaultCreditLimit());
                }
                if (bl4) {
                    bigDecimal3 = memberProductAccessor.getDefaultUpperCreditLimit();
                }
            }
            bigDecimal = new CurrencyAmount(userAccount.getCurrency(), bigDecimal2.negate());
            CurrencyAmount currencyAmount = new CurrencyAmount(userAccount.getCurrency(), bigDecimal3);
            this.notificationHandler.user((BasicUser)user).account().limitChange(userAccount, (CurrencyAmount)bigDecimal, currencyAmount, (AccountType)userAccountType);
            this.sendStatusPushNotification((Account)userAccount);
        }
    }

    private void doUpdateBalances(Collection<AccountStatusUpdateParams> collection) {
        boolean bl = collection.stream().anyMatch(accountStatusUpdateParams -> accountStatusUpdateParams.getAccount() instanceof UserAccount);
        boolean bl2 = bl && this.userSearchHandler.indexName() != null;
        List list = this.nativeQueryHandler.updateAccountStatuses(collection);
        if (bl2) {
            HashMap<UserAccount, AccountStatusUpdateResult> hashMap = new HashMap<UserAccount, AccountStatusUpdateResult>();
            for (AccountStatusUpdateResult accountStatusUpdateResult : list) {
                Account account = (Account)this.rawEntityManagerHandler.find(Account.class, accountStatusUpdateResult.getAccountId());
                if (!(account instanceof UserAccount)) continue;
                hashMap.put((UserAccount)account, accountStatusUpdateResult);
            }
            if (!hashMap.isEmpty()) {
                this.userSearchHandler.updateBalances(hashMap);
            }
        }
    }

    private <E extends SimpleEntity, VO extends EntityVO> Pair<E, VO> entityAndVO(Class<E> clazz, Class<VO> clazz2, Long l) {
        SimpleEntity simpleEntity;
        try {
            simpleEntity = (SimpleEntity)this.rawEntityManagerHandler.find(clazz, l);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            simpleEntity = null;
        }
        return Pair.create((Object)simpleEntity, (Object)((EntityVO)this.conversionHandler.convert(clazz2, (Object)simpleEntity)));
    }

    private void fill(AmountReservation amountReservation, Account account, BigDecimal bigDecimal) throws InsufficientBalanceException {
        this.fill(amountReservation, account, bigDecimal, false);
    }

    private void fill(AmountReservation amountReservation, Account object, BigDecimal bigDecimal, boolean bl) throws InsufficientBalanceException {
        if (object.isTransient()) {
            object = this.require(object.getOwner(), object.getType());
        }
        if (BigDecimalHelper.isZero((BigDecimal)(bigDecimal = BigDecimalHelper.round((BigDecimal)bigDecimal, (int)object.getCurrency().getPrecision())))) {
            throw new IllegalActionException("Cannot reserve / dereserve an amount of zero");
        }
        NativeAccountStatus nativeAccountStatus = this.doCheckAvailableBalance((Account)object, bigDecimal, bl);
        amountReservation.setAccount(object);
        amountReservation.setAmount(bigDecimal);
        amountReservation.setDate(DateHelper.now());
        nativeAccountStatus.setReserved(BigDecimalHelper.zeroWhenNull((BigDecimal)nativeAccountStatus.getReserved()).add(bigDecimal));
        this.updateStatus((Account)object, nativeAccountStatus.getBalance(), nativeAccountStatus.getReserved(), nativeAccountStatus.getDirtyTransferIds());
        this.sendStatusPushNotification((Account)object);
    }

    private Collection<TransferFilter> filterTransferFiltersForAccount(Account account, List<TransferFilter> list) {
        if (CollectionHelper.isEmpty(list)) {
            return Collections.emptyList();
        }
        ArrayList<TransferFilter> arrayList = new ArrayList<TransferFilter>();
        for (TransferFilter transferFilter : list) {
            if (!account.getType().equals((Object)transferFilter.getAccountType())) continue;
            arrayList.add(transferFilter);
        }
        return arrayList;
    }

    private AccountLimitsOverviewData getAccountLimitsOverviewData(ExportFormatContext exportFormatContext) {
        AccountLimitsOverviewData accountLimitsOverviewData = new AccountLimitsOverviewData();
        List list = this.getSessionData().getProducts().userManagement().getUserAccountsAccess();
        accountLimitsOverviewData.setUserAccountTypes(this.conversionHandler.convertList(AccountTypeWithCurrencyVO.class, (Iterable)list));
        if (this.getLoggedUser().isAdmin()) {
            accountLimitsOverviewData.setManagedGroups(this.groupsHandler.visibles().accessibles().basicUsers().sorted());
        } else {
            accountLimitsOverviewData.setManagedGroups(Collections.emptyList());
        }
        accountLimitsOverviewData.setExportFormats(this.conversionHandler.convertList(ExportFormatVO.class, (Iterable)this.exportFormatService.listByContext(exportFormatContext)));
        return accountLimitsOverviewData;
    }

    private AmountSummaryVO getAmountSummary(AccountHistoryQuery accountHistoryQuery, Account account) {
        NumberExpression numberExpression = t.count();
        NumberExpression numberExpression2 = AccountServiceImpl.t.amount.abs().sum();
        DBQuery dBQuery = this.transferQueryHandler.build((BuildTransQueryParams)new BuildTransferQueryParams(account, (BaseTransferQuery)accountHistoryQuery));
        dBQuery.getMetadata().clearOrderBy();
        Tuple tuple = dBQuery.singleResult(new Expression[]{numberExpression, numberExpression2});
        int n = ((Long)tuple.get((Expression)numberExpression)).intValue();
        BigDecimal bigDecimal = BigDecimalHelper.zeroWhenNull((BigDecimal)((BigDecimal)tuple.get((Expression)numberExpression2)));
        Currency currency = account.getCurrency();
        BigDecimal bigDecimal2 = BigDecimalHelper.round((BigDecimal)(n == 0 ? BigDecimal.ZERO : bigDecimal.divide(new BigDecimal(n), BigDecimalHelper.MATH_CONTEXT)), (int)currency.getPrecision());
        CurrencyVO currencyVO = (CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)currency);
        return ModelHelper.amountSummary((BigDecimal)bigDecimal, (BigDecimal)bigDecimal2, (int)n, (CurrencyVO)currencyVO);
    }

    private AccountBalanceLimitLog getBalanceLimitLog(SystemAccount systemAccount, Date date) {
        AccountBalanceLimitLog accountBalanceLimitLog;
        AccountBalanceLimitLog accountBalanceLimitLog2 = accountBalanceLimitLog = date == null ? null : this.getLastBalanceLimitLog((Account)systemAccount, date);
        if (accountBalanceLimitLog == null) {
            accountBalanceLimitLog = new AccountBalanceLimitLog();
            accountBalanceLimitLog.setAccount((Account)systemAccount);
            if (systemAccount.getType().getLimitType() == AccountTypeLimitType.LIMITED) {
                accountBalanceLimitLog.setCreditLimit(BigDecimalHelper.zeroWhenNull((BigDecimal)systemAccount.getCreditLimit()));
                accountBalanceLimitLog.setUpperCreditLimit(systemAccount.getUpperCreditLimit());
            }
        } else if (accountBalanceLimitLog.isPersistent()) {
            this.detach((IEntity)accountBalanceLimitLog);
        }
        return accountBalanceLimitLog;
    }

    private BigDecimal getCurrentReservedAmountByAccountFees(Account account) {
        if (account.isTransient()) {
            return BigDecimal.ZERO;
        }
        if (account instanceof UserAccount) {
            BigDecimal bigDecimal;
            UserAccount userAccount = (UserAccount)account;
            List list = this.accountFeeService.listScheduledFeesReservingAmount(userAccount);
            if (list.size() > 1) {
                throw new ValidationException(this.message(BankingKeys.AccountFees.ERROR_MULTIPLE_FEES_RESERVING_AMOUNT, list));
            }
            AccountFee accountFee = (AccountFee)CollectionHelper.first((Iterable)list);
            if (accountFee != null && BigDecimalHelper.isPositive((BigDecimal)(bigDecimal = this.accountFeeLogService.calculateReservedAmount(accountFee, userAccount)))) {
                return bigDecimal;
            }
        }
        return BigDecimal.ZERO;
    }

    private List<TransactionCustomField> getFieldsForList(Account account) {
        SessionData sessionData = this.getSessionData();
        AccountType accountType = account.getType();
        List list = sessionData.getProducts().product().getVisibleTransactionFields();
        ArrayList<TransactionCustomField> arrayList = new ArrayList<TransactionCustomField>(list);
        arrayList.retainAll(accountType.getCustomFieldsForList());
        return arrayList;
    }

    private AccountBalanceLimitLog getLastBalanceLimitLog(Account account, Date date) {
        if (account.isTransient()) {
            return null;
        }
        QAccountBalanceLimitLog qAccountBalanceLimitLog = QAccountBalanceLimitLog.accountBalanceLimitLog;
        return (AccountBalanceLimitLog)CollectionHelper.first((Iterable)((DBQuery)((DBQuery)((DBQuery)this.from(new EntityPath[]{qAccountBalanceLimitLog}).where(new Predicate[]{qAccountBalanceLimitLog.account().eq((Object)account), date == null ? qAccountBalanceLimitLog.id.isNotNull() : qAccountBalanceLimitLog.modifiedAt.loe((Comparable)date)})).orderBy(qAccountBalanceLimitLog.modifiedAt.desc())).limit(1L)).list((Expression)qAccountBalanceLimitLog));
    }

    private <A extends Account> Map<AccountProfileVisibility, List<A>> getProfileAccounts(User user) {
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor((BasicUser)user);
        List list = productsAccessor.member().getUserAccounts();
        if (CollectionHelper.isEmpty((Iterable)list)) {
            return null;
        }
        User user2 = user == null ? this.getLoggedUser() : (User)this.conversionHandler.convert(User.class, (Object)user);
        QUserAccount qUserAccount = QUserAccount.userAccount;
        List list2 = ((DBQuery)((DBQuery)this.from(new EntityPath[]{qUserAccount}).where(new Predicate[]{qUserAccount.user().eq((Object)user2), qUserAccount.type().in((Collection)list)})).orderBy(qUserAccount.type().name.asc())).list((Expression)qUserAccount);
        HashMap hashMap = new HashMap();
        list2.forEach(account -> {
            AccountProfileVisibility accountProfileVisibility = productsAccessor.member((UserAccountType)account.getType()).getShowAccountInProfile();
            ArrayList<Account> arrayList = (ArrayList<Account>)hashMap.get(accountProfileVisibility);
            if (arrayList == null) {
                arrayList = new ArrayList<Account>();
            }
            arrayList.add((Account)account);
            hashMap.put(accountProfileVisibility, arrayList);
        });
        return hashMap;
    }

    private List<TransferStatusFlow> getTransferStatusFlows(Account account, boolean bl) {
        UserAccount userAccount;
        BooleanPropertiesHolder booleanPropertiesHolder;
        SessionData sessionData = this.getSessionData();
        ProductsAccessor productsAccessor = sessionData.getProducts();
        if (account == null) {
            booleanPropertiesHolder = productsAccessor.product().getTransferStatusFlows();
        } else if (account instanceof UserAccount) {
            userAccount = (UserAccount)account;
            booleanPropertiesHolder = userAccount.getUser().equals((Object)sessionData.getLoggedUser()) ? productsAccessor.member().getTransferStatusFlows() : productsAccessor.userManagement().getTransferStatusFlows();
        } else if (account instanceof SystemAccount) {
            booleanPropertiesHolder = productsAccessor.admin().getTransferStatusFlows();
        } else {
            throw new IllegalStateException("Unhandled account: " + String.valueOf(account));
        }
        userAccount = QProductTransferStatusFlow.productTransferStatusFlow;
        Set set = booleanPropertiesHolder.keysSet((Path)(bl ? userAccount.editable : userAccount.visible));
        if (account != null) {
            List list = this.transferStatusFlowService.listByAccountType(account.getType());
            set.retainAll(list);
        }
        return CollectionHelper.sort((Collection)set);
    }

    private boolean ignoreBalanceLimitsSave(AccountBalanceLimitDTO accountBalanceLimitDTO, UserAccount userAccount) {
        return StringHelper.isBlank((Object)accountBalanceLimitDTO.getDescription()) && accountBalanceLimitDTO.isCreditLimitFromProduct() == userAccount.isCreditLimitFromProduct() && accountBalanceLimitDTO.isUpperCreditLimitFromProduct() == userAccount.isUpperCreditLimitFromProduct() && BigDecimalHelper.areEqualsOrBothNull((BigDecimal)accountBalanceLimitDTO.getCreditLimit(), (BigDecimal)userAccount.getCreditLimit()) && BigDecimalHelper.areEqualsOrBothNull((BigDecimal)accountBalanceLimitDTO.getUpperCreditLimit(), (BigDecimal)userAccount.getUpperCreditLimit());
    }

    private boolean ignorePaymentAmountLimitsSave(AccountPaymentAmountLimitDTO accountPaymentAmountLimitDTO, UserAccount userAccount) {
        return StringHelper.isBlank((Object)accountPaymentAmountLimitDTO.getDescription()) && accountPaymentAmountLimitDTO.isMaxLimitFromProduct() == userAccount.isPaymentAmountLimitFromProduct() && accountPaymentAmountLimitDTO.isMaxPerDayLimitFromProduct() == userAccount.isPaymentAmountPerDayLimitFromProduct() && accountPaymentAmountLimitDTO.isMaxPerWeekLimitFromProduct() == userAccount.isPaymentAmountPerWeekLimitFromProduct() && accountPaymentAmountLimitDTO.isMaxPerMonthLimitFromProduct() == userAccount.isPaymentAmountPerMonthLimitFromProduct() && accountPaymentAmountLimitDTO.isMaxPerYearLimitFromProduct() == userAccount.isPaymentAmountPerYearLimitFromProduct() && BigDecimalHelper.areEqualsOrBothNull((BigDecimal)accountPaymentAmountLimitDTO.getMaxLimit(), (BigDecimal)userAccount.getPaymentAmountLimit()) && BigDecimalHelper.areEqualsOrBothNull((BigDecimal)accountPaymentAmountLimitDTO.getMaxPerDayLimit(), (BigDecimal)userAccount.getPaymentAmountPerDayLimit()) && BigDecimalHelper.areEqualsOrBothNull((BigDecimal)accountPaymentAmountLimitDTO.getMaxPerWeekLimit(), (BigDecimal)userAccount.getPaymentAmountPerWeekLimit()) && BigDecimalHelper.areEqualsOrBothNull((BigDecimal)accountPaymentAmountLimitDTO.getMaxPerMonthLimit(), (BigDecimal)userAccount.getPaymentAmountPerMonthLimit()) && BigDecimalHelper.areEqualsOrBothNull((BigDecimal)accountPaymentAmountLimitDTO.getMaxPerYearLimit(), (BigDecimal)userAccount.getPaymentAmountPerYearLimit());
    }

    private InitialCreditTransfer insertInitialCredit(UserAccount userAccount) {
        UserAccountType userAccountType = userAccount.getType();
        User user = userAccount.getUser();
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor((BasicUser)user);
        GeneratedTransferType generatedTransferType = null;
        BigDecimal bigDecimal = BigDecimal.ZERO;
        Collection collection = productsAccessor.getProducts();
        for (Product product : collection) {
            BigDecimal bigDecimal2;
            if (!(product instanceof MemberProduct) || (bigDecimal2 = ((MemberProduct)product).getInitialCredit()) == null || BigDecimalHelper.compareTo((BigDecimal)bigDecimal2, (BigDecimal)bigDecimal) <= 0 || !userAccountType.getToTransferTypes().contains(((MemberProduct)product).getInitialCreditType())) continue;
            bigDecimal = bigDecimal2;
            generatedTransferType = ((MemberProduct)product).getInitialCreditType();
        }
        if (BigDecimalHelper.isPositive((BigDecimal)bigDecimal) && generatedTransferType != null) {
            try {
                return this.transferService.insertInitialCreditTransfer(userAccount, generatedTransferType, bigDecimal);
            }
            catch (TransferException transferException) {
                this.alertService.create(user, UserAlertType.INSUFFICIENT_BALANCE_FOR_INITIAL_CREDIT, new Object[]{userAccountType.getName(), new CurrencyAmount(userAccountType.getCurrency(), bigDecimal), generatedTransferType.getName()});
            }
        }
        return null;
    }

    private boolean isOutRetentionWindow(Date date) {
        if (date == null) {
            return false;
        }
        Date date2 = this.applicationHandler.getApplication().getArchivingDate();
        return date2 != null && date.before(date2);
    }

    private List<AccountHistoryEntryVO> lastAccountHistoryEntries(Account account, int n) {
        QTransfer qTransfer = QTransfer.transfer;
        return ((DBQuery)((DBQuery)((DBQuery)this.from(new EntityPath[]{qTransfer}).where((Predicate)qTransfer.from().eq((Object)account).or((Predicate)qTransfer.to().eq((Object)account)))).orderBy(qTransfer.date.desc())).limit((long)n)).stream((Expression)qTransfer).map(transfer -> new AccountHistoryEntry(account, transfer, false)).map(this.conversionHandler.convertingFunction(AccountHistoryEntryVO.class, new Object[0])).collect(Collectors.toList());
    }

    private <A extends Account> List<A> listAll(InternalAccountOwner internalAccountOwner) {
        LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locateOrCurrent((AccountOwner)internalAccountOwner, true);
        InvocationContext invocationContext = InvocationContext.ensure();
        Function<List, List> function = list -> {
            list.forEach(account -> invocationContext.setAttribute((Object)new AccountLocator(internalAccountOwner, account.getType()), account));
            return list;
        };
        if (locateAccountOwnerResult.isSystem()) {
            return new ArrayList((Collection)invocationContext.getAttribute((Object)"systemAccounts", () -> {
                QSystemAccount qSystemAccount = QSystemAccount.systemAccount;
                return (List)function.apply(((DBQuery)this.from(new EntityPath[]{qSystemAccount}).orderBy(qSystemAccount.type().name.asc())).list((Expression)qSystemAccount));
            }));
        }
        if (locateAccountOwnerResult.isUser()) {
            User user = locateAccountOwnerResult.getUser();
            return new ArrayList((Collection)invocationContext.getAttribute((Object)AccountServiceImpl.allAccountsKey(user), () -> {
                List list;
                block3: {
                    Map<UserAccountType, IUserAccount> map;
                    List list2;
                    block2: {
                        list2 = this.productsHandler.getAccessor((BasicUser)user).member().getUserAccounts();
                        map = this.persistedAccounts(user);
                        list = list2.stream().map(userAccountType -> this.resolveAccount(user, (UserAccountType)userAccountType, map)).sorted(ACCOUNT_TYPE_COMPARATOR).collect(Collectors.toList());
                        SessionData sessionData = this.getSessionData();
                        if (sessionData.isSystem()) break block2;
                        if (!sessionData.isManagerOf((BasicUser)user)) break block3;
                    }
                    map.values().stream().filter(UserAccount.class::isInstance).map(UserAccount.class::cast).filter(userAccount -> !list2.contains(userAccount.getType())).forEach(list::add);
                }
                return (List)function.apply(list);
            }));
        }
        return Collections.emptyList();
    }

    private ArchivedTransferVO loadArchivedTransfer(@NotNull Long l) throws FrameworkException {
        ArchivedTransfer archivedTransfer;
        try {
            archivedTransfer = this.archiveHandler.viewTransfer(l);
        }
        catch (ResourceAccessException resourceAccessException) {
            this.getLogger().error("Error connecting to the archive application to load a transfer", (Throwable)resourceAccessException);
            throw new ValidationException(this.message(BankingKeys.Accounts.ERROR_ARCHIVE_SERVER_NOT_AVAILABLE, new Object[0]));
        }
        Pair<TransferType, TransferTypeVO> pair = this.entityAndVO(TransferType.class, TransferTypeVO.class, archivedTransfer.getTypeId());
        Pair<Account, AccountVO> pair2 = this.entityAndVO(Account.class, AccountVO.class, archivedTransfer.getFromId());
        Pair<Account, AccountVO> pair3 = this.entityAndVO(Account.class, AccountVO.class, archivedTransfer.getToId());
        Currency currency = ((HasCurrency)((NetworkedEntity)((Pair)ObjectHelper.coalesce((Object[])new Pair[]{pair, pair2, pair3})).getFirst())).getCurrency();
        ArchivedTransferVO archivedTransferVO = new ArchivedTransferVO();
        archivedTransferVO.setId(archivedTransfer.getId());
        archivedTransferVO.setDate((DateTime)this.conversionHandler.convert(DateTime.class, (Object)archivedTransfer.getDate()));
        archivedTransferVO.setAmount(archivedTransfer.getAmount());
        archivedTransferVO.setDescription(archivedTransfer.getDescription());
        archivedTransferVO.setTransactionNumber(archivedTransfer.getTransactionNumber());
        archivedTransferVO.setType((TransferTypeVO)pair.getSecond());
        archivedTransferVO.setFrom((AccountVO)pair2.getSecond());
        archivedTransferVO.setTo((AccountVO)pair3.getSecond());
        archivedTransferVO.setCurrency((CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)currency));
        archivedTransferVO.setChannel((ChannelVO)this.entityAndVO(Channel.class, ChannelVO.class, archivedTransfer.getChannelId()).getSecond());
        archivedTransferVO.setBy((BasicUserVO)this.entityAndVO(BasicUser.class, BasicUserVO.class, archivedTransfer.getById()).getSecond());
        archivedTransferVO.setReceivedBy((BasicUserVO)this.entityAndVO(BasicUser.class, BasicUserVO.class, archivedTransfer.getReceivedById()).getSecond());
        AccountFeeLogVO accountFeeLogVO = (AccountFeeLogVO)this.entityAndVO(AccountFeeLog.class, AccountFeeLogVO.class, archivedTransfer.getAccountFeeLogId()).getSecond();
        if (accountFeeLogVO != null) {
            archivedTransferVO.setAccountFee(accountFeeLogVO.getAccountFee());
        }
        archivedTransferVO.setTransferFee((TransferFeeVO)this.entityAndVO(TransferFee.class, TransferFeeVO.class, archivedTransfer.getTransferFeeId()).getSecond());
        try {
            archivedTransferVO.setNature(TransferNature.valueOf((String)archivedTransfer.getSubclass()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            archivedTransferVO.setCreationType(PaymentCreationType.valueOf((String)archivedTransfer.getCreationType()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        SessionData sessionData = this.getSessionData();
        List list = sessionData.getProducts().product().getVisibleTransactionFields();
        archivedTransferVO.setCustomValues(this.toCustomFieldValues(list, archivedTransfer.getCustomValues()));
        return archivedTransferVO;
    }

    private Map<UserAccountType, IUserAccount> persistedAccounts(User user) {
        return this.persistedAccounts(user, false);
    }

    private Map<UserAccountType, IUserAccount> persistedAccounts(User user, boolean bl) {
        InvocationContext invocationContext = InvocationContext.get();
        String string = AccountServiceImpl.persistedAccountsKey(user);
        if (bl) {
            invocationContext.setAttribute((Object)string, null);
        }
        return (Map)invocationContext.getAttribute((Object)string, () -> this.nativeQueryHandler.userAccounts(user, null, false, null));
    }

    private UserAccount requireUserAccount(AccountVO accountVO) {
        UserAccount userAccount;
        if (accountVO == null) {
            throw new EntityNotFoundException(Account.class);
        }
        if (accountVO.getId() != null) {
            userAccount = this.find(UserAccount.class, accountVO.getId());
        } else if (accountVO.getNumber() != null) {
            userAccount = (UserAccount)ObjectHelper.ifType((Object)this.findByNumber(accountVO.getNumber()), UserAccount.class);
            if (userAccount == null) {
                throw new EntityNotFoundException(Account.class, accountVO.getNumber());
            }
            if (userAccount.isTransient()) {
                userAccount = (UserAccount)this.require((InternalAccountOwner)userAccount.getOwner(), (AccountType)userAccount.getType());
            }
        } else {
            UserAccountType userAccountType = (UserAccountType)this.conversionHandler.convert(UserAccountType.class, (Object)accountVO.getType());
            User user = (User)this.conversionHandler.convert(User.class, (Object)accountVO.getOwner());
            userAccount = (UserAccount)this.require((InternalAccountOwner)user, (AccountType)userAccountType);
        }
        if (!this.isActive((IAccount)userAccount)) {
            throw new IllegalActionException("Inactive account of " + String.valueOf(userAccount.getOwner()) + " of type " + String.valueOf(userAccount.getType()));
        }
        return userAccount;
    }

    private UserAccount resolveAccount(User user, UserAccountType userAccountType, Map<UserAccountType, IUserAccount> map) {
        IUserAccount iUserAccount = map.get(userAccountType);
        if (iUserAccount instanceof UserAccount) {
            return (UserAccount)iUserAccount;
        }
        if (iUserAccount == null) {
            return new UserAccount(user, userAccountType);
        }
        return new UserAccount(iUserAccount);
    }

    private UserAccount resolveUserAccount(User user, UserAccountType userAccountType, boolean bl, boolean bl2) {
        List list = this.productsHandler.getAccessor((BasicUser)user).member().getUserAccounts();
        if (!bl && !list.contains(userAccountType)) {
            throw new EntityNotFoundException(UserAccount.class);
        }
        UserAccount userAccount2 = null;
        InvocationContext invocationContext = InvocationContext.get();
        List list2 = (List)invocationContext.getAttribute((Object)AccountServiceImpl.allAccountsKey(user));
        if (list2 != null && (userAccount2 = (UserAccount)list2.stream().filter(userAccount -> userAccount.getType().equals((Object)userAccountType)).findAny().orElse(null)) != null) {
            if (userAccount2.getType() != userAccountType) {
                userAccount2.setType((AccountType)userAccountType);
            }
            if (userAccount2.getUser() != user) {
                userAccount2.setUser(user);
            }
        }
        if (userAccount2 == null) {
            AccountLocator accountLocator = new AccountLocator((InternalAccountOwner)user, (AccountType)userAccountType);
            userAccount2 = (UserAccount)invocationContext.getAttribute((Object)accountLocator, () -> {
                Map<UserAccountType, IUserAccount> map = this.persistedAccounts(user);
                return map.isEmpty() ? null : this.resolveAccount(user, userAccountType, map);
            });
        }
        if (userAccount2 != null && userAccount2.isTransient() && bl2) {
            userAccount2 = null;
        }
        if (userAccount2 == null) {
            if (!list.contains(userAccountType)) {
                throw new EntityNotFoundException(UserAccount.class);
            }
            userAccount2 = bl2 ? this.createAccount(user, userAccountType, false) : this.resolveAccount(user, userAccountType, Collections.emptyMap());
            invocationContext.setAttribute((Object)new AccountLocator((InternalAccountOwner)user, (AccountType)userAccountType), (Object)userAccount2);
        }
        return userAccount2.isTransient() ? userAccount2 : (UserAccount)this.rawEntityManagerHandler.find(UserAccount.class, userAccount2.getId());
    }

    private void setBalanceLimit(AccountBalanceLimitDTO accountBalanceLimitDTO, boolean bl) {
        UserAccount userAccount = this.requireUserAccount(accountBalanceLimitDTO.getAccount());
        this.lockHandler.lock(AccountLockKey.of((Account)userAccount));
        if (this.ignoreBalanceLimitsSave(accountBalanceLimitDTO, userAccount)) {
            return;
        }
        this.doSetBalanceLimit(userAccount, accountBalanceLimitDTO, bl, true);
    }

    private void setStatus(Account account, Date date, Date date2, boolean bl, boolean bl2, InternalAccountOwner internalAccountOwner, Map<Account, Pair<NativeAccountStatus, AccountWithStatusVO>> map) {
        Pair<NativeAccountStatus, AccountWithStatusVO> pair = map.get(account);
        RateVisibility rateVisibility = bl ? RateVisibility.PARAM : RateVisibility.NOT;
        NativeAccountStatus nativeAccountStatus = (NativeAccountStatus)pair.getFirst();
        AccountWithStatusVO accountWithStatusVO = (AccountWithStatusVO)pair.getSecond();
        accountWithStatusVO.setOwner(internalAccountOwner);
        accountWithStatusVO.setStatus(this.doGetAccountStatus(AccountStatusVO.class, account, date, rateVisibility, bl2, nativeAccountStatus));
        if (date2 != null) {
            DatePeriod datePeriod = new DatePeriod();
            datePeriod.setBegin(date2);
            TransferSummary transferSummary = this.transferService.getTransferSummary(new GetTransferSummaryParameters(null, account, datePeriod));
            accountWithStatusVO.setReceived(transferSummary.getAmount());
        }
        if (account.getType().getLimitType() == AccountTypeLimitType.UNLIMITED) {
            accountWithStatusVO.setUnlimited(true);
        }
    }

    private String statusCacheKey(Account account) {
        return "accountStatus:" + account.getId();
    }

    private ArchivedAccountHistoryEntryVO toArchivedEntryVO(ZoneId zoneId, FormatterImpl formatterImpl, ArchivedAccountHistoryEntry archivedAccountHistoryEntry, List<TransactionCustomField> list, VOFiller<AccountVO> vOFiller) {
        ArchivedAccountHistoryEntryVO archivedAccountHistoryEntryVO = new ArchivedAccountHistoryEntryVO();
        archivedAccountHistoryEntryVO.setId(archivedAccountHistoryEntry.getId());
        archivedAccountHistoryEntryVO.setAmount(archivedAccountHistoryEntry.getAmount());
        archivedAccountHistoryEntryVO.setDate(new DateTime(archivedAccountHistoryEntry.getDate().atZoneSameInstant(zoneId)));
        archivedAccountHistoryEntryVO.setDescription(archivedAccountHistoryEntry.getDescription());
        archivedAccountHistoryEntryVO.setRelatedAccount((AccountVO)vOFiller.add(archivedAccountHistoryEntry.getRelatedAccountId()));
        archivedAccountHistoryEntryVO.setCustomValues(this.toCustomFieldValues(list, archivedAccountHistoryEntry.getCustomValues()));
        return archivedAccountHistoryEntryVO;
    }

    private List<CustomFieldValueVO> toCustomFieldValues(List<TransactionCustomField> list, Map<String, String> map) {
        if (CollectionHelper.isEmpty(list) || CollectionHelper.isEmpty(map)) {
            return Collections.emptyList();
        }
        return list.stream().map(transactionCustomField -> {
            Object object;
            String string = (String)map.get(transactionCustomField.getId().toString());
            String string2 = string;
            if (StringHelper.isBlank((Object)string2)) {
                return null;
            }
            if (transactionCustomField.getType() == CustomFieldType.LINKED_ENTITY) {
                string2 = StringUtils.substringBefore((String)string, (String)" ");
            }
            if ((object = this.customFieldValueHandler.resolveReference((CustomField)transactionCustomField, string2, false, false, null, ",")) == null && transactionCustomField.getType() == CustomFieldType.LINKED_ENTITY) {
                object = this.toLinkedentityVO((TransactionCustomField)transactionCustomField, string);
            }
            CustomFieldValueVO customFieldValueVO = new CustomFieldValueVO();
            this.customFieldValueHandler.setModelValue((CustomField)transactionCustomField, object, (ICustomFieldValue)customFieldValueVO);
            return customFieldValueVO;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Object toLinkedentityVO(TransactionCustomField transactionCustomField, String string) {
        Object object;
        LinkedEntityType linkedEntityType = transactionCustomField.getLinkedEntityType();
        Object object2 = StringUtils.substringAfter((String)string, (String)" ");
        if (linkedEntityType == LinkedEntityType.TRANSACTION || linkedEntityType == LinkedEntityType.TRANSFER) {
            if (StringHelper.isBlank((Object)object2)) {
                object2 = this.applicationHandler.getIdMask().apply((Object)string).toString();
            }
        } else if (linkedEntityType == LinkedEntityType.RECORD) {
            object = StringUtils.substringBefore((String)string, (String)" ");
            object2 = (String)object2 + " (" + this.applicationHandler.getIdMask().apply(object) + ")";
        }
        object = (LinkedEntityVO)ClassHelper.instantiate((Class)LinkedEntityTypeMapping.getLinkedEntityVOType((LinkedEntityType)linkedEntityType));
        org.cyclos.model.Property property = LinkedEntityTypeMapping.getLinkedEntityVOProperty((LinkedEntityType)linkedEntityType);
        EntityVO entityVO = (EntityVO)ClassHelper.instantiate((Class)LinkedEntityTypeMapping.getVoType((LinkedEntityType)linkedEntityType));
        if (entityVO instanceof HasDisplay) {
            ((HasDisplay)entityVO).setDisplay((String)object2);
        } else if (entityVO instanceof INamedEntity) {
            ((INamedEntity)entityVO).setName((String)object2);
        }
        object.set(property, (Object)entityVO);
        object.setName((String)object2);
        return object;
    }

    private List<TransferTypeVO> toVOs(AccountType accountType, List<PaymentTransferType> list) {
        if (CollectionHelper.isEmpty(list)) {
            return Collections.emptyList();
        }
        ArrayList<TransferTypeVO> arrayList = new ArrayList<TransferTypeVO>();
        for (PaymentTransferType paymentTransferType : list) {
            if (!paymentTransferType.getFrom().equals((Object)accountType) && !paymentTransferType.getTo().equals((Object)accountType)) continue;
            arrayList.add((TransferTypeVO)this.conversionHandler.convert(TransferTypeVO.class, (Object)paymentTransferType));
        }
        return arrayList;
    }

    private void updateNumber(IUserAccount iUserAccount, String string) {
        if (iUserAccount instanceof UserAccount) {
            this.update((EntityPath<?>)a).set((Path)AccountServiceImpl.a.number, (Object)string).where(new Predicate[]{AccountServiceImpl.a.id.eq((Object)iUserAccount.getId())}).execute();
        } else if (iUserAccount instanceof PendingUserAccount) {
            this.update((EntityPath<?>)p).set((Path)AccountServiceImpl.p.number, (Object)string).where(new Predicate[]{AccountServiceImpl.p.id.eq((Object)iUserAccount.getId())}).execute();
        }
    }

    private void updateStatus(Account account, BigDecimal bigDecimal, BigDecimal bigDecimal2, Long[] longArray) {
        String string;
        InvocationContext invocationContext = InvocationContext.ensure();
        NativeAccountStatus nativeAccountStatus = (NativeAccountStatus)invocationContext.getAttribute((Object)(string = this.statusCacheKey(account)));
        if (nativeAccountStatus == null) {
            throw new IllegalStateException("Trying to update an account balance without locking it first");
        }
        nativeAccountStatus.setBalance(bigDecimal);
        if (bigDecimal2 != null) {
            nativeAccountStatus.setReserved(bigDecimal2);
        }
        if (CollectionHelper.isNotEmpty((Object[])longArray)) {
            longArray = (Long[])ArrayUtils.addAll((Object[])nativeAccountStatus.getDirtyTransferIds(), (Object[])longArray);
            nativeAccountStatus.setDirtyTransferIds(longArray);
        }
        AccountStatusUpdateParams accountStatusUpdateParams = new AccountStatusUpdateParams(account, bigDecimal, nativeAccountStatus.getReserved(), nativeAccountStatus.getDirtyTransferIds());
        ((HashMap)invocationContext.getAttribute((Object)UPDATE_STATUSES_ATTR, HashMap::new)).put(account, accountStatusUpdateParams);
        invocationContext.addBeforeEndListener(() -> {
            InvocationContext invocationContext = InvocationContext.ensure();
            Map map = (Map)invocationContext.getAttribute((Object)UPDATE_STATUSES_ATTR);
            if (map != null) {
                this.doUpdateBalances(map.values());
                invocationContext.setAttribute((Object)UPDATE_STATUSES_ATTR, null);
            }
        });
    }

    private static /* synthetic */ boolean lambda$fillTransSearchData$3(List list, TransferFilter transferFilter) {
        return list.contains(transferFilter.getAccountType());
    }

    public class ChargebackDescriptionFillerImpl
    implements ChargebackDescriptionFiller {
        private Map<Long, AccountHistoryEntryVO> vos = new HashMap<Long, AccountHistoryEntryVO>();

        public void add(AccountHistoryEntryVO accountHistoryEntryVO) {
            this.vos.put(accountHistoryEntryVO.getId(), accountHistoryEntryVO);
        }

        public void fill() {
            if (this.vos.isEmpty()) {
                return;
            }
            QChargebackTransfer qChargebackTransfer = QChargebackTransfer.chargebackTransfer;
            QTransfer qTransfer = QTransfer.transfer;
            QTransaction qTransaction = QTransaction.transaction1;
            ((DBQuery)((DBQuery)((DBQuery)AccountServiceImpl.this.from(new EntityPath[]{qChargebackTransfer}).innerJoin((EntityPath)qChargebackTransfer.chargebackOf(), (Path)qTransfer)).leftJoin((EntityPath)qTransfer.transaction(), (Path)qTransaction)).where((Predicate)qChargebackTransfer.id.in(this.vos.keySet()))).stream(new Expression[]{qChargebackTransfer.id, qTransaction.description}).forEach(tuple -> {
                Long l = (Long)tuple.get((Expression)qChargebackTransfer.id);
                String string = (String)tuple.get((Expression)qTransaction.description);
                AccountHistoryEntryVO accountHistoryEntryVO = this.vos.get(l);
                MessageKey messageKey = StringHelper.isBlank((Object)string) ? BankingKeys.Transfers.NATURE_CHARGEBACK : BankingKeys.Transfers.CHARGEBACK_DESCRIPTION;
                accountHistoryEntryVO.setDescription(AccountServiceImpl.this.message(messageKey, new Object[]{string}));
            });
        }
    }
}

