/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountBalanceLimitLog;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.GeneratedTransferType;
import org.cyclos.entities.banking.QAccountType;
import org.cyclos.entities.banking.SystemAccount;
import org.cyclos.entities.banking.SystemAccountType;
import org.cyclos.entities.banking.UserAccountType;
import org.cyclos.entities.contentmanagement.QDataTranslation;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Product;
import org.cyclos.entities.users.User;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AccountFeeServiceLocal;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.AccountTypeServiceLocal;
import org.cyclos.impl.banking.CurrencyServiceLocal;
import org.cyclos.impl.banking.DRateTypeHandler;
import org.cyclos.impl.banking.LocateAccountOwnerResult;
import org.cyclos.impl.banking.TransactionCustomFieldServiceLocal;
import org.cyclos.impl.banking.TransferFilterServiceLocal;
import org.cyclos.impl.banking.TransferTypeServiceLocal;
import org.cyclos.impl.users.ProductServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.SerializablePredicate;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.PropertyValidation;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.impl.utils.validation.validations.BasePropertyValidation;
import org.cyclos.impl.utils.validation.validations.RangeOptionalType;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.accountfees.AccountFeeQuery;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounttypes.AccountTypeDTO;
import org.cyclos.model.banking.accounttypes.AccountTypeData;
import org.cyclos.model.banking.accounttypes.AccountTypeLimitType;
import org.cyclos.model.banking.accounttypes.AccountTypeNature;
import org.cyclos.model.banking.accounttypes.AccountTypeQuery;
import org.cyclos.model.banking.accounttypes.AccountTypeSearchData;
import org.cyclos.model.banking.accounttypes.AccountTypeVO;
import org.cyclos.model.banking.accounttypes.AccountTypeWithCurrencyVO;
import org.cyclos.model.banking.accounttypes.SystemAccountTypeDTO;
import org.cyclos.model.banking.accounttypes.SystemAccountTypeData;
import org.cyclos.model.banking.accounttypes.UserAccountTypeDTO;
import org.cyclos.model.banking.accounttypes.UserAccountTypeData;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.currencies.CurrencyVOWithDRate;
import org.cyclos.model.banking.transferfilters.TransferFilterQuery;
import org.cyclos.model.banking.transfertypes.TransferTypeNature;
import org.cyclos.model.banking.transfertypes.TransferTypeQuery;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.users.products.AdminProductDTO;
import org.cyclos.model.users.products.UserManagementProductDTO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccountTypeServiceImpl
extends CRUDServiceImpl<AccountType, QAccountType, AccountTypeDTO, AccountTypeData, AccountTypeNature>
implements AccountTypeServiceLocal {
    private static final BidiMap<Class<? extends AccountType>, Class<? extends AccountTypeDTO>> SUBCLASS_MAPPINGS = new DualHashBidiMap();
    @Autowired
    private CurrencyServiceLocal currencyService;
    @Autowired
    private AccountFeeServiceLocal accountFeeService;
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private TransferFilterServiceLocal transferFilterService;
    @Autowired
    private TransferTypeServiceLocal transferTypeService;
    @Autowired
    private TransactionCustomFieldServiceLocal transactionCustomFieldService;
    @Autowired
    private ProductServiceLocal productService;
    @Autowired
    private DRateTypeHandler dRateHandler;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;

    public AccountTypeServiceImpl() {
        super(AccountType.class, QAccountType.accountType, AccountTypeDTO.class);
    }

    public AccountTypeSearchData getSearchData() {
        AccountTypeSearchData accountTypeSearchData = new AccountTypeSearchData();
        AccountTypeQuery accountTypeQuery = (AccountTypeQuery)QueryHelper.newQuery(AccountTypeQuery.class);
        accountTypeSearchData.setQuery((QueryParameters)accountTypeQuery);
        accountTypeSearchData.setCurrencies(this.currencyService.list());
        accountTypeSearchData.setCanManage(true);
        return accountTypeSearchData;
    }

    public boolean hasAccessible(InternalAccountOwner internalAccountOwner) {
        SessionData sessionData = this.getSessionData();
        LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locateOrCurrent((AccountOwner)internalAccountOwner, true);
        if (locateAccountOwnerResult.isUser() && sessionData.isSelf((BasicUser)locateAccountOwnerResult.getUser())) {
            return sessionData.getProducts().member().hasUserAccounts();
        }
        return !this.listAccessible(locateAccountOwnerResult.getInternalAccountOwner()).isEmpty();
    }

    public <A extends AccountType> List<A> listAccessible(InternalAccountOwner internalAccountOwner) {
        SessionData sessionData = this.getSessionData();
        ProductsAccessor productsAccessor = sessionData.getProducts();
        LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locateOrCurrent((AccountOwner)internalAccountOwner, true);
        if (locateAccountOwnerResult.isSystem()) {
            return productsAccessor.admin().getSystemAccounts();
        }
        if (locateAccountOwnerResult.getInternalAccountOwner().equals((Object)sessionData.getLoggedUser())) {
            return productsAccessor.member().getUserAccounts();
        }
        if (sessionData.isSystem() || sessionData.isManagerOf((BasicUser)locateAccountOwnerResult.getUser())) {
            User user = locateAccountOwnerResult.getUser();
            List list = this.productsHandler.getAccessor((BasicUser)user).member().getUserAccounts();
            list.retainAll(productsAccessor.userManagement().getUserAccountsAccess());
            return list;
        }
        return Collections.emptyList();
    }

    public List<AccountType> listAll() {
        return ((DBQuery)this.from().orderBy(((QAccountType)this.$).name.asc())).list((Expression)this.$);
    }

    public List<AccountType> listByCurrency(Currency currency) {
        return ((DBQuery)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{this.$}).where((Predicate)((QAccountType)this.$).currency().eq((Object)currency))).orderBy(((QAccountType)this.$).name.asc())).list((Expression)this.$);
    }

    @Override
    public AccountType newEntity(AccountTypeNature accountTypeNature) {
        if (accountTypeNature == AccountTypeNature.SYSTEM) {
            SystemAccountType systemAccountType = new SystemAccountType();
            systemAccountType.setLimitType(AccountTypeLimitType.UNLIMITED);
            return systemAccountType;
        }
        return new UserAccountType();
    }

    public Page<AccountTypeWithCurrencyVO> search(AccountTypeQuery accountTypeQuery) {
        return this.search(AccountTypeWithCurrencyVO.class, accountTypeQuery);
    }

    public <T> Page<T> search(Class<T> clazz, AccountTypeQuery accountTypeQuery) {
        QDataTranslation qDataTranslation;
        DBQuery<?> dBQuery = this.from();
        if (StringHelper.isNotBlank((Object)accountTypeQuery.getKeywords())) {
            qDataTranslation = QDataTranslation.dataTranslation;
            ((DBQuery)((DBQuery)dBQuery.leftJoin((EntityPath)qDataTranslation)).on((Predicate)qDataTranslation.entityId.eq((Expression)((QAccountType)this.$).id).and((Predicate)qDataTranslation.type.in((Object[])new DataTranslationType[]{DataTranslationType.ACCOUNT_TYPES, DataTranslationType.CURRENCIES})).and((Predicate)qDataTranslation.propertyName.eq((Object)"name")))).where((Predicate)((QAccountType)this.$).name.containsIgnoreCase(accountTypeQuery.getKeywords()).or((Predicate)((QAccountType)this.$).currency().name.containsIgnoreCase(accountTypeQuery.getKeywords())).or((Predicate)qDataTranslation.value.containsIgnoreCase(accountTypeQuery.getKeywords())));
        }
        if (accountTypeQuery.getNature() != null) {
            dBQuery.where((Predicate)((QAccountType)this.$).nature.eq((Object)accountTypeQuery.getNature()));
        }
        if ((qDataTranslation = (Currency)this.conversionHandler.convert(Currency.class, (Object)accountTypeQuery.getCurrency())) != null) {
            dBQuery.where((Predicate)((QAccountType)this.$).currency().eq((Object)qDataTranslation));
        }
        dBQuery.orderBy(new OrderSpecifier[]{((QAccountType)this.$).currency().name.asc(), ((QAccountType)this.$).nature.asc(), ((QAccountType)this.$).name.asc()});
        return dBQuery.page(clazz, (QueryParameters)accountTypeQuery, (Expression)this.$);
    }

    @Override
    public AccountTypeDTO toDTO(AccountType accountType) {
        AccountTypeDTO accountTypeDTO = (AccountTypeDTO)super.toDTO(accountType);
        if (accountType instanceof SystemAccountType) {
            SystemAccountType systemAccountType = (SystemAccountType)accountType;
            SystemAccountTypeDTO systemAccountTypeDTO = (SystemAccountTypeDTO)accountTypeDTO;
            if (accountTypeDTO.isPersistent()) {
                SystemAccount systemAccount = systemAccountType.getAccount();
                systemAccountTypeDTO.setCreditLimit(systemAccount.getCreditLimit());
                systemAccountTypeDTO.setUpperCreditLimit(systemAccount.getUpperCreditLimit());
            }
        }
        return accountTypeDTO;
    }

    @Override
    protected void doRemove(AccountType accountType, boolean bl) {
        if (accountType instanceof SystemAccountType) {
            this.productService.removeAllRelationships((Property)AdminProductDTO.SYSTEM_ACCOUNTS, (SimpleEntity)accountType);
        } else {
            this.productService.removeAllRelationships((Property)UserManagementProductDTO.USER_ACCOUNTS_ACCESS, (SimpleEntity)accountType);
        }
        super.doRemove(accountType, bl);
    }

    @Override
    protected AccountTypeData getData(AccountType accountType) {
        Object object = accountType instanceof UserAccountType ? new UserAccountTypeData() : new SystemAccountTypeData();
        if (accountType.isTransient()) {
            List list = this.currencyService.listAll();
            object.setCurrencies(this.conversionHandler.convertList(CurrencyVOWithDRate.class, (Iterable)list));
            if (list.size() == 1) {
                Currency currency = (Currency)CollectionHelper.first((Iterable)list);
                boolean bl = this.dRateHandler.isEnabled(currency, null);
                object.setShowMaturityFreez(bl);
            } else {
                object.setShowMaturityFreez(false);
            }
        } else {
            object.setShowMaturityFreez(this.dRateHandler.isEnabled(accountType.getCurrency(), null));
            AccountTypeVO accountTypeVO = new AccountTypeVO(accountType.getId());
            TransferTypeQuery transferTypeQuery = new TransferTypeQuery();
            transferTypeQuery.setUnlimited();
            transferTypeQuery.setIncludeDisabled(true);
            transferTypeQuery.setFromAccountTypes(Collections.singleton(accountTypeVO));
            object.setTransferTypes(this.transferTypeService.search(transferTypeQuery).getPageItems());
            TransferFilterQuery transferFilterQuery = new TransferFilterQuery();
            transferFilterQuery.setUnlimited();
            transferFilterQuery.setOwnerAccountType(accountTypeVO);
            transferFilterQuery.setIncludeEmpty(true);
            object.setTransferFilters(this.transferFilterService.search(transferFilterQuery).getPageItems());
            if (object instanceof UserAccountTypeData) {
                UserAccountTypeData userAccountTypeData = object;
                AccountFeeQuery accountFeeQuery = new AccountFeeQuery();
                accountFeeQuery.setUnlimited();
                accountFeeQuery.setAccountType(accountTypeVO);
                accountFeeQuery.setReturnDisabled(true);
                userAccountTypeData.setAccountFees(this.accountFeeService.search(accountFeeQuery).getPageItems());
                TransferTypeQuery transferTypeQuery2 = new TransferTypeQuery();
                transferTypeQuery2.setUnlimited();
                transferTypeQuery2.setNatures(EnumSet.of(TransferTypeNature.GENERATED));
                transferTypeQuery2.setFromAccountTypes(CollectionHelper.asSet((Object[])new AccountTypeVO[]{new AccountTypeVO(accountType.getId())}));
                transferTypeQuery2.setToNature(AccountTypeNature.SYSTEM);
                userAccountTypeData.setDisposePositiveTypes(this.transferTypeService.search(transferTypeQuery2).getPageItems());
                TransferTypeQuery transferTypeQuery3 = new TransferTypeQuery();
                transferTypeQuery3.setUnlimited();
                transferTypeQuery3.setNatures(EnumSet.of(TransferTypeNature.GENERATED));
                transferTypeQuery3.setFromNature(AccountTypeNature.SYSTEM);
                transferTypeQuery3.setToAccountTypes(CollectionHelper.asSet((Object[])new AccountTypeVO[]{new AccountTypeVO(accountType.getId())}));
                userAccountTypeData.setDisposeNegativeTypes(this.transferTypeService.search(transferTypeQuery3).getPageItems());
            }
        }
        object.setDto((EntityDTO)this.toDTO(accountType));
        object.setCurrency((CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)accountType.getCurrency()));
        object.setCustomFields(this.conversionHandler.convertList(CustomFieldVO.class, (Iterable)this.transactionCustomFieldService.listAll().stream().filter(transactionCustomField -> !transactionCustomField.getType().isBinary()).collect(Collectors.toList())));
        return object;
    }

    @Override
    protected void onAfterRemove(AccountType accountType) {
        Long l = SimpleEntity.id((SimpleEntity)accountType.getNetwork());
        Long l2 = SimpleEntity.id((SimpleEntity)accountType.getCurrency());
        this.cacheHandler.schedulePartialEvict(CacheType.TRANSFER_TYPES, (SerializablePredicate & Serializable)transferTypeCacheKey -> transferTypeCacheKey.matches(l, l2));
    }

    @Override
    protected void onAfterSave(AccountType accountType, AccountType accountType2, Object object) {
        Date date;
        SystemAccountType systemAccountType;
        if (accountType instanceof SystemAccountType) {
            BigDecimal bigDecimal;
            SystemAccount systemAccount;
            systemAccountType = (SystemAccountType)accountType;
            date = new Date();
            BigDecimal bigDecimal2 = systemAccountType.getCreditLimit();
            BigDecimal bigDecimal3 = systemAccountType.getUpperCreditLimit();
            boolean bl = false;
            if (accountType2 == null) {
                systemAccount = this.accountService.createSystemAccount(systemAccountType);
                bl = systemAccountType.getLimitType() == AccountTypeLimitType.LIMITED;
            } else {
                systemAccount = systemAccountType.getAccount();
                if (systemAccountType.getLimitType() == AccountTypeLimitType.LIMITED) {
                    bigDecimal = systemAccount.getCreditLimit();
                    BigDecimal bigDecimal4 = systemAccount.getUpperCreditLimit();
                    if (bigDecimal == null != (bigDecimal2 == null)) {
                        throw new IllegalActionException("Cannot change the limit type");
                    }
                    boolean bl2 = bl = !Objects.equals(bigDecimal, bigDecimal2) || !Objects.equals(bigDecimal4, bigDecimal3);
                }
            }
            if (bl) {
                systemAccount.setCreditLimit(bigDecimal2);
                systemAccount.setUpperCreditLimit(bigDecimal3);
                bigDecimal = new AccountBalanceLimitLog();
                bigDecimal.setAccount((Account)systemAccount);
                bigDecimal.setModifiedAt(date);
                bigDecimal.setCreditLimit(bigDecimal2);
                bigDecimal.setUpperCreditLimit(bigDecimal3);
                this.persist((IEntity)bigDecimal);
                this.accountService.sendStatusPushNotification((Account)systemAccount);
            }
        }
        if (accountType2 == null && this.isAdmin()) {
            systemAccountType = (AdminGroup)this.getSessionData().getGroup();
            date = systemAccountType.getAdminProduct();
            if (accountType instanceof SystemAccountType) {
                this.productService.createRelationship((Product)date, (Property)AdminProductDTO.SYSTEM_ACCOUNTS, (SimpleEntity)accountType);
            } else if (accountType instanceof UserAccountType) {
                this.productService.createRelationship((Product)date, (Property)UserManagementProductDTO.USER_ACCOUNTS_ACCESS, (SimpleEntity)accountType);
            }
        }
    }

    @Override
    protected void preProcessCurrentCopy(AccountTypeDTO accountTypeDTO, AccountType accountType) {
        if (accountType instanceof SystemAccountType) {
            SystemAccountType systemAccountType = (SystemAccountType)accountType;
            SystemAccount systemAccount = systemAccountType.getAccount();
            systemAccountType.setCreditLimit(systemAccount.getCreditLimit());
            systemAccountType.setUpperCreditLimit(systemAccount.getUpperCreditLimit());
        }
        accountType.getCustomFieldsForList().size();
        accountType.getCustomFieldsForSearch().size();
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QAccountType)this.$).currency().network(), true);
    }

    @Override
    protected Validator resolveValidator(final AccountTypeDTO accountTypeDTO) {
        Validator validator = new Validator();
        validator.property(AccountTypeDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION).maxLength(1000);
        if (accountTypeDTO.isTransient()) {
            validator.property((Property)AccountTypeDTO.CURRENCY, BankingKeys.AccountTypes.CURRENCY).required().add((PropertyValidation)new BasePropertyValidation(){

                protected boolean isValid(Object object, Object object2, Object object3) {
                    Network network = AccountTypeServiceImpl.this.getSessionData().getNetwork();
                    Currency currency = (Currency)this.getConversionHandler().convert(Currency.class, object3);
                    return Objects.equals(network, currency.getNetwork());
                }
            });
        }
        if (accountTypeDTO.getNature() == AccountTypeNature.SYSTEM) {
            SystemAccountTypeDTO systemAccountTypeDTO = (SystemAccountTypeDTO)accountTypeDTO;
            if (systemAccountTypeDTO.getLimitType() == AccountTypeLimitType.LIMITED) {
                validator.property((Property)SystemAccountTypeDTO.CREDIT_LIMIT, BankingKeys.AccountTypes.CREDIT_LIMIT).required().negativeOrZero();
            }
            validator.property((Property)SystemAccountTypeDTO.UPPER_CREDIT_LIMIT, BankingKeys.AccountTypes.UPPER_CREDIT_LIMIT).positiveOrZero();
        } else {
            validator.property((Property)UserAccountTypeDTO.DEFAULT_YELLOW_BALANCE_RANGE, BankingKeys.AccountTypes.DEFAULT_YELLOW_BALANCE_RANGE).range(RangeOptionalType.BOTH_REQUIRED);
            validator.property((Property)UserAccountTypeDTO.DISPOSE_POSITIVE_TYPE, BankingKeys.AccountTypes.DISPOSE_POSITIVE_TYPE).entity(GeneratedTransferType.class, (EntityValidation)new BaseEntityValidation<GeneratedTransferType>(){

                protected boolean isValid(Object object, Object object2, GeneratedTransferType generatedTransferType) {
                    return generatedTransferType.getFrom().getId().equals(accountTypeDTO.getId()) && generatedTransferType.isToSystem();
                }
            });
            validator.property((Property)UserAccountTypeDTO.DISPOSE_NEGATIVE_TYPE, BankingKeys.AccountTypes.DISPOSE_NEGATIVE_TYPE).entity(GeneratedTransferType.class, (EntityValidation)new BaseEntityValidation<GeneratedTransferType>(){

                protected boolean isValid(Object object, Object object2, GeneratedTransferType generatedTransferType) {
                    return generatedTransferType.isFromSystem() && generatedTransferType.getTo().getId().equals(accountTypeDTO.getId());
                }
            });
        }
        return validator;
    }

    @Override
    protected BidiMap<Class<? extends AccountType>, Class<? extends AccountTypeDTO>> subClassMappings() {
        return SUBCLASS_MAPPINGS;
    }

    static {
        SUBCLASS_MAPPINGS.put(UserAccountType.class, UserAccountTypeDTO.class);
        SUBCLASS_MAPPINGS.put(SystemAccountType.class, SystemAccountTypeDTO.class);
    }
}

