/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.users.BulkActionServiceLocal;
import org.cyclos.impl.utils.tasks.AbstractBackgroundTask;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.scheduledtasks.BackgroundTaskPriority;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ArchiveBulkActionBackgroundTask
extends AbstractBackgroundTask {
    @Autowired
    private BulkActionServiceLocal bulkActionService;

    public MessageKey getMessageKey() {
        return SystemKeys.BackgroundTasks.ARCHIVE_BULK_ACTION;
    }

    public BackgroundTaskPriority getPriority() {
        return BackgroundTaskPriority.LOW;
    }

    @Override
    protected long doExecute(String string, ProfilingEntry profilingEntry) {
        return (Long)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            long l = Long.parseLong(string);
            return this.bulkActionService.archive(l);
        });
    }
}

