/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.AbstractJPAQuery;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.QCurrency;
import org.cyclos.entities.banking.QTransaction;
import org.cyclos.entities.banking.QTransfer;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.CurrencyServiceLocal;
import org.cyclos.impl.banking.RateHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.BeanPropertyAccess;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.impl.utils.validation.PropertyValidation;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.currencies.CurrencyDTO;
import org.cyclos.model.banking.currencies.CurrencyData;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.utils.NumberGenerationDTO;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CurrencyServiceImpl
extends CRUDServiceImpl<Currency, QCurrency, CurrencyDTO, CurrencyData, Void>
implements CurrencyServiceLocal {
    @Autowired
    private RateHandler rateHandler;
    @Autowired
    private AccountServiceLocal accountService;

    public CurrencyServiceImpl() {
        super(Currency.class, QCurrency.currency, CurrencyDTO.class);
    }

    public List<CurrencyVO> list() {
        return this.conversionHandler.convertList(CurrencyVO.class, this.listAll());
    }

    public List<Currency> listAll() throws FrameworkException {
        return ((DBQuery)this.from().orderBy(((QCurrency)this.$).name.asc())).list((Expression)this.$);
    }

    public List<Currency> listForAds(User user) {
        return this.listForAds(user, true);
    }

    public List<Currency> listForAds(User user, boolean bl) {
        List list;
        SessionData sessionData = this.getSessionData();
        boolean bl2 = user != null && !user.equals((Object)sessionData.getLoggedUser());
        HashSet hashSet = new HashSet(bl2 ? this.configurationHandler.getAccessor((BasicUser)user).getVisibleAdCurrencies() : sessionData.getConfiguration().getVisibleAdCurrencies());
        if (sessionData.isGuest()) {
            list = this.listAll();
        } else if (sessionData.isAdmin() || sessionData.isSystem()) {
            list = sessionData.getProducts().grantedCurrencies();
        } else {
            boolean bl3;
            Set<Object> set;
            List list2 = this.accountService.listVisibleCurrencies((InternalAccountOwner)sessionData.getLoggedUser());
            if (bl) {
                List list3 = sessionData.getProducts().member().getViewAdsInOtherCurrencies();
                set = new HashSet(list2);
                set.addAll(list3);
                list = CollectionHelper.sort(set);
            } else {
                list = list2;
            }
            boolean bl4 = bl3 = !bl;
            if (bl2 && bl3) {
                set = this.productsHandler.getAccessor((BasicUser)user).member().getUserAccounts().stream().map(AccountType::getCurrency).collect(Collectors.toSet());
                if (CollectionHelper.isEmpty(set)) {
                    return Collections.emptyList();
                }
                hashSet.addAll(set);
            }
        }
        if (CollectionHelper.isNotEmpty(hashSet)) {
            list.retainAll(hashSet);
        }
        return list;
    }

    @Override
    public Currency newEntity(Void void_) {
        return new Currency();
    }

    @Override
    public CurrencyDTO toDTO(Currency currency) {
        CurrencyDTO currencyDTO = (CurrencyDTO)super.toDTO(currency);
        this.rateHandler.setRateParametersToCurrencyDTO(currencyDTO);
        return currencyDTO;
    }

    @Override
    public Currency toEntity(CurrencyDTO currencyDTO) {
        Currency currency = (Currency)super.toEntity(currencyDTO);
        if (!currencyDTO.isTransactionNumberEnabled()) {
            currency.setTransactionNumber(null);
        }
        this.rateHandler.toEntity(currency, currencyDTO);
        return currency;
    }

    @Override
    protected CurrencyData getData(Currency currency) {
        CurrencyData currencyData = new CurrencyData();
        currencyData.setDto((EntityDTO)this.toDTO(currency));
        return currencyData;
    }

    @Override
    protected void onAfterSave(Currency currency, Currency currency2, Object object) {
        if (currency2 == null) {
            this.rateHandler.resetCurrency(currency);
        }
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QCurrency)this.$).network(), true);
    }

    @Override
    protected Validator resolveValidator(CurrencyDTO currencyDTO) {
        DBQuery dBQuery;
        Validator validator = new Validator();
        validator.property(CurrencyDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION).maxLength(2000);
        org.cyclos.impl.utils.validation.Property property = validator.property((Property)CurrencyDTO.SYMBOL, BankingKeys.Currencies.SYMBOL);
        property.required().maxLength(20);
        if (StringHelper.isNotBlank((Object)currencyDTO.getSymbol())) {
            dBQuery = (DBQuery)this.from(this.$).where((Predicate)((QCurrency)this.$).symbol.eq((Object)currencyDTO.getSymbol()));
            if (currencyDTO.isPersistent()) {
                dBQuery.where((Predicate)((QCurrency)this.$).id.ne((Object)currencyDTO.getId()));
            }
            Long l = SimpleEntity.id((SimpleEntity)this.getSessionData().getNetwork());
            property.unique("currencySymbol_" + l + "_" + currencyDTO.getSymbol(), (AbstractJPAQuery)dBQuery);
        }
        validator.property((Property)CurrencyDTO.PREFIX, BankingKeys.Currencies.CURRENCY_PREFIX).maxLength(20);
        validator.property((Property)CurrencyDTO.SUFFIX, BankingKeys.Currencies.CURRENCY_SUFFIX).maxLength(20);
        validator.property((Property)CurrencyDTO.PRECISION, BankingKeys.Currencies.PRECISION).required().between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(BigDecimalHelper.MAX_SCALE)).add((PropertyValidation)new PrecisionValidator());
        if (currencyDTO.isTransactionNumberEnabled()) {
            dBQuery = new Validator();
            dBQuery.property((Property)NumberGenerationDTO.PREFIX, BankingKeys.Currencies.TRANSACTION_NUMBER_PREFIX).notContains(":").maxLength(40);
            dBQuery.property((Property)NumberGenerationDTO.SUFFIX, BankingKeys.Currencies.TRANSACTION_NUMBER_SUFFIX).notContains(":").maxLength(40);
            dBQuery.property((Property)NumberGenerationDTO.PAD_LENGTH, BankingKeys.Currencies.TRANSACTION_NUMBER_PAD_LENGTH).required().between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(19));
            validator.nested((PropertyAccess)new BeanPropertyAccess((Property)CurrencyDTO.TRANSACTION_NUMBER), (Validator)dBQuery);
        }
        this.rateHandler.resolveValidator(validator, currencyDTO);
        return validator;
    }

    private boolean existsTransactions(Long l) {
        QTransaction qTransaction = QTransaction.transaction1;
        return ((DBQuery)this.from(new EntityPath[]{qTransaction}).where((Predicate)qTransaction.type().from().currency().id.eq((Object)l))).hasResults();
    }

    private boolean existsTransfers(Long l) {
        QTransfer qTransfer = QTransfer.transfer;
        return ((DBQuery)this.from(new EntityPath[]{qTransfer}).where((Predicate)qTransfer.type().from().currency().id.eq((Object)l))).hasResults();
    }

    private final class PrecisionValidator
    implements PropertyValidation {
        private PrecisionValidator() {
        }

        public ValidationError validate(Object object, Object object2, Object object3) {
            CurrencyDTO currencyDTO = (CurrencyDTO)object;
            if (currencyDTO.getPrecision() == null) {
                return null;
            }
            if (!currencyDTO.isTransient()) {
                int n = ((Currency)CurrencyServiceImpl.this.find(currencyDTO.getId())).getPrecision();
                int n2 = currencyDTO.getPrecision();
                if (n2 < n && (CurrencyServiceImpl.this.existsTransfers(currencyDTO.getId()) || CurrencyServiceImpl.this.existsTransactions(currencyDTO.getId()))) {
                    return new ValidationError(BankingKeys.Currencies.ERROR_CANNOT_REDUCE_PRECISION);
                }
            }
            return null;
        }
    }
}

