/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.cyclos.entities.banking.AccountRates;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.DRateCreationValueForTransferType;
import org.cyclos.entities.banking.DRateParameters;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.QAccountRates;
import org.cyclos.entities.banking.QDRateCreationValueForTransferType;
import org.cyclos.entities.banking.QDRateParameters;
import org.cyclos.entities.banking.QRateParameters;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.utils.RatedCurrencyAmount;
import org.cyclos.entities.utils.RatedEntity;
import org.cyclos.impl.banking.BaseRateTypeHandlerImpl;
import org.cyclos.impl.banking.DRateTypeHandlerTestable;
import org.cyclos.impl.banking.FromRatesData;
import org.cyclos.impl.banking.RatesData;
import org.cyclos.impl.banking.TimeBasedRateTypeHandlerImpl;
import org.cyclos.impl.banking.TransferTypeServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.validation.BeanPropertyAccess;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.IEntity;
import org.cyclos.model.Property;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.currencies.CurrencyDTO;
import org.cyclos.model.banking.rates.DRateCreationValueForTransferTypeDTO;
import org.cyclos.model.banking.rates.DRateParametersDTO;
import org.cyclos.model.banking.rates.HasRates;
import org.cyclos.model.banking.rates.RateType;
import org.cyclos.model.banking.transfertypes.MaturityPolicy;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.utils.TimeField;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DRateTypeHandlerImpl
extends TimeBasedRateTypeHandlerImpl<DRateParameters, DRateParametersDTO>
implements DRateTypeHandlerTestable {
    @Autowired
    private TransferTypeServiceLocal transferTypeService;

    @Override
    public void appendToRateParametersHistory(DRateCreationValueForTransferTypeDTO dRateCreationValueForTransferTypeDTO, TransferType transferType) {
        Date date = this.closeDRateCreationValueForTransferTypeInHistory(transferType);
        if (date == null) {
            date = DateHelper.now();
        }
        dRateCreationValueForTransferTypeDTO.setId(null);
        dRateCreationValueForTransferTypeDTO.setTransferType(new TransferTypeVO(transferType.getId()));
        dRateCreationValueForTransferTypeDTO.setStartDate((DateTime)this.conversionHandler.convert(DateTime.class, (Object)date));
        DRateCreationValueForTransferType dRateCreationValueForTransferType = (DRateCreationValueForTransferType)this.conversionHandler.convert(DRateCreationValueForTransferType.class, (Object)dRateCreationValueForTransferTypeDTO);
        transferType.setdRateCreationValue(dRateCreationValueForTransferType);
    }

    public void applyMaturityPolicyChangesForFrom(TransferType transferType, BigDecimal bigDecimal, RatesData ratesData, FromRatesData fromRatesData) {
        PaymentTransferType paymentTransferType;
        Date date = ratesData.getDate();
        if (this.isEnabled(transferType.getCurrency(), date) && transferType instanceof PaymentTransferType && ((paymentTransferType = (PaymentTransferType)transferType).getMaturityPolicy() == MaturityPolicy.ZERO || paymentTransferType.getMaturityPolicy() == MaturityPolicy.HISTORY) && BigDecimalHelper.isPositive((BigDecimal)ratesData.getDRate())) {
            if (fromRatesData.isChangedDueToCreation()) {
                throw new IllegalArgumentException("maturity policy forbids creating units via going negative.");
            }
            RatedCurrencyAmount ratedCurrencyAmount = new RatedCurrencyAmount(ratesData.getVirtualRatedBalance(), (Object)ratesData.getExpirationDate(), transferType.getCurrency());
            Date date2 = this.convert(BigDecimal.ZERO, date);
            RatedCurrencyAmount ratedCurrencyAmount2 = new RatedCurrencyAmount(bigDecimal, (Object)date2, transferType.getCurrency());
            Date date3 = (Date)this.inverseMerge(ratedCurrencyAmount, ratedCurrencyAmount2, date);
            fromRatesData.setEnforcedZeroDRate(true);
            fromRatesData.setTransferD(BigDecimal.ZERO);
            fromRatesData.setTransferExpirationDate(date2);
            fromRatesData.setPreviousD(ratesData.getDRate());
            fromRatesData.setExpirationDate(date3);
            fromRatesData.setDRate(this.convert(date3, date));
        }
    }

    @Override
    public Date closeDRateCreationValueForTransferTypeInHistory(TransferType transferType) {
        DRateCreationValueForTransferType dRateCreationValueForTransferType = transferType.getdRateCreationValue();
        if (dRateCreationValueForTransferType != null) {
            dRateCreationValueForTransferType.setEndDate(DateHelper.now());
            this.entityManagerHandler.persist((IEntity)dRateCreationValueForTransferType);
            transferType.setdRateCreationValue(null);
            return dRateCreationValueForTransferType.getEndDate();
        }
        return null;
    }

    public void complete(RatesData ratesData) {
        if (ratesData.getExpirationDate() != null) {
            ratesData.setDRate(this.convert(ratesData.getExpirationDate(), ratesData.getDate()));
        } else if (ratesData.getDRate() != null) {
            ratesData.setExpirationDate(this.convert(ratesData.getDRate(), ratesData.getDate()));
        }
    }

    public Date convert(BigDecimal bigDecimal, Date date) {
        if (bigDecimal == null) {
            return null;
        }
        Date date2 = date == null ? DateHelper.now() : date;
        return DateHelper.addDecimal((Date)date2, (TimeField)TimeField.DAYS, (double)bigDecimal.doubleValue());
    }

    @Override
    public BigDecimal convert(Date date, Date date2) {
        if (date == null) {
            return null;
        }
        BigDecimal bigDecimal = super.convert(date, date2);
        BigDecimal bigDecimal2 = BigDecimal.ZERO;
        return bigDecimal.max(bigDecimal2);
    }

    public void copy(HasRates hasRates, HasRates hasRates2) {
        if (hasRates != null && hasRates2 != null) {
            hasRates2.setDRate(hasRates.getDRate());
        }
    }

    @Override
    public BigDecimal getDRateConversionResult(RatedCurrencyAmount<Date> ratedCurrencyAmount) {
        Date date;
        Currency currency = ratedCurrencyAmount.getCurrency();
        if (!this.isEnabled(currency, date = ratedCurrencyAmount.getDate())) {
            return null;
        }
        BigDecimal bigDecimal = ratedCurrencyAmount.getAmount();
        return bigDecimal;
    }

    @Override
    public DRateCreationValueForTransferType getDRateCreationValueForTransferType(Long l, Date date) {
        QDRateCreationValueForTransferType qDRateCreationValueForTransferType = QDRateCreationValueForTransferType.dRateCreationValueForTransferType;
        Date date2 = date == null ? DateHelper.now() : date;
        return (DRateCreationValueForTransferType)((DBQuery)this.from(new EntityPath[]{qDRateCreationValueForTransferType}).where(new Predicate[]{qDRateCreationValueForTransferType.transferType().id.eq((Object)l), qDRateCreationValueForTransferType.endDate.after((Comparable)date2).or((Predicate)qDRateCreationValueForTransferType.endDate.isNull()), qDRateCreationValueForTransferType.startDate.before((Comparable)date2).or((Predicate)qDRateCreationValueForTransferType.startDate.eq((Object)date2))})).singleResult((Expression)qDRateCreationValueForTransferType);
    }

    public Date getNullSafeRawRate(RatedEntity ratedEntity, Currency currency, Date date) {
        if (ratedEntity == null || ratedEntity.getExpirationDate() == null) {
            return this.getInitValue(currency, date);
        }
        return this.getRawRate(ratedEntity, date);
    }

    public DRateParameters getRateParameters(Currency currency) {
        return currency.getdRateParameters();
    }

    public DRateParametersDTO getRateParametersDTO(CurrencyDTO currencyDTO) {
        return currencyDTO.getDRateParameters();
    }

    public RateType getRateType() {
        return RateType.D;
    }

    public void setRate(HasRates hasRates, BigDecimal bigDecimal) {
        hasRates.setDRate(bigDecimal);
    }

    public void setRawRate(RatedEntity ratedEntity, Date date) {
        ratedEntity.setExpirationDate(date);
    }

    public void toEntity(TransferType transferType, DRateCreationValueForTransferTypeDTO dRateCreationValueForTransferTypeDTO) {
        BaseRateTypeHandlerImpl.RateParametersChangeAction rateParametersChangeAction = this.haveRateParametersChanged(transferType, dRateCreationValueForTransferTypeDTO);
        switch (rateParametersChangeAction) {
            case NORATES: 
            case UNCHANGED: {
                break;
            }
            case ENABLED_ANEW: {
                this.appendToRateParametersHistory(dRateCreationValueForTransferTypeDTO, transferType);
                break;
            }
            case CHANGED: {
                this.appendToRateParametersHistory(dRateCreationValueForTransferTypeDTO, transferType);
                break;
            }
            case DISABLED_ANEW: {
                this.closeDRateCreationValueForTransferTypeInHistory(transferType);
                break;
            }
        }
    }

    @Override
    protected void assignEntityToCurrency(DRateParameters dRateParameters, Currency currency) {
        currency.setdRateParameters(dRateParameters);
    }

    @Override
    protected void assignValidator(Validator validator, Validator validator2) {
        validator2.property((Property)DRateParametersDTO.INIT_VALUE, BankingKeys.Rates.D_INIT_VALUE).required();
        validator2.property((Property)DRateParametersDTO.CREATION_VALUE, BankingKeys.Rates.D_CREATION_VALUE).required().greaterEquals((Comparable)Integer.valueOf(0));
        validator.nested((PropertyAccess)new BeanPropertyAccess((Property)CurrencyDTO.D_RATE_PARAMETERS), validator2);
    }

    @Override
    protected BigDecimal calculateRateChange(BigDecimal bigDecimal, Date date, Date date2) {
        Date date3 = date2 == null ? DateHelper.now() : date2;
        BigDecimal bigDecimal2 = new BigDecimal(DateHelper.daysBetween((Date)date3, (Date)date));
        BigDecimal bigDecimal3 = bigDecimal.add(bigDecimal2);
        return bigDecimal3;
    }

    @Override
    protected Path getAccountRatesFieldPath() {
        QAccountRates qAccountRates = QAccountRates.accountRates;
        return qAccountRates.expirationDate;
    }

    @Override
    protected DRateParameters getCurrentRateParameters(Currency currency) {
        return currency.getdRateParameters();
    }

    @Override
    protected Class<DRateParameters> getEntityClass() {
        return DRateParameters.class;
    }

    @Override
    protected List<DRateParameters> getParametersList() {
        QDRateParameters qDRateParameters = QDRateParameters.dRateParameters;
        return this.from(new EntityPath[]{qDRateParameters}).list((Expression)qDRateParameters);
    }

    @Override
    protected QRateParameters getQuery() {
        return QDRateParameters.dRateParameters._super._super;
    }

    @Override
    protected boolean hasEqualProperties(DRateParameters dRateParameters, DRateParametersDTO dRateParametersDTO) {
        boolean bl = super.hasEqualProperties(dRateParameters, dRateParametersDTO);
        if (!bl) {
            return false;
        }
        return dRateParameters.getCreationValue().equals(dRateParametersDTO.getCreationValue());
    }

    @Override
    protected void immediateDisableActions(Currency currency) {
        super.immediateDisableActions(currency);
        this.transferTypeService.resetAllMaturityPolicy(currency);
    }

    private Date getRawRate(RatedEntity ratedEntity, Date date) {
        AccountRates accountRates;
        if (ratedEntity instanceof AccountRates && (accountRates = (AccountRates)ratedEntity).getAccount().getType().isMaturityFreeze()) {
            Date date2 = accountRates.getExpirationDate();
            Date date3 = accountRates.getTime();
            double d = DateHelper.daysBetween((Date)date3, (Date)date2);
            Date date4 = DateHelper.addDecimal((Date)date, (TimeField)TimeField.DAYS, (double)d);
            return date4;
        }
        return ratedEntity.getExpirationDate();
    }

    private BaseRateTypeHandlerImpl.RateParametersChangeAction haveRateParametersChanged(TransferType transferType, DRateCreationValueForTransferTypeDTO dRateCreationValueForTransferTypeDTO) {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2;
        BigDecimal bigDecimal3 = bigDecimal2 = dRateCreationValueForTransferTypeDTO == null ? null : dRateCreationValueForTransferTypeDTO.getCreationValue();
        if (transferType.isTransient()) {
            if (dRateCreationValueForTransferTypeDTO == null || bigDecimal2 == null) {
                return BaseRateTypeHandlerImpl.RateParametersChangeAction.NORATES;
            }
            return BaseRateTypeHandlerImpl.RateParametersChangeAction.ENABLED_ANEW;
        }
        DRateCreationValueForTransferType dRateCreationValueForTransferType = this.getDRateCreationValueForTransferType(transferType.getId(), null);
        if (dRateCreationValueForTransferTypeDTO == null || bigDecimal2 == null) {
            return dRateCreationValueForTransferType == null ? BaseRateTypeHandlerImpl.RateParametersChangeAction.NORATES : BaseRateTypeHandlerImpl.RateParametersChangeAction.DISABLED_ANEW;
        }
        if (dRateCreationValueForTransferTypeDTO.getId() == null) {
            return BaseRateTypeHandlerImpl.RateParametersChangeAction.ENABLED_ANEW;
        }
        BigDecimal bigDecimal4 = bigDecimal = dRateCreationValueForTransferType == null ? null : dRateCreationValueForTransferType.getCreationValue();
        if (BigDecimalHelper.areEquals((BigDecimal)bigDecimal, (BigDecimal)bigDecimal2)) {
            return BaseRateTypeHandlerImpl.RateParametersChangeAction.UNCHANGED;
        }
        return BaseRateTypeHandlerImpl.RateParametersChangeAction.CHANGED;
    }

    @Override
    void applyTransferTypeDefaults(RatesData ratesData, TransferType transferType) {
        if (transferType.getdRateCreationValue() != null) {
            ratesData.setDRate(transferType.getdRateCreationValue().getCreationValue());
            Date date = this.convert(transferType.getdRateCreationValue().getCreationValue(), ratesData.getDate());
            ratesData.setExpirationDate(date);
        }
    }
}

