/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.DateTimeExpression;
import java.util.Collection;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.QBasePayment;
import org.cyclos.entities.banking.QPaymentTransferType;
import org.cyclos.impl.banking.TransactionAuthorizationServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.tasks.EntityBatchRecurringTask;
import org.cyclos.model.banking.transactions.TransactionAuthorizationStatus;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.utils.RecurringTaskRecurrence;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExpirePendingAuthorizationPaymentRecurringTask
extends EntityBatchRecurringTask<BasePayment> {
    @Autowired
    private TransactionAuthorizationServiceLocal authorizationServiceLocal;

    public ExpirePendingAuthorizationPaymentRecurringTask() {
        super(BasePayment.class);
    }

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.EXPIRE_PENDING_AUTHORIZATION_PAYMENT;
    }

    @Override
    public RecurringTaskRecurrence getRecurrence() {
        return RecurringTaskRecurrence.EVERY_DAY;
    }

    @Override
    protected void finish(BasePayment basePayment, Throwable throwable) throws Throwable {
    }

    @Override
    protected Collection<Long> nextIds() throws Throwable {
        QBasePayment qBasePayment = QBasePayment.basePayment;
        QPaymentTransferType qPaymentTransferType = QPaymentTransferType.paymentTransferType;
        return ((DBQuery)((DBQuery)((DBQuery)this.from(new EntityPath[]{qBasePayment}).innerJoin((EntityPath)qBasePayment.type(), (Path)qPaymentTransferType._super)).where((Predicate)qBasePayment.authorizationStatus.eq((Object)TransactionAuthorizationStatus.PENDING_AUTHORIZATION).and((Predicate)qPaymentTransferType.authorizationExpirationPeriod().isNotNull()).and((Predicate)qBasePayment.date.addInterval((Expression)qPaymentTransferType.authorizationExpirationPeriod()).before((Expression)DateTimeExpression.currentTimestamp())))).limit(200L)).list((Expression)qBasePayment.id);
    }

    @Override
    protected void process(BasePayment basePayment) throws Throwable {
        this.authorizationServiceLocal.expire(basePayment);
    }
}

