/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import org.cyclos.entities.banking.ExternalPayment;
import org.cyclos.entities.users.User;
import org.cyclos.impl.banking.ExternalPaymentServiceLocal;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.utils.tasks.AbstractBackgroundTask;
import org.cyclos.impl.utils.tasks.BackgroundTaskScheduling;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.system.scheduledtasks.BackgroundTaskPriority;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExternalPaymentBackgroundTask
extends AbstractBackgroundTask {
    @Autowired
    private ExternalPaymentServiceLocal externalPaymentService;

    public static BackgroundTaskScheduling scheduling(ExternalPayment externalPayment, User user) {
        String string = externalPayment.getId() + "," + user.getId();
        return new BackgroundTaskScheduling(ExternalPaymentBackgroundTask.class, (Object)string, "Process external payment " + externalPayment.getTransactionNumberOrId() + " for user " + user.getUsername());
    }

    public MessageKey getMessageKey() {
        return SystemKeys.BackgroundTasks.PROCESS_EXTERNAL_PAYMENT;
    }

    public BackgroundTaskPriority getPriority() {
        return BackgroundTaskPriority.HIGH;
    }

    @Override
    protected long doExecute(String string, ProfilingEntry profilingEntry) {
        String[] stringArray = string.split(",");
        Long l = Long.parseLong(stringArray[0]);
        Long l2 = Long.parseLong(stringArray[1]);
        this.externalPaymentService.processExternalPayment(l, l2);
        return 1L;
    }
}

