/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.access.CustomFieldPrincipalType;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.access.QPrincipalType;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.ExternalPayment;
import org.cyclos.entities.banking.Payment;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.QExternalPayment;
import org.cyclos.entities.banking.QPaymentTransferType;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.PaymentPrincipalsConfiguration;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserCustomField;
import org.cyclos.entities.users.UserCustomFieldValue;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.DirectUserSessionData;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.access.PrincipalTypeServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.ExternalPaymentBackgroundTask;
import org.cyclos.impl.banking.ExternalPaymentServiceLocal;
import org.cyclos.impl.banking.LocateAccountOwnerResult;
import org.cyclos.impl.banking.PaymentServiceLocal;
import org.cyclos.impl.banking.PaymentTransferTypeQuery;
import org.cyclos.impl.banking.PrepareValidationParameter;
import org.cyclos.impl.banking.TransactionServiceLocal;
import org.cyclos.impl.banking.TransactionValidationData;
import org.cyclos.impl.banking.TransferFeeServiceLocal;
import org.cyclos.impl.banking.TransferTypeServiceLocal;
import org.cyclos.impl.messaging.ErrorLogServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ExtensionPointAccessor;
import org.cyclos.impl.system.ExtensionPointFilter;
import org.cyclos.impl.system.ExtensionPointServiceLocal;
import org.cyclos.impl.users.PhoneServiceLocal;
import org.cyclos.impl.users.UserCustomFieldServiceLocal;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.utils.LinkGeneratorHandler;
import org.cyclos.impl.utils.PhoneNumberDescriptor;
import org.cyclos.impl.utils.PhoneNumberHandler;
import org.cyclos.impl.utils.notifications.MailHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.sms.OutboundSmsHandler;
import org.cyclos.impl.utils.tasks.BackgroundTaskHandler;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.PasswordException;
import org.cyclos.model.access.principaltypes.ExistingBuiltInPrincipalType;
import org.cyclos.model.access.principaltypes.PrincipalTypeInputVO;
import org.cyclos.model.access.principaltypes.PrincipalTypeNature;
import org.cyclos.model.access.principaltypes.PrincipalTypeVO;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.ExternalAccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SingletonAccountOwner;
import org.cyclos.model.banking.transactions.AbstractPaymentTypeData;
import org.cyclos.model.banking.transactions.BasePaymentPreviewVO;
import org.cyclos.model.banking.transactions.ExternalPaymentAction;
import org.cyclos.model.banking.transactions.ExternalPaymentActionDTO;
import org.cyclos.model.banking.transactions.ExternalPaymentData;
import org.cyclos.model.banking.transactions.ExternalPaymentPreviewVO;
import org.cyclos.model.banking.transactions.ExternalPaymentStatus;
import org.cyclos.model.banking.transactions.ExternalPaymentVO;
import org.cyclos.model.banking.transactions.ManageExternalPaymentConfirmationField;
import org.cyclos.model.banking.transactions.PaymentCreationType;
import org.cyclos.model.banking.transactions.PerformExternalPaymentConfirmationField;
import org.cyclos.model.banking.transactions.PerformExternalPaymentDTO;
import org.cyclos.model.banking.transactions.PerformExternalPaymentData;
import org.cyclos.model.banking.transactions.PerformExternalPaymentTypeData;
import org.cyclos.model.banking.transactions.PerformTransactionDTO;
import org.cyclos.model.banking.transactions.TransactionStatus;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.banking.transfertypes.TransferTypeWithCurrencyVO;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.messaging.sms.OutboundSmsType;
import org.cyclos.model.system.extensionpoints.ExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.TransactionExtensionPointEvent;
import org.cyclos.model.system.fields.CustomFieldType;
import org.cyclos.model.users.phones.PhoneListData;
import org.cyclos.model.users.phones.PhoneNature;
import org.cyclos.model.users.phones.PhoneVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.ICurrencyAmount;
import org.cyclos.model.utils.TimeField;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ExceptionTranslationHelper;
import org.cyclos.utils.MaskHelper;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.TranslationMessageSpecification;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExternalPaymentServiceImpl
extends BaseServiceImpl
implements ExternalPaymentServiceLocal {
    private static final QExternalPayment $ = QExternalPayment.externalPayment;
    @Autowired
    private TransactionServiceLocal transactionService;
    @Autowired
    private TransferFeeServiceLocal transferFeeService;
    @Autowired
    private UserCustomFieldServiceLocal userCustomFieldService;
    @Autowired
    private PhoneServiceLocal phoneService;
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private PrincipalTypeServiceLocal principalTypeService;
    @Autowired
    private PaymentServiceLocal paymentService;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private UserServiceLocal userService;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private MailHandler mailHandler;
    @Autowired
    private LinkGeneratorHandler linkGeneratorHandler;
    @Autowired
    private PasswordHandler passwordHandler;
    @Autowired
    private ExtensionPointServiceLocal extensionPointService;
    @Autowired
    private ErrorLogServiceLocal errorLogService;
    @Autowired
    private BackgroundTaskHandler backgroundTaskHandler;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private OutboundSmsHandler outboundSmsHandler;
    @Autowired
    private TransferTypeServiceLocal transferTypeService;
    @Autowired
    private PhoneNumberHandler phoneNumberHandler;

    public void cancel(ExternalPaymentActionDTO externalPaymentActionDTO) {
        ExternalPayment externalPayment = this.validateActionAndGet(externalPaymentActionDTO, ExternalPaymentStatus.PENDING, ExternalPaymentAction.CANCEL);
        this.cancel(externalPayment, externalPaymentActionDTO.getComments(), true);
    }

    public int cancelAll(UserAccount userAccount) {
        if (userAccount.isTransient()) {
            return 0;
        }
        CloseableIterator closeableIterator = ((DBQuery)this.from(new EntityPath[]{$}).where(new Predicate[]{$.from().eq((Object)userAccount), ExternalPaymentServiceImpl.$.status.eq((Object)ExternalPaymentStatus.PENDING.name())})).iterate((Expression)$);
        return (int)this.processBatch(closeableIterator, (T externalPayment) -> this.cancel((ExternalPayment)externalPayment, null, true));
    }

    public void expire(ExternalPayment externalPayment) {
        if (externalPayment.getStatus() != ExternalPaymentStatus.PENDING) {
            throw new IllegalActionException();
        }
        ExtensionPointAccessor extensionPointAccessor = this.transactionService.setStatusAndGetExtensionPoint((Transaction)externalPayment, (TransactionStatus)ExternalPaymentStatus.EXPIRED);
        this.accountService.dereserveAmount(externalPayment);
        PrincipalType principalType = externalPayment.getToPrincipalType();
        String string = principalType.getName();
        String string2 = externalPayment.getToPrincipalValue();
        String string3 = this.message(BankingKeys.Transactions.EXTERNAL_PAYMENT_PAYEE_INFO, string, string2);
        if (externalPayment.isFromUser()) {
            this.notificationHandler.user((BasicUser)externalPayment.getFromUser()).account().externalPaymentExpired((Transaction)externalPayment, externalPayment.getDate(), externalPayment.getCurrencyAmount(), externalPayment.getType(), string3);
        }
        this.notificationHandler.admin().externalPaymentExpired(externalPayment, string3);
        if (this.principalIsEmail(principalType)) {
            this.sendMailToExternalUser(externalPayment, ContentManagementKeys.Emails.EXTERNAL_PAYMENT_EXPIRED_SUBJECT, ContentManagementKeys.Emails.EXTERNAL_PAYMENT_EXPIRED_BODY);
        } else if (this.principalIsMobile(principalType)) {
            this.sendSMSToExternalUser(externalPayment, BankingKeys.Transactions.EXTERNAL_PAYMENT_SMS_EXPIRED);
        }
        extensionPointAccessor.fireSaved();
    }

    public ExternalPayment findByToken(String string) {
        return (ExternalPayment)((DBQuery)this.from(new EntityPath[]{$}).where((Predicate)ExternalPaymentServiceImpl.$.token.eq((Object)string.trim()))).singleResult((Expression)$);
    }

    public ExternalPaymentData getData(ExternalPayment externalPayment) {
        ExternalPaymentData externalPaymentData = (ExternalPaymentData)this.transactionService.newData((Transaction)externalPayment, true);
        externalPaymentData.setCanCancel(externalPayment.getStatus() == ExternalPaymentStatus.PENDING);
        return externalPaymentData;
    }

    public ExternalPaymentData getData(Long l) {
        ExternalPayment externalPayment = this.find(ExternalPayment.class, l);
        return this.getData(externalPayment);
    }

    public PerformExternalPaymentData getExternalPaymentData(InternalAccountOwner internalAccountOwner) {
        SessionData sessionData = this.getSessionData();
        PerformExternalPaymentData performExternalPaymentData = new PerformExternalPaymentData();
        LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locateOrCurrent((AccountOwner)internalAccountOwner);
        internalAccountOwner = locateAccountOwnerResult.getInternalAccountOwner();
        performExternalPaymentData.setExternalPaymentTypeData(this.getExternalPaymentTypeData(internalAccountOwner, null));
        performExternalPaymentData.setFrom(this.accountHandler.toAccountOwnerVO(internalAccountOwner));
        performExternalPaymentData.setFromPrincipalType((PrincipalTypeVO)this.conversionHandler.convert(PrincipalTypeVO.class, (Object)locateAccountOwnerResult.getPrincipalType()));
        List<PaymentTransferType> list = this.listPossiblePaymentTypesToPerformExternalPayment(internalAccountOwner);
        performExternalPaymentData.setPaymentTypes(this.conversionHandler.convertList(TransferTypeWithCurrencyVO.class, list));
        PaymentPrincipalsConfiguration paymentPrincipalsConfiguration = sessionData.getChannelSettingsAccessor().getPayment();
        ArrayList<PrincipalType> arrayList = new ArrayList<PrincipalType>(paymentPrincipalsConfiguration.getPrincipalTypes());
        PrincipalType principalType2 = paymentPrincipalsConfiguration.getDefaultPrincipalType();
        arrayList.removeIf(principalType -> !principalType.isUsedExternalPayment());
        if (principalType2 != null && !principalType2.isUsedExternalPayment()) {
            principalType2 = null;
        }
        this.principalTypeService.sort(arrayList);
        performExternalPaymentData.setPrincipalTypes(this.conversionHandler.convertList(PrincipalTypeInputVO.class, arrayList));
        performExternalPaymentData.setDefaultPrincipalType((PrincipalTypeInputVO)this.conversionHandler.convert(PrincipalTypeInputVO.class, (Object)principalType2));
        Set set = list.stream().map(TransferType::getFrom).collect(Collectors.toSet());
        InternalAccountOwner internalAccountOwner2 = internalAccountOwner;
        performExternalPaymentData.setAccounts(set.stream().sorted().map(accountType -> this.accountService.load(internalAccountOwner2, accountType)).map(object -> this.accountService.toAccountWithStatus((Account)object, null, null, false)).collect(Collectors.toList()));
        return performExternalPaymentData;
    }

    public PerformExternalPaymentTypeData getExternalPaymentTypeData(InternalAccountOwner internalAccountOwner, TransferTypeVO transferTypeVO) throws FrameworkException {
        PerformExternalPaymentTypeData performExternalPaymentTypeData;
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)transferTypeVO);
        if (paymentTransferType == null && !(performExternalPaymentTypeData = this.listPossiblePaymentTypesToPerformExternalPayment(internalAccountOwner)).isEmpty()) {
            paymentTransferType = (PaymentTransferType)CollectionHelper.first((Iterable)performExternalPaymentTypeData);
        }
        if (paymentTransferType != null) {
            performExternalPaymentTypeData = new PerformExternalPaymentTypeData();
            this.transactionService.fill((AbstractPaymentTypeData)performExternalPaymentTypeData, this.accountHandler.locateOrCurrent((AccountOwner)internalAccountOwner), LocateAccountOwnerResult.external(), paymentTransferType);
            return performExternalPaymentTypeData;
        }
        return null;
    }

    public List<PaymentTransferType> listPossiblePaymentTypesToPerformExternalPayment(InternalAccountOwner internalAccountOwner) {
        LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locate((AccountOwner)internalAccountOwner);
        InternalAccountOwner internalAccountOwner2 = locateAccountOwnerResult.getInternalAccountOwner();
        PaymentTransferTypeQuery paymentTransferTypeQuery = new PaymentTransferTypeQuery();
        paymentTransferTypeQuery.setUnlimited();
        paymentTransferTypeQuery.setFromOwner(internalAccountOwner2);
        paymentTransferTypeQuery.setFromAccounts((Collection)this.accountService.listVisible(internalAccountOwner2));
        return this.transferTypeService.searchExternalPayment(paymentTransferTypeQuery).getPageItems();
    }

    public ExternalPaymentVO perform(PerformExternalPaymentDTO performExternalPaymentDTO) throws FrameworkException, TransferException, PasswordException {
        Object object;
        CustomFieldType customFieldType;
        LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locateOrCurrent((AccountOwner)performExternalPaymentDTO.getOwner());
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)performExternalPaymentDTO.getType());
        performExternalPaymentDTO.setOwner(locateAccountOwnerResult.getInternalAccountOwner());
        this.validate(performExternalPaymentDTO);
        BigDecimal bigDecimal = BigDecimalHelper.round((BigDecimal)performExternalPaymentDTO.getAmount(), (int)paymentTransferType.getCurrency().getPrecision());
        this.transactionService.validatePaymentAmount(locateAccountOwnerResult, this.accountHandler.locate((AccountOwner)ExternalAccountOwner.instance()), paymentTransferType, bigDecimal, null);
        if (this.transactionService.isCheckConfirmation(paymentTransferType, locateAccountOwnerResult.getInternalAccountOwner(), bigDecimal, DateHelper.now())) {
            this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(performExternalPaymentDTO.getConfirmationPassword(), PerformExternalPaymentConfirmationField.confirmation((PerformExternalPaymentDTO)performExternalPaymentDTO));
        }
        Account account = this.accountService.load(locateAccountOwnerResult.getInternalAccountOwner(), paymentTransferType.getFrom());
        ExtensionPointAccessor extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)TransactionExtensionPointEvent.CONFIRM, new ExtensionPointFilter((TransferType)paymentTransferType)).attribute("performTransaction", (Object)performExternalPaymentDTO).attribute("fromAccount", (Object)account).attribute("fromOwner", (Object)locateAccountOwnerResult.getAccountOwner()).attribute("fromOwnerResult", (Object)locateAccountOwnerResult).attribute("toAccount", null).attribute("toOwner", (Object)ExternalAccountOwner.instance()).attribute("toOwnerResult", (Object)LocateAccountOwnerResult.instance((SingletonAccountOwner)ExternalAccountOwner.instance())).attribute("paymentType", (Object)paymentTransferType);
        extensionPointAccessor.fireValidated();
        ExternalPayment externalPayment = new ExternalPayment();
        this.transactionService.fill((Transaction)externalPayment, (TransferType)paymentTransferType, PaymentCreationType.EXTERNAL, account, null, null, null, null, bigDecimal, performExternalPaymentDTO.getDescription(), (Collection)performExternalPaymentDTO.getCustomValues());
        PrincipalType principalType = (PrincipalType)this.conversionHandler.convert(PrincipalType.class, (Object)performExternalPaymentDTO.getToPrincipalType());
        externalPayment.setToPrincipalType(principalType);
        String string = performExternalPaymentDTO.getToPrincipalValue();
        if (principalType instanceof CustomFieldPrincipalType && (customFieldType = (object = ((CustomFieldPrincipalType)principalType).getCustomField()).getType()) == CustomFieldType.STRING) {
            string = MaskHelper.removeMask((String)object.getPattern(), (String)string);
        }
        externalPayment.setToPrincipalValue(string);
        if (this.principalIsMobile(principalType)) {
            externalPayment.setToPrincipalValue(this.phoneNumberHandler.tryNormalize(string, this.getConfiguration()));
        }
        externalPayment.setStatus(ExternalPaymentStatus.PENDING);
        externalPayment.setExpirationDate(this.getExpirationDate());
        object = null;
        while (this.findByToken((String)(object = StringHelper.randomAlphanumeric((int)32))) != null) {
        }
        externalPayment.setToken((String)object);
        this.transactionService.persist((Transaction)externalPayment);
        this.accountService.reserveAmount(externalPayment);
        if (this.principalIsEmail(principalType)) {
            this.sendMailToExternalUser(externalPayment, ContentManagementKeys.Emails.EXTERNAL_PAYMENT_RECEIVED_SUBJECT, ContentManagementKeys.Emails.EXTERNAL_PAYMENT_RECEIVED_BODY);
        } else if (this.principalIsMobile(principalType)) {
            this.sendSMSToExternalUser(externalPayment, BankingKeys.Transactions.EXTERNAL_PAYMENT_SMS_RECEIVED);
        }
        extensionPointAccessor.attribute("transaction", (Object)externalPayment).fireSaved();
        customFieldType = (ExternalPaymentVO)this.conversionHandler.convert(ExternalPaymentVO.class, (Object)externalPayment);
        return customFieldType;
    }

    public ExternalPaymentPreviewVO preview(PerformExternalPaymentDTO performExternalPaymentDTO) {
        LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locateOrCurrent((AccountOwner)performExternalPaymentDTO.getOwner());
        InternalAccountOwner internalAccountOwner = locateAccountOwnerResult.getInternalAccountOwner();
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)performExternalPaymentDTO.getType());
        this.validate(performExternalPaymentDTO);
        BigDecimal bigDecimal = performExternalPaymentDTO.getAmount();
        if (bigDecimal == null && paymentTransferType.isUseFixedAmount()) {
            bigDecimal = paymentTransferType.getFixedAmount();
            performExternalPaymentDTO.setAmount(bigDecimal);
        }
        this.customFieldValueHandler.resolveValues(TransactionCustomField.class, (Collection)performExternalPaymentDTO.getCustomValues());
        ExternalPaymentPreviewVO externalPaymentPreviewVO = this.preview(performExternalPaymentDTO, paymentTransferType, locateAccountOwnerResult, bigDecimal);
        if (!BigDecimalHelper.isPositive((BigDecimal)externalPaymentPreviewVO.getMainAmount().getAmount())) {
            throw new ValidationException(this.message(BankingKeys.Transfers.ERROR_INVALID_AMOUNT, new Object[0]));
        }
        externalPaymentPreviewVO.setConfirmationMessage(this.getTranslatedValue((BaseEntity)paymentTransferType, QPaymentTransferType.paymentTransferType.confirmationMessage));
        if (this.transactionService.isCheckConfirmation(paymentTransferType, internalAccountOwner, performExternalPaymentDTO.getAmount(), DateHelper.now())) {
            externalPaymentPreviewVO.setConfirmationPasswordInput(this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).getCredentialInput());
        }
        externalPaymentPreviewVO.setSkipConfirmation(externalPaymentPreviewVO.getConfirmationPasswordInput() == null && paymentTransferType.isSkipConfirmation());
        Account account = this.accountService.load(internalAccountOwner, paymentTransferType.getFrom());
        LocateAccountOwnerResult locateAccountOwnerResult2 = LocateAccountOwnerResult.external();
        ExtensionPointAccessor extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)TransactionExtensionPointEvent.PREVIEW, new ExtensionPointFilter((TransferType)paymentTransferType)).attribute("performTransaction", (Object)performExternalPaymentDTO).attribute("paymentType", (Object)paymentTransferType).attribute("fromAccount", (Object)account).attribute("fromOwner", (Object)internalAccountOwner).attribute("fromOwnerResult", (Object)locateAccountOwnerResult).attribute("toAccount", null).attribute("toOwner", (Object)ExternalAccountOwner.instance()).attribute("toOwnerResult", (Object)locateAccountOwnerResult2).attribute("preview", (Object)externalPaymentPreviewVO);
        extensionPointAccessor.fireValidated();
        this.transactionService.updatePreviewAndPayment((BasePaymentPreviewVO)externalPaymentPreviewVO, (PerformTransactionDTO)performExternalPaymentDTO, locateAccountOwnerResult, locateAccountOwnerResult2, (TransferType)paymentTransferType, null);
        extensionPointAccessor.fireSaved();
        return externalPaymentPreviewVO;
    }

    public boolean processExternalPayment(Long l, Long l2) {
        SessionData sessionData = (SessionData)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            ExternalPayment externalPayment = this.find(ExternalPayment.class, l);
            return (DirectUserSessionData)this.invokerHandler.runAs(SessionDataFactory.system((Network)externalPayment.getNetwork()), () -> {
                BasicUser basicUser = (BasicUser)ObjectHelper.defaultValue((Object)externalPayment.getBy(), (Object)externalPayment.getFromUser());
                return SessionDataFactory.direct((BasicUser)basicUser).channel(externalPayment.getChannel().getInternalName()).build();
            });
        });
        try {
            return (Boolean)this.invokerHandler.runAsInTransaction(sessionData, TransactionLevel.READ_WRITE, transactionStatus -> {
                ExternalPayment externalPayment = (ExternalPayment)this.rawEntityManagerHandler.find(ExternalPayment.class, l);
                if (externalPayment.getStatus() != ExternalPaymentStatus.PENDING) {
                    return false;
                }
                ExtensionPointAccessor extensionPointAccessor = this.transactionService.setStatusAndGetExtensionPoint((Transaction)externalPayment, (TransactionStatus)ExternalPaymentStatus.PROCESSED);
                externalPayment.setStatus(ExternalPaymentStatus.PENDING);
                User user = (User)this.rawEntityManagerHandler.find(User.class, l2);
                Payment payment = this.paymentService.acceptExternalPayment(externalPayment, user);
                externalPayment.setPayment(payment);
                externalPayment.setStatus(ExternalPaymentStatus.PROCESSED);
                extensionPointAccessor.fireSaved();
                return true;
            });
        }
        catch (Throwable throwable) {
            this.invokerHandler.runAsInTransaction(sessionData, TransactionLevel.READ_WRITE, transactionStatus -> {
                ExternalPayment externalPayment = (ExternalPayment)this.rawEntityManagerHandler.find(ExternalPayment.class, l);
                ExtensionPointAccessor extensionPointAccessor = this.transactionService.setStatusAndGetExtensionPoint((Transaction)externalPayment, (TransactionStatus)ExternalPaymentStatus.FAILED);
                User user = (User)this.rawEntityManagerHandler.find(User.class, l2);
                if (throwable instanceof TransferException) {
                    TranslationMessageSpecification translationMessageSpecification = ExceptionTranslationHelper.getForTransferException((TransferException)((TransferException)throwable));
                    externalPayment.setComments(this.message(translationMessageSpecification.getKey(), translationMessageSpecification.getArguments()));
                } else if (throwable instanceof ValidationException) {
                    externalPayment.setComments(((ValidationException)throwable).getValidation().getFirstError());
                } else {
                    StringWriter stringWriter = new StringWriter();
                    throwable.printStackTrace(new PrintWriter(stringWriter));
                    String string = stringWriter.toString();
                    String string2 = Thread.currentThread().getStackTrace()[1].getMethodName();
                    this.errorLogService.create(string2, String.format("{\"externalPaymentId\": %s, \"toUserId\": %s}", l, l2), string, null, null);
                    externalPayment.setComments(this.message(BankingKeys.Transactions.EXTERNAL_PAYMENT_ERROR_UNKNOWN, new Object[0]));
                }
                if (externalPayment.getAmountDereservation() == null) {
                    this.accountService.dereserveAmount(externalPayment);
                }
                extensionPointAccessor.fireSaved();
                this.sendFailedPaymentNotification(user, externalPayment);
                return null;
            });
            return false;
        }
    }

    public int processExternalPayments(User user) {
        if (!AccountServiceLocal.POSSIBLE_STATUSES_TO_OWN_ACCOUNTS.contains(user.getStatus())) {
            return 0;
        }
        List<ExternalPayment> list = this.getExternalPaymentsToProcess(user);
        if (list == null) {
            return 0;
        }
        for (ExternalPayment externalPayment : list) {
            if (user.equals((Object)externalPayment.getFromUser())) {
                this.cancel(externalPayment, null, false);
                continue;
            }
            this.backgroundTaskHandler.schedule(ExternalPaymentBackgroundTask.scheduling(externalPayment, user));
        }
        return list.size();
    }

    protected boolean principalIsEmail(PrincipalType principalType) {
        return principalType.getInternalName().equals(ExistingBuiltInPrincipalType.EMAIL.getInternalName());
    }

    protected boolean principalIsMobile(PrincipalType principalType) {
        return principalType.getInternalName().equals(ExistingBuiltInPrincipalType.MOBILE_PHONE.getInternalName());
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(QExternalPayment.externalPayment.type().from().currency().network(), true);
    }

    protected void sendFailedPaymentNotification(User user, ExternalPayment externalPayment) {
        PrincipalType principalType = externalPayment.getToPrincipalType();
        String string = principalType.getName();
        String string2 = externalPayment.getToPrincipalValue();
        String string3 = this.message(BankingKeys.Transactions.EXTERNAL_PAYMENT_PAYEE_INFO, string, string2);
        if (externalPayment.getType().isFromSystem()) {
            this.notificationHandler.admin().externalPaymentPerformedFailed(externalPayment, string3);
        } else {
            this.notificationHandler.user((BasicUser)externalPayment.getFromUser()).account().externalPaymentPerformedFailed((Transaction)externalPayment, externalPayment.getDate(), externalPayment.getCurrencyAmount(), externalPayment.getType(), string3);
            this.notificationHandler.user((BasicUser)user).account().externalPaymentReceivedFailed((Transaction)externalPayment, externalPayment.getDate(), (AccountOwner)externalPayment.getFromOwner(), externalPayment.getCurrencyAmount(), externalPayment.getType());
        }
    }

    protected void sendMailToExternalUser(ExternalPayment externalPayment, MessageKey messageKey, MessageKey messageKey2) {
        String string = StringHelper.isNotBlank((Object)externalPayment.getDescription()) ? this.message(MessageFormat.HTML, ContentManagementKeys.Emails.EXTERNAL_PAYMENT_DESCRIPTION, externalPayment.getDescription()) : null;
        String string2 = StringHelper.isNotBlank((Object)externalPayment.getComments()) ? this.message(MessageFormat.HTML, ContentManagementKeys.Emails.EXTERNAL_PAYMENT_COMMENTS, externalPayment.getComments()) : null;
        this.mailHandler.send(null, externalPayment.getToPrincipalValue(), this.message(messageKey, new Object[0]), this.message(MessageFormat.HTML, messageKey2, externalPayment.getDate(), externalPayment.getFromOwner(), externalPayment.getCurrencyAmount(), externalPayment.getExpirationDate(), string, this.linkGeneratorHandler.registrationWithExternalPayment(externalPayment), string2), new FileInfo[0]);
    }

    protected void sendSMSToExternalUser(ExternalPayment externalPayment, MessageKey messageKey) {
        BasicUser basicUser = (BasicUser)ObjectHelper.defaultValue((Object)externalPayment.getBy(), (Object)externalPayment.getFromUser());
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
        String string = this.message(messageKey, this.getFormatter().format(externalPayment.getDate()), this.getFormatter().format((AccountOwner)externalPayment.getFromOwner()), this.getFormatter().format((ICurrencyAmount)externalPayment.getCurrencyAmount()), this.getFormatter().format(externalPayment.getExpirationDate()));
        OutboundSmsType outboundSmsType = OutboundSmsType.NOTIFICATION;
        if (configurationAccessor.getOutboundSmsConfiguration() != null) {
            Integer n = configurationAccessor.getOutboundSmsConfiguration().getMaxMessagesToUnregistered();
            this.outboundSmsHandler.sendToUnregistered(configurationAccessor, externalPayment.getToPrincipalValue(), string, outboundSmsType, n);
        }
    }

    private void cancel(ExternalPayment externalPayment, String string, boolean bl) {
        if (externalPayment.getStatus() != ExternalPaymentStatus.PENDING) {
            throw new IllegalActionException();
        }
        ExtensionPointAccessor extensionPointAccessor = this.transactionService.setStatusAndGetExtensionPoint((Transaction)externalPayment, (TransactionStatus)ExternalPaymentStatus.CANCELED);
        externalPayment.setComments(string);
        PrincipalType principalType = externalPayment.getToPrincipalType();
        this.accountService.dereserveAmount(externalPayment);
        if (bl) {
            if (this.principalIsEmail(principalType)) {
                this.sendMailToExternalUser(externalPayment, ContentManagementKeys.Emails.EXTERNAL_PAYMENT_CANCELED_SUBJECT, ContentManagementKeys.Emails.EXTERNAL_PAYMENT_CANCELED_BODY);
            } else if (this.principalIsMobile(principalType)) {
                this.sendSMSToExternalUser(externalPayment, BankingKeys.Transactions.EXTERNAL_PAYMENT_SMS_CANCELED);
            }
        }
        extensionPointAccessor.fireSaved();
    }

    private Date getExpirationDate() {
        int n = this.cyclosProperties.getExpireExternalPaymentsDays();
        return DateHelper.add((Date)DateHelper.now(), (TimeField)TimeField.DAYS, (int)n);
    }

    private List<ExternalPayment> getExternalPaymentsToProcess(User user) {
        Object object;
        QPrincipalType qPrincipalType = QPrincipalType.principalType;
        DBQuery dBQuery = (DBQuery)((DBQuery)((DBQuery)this.from(new EntityPath[]{$}).leftJoin((EntityPath)qPrincipalType)).on((Predicate)$.toPrincipalType().eq((Expression)qPrincipalType))).where((Predicate)ExternalPaymentServiceImpl.$.status.eq((Object)ExternalPaymentStatus.PENDING.name()));
        BooleanBuilder booleanBuilder = new BooleanBuilder();
        String string = user.getEmail();
        if (StringHelper.isNotBlank((Object)string)) {
            booleanBuilder.or((Predicate)qPrincipalType.internalName.eq((Object)ExistingBuiltInPrincipalType.EMAIL.getInternalName()).and((Predicate)ExternalPaymentServiceImpl.$.toPrincipalValue.eq((Object)string)));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        PhoneListData phoneListData = this.phoneService.getPhoneListData((BasicUser)user);
        Object object2 = phoneListData.getPhones().iterator();
        while (object2.hasNext()) {
            String string2;
            object = (PhoneVO)object2.next();
            if (!object.getNature().equals((Object)PhoneNature.MOBILE) || (string2 = object.getNormalizedNumber()) == null) continue;
            arrayList.add(string2);
        }
        if (CollectionHelper.isNotEmpty(arrayList)) {
            booleanBuilder.or((Predicate)qPrincipalType.internalName.eq((Object)ExistingBuiltInPrincipalType.MOBILE_PHONE.getInternalName()).and((Predicate)ExternalPaymentServiceImpl.$.toPrincipalValue.in(arrayList)));
        }
        if (!(object2 = this.principalTypeService.listByNatures(new PrincipalTypeNature[]{PrincipalTypeNature.CUSTOM_FIELD})).isEmpty()) {
            object = object2.stream().collect(Collectors.toMap(CustomFieldPrincipalType::getCustomField, customFieldPrincipalType -> customFieldPrincipalType));
            user.getCustomValues().stream().filter(arg_0 -> ExternalPaymentServiceImpl.lambda$getExternalPaymentsToProcess$9((Map)object, arg_0)).forEach(arg_0 -> this.lambda$getExternalPaymentsToProcess$10(booleanBuilder, qPrincipalType, (Map)object, arg_0));
        }
        return ((DBQuery)dBQuery.where((Predicate)booleanBuilder)).list((Expression)$);
    }

    private ExternalPaymentPreviewVO preview(PerformExternalPaymentDTO performExternalPaymentDTO, PaymentTransferType paymentTransferType, LocateAccountOwnerResult locateAccountOwnerResult, BigDecimal bigDecimal) {
        InternalAccountOwner internalAccountOwner = locateAccountOwnerResult.getInternalAccountOwner();
        Account account = this.accountService.load(internalAccountOwner, paymentTransferType.getFrom());
        ExternalPaymentPreviewVO externalPaymentPreviewVO = (ExternalPaymentPreviewVO)this.conversionHandler.convert(ExternalPaymentPreviewVO.class, (Object)this.transferFeeService.preview((PerformTransactionDTO)performExternalPaymentDTO, paymentTransferType, internalAccountOwner, null, bigDecimal));
        externalPaymentPreviewVO.setFromAccount((AccountVO)this.conversionHandler.convert(AccountVO.class, (Object)account));
        this.transactionService.updatePreviewAndPayment((BasePaymentPreviewVO)externalPaymentPreviewVO, (PerformTransactionDTO)performExternalPaymentDTO, locateAccountOwnerResult, null, (TransferType)paymentTransferType, null);
        PrincipalType principalType = (PrincipalType)this.conversionHandler.convert(PrincipalType.class, (Object)performExternalPaymentDTO.getToPrincipalType());
        externalPaymentPreviewVO.getPayment().setToPrincipalType((PrincipalTypeVO)this.conversionHandler.convert(PrincipalTypeVO.class, (Object)principalType));
        return externalPaymentPreviewVO;
    }

    private void validate(PerformExternalPaymentDTO performExternalPaymentDTO) {
        LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locateOrCurrent((AccountOwner)performExternalPaymentDTO.getOwner());
        LocateAccountOwnerResult locateAccountOwnerResult2 = LocateAccountOwnerResult.external();
        PrepareValidationParameter prepareValidationParameter = new PrepareValidationParameter.Builder((PerformTransactionDTO)performExternalPaymentDTO, locateAccountOwnerResult, locateAccountOwnerResult2, PaymentCreationType.EXTERNAL).validateCustomFields(true).allowSearchingTTWhenNoneIsGiven(false).validateConfirmationPassword(false).excludeHideInForm(true).validateNFCChallenge(false).validateAmount(true).build();
        TransactionValidationData transactionValidationData = this.transactionService.prepareValidation(prepareValidationParameter);
        Validator validator = transactionValidationData.getValidator();
        PrincipalType principalType = (PrincipalType)this.conversionHandler.convert(PrincipalType.class, (Object)performExternalPaymentDTO.getToPrincipalType());
        validator.property((Property)PerformExternalPaymentDTO.TO_PRINCIPAL_TYPE, BankingKeys.Transactions.TO_PRINCIPAL_TYPE).required().entity(PrincipalType.class, (EntityValidation)new BaseEntityValidation<PrincipalType>(){

            protected boolean isValid(Object object, Object object2, PrincipalType principalType) {
                PaymentPrincipalsConfiguration paymentPrincipalsConfiguration = ExternalPaymentServiceImpl.this.getSessionData().getChannelSettingsAccessor().getPayment();
                return paymentPrincipalsConfiguration.getPrincipalTypes().contains(principalType) && principalType.isUsedExternalPayment();
            }
        });
        if (principalType != null && principalType.isUsedExternalPayment()) {
            org.cyclos.impl.utils.validation.Property property;
            String string = performExternalPaymentDTO.getToPrincipalValue();
            boolean bl = false;
            boolean bl2 = this.principalIsEmail(principalType);
            boolean bl3 = this.principalIsMobile(principalType);
            if (bl2 || bl3) {
                property = validator.property((Property)PerformExternalPaymentDTO.TO_PRINCIPAL_VALUE, BankingKeys.Transactions.TO_PRINCIPAL_VALUE);
                if (bl2) {
                    property.email();
                    bl = this.userService.existsUserWithEmail(string);
                } else {
                    property.phoneNumber(this.getConfiguration(), PhoneNature.MOBILE);
                    PhoneNumberDescriptor phoneNumberDescriptor = this.phoneNumberHandler.parse(string, this.getConfiguration());
                    bl = this.userService.existsUserWithMobilePhone(phoneNumberDescriptor);
                }
            } else if (principalType.getNature() == PrincipalTypeNature.CUSTOM_FIELD) {
                CustomFieldPrincipalType customFieldPrincipalType = (CustomFieldPrincipalType)principalType;
                UserCustomField userCustomField = customFieldPrincipalType.getCustomField();
                property = this.customFieldValueHandler.addValueValidationAsPropertyIgnoringRequired(validator, (CustomField)userCustomField, null, null, (Property)PerformExternalPaymentDTO.TO_PRINCIPAL_VALUE);
                bl = this.userCustomFieldService.existsUser(userCustomField, performExternalPaymentDTO.getToPrincipalValue());
            } else {
                throw new IllegalArgumentException();
            }
            property.required();
            if (bl) {
                throw new ValidationException(this.message(BankingKeys.Transactions.EXTERNAL_PAYMENT_ERROR_INVALID_PRINCIPAL_VALUE, principalType.getName()));
            }
        }
        this.validate(validator, performExternalPaymentDTO, "performExternalPaymentDTO");
    }

    private void validateAction(ExternalPayment externalPayment, ExternalPaymentActionDTO externalPaymentActionDTO, ExternalPaymentAction externalPaymentAction) {
        Validator validator = new Validator();
        validator.property((Property)ExternalPaymentActionDTO.EXTERNAL_PAYMENT, BankingKeys.Transactions.TRANSACTION).required();
        this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).addRequiredValidation(validator, (Property)ExternalPaymentActionDTO.CONFIRMATION_PASSWORD);
        this.validate(validator, externalPaymentActionDTO, "validateAction");
        this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(externalPaymentActionDTO.getConfirmationPassword(), ManageExternalPaymentConfirmationField.confirmation((TransactionVO)externalPaymentActionDTO.getExternalPayment(), (ExternalPaymentAction)externalPaymentAction));
    }

    private ExternalPayment validateActionAndGet(ExternalPaymentActionDTO externalPaymentActionDTO, ExternalPaymentStatus externalPaymentStatus, ExternalPaymentAction externalPaymentAction) {
        ExternalPayment externalPayment = (ExternalPayment)this.conversionHandler.convert(ExternalPayment.class, (Object)externalPaymentActionDTO.getExternalPayment());
        this.validateAction(externalPayment, externalPaymentActionDTO, externalPaymentAction);
        if (externalPayment.getStatus() != externalPaymentStatus) {
            throw new IllegalActionException();
        }
        return externalPayment;
    }

    private /* synthetic */ void lambda$getExternalPaymentsToProcess$10(BooleanBuilder booleanBuilder, QPrincipalType qPrincipalType, Map map, UserCustomFieldValue userCustomFieldValue) {
        UserCustomField userCustomField = userCustomFieldValue.getField();
        String string = StringHelper.trimToNull((Object)this.customFieldValueHandler.getValue((CustomField)userCustomField, (Object)userCustomFieldValue, false));
        if (string != null) {
            string = MaskHelper.removeMask((String)userCustomField.getPattern(), (String)string);
            booleanBuilder.or((Predicate)qPrincipalType.eq((Object)((PrincipalType)map.get(userCustomField))).and((Predicate)ExternalPaymentServiceImpl.$.toPrincipalValue.eq((Object)string)));
        }
    }

    private static /* synthetic */ boolean lambda$getExternalPaymentsToProcess$9(Map map, UserCustomFieldValue userCustomFieldValue) {
        return map.containsKey(userCustomFieldValue.getField());
    }
}

