/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.DateTimeExpression;
import java.util.Collection;
import org.cyclos.entities.banking.Installment;
import org.cyclos.entities.banking.QInstallment;
import org.cyclos.entities.banking.RecurringPaymentOccurrence;
import org.cyclos.entities.banking.ScheduledPaymentInstallment;
import org.cyclos.impl.banking.RecurringPaymentServiceLocal;
import org.cyclos.impl.banking.ScheduledPaymentServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.tasks.EntityBatchRecurringTask;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.transactions.InstallmentStatus;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InstallmentProcessingRecurringTask
extends EntityBatchRecurringTask<Installment> {
    @Autowired
    private ScheduledPaymentServiceLocal scheduledPaymentService;
    @Autowired
    private RecurringPaymentServiceLocal recurringPaymentService;

    public InstallmentProcessingRecurringTask() {
        super(Installment.class);
    }

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.INSTALLMENT_PROCESSING;
    }

    @Override
    protected boolean doLogProcessingErrors(Installment installment, Throwable throwable) {
        return false;
    }

    @Override
    protected boolean doShouldGenerateErrorLog(Long l, Throwable throwable) {
        return !(throwable instanceof TransferException);
    }

    @Override
    protected void finish(Installment installment, Throwable throwable) throws Throwable {
        if (throwable != null) {
            if (installment instanceof ScheduledPaymentInstallment) {
                this.scheduledPaymentService.markAsFailed((ScheduledPaymentInstallment)installment);
            } else if (installment instanceof RecurringPaymentOccurrence) {
                this.recurringPaymentService.markAsFailed((RecurringPaymentOccurrence)installment);
            } else {
                throw new IllegalStateException("Unhandled installment kind: " + String.valueOf(installment));
            }
        }
    }

    @Override
    protected Collection<Long> nextIds() throws Throwable {
        QInstallment qInstallment = QInstallment.installment;
        return ((DBQuery)((DBQuery)this.from(new EntityPath[]{qInstallment}).where(new Predicate[]{qInstallment.status.eq((Object)InstallmentStatus.SCHEDULED), qInstallment.dueDate.before((Expression)DateTimeExpression.currentTimestamp())})).limit(200L)).list((Expression)qInstallment.id);
    }

    @Override
    protected void process(Installment installment) throws Throwable {
        if (installment instanceof ScheduledPaymentInstallment) {
            this.scheduledPaymentService.processInstallment((ScheduledPaymentInstallment)installment);
        } else if (installment instanceof RecurringPaymentOccurrence) {
            this.recurringPaymentService.processOccurrence((RecurringPaymentOccurrence)installment);
        } else {
            throw new IllegalStateException("Unhandled installment kind: " + String.valueOf(installment));
        }
    }
}

