/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.DateTimeExpression;
import java.util.Collection;
import org.cyclos.entities.banking.PaymentRequest;
import org.cyclos.entities.banking.QPaymentRequest;
import org.cyclos.impl.banking.PaymentRequestServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.tasks.EntityBatchRecurringTask;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.transactions.PaymentRequestStatus;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PaymentRequestProcessingRecurringTask
extends EntityBatchRecurringTask<PaymentRequest> {
    @Autowired
    private PaymentRequestServiceLocal paymentRequestService;

    public PaymentRequestProcessingRecurringTask() {
        super(PaymentRequest.class);
    }

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.PAYMENT_REQUEST_PROCESSING;
    }

    @Override
    protected boolean doLogProcessingErrors(PaymentRequest paymentRequest, Throwable throwable) {
        return false;
    }

    @Override
    protected boolean doShouldGenerateErrorLog(Long l, Throwable throwable) {
        return !(throwable instanceof TransferException);
    }

    @Override
    protected void finish(PaymentRequest paymentRequest, Throwable throwable) throws Throwable {
        boolean bl;
        boolean bl2 = bl = throwable == null;
        if (!bl && paymentRequest.getStatus() == PaymentRequestStatus.SCHEDULED) {
            this.paymentRequestService.reopenFailed(paymentRequest);
        }
    }

    @Override
    protected Collection<Long> nextIds() throws Throwable {
        QPaymentRequest qPaymentRequest = QPaymentRequest.paymentRequest;
        BooleanExpression booleanExpression = qPaymentRequest.status.eq((Object)PaymentRequestStatus.OPEN.name()).and((Predicate)qPaymentRequest.expirationDate.before((Expression)DateTimeExpression.currentTimestamp()));
        BooleanExpression booleanExpression2 = qPaymentRequest.status.eq((Object)PaymentRequestStatus.SCHEDULED.name()).and((Predicate)qPaymentRequest.processDate.before((Expression)DateTimeExpression.currentTimestamp()));
        return ((DBQuery)((DBQuery)this.from(new EntityPath[]{qPaymentRequest}).where((Predicate)booleanExpression.or((Predicate)booleanExpression2))).limit(200L)).list((Expression)qPaymentRequest.id);
    }

    @Override
    protected void process(PaymentRequest paymentRequest) throws Throwable {
        if (paymentRequest.getStatus() == PaymentRequestStatus.OPEN) {
            this.paymentRequestService.expire(paymentRequest);
        } else if (paymentRequest.getStatus() == PaymentRequestStatus.SCHEDULED) {
            this.paymentRequestService.processScheduling(paymentRequest);
        }
    }
}

