/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.PaymentRequest;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.QPaymentRequest;
import org.cyclos.entities.banking.QUserAccount;
import org.cyclos.entities.banking.ScheduledPayment;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.system.AcceptPaymentRequestSmsOperationConfiguration;
import org.cyclos.entities.system.DenyPaymentRequestSmsOperationConfiguration;
import org.cyclos.entities.system.PaymentPrincipalsConfiguration;
import org.cyclos.entities.system.SmsChannelConfiguration;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.CredentialAccessor;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.access.PrincipalTypeServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.LocateAccountOwnerResult;
import org.cyclos.impl.banking.PaymentRequestServiceLocal;
import org.cyclos.impl.banking.PaymentServiceLocal;
import org.cyclos.impl.banking.PaymentTransferTypeQuery;
import org.cyclos.impl.banking.PrepareValidationParameter;
import org.cyclos.impl.banking.RecurringPaymentServiceLocal;
import org.cyclos.impl.banking.ScheduledPaymentServiceLocal;
import org.cyclos.impl.banking.TransactionNotificationProcessingRecurringTask;
import org.cyclos.impl.banking.TransactionServiceLocal;
import org.cyclos.impl.banking.TransactionValidationData;
import org.cyclos.impl.banking.TransferTypeServiceLocal;
import org.cyclos.impl.search.TransactionSearchHandler;
import org.cyclos.impl.system.ExtensionPointAccessor;
import org.cyclos.impl.system.ExtensionPointFilter;
import org.cyclos.impl.system.ExtensionPointServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.tasks.RecurringTaskHandler;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.GeneralValidations;
import org.cyclos.impl.utils.validation.validations.ValidationErrors;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.channels.IdentificationMethod;
import org.cyclos.model.access.devices.CreateDeviceConfirmationParams;
import org.cyclos.model.access.principaltypes.PrincipalTypeInputVO;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.AccountWithCurrencyVO;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.transactions.AbstractPaymentTypeData;
import org.cyclos.model.banking.transactions.AcceptPaymentRequestDTO;
import org.cyclos.model.banking.transactions.AcceptPaymentRequestPreviewVO;
import org.cyclos.model.banking.transactions.BaseInternalPaymentPreviewVO;
import org.cyclos.model.banking.transactions.CalculateInstallmentsDTO;
import org.cyclos.model.banking.transactions.ChangePaymentRequestExpirationDateDTO;
import org.cyclos.model.banking.transactions.InstallmentDTO;
import org.cyclos.model.banking.transactions.ManagePaymentRequestConfirmationField;
import org.cyclos.model.banking.transactions.PaymentCreationType;
import org.cyclos.model.banking.transactions.PaymentRequestAction;
import org.cyclos.model.banking.transactions.PaymentRequestActionDTO;
import org.cyclos.model.banking.transactions.PaymentRequestData;
import org.cyclos.model.banking.transactions.PaymentRequestStatus;
import org.cyclos.model.banking.transactions.PaymentRequestVO;
import org.cyclos.model.banking.transactions.PerformPaymentDTO;
import org.cyclos.model.banking.transactions.PerformTransactionDTO;
import org.cyclos.model.banking.transactions.RequestPaymentData;
import org.cyclos.model.banking.transactions.RequestPaymentPayerData;
import org.cyclos.model.banking.transactions.RequestPaymentTypeData;
import org.cyclos.model.banking.transactions.ScheduledPaymentPreviewVO;
import org.cyclos.model.banking.transactions.SchedulingType;
import org.cyclos.model.banking.transactions.SendPaymentRequestDTO;
import org.cyclos.model.banking.transactions.TransactionStatus;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.banking.transfertypes.TransferTypeWithCurrencyVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.extensionpoints.ExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.TransactionExtensionPointEvent;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.model.utils.TimeField;
import org.cyclos.security.banking.TransactionServiceSecurity;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.server.utils.SecureRandomHelper;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.IDate;
import org.cyclos.utils.ObjectHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PaymentRequestServiceImpl
extends BaseServiceImpl
implements PaymentRequestServiceLocal {
    private static QPaymentRequest $ = QPaymentRequest.paymentRequest;
    @Autowired
    private TransactionServiceLocal transactionService;
    @Autowired
    private TransactionServiceSecurity transactionServiceSecurity;
    @Autowired
    private ExtensionPointServiceLocal extensionPointService;
    @Autowired
    private TransferTypeServiceLocal transferTypeService;
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private ScheduledPaymentServiceLocal scheduledPaymentService;
    @Autowired
    private RecurringPaymentServiceLocal recurringPaymentService;
    @Autowired
    private PaymentServiceLocal paymentService;
    @Autowired
    private PasswordHandler passwordHandler;
    @Autowired
    private PrincipalTypeServiceLocal principalTypeService;
    @Autowired
    private TransactionSearchHandler transactionSearchHandler;
    @Autowired
    private RecurringTaskHandler recurringTaskHandler;
    @Autowired
    private ChannelServiceLocal channelService;

    public PaymentRequestVO accept(AcceptPaymentRequestDTO acceptPaymentRequestDTO) throws FrameworkException {
        PaymentRequest paymentRequest = this.validateActionAndGet((PaymentRequestActionDTO)acceptPaymentRequestDTO, PaymentRequestAction.ACCEPT, PaymentRequestStatus.OPEN);
        return this.acceptOrReschedule(acceptPaymentRequestDTO, paymentRequest);
    }

    public void cancel(PaymentRequestActionDTO paymentRequestActionDTO) throws FrameworkException {
        PaymentRequest paymentRequest = this.validateActionAndGet(paymentRequestActionDTO, PaymentRequestAction.CANCEL, PaymentRequestStatus.OPEN, PaymentRequestStatus.EXPIRED);
        String string = paymentRequestActionDTO.getComments();
        this.cancel(paymentRequest, string);
        User user = paymentRequest.getFromUser();
        if (user != null) {
            this.notificationHandler.user((BasicUser)user).account().paymentRequestCanceled(paymentRequest, paymentRequest.getCurrencyAmount(), paymentRequest.getType(), (AccountOwner)paymentRequest.getToOwner(), paymentRequest.getTransactionNumber());
        }
    }

    public int cancelAll(UserAccount userAccount) {
        if (userAccount.isTransient()) {
            return 0;
        }
        CloseableIterator closeableIterator = ((DBQuery)this.from(new EntityPath[]{$}).where(new Predicate[]{$.from().eq((Object)userAccount).or((Predicate)$.to().eq((Object)userAccount)), PaymentRequestServiceImpl.$.status.in((Object[])new String[]{PaymentRequestStatus.OPEN.name(), PaymentRequestStatus.SCHEDULED.name()})})).iterate((Expression)$);
        return (int)this.processBatch(closeableIterator, (T paymentRequest) -> this.cancel((PaymentRequest)paymentRequest, null));
    }

    public void changeExpirationDate(ChangePaymentRequestExpirationDateDTO changePaymentRequestExpirationDateDTO) throws FrameworkException {
        User user;
        PaymentRequest paymentRequest = (PaymentRequest)this.conversionHandler.convert(PaymentRequest.class, (Object)changePaymentRequestExpirationDateDTO.getPaymentRequest());
        this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(changePaymentRequestExpirationDateDTO.getConfirmationPassword(), ManagePaymentRequestConfirmationField.confirmation((PaymentRequestVO)new PaymentRequestVO(paymentRequest.getId()), (PaymentRequestAction)PaymentRequestAction.CHANGE_EXPIRATION_DATE));
        Validator validator = new Validator();
        validator.property((Property)ChangePaymentRequestExpirationDateDTO.NEW_EXPIRATION_DATE, BankingKeys.Transactions.NEW_EXPIRATION_DATE).required().futureDate();
        this.validate(validator, changePaymentRequestExpirationDateDTO, "changeExpirationDate");
        if (ObjectHelper.isNotOneOf((Object)paymentRequest.getStatus(), (Object[])new Object[]{PaymentRequestStatus.OPEN, PaymentRequestStatus.EXPIRED})) {
            throw new IllegalActionException();
        }
        paymentRequest.setStatus(PaymentRequestStatus.OPEN);
        paymentRequest.setExpirationDate(this.toDate(changePaymentRequestExpirationDateDTO.getNewExpirationDate()));
        paymentRequest.setExpirationDateComments(changePaymentRequestExpirationDateDTO.getComments());
        this.transactionSearchHandler.index((NetworkedEntity)paymentRequest);
        User user2 = paymentRequest.getFromUser();
        if (user2 != null) {
            this.notificationHandler.user((BasicUser)user2).account().paymentRequestExpirationDateChanged(paymentRequest, paymentRequest.getCurrencyAmount(), paymentRequest.getType(), (AccountOwner)paymentRequest.getToOwner(), paymentRequest.getExpirationDate(), paymentRequest.getSmsCode(), paymentRequest.getTransactionNumber());
        }
        if ((user = paymentRequest.getToUser()) != null && !user.equals((Object)this.getLoggedUser())) {
            this.notificationHandler.user((BasicUser)user).account().sentPaymentRequestExpirationDateChanged(paymentRequest, paymentRequest.getCurrencyAmount(), paymentRequest.getType(), (AccountOwner)paymentRequest.getFromOwner(), paymentRequest.getExpirationDate(), paymentRequest.getSmsCode(), paymentRequest.getTransactionNumber());
        }
    }

    public void deny(PaymentRequestActionDTO paymentRequestActionDTO) throws FrameworkException {
        PaymentRequest paymentRequest = this.validateActionAndGet(paymentRequestActionDTO, PaymentRequestAction.DENY, PaymentRequestStatus.OPEN);
        ExtensionPointAccessor extensionPointAccessor = this.transactionService.setStatusAndGetExtensionPoint((Transaction)paymentRequest, (TransactionStatus)PaymentRequestStatus.DENIED);
        paymentRequest.setComments(paymentRequestActionDTO.getComments());
        paymentRequest.setSmsCode(null);
        User user = paymentRequest.getToUser();
        if (user != null) {
            this.notificationHandler.user((BasicUser)user).account().paymentRequestDenied(paymentRequest, paymentRequest.getCurrencyAmount(), paymentRequest.getType(), (AccountOwner)paymentRequest.getFromOwner(), paymentRequest.getTransactionNumber());
        }
        extensionPointAccessor.fireSaved();
    }

    public void expire(PaymentRequest paymentRequest) {
        ExtensionPointAccessor extensionPointAccessor = this.transactionService.setStatusAndGetExtensionPoint((Transaction)paymentRequest, (TransactionStatus)PaymentRequestStatus.EXPIRED);
        paymentRequest.setSmsCode(null);
        User user = paymentRequest.getFromUser();
        if (user != null) {
            this.notificationHandler.user((BasicUser)user).account().paymentRequestExpired(paymentRequest, paymentRequest.getCurrencyAmount(), paymentRequest.getType(), (AccountOwner)paymentRequest.getToOwner(), paymentRequest.getTransactionNumber());
        }
        extensionPointAccessor.fireSaved();
    }

    public PaymentRequest getBySmsCode(String string, User user) {
        QUserAccount qUserAccount = QUserAccount.userAccount;
        return (PaymentRequest)((DBQuery)((DBQuery)this.from(new EntityPath[]{$}).innerJoin((EntityPath)$.from(), (Path)qUserAccount._super)).where(new Predicate[]{PaymentRequestServiceImpl.$.smsCode.eq((Object)string.toUpperCase()), qUserAccount.user().eq((Object)user)})).singleResult((Expression)$);
    }

    public PaymentRequestData getData(Long l) throws FrameworkException {
        PaymentRequest paymentRequest = this.find(PaymentRequest.class, l);
        return this.getData(paymentRequest);
    }

    public PaymentRequestData getData(PaymentRequest paymentRequest) {
        PaymentRequestData paymentRequestData = (PaymentRequestData)this.transactionService.newData((Transaction)paymentRequest, true);
        PaymentRequestStatus paymentRequestStatus = paymentRequest.getStatus();
        boolean bl = paymentRequestStatus == PaymentRequestStatus.OPEN;
        boolean bl2 = bl || paymentRequestStatus == PaymentRequestStatus.EXPIRED;
        paymentRequestData.setCanAccept(bl);
        paymentRequestData.setCanDeny(bl);
        paymentRequestData.setCanCancel(bl);
        paymentRequestData.setCanReschedule(paymentRequestStatus == PaymentRequestStatus.SCHEDULED);
        paymentRequestData.setCanChangeExpirationDate(bl2);
        return paymentRequestData;
    }

    public RequestPaymentData getRequestData(InternalAccountOwner internalAccountOwner, InternalAccountOwner internalAccountOwner2, TransferTypeVO transferTypeVO) throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        User user = sessionData.getLoggedUser();
        LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locateOrCurrent((AccountOwner)internalAccountOwner);
        LocateAccountOwnerResult locateAccountOwnerResult2 = this.accountHandler.locate((AccountOwner)internalAccountOwner2);
        internalAccountOwner = locateAccountOwnerResult.getInternalAccountOwner();
        internalAccountOwner2 = locateAccountOwnerResult2.getInternalAccountOwner();
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)transferTypeVO);
        RequestPaymentData requestPaymentData = new RequestPaymentData();
        List<PaymentTransferType> list = this.fill((RequestPaymentPayerData)requestPaymentData, locateAccountOwnerResult, locateAccountOwnerResult2, paymentTransferType);
        Set set = list.stream().map(TransferType::getTo).collect(Collectors.toSet());
        PaymentPrincipalsConfiguration paymentPrincipalsConfiguration = sessionData.getChannelSettingsAccessor().getPayment();
        ArrayList arrayList = new ArrayList(paymentPrincipalsConfiguration.getPrincipalTypes());
        this.principalTypeService.sort(arrayList);
        requestPaymentData.setPrincipalTypes(this.conversionHandler.convertList(PrincipalTypeInputVO.class, arrayList));
        if (user != null) {
            boolean bl = Objects.equals(sessionData.getNetwork(), user.getNetwork());
            if (bl) {
                bl = sessionData.hasPermission(Permission.MY_CONTACTS_ENABLE);
            }
            requestPaymentData.setAllowContacts(paymentPrincipalsConfiguration.isContacts() && bl);
        }
        requestPaymentData.setAllowAutocomplete(paymentPrincipalsConfiguration.isAutocomplete());
        requestPaymentData.setDefaultIdMethod(paymentPrincipalsConfiguration.getDefaultIdMethod());
        if (requestPaymentData.getDefaultIdMethod() == IdentificationMethod.PRINCIPAL_TYPE) {
            PrincipalType principalType = paymentPrincipalsConfiguration.getDefaultPrincipalType();
            requestPaymentData.setDefaultPrincipalType((PrincipalTypeInputVO)this.conversionHandler.convert(PrincipalTypeInputVO.class, (Object)principalType));
        }
        InternalAccountOwner internalAccountOwner3 = internalAccountOwner;
        requestPaymentData.setAccounts(set.stream().sorted().map(accountType -> this.accountService.load(internalAccountOwner3, accountType)).map(this.conversionHandler.convertingFunction(AccountWithCurrencyVO.class, new Object[0])).collect(Collectors.toList()));
        return requestPaymentData;
    }

    public RequestPaymentPayerData getRequestPaymentPayerData(InternalAccountOwner internalAccountOwner, InternalAccountOwner internalAccountOwner2) throws FrameworkException {
        RequestPaymentPayerData requestPaymentPayerData = new RequestPaymentPayerData();
        LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locateOrCurrent((AccountOwner)internalAccountOwner);
        LocateAccountOwnerResult locateAccountOwnerResult2 = this.accountHandler.locate((AccountOwner)internalAccountOwner2);
        this.fill(requestPaymentPayerData, locateAccountOwnerResult, locateAccountOwnerResult2, null);
        return requestPaymentPayerData;
    }

    public RequestPaymentTypeData getRequestPaymentTypeData(InternalAccountOwner internalAccountOwner, InternalAccountOwner internalAccountOwner2, TransferTypeVO transferTypeVO) throws FrameworkException {
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)transferTypeVO);
        return this.toRequestPaymentTypeData(internalAccountOwner, internalAccountOwner2, paymentTransferType);
    }

    public void notifyRequestSend(PaymentRequest paymentRequest) {
        if (paymentRequest.getFromUser() != null) {
            this.notificationHandler.user((BasicUser)paymentRequest.getFromUser()).account().paymentRequestReceived(paymentRequest, paymentRequest.getCurrencyAmount(), paymentRequest.getType(), (AccountOwner)paymentRequest.getToOwner(), paymentRequest.getExpirationDate(), paymentRequest.getSmsCode(), paymentRequest.getTransactionNumber());
        }
    }

    public AcceptPaymentRequestPreviewVO previewAccept(PaymentRequestVO paymentRequestVO) throws FrameworkException {
        PaymentRequest paymentRequest = (PaymentRequest)this.conversionHandler.convert(PaymentRequest.class, (Object)paymentRequestVO);
        PaymentTransferType paymentTransferType = (PaymentTransferType)paymentRequest.getType();
        ScheduledPaymentPreviewVO scheduledPaymentPreviewVO = null;
        switch (paymentRequest.getScheduling()) {
            case FUTURE_DATE: 
            case MULTIPLE_INSTALLMENTS: {
                scheduledPaymentPreviewVO = this.scheduledPaymentService.previewAcceptPaymentRequest(paymentRequest);
                break;
            }
            case NOT_SCHEDULED: {
                scheduledPaymentPreviewVO = this.paymentService.previewAcceptPaymentRequest(paymentRequest);
                break;
            }
            case RECURRING: {
                scheduledPaymentPreviewVO = this.recurringPaymentService.previewAcceptPaymentRequest(paymentRequest);
            }
        }
        AcceptPaymentRequestPreviewVO acceptPaymentRequestPreviewVO = new AcceptPaymentRequestPreviewVO();
        acceptPaymentRequestPreviewVO.setPaymentRequest((PaymentRequestVO)this.conversionHandler.convert(PaymentRequestVO.class, (Object)paymentRequest));
        acceptPaymentRequestPreviewVO.setPaymentPreview((BaseInternalPaymentPreviewVO)scheduledPaymentPreviewVO);
        acceptPaymentRequestPreviewVO.setCanSetProcessDate(!paymentTransferType.isHidePaymentRequestExpirationDate());
        return acceptPaymentRequestPreviewVO;
    }

    public void processScheduling(PaymentRequest paymentRequest) {
        if (paymentRequest.getStatus() != PaymentRequestStatus.SCHEDULED) {
            throw new IllegalActionException();
        }
        this.processNow(paymentRequest);
    }

    public void reopenFailed(PaymentRequest paymentRequest) {
        if (paymentRequest.getStatus() != PaymentRequestStatus.SCHEDULED) {
            throw new IllegalActionException();
        }
        ExtensionPointAccessor extensionPointAccessor = this.transactionService.setStatusAndGetExtensionPoint((Transaction)paymentRequest, (TransactionStatus)PaymentRequestStatus.OPEN);
        User user = paymentRequest.getFromUser();
        if (user != null) {
            this.notificationHandler.user((BasicUser)user).account().scheduledPaymentRequestFailed(paymentRequest, paymentRequest.getCurrencyAmount(), paymentRequest.getType(), (AccountOwner)paymentRequest.getToOwner());
        }
        extensionPointAccessor.fireSaved();
    }

    public PaymentRequestVO reschedule(AcceptPaymentRequestDTO acceptPaymentRequestDTO) throws FrameworkException {
        PaymentRequest paymentRequest = this.validateActionAndGet((PaymentRequestActionDTO)acceptPaymentRequestDTO, PaymentRequestAction.RESCHEDULE, PaymentRequestStatus.SCHEDULED);
        return this.acceptOrReschedule(acceptPaymentRequestDTO, paymentRequest);
    }

    public PaymentRequestVO send(SendPaymentRequestDTO sendPaymentRequestDTO) throws FrameworkException {
        Operator operator;
        if (sendPaymentRequestDTO.getScheduling() == null) {
            sendPaymentRequestDTO.setScheduling(SchedulingType.NOT_SCHEDULED);
        }
        this.validateSend(sendPaymentRequestDTO);
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)sendPaymentRequestDTO.getType());
        LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locateOrCurrent((AccountOwner)sendPaymentRequestDTO.getOwner());
        LocateAccountOwnerResult locateAccountOwnerResult2 = this.transactionService.locateForPayment(sendPaymentRequestDTO.getSubject());
        this.transactionServiceSecurity.checkPaymentParameters(locateAccountOwnerResult2, locateAccountOwnerResult, PaymentCreationType.REQUEST, paymentTransferType);
        if (locateAccountOwnerResult2.isOperator() && (operator = locateAccountOwnerResult2.getOperator()).isRestrictedOperator() && !operator.getGroup().isRequestPayments()) {
            throw new ValidationException(this.message(BankingKeys.Transactions.PAYMENT_REQUEST_OPERATOR_CANNOT_RECEIVE, operator));
        }
        operator = this.accountService.load(locateAccountOwnerResult2.getInternalAccountOwner(), paymentTransferType.getFrom());
        Account account = this.accountService.load(locateAccountOwnerResult.getInternalAccountOwner(), paymentTransferType.getTo());
        ExtensionPointAccessor extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)TransactionExtensionPointEvent.SEND_REQUEST, new ExtensionPointFilter((TransferType)paymentTransferType)).attribute("performTransaction", (Object)sendPaymentRequestDTO).attribute("fromAccount", (Object)operator).attribute("fromOwner", (Object)locateAccountOwnerResult.getAccountOwner()).attribute("fromOwnerResult", (Object)locateAccountOwnerResult).attribute("toAccount", (Object)account).attribute("toOwner", (Object)locateAccountOwnerResult2.getAccountOwner()).attribute("toOwnerResult", (Object)locateAccountOwnerResult2).attribute("paymentType", (Object)paymentTransferType);
        extensionPointAccessor.fireValidated();
        BigDecimal bigDecimal = BigDecimalHelper.round((BigDecimal)sendPaymentRequestDTO.getAmount(), (int)paymentTransferType.getCurrency().getPrecision());
        PaymentRequest paymentRequest = new PaymentRequest();
        Date date = this.conversionHandler.toDate((IDate)sendPaymentRequestDTO.getExpirationDate());
        if (date == null) {
            date = this.getDefaultExpiration(paymentTransferType);
        }
        paymentRequest.setExpirationDate(date);
        paymentRequest.setFirstSchedulingIsImmediate(Boolean.valueOf(sendPaymentRequestDTO.isFirstSchedulingIsImmediate()));
        paymentRequest.setSchedulingCount(sendPaymentRequestDTO.getSchedulingCount());
        paymentRequest.setScheduling(sendPaymentRequestDTO.getScheduling());
        paymentRequest.setOccurrenceInterval((TimeInterval)this.conversionHandler.convert(TimeInterval.class, (Object)sendPaymentRequestDTO.getOccurrenceInterval()));
        paymentRequest.setStatus(PaymentRequestStatus.OPEN);
        if (locateAccountOwnerResult2.isUser()) {
            paymentRequest.setSmsCode(this.generateSmsCode(locateAccountOwnerResult2.getUser()));
        }
        this.transactionService.fill((Transaction)paymentRequest, (TransferType)paymentTransferType, null, (Account)operator, account, null, sendPaymentRequestDTO.getFromName(), sendPaymentRequestDTO.getToName(), bigDecimal, sendPaymentRequestDTO.getDescription(), (Collection)sendPaymentRequestDTO.getCustomValues());
        User user = paymentRequest.getFromUser();
        paymentRequest.setPendingNotification(user != null);
        this.transactionService.persist((Transaction)paymentRequest);
        if (paymentRequest.isPendingNotification()) {
            this.recurringTaskHandler.scheduleAwake(TransactionNotificationProcessingRecurringTask.class);
        }
        extensionPointAccessor.attribute("transaction", (Object)paymentRequest).fireSaved();
        return (PaymentRequestVO)this.conversionHandler.convert(PaymentRequestVO.class, (Object)paymentRequest);
    }

    protected PaymentRequestVO acceptOrReschedule(AcceptPaymentRequestDTO acceptPaymentRequestDTO, PaymentRequest paymentRequest) {
        paymentRequest.setComments(acceptPaymentRequestDTO.getComments());
        if (acceptPaymentRequestDTO.getProcessDate() == null) {
            this.processNow(paymentRequest);
        } else {
            ExtensionPointAccessor extensionPointAccessor = this.transactionService.setStatusAndGetExtensionPoint((Transaction)paymentRequest, (TransactionStatus)PaymentRequestStatus.SCHEDULED);
            paymentRequest.setProcessDate(this.conversionHandler.toDate((IDate)acceptPaymentRequestDTO.getProcessDate()));
            extensionPointAccessor.fireSaved();
        }
        return (PaymentRequestVO)this.conversionHandler.convert(PaymentRequestVO.class, (Object)paymentRequest);
    }

    protected void processNow(PaymentRequest paymentRequest) {
        PaymentRequestStatus paymentRequestStatus = paymentRequest.getStatus();
        ExtensionPointAccessor extensionPointAccessor = this.transactionService.setStatusAndGetExtensionPoint((Transaction)paymentRequest, (TransactionStatus)PaymentRequestStatus.PROCESSED);
        paymentRequest.setStatus(paymentRequestStatus);
        ScheduledPayment scheduledPayment = null;
        switch (paymentRequest.getScheduling()) {
            case FUTURE_DATE: 
            case MULTIPLE_INSTALLMENTS: {
                scheduledPayment = this.scheduledPaymentService.acceptPaymentRequest(paymentRequest);
                break;
            }
            case NOT_SCHEDULED: {
                scheduledPayment = this.paymentService.acceptPaymentRequest(paymentRequest);
                break;
            }
            case RECURRING: {
                scheduledPayment = this.recurringPaymentService.acceptPaymentRequest(paymentRequest);
            }
        }
        paymentRequest.setStatus(PaymentRequestStatus.PROCESSED);
        paymentRequest.setTransaction((BasePayment)scheduledPayment);
        paymentRequest.setSmsCode(null);
        paymentRequest.setProcessDate(null);
        User user = paymentRequest.getToUser();
        if (user != null) {
            this.notificationHandler.user((BasicUser)user).account().paymentRequestProcessed(paymentRequest, paymentRequest.getCurrencyAmount(), paymentRequest.getType(), (AccountOwner)paymentRequest.getFromOwner(), paymentRequest.getTransactionNumber());
        }
        extensionPointAccessor.fireSaved();
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }

    private void cancel(PaymentRequest paymentRequest, String string) {
        ExtensionPointAccessor extensionPointAccessor = this.transactionService.setStatusAndGetExtensionPoint((Transaction)paymentRequest, (TransactionStatus)PaymentRequestStatus.CANCELED);
        paymentRequest.setComments(string);
        paymentRequest.setSmsCode(null);
        extensionPointAccessor.fireSaved();
    }

    private List<PaymentTransferType> fill(RequestPaymentPayerData requestPaymentPayerData, LocateAccountOwnerResult locateAccountOwnerResult, LocateAccountOwnerResult locateAccountOwnerResult2, PaymentTransferType paymentTransferType) {
        requestPaymentPayerData.setPayee((InternalAccountOwner)this.accountHandler.toAccountOwnerVO(locateAccountOwnerResult));
        requestPaymentPayerData.setPayer((InternalAccountOwner)this.accountHandler.toAccountOwnerVO(locateAccountOwnerResult2));
        List<PaymentTransferType> list = this.listPaymentTypes(locateAccountOwnerResult.getInternalAccountOwner(), locateAccountOwnerResult2.getInternalAccountOwner(), null);
        if (paymentTransferType != null && !list.contains(paymentTransferType)) {
            this.throwInvalidTransferType();
        }
        if (paymentTransferType != null) {
            list = Collections.singletonList(paymentTransferType);
        }
        List list2 = this.conversionHandler.convertList(TransferTypeWithCurrencyVO.class, list);
        requestPaymentPayerData.setPaymentTypes(list2);
        if (paymentTransferType == null) {
            paymentTransferType = (PaymentTransferType)CollectionHelper.first(list);
        }
        if (paymentTransferType != null) {
            requestPaymentPayerData.setPaymentTypeData(this.toRequestPaymentTypeData(locateAccountOwnerResult.getInternalAccountOwner(), locateAccountOwnerResult2.getInternalAccountOwner(), paymentTransferType));
        }
        return list;
    }

    private String generateSmsCode(User user) {
        Channel channel = this.channelService.getSms();
        SmsChannelConfiguration smsChannelConfiguration = (SmsChannelConfiguration)this.configurationHandler.getAccessor((BasicUser)user).getChannelConfiguration(channel);
        boolean bl = smsChannelConfiguration != null && smsChannelConfiguration.isEnabled() && smsChannelConfiguration.getOperations().stream().anyMatch(smsOperationConfiguration -> smsOperationConfiguration instanceof AcceptPaymentRequestSmsOperationConfiguration || smsOperationConfiguration instanceof DenyPaymentRequestSmsOperationConfiguration);
        String string = null;
        if (bl) {
            int n = 0;
            while (this.getBySmsCode(string = SecureRandomHelper.randomUppercase((int)3), user) != null && n++ < 5) {
            }
        }
        return string;
    }

    private Date getDefaultExpiration(PaymentTransferType paymentTransferType) {
        TimeInterval timeInterval = paymentTransferType.getDefaultPaymentRequestExpirationPeriod();
        if (timeInterval == null || timeInterval.getAmount() == null || timeInterval.getField() == null) {
            return null;
        }
        Date date = DateHelper.add((Date)new Date(), (ITimeInterval)timeInterval);
        return DateHelper.shiftToEnd((Date)date, (TimeZone)this.getConfiguration().getTimeZone());
    }

    private List<PaymentTransferType> listPaymentTypes(InternalAccountOwner internalAccountOwner, InternalAccountOwner internalAccountOwner2, Currency currency) {
        PaymentTransferTypeQuery paymentTransferTypeQuery = new PaymentTransferTypeQuery();
        paymentTransferTypeQuery.setUnlimited();
        paymentTransferTypeQuery.setFromOwner(internalAccountOwner2);
        paymentTransferTypeQuery.setToOwner((AccountOwner)internalAccountOwner);
        paymentTransferTypeQuery.setCurrency(currency);
        paymentTransferTypeQuery.setToAccounts((Collection)this.accountService.listVisible(internalAccountOwner));
        return this.transferTypeService.searchPaymentRequest(paymentTransferTypeQuery).getPageItems();
    }

    private void throwInvalidTransferType() {
        String string = this.message(BankingKeys.Transactions.TYPE, new Object[0]);
        String string2 = this.message(GeneralKeys.Errors.INVALID, string);
        throw new ValidationException(PerformPaymentDTO.TYPE.getName(), string2);
    }

    private RequestPaymentTypeData toRequestPaymentTypeData(InternalAccountOwner internalAccountOwner, InternalAccountOwner internalAccountOwner2, PaymentTransferType paymentTransferType) {
        RequestPaymentTypeData requestPaymentTypeData = new RequestPaymentTypeData();
        this.transactionService.fill((AbstractPaymentTypeData)requestPaymentTypeData, this.accountHandler.locateOrCurrent((AccountOwner)internalAccountOwner), this.transactionService.locateForPayment(internalAccountOwner2), paymentTransferType);
        Date date = this.getDefaultExpiration(paymentTransferType);
        if (date != null) {
            requestPaymentTypeData.setDefaultExpirationDate(this.conversionHandler.toDateTime(date));
            requestPaymentTypeData.setHideExpirationDate(paymentTransferType.isHidePaymentRequestExpirationDate());
        }
        return requestPaymentTypeData;
    }

    private void validateAction(PaymentRequest paymentRequest, PaymentRequestActionDTO paymentRequestActionDTO, PaymentRequestAction paymentRequestAction) {
        org.cyclos.impl.utils.validation.Property property;
        Validator validator = new Validator();
        validator.property((Property)PaymentRequestActionDTO.PAYMENT_REQUEST, BankingKeys.Transactions.TRANSACTION).required();
        CredentialAccessor credentialAccessor = this.passwordHandler.accessor(CredentialUsage.CONFIRMATION);
        boolean bl = credentialAccessor.isDefined();
        if (paymentRequestActionDTO instanceof AcceptPaymentRequestDTO) {
            property = validator.property((Property)AcceptPaymentRequestDTO.PROCESS_DATE, BankingKeys.Transactions.PROCESS_DATE).futureDate();
            if (((AcceptPaymentRequestDTO)paymentRequestActionDTO).getProcessDate() != null) {
                property.add((object, object2, object3) -> {
                    Date date = this.conversionHandler.toDate((IDate)((DateTime)object3));
                    return paymentRequest.getExpirationDate().before(date) ? ValidationErrors.lessEquals((Comparable)paymentRequest.getExpirationDate()) : null;
                });
            }
            if (bl) {
                PaymentTransferType paymentTransferType = (PaymentTransferType)paymentRequest.getType();
                boolean bl2 = false;
                Date date = new Date();
                Date date2 = null;
                block0 : switch (paymentRequest.getScheduling()) {
                    case FUTURE_DATE: 
                    case MULTIPLE_INSTALLMENTS: {
                        Object object4;
                        CalculateInstallmentsDTO calculateInstallmentsDTO = new CalculateInstallmentsDTO();
                        calculateInstallmentsDTO.setInstallmentsCount(paymentRequest.getSchedulingCount());
                        calculateInstallmentsDTO.setAmount(paymentRequest.getAmount());
                        calculateInstallmentsDTO.setOwner(paymentRequest.getToOwner());
                        calculateInstallmentsDTO.setSubject(paymentRequest.getFromOwner());
                        calculateInstallmentsDTO.setType(new TransferTypeVO(paymentTransferType.getId()));
                        calculateInstallmentsDTO.setFirstInstallmentIsNow(paymentRequest.isFirstSchedulingIsImmediate());
                        if (!paymentRequest.isFirstSchedulingIsImmediate()) {
                            object4 = DateHelper.add((Date)date, (ITimeInterval)TimeInterval.ONE_MONTH);
                            calculateInstallmentsDTO.setFirstInstallmentDate(this.conversionHandler.toDateTime((Date)object4));
                        }
                        object4 = this.scheduledPaymentService.calculateInstallments(calculateInstallmentsDTO);
                        Iterator iterator = object4.iterator();
                        while (iterator.hasNext()) {
                            InstallmentDTO installmentDTO = (InstallmentDTO)iterator.next();
                            bl2 = this.transactionService.isCheckConfirmation(paymentTransferType, paymentRequest.getToOwner(), installmentDTO.getAmount(), date);
                            if (!bl2) continue;
                            break block0;
                        }
                        break;
                    }
                    case RECURRING: {
                        date2 = paymentRequest.isFirstSchedulingIsImmediate() ? date : DateHelper.add((Date)new Date(), (TimeField)TimeField.MONTHS, (int)1);
                    }
                    case NOT_SCHEDULED: {
                        bl2 = this.transactionService.isCheckConfirmation(paymentTransferType, paymentRequest.getToOwner(), paymentRequest.getAmount(), date2 != null ? date2 : date);
                    }
                }
                bl = bl2;
            }
        }
        if (bl) {
            credentialAccessor.addRequiredValidation(validator, (Property)PaymentRequestActionDTO.CONFIRMATION_PASSWORD);
        }
        this.validate(validator, paymentRequestActionDTO, "validateAction");
        if (bl) {
            property = ManagePaymentRequestConfirmationField.confirmation((PaymentRequestVO)new PaymentRequestVO(paymentRequest.getId()), (PaymentRequestAction)paymentRequestAction);
            credentialAccessor.check(paymentRequestActionDTO.getConfirmationPassword(), (CreateDeviceConfirmationParams)property);
        }
    }

    private PaymentRequest validateActionAndGet(PaymentRequestActionDTO paymentRequestActionDTO, PaymentRequestAction paymentRequestAction, PaymentRequestStatus ... paymentRequestStatusArray) {
        PaymentRequest paymentRequest = (PaymentRequest)this.conversionHandler.convert(PaymentRequest.class, (Object)paymentRequestActionDTO.getPaymentRequest());
        this.validateAction(paymentRequest, paymentRequestActionDTO, paymentRequestAction);
        if (ObjectHelper.isNotOneOf((Object)paymentRequest.getStatus(), (Object[])paymentRequestStatusArray)) {
            throw new IllegalActionException();
        }
        return paymentRequest;
    }

    private void validateSend(SendPaymentRequestDTO sendPaymentRequestDTO) {
        LocateAccountOwnerResult locateAccountOwnerResult = this.transactionService.locateForPayment(sendPaymentRequestDTO.getOwner());
        LocateAccountOwnerResult locateAccountOwnerResult2 = this.accountHandler.locateOrCurrent((AccountOwner)sendPaymentRequestDTO.getSubject());
        PrepareValidationParameter prepareValidationParameter = new PrepareValidationParameter.Builder((PerformTransactionDTO)sendPaymentRequestDTO, locateAccountOwnerResult2, locateAccountOwnerResult, PaymentCreationType.REQUEST).validateCustomFields(true).allowSearchingTTWhenNoneIsGiven(true).validateConfirmationPassword(false).excludeHideInForm(true).validateNFCChallenge(false).validateAmount(true).build();
        TransactionValidationData transactionValidationData = this.transactionService.prepareValidation(prepareValidationParameter);
        Validator validator = transactionValidationData.getValidator();
        PaymentTransferType paymentTransferType = transactionValidationData.getPaymentType();
        if (paymentTransferType != null) {
            org.cyclos.impl.utils.validation.Property property = validator.property((Property)SendPaymentRequestDTO.EXPIRATION_DATE, BankingKeys.Transactions.EXPIRATION_DATE).futureDate();
            if (paymentTransferType.getDefaultPaymentRequestExpirationPeriod() == null) {
                property.required();
            }
            if (paymentTransferType.isAllowsScheduledPayments()) {
                if (sendPaymentRequestDTO.getScheduling() != null && sendPaymentRequestDTO.getScheduling().useInstallments()) {
                    if (paymentTransferType.getCurrency().getPrecision() == 0 && sendPaymentRequestDTO.getSchedulingCount() > sendPaymentRequestDTO.getAmount().intValue()) {
                        validator.general(GeneralValidations.invalid((ValidationError)new ValidationError(BankingKeys.Transactions.INVALID_INSTALLMENTS_COUNT_FOR_CURRENCY_WITH_SCALE_ZERO)));
                    }
                    validator.property((Property)SendPaymentRequestDTO.SCHEDULING_COUNT, BankingKeys.Transactions.INSTALLMENTS_COUNT).required().positiveIntegerNonZero().lessEquals((Comparable)paymentTransferType.getMaxInstallments());
                }
            } else {
                validator.property((Property)SendPaymentRequestDTO.SCHEDULING, BankingKeys.Transactions.SCHEDULED).noneOf(new Object[]{SchedulingType.FUTURE_DATE, SchedulingType.MULTIPLE_INSTALLMENTS});
            }
            if (paymentTransferType.isAllowsRecurringPayments()) {
                if (sendPaymentRequestDTO.getScheduling() == SchedulingType.RECURRING) {
                    if (sendPaymentRequestDTO.getSchedulingCount() != null) {
                        validator.property((Property)SendPaymentRequestDTO.SCHEDULING_COUNT, BankingKeys.Transactions.OCCURRENCE_COUNT).greaterThan((Comparable)Integer.valueOf(1)).lessEquals((Comparable)Integer.valueOf(2000));
                    }
                    validator.property((Property)SendPaymentRequestDTO.OCCURRENCE_INTERVAL, BankingKeys.Transactions.OCCURRENCE_INTERVAL).required().positiveIntegerNonZero().minInterval(1, TimeField.DAYS).maxInterval(1, TimeField.YEARS);
                }
            } else {
                validator.property((Property)SendPaymentRequestDTO.SCHEDULING, BankingKeys.Transactions.SCHEDULED).noneOf(new Object[]{SchedulingType.RECURRING});
            }
        }
        this.validate(validator, sendPaymentRequestDTO, "validateSend");
    }
}

