/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.access.NFCToken;
import org.cyclos.entities.access.Token;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AuthorizationLevel;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.Installment;
import org.cyclos.entities.banking.InstallmentTransfer;
import org.cyclos.entities.banking.PaymentRequest;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.QRecurringPayment;
import org.cyclos.entities.banking.QRecurringPaymentOccurrence;
import org.cyclos.entities.banking.RecurringPayment;
import org.cyclos.entities.banking.RecurringPaymentOccurrence;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.TransactionCustomFieldValue;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.InstallmentProcessingRecurringTask;
import org.cyclos.impl.banking.LocateAccountOwnerResult;
import org.cyclos.impl.banking.PaymentServiceLocal;
import org.cyclos.impl.banking.PrepareValidationParameter;
import org.cyclos.impl.banking.RecurringPaymentServiceLocal;
import org.cyclos.impl.banking.TransactionAuthorizationServiceLocal;
import org.cyclos.impl.banking.TransactionCustomFieldServiceLocal;
import org.cyclos.impl.banking.TransactionNotificationProcessingRecurringTask;
import org.cyclos.impl.banking.TransactionServiceLocal;
import org.cyclos.impl.banking.TransactionValidationData;
import org.cyclos.impl.banking.TransferServiceLocal;
import org.cyclos.impl.locks.LockHandler;
import org.cyclos.impl.locks.LockType;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ExtensionPointAccessor;
import org.cyclos.impl.system.ExtensionPointFilter;
import org.cyclos.impl.system.ExtensionPointServiceLocal;
import org.cyclos.impl.users.TransactionFeedbackServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.tasks.RecurringTaskHandler;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.StaleEntityException;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.authorizations.AuthorizationAction;
import org.cyclos.model.banking.transactions.BasePaymentPreviewVO;
import org.cyclos.model.banking.transactions.InstallmentActionDTO;
import org.cyclos.model.banking.transactions.InstallmentStatus;
import org.cyclos.model.banking.transactions.InstallmentVO;
import org.cyclos.model.banking.transactions.ManageRecurringPaymentConfirmationField;
import org.cyclos.model.banking.transactions.ManageRecurringPaymentFailedOccurrenceConfirmationField;
import org.cyclos.model.banking.transactions.PaymentCreationType;
import org.cyclos.model.banking.transactions.PaymentPreviewVO;
import org.cyclos.model.banking.transactions.PaymentRequestStatus;
import org.cyclos.model.banking.transactions.PerformInternalTransactionDTO;
import org.cyclos.model.banking.transactions.PerformPaymentConfirmationField;
import org.cyclos.model.banking.transactions.PerformPaymentDTO;
import org.cyclos.model.banking.transactions.PerformRecurringPaymentDTO;
import org.cyclos.model.banking.transactions.PerformScheduledPaymentDTO;
import org.cyclos.model.banking.transactions.PerformTransactionDTO;
import org.cyclos.model.banking.transactions.RecurringPaymentAction;
import org.cyclos.model.banking.transactions.RecurringPaymentActionDTO;
import org.cyclos.model.banking.transactions.RecurringPaymentDTO;
import org.cyclos.model.banking.transactions.RecurringPaymentData;
import org.cyclos.model.banking.transactions.RecurringPaymentEditData;
import org.cyclos.model.banking.transactions.RecurringPaymentFailedOccurrenceAction;
import org.cyclos.model.banking.transactions.RecurringPaymentPreviewVO;
import org.cyclos.model.banking.transactions.RecurringPaymentStatus;
import org.cyclos.model.banking.transactions.RecurringPaymentVO;
import org.cyclos.model.banking.transactions.SchedulingType;
import org.cyclos.model.banking.transactions.TransactionData;
import org.cyclos.model.banking.transactions.TransactionStatus;
import org.cyclos.model.banking.transfers.TransferVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.system.extensionpoints.ExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.TransactionExtensionPointEvent;
import org.cyclos.model.system.fields.CustomFieldValueDTO;
import org.cyclos.model.system.fields.ModelWithCustomValues;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.TimeField;
import org.cyclos.model.utils.TimeIntervalDTO;
import org.cyclos.security.banking.TransactionServiceSecurity;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.IDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecurringPaymentServiceImpl
extends BaseServiceImpl
implements RecurringPaymentServiceLocal {
    private static final QRecurringPayment $ = QRecurringPayment.recurringPayment;
    @Autowired
    private TransferServiceLocal transferService;
    @Autowired
    private TransactionServiceLocal transactionService;
    @Autowired
    private PaymentServiceLocal paymentService;
    @Autowired
    private PasswordHandler passwordHandler;
    @Autowired
    private TransactionAuthorizationServiceLocal transactionAuthorizationService;
    @Autowired
    private TransactionFeedbackServiceLocal transactionFeedbackService;
    @Autowired
    private ExtensionPointServiceLocal extensionPointService;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private TransactionCustomFieldServiceLocal transactionCustomFieldServiceLocal;
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private RecurringTaskHandler recurringTaskHandler;
    @Autowired
    private TransactionServiceSecurity transactionServiceSecurity;
    @Autowired
    private LockHandler lockHandler;

    public RecurringPayment acceptPaymentRequest(PaymentRequest paymentRequest) {
        PerformRecurringPaymentDTO performRecurringPaymentDTO = this.toPerformDTO(paymentRequest, false);
        RecurringPayment recurringPayment = new RecurringPayment();
        recurringPayment.setShowToReceiver(true);
        if (paymentRequest.getBy() instanceof Operator) {
            recurringPayment.setReceivedBy((Operator)paymentRequest.getBy());
        }
        return this.doPerform(performRecurringPaymentDTO, null, null, recurringPayment, PaymentCreationType.REQUEST);
    }

    public void block(RecurringPaymentActionDTO recurringPaymentActionDTO) throws FrameworkException {
        RecurringPayment recurringPayment = this.checkPasswordAndGet(recurringPaymentActionDTO.getRecurringPayment(), recurringPaymentActionDTO.getConfirmationPassword(), RecurringPaymentAction.BLOCK);
        this.checkOpenStatus(recurringPayment);
        ExtensionPointAccessor extensionPointAccessor = this.transactionService.setStatusAndGetExtensionPoint((Transaction)recurringPayment, (TransactionStatus)RecurringPaymentStatus.BLOCKED);
        for (RecurringPaymentOccurrence recurringPaymentOccurrence : recurringPayment.getInstallments()) {
            if (recurringPaymentOccurrence.getStatus() != InstallmentStatus.SCHEDULED) continue;
            this.transactionService.setStatusAndGetExtensionPoint((Installment)recurringPaymentOccurrence, InstallmentStatus.BLOCKED).fireSaved();
        }
        extensionPointAccessor.fireSaved();
    }

    public void cancel(RecurringPaymentActionDTO recurringPaymentActionDTO) throws FrameworkException {
        RecurringPayment recurringPayment = this.checkPasswordAndGet(recurringPaymentActionDTO.getRecurringPayment(), recurringPaymentActionDTO.getConfirmationPassword(), RecurringPaymentAction.CANCEL);
        this.cancel(recurringPayment);
    }

    public int cancelAll(UserAccount userAccount) {
        if (userAccount.isTransient()) {
            return 0;
        }
        CloseableIterator closeableIterator = ((DBQuery)this.from(new EntityPath[]{$}).where(new Predicate[]{$.from().eq((Object)userAccount).or((Predicate)$.to().eq((Object)userAccount)), RecurringPaymentServiceImpl.$.status.in((Object[])new String[]{RecurringPaymentStatus.OPEN.name()})})).iterate((Expression)$);
        return (int)this.processBatch(closeableIterator, this::cancel);
    }

    public RecurringPaymentData getData(Long l) throws FrameworkException {
        RecurringPayment recurringPayment = this.find(RecurringPayment.class, l);
        return this.getData(recurringPayment);
    }

    public RecurringPaymentData getData(RecurringPayment recurringPayment) {
        RecurringPaymentData recurringPaymentData = (RecurringPaymentData)this.transactionService.newData((Transaction)recurringPayment, true);
        this.fillCommonData(recurringPaymentData, recurringPayment);
        return recurringPaymentData;
    }

    public RecurringPaymentEditData getEditData(@NotNull RecurringPaymentVO recurringPaymentVO) throws FrameworkException {
        RecurringPayment recurringPayment = (RecurringPayment)this.conversionHandler.convert(RecurringPayment.class, (Object)recurringPaymentVO);
        RecurringPaymentEditData recurringPaymentEditData = new RecurringPaymentEditData();
        this.transactionService.fill((TransactionData)recurringPaymentEditData, (Transaction)recurringPayment, true);
        this.fillCommonData((RecurringPaymentData)recurringPaymentEditData, recurringPayment);
        RecurringPaymentDTO recurringPaymentDTO = (RecurringPaymentDTO)this.conversionHandler.convert(RecurringPaymentDTO.class, (Object)recurringPayment);
        recurringPaymentDTO.setUntilCanceled(recurringPaymentDTO.getOccurrencesCount() == null);
        recurringPaymentEditData.setDetails(recurringPaymentDTO);
        return recurringPaymentEditData;
    }

    @PostConstruct
    public void initialize() {
        this.transactionAuthorizationService.registerHandler(AuthorizationAction.AUTHORIZED, RecurringPayment.class, this::onRecurringPaymentAuthorized);
    }

    public void markAsFailed(RecurringPaymentOccurrence recurringPaymentOccurrence) {
        RecurringPayment recurringPayment = recurringPaymentOccurrence.getRecurringPayment();
        ExtensionPointAccessor extensionPointAccessor = this.transactionService.setStatusAndGetExtensionPoint((Installment)recurringPaymentOccurrence, InstallmentStatus.FAILED);
        if (recurringPayment.isFromUser()) {
            this.notificationHandler.user(recurringPayment.getPerformer()).account().recurringPaymentFailed(recurringPaymentOccurrence, Integer.valueOf(recurringPaymentOccurrence.getNumber()), recurringPaymentOccurrence.getCurrencyAmount(), recurringPayment.getType(), (AccountOwner)recurringPayment.getToOwner());
        }
        if (recurringPayment.isToUser() && recurringPayment.isShowToReceiver()) {
            this.notificationHandler.user(recurringPayment.getReceiver()).account().incomingRecurringPaymentFailed(recurringPaymentOccurrence, Integer.valueOf(recurringPaymentOccurrence.getNumber()), recurringPaymentOccurrence.getCurrencyAmount(), recurringPayment.getType(), (AccountOwner)recurringPayment.getFromOwner());
        }
        extensionPointAccessor.fireSaved();
        this.maybeInsertNextOccurrence(recurringPaymentOccurrence);
    }

    public void modify(RecurringPaymentDTO recurringPaymentDTO, String string) throws FrameworkException {
        RecurringPayment recurringPayment = (RecurringPayment)this.conversionHandler.convert(RecurringPayment.class, (Object)recurringPaymentDTO);
        this.checkOpenStatus(recurringPayment);
        Validator validator = new Validator();
        this.appendCommonValidations(validator, null, recurringPaymentDTO);
        if (!Objects.equals(recurringPaymentDTO.getVersion(), recurringPayment.getVersion())) {
            throw new StaleEntityException();
        }
        QRecurringPaymentOccurrence qRecurringPaymentOccurrence = QRecurringPaymentOccurrence.recurringPaymentOccurrence;
        int n = ((DBQuery)this.from(new EntityPath[]{qRecurringPaymentOccurrence}).where(new Predicate[]{qRecurringPaymentOccurrence.status.in(Arrays.asList(InstallmentStatus.PROCESSED, InstallmentStatus.SETTLED, InstallmentStatus.FAILED)), qRecurringPaymentOccurrence.transaction().eq((Object)recurringPayment)})).count(qRecurringPaymentOccurrence.id);
        if (recurringPaymentDTO.getOccurrencesCount() != null) {
            validator.property((Property)PerformRecurringPaymentDTO.OCCURRENCES_COUNT, BankingKeys.Transactions.OCCURRENCE_COUNT).greaterThan((Comparable)Integer.valueOf(n));
        }
        this.validate(validator, recurringPaymentDTO, "modify");
        this.checkPassword(recurringPayment, string, RecurringPaymentAction.MODIFY);
        this.delete((EntityPath<?>)qRecurringPaymentOccurrence).where(new Predicate[]{qRecurringPaymentOccurrence.status.eq((Object)InstallmentStatus.SCHEDULED), qRecurringPaymentOccurrence.transaction().eq((Object)recurringPayment)}).execute();
        this.insertOcurrences(recurringPaymentDTO.isFirstOccurrenceIsNow(), recurringPaymentDTO.getFirstOccurrenceDate(), recurringPayment.getFromUser(), recurringPayment, n);
    }

    public void notifyPaymentPerformed(RecurringPayment recurringPayment) {
        if (recurringPayment.isPendingAuthorization()) {
            this.transactionAuthorizationService.notifyPendingAuthorization((BasePayment)recurringPayment);
        } else {
            this.transactionFeedbackService.notifyTransactionFeedback((PaymentTransferType)recurringPayment.getType());
            this.notifyReceiver(recurringPayment);
        }
    }

    public RecurringPaymentVO perform(PerformRecurringPaymentDTO performRecurringPaymentDTO) throws FrameworkException {
        RecurringPayment recurringPayment = this.doPerform(performRecurringPaymentDTO, null);
        return (RecurringPaymentVO)this.conversionHandler.convert(RecurringPaymentVO.class, (Object)recurringPayment);
    }

    public RecurringPaymentPreviewVO preview(PerformRecurringPaymentDTO performRecurringPaymentDTO) throws FrameworkException {
        return this.doPreview(performRecurringPaymentDTO, true, null);
    }

    public RecurringPaymentPreviewVO previewAcceptPaymentRequest(PaymentRequest paymentRequest) {
        PerformRecurringPaymentDTO performRecurringPaymentDTO = this.toPerformDTO(paymentRequest, true);
        return this.doPreview(performRecurringPaymentDTO, false, null);
    }

    public RecurringPaymentPreviewVO previewReceive(PerformRecurringPaymentDTO performRecurringPaymentDTO) throws FrameworkException, TransferException {
        SessionData sessionData = this.getSessionData();
        InternalAccountOwner internalAccountOwner = performRecurringPaymentDTO.getOwner();
        return (RecurringPaymentPreviewVO)this.transactionService.receive(internalAccountOwner, () -> this.doPreview(performRecurringPaymentDTO, true, sessionData));
    }

    public TransferVO processFailure(@NotNull InstallmentActionDTO installmentActionDTO) throws FrameworkException, TransferException {
        RecurringPaymentOccurrence recurringPaymentOccurrence = (RecurringPaymentOccurrence)this.conversionHandler.convert(RecurringPaymentOccurrence.class, (Object)installmentActionDTO.getInstallment());
        this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(installmentActionDTO.getConfirmationPassword(), ManageRecurringPaymentFailedOccurrenceConfirmationField.confirmation((InstallmentVO)new InstallmentVO(recurringPaymentOccurrence.getId()), (RecurringPaymentFailedOccurrenceAction)RecurringPaymentFailedOccurrenceAction.PROCESS));
        return (TransferVO)this.conversionHandler.convert(TransferVO.class, (Object)this.processFailure(recurringPaymentOccurrence));
    }

    public InstallmentTransfer processFailure(RecurringPaymentOccurrence recurringPaymentOccurrence) {
        if (recurringPaymentOccurrence.getStatus() != InstallmentStatus.FAILED) {
            throw new IllegalActionException();
        }
        User user = recurringPaymentOccurrence.getRecurringPayment().getToUser();
        if (user != null && user.isRemoved()) {
            throw new IllegalActionException();
        }
        return this.doProcess(recurringPaymentOccurrence);
    }

    public InstallmentTransfer processOccurrence(RecurringPaymentOccurrence recurringPaymentOccurrence) {
        this.lockHandler.lock(LockType.INSTALLMENT.key(recurringPaymentOccurrence.getId()));
        this.entityManagerHandler.refresh((IEntity)recurringPaymentOccurrence);
        InstallmentStatus installmentStatus = recurringPaymentOccurrence.getStatus();
        if (installmentStatus.isTerminal()) {
            throw new IllegalActionException("Can't process this occurrence because its status is " + String.valueOf(installmentStatus));
        }
        RecurringPayment recurringPayment = recurringPaymentOccurrence.getRecurringPayment();
        this.checkOpenStatus(recurringPayment);
        if (recurringPaymentOccurrence.getDueDate().after(new Date())) {
            throw new IllegalActionException("Can't process this occurrence before " + String.valueOf(recurringPaymentOccurrence.getDueDate()));
        }
        PaymentTransferType paymentTransferType = (PaymentTransferType)recurringPayment.getType();
        this.transactionService.validatePaymentAmount(this.accountHandler.locate((AccountOwner)recurringPayment.getFromOwner()), this.accountHandler.locate((AccountOwner)recurringPayment.getToOwner()), paymentTransferType, recurringPayment.getAmount(), new Date());
        InstallmentTransfer installmentTransfer = this.doProcess(recurringPaymentOccurrence);
        this.maybeInsertNextOccurrence(recurringPaymentOccurrence);
        Integer n = recurringPaymentOccurrence.getNumber();
        if (recurringPayment.isFromUser() && paymentTransferType.isNotifyPaymentPerformed()) {
            this.notificationHandler.user(recurringPayment.getPerformer()).account().recurringPaymentOccurrenceProcessed(installmentTransfer, n, installmentTransfer.getCurrencyAmount(), (TransferType)paymentTransferType, (AccountOwner)recurringPayment.getToOwner());
        }
        return installmentTransfer;
    }

    public RecurringPaymentVO receive(PerformRecurringPaymentDTO performRecurringPaymentDTO) throws FrameworkException, TransferException {
        SessionData sessionData = this.getSessionData();
        InternalAccountOwner internalAccountOwner = performRecurringPaymentDTO.getOwner();
        return (RecurringPaymentVO)this.transactionService.receive(internalAccountOwner, () -> {
            RecurringPayment recurringPayment = this.doPerform(performRecurringPaymentDTO, sessionData);
            return (RecurringPaymentVO)this.conversionHandler.convert(RecurringPaymentVO.class, (Object)recurringPayment);
        });
    }

    public void unblock(RecurringPaymentActionDTO recurringPaymentActionDTO) throws FrameworkException {
        RecurringPayment recurringPayment = this.checkPasswordAndGet(recurringPaymentActionDTO.getRecurringPayment(), recurringPaymentActionDTO.getConfirmationPassword(), RecurringPaymentAction.UNBLOCK);
        if (recurringPayment.getStatus() != RecurringPaymentStatus.BLOCKED) {
            throw new IllegalActionException();
        }
        ExtensionPointAccessor extensionPointAccessor = this.transactionService.setStatusAndGetExtensionPoint((Transaction)recurringPayment, (TransactionStatus)RecurringPaymentStatus.OPEN);
        for (RecurringPaymentOccurrence recurringPaymentOccurrence : recurringPayment.getInstallments()) {
            if (recurringPaymentOccurrence.getStatus() != InstallmentStatus.BLOCKED) continue;
            this.transactionService.setStatusAndGetExtensionPoint((Installment)recurringPaymentOccurrence, InstallmentStatus.SCHEDULED).fireSaved();
        }
        extensionPointAccessor.fireSaved();
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }

    private void appendCommonValidations(Validator validator, PerformRecurringPaymentDTO performRecurringPaymentDTO, RecurringPaymentDTO recurringPaymentDTO) {
        boolean bl;
        boolean bl2;
        if (performRecurringPaymentDTO != null) {
            bl2 = performRecurringPaymentDTO.isFirstOccurrenceIsNow();
            bl = performRecurringPaymentDTO.isUntilCanceled();
        } else {
            bl2 = recurringPaymentDTO.isFirstOccurrenceIsNow();
            bl = recurringPaymentDTO.isUntilCanceled();
        }
        if (!bl2) {
            validator.property((Property)PerformRecurringPaymentDTO.FIRST_OCCURRENCE_DATE, BankingKeys.Transactions.FIRST_OCCURRENCE_DATE).required().futureDate();
        }
        if (!bl) {
            validator.property((Property)PerformRecurringPaymentDTO.OCCURRENCES_COUNT, BankingKeys.Transactions.OCCURRENCE_COUNT).required().greaterThan((Comparable)Integer.valueOf(1)).lessEquals((Comparable)Integer.valueOf(2000));
        }
        validator.property((Property)PerformRecurringPaymentDTO.OCCURRENCE_INTERVAL, BankingKeys.Transactions.OCCURRENCE_INTERVAL).required().positiveIntegerNonZero().minInterval(1, TimeField.DAYS).maxInterval(1, TimeField.YEARS);
    }

    private void cancel(RecurringPayment recurringPayment) {
        this.checkOpenStatus(recurringPayment);
        ExtensionPointAccessor extensionPointAccessor = this.transactionService.setStatusAndGetExtensionPoint((Transaction)recurringPayment, (TransactionStatus)RecurringPaymentStatus.CANCELED);
        recurringPayment.getOccurrences().stream().filter(recurringPaymentOccurrence -> recurringPaymentOccurrence.getStatus() == InstallmentStatus.SCHEDULED || recurringPaymentOccurrence.getStatus() == InstallmentStatus.BLOCKED).forEach(recurringPaymentOccurrence -> this.transactionService.setStatusAndGetExtensionPoint((Installment)recurringPaymentOccurrence, InstallmentStatus.CANCELED).fireSaved());
        if (recurringPayment.isToUser() && recurringPayment.isShowToReceiver()) {
            this.notificationHandler.user(recurringPayment.getReceiver()).account().incomingRecurringPaymentCanceled(recurringPayment, recurringPayment.getCurrencyAmount(), recurringPayment.getType(), (AccountOwner)recurringPayment.getFromOwner());
        }
        extensionPointAccessor.fireSaved();
    }

    private void checkOpenStatus(RecurringPayment recurringPayment) {
        if (recurringPayment.getStatus() != RecurringPaymentStatus.OPEN) {
            throw new IllegalActionException();
        }
    }

    private void checkPassword(RecurringPayment recurringPayment, String string, RecurringPaymentAction recurringPaymentAction) {
        this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(string, ManageRecurringPaymentConfirmationField.confirmation((RecurringPaymentVO)new RecurringPaymentVO(recurringPayment.getId()), (RecurringPaymentAction)recurringPaymentAction));
    }

    private RecurringPayment checkPasswordAndGet(RecurringPaymentVO recurringPaymentVO, String string, RecurringPaymentAction recurringPaymentAction) {
        RecurringPayment recurringPayment = (RecurringPayment)this.conversionHandler.convert(RecurringPayment.class, (Object)recurringPaymentVO);
        this.checkPassword(recurringPayment, string, recurringPaymentAction);
        return recurringPayment;
    }

    private RecurringPayment doPerform(PerformRecurringPaymentDTO performRecurringPaymentDTO, LocateAccountOwnerResult locateAccountOwnerResult, LocateAccountOwnerResult locateAccountOwnerResult2, RecurringPayment recurringPayment, PaymentCreationType paymentCreationType) {
        if (locateAccountOwnerResult == null) {
            locateAccountOwnerResult = this.accountHandler.locateOrCurrent((AccountOwner)performRecurringPaymentDTO.getOwner());
        }
        if (locateAccountOwnerResult2 == null) {
            locateAccountOwnerResult2 = this.transactionService.locateForPayment(performRecurringPaymentDTO.getSubject());
        }
        String string = performRecurringPaymentDTO.getFromName();
        String string2 = performRecurringPaymentDTO.getToName();
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)performRecurringPaymentDTO.getType());
        BigDecimal bigDecimal = BigDecimalHelper.round((BigDecimal)performRecurringPaymentDTO.getAmount(), (int)paymentTransferType.getCurrency().getPrecision());
        this.transactionService.validateMinTimeBetweenPayments(locateAccountOwnerResult, paymentTransferType);
        Account account = this.accountService.load(locateAccountOwnerResult.getInternalAccountOwner(), paymentTransferType.getFrom());
        Account account2 = this.accountService.load(locateAccountOwnerResult2.getInternalAccountOwner(), paymentTransferType.getTo());
        ExtensionPointAccessor extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)TransactionExtensionPointEvent.CONFIRM, new ExtensionPointFilter((TransferType)paymentTransferType)).attribute("performTransaction", (Object)performRecurringPaymentDTO).attribute("fromAccount", (Object)account).attribute("fromOwner", (Object)locateAccountOwnerResult.getAccountOwner()).attribute("fromOwnerResult", (Object)locateAccountOwnerResult).attribute("toAccount", (Object)account2).attribute("toOwner", (Object)locateAccountOwnerResult2.getAccountOwner()).attribute("toOwnerResult", (Object)locateAccountOwnerResult2).attribute("paymentType", (Object)paymentTransferType);
        extensionPointAccessor.fireValidated();
        this.transactionService.fill((Transaction)recurringPayment, (TransferType)paymentTransferType, paymentCreationType, account, account2, (BasicUser)locateAccountOwnerResult2.getOperator(), string, string2, bigDecimal, performRecurringPaymentDTO.getDescription(), (Collection)performRecurringPaymentDTO.getCustomValues());
        recurringPayment.setOccurrencesCount(performRecurringPaymentDTO.isUntilCanceled() ? null : performRecurringPaymentDTO.getOccurrencesCount());
        recurringPayment.setOccurrenceInterval((TimeInterval)this.conversionHandler.convert(TimeInterval.class, (Object)performRecurringPaymentDTO.getOccurrenceInterval()));
        if (!recurringPayment.isPendingAuthorization()) {
            recurringPayment.setStatus(RecurringPaymentStatus.OPEN);
        }
        recurringPayment.setPendingNotification(recurringPayment.isPendingAuthorization() || this.shouldNotifyReceiver(recurringPayment));
        this.transactionService.persist((Transaction)recurringPayment);
        this.insertOcurrences(performRecurringPaymentDTO.isFirstOccurrenceIsNow(), performRecurringPaymentDTO.getFirstOccurrenceDate(), locateAccountOwnerResult.isUser() ? locateAccountOwnerResult.getUser() : null, recurringPayment, 0);
        if (recurringPayment.isPendingAuthorization()) {
            this.transactionAuthorizationService.authorizeFirstLevelIfNeeded((BasePayment)recurringPayment);
        } else if (performRecurringPaymentDTO.isFirstOccurrenceIsNow()) {
            this.processOccurrence((RecurringPaymentOccurrence)CollectionHelper.first((Iterable)recurringPayment.getOccurrences()));
        }
        if (recurringPayment.isPendingNotification()) {
            this.recurringTaskHandler.scheduleAwake(TransactionNotificationProcessingRecurringTask.class);
        }
        extensionPointAccessor.attribute("transaction", (Object)recurringPayment).fireSaved();
        return recurringPayment;
    }

    private RecurringPayment doPerform(PerformRecurringPaymentDTO performRecurringPaymentDTO, SessionData sessionData) {
        RecurringPayment recurringPayment;
        boolean bl;
        Token token;
        this.validate(performRecurringPaymentDTO, sessionData, true, false, false, true);
        InternalAccountOwner internalAccountOwner = performRecurringPaymentDTO.getOwner();
        InternalAccountOwner internalAccountOwner2 = performRecurringPaymentDTO.getSubject();
        boolean bl2 = sessionData != null;
        LocateAccountOwnerResult locateAccountOwnerResult = sessionData == null ? this.accountHandler.locateOrCurrent((AccountOwner)internalAccountOwner) : (LocateAccountOwnerResult)this.invokerHandler.runAs(sessionData, () -> this.transactionService.locateForReceiving(internalAccountOwner));
        PaymentCreationType paymentCreationType = bl2 ? PaymentCreationType.POS : PaymentCreationType.DIRECT;
        LocateAccountOwnerResult locateAccountOwnerResult2 = bl2 ? this.accountHandler.locate((AccountOwner)internalAccountOwner2) : this.transactionService.locateForPayment(internalAccountOwner2);
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)performRecurringPaymentDTO.getType());
        Date date = performRecurringPaymentDTO.isFirstOccurrenceIsNow() ? new Date() : this.conversionHandler.toDate((IDate)performRecurringPaymentDTO.getFirstOccurrenceDate());
        boolean bl3 = this.transactionService.isCheckConfirmation(paymentTransferType, locateAccountOwnerResult.getInternalAccountOwner(), performRecurringPaymentDTO.getAmount(), date);
        if (bl3) {
            this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(performRecurringPaymentDTO.getConfirmationPassword(), PerformPaymentConfirmationField.confirmation((PerformInternalTransactionDTO)performRecurringPaymentDTO));
        }
        if ((token = this.getSessionData().getToken()) instanceof NFCToken) {
            ((NFCToken)token).resetChallenge();
        }
        this.transactionServiceSecurity.checkPaymentParameters(locateAccountOwnerResult, locateAccountOwnerResult2, paymentCreationType, paymentTransferType);
        boolean bl4 = bl = bl2 || paymentTransferType.isShowRecurringPaymentsToReceiver();
        if (!bl && paymentTransferType.isRequiresAuthorization()) {
            recurringPayment = (AuthorizationLevel)CollectionHelper.first((Iterable)paymentTransferType.getAuthorizationLevels());
            bl = recurringPayment != null && recurringPayment.isReceiver();
        }
        recurringPayment = new RecurringPayment();
        recurringPayment.setShowToReceiver(bl);
        recurringPayment.setCreationType(paymentCreationType);
        if (sessionData != null) {
            recurringPayment.setReceivedBy(sessionData.getLoggedOperator());
            recurringPayment.setAccessClient(sessionData.getAccessClient());
        }
        this.doPerform(performRecurringPaymentDTO, locateAccountOwnerResult, locateAccountOwnerResult2, recurringPayment, paymentCreationType);
        return recurringPayment;
    }

    private RecurringPaymentPreviewVO doPreview(PerformRecurringPaymentDTO performRecurringPaymentDTO, boolean bl, SessionData sessionData) {
        LocateAccountOwnerResult locateAccountOwnerResult;
        PaymentCreationType paymentCreationType;
        this.validate(performRecurringPaymentDTO, sessionData, bl, false, true, false);
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)performRecurringPaymentDTO.getType());
        LocateAccountOwnerResult locateAccountOwnerResult2 = sessionData == null ? this.transactionService.locateForPayment(performRecurringPaymentDTO.getSubject()) : this.accountHandler.locate((AccountOwner)performRecurringPaymentDTO.getSubject());
        InternalAccountOwner internalAccountOwner = performRecurringPaymentDTO.getOwner();
        if (sessionData == null) {
            paymentCreationType = PaymentCreationType.DIRECT;
            locateAccountOwnerResult = this.accountHandler.locate((AccountOwner)internalAccountOwner);
        } else {
            paymentCreationType = PaymentCreationType.POS;
            locateAccountOwnerResult = (LocateAccountOwnerResult)this.invokerHandler.runAs(sessionData, () -> this.transactionService.locateForReceiving(internalAccountOwner));
        }
        InternalAccountOwner internalAccountOwner2 = locateAccountOwnerResult.getInternalAccountOwner();
        InternalAccountOwner internalAccountOwner3 = locateAccountOwnerResult2.getInternalAccountOwner();
        BigDecimal bigDecimal = performRecurringPaymentDTO.getAmount();
        if (bigDecimal == null && paymentTransferType.isUseFixedAmount()) {
            bigDecimal = paymentTransferType.getFixedAmount();
            performRecurringPaymentDTO.setAmount(bigDecimal);
        }
        PerformPaymentDTO performPaymentDTO = (PerformPaymentDTO)this.conversionHandler.convertExcluding(PerformPaymentDTO.class, (Object)performRecurringPaymentDTO, new Object[]{PerformPaymentDTO.OWNER, PerformPaymentDTO.SUBJECT});
        performPaymentDTO.setOwner(performRecurringPaymentDTO.getOwner());
        performPaymentDTO.setSubject(performRecurringPaymentDTO.getSubject());
        PaymentPreviewVO paymentPreviewVO = this.paymentService.doPreview(performPaymentDTO, bl, false, sessionData, paymentCreationType);
        AuthorizationLevel authorizationLevel = (AuthorizationLevel)paymentPreviewVO.getAttribute(AuthorizationLevel.class.getSimpleName());
        this.customFieldValueHandler.resolveValues(TransactionCustomField.class, (Collection)performRecurringPaymentDTO.getCustomValues());
        RecurringPaymentPreviewVO recurringPaymentPreviewVO = (RecurringPaymentPreviewVO)this.conversionHandler.convert(RecurringPaymentPreviewVO.class, (Object)paymentPreviewVO);
        recurringPaymentPreviewVO.setRecurringPayment(performRecurringPaymentDTO);
        Account account = this.accountService.load(internalAccountOwner2, paymentTransferType.getFrom());
        Account account2 = this.accountService.load(internalAccountOwner3, paymentTransferType.getTo());
        ExtensionPointAccessor extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)TransactionExtensionPointEvent.PREVIEW, new ExtensionPointFilter((TransferType)paymentTransferType)).attribute("performTransaction", (Object)performRecurringPaymentDTO).attribute("paymentType", (Object)paymentTransferType).attribute("fromAccount", (Object)account).attribute("fromOwner", (Object)internalAccountOwner2).attribute("fromOwnerResult", (Object)locateAccountOwnerResult).attribute("toAccount", (Object)account2).attribute("toOwner", (Object)internalAccountOwner3).attribute("toOwnerResult", (Object)locateAccountOwnerResult2).attribute("preview", (Object)recurringPaymentPreviewVO).attribute("authorizationLevel", (Object)authorizationLevel);
        extensionPointAccessor.fireValidated();
        this.transactionService.updatePreviewAndPayment((BasePaymentPreviewVO)recurringPaymentPreviewVO, (PerformTransactionDTO)performRecurringPaymentDTO, locateAccountOwnerResult, locateAccountOwnerResult2, (TransferType)paymentTransferType, sessionData);
        extensionPointAccessor.fireSaved();
        return recurringPaymentPreviewVO;
    }

    private InstallmentTransfer doProcess(RecurringPaymentOccurrence recurringPaymentOccurrence) {
        ExtensionPointAccessor extensionPointAccessor = this.transactionService.setStatusAndGetExtensionPoint((Installment)recurringPaymentOccurrence, InstallmentStatus.PROCESSED);
        InstallmentTransfer installmentTransfer = this.transferService.insertInstallmentTransfer((Installment)recurringPaymentOccurrence);
        extensionPointAccessor.fireSaved();
        this.maybeClose(recurringPaymentOccurrence.getRecurringPayment());
        return installmentTransfer;
    }

    private void fillCommonData(RecurringPaymentData recurringPaymentData, RecurringPayment recurringPayment) {
        boolean bl = recurringPayment.getStatus() == RecurringPaymentStatus.OPEN;
        boolean bl2 = recurringPayment.getStatus() == RecurringPaymentStatus.BLOCKED;
        recurringPaymentData.setCanCancel(bl || bl2);
        recurringPaymentData.setCanModify(bl);
        recurringPaymentData.setCanBlock(bl);
        recurringPaymentData.setCanUnblock(bl2);
        List list = recurringPayment.getOccurrences();
        recurringPaymentData.setCanProcessFailed(list.stream().anyMatch(recurringPaymentOccurrence -> recurringPaymentOccurrence.getStatus() == InstallmentStatus.FAILED));
        recurringPaymentData.setOccurrences(this.conversionHandler.convertList(InstallmentVO.class, (Iterable)list));
    }

    private RecurringPaymentOccurrence insertOccurrence(RecurringPayment recurringPayment, int n, Date date) {
        RecurringPaymentOccurrence recurringPaymentOccurrence = new RecurringPaymentOccurrence();
        recurringPaymentOccurrence.setRecurringPayment(recurringPayment);
        recurringPaymentOccurrence.setNumber(n);
        recurringPaymentOccurrence.setDueDate(date);
        recurringPaymentOccurrence.setAmount(recurringPayment.getAmount());
        recurringPaymentOccurrence.setStatus(recurringPayment.isPendingAuthorization() ? null : InstallmentStatus.SCHEDULED);
        this.persist((IEntity)recurringPaymentOccurrence);
        recurringPayment.getOccurrences().add(recurringPaymentOccurrence);
        return recurringPaymentOccurrence;
    }

    private void insertOcurrences(boolean bl, DateTime dateTime, User user, RecurringPayment recurringPayment, int n) {
        ConfigurationAccessor configurationAccessor = user != null ? this.configurationHandler.getAccessor((BasicUser)user) : this.getConfiguration();
        Date date = DateHelper.shiftToBegin((Date)(bl ? new Date() : this.conversionHandler.toDate((IDate)dateTime)), (TimeZone)configurationAccessor.getTimeZone(), (boolean)true);
        if (recurringPayment.getOccurrencesCount() == null) {
            this.insertOccurrence(recurringPayment, n + 1, date);
        } else {
            for (int i = n; i < recurringPayment.getOccurrencesCount(); ++i) {
                this.insertOccurrence(recurringPayment, i + 1, date);
                date = DateHelper.add((Date)date, (ITimeInterval)recurringPayment.getOccurrenceInterval());
            }
        }
    }

    private void maybeClose(RecurringPayment recurringPayment) {
        if (recurringPayment.getOccurrencesCount() != null) {
            QRecurringPaymentOccurrence qRecurringPaymentOccurrence = QRecurringPaymentOccurrence.recurringPaymentOccurrence;
            int n = ((DBQuery)this.from(new EntityPath[]{qRecurringPaymentOccurrence}).where(new Predicate[]{qRecurringPaymentOccurrence.status.eq((Object)InstallmentStatus.PROCESSED), qRecurringPaymentOccurrence.transaction().eq((Object)recurringPayment)})).count(qRecurringPaymentOccurrence.id);
            if (n == recurringPayment.getOccurrencesCount()) {
                recurringPayment.setStatus(RecurringPaymentStatus.CLOSED);
                ExtensionPointAccessor extensionPointAccessor = this.transactionService.setStatusAndGetExtensionPoint((Transaction)recurringPayment, (TransactionStatus)RecurringPaymentStatus.CLOSED);
                extensionPointAccessor.fireSaved();
            }
        }
    }

    private void maybeInsertNextOccurrence(RecurringPaymentOccurrence recurringPaymentOccurrence2) {
        RecurringPayment recurringPayment = recurringPaymentOccurrence2.getRecurringPayment();
        if (recurringPayment.getOccurrencesCount() == null) {
            int n = recurringPaymentOccurrence2.getNumber() + 1;
            if (!recurringPayment.getOccurrences().stream().anyMatch(recurringPaymentOccurrence -> recurringPaymentOccurrence.getNumber() == n)) {
                Date date = DateHelper.add((Date)recurringPaymentOccurrence2.getDueDate(), (ITimeInterval)recurringPayment.getOccurrenceInterval());
                this.insertOccurrence(recurringPayment, n, date);
            }
        }
    }

    private void notifyReceiver(RecurringPayment recurringPayment) {
        if (this.shouldNotifyReceiver(recurringPayment)) {
            this.notificationHandler.user(recurringPayment.getReceiver()).account().incomingRecurringPaymentReceived(recurringPayment, recurringPayment.getCurrencyAmount(), recurringPayment.getType(), (AccountOwner)recurringPayment.getFromOwner());
        }
    }

    private void onRecurringPaymentAuthorized(RecurringPayment recurringPayment) {
        recurringPayment.setStatus(RecurringPaymentStatus.OPEN);
        for (RecurringPaymentOccurrence recurringPaymentOccurrence : recurringPayment.getOccurrences()) {
            recurringPaymentOccurrence.setStatus(InstallmentStatus.SCHEDULED);
        }
        RecurringPaymentOccurrence recurringPaymentOccurrence = (RecurringPaymentOccurrence)recurringPayment.getFirstScheduledInstallment();
        if (recurringPaymentOccurrence != null && recurringPaymentOccurrence.getDueDate().before(new Date())) {
            this.recurringTaskHandler.scheduleAwake(InstallmentProcessingRecurringTask.class);
        }
        this.notifyReceiver(recurringPayment);
    }

    private boolean shouldNotifyReceiver(RecurringPayment recurringPayment) {
        return recurringPayment.isToUser() && recurringPayment.isShowToReceiver() && recurringPayment.getPaymentRequest() == null;
    }

    private PerformRecurringPaymentDTO toPerformDTO(PaymentRequest paymentRequest, boolean bl) {
        Object object;
        PaymentRequestStatus paymentRequestStatus = paymentRequest.getStatus();
        if (paymentRequest.getScheduling() != SchedulingType.RECURRING || paymentRequestStatus != PaymentRequestStatus.OPEN && paymentRequestStatus != PaymentRequestStatus.SCHEDULED) {
            throw new IllegalActionException();
        }
        PerformRecurringPaymentDTO performRecurringPaymentDTO = new PerformRecurringPaymentDTO();
        performRecurringPaymentDTO.setOwner(paymentRequest.getFromOwner());
        performRecurringPaymentDTO.setSubject(paymentRequest.getToOwner());
        performRecurringPaymentDTO.setAmount(paymentRequest.getAmount());
        performRecurringPaymentDTO.setType((TransferTypeVO)this.conversionHandler.convert(TransferTypeVO.class, (Object)paymentRequest.getType()));
        performRecurringPaymentDTO.setDescription(paymentRequest.getDescription());
        Set set = paymentRequest.getCustomValues();
        Set<TransactionCustomFieldValue> set2 = new HashSet();
        if (CollectionHelper.isNotEmpty((Iterable)set)) {
            object = this.transactionCustomFieldServiceLocal.listVisible((AccountOwner)paymentRequest.getToOwner());
            for (TransactionCustomFieldValue transactionCustomFieldValue : set) {
                if (!object.contains(transactionCustomFieldValue.getField())) continue;
                set2.add(transactionCustomFieldValue);
            }
        } else if (!bl) {
            set2 = set;
        }
        if (bl) {
            performRecurringPaymentDTO.setCustomValues(this.conversionHandler.convertList(CustomFieldValueDTO.class, set2));
        } else {
            this.customFieldValueHandler.cloneCustomValuesData((ModelWithCustomValues)performRecurringPaymentDTO, set2);
        }
        ModelHelper.clearIds((Iterable)performRecurringPaymentDTO.getCustomValues());
        performRecurringPaymentDTO.setFirstOccurrenceIsNow(paymentRequest.isFirstSchedulingIsImmediate());
        performRecurringPaymentDTO.setOccurrencesCount(paymentRequest.getSchedulingCount());
        performRecurringPaymentDTO.setUntilCanceled(paymentRequest.getSchedulingCount() == null);
        if (!paymentRequest.isFirstSchedulingIsImmediate()) {
            object = DateHelper.add((Date)new Date(), (ITimeInterval)paymentRequest.getOccurrenceInterval());
            performRecurringPaymentDTO.setFirstOccurrenceDate(this.conversionHandler.toDateTime((Date)object));
        }
        performRecurringPaymentDTO.setOccurrenceInterval((TimeIntervalDTO)this.conversionHandler.convert(TimeIntervalDTO.class, (Object)paymentRequest.getOccurrenceInterval()));
        return performRecurringPaymentDTO;
    }

    private void validate(PerformRecurringPaymentDTO performRecurringPaymentDTO, SessionData sessionData, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locateOrCurrent((AccountOwner)performRecurringPaymentDTO.getOwner());
        LocateAccountOwnerResult locateAccountOwnerResult2 = this.transactionService.locateForPayment(performRecurringPaymentDTO.getSubject());
        PaymentCreationType paymentCreationType = sessionData != null ? PaymentCreationType.POS : PaymentCreationType.DIRECT;
        PrepareValidationParameter prepareValidationParameter = new PrepareValidationParameter.Builder((PerformTransactionDTO)performRecurringPaymentDTO, locateAccountOwnerResult, locateAccountOwnerResult2, sessionData, paymentCreationType).validateCustomFields(bl).allowSearchingTTWhenNoneIsGiven(true).validateConfirmationPassword(bl2).excludeHideInForm(bl3).validateNFCChallenge(bl4).validateAmount(false).build();
        TransactionValidationData transactionValidationData = this.transactionService.prepareValidation(prepareValidationParameter);
        Validator validator = transactionValidationData.getValidator();
        PaymentTransferType paymentTransferType = transactionValidationData.getPaymentType();
        if (paymentTransferType != null && !paymentTransferType.isAllowsRecurringPayments()) {
            validator.property((Property)PerformScheduledPaymentDTO.TYPE, BankingKeys.Transactions.TYPE).invalid();
        }
        this.appendCommonValidations(validator, performRecurringPaymentDTO, null);
        this.validate(validator, performRecurringPaymentDTO, "performRecurringPaymentDTO");
    }
}

