/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.DateTimeExpression;
import java.util.Collection;
import org.cyclos.entities.banking.QTicket;
import org.cyclos.entities.banking.Ticket;
import org.cyclos.impl.banking.TicketServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.tasks.EntityBatchRecurringTask;
import org.cyclos.model.banking.transactions.TicketStatus;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TicketProcessingRecurringTask
extends EntityBatchRecurringTask<Ticket> {
    @Autowired
    private TicketServiceLocal ticketService;

    public TicketProcessingRecurringTask() {
        super(Ticket.class);
    }

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.TICKET_PROCESSING;
    }

    @Override
    protected void finish(Ticket ticket, Throwable throwable) throws Throwable {
    }

    @Override
    protected Collection<Long> nextIds() throws Throwable {
        QTicket qTicket = QTicket.ticket;
        return ((DBQuery)((DBQuery)this.from(new EntityPath[]{qTicket}).where((Predicate)qTicket.status.eq((Object)TicketStatus.OPEN.name()).or((Predicate)qTicket.status.eq((Object)TicketStatus.APPROVED.name())).and((Predicate)qTicket.expirationDate.before((Expression)DateTimeExpression.currentTimestamp())))).limit(200L)).list((Expression)qTicket.id);
    }

    @Override
    protected void process(Ticket ticket) throws Throwable {
        this.ticketService.expire(ticket);
    }
}

