/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.Payment;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.QTicket;
import org.cyclos.entities.banking.Ticket;
import org.cyclos.entities.banking.TicketAmountReservation;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.CredentialAccessor;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.LocateAccountOwnerResult;
import org.cyclos.impl.banking.PaymentServiceLocal;
import org.cyclos.impl.banking.PaymentTransferTypeQuery;
import org.cyclos.impl.banking.PrepareValidationParameter;
import org.cyclos.impl.banking.TicketServiceLocal;
import org.cyclos.impl.banking.TicketWebhookSender;
import org.cyclos.impl.banking.TransactionServiceLocal;
import org.cyclos.impl.banking.TransactionValidationData;
import org.cyclos.impl.banking.TransferFeeServiceLocal;
import org.cyclos.impl.banking.TransferTypeServiceLocal;
import org.cyclos.impl.locks.LockHandler;
import org.cyclos.impl.locks.LockType;
import org.cyclos.impl.system.ExtensionPointAccessor;
import org.cyclos.impl.system.ExtensionPointFilter;
import org.cyclos.impl.system.ExtensionPointServiceLocal;
import org.cyclos.impl.users.LocateUserResult;
import org.cyclos.impl.utils.BarcodeHandler;
import org.cyclos.impl.utils.LinkGeneratorHandler;
import org.cyclos.impl.utils.PushNotificationEventContext;
import org.cyclos.impl.utils.PushNotificationHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.AccountWithCurrencyVO;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.transactions.AbstractPaymentTypeData;
import org.cyclos.model.banking.transactions.ApproveTicketConfirmationField;
import org.cyclos.model.banking.transactions.ApproveTicketDTO;
import org.cyclos.model.banking.transactions.ApproveTicketPreviewVO;
import org.cyclos.model.banking.transactions.CreateTicketDTO;
import org.cyclos.model.banking.transactions.CreateTicketData;
import org.cyclos.model.banking.transactions.PaymentCreationType;
import org.cyclos.model.banking.transactions.PaymentPreviewVO;
import org.cyclos.model.banking.transactions.PerformPaymentDTO;
import org.cyclos.model.banking.transactions.PerformTransactionDTO;
import org.cyclos.model.banking.transactions.ProcessTicketDTO;
import org.cyclos.model.banking.transactions.TicketBarcodeParams;
import org.cyclos.model.banking.transactions.TicketData;
import org.cyclos.model.banking.transactions.TicketPaymentTypeData;
import org.cyclos.model.banking.transactions.TicketProcessResult;
import org.cyclos.model.banking.transactions.TicketStatus;
import org.cyclos.model.banking.transactions.TicketVO;
import org.cyclos.model.banking.transactions.TransactionStatus;
import org.cyclos.model.banking.transactions.TransferFeesPreviewVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.banking.transfertypes.TransferTypeWithCurrencyVO;
import org.cyclos.model.system.extensionpoints.ExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.TransactionExtensionPointEvent;
import org.cyclos.model.system.images.ImageSize;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.security.banking.TransactionServiceSecurity;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.server.utils.SecureRandomHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TicketServiceImpl
extends BaseServiceImpl
implements TicketServiceLocal {
    private static final TimeInterval TICKET_DEFAULT_EXPIRATION_INTERVAL = TimeInterval.ONE_DAY;
    private static final QTicket $ = QTicket.ticket;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private TransactionServiceLocal transactionService;
    @Autowired
    private LinkGeneratorHandler linkGeneratorHandler;
    @Autowired
    private BarcodeHandler barcodeHandler;
    @Autowired
    private PaymentServiceLocal paymentService;
    @Autowired
    private PasswordHandler passwordHandler;
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private PushNotificationHandler pushNotificationHandler;
    @Autowired
    private ExtensionPointServiceLocal extensionPointService;
    @Autowired
    private LockHandler lockHandler;
    @Autowired
    private TransferFeeServiceLocal transferFeeService;
    @Autowired
    private TransferTypeServiceLocal transferTypeService;
    @Autowired
    private TransactionServiceSecurity transactionServiceSecurity;

    public TicketVO approve(ApproveTicketDTO approveTicketDTO) throws FrameworkException, TransferException {
        Ticket ticket = this.validateApproveTicket(approveTicketDTO, TicketStatus.OPEN);
        User user = this.getLoggedUser();
        if (user == null || !user.isMember()) {
            throw new IllegalActionException();
        }
        UserAccount userAccount = (UserAccount)this.accountService.require((InternalAccountOwner)user, ticket.getType().getFrom());
        ticket.setFrom((Account)userAccount);
        LocateAccountOwnerResult locateAccountOwnerResult = new LocateAccountOwnerResult(new LocateUserResult((UserPrincipal)userAccount));
        InternalAccountOwner internalAccountOwner = ticket.getToOwner();
        PaymentTransferType paymentTransferType = (PaymentTransferType)ticket.getType();
        TicketAmountReservation ticketAmountReservation = this.accountService.reserveAmount(ticket);
        if (ticketAmountReservation == null) {
            this.transactionService.validatePaymentAmount(locateAccountOwnerResult, this.accountHandler.locate((AccountOwner)internalAccountOwner), paymentTransferType, ticket.getAmount(), new Date());
        }
        if (ticket.shouldBeApproved()) {
            PerformPaymentDTO performPaymentDTO = new PerformPaymentDTO();
            performPaymentDTO.setOwner(internalAccountOwner);
            performPaymentDTO.setSubject(ticket.getToOwner());
            performPaymentDTO.setAmount(ticket.getAmount());
            performPaymentDTO.setType(new TransferTypeVO(paymentTransferType.getId()));
            TransferFeesPreviewVO transferFeesPreviewVO = this.transferFeeService.preview((PerformTransactionDTO)performPaymentDTO, paymentTransferType, locateAccountOwnerResult.getInternalAccountOwner(), internalAccountOwner, ticket.getAmount());
            this.accountService.checkAvailableBalance((Account)userAccount, transferFeesPreviewVO.getTotalAmount().getAmount());
            if (StringHelper.isNotBlank((Object)ticket.getSuccessWebhookUrl())) {
                InvocationContext.ensure().addCommitListener(false, () -> {
                    TicketWebhookSender ticketWebhookSender = new TicketWebhookSender(ticket.getTicketNumber(), ticket.getSuccessWebhookUrl(), this.invokerHandler, this, this.notificationHandler);
                    this.invokerHandler.getExecutorService().submit(ticketWebhookSender);
                });
            }
            return this.setStatusAndSendEvent(ticket, TicketStatus.APPROVED);
        }
        return this.doProcessTicket(ticket, null).getTicket();
    }

    public SerializableInputStream barcode(TicketBarcodeParams ticketBarcodeParams) throws FrameworkException {
        Ticket ticket = (Ticket)this.conversionHandler.convert(Ticket.class, (Object)ticketBarcodeParams.getTicket());
        if (ticket.getStatus() != TicketStatus.OPEN) {
            throw new IllegalActionException("Cannot get the QR-code for a ticket which is not open");
        }
        return this.barcodeHandler.qrcode(this.getApproveUrl(ticket), (ImageSize)ObjectHelper.defaultValue((Object)ticketBarcodeParams.getSize(), (Object)ImageSize.SMALL));
    }

    public void cancel(TicketVO ticketVO) throws FrameworkException {
        Ticket ticket = (Ticket)this.conversionHandler.convert(Ticket.class, (Object)ticketVO);
        this.cancel(ticket);
    }

    public int cancelAll(UserAccount userAccount) {
        if (userAccount.isTransient()) {
            return 0;
        }
        CloseableIterator closeableIterator = ((DBQuery)this.from(new EntityPath[]{$}).where(new Predicate[]{$.to().eq((Object)userAccount), TicketServiceImpl.$.status.eq((Object)TicketStatus.OPEN.name())})).iterate((Expression)$);
        MutableInt mutableInt = new MutableInt();
        this.processBatch(closeableIterator, (T ticket) -> {
            if (ticket.getStatus() == TicketStatus.EXPIRED) {
                this.expire((Ticket)ticket);
            } else {
                this.cancel((Ticket)ticket);
                mutableInt.increment();
            }
        });
        return mutableInt.intValue();
    }

    public void checkExists(String string, boolean bl) {
        Ticket ticket = this.getByNumber(string);
        if (ticket == null || bl && ticket.getStatus() != TicketStatus.OPEN) {
            throw new EntityNotFoundException(Ticket.class, string);
        }
    }

    public TicketVO create(CreateTicketDTO createTicketDTO) throws FrameworkException {
        LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locateOrCurrent((AccountOwner)createTicketDTO.getOwner());
        LocateAccountOwnerResult locateAccountOwnerResult2 = this.transactionService.locateForPayment((InternalAccountOwner)createTicketDTO.getPayer());
        PaymentTransferType paymentTransferType = this.validateCreateTicket(createTicketDTO, locateAccountOwnerResult);
        this.transactionServiceSecurity.checkPaymentParameters(locateAccountOwnerResult2 != null ? locateAccountOwnerResult2 : LocateAccountOwnerResult.empty(), locateAccountOwnerResult, PaymentCreationType.TICKET, paymentTransferType);
        Account account = locateAccountOwnerResult2.isEmpty() ? null : this.accountService.load(locateAccountOwnerResult2.getInternalAccountOwner(), paymentTransferType.getFrom());
        Account account2 = this.accountService.load(locateAccountOwnerResult.getInternalAccountOwner(), paymentTransferType.getTo());
        ExtensionPointAccessor extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)TransactionExtensionPointEvent.CREATE_TICKET, new ExtensionPointFilter((TransferType)paymentTransferType)).attribute("performTransaction", (Object)createTicketDTO).attribute("fromAccount", (Object)account).attribute("fromOwner", (Object)locateAccountOwnerResult.getAccountOwner()).attribute("fromOwnerResult", (Object)locateAccountOwnerResult).attribute("toAccount", (Object)account2).attribute("paymentType", (Object)paymentTransferType);
        extensionPointAccessor.fireValidated();
        BigDecimal bigDecimal = BigDecimalHelper.round((BigDecimal)createTicketDTO.getAmount(), (int)paymentTransferType.getCurrency().getPrecision());
        Ticket ticket = new Ticket();
        ticket.setStatus(TicketStatus.OPEN);
        String string = this.generateNewTicketNumber();
        ticket.setTicketNumber(string);
        ticket.setOrderId(createTicketDTO.getOrderId());
        String string2 = this.appendParameter("ticketNumber", string, createTicketDTO.getCancelUrl());
        string2 = this.appendParameter("orderId", createTicketDTO.getOrderId(), string2);
        String string3 = this.appendParameter("ticketNumber", string, createTicketDTO.getSuccessUrl());
        string3 = this.appendParameter("orderId", createTicketDTO.getOrderId(), string3);
        String string4 = this.appendParameter("ticketNumber", string, createTicketDTO.getSuccessWebhookUrl());
        string4 = this.appendParameter("orderId", createTicketDTO.getOrderId(), string4);
        ticket.setCancelUrl(string2);
        ticket.setSuccessUrl(string3);
        ticket.setSuccessWebhookUrl(string4);
        TimeInterval timeInterval = createTicketDTO.getExpiresAfter() == null ? TICKET_DEFAULT_EXPIRATION_INTERVAL : createTicketDTO.getExpiresAfter();
        ticket.setExpirationDate(DateHelper.add((Date)DateHelper.now(), (ITimeInterval)timeInterval));
        this.transactionService.fill((Transaction)ticket, (TransferType)paymentTransferType, PaymentCreationType.TICKET, account, account2, null, null, null, bigDecimal, createTicketDTO.getDescription(), (Collection)createTicketDTO.getCustomValues());
        this.transactionService.persist((Transaction)ticket);
        extensionPointAccessor.attribute("transaction", (Object)ticket).fireSaved();
        TicketVO ticketVO = (TicketVO)this.conversionHandler.convert(TicketVO.class, (Object)ticket);
        return ticketVO;
    }

    public void expire(Ticket ticket) {
        if (ticket.getPersistedStatus() == TicketStatus.EXPIRED) {
            return;
        }
        if (ticket.getPersistedStatus() != TicketStatus.OPEN && ticket.getPersistedStatus() != TicketStatus.APPROVED) {
            throw new IllegalActionException();
        }
        this.setStatusAndSendEvent(ticket, TicketStatus.EXPIRED);
    }

    public Ticket findByTicketNumber(String string) {
        Ticket ticket = this.getByNumber(string);
        if (ticket == null) {
            throw new EntityNotFoundException(Ticket.class, string);
        }
        if (this.getSessionData().isGuest() && ticket.getStatus() != TicketStatus.OPEN) {
            MessageKey messageKey;
            switch (ticket.getStatus()) {
                case CANCELED: {
                    messageKey = BankingKeys.Transactions.GUEST_TICKET_CANCELED;
                    break;
                }
                case EXPIRED: {
                    messageKey = BankingKeys.Transactions.GUEST_TICKET_EXPIRED;
                    break;
                }
                case PROCESSED: {
                    messageKey = BankingKeys.Transactions.GUEST_TICKET_PROCESSED;
                    break;
                }
                case APPROVED: {
                    messageKey = BankingKeys.Transactions.GUEST_TICKET_APPROVED;
                    break;
                }
                default: {
                    throw new EntityNotFoundException();
                }
            }
            if (messageKey != null) {
                throw new ValidationException(this.message(messageKey, new Object[0]));
            }
        }
        return ticket;
    }

    public String getApproveUrl(Ticket ticket) {
        return ticket.getStatus() == TicketStatus.OPEN ? this.linkGeneratorHandler.ticket(ticket) : null;
    }

    public CreateTicketData getCreateData(UserLocatorVO userLocatorVO, UserLocatorVO userLocatorVO2) throws FrameworkException {
        CreateTicketData createTicketData = new CreateTicketData();
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        LocateAccountOwnerResult locateAccountOwnerResult = this.transactionService.locateForPayment((InternalAccountOwner)userLocatorVO2);
        List<PaymentTransferType> list = this.listPossiblePaymentTypesForCreateTicket(user, locateAccountOwnerResult.getUser());
        createTicketData.setPaymentTypes(this.conversionHandler.convertList(TransferTypeWithCurrencyVO.class, list));
        TransferTypeVO transferTypeVO = (TransferTypeVO)CollectionHelper.first((Iterable)this.conversionHandler.convertList(TransferTypeWithCurrencyVO.class, list));
        if (transferTypeVO != null) {
            createTicketData.setPaymentTypeData(this.getTicketPaymentTypeData(userLocatorVO, transferTypeVO));
        }
        Set set = list.stream().map(TransferType::getTo).collect(Collectors.toSet());
        createTicketData.setAccounts(set.stream().sorted().map(accountType -> this.accountService.load((InternalAccountOwner)user, accountType)).map(this.conversionHandler.convertingFunction(AccountWithCurrencyVO.class, new Object[0])).collect(Collectors.toList()));
        return createTicketData;
    }

    public TicketData getData(Ticket ticket) throws FrameworkException {
        List list;
        SessionData sessionData = this.getSessionData();
        TicketData ticketData = (TicketData)this.transactionService.newData((Transaction)ticket, true);
        boolean bl = ticket.getStatus() == TicketStatus.OPEN;
        ticketData.setCanCancel(bl);
        InternalAccountOwner internalAccountOwner = ticket.getToOwner();
        if (bl && sessionData.isMember() && !sessionData.getLoggedUser().equals((Object)internalAccountOwner) && (list = sessionData.getProducts().member().getMyApproveTicketPaymentTypes()).contains(ticket.getType())) {
            ticketData.setPaymentPreview(this.preview(ticket));
        }
        return ticketData;
    }

    public TicketData getData(TicketVO ticketVO) throws FrameworkException {
        Ticket ticket = (Ticket)this.conversionHandler.convert(Ticket.class, (Object)ticketVO);
        SessionData sessionData = this.getSessionData();
        if (sessionData.isGuest()) {
            return (TicketData)this.invokerHandler.runAs(SessionDataFactory.user((BasicUser)ticket.getToUser()), () -> this.getData(ticket));
        }
        return this.getData(ticket);
    }

    public TicketPaymentTypeData getTicketPaymentTypeData(UserLocatorVO userLocatorVO, TransferTypeVO transferTypeVO) throws FrameworkException {
        TicketPaymentTypeData ticketPaymentTypeData = new TicketPaymentTypeData();
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)transferTypeVO);
        this.transactionService.fill((AbstractPaymentTypeData)ticketPaymentTypeData, LocateAccountOwnerResult.empty(), this.accountHandler.locateOrCurrent((AccountOwner)userLocatorVO), paymentTransferType);
        return ticketPaymentTypeData;
    }

    public List<PaymentTransferType> listPossiblePaymentTypesForCreateTicket(User user, User user2) {
        SessionData sessionData = this.getSessionData();
        User user3 = (User)ObjectHelper.defaultValue((Object)user, (Object)sessionData.getLoggedUser());
        if (user3 == null) {
            return Collections.emptyList();
        }
        PaymentTransferTypeQuery paymentTransferTypeQuery = new PaymentTransferTypeQuery();
        paymentTransferTypeQuery.setUnlimited();
        paymentTransferTypeQuery.setFromOwner((InternalAccountOwner)user2);
        paymentTransferTypeQuery.setToOwner((AccountOwner)user3);
        paymentTransferTypeQuery.setToAccounts((Collection)this.accountService.listVisible((InternalAccountOwner)user3));
        return this.transferTypeService.searchTicket(paymentTransferTypeQuery).getPageItems();
    }

    public ApproveTicketPreviewVO previewApprove(TicketVO ticketVO) throws FrameworkException {
        Ticket ticket = (Ticket)this.conversionHandler.convert(Ticket.class, (Object)ticketVO);
        PaymentPreviewVO paymentPreviewVO = this.paymentService.previewApproveTicket(ticket);
        ApproveTicketPreviewVO approveTicketPreviewVO = new ApproveTicketPreviewVO();
        approveTicketPreviewVO.setTicket((TicketVO)this.conversionHandler.convert(TicketVO.class, (Object)ticket));
        approveTicketPreviewVO.setPaymentPreview(paymentPreviewVO);
        return approveTicketPreviewVO;
    }

    public TicketProcessResult process(ProcessTicketDTO processTicketDTO) throws TransferException, FrameworkException {
        Ticket ticket = (Ticket)this.conversionHandler.convert(Ticket.class, (Object)processTicketDTO.getTicket());
        User user = ticket.getToUser();
        if (!user.equals((Object)this.getLoggedUser())) {
            throw new EntityNotFoundException(Ticket.class, ticket.getTicketNumber());
        }
        this.lockHandler.lock(LockType.TICKET.key(ticket.getTicketNumber() + "_process"));
        ticket = (Ticket)this.entityManagerHandler.refresh((IEntity)ticket);
        if (ticket.getStatus() != TicketStatus.APPROVED && ticket.getStatus() != TicketStatus.PROCESSED) {
            throw new IllegalActionException();
        }
        return this.doProcessTicket(ticket, processTicketDTO.getOrderId());
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }

    private String appendParameter(String string, String string2, String string3) {
        if (StringHelper.isBlank((Object)string3) || StringHelper.isBlank((Object)string2)) {
            return string3;
        }
        if (string3.contains("?")) {
            return StringUtils.appendIfMissing((String)string3, (CharSequence)"&", (CharSequence[])new CharSequence[0]) + string + "=" + string2;
        }
        return string3 + "?" + string + "=" + string2;
    }

    private boolean areAllNumbers(String string) {
        return !string.chars().filter(Character::isLetter).findAny().isPresent();
    }

    private void cancel(Ticket ticket) {
        if (ticket.getStatus() != TicketStatus.OPEN) {
            throw new IllegalActionException();
        }
        this.setStatusAndSendEvent(ticket, TicketStatus.CANCELED);
    }

    private TicketProcessResult doProcessTicket(Ticket ticket, String string) {
        TicketProcessResult ticketProcessResult = new TicketProcessResult();
        if (!Objects.equals(string, ticket.getOrderId())) {
            throw new ValidationException(this.message(BankingKeys.Transactions.INVALID_ORDER_ID_FOR_TICKET, new Object[0]));
        }
        if (ticket.getStatus() == TicketStatus.PROCESSED) {
            TicketVO ticketVO = (TicketVO)this.conversionHandler.convert(TicketVO.class, (Object)ticket);
            ticketProcessResult.setTicket(ticketVO);
            ticketProcessResult.setActuallyProcessed(false);
        } else {
            TicketStatus ticketStatus = ticket.getStatus();
            ExtensionPointAccessor extensionPointAccessor = this.transactionService.setStatusAndGetExtensionPoint((Transaction)ticket, (TransactionStatus)TicketStatus.PROCESSED);
            ticket.setStatus(ticketStatus);
            this.accountService.dereserveAmount(ticket);
            Payment payment = this.paymentService.processTicket(ticket);
            ticket.setStatus(TicketStatus.PROCESSED);
            ticket.setPayment(payment);
            extensionPointAccessor.fireSaved();
            Long l = ticket.getBy() != null && ticket.getBy().isOperator() ? ticket.getBy().getId() : ticket.getToUser().getId();
            TicketVO ticketVO = (TicketVO)this.conversionHandler.convert(TicketVO.class, (Object)ticket);
            this.publishNotification(ticketVO, l);
            User user = ticket.getFromUser();
            if (user != null) {
                this.publishNotification(ticketVO, user.getId());
            }
            ticketProcessResult.setTicket(ticketVO);
            ticketProcessResult.setActuallyProcessed(true);
        }
        return ticketProcessResult;
    }

    private String generateNewTicketNumber() {
        String string;
        while (this.areAllNumbers(string = SecureRandomHelper.randomAlphanumeric((int)32))) {
        }
        return string;
    }

    private Ticket getByNumber(String string) {
        if (StringHelper.isBlank((Object)string)) {
            throw new EntityNotFoundException(Ticket.class);
        }
        return (Ticket)((DBQuery)this.from(new EntityPath[]{$}).where((Predicate)TicketServiceImpl.$.ticketNumber.eq((Object)string))).singleResult((Expression)$);
    }

    private PaymentPreviewVO preview(Ticket ticket) {
        return (PaymentPreviewVO)this.invokerHandler.runAs(SessionDataFactory.inChannel((String)BuiltInChannel.TICKET.getInternalName()), () -> {
            PaymentPreviewVO paymentPreviewVO = this.paymentService.previewApproveTicket(ticket);
            paymentPreviewVO.setPayment(null);
            paymentPreviewVO.setConfirmationPasswordInput(null);
            return paymentPreviewVO;
        });
    }

    private void publishNotification(TicketVO ticketVO, Long l) {
        this.pushNotificationHandler.publish(PushNotificationEventContext.ticket((Long)l, (String)ticketVO.getTicketNumber()), (Object)ticketVO);
    }

    private TicketVO setStatusAndSendEvent(Ticket ticket, TicketStatus ticketStatus) {
        this.transactionService.setStatusAndGetExtensionPoint((Transaction)ticket, (TransactionStatus)ticketStatus).fireSaved();
        TicketVO ticketVO = (TicketVO)this.conversionHandler.convert(TicketVO.class, (Object)ticket);
        User user = ticket.getFromUser();
        this.publishNotification(ticketVO, SimpleEntity.id((SimpleEntity)user));
        if (ticketStatus.isFinal()) {
            this.accountService.dereserveAmount(ticket);
        }
        return ticketVO;
    }

    private Ticket validateApproveTicket(ApproveTicketDTO approveTicketDTO, TicketStatus ticketStatus) {
        PaymentTransferType paymentTransferType;
        Ticket ticket = (Ticket)this.conversionHandler.convert(Ticket.class, (Object)approveTicketDTO.getTicket());
        Validator validator = new Validator();
        validator.property((Property)ApproveTicketDTO.TICKET, BankingKeys.Transactions.TRANSACTION).required();
        CredentialAccessor credentialAccessor = this.passwordHandler.accessor(CredentialUsage.CONFIRMATION);
        boolean bl = credentialAccessor.isDefined();
        if (ticket != null) {
            if (bl) {
                paymentTransferType = (PaymentTransferType)ticket.getType();
                bl = this.transactionService.isCheckConfirmation(paymentTransferType, (InternalAccountOwner)this.getLoggedUser(), ticket.getAmount(), DateHelper.now());
            }
            if (bl) {
                credentialAccessor.addRequiredValidation(validator, (Property)ApproveTicketDTO.CONFIRMATION_PASSWORD);
            }
        }
        this.validate(validator, approveTicketDTO, "validateApproveTicket");
        if (bl) {
            credentialAccessor.check(approveTicketDTO.getConfirmationPassword(), ApproveTicketConfirmationField.confirmation((TicketVO)new TicketVO(ticket.getId())));
        }
        if (ticket.getStatus() != ticketStatus) {
            throw new IllegalActionException();
        }
        paymentTransferType = ticket.getFromUser();
        if (paymentTransferType != null && !paymentTransferType.equals((Object)this.getLoggedUser())) {
            throw new EntityNotFoundException(Ticket.class, ticket.getTicketNumber());
        }
        return ticket;
    }

    private PaymentTransferType validateCreateTicket(CreateTicketDTO createTicketDTO, LocateAccountOwnerResult locateAccountOwnerResult) {
        PrepareValidationParameter prepareValidationParameter = new PrepareValidationParameter.Builder((PerformTransactionDTO)createTicketDTO, LocateAccountOwnerResult.empty(), locateAccountOwnerResult, PaymentCreationType.TICKET).validateCustomFields(true).allowSearchingTTWhenNoneIsGiven(true).validateConfirmationPassword(false).excludeHideInForm(true).validateNFCChallenge(false).validateAmount(true).build();
        final TransactionValidationData transactionValidationData = this.transactionService.prepareValidation(prepareValidationParameter);
        Validator validator = transactionValidationData.getValidator();
        validator.property((Property)CreateTicketDTO.PAYER, BankingKeys.Accounts.TO).entity(User.class, (EntityValidation)new BaseEntityValidation<User>(){

            protected boolean isValid(Object object, Object object2, User user) {
                User user2 = TicketServiceImpl.this.getLoggedUser();
                if (user.equals((Object)user2)) {
                    return false;
                }
                try {
                    TicketServiceImpl.this.accountService.load((InternalAccountOwner)user, transactionValidationData.getPaymentType().getFrom());
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        });
        validator.property((Property)CreateTicketDTO.EXPIRES_AFTER, BankingKeys.Transactions.EXPIRES_AFTER).positiveIntegerNonZero().timeInterval();
        validator.property((Property)CreateTicketDTO.CANCEL_URL, BankingKeys.Transactions.CANCEL_URL).url().maxLength(255);
        validator.property((Property)CreateTicketDTO.SUCCESS_URL, BankingKeys.Transactions.SUCCESS_URL).url().maxLength(255);
        validator.property((Property)CreateTicketDTO.SUCCESS_WEBHOOK_URL, BankingKeys.Transactions.SUCCESS_WEBHOOK_URL).url().maxLength(255);
        this.validate(validator, createTicketDTO, "validateCreateTicket");
        return transactionValidationData.getPaymentType();
    }
}

