/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import java.io.IOException;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.entities.banking.Ticket;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.banking.TicketServiceLocal;
import org.cyclos.impl.utils.notifications.AccountNotificationsHandler;
import org.cyclos.impl.utils.notifications.NotificationHandler;
import org.cyclos.model.utils.TransactionLevel;

public class TicketWebhookSender
implements Runnable {
    private static Logger LOG = LogManager.getLogger(TicketWebhookSender.class);
    private static final int CONNECT_TIMEOUT = 1000;
    private static final int SOCKET_TIMEOUT = 10000;
    private static final int MAX_TRIES = 3;
    private final String ticketNumber;
    private final InvokerHandler invokerHandler;
    private final TicketServiceLocal ticketService;
    private final NotificationHandler notificationHandler;
    private final HttpUriRequest request;
    private final RequestConfig config;

    public TicketWebhookSender(String string, String string2, InvokerHandler invokerHandler, TicketServiceLocal ticketServiceLocal, NotificationHandler notificationHandler) {
        this.ticketNumber = string;
        this.invokerHandler = invokerHandler;
        this.ticketService = ticketServiceLocal;
        this.notificationHandler = notificationHandler;
        this.request = new HttpPost(string2);
        this.config = RequestConfig.custom().setConnectTimeout(1000).setConnectionRequestTimeout(1000).setSocketTimeout(10000).build();
    }

    @Override
    public void run() {
        try (CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().setDefaultRequestConfig(this.config).build();){
            int n;
            for (n = 0; n < 3; ++n) {
                try (CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute(this.request);){
                    StatusLine statusLine = closeableHttpResponse.getStatusLine();
                    if (statusLine.getStatusCode() >= 300) {
                        throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
                    }
                    break;
                }
                catch (IOException iOException) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            if (n == 3) {
                this.notifyOnError(this.ticketNumber, null);
            }
        }
        catch (IOException iOException) {
            this.notifyOnError(this.ticketNumber, iOException);
        }
    }

    private void notifyOnError(String string, Throwable throwable) {
        if (throwable != null) {
            LOG.error(String.format("Error trying to invoke webhook for ticket with number %s", string), throwable);
        }
        this.invokerHandler.runAsInCurrentOrNewTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            Ticket ticket = this.ticketService.findByTicketNumber(string);
            this.invokerHandler.runAs(SessionDataFactory.system((Network)ticket.getNetwork()), () -> {
                AccountNotificationsHandler accountNotificationsHandler = this.notificationHandler.user((BasicUser)ticket.getFromUser()).account();
                accountNotificationsHandler.ticketWebhookFailed(ticket, ticket.getTicketNumber(), ticket.getCurrencyAmount(), ticket.getToOwner());
                return null;
            });
            return null;
        });
    }
}

