/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import java.math.BigDecimal;
import java.util.Date;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.TimeBasedRateParameters;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.impl.banking.BaseRateTypeHandlerImpl;
import org.cyclos.impl.banking.TimeBasedRateTypeHandler;
import org.cyclos.model.banking.rates.TimeBasedRateParametersDTO;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.DateTime;

public abstract class TimeBasedRateTypeHandlerImpl<R extends TimeBasedRateParameters, D extends TimeBasedRateParametersDTO>
extends BaseRateTypeHandlerImpl<Date, R, D>
implements TimeBasedRateTypeHandler<R, D> {
    public DateTime convert(BigDecimal bigDecimal, DateTime dateTime) {
        Date date = this.convert(Date.class, (Object)dateTime);
        Date date2 = (Date)this.convert(bigDecimal, date);
        return this.convert(DateTime.class, (Object)date2);
    }

    public BigDecimal convert(Date date, Date date2) {
        if (date == null) {
            return null;
        }
        Date date3 = date2 == null ? DateHelper.now() : date2;
        return this.calculateRateChange(BigDecimal.ZERO, date, date3);
    }

    public BigDecimal convert(DateTime dateTime, DateTime dateTime2) {
        Date date = this.convert(Date.class, (Object)dateTime);
        Date date2 = this.convert(Date.class, (Object)dateTime2);
        return this.convert(date, date2);
    }

    public Date getInitValue(Currency currency, Date date) {
        TimeBasedRateParameters timeBasedRateParameters = (TimeBasedRateParameters)this.getRateParameters(currency, date);
        if (timeBasedRateParameters == null) {
            return null;
        }
        return timeBasedRateParameters.getInitValue();
    }

    @Override
    protected Date adjustIncomingRawRateInTransfer(Date date, Transfer transfer) {
        return date;
    }

    protected abstract BigDecimal calculateRateChange(BigDecimal var1, Date var2, Date var3);

    @Override
    protected boolean hasEqualProperties(R r, D d) {
        boolean bl = super.hasEqualProperties(r, d);
        if (!bl) {
            return false;
        }
        DateTime dateTime = (DateTime)this.conversionHandler.convert(DateTime.class, (Object)r.getInitValue());
        return dateTime.equals((Object)d.getInitValue());
    }
}

