/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.AuthorizationLevel;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.QBasePayment;
import org.cyclos.entities.banking.QTransactionAuthorization;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransactionAuthorization;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.OperatorGroupPaymentType;
import org.cyclos.entities.users.QAdminProductAuthorizationRole;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.DecimalRange;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.TransactionAuthorizationServiceLocal;
import org.cyclos.impl.search.TransactionSearchHandler;
import org.cyclos.impl.system.ExtensionPointAccessor;
import org.cyclos.impl.system.ExtensionPointFilter;
import org.cyclos.impl.system.ExtensionPointServiceLocal;
import org.cyclos.impl.users.ProductAccessor;
import org.cyclos.impl.utils.PushNotificationEventContext;
import org.cyclos.impl.utils.PushNotificationHandler;
import org.cyclos.impl.utils.notifications.AccountNotificationsHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.authorizations.AuthorizationAction;
import org.cyclos.model.banking.authorizations.TransactionAuthorizationDTO;
import org.cyclos.model.banking.transactions.ManageTransactionAuthorizationConfirmationField;
import org.cyclos.model.banking.transactions.PaymentAuthorizationLevelData;
import org.cyclos.model.banking.transactions.TransactionAuthorizationStatus;
import org.cyclos.model.banking.transactions.TransactionAuthorizationType;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.system.extensionpoints.AuthorizationExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.ExtensionPointEvent;
import org.cyclos.model.utils.PushNotificationEventType;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TransactionAuthorizationServiceImpl
extends BaseServiceImpl
implements TransactionAuthorizationServiceLocal {
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private PasswordHandler passwordHandler;
    @Autowired
    private ExtensionPointServiceLocal extensionPointService;
    private Map<Pair<AuthorizationAction, Class<Transaction>>, List<Consumer<Transaction>>> actionHandlers = new HashMap<Pair<AuthorizationAction, Class<Transaction>>, List<Consumer<Transaction>>>();
    @Autowired
    private PushNotificationHandler pushNotificationHandler;
    @Autowired
    private TransactionSearchHandler transactionSearchHandler;

    public PaymentAuthorizationLevelData authorize(TransactionAuthorizationDTO transactionAuthorizationDTO) {
        this.validate(transactionAuthorizationDTO, false);
        BasePayment basePayment = (BasePayment)this.conversionHandler.convert(BasePayment.class, (Object)transactionAuthorizationDTO.getTransaction());
        this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(transactionAuthorizationDTO.getConfirmationPassword(), ManageTransactionAuthorizationConfirmationField.confirmation((TransactionVO)transactionAuthorizationDTO.getTransaction(), (AuthorizationAction)AuthorizationAction.AUTHORIZED));
        if (!basePayment.isPendingAuthorization()) {
            throw new IllegalActionException();
        }
        User user = this.getLoggedUser();
        if (user != null && user.isAdmin() && CollectionHelper.isNotEmpty((Iterable)basePayment.getAuthorizations())) {
            for (TransactionAuthorization transactionAuthorization : basePayment.getAuthorizations()) {
                if (!user.equals((Object)transactionAuthorization.getBy())) continue;
                throw new IllegalActionException();
            }
        }
        this.doAuthorize(basePayment, transactionAuthorizationDTO.getComments(), true);
        return (PaymentAuthorizationLevelData)this.conversionHandler.convert(PaymentAuthorizationLevelData.class, (Object)basePayment.getNextAuthorizationLevel());
    }

    public void authorizeFirstLevelIfNeeded(BasePayment basePayment) throws FrameworkException {
        AuthorizationLevel authorizationLevel = basePayment.getNextAuthorizationLevel();
        if (authorizationLevel == null) {
            return;
        }
        SessionData sessionData = this.getSessionData();
        boolean bl = false;
        if (sessionData.isAdmin()) {
            bl = this.hasAuthorizationRoles(authorizationLevel, true);
        } else {
            User user = sessionData.getLoggedUser();
            if (user == null) {
                return;
            }
            boolean bl2 = user.equals((Object)basePayment.getFromUser()) && authorizationLevel.isPayer() && sessionData.hasPermission(Permission.MY_AUTHORIZED_PAYMENTS_AUTHORIZE);
            boolean bl3 = user.equals((Object)basePayment.getToUser()) && authorizationLevel.isReceiver() && sessionData.hasPermission(Permission.MY_AUTHORIZED_PAYMENTS_AUTHORIZE);
            boolean bl4 = sessionData.isBrokerOf((BasicUser)basePayment.getFromUser()) && authorizationLevel.isBroker() && sessionData.hasPermission(Permission.BROKER_AUTHORIZED_PAYMENTS_AUTHORIZE);
            boolean bl5 = bl = bl2 || bl3 || bl4;
        }
        if (bl) {
            this.doAuthorize(basePayment, null, false);
        }
    }

    public void cancel(BasePayment basePayment, String string) {
        this.doNegateAuthorization(TransactionAuthorizationStatus.AUTHORIZATION_CANCELED, basePayment, string);
    }

    public void cancel(TransactionAuthorizationDTO transactionAuthorizationDTO) {
        this.validate(transactionAuthorizationDTO, false);
        this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(transactionAuthorizationDTO.getConfirmationPassword(), ManageTransactionAuthorizationConfirmationField.confirmation((TransactionVO)transactionAuthorizationDTO.getTransaction(), (AuthorizationAction)AuthorizationAction.CANCELED));
        BasePayment basePayment = (BasePayment)this.conversionHandler.convert(BasePayment.class, (Object)transactionAuthorizationDTO.getTransaction());
        this.cancel(basePayment, transactionAuthorizationDTO.getComments());
    }

    public int cancelAll(UserAccount userAccount) throws FrameworkException {
        if (userAccount.isTransient()) {
            return 0;
        }
        QBasePayment qBasePayment = QBasePayment.basePayment;
        CloseableIterator closeableIterator = ((DBQuery)this.from(new EntityPath[]{qBasePayment}).where(new Predicate[]{qBasePayment.authorizationStatus.eq((Object)TransactionAuthorizationStatus.PENDING_AUTHORIZATION), qBasePayment.from().eq((Object)userAccount).or((Predicate)qBasePayment.to().eq((Object)userAccount))})).iterate((Expression)qBasePayment);
        return (int)this.processBatch(closeableIterator, (T basePayment) -> this.cancel((BasePayment)basePayment, null));
    }

    public void deny(TransactionAuthorizationDTO transactionAuthorizationDTO) {
        this.validate(transactionAuthorizationDTO, true);
        this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(transactionAuthorizationDTO.getConfirmationPassword(), ManageTransactionAuthorizationConfirmationField.confirmation((TransactionVO)transactionAuthorizationDTO.getTransaction(), (AuthorizationAction)AuthorizationAction.DENIED));
        BasePayment basePayment = (BasePayment)this.conversionHandler.convert(BasePayment.class, (Object)transactionAuthorizationDTO.getTransaction());
        this.doNegateAuthorization(TransactionAuthorizationStatus.AUTHORIZATION_DENIED, basePayment, transactionAuthorizationDTO.getComments());
    }

    public void expire(BasePayment basePayment) {
        this.doNegateAuthorization(TransactionAuthorizationStatus.AUTHORIZATION_EXPIRED, basePayment, null);
    }

    public Pair<TransactionAuthorizationType, AuthorizationLevel> initialAuthorization(PaymentTransferType paymentTransferType, BigDecimal bigDecimal) {
        List list;
        OperatorGroupPaymentType operatorGroupPaymentType;
        SessionData sessionData = this.getSessionData();
        if (sessionData.isRestrictedOperator() && (operatorGroupPaymentType = (list = sessionData.getLoggedOperator().getGroup()).getPaymentType(paymentTransferType)) != null && operatorGroupPaymentType.isRequiresAuthorization()) {
            return Pair.create((Object)TransactionAuthorizationType.OPERATOR, null);
        }
        list = paymentTransferType.getAuthorizationLevels();
        if (!paymentTransferType.isRequiresAuthorization() || CollectionHelper.isEmpty((Iterable)list)) {
            return null;
        }
        operatorGroupPaymentType = list.stream().filter(authorizationLevel -> this.applyLevel((AuthorizationLevel)authorizationLevel, bigDecimal)).findFirst().orElse(null);
        return operatorGroupPaymentType == null ? null : Pair.create((Object)TransactionAuthorizationType.LEVEL, (Object)operatorGroupPaymentType);
    }

    public void notifyPendingAuthorization(BasePayment basePayment) {
        TransactionAuthorizationType transactionAuthorizationType = basePayment.getAuthorizationType();
        if (transactionAuthorizationType == null) {
            return;
        }
        switch (transactionAuthorizationType) {
            case OPERATOR: {
                Operator operator = this.getByOperator(basePayment);
                this.notificationHandler.user((BasicUser)operator).account().operatorPaymentAwaitingAuthorization((Transaction)basePayment, basePayment.getCurrencyAmount(), operator, basePayment.getTransactionNumber());
                break;
            }
            case LEVEL: {
                AuthorizationLevel authorizationLevel = basePayment.getNextAuthorizationLevel();
                User user = basePayment.getFromUser();
                User user2 = basePayment.getToUser();
                if (authorizationLevel.isReceiver() && user2 != null && this.productsHandler.getAccessor((BasicUser)user2).product().hasPermission(Permission.MY_AUTHORIZED_PAYMENTS_AUTHORIZE)) {
                    this.notificationHandler.user((BasicUser)user2).account().paymentAwaitingAuthorization((Transaction)basePayment, basePayment.getCurrencyAmount(), (AccountOwner)basePayment.getFromOwner(), basePayment.getTransactionNumber());
                }
                if (authorizationLevel.isBroker() && user != null) {
                    for (User user3 : user.getBrokers()) {
                        ProductAccessor productAccessor = this.productsHandler.getAccessor((BasicUser)user3).product();
                        if (!productAccessor.hasPermission(Permission.BROKER_AUTHORIZED_PAYMENTS_AUTHORIZE)) continue;
                        this.notificationHandler.user((BasicUser)user3).account().paymentAwaitingAuthorization((Transaction)basePayment, basePayment.getCurrencyAmount(), (AccountOwner)basePayment.getFromOwner(), basePayment.getTransactionNumber());
                    }
                }
                if (authorizationLevel.isPayer() && user != null && this.productsHandler.getAccessor((BasicUser)user).product().hasPermission(Permission.MY_AUTHORIZED_PAYMENTS_AUTHORIZE)) {
                    this.notificationHandler.user((BasicUser)user).account().paymentAwaitingAuthorization((Transaction)basePayment, basePayment.getCurrencyAmount(), (AccountOwner)basePayment.getFromOwner(), basePayment.getTransactionNumber());
                }
                this.notificationHandler.admin().paymentAwaitingAuthorization((Transaction)basePayment);
                break;
            }
        }
    }

    public <T extends BasePayment> void registerHandler(AuthorizationAction authorizationAction, Class<T> clazz, Consumer<T> consumer) {
        Pair pair2 = Pair.create((Object)authorizationAction, clazz);
        List list = this.actionHandlers.computeIfAbsent((Pair<AuthorizationAction, Class<Transaction>>)pair2, pair -> new ArrayList());
        list.add(consumer);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(QTransactionAuthorization.transactionAuthorization.transaction().type().from().currency().network());
    }

    private boolean applyLevel(AuthorizationLevel authorizationLevel, BigDecimal bigDecimal) {
        DecimalRange decimalRange = authorizationLevel.getAmountRange();
        return decimalRange == null || (decimalRange.getMax() == null || decimalRange.getMax().compareTo(bigDecimal) >= 0) && (decimalRange.getMin() == null || decimalRange.getMin().compareTo(bigDecimal) <= 0);
    }

    private TransactionAuthorization createAuthorization(BasePayment basePayment, AuthorizationAction authorizationAction, TransactionAuthorizationType transactionAuthorizationType, AuthorizationLevel authorizationLevel, String string) {
        TransactionAuthorization transactionAuthorization = new TransactionAuthorization();
        transactionAuthorization.setTransaction(basePayment);
        transactionAuthorization.setType(transactionAuthorizationType);
        transactionAuthorization.setLevel(authorizationLevel);
        transactionAuthorization.setBy(this.getLoggedBasicUser());
        transactionAuthorization.setDate(DateHelper.now());
        transactionAuthorization.setAction(authorizationAction);
        transactionAuthorization.setComments(string);
        this.persist((IEntity)transactionAuthorization);
        basePayment.getAuthorizations().add(transactionAuthorization);
        return transactionAuthorization;
    }

    private void doAuthorize(BasePayment basePayment, String string, boolean bl) {
        TransactionAuthorizationType transactionAuthorizationType = basePayment.getAuthorizationType();
        AuthorizationLevel authorizationLevel = basePayment.getNextAuthorizationLevel();
        AuthorizationLevel authorizationLevel2 = this.getSecondNextAuthorizationLevel(basePayment);
        boolean bl2 = authorizationLevel2 == null;
        ExtensionPointAccessor extensionPointAccessor = this.newExtensionPointAccessor(AuthorizationExtensionPointEvent.AUTHORIZE, basePayment, string).attribute("nextLevel", (Object)authorizationLevel2);
        extensionPointAccessor.fireValidated();
        this.createAuthorization(basePayment, AuthorizationAction.AUTHORIZED, transactionAuthorizationType, authorizationLevel, string);
        basePayment.setNextAuthorizationLevel(authorizationLevel2);
        this.transactionSearchHandler.index((NetworkedEntity)basePayment);
        if (bl2) {
            basePayment.setAuthorizationType(null);
            this.returnReservation(basePayment);
            basePayment.setAuthorizationStatus(TransactionAuthorizationStatus.AUTHORIZED);
            this.runHandlers(AuthorizationAction.AUTHORIZED, (Transaction)basePayment);
            BasicUser basicUser = basePayment.getPerformer();
            if (basicUser != null) {
                switch (transactionAuthorizationType) {
                    case OPERATOR: {
                        Operator operator = this.getByOperator(basePayment);
                        this.notificationHandler.user((BasicUser)operator).account().operatorAuthorizedPaymentSucceeded((Transaction)basePayment, operator, basePayment.getCurrencyAmount(), this.getLoggedBasicUser(), basePayment.getTransactionNumber());
                        break;
                    }
                    case LEVEL: {
                        this.notificationHandler.user(basicUser).account().authorizedPaymentSucceeded((Transaction)basePayment, basePayment.getCurrencyAmount(), (AccountOwner)basePayment.getToOwner(), basePayment.getTransactionNumber());
                        break;
                    }
                }
            }
            this.sendPaymentAuthorizationPushNotification(basePayment);
        } else {
            if (basePayment.getAuthorizationType() != TransactionAuthorizationType.LEVEL) {
                basePayment.setAuthorizationType(TransactionAuthorizationType.LEVEL);
            }
            if (bl) {
                this.notifyPendingAuthorization(basePayment);
            }
            if (transactionAuthorizationType == TransactionAuthorizationType.OPERATOR) {
                Operator operator = this.getByOperator(basePayment);
                this.notificationHandler.user((BasicUser)operator).account().operatorAuthorizedPaymentApprovedStillPending((Transaction)basePayment, operator, basePayment.getCurrencyAmount(), this.getLoggedBasicUser(), basePayment.getTransactionNumber());
            }
        }
        extensionPointAccessor.fireSaved();
    }

    private void doNegateAuthorization(TransactionAuthorizationStatus transactionAuthorizationStatus, BasePayment basePayment, String string) {
        if (!basePayment.isPendingAuthorization()) {
            throw new IllegalActionException();
        }
        AuthorizationExtensionPointEvent authorizationExtensionPointEvent = null;
        AuthorizationAction authorizationAction = null;
        switch (transactionAuthorizationStatus) {
            case AUTHORIZATION_CANCELED: {
                authorizationExtensionPointEvent = AuthorizationExtensionPointEvent.CANCEL;
                authorizationAction = AuthorizationAction.CANCELED;
                break;
            }
            case AUTHORIZATION_DENIED: {
                authorizationExtensionPointEvent = AuthorizationExtensionPointEvent.DENY;
                authorizationAction = AuthorizationAction.DENIED;
                break;
            }
            case AUTHORIZATION_EXPIRED: {
                authorizationExtensionPointEvent = AuthorizationExtensionPointEvent.EXPIRE;
                authorizationAction = AuthorizationAction.EXPIRED;
                break;
            }
            default: {
                throw new IllegalActionException();
            }
        }
        ExtensionPointAccessor extensionPointAccessor = this.newExtensionPointAccessor(authorizationExtensionPointEvent, basePayment, string);
        extensionPointAccessor.fireValidated();
        TransactionAuthorizationType transactionAuthorizationType = basePayment.getAuthorizationType();
        AuthorizationLevel authorizationLevel = basePayment.getNextAuthorizationLevel();
        this.createAuthorization(basePayment, authorizationAction, transactionAuthorizationType, authorizationLevel, string);
        this.returnReservation(basePayment);
        basePayment.setAuthorizationStatus(transactionAuthorizationStatus);
        basePayment.setNextAuthorizationLevel(null);
        basePayment.setAuthorizationType(null);
        this.runHandlers(authorizationAction, (Transaction)basePayment);
        if (basePayment.isFromUser()) {
            block5 : switch (transactionAuthorizationType) {
                case OPERATOR: {
                    Operator operator = this.getByOperator(basePayment);
                    AccountNotificationsHandler accountNotificationsHandler = this.notificationHandler.user((BasicUser)operator).account();
                    switch (transactionAuthorizationStatus) {
                        case AUTHORIZATION_CANCELED: {
                            accountNotificationsHandler.operatorAuthorizedPaymentCanceled((Transaction)basePayment, operator, basePayment.getCurrencyAmount(), this.getLoggedBasicUser(), basePayment.getTransactionNumber());
                            break block5;
                        }
                        case AUTHORIZATION_DENIED: {
                            accountNotificationsHandler.operatorAuthorizedPaymentDenied((Transaction)basePayment, operator, basePayment.getCurrencyAmount(), this.getLoggedBasicUser(), basePayment.getTransactionNumber());
                            break block5;
                        }
                        case AUTHORIZATION_EXPIRED: {
                            accountNotificationsHandler.operatorAuthorizedPaymentExpired((Transaction)basePayment, operator, basePayment.getCurrencyAmount(), basePayment.getTransactionNumber());
                            break block5;
                        }
                    }
                    break;
                }
                case LEVEL: {
                    User user = this.getLoggedUser();
                    BasicUser basicUser = basePayment.getPerformer();
                    AccountNotificationsHandler accountNotificationsHandler = this.notificationHandler.user(basicUser).account();
                    switch (transactionAuthorizationStatus) {
                        case AUTHORIZATION_CANCELED: {
                            if (basicUser == null || basicUser.getUser().equals((Object)user)) break block5;
                            accountNotificationsHandler.authorizedPaymentCanceled((Transaction)basePayment, basePayment.getCurrencyAmount(), (AccountOwner)user, basePayment.getTransactionNumber());
                            break block5;
                        }
                        case AUTHORIZATION_DENIED: {
                            accountNotificationsHandler.authorizedPaymentDenied((Transaction)basePayment, basePayment.getCurrencyAmount(), (AccountOwner)this.getLoggedUser(), basePayment.getTransactionNumber());
                            break block5;
                        }
                        case AUTHORIZATION_EXPIRED: {
                            accountNotificationsHandler.authorizedPaymentExpired((Transaction)basePayment, basePayment.getCurrencyAmount(), basePayment.getTransactionNumber());
                            break block5;
                        }
                    }
                    break;
                }
            }
        }
        this.sendPaymentAuthorizationPushNotification(basePayment);
        this.transactionSearchHandler.index((NetworkedEntity)basePayment);
        extensionPointAccessor.fireSaved();
    }

    private Operator getByOperator(BasePayment basePayment) {
        Operator operator = (Operator)ObjectHelper.ifType((Object)basePayment.getBy(), Operator.class);
        if (operator == null) {
            throw new IllegalStateException(String.format("A payment has authorization type = %s, but not performed by operator, but by %s", TransactionAuthorizationType.OPERATOR, basePayment.getBy()));
        }
        return operator;
    }

    private AuthorizationLevel getSecondNextAuthorizationLevel(BasePayment basePayment) {
        PaymentTransferType paymentTransferType = (PaymentTransferType)basePayment.getType();
        List list = paymentTransferType.getAuthorizationLevels();
        if (!paymentTransferType.isRequiresAuthorization() || CollectionHelper.isEmpty((Iterable)list)) {
            return null;
        }
        int n = 0;
        if (basePayment.getAuthorizationType() == TransactionAuthorizationType.LEVEL) {
            n = list.indexOf(basePayment.getNextAuthorizationLevel());
            if (n < 0 || n == list.size() - 1) {
                return null;
            }
            ++n;
        }
        return list.subList(n, list.size()).stream().filter(authorizationLevel -> this.applyLevel((AuthorizationLevel)authorizationLevel, basePayment.getAmount())).findFirst().orElse(null);
    }

    private boolean hasAuthorizationRoles(AuthorizationLevel authorizationLevel, boolean bl) {
        if (this.isAdmin()) {
            QAdminProductAuthorizationRole qAdminProductAuthorizationRole = QAdminProductAuthorizationRole.adminProductAuthorizationRole;
            Set set = this.getProducts().admin().getAuthorizationRoles().keysSet((Path)(bl ? qAdminProductAuthorizationRole.manage : qAdminProductAuthorizationRole.view));
            return CollectionHelper.containsAny((Collection)authorizationLevel.getRoles(), (Collection)set);
        }
        return false;
    }

    private ExtensionPointAccessor newExtensionPointAccessor(AuthorizationExtensionPointEvent authorizationExtensionPointEvent, BasePayment basePayment, String string) {
        return this.extensionPointService.newAccessor((ExtensionPointEvent)authorizationExtensionPointEvent, new ExtensionPointFilter(basePayment.getType())).attribute("transaction", (Object)basePayment).attribute("currentLevel", (Object)basePayment.getNextAuthorizationLevel()).attribute("comment", (Object)string);
    }

    private void returnReservation(BasePayment basePayment) {
        if (this.accountService.getAmountReservationForAuthorization(basePayment) != null) {
            this.accountService.dereserveAmountForAuthorization(basePayment);
        }
    }

    private void runHandlers(AuthorizationAction authorizationAction, Transaction transaction) {
        List<Consumer<Transaction>> list = null;
        for (Class<?> clazz = transaction.getClass(); list == null && clazz != null; clazz = clazz.getSuperclass()) {
            list = this.actionHandlers.get(Pair.create((Object)authorizationAction, clazz));
        }
        if (list != null) {
            list.forEach(consumer -> consumer.accept(transaction));
        }
    }

    private void sendPaymentAuthorizationPushNotification(BasePayment basePayment) {
        User user;
        Object object = user = basePayment.isReceived() ? basePayment.getToUser() : basePayment.getBy();
        if (user != null) {
            this.pushNotificationHandler.publish(PushNotificationEventContext.user((PushNotificationEventType)PushNotificationEventType.PAYMENT_AUTHORIZATION, (Long)user.getId()), SimpleEntity.id((SimpleEntity)basePayment.getNetwork()), () -> {
                BasePayment basePayment2 = this.find(BasePayment.class, basePayment.getId());
                return (TransactionVO)this.conversionHandler.convert(TransactionVO.class, (Object)basePayment2);
            });
        }
    }

    private void validate(TransactionAuthorizationDTO transactionAuthorizationDTO, boolean bl) {
        Validator validator = new Validator();
        org.cyclos.impl.utils.validation.Property property = validator.property((Property)TransactionAuthorizationDTO.COMMENTS, BankingKeys.Authorizations.COMMENTS).maxLength(10000);
        if (bl) {
            property.required();
        }
        this.validate(validator, transactionAuthorizationDTO, "transactionAuthorizationDTO");
    }
}

