/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.QTransactionCustomField;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.TransactionCustomFieldPossibleValue;
import org.cyclos.entities.banking.TransactionCustomFieldPossibleValueCategory;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.AdminProduct;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.QProduct;
import org.cyclos.entities.users.User;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.TransactionCustomFieldPossibleValueCategoryServiceLocal;
import org.cyclos.impl.banking.TransactionCustomFieldPossibleValueServiceLocal;
import org.cyclos.impl.banking.TransactionCustomFieldServiceLocal;
import org.cyclos.impl.system.BaseCustomFieldPossibleValueCategoryServiceLocal;
import org.cyclos.impl.system.BaseCustomFieldServiceImpl;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.utils.SerializablePredicate;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.banking.TransSearchContext;
import org.cyclos.model.banking.accounts.AccountHistoriesOverviewQuery;
import org.cyclos.model.banking.accounts.AccountHistoryQuery;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.transactionfields.TransactionCustomFieldDTO;
import org.cyclos.model.banking.transactionfields.TransactionCustomFieldData;
import org.cyclos.model.banking.transactionfields.TransactionCustomFieldDetailedVO;
import org.cyclos.model.banking.transactions.AbstractTransQuery;
import org.cyclos.model.banking.transactions.CreateTicketDTO;
import org.cyclos.model.banking.transactions.ImportTransferDTO;
import org.cyclos.model.banking.transactions.InstallmentOverviewQuery;
import org.cyclos.model.banking.transactions.InstallmentQuery;
import org.cyclos.model.banking.transactions.PerformExternalPaymentDTO;
import org.cyclos.model.banking.transactions.PerformPaymentDTO;
import org.cyclos.model.banking.transactions.PerformRecurringPaymentDTO;
import org.cyclos.model.banking.transactions.PerformScheduledPaymentDTO;
import org.cyclos.model.banking.transactions.SendPaymentRequestDTO;
import org.cyclos.model.banking.transactions.TransactionOverviewQuery;
import org.cyclos.model.banking.transactions.TransactionQuery;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.users.users.IUser;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.server.utils.SortHelper;
import org.cyclos.server.utils.SortSpecifier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TransactionCustomFieldServiceImpl
extends BaseCustomFieldServiceImpl<TransactionCustomField, TransactionCustomFieldPossibleValueCategory, TransactionCustomFieldPossibleValue, QTransactionCustomField, TransactionCustomFieldDTO, TransactionCustomFieldData, Void>
implements TransactionCustomFieldServiceLocal {
    @Autowired
    private TransactionCustomFieldPossibleValueServiceLocal transactionCustomFieldPossibleValueService;
    @Autowired
    private TransactionCustomFieldPossibleValueCategoryServiceLocal transactionCustomFieldPossibleValueCategoryService;
    @Autowired
    private CacheHandler cacheHandler;

    public TransactionCustomFieldServiceImpl() {
        super(TransactionCustomField.class, QTransactionCustomField.transactionCustomField, TransactionCustomFieldDTO.class, TransactionCustomFieldData.class);
    }

    public void addRelation(TransferTypeVO transferTypeVO, CustomFieldVO customFieldVO) throws EntityNotFoundException {
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)transferTypeVO);
        TransactionCustomField transactionCustomField = (TransactionCustomField)this.conversionHandler.convert(TransactionCustomField.class, (Object)customFieldVO);
        paymentTransferType.getCustomFields().add(transactionCustomField);
    }

    public List<TransactionCustomFieldDetailedVO> list() {
        return this.conversionHandler.convertList(TransactionCustomFieldDetailedVO.class, this.listAll());
    }

    public List<TransactionCustomField> listAll() {
        QTransactionCustomField qTransactionCustomField = QTransactionCustomField.transactionCustomField;
        return ((DBQuery)this.from(new EntityPath[]{qTransactionCustomField}).orderBy(qTransactionCustomField.order.asc())).list((Expression)qTransactionCustomField);
    }

    public List<CustomFieldVO> listAllRelated(TransferTypeVO transferTypeVO) throws EntityNotFoundException {
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)transferTypeVO);
        ArrayList arrayList = new ArrayList(paymentTransferType.getCustomFields());
        Collections.sort(arrayList, (transactionCustomField, transactionCustomField2) -> transactionCustomField.getOrder().compareTo(transactionCustomField2.getOrder()));
        return this.conversionHandler.convertList(CustomFieldVO.class, arrayList);
    }

    public List<TransactionCustomField> listRelated(TransferType transferType) {
        if (transferType instanceof PaymentTransferType) {
            PaymentTransferType paymentTransferType = (PaymentTransferType)transferType;
            SessionData sessionData = this.getSessionData();
            List list = SortHelper.sortBy((Collection)paymentTransferType.getCustomFields(), (SortSpecifier[])new SortSpecifier[0]);
            if (!sessionData.isSystem()) {
                list.retainAll(sessionData.getProducts().product().getVisibleTransactionFields());
            }
            return list;
        }
        return Collections.emptyList();
    }

    public List<CustomFieldVO> listRelated(TransferTypeVO transferTypeVO) throws EntityNotFoundException {
        TransferType transferType = (TransferType)this.conversionHandler.convert(TransferType.class, (Object)transferTypeVO);
        List<TransactionCustomField> list = this.listRelated(transferType);
        return this.conversionHandler.convertList(CustomFieldVO.class, list);
    }

    public List<TransactionCustomField> listVisible(AccountOwner accountOwner) throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        ProductsAccessor productsAccessor = sessionData.getProducts();
        if (accountOwner == null) {
            if (sessionData.isAdmin()) {
                return productsAccessor.admin().getVisibleTransactionFields();
            }
            return productsAccessor.member().getVisibleTransactionFields();
        }
        if (accountOwner instanceof SystemAccountOwner) {
            return productsAccessor.admin().getVisibleTransactionFields();
        }
        if (accountOwner instanceof IUser) {
            User user = (User)this.conversionHandler.convert(User.class, (Object)accountOwner);
            if (sessionData.isBrokerOf((BasicUser)user)) {
                return productsAccessor.broker().getVisibleTransactionFields();
            }
            if (sessionData.isAdminOf((BasicUser)user)) {
                return productsAccessor.admin().getVisibleTransactionFields();
            }
            return productsAccessor.member().getVisibleTransactionFields();
        }
        return Collections.emptyList();
    }

    public List<TransactionCustomField> listVisibleForList(AbstractTransQuery abstractTransQuery) {
        if (abstractTransQuery instanceof AccountHistoryQuery) {
            List<TransactionCustomField> list = this.listVisible((AccountOwner)this.resolveOwnerParameter(abstractTransQuery));
            list.retainAll(((Account)this.conversionHandler.convert(Account.class, (Object)((AccountHistoryQuery)abstractTransQuery).getAccount())).getType().getCustomFieldsForList());
            return list;
        }
        return this.listVisibleForList((AccountOwner)this.resolveOwnerParameter(abstractTransQuery), this.resolveTransSearchContext(abstractTransQuery));
    }

    public List<TransactionCustomField> listVisibleForList(AccountOwner accountOwner, TransSearchContext transSearchContext) {
        return this.listVisible(accountOwner).stream().filter(transactionCustomField -> transactionCustomField.getContextsToShowInList().contains(transSearchContext)).collect(Collectors.toList());
    }

    public List<TransactionCustomField> listVisibleForSearch(AbstractTransQuery abstractTransQuery) {
        if (abstractTransQuery instanceof AccountHistoryQuery) {
            List<TransactionCustomField> list = this.listVisible((AccountOwner)this.resolveOwnerParameter(abstractTransQuery));
            list.removeIf(transactionCustomField -> !transactionCustomField.isAllowedAsSearchFilter());
            if (!this.getSessionData().isSystem()) {
                list.retainAll(((Account)this.conversionHandler.convert(Account.class, (Object)((AccountHistoryQuery)abstractTransQuery).getAccount())).getType().getCustomFieldsForSearch());
            }
            return list;
        }
        return this.listVisibleForSearch((AccountOwner)this.resolveOwnerParameter(abstractTransQuery), this.resolveTransSearchContext(abstractTransQuery));
    }

    public List<TransactionCustomField> listVisibleForSearch(AccountOwner accountOwner, TransSearchContext transSearchContext) {
        return this.listVisible(accountOwner).stream().filter(transactionCustomField -> transactionCustomField.isAllowedAsSearchFilter() && (this.getSessionData().isSystem() || transactionCustomField.getContextsToShowInSearch().contains(transSearchContext))).collect(Collectors.toList());
    }

    @Override
    public TransactionCustomField newEntity(Void void_) {
        return new TransactionCustomField();
    }

    public void removeRelation(TransferTypeVO transferTypeVO, CustomFieldVO customFieldVO) throws EntityNotFoundException {
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)transferTypeVO);
        TransactionCustomField transactionCustomField = (TransactionCustomField)this.conversionHandler.convert(TransactionCustomField.class, (Object)customFieldVO);
        paymentTransferType.getCustomFields().remove(transactionCustomField);
    }

    public TransSearchContext resolveTransSearchContext(AbstractTransQuery abstractTransQuery) {
        if (abstractTransQuery instanceof TransactionOverviewQuery) {
            return ((TransactionOverviewQuery)abstractTransQuery).isPendingMyAuthorization() ? TransSearchContext.PENDING_MY_AUTHORIZATION : TransSearchContext.TRANSACTIONS_OVERVIEW;
        }
        if (abstractTransQuery instanceof AccountHistoriesOverviewQuery) {
            return TransSearchContext.TRANSFERS_OVERVIEW;
        }
        if (abstractTransQuery instanceof InstallmentOverviewQuery) {
            return TransSearchContext.INSTALLMENTS_OVERVIEW;
        }
        if (abstractTransQuery instanceof InstallmentQuery) {
            InternalAccountOwner internalAccountOwner = this.accountHandler.locate((AccountOwner)this.resolveOwnerParameter(abstractTransQuery)).getInternalAccountOwner();
            return internalAccountOwner instanceof SystemAccountOwner ? TransSearchContext.SYSTEM_INSTALLMENTS : TransSearchContext.USER_INSTALLMENTS;
        }
        if (abstractTransQuery instanceof TransactionQuery) {
            InternalAccountOwner internalAccountOwner = this.accountHandler.locate((AccountOwner)this.resolveOwnerParameter(abstractTransQuery)).getInternalAccountOwner();
            return internalAccountOwner instanceof SystemAccountOwner ? TransSearchContext.SYSTEM_TRANSACTIONS : TransSearchContext.USER_TRANSACTIONS;
        }
        return null;
    }

    @Override
    protected Integer getMaxOrder(TransactionCustomField transactionCustomField) {
        QTransactionCustomField qTransactionCustomField = QTransactionCustomField.transactionCustomField;
        return (Integer)this.from(new EntityPath[]{qTransactionCustomField}).singleResult((Expression)qTransactionCustomField.order.max());
    }

    @Override
    protected BaseCustomFieldPossibleValueCategoryServiceLocal<TransactionCustomField, TransactionCustomFieldPossibleValueCategory, TransactionCustomFieldPossibleValue> getPossibleValueCategoryService() {
        return this.transactionCustomFieldPossibleValueCategoryService;
    }

    protected TransactionCustomFieldPossibleValueServiceLocal getPossibleValueService() {
        return this.transactionCustomFieldPossibleValueService;
    }

    @Override
    protected List<Class<?>> getPropertyClasses() {
        return Arrays.asList(CreateTicketDTO.class, PerformExternalPaymentDTO.class, ImportTransferDTO.class, PerformPaymentDTO.class, PerformRecurringPaymentDTO.class, PerformScheduledPaymentDTO.class, SendPaymentRequestDTO.class);
    }

    @Override
    protected boolean isBinaryTypesAllowed() {
        return true;
    }

    @Override
    protected void onAfterRemove(TransactionCustomField transactionCustomField) {
        Long l = SimpleEntity.id((SimpleEntity)transactionCustomField.getNetwork());
        String string = PropertyHelper.getGetterName((Path)QProduct.product.visibleTransactionFields);
        this.cacheHandler.schedulePartialEvict(CacheType.PRODUCTS_ACCESSOR, (SerializablePredicate & Serializable)productsAccessorCacheKey -> productsAccessorCacheKey.matchesNetworkAndMethod(l, string));
    }

    @Override
    protected void onAfterSave(TransactionCustomField transactionCustomField, TransactionCustomField transactionCustomField2, Object object) {
        Group group;
        if (transactionCustomField2 == null && (group = this.getSessionData().getGroup()) instanceof AdminGroup) {
            AdminProduct adminProduct = ((AdminGroup)group).getAdminProduct();
            adminProduct.getVisibleTransactionFields().add(transactionCustomField);
            Long l = SimpleEntity.id((SimpleEntity)adminProduct);
            this.cacheHandler.schedulePartialEvict(CacheType.PRODUCTS_ACCESSOR, (SerializablePredicate & Serializable)productsAccessorCacheKey -> productsAccessorCacheKey.matchesProduct(l));
        }
    }

    @Override
    protected Object onBeforeSave(TransactionCustomField transactionCustomField, TransactionCustomField transactionCustomField2) {
        if (!transactionCustomField.getType().isAllowedToBeOnResultList()) {
            transactionCustomField.setContextsToShowInList(null);
        }
        if (!transactionCustomField.getType().isAllowedToBeOnSearchFilters()) {
            transactionCustomField.setContextsToShowInSearch(null);
        }
        return super.onBeforeSave(transactionCustomField, transactionCustomField2);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QTransactionCustomField)this.$).network(), true);
    }

    private InternalAccountOwner resolveOwnerParameter(AbstractTransQuery abstractTransQuery) {
        if (abstractTransQuery instanceof InstallmentQuery) {
            return ((InstallmentQuery)abstractTransQuery).getOwner();
        }
        if (abstractTransQuery instanceof TransactionQuery) {
            return ((TransactionQuery)abstractTransQuery).getOwner();
        }
        if (abstractTransQuery instanceof AccountHistoryQuery) {
            return ((AccountHistoryQuery)abstractTransQuery).getAccount().getOwner();
        }
        return null;
    }
}

