/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.banking.QAuthorizationLevel;
import org.cyclos.entities.banking.QAuthorizationRole;
import org.cyclos.entities.banking.QTransaction;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.OperatorGroup;
import org.cyclos.entities.users.QAdminProductAuthorizationRole;
import org.cyclos.entities.users.QBrokering;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.BaseTransactionQueryHandlerImpl;
import org.cyclos.impl.banking.BuildTransactionQueryParams;
import org.cyclos.impl.banking.TransactionQueryHandler;
import org.cyclos.impl.users.ProductAccessor;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.transactions.BaseTransactionQuery;
import org.cyclos.model.banking.transactions.TransactionAuthorizationStatus;
import org.cyclos.model.banking.transactions.TransactionAuthorizationType;
import org.cyclos.model.banking.transactions.TransactionNature;
import org.cyclos.model.banking.transactions.TransactionOverviewQuery;
import org.cyclos.model.banking.transactions.TransactionQuery;
import org.cyclos.model.utils.DatePeriodDTO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.utils.CollectionHelper;
import org.springframework.stereotype.Component;

@Component
public class TransactionQueryHandlerImpl
extends BaseTransactionQueryHandlerImpl<BaseTransactionQuery, BuildTransactionQueryParams>
implements TransactionQueryHandler {
    public TransactionQueryHandlerImpl() {
        this.tx = QTransaction.transaction1;
        this.id = this.tx.id;
        this.transactionNumber = this.tx.transactionNumber;
        this.date = this.tx.date;
        this.amount = this.tx.amount;
    }

    @Override
    public DBQuery<?> build(BuildTransactionQueryParams buildTransactionQueryParams) {
        DatePeriod datePeriod;
        DBQuery<?> dBQuery = super.build(buildTransactionQueryParams);
        BaseTransactionQuery baseTransactionQuery = (BaseTransactionQuery)buildTransactionQueryParams.getParams();
        this.applyStatusesFilter(dBQuery, TransactionNature.EXTERNAL_PAYMENT, baseTransactionQuery.getExternalPaymentStatuses());
        this.applyStatusesFilter(dBQuery, TransactionNature.PAYMENT_REQUEST, baseTransactionQuery.getPaymentRequestStatuses());
        this.applyStatusesFilter(dBQuery, TransactionNature.RECURRING_PAYMENT, baseTransactionQuery.getRecurringPaymentStatuses());
        this.applyStatusesFilter(dBQuery, TransactionNature.SCHEDULED_PAYMENT, baseTransactionQuery.getScheduledPaymentStatuses());
        this.applyStatusesFilter(dBQuery, TransactionNature.TICKET, baseTransactionQuery.getTicketStatuses());
        if (!ModelHelper.isEmpty((DatePeriodDTO)baseTransactionQuery.getPaymentRequestExpiration())) {
            datePeriod = (DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)baseTransactionQuery.getPaymentRequestExpiration());
            dBQuery.where((Predicate)this.tx.nature.ne((Object)TransactionNature.PAYMENT_REQUEST).or(this.tx.expirationDate.period(datePeriod)));
        }
        if (!ModelHelper.isEmpty((DatePeriodDTO)baseTransactionQuery.getExternalPaymentExpiration())) {
            datePeriod = (DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)baseTransactionQuery.getExternalPaymentExpiration());
            dBQuery.where((Predicate)this.tx.nature.ne((Object)TransactionNature.EXTERNAL_PAYMENT).or(this.tx.expirationDate.period(datePeriod)));
        }
        if (!ModelHelper.isEmpty((DatePeriodDTO)baseTransactionQuery.getTicketExpiration())) {
            datePeriod = (DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)baseTransactionQuery.getTicketExpiration());
            dBQuery.where((Predicate)this.tx.nature.ne((Object)TransactionNature.TICKET).or(this.tx.expirationDate.period(datePeriod)));
        }
        return dBQuery;
    }

    @Override
    protected void applyOverview(DBQuery<?> dBQuery, BuildTransactionQueryParams buildTransactionQueryParams) {
        TransactionOverviewQuery transactionOverviewQuery;
        super.applyOverview(dBQuery, buildTransactionQueryParams);
        if (buildTransactionQueryParams.getParams() instanceof TransactionOverviewQuery && (transactionOverviewQuery = (TransactionOverviewQuery)buildTransactionQueryParams.getParams()).isPendingMyAuthorization()) {
            this.applyPendingMyAuthorization(dBQuery);
        }
    }

    @Override
    protected void doApplyVisibility(SessionData sessionData, DBQuery<?> dBQuery, BuildTransactionQueryParams buildTransactionQueryParams) {
        super.doApplyVisibility(sessionData, dBQuery, buildTransactionQueryParams);
        if (sessionData.isMember()) {
            User user = sessionData.getLoggedUser();
            BooleanExpression booleanExpression = this.tx.nature.ne((Object)TransactionNature.TICKET).or((Predicate)this.fu.isNull()).or((Predicate)this.fu.ne((Object)user));
            if (!(buildTransactionQueryParams.getParams() instanceof TransactionQuery) || !sessionData.getLoggedUser().equals((Object)((TransactionQuery)buildTransactionQueryParams.getParams()).getOwner())) {
                QBrokering qBrokering = QBrokering.brokering;
                booleanExpression = booleanExpression.or((Predicate)((DBQuery)this.subQuery(new EntityPath[]{qBrokering}).where((Predicate)qBrokering.broker().eq((Object)user).and((Predicate)qBrokering.user().eq((Expression)this.tu)))).exists());
            }
            dBQuery.where((Predicate)booleanExpression);
        }
    }

    @Override
    protected DBQuery<?> initQuery(BuildTransactionQueryParams buildTransactionQueryParams) {
        DBQuery dBQuery = (DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{this.tx}).leftJoin((EntityPath)this.tx.type(), (Path)this.tt)).leftJoin((EntityPath)this.tx.from(), (Path)this.fa)).leftJoin((EntityPath)this.fa.type(), (Path)this.fat)).leftJoin((EntityPath)this.fa.user(), (Path)this.fu)).leftJoin((EntityPath)this.fu.group(), (Path)this.fg)).leftJoin((EntityPath)this.tx.to(), (Path)this.ta)).leftJoin((EntityPath)this.ta.type(), (Path)this.tat)).leftJoin((EntityPath)this.ta.user(), (Path)this.tu)).leftJoin((EntityPath)this.tu.group(), (Path)this.tg)).leftJoin((EntityPath)this.c)).on((Predicate)this.c.id.eq((Expression)this.fat.currencyId.coalesce(new Expression[]{this.tat.currencyId})));
        return dBQuery;
    }

    private void applyPendingMyAuthorization(DBQuery<?> dBQuery) {
        SessionData sessionData = this.getSessionData();
        QTransaction qTransaction = this.getTransactionPath();
        dBQuery.where((Predicate)qTransaction.authorizationStatus.eq((Object)TransactionAuthorizationStatus.PENDING_AUTHORIZATION));
        if (sessionData.isSystem()) {
            return;
        }
        User user = sessionData.getLoggedUser();
        QAuthorizationLevel qAuthorizationLevel = QAuthorizationLevel.authorizationLevel;
        dBQuery.leftJoin((EntityPath)qTransaction.nextAuthorizationLevel(), (Path)qAuthorizationLevel);
        if (sessionData.isAdmin()) {
            Set set = sessionData.getProducts().admin().getAuthorizationRoles().keysSet((Path)QAdminProductAuthorizationRole.adminProductAuthorizationRole.manage);
            if (set.isEmpty()) {
                dBQuery.where((Predicate)qTransaction.id.isNull());
            } else {
                dBQuery.where((Predicate)((QAuthorizationRole)qAuthorizationLevel.roles.any()).in((Collection)set));
            }
        } else if (sessionData.isRestrictedOperator()) {
            Operator operator = sessionData.getLoggedOperator();
            OperatorGroup operatorGroup = operator.getGroup();
            List list = this.operatorGroupService.listPaymentTypesWithAuthorize(operatorGroup);
            if (CollectionHelper.isNotEmpty((Iterable)list)) {
                dBQuery.where((Predicate)qTransaction.authorizationType.eq((Object)TransactionAuthorizationType.OPERATOR));
                dBQuery.where((Predicate)qTransaction.by().ne((Object)operator));
                dBQuery.where((Predicate)this.fu.eq((Object)operatorGroup.getUser()));
                dBQuery.where((Predicate)qTransaction.type().in((Collection)list));
            } else {
                dBQuery.where((Predicate)qTransaction.id.isNull());
            }
        } else {
            BooleanBuilder booleanBuilder = new BooleanBuilder();
            ProductAccessor productAccessor = sessionData.getProducts().product();
            if (productAccessor.hasPermission(Permission.MY_AUTHORIZED_PAYMENTS_AUTHORIZE)) {
                booleanBuilder.or((Predicate)qAuthorizationLevel.payer.isTrue().and((Predicate)this.fu.eq((Object)user)));
                booleanBuilder.or((Predicate)qAuthorizationLevel.receiver.isTrue().and((Predicate)this.tu.eq((Object)user)));
            }
            if (productAccessor.hasPermission(Permission.MY_OPERATORS_ENABLE) && this.operatorGroupService.anyRequiresAuthorization(user)) {
                booleanBuilder.or((Predicate)this.fu.eq((Object)user).and((Predicate)qTransaction.authorizationType.eq((Object)TransactionAuthorizationType.OPERATOR)));
            }
            if (user.isBroker() && productAccessor.hasPermission(Permission.BROKER_AUTHORIZED_PAYMENTS_AUTHORIZE)) {
                QUser qUser = QUser.user;
                booleanBuilder.or((Predicate)qAuthorizationLevel.broker.isTrue().and((Predicate)((DBQuery)this.rawEntityManagerHandler.subQuery(new EntityPath[]{qUser}).where((Predicate)qUser.eq((Expression)this.fu).and((Predicate)qUser.brokers.contains((Object)user)))).exists()));
            }
            if (booleanBuilder.getValue() == null) {
                dBQuery.where((Predicate)qTransaction.id.isNull());
            } else {
                dBQuery.where((Predicate)booleanBuilder);
            }
        }
    }

    private void applyStatusesFilter(DBQuery<?> dBQuery, TransactionNature transactionNature, Set<? extends Enum<?>> set) {
        if (CollectionHelper.isNotEmpty(set)) {
            dBQuery.where((Predicate)this.tx.nature.ne((Object)transactionNature).or((Predicate)this.tx.status.in((Collection)set.stream().map(Enum::name).collect(Collectors.toSet()))));
        }
    }
}

