/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.Tuple;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.access.Channel;
import org.cyclos.entities.access.OidcAccessToken;
import org.cyclos.entities.access.OidcAuthorization;
import org.cyclos.entities.access.PrincipalType;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.AccountType;
import org.cyclos.entities.banking.AuthorizationLevel;
import org.cyclos.entities.banking.BasePayment;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.ExternalPayment;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.banking.IAccount;
import org.cyclos.entities.banking.ImportTransaction;
import org.cyclos.entities.banking.Installment;
import org.cyclos.entities.banking.Payment;
import org.cyclos.entities.banking.PaymentRequest;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.QBasePayment;
import org.cyclos.entities.banking.QChargebackTransfer;
import org.cyclos.entities.banking.QInstallment;
import org.cyclos.entities.banking.QInstallmentTransfer;
import org.cyclos.entities.banking.QPaymentTransferType;
import org.cyclos.entities.banking.QTransaction;
import org.cyclos.entities.banking.QTransactionAuthorization;
import org.cyclos.entities.banking.QTransactionCustomFieldValue;
import org.cyclos.entities.banking.RecurringPayment;
import org.cyclos.entities.banking.RecurringPaymentOccurrence;
import org.cyclos.entities.banking.ScheduledPayment;
import org.cyclos.entities.banking.ScheduledPaymentInstallment;
import org.cyclos.entities.banking.SystemAccountType;
import org.cyclos.entities.banking.Ticket;
import org.cyclos.entities.banking.Trans;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.TransactionAuthorization;
import org.cyclos.entities.banking.TransactionCustomField;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.banking.TransferType;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.EntityWithCustomValues;
import org.cyclos.entities.system.ExportFormat;
import org.cyclos.entities.system.PaymentPrincipalsConfiguration;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Operator;
import org.cyclos.entities.users.OperatorGroup;
import org.cyclos.entities.users.OperatorGroupPaymentType;
import org.cyclos.entities.users.QAdminProductAuthorizationRole;
import org.cyclos.entities.users.User;
import org.cyclos.entities.users.UserPrincipal;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.AgreementLogServiceLocal;
import org.cyclos.impl.access.ChannelServiceLocal;
import org.cyclos.impl.access.DeviceConfirmationServiceLocal;
import org.cyclos.impl.access.OidcAuthorizationServiceLocal;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.access.PasswordServiceLocal;
import org.cyclos.impl.access.PrincipalTypeServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.access.TokenServiceLocal;
import org.cyclos.impl.access.UrgentSituation;
import org.cyclos.impl.access.UserChannelServiceLocal;
import org.cyclos.impl.banking.AccountLockKey;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.DRateTypeHandler;
import org.cyclos.impl.banking.ExternalPaymentServiceLocal;
import org.cyclos.impl.banking.LocateAccountOwnerResult;
import org.cyclos.impl.banking.PaymentRequestServiceLocal;
import org.cyclos.impl.banking.PaymentServiceLocal;
import org.cyclos.impl.banking.PaymentTransferTypeQuery;
import org.cyclos.impl.banking.PrepareValidationParameter;
import org.cyclos.impl.banking.RateHandler;
import org.cyclos.impl.banking.RatesData;
import org.cyclos.impl.banking.RecurringPaymentServiceLocal;
import org.cyclos.impl.banking.ScheduledPaymentServiceLocal;
import org.cyclos.impl.banking.TicketServiceLocal;
import org.cyclos.impl.banking.TransactionAuthorizationServiceLocal;
import org.cyclos.impl.banking.TransactionCustomFieldServiceLocal;
import org.cyclos.impl.banking.TransactionNumberHandler;
import org.cyclos.impl.banking.TransactionServiceLocal;
import org.cyclos.impl.banking.TransactionValidationData;
import org.cyclos.impl.banking.TransferServiceLocal;
import org.cyclos.impl.banking.TransferTypeServiceLocal;
import org.cyclos.impl.locks.LockHandler;
import org.cyclos.impl.locks.LockType;
import org.cyclos.impl.search.InstallmentSearchHandler;
import org.cyclos.impl.search.TransactionSearchHandler;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.system.ExportFormatServiceLocal;
import org.cyclos.impl.system.ExtensionPointAccessor;
import org.cyclos.impl.system.ExtensionPointFilter;
import org.cyclos.impl.system.ExtensionPointServiceLocal;
import org.cyclos.impl.users.ContactServiceLocal;
import org.cyclos.impl.users.LocateUserResult;
import org.cyclos.impl.users.MemberProductAccessor;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.TransactionFeedbackServiceLocal;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.utils.PermissionHelper;
import org.cyclos.impl.utils.ToStringComparator;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Property;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.GeneralValidations;
import org.cyclos.model.Availability;
import org.cyclos.model.CyclosException;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IInternalNamedEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.access.channels.IdentificationMethod;
import org.cyclos.model.access.devices.DeviceConfirmationBarcodeParams;
import org.cyclos.model.access.devices.DeviceConfirmationVO;
import org.cyclos.model.access.principaltypes.PrincipalTypeInputVO;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.MaxAmountPerDayExceededException;
import org.cyclos.model.banking.MaxAmountPerMonthExceededException;
import org.cyclos.model.banking.MaxAmountPerWeekExceededException;
import org.cyclos.model.banking.MaxAmountPerYearExceededException;
import org.cyclos.model.banking.MaxPaymentAmountExceededException;
import org.cyclos.model.banking.MaxPaymentsPerDayExceededException;
import org.cyclos.model.banking.MaxPaymentsPerMonthExceededException;
import org.cyclos.model.banking.MaxPaymentsPerWeekExceededException;
import org.cyclos.model.banking.MinTimeBetweenPaymentsException;
import org.cyclos.model.banking.PosPayerInaccessiblePrincipalException;
import org.cyclos.model.banking.PosPayerNotInChannelException;
import org.cyclos.model.banking.PosPayerNotOperativeException;
import org.cyclos.model.banking.TransSearchContext;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.AccountWithCurrencyVO;
import org.cyclos.model.banking.accounts.ITransSearchData;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounts.SystemAccountOwner;
import org.cyclos.model.banking.accounttypes.AccountTypeLimitType;
import org.cyclos.model.banking.accounttypes.AccountTypeWithCurrencyVO;
import org.cyclos.model.banking.authorizationroles.AuthorizationRoleVO;
import org.cyclos.model.banking.authorizations.TransactionAuthorizationVO;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.rates.RateVisibility;
import org.cyclos.model.banking.transactions.AbstractPaymentTypeData;
import org.cyclos.model.banking.transactions.AbstractTransQuery;
import org.cyclos.model.banking.transactions.BaseInstallmentQuery;
import org.cyclos.model.banking.transactions.BasePaymentData;
import org.cyclos.model.banking.transactions.BasePaymentPreviewVO;
import org.cyclos.model.banking.transactions.BaseTransactionQuery;
import org.cyclos.model.banking.transactions.ExternalPaymentData;
import org.cyclos.model.banking.transactions.ExternalPaymentPreviewVO;
import org.cyclos.model.banking.transactions.ExternalPaymentStatus;
import org.cyclos.model.banking.transactions.HasTransactionStatus;
import org.cyclos.model.banking.transactions.IInstallmentSearchData;
import org.cyclos.model.banking.transactions.ITransactionSearchData;
import org.cyclos.model.banking.transactions.ImportedTransactionData;
import org.cyclos.model.banking.transactions.InstallmentActionDTO;
import org.cyclos.model.banking.transactions.InstallmentOverviewQuery;
import org.cyclos.model.banking.transactions.InstallmentOverviewSearchData;
import org.cyclos.model.banking.transactions.InstallmentQuery;
import org.cyclos.model.banking.transactions.InstallmentResultVO;
import org.cyclos.model.banking.transactions.InstallmentSearchData;
import org.cyclos.model.banking.transactions.InstallmentStatus;
import org.cyclos.model.banking.transactions.MaturityTableItemData;
import org.cyclos.model.banking.transactions.MaturityTableQuery;
import org.cyclos.model.banking.transactions.OwnedTransactionQuery;
import org.cyclos.model.banking.transactions.PaymentAuthorizationLevelData;
import org.cyclos.model.banking.transactions.PaymentCreationType;
import org.cyclos.model.banking.transactions.PaymentData;
import org.cyclos.model.banking.transactions.PaymentPreviewVO;
import org.cyclos.model.banking.transactions.PaymentRequestData;
import org.cyclos.model.banking.transactions.PerformExternalPaymentDTO;
import org.cyclos.model.banking.transactions.PerformInternalTransactionDTO;
import org.cyclos.model.banking.transactions.PerformPaymentConfirmationField;
import org.cyclos.model.banking.transactions.PerformPaymentDTO;
import org.cyclos.model.banking.transactions.PerformPaymentData;
import org.cyclos.model.banking.transactions.PerformPaymentToOwnerData;
import org.cyclos.model.banking.transactions.PerformPaymentTypeData;
import org.cyclos.model.banking.transactions.PerformRecurringPaymentDTO;
import org.cyclos.model.banking.transactions.PerformScheduledPaymentDTO;
import org.cyclos.model.banking.transactions.PerformTransactionDTO;
import org.cyclos.model.banking.transactions.ReceivePaymentData;
import org.cyclos.model.banking.transactions.ReceivePaymentFromUserData;
import org.cyclos.model.banking.transactions.RecurringPaymentData;
import org.cyclos.model.banking.transactions.RecurringPaymentPreviewVO;
import org.cyclos.model.banking.transactions.ScheduledPaymentData;
import org.cyclos.model.banking.transactions.ScheduledPaymentPreviewVO;
import org.cyclos.model.banking.transactions.TicketData;
import org.cyclos.model.banking.transactions.TransactionAuthorizationStatus;
import org.cyclos.model.banking.transactions.TransactionAuthorizationType;
import org.cyclos.model.banking.transactions.TransactionData;
import org.cyclos.model.banking.transactions.TransactionDetailedVO;
import org.cyclos.model.banking.transactions.TransactionOrderBy;
import org.cyclos.model.banking.transactions.TransactionOverviewQuery;
import org.cyclos.model.banking.transactions.TransactionOverviewSearchData;
import org.cyclos.model.banking.transactions.TransactionQuery;
import org.cyclos.model.banking.transactions.TransactionResultVO;
import org.cyclos.model.banking.transactions.TransactionSearchData;
import org.cyclos.model.banking.transactions.TransactionStatus;
import org.cyclos.model.banking.transactions.TransactionSubjects;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.banking.transfers.TransferVO;
import org.cyclos.model.banking.transfertypes.MaturityPolicy;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.banking.transfertypes.TransferTypeWithCurrencyVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.messaging.sms.SmsSendingException;
import org.cyclos.model.system.exportformats.ExportFormatContext;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.system.extensionpoints.ExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.TransactionExtensionPointEvent;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.system.fields.CustomFieldValueDTO;
import org.cyclos.model.system.scripts.LoadValuesScriptFunction;
import org.cyclos.model.users.operators.OperatorVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.LocateUserException;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.CurrencyAmountDTO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.PeriodPreselectorOptionData;
import org.cyclos.model.utils.SendMedium;
import org.cyclos.security.banking.TransactionServiceSecurity;
import org.cyclos.security.users.OperatorServiceSecurity;
import org.cyclos.security.users.UserServiceSecurity;
import org.cyclos.server.utils.CallableRunnable;
import org.cyclos.server.utils.DataIterator;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.server.utils.ExceptionHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.server.utils.SortHelper;
import org.cyclos.server.utils.SortSpecifier;
import org.cyclos.services.banking.TransactionService;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.CustomFieldHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.PageImpl;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TransactionServiceImpl
extends BaseServiceImpl
implements TransactionServiceLocal {
    @Autowired
    private TransactionSearchHandler transactionSearchHandler;
    @Autowired
    private InstallmentSearchHandler installmentSearchHandler;
    @Autowired
    private RecurringPaymentServiceLocal recurringPaymentService;
    @Autowired
    private ScheduledPaymentServiceLocal scheduledPaymentService;
    @Autowired
    private PaymentServiceLocal paymentService;
    @Autowired
    private PaymentRequestServiceLocal paymentRequestService;
    @Autowired
    private ExternalPaymentServiceLocal externalPaymentService;
    @Autowired
    private AgreementLogServiceLocal agreementLogService;
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private TokenServiceLocal tokenService;
    @Autowired
    private TransferTypeServiceLocal transferTypeService;
    @Autowired
    private TransactionNumberHandler transactionNumberHandler;
    @Autowired
    private RateHandler rateHandler;
    @Autowired
    private DRateTypeHandler dRateHandler;
    @Autowired
    private TransactionAuthorizationServiceLocal transactionAuthorizationService;
    @Autowired
    private PasswordHandler passwordHandler;
    @Autowired
    private LockHandler lockHandler;
    @Autowired
    private PasswordServiceLocal passwordService;
    @Autowired
    private CustomFieldValueHandler customFieldValueHandler;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private ChannelServiceLocal channelService;
    @Autowired
    private PrincipalTypeServiceLocal principalTypeService;
    @Autowired
    private UserChannelServiceLocal userChannelService;
    @Autowired
    private DeviceConfirmationServiceLocal deviceConfirmationService;
    @Autowired
    private TransferServiceLocal transferService;
    @Autowired
    private TransactionCustomFieldServiceLocal transactionCustomFieldService;
    @Autowired
    private UserServiceLocal userService;
    @Autowired
    private UserServiceSecurity userServiceSecurity;
    @Autowired
    private ContactServiceLocal contactService;
    @Autowired
    private TicketServiceLocal ticketService;
    @Autowired
    private OperatorServiceSecurity operatorServiceSecurity;
    @Autowired
    private ExtensionPointServiceLocal extensionPointService;
    @Autowired
    private ExportFormatServiceLocal exportFormatService;
    @Autowired
    private TransactionFeedbackServiceLocal transactionFeedbackService;
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private TransactionServiceSecurity transactionServiceSecurity;
    @Autowired
    private OidcAuthorizationServiceLocal oidcAuthorizationService;

    public OperatorVO convertToOperatorVO(Operator operator) {
        OperatorVO operatorVO = null;
        SessionData sessionData = this.getSessionData();
        if (operator != null && sessionData.relatesTo((BasicUser)operator)) {
            if (sessionData.isSystem() || sessionData.getLoggedBasicUser().equals((Object)operator) || this.operatorServiceSecurity.canViewOperators(operator.getUser())) {
                operatorVO = (OperatorVO)this.conversionHandler.convert(OperatorVO.class, (Object)operator);
            } else {
                operatorVO = new OperatorVO();
                operatorVO.setDisplay(this.getFormatter().format((BasicUser)operator));
                operatorVO.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)operator.getUser()));
            }
        }
        return operatorVO;
    }

    public Pair<Integer, PaymentTransferType> countPaymentTypes(PaymentCreationType paymentCreationType, PaymentTransferTypeQuery paymentTransferTypeQuery) {
        Page page = null;
        switch (paymentCreationType) {
            case EXTERNAL: {
                page = this.transferTypeService.searchExternalPayment(paymentTransferTypeQuery);
                break;
            }
            case DIRECT: 
            case POS: 
            case IMPORT: 
            case EASY_INVOICE: 
            case ORDER: {
                page = this.transferTypeService.searchPayment(paymentTransferTypeQuery);
                break;
            }
            case REQUEST: {
                page = this.transferTypeService.searchPaymentRequest(paymentTransferTypeQuery);
                break;
            }
            case VOUCHER_BUYING: 
            case VOUCHER_REDEEMING: 
            case VOUCHER_REFUNDING: 
            case VOUCHER_TOP_UP: {
                return Pair.create((Object)2, null);
            }
            case TICKET: {
                page = this.transferTypeService.searchTicket(paymentTransferTypeQuery);
            }
        }
        if (page == null) {
            throw new IllegalArgumentException("Can't search for payment types. Unknown payment operation" + String.valueOf(paymentCreationType));
        }
        return Pair.create((Object)page.getTotalCount(), CollectionHelper.size((Collection)page.getPageItems()) == 1 ? (PaymentTransferType)CollectionHelper.first((Iterable)page.getPageItems()) : null);
    }

    public DeviceConfirmationVO createDeviceConfirmationForReceive(@NotNull PerformInternalTransactionDTO performInternalTransactionDTO) throws FrameworkException {
        InternalAccountOwner internalAccountOwner = performInternalTransactionDTO.getOwner();
        LocateAccountOwnerResult locateAccountOwnerResult = this.locateForReceiving(internalAccountOwner);
        BasicUser basicUser = this.getLoggedBasicUser();
        return this.runAsUserToReceivePayment(locateAccountOwnerResult, () -> {
            performInternalTransactionDTO.setOwner(locateAccountOwnerResult.getInternalAccountOwner());
            return this.deviceConfirmationService.create(PerformPaymentConfirmationField.confirmation((PerformInternalTransactionDTO)performInternalTransactionDTO), basicUser, this.getLoggedBasicUser(), false);
        });
    }

    public SerializableInputStream deviceConfirmationBarcodeForReceive(InternalAccountOwner internalAccountOwner, DeviceConfirmationBarcodeParams deviceConfirmationBarcodeParams) throws FrameworkException {
        LocateAccountOwnerResult locateAccountOwnerResult = this.locateForReceiving(internalAccountOwner);
        return this.runAsUserToReceivePayment(locateAccountOwnerResult, () -> this.deviceConfirmationService.barcode(deviceConfirmationBarcodeParams));
    }

    public FileInfo exportInstallments(@NotNull ExportFormatVO exportFormatVO, @NotNull InstallmentQuery installmentQuery) {
        this.checkOwnedQuery((OwnedTransactionQuery)installmentQuery);
        ExportFormat exportFormat = (ExportFormat)this.conversionHandler.convert(ExportFormat.class, (Object)exportFormatVO);
        return this.exportFormatService.exportMultiple(exportFormat, ExportFormatContext.INSTALLMENTS_SEARCH, (QueryParameters)installmentQuery, this.doExport((BaseInstallmentQuery)installmentQuery));
    }

    public FileInfo exportInstallmentsOverview(@NotNull ExportFormatVO exportFormatVO, @NotNull InstallmentOverviewQuery installmentOverviewQuery) {
        ExportFormat exportFormat = (ExportFormat)this.conversionHandler.convert(ExportFormat.class, (Object)exportFormatVO);
        return this.exportFormatService.exportMultiple(exportFormat, ExportFormatContext.INSTALLMENTS_OVERVIEW, (QueryParameters)installmentOverviewQuery, this.doExport((BaseInstallmentQuery)installmentOverviewQuery));
    }

    public FileInfo exportOverview(@NotNull ExportFormatVO exportFormatVO, @NotNull TransactionOverviewQuery transactionOverviewQuery) {
        ExportFormat exportFormat = (ExportFormat)this.conversionHandler.convert(ExportFormat.class, (Object)exportFormatVO);
        return this.exportFormatService.exportMultiple(exportFormat, ExportFormatContext.TRANSACTIONS_OVERVIEW, (QueryParameters)transactionOverviewQuery, this.doExport((BaseTransactionQuery)transactionOverviewQuery));
    }

    public FileInfo exportTransaction(@NotNull ExportFormatVO exportFormatVO, @NotNull TransactionVO transactionVO) throws FrameworkException {
        ExportFormat exportFormat = (ExportFormat)this.conversionHandler.convert(ExportFormat.class, (Object)exportFormatVO);
        Transaction transaction = (Transaction)this.conversionHandler.convert(Transaction.class, (Object)transactionVO);
        return this.exportFormatService.exportSingle(exportFormat, ExportFormatContext.TRANS_DETAILS, (Object)transaction);
    }

    public FileInfo exportTransactions(@NotNull ExportFormatVO exportFormatVO, @NotNull TransactionQuery transactionQuery) {
        this.checkOwnedQuery((OwnedTransactionQuery)transactionQuery);
        ExportFormat exportFormat = (ExportFormat)this.conversionHandler.convert(ExportFormat.class, (Object)exportFormatVO);
        return this.exportFormatService.exportMultiple(exportFormat, ExportFormatContext.TRANSACTIONS_SEARCH, (QueryParameters)transactionQuery, this.doExport((BaseTransactionQuery)transactionQuery));
    }

    public PaymentTransferType fill(AbstractPaymentTypeData abstractPaymentTypeData, LocateAccountOwnerResult locateAccountOwnerResult, LocateAccountOwnerResult locateAccountOwnerResult2, PaymentTransferType paymentTransferType) {
        if (locateAccountOwnerResult == null || locateAccountOwnerResult2 == null || paymentTransferType == null) {
            return null;
        }
        this.conversionHandler.fillExcluding((Object)paymentTransferType, (Object)abstractPaymentTypeData, new Object[]{QPaymentTransferType.paymentTransferType.internalName, QPaymentTransferType.paymentTransferType.customFields});
        abstractPaymentTypeData.setInternalName(this.entityManagerHandler.getQualifiedInternalName((IInternalNamedEntity)paymentTransferType));
        List list = this.transactionCustomFieldService.listRelated((TransferType)paymentTransferType);
        if (CollectionHelper.isNotEmpty((Iterable)list)) {
            list.removeIf(TransactionCustomField::isHideInForm);
            List list2 = this.conversionHandler.convertList(CustomFieldDetailedVO.class, (Iterable)list);
            abstractPaymentTypeData.setCustomFields(list2);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("paymentType", paymentTransferType);
            hashMap.put("fromOwner", locateAccountOwnerResult.getAccountOwner());
            hashMap.put("fromOwnerResult", locateAccountOwnerResult);
            hashMap.put("toOwner", locateAccountOwnerResult2.getAccountOwner());
            hashMap.put("toOwnerResult", locateAccountOwnerResult2);
            this.customFieldValueHandler.fillValuesFromScript(TransactionCustomField.class, LoadValuesScriptFunction.ENTITY, hashMap, (Collection)list2);
        }
        abstractPaymentTypeData.setDescriptionAvailability(paymentTransferType.getDescriptionAvailability());
        return paymentTransferType;
    }

    public <D extends TransactionData> D fill(D d, Transaction transaction, boolean bl) {
        BasicUser basicUser = this.getLoggedBasicUser();
        TransactionDetailedVO transactionDetailedVO = (TransactionDetailedVO)this.conversionHandler.convert(TransactionDetailedVO.class, (Object)transaction);
        d.setTransaction(transactionDetailedVO);
        if (bl) {
            d.setConfirmationPasswordInput(this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).getCredentialInput());
            d.setExportFormats(this.conversionHandler.convertList(ExportFormatVO.class, (Iterable)this.exportFormatService.listByContext(ExportFormatContext.TRANS_DETAILS)));
        }
        boolean bl2 = this.contactService.canAddToContacts(basicUser, transaction.getFromBasicUser());
        boolean bl3 = this.contactService.canAddToContacts(basicUser, transaction.getToBasicUser());
        d.setUsersWhichCanAddToContacts(TransactionSubjects.of((boolean)bl2, (boolean)bl3));
        boolean bl4 = this.userServiceSecurity.canViewProfile(transaction.getFromUser());
        boolean bl5 = this.userServiceSecurity.canViewProfile(transaction.getToUser());
        d.setUsersWhichCanViewProfile(TransactionSubjects.of((boolean)bl4, (boolean)bl5));
        if (transaction instanceof BasePayment) {
            boolean bl6;
            List list;
            BasePayment basePayment = (BasePayment)transaction;
            BasePaymentData basePaymentData = (BasePaymentData)d;
            boolean bl7 = basePayment.isPendingAuthorization();
            basePaymentData.setCanAuthorize(bl7);
            basePaymentData.setCanDeny(bl7);
            basePaymentData.setCanCancelAuthorization(bl7);
            basePaymentData.setAuthorizationType(basePayment.getAuthorizationType());
            AuthorizationLevel authorizationLevel = basePayment.getNextAuthorizationLevel();
            if (authorizationLevel != null) {
                InternalAccountOwner internalAccountOwner;
                PaymentAuthorizationLevelData paymentAuthorizationLevelData = new PaymentAuthorizationLevelData();
                paymentAuthorizationLevelData.setAllowBroker(authorizationLevel.isBroker());
                paymentAuthorizationLevelData.setAllowPayer(authorizationLevel.isPayer());
                paymentAuthorizationLevelData.setAllowReceiver(authorizationLevel.isReceiver());
                paymentAuthorizationLevelData.setAllowAdmin(authorizationLevel.isAdmin());
                basePaymentData.setAuthorizationLevelData(paymentAuthorizationLevelData);
                if (authorizationLevel.isBroker() && (internalAccountOwner = basePayment.getFromOwner()) instanceof User) {
                    list = this.conversionHandler.convertList(UserVO.class, (Iterable)((User)internalAccountOwner).getBrokers());
                    basePaymentData.setAuthorizingBrokers(CollectionHelper.sort((Collection)list, ToStringComparator.instance()));
                }
            }
            boolean bl8 = basicUser != null && basicUser.getUser().equals((Object)transaction.getFromUser());
            boolean bl9 = bl6 = basicUser != null && basicUser.getUser().equals((Object)transaction.getToUser());
            if (basePayment.getAuthorizationStatus() != null) {
                list = SortHelper.sortBy((Collection)basePayment.getAuthorizations(), (SortSpecifier[])new SortSpecifier[]{SortSpecifier.desc((Path)QTransactionAuthorization.transactionAuthorization.date)});
                List<TransactionAuthorizationVO> list2 = null;
                if (bl8 || bl6) {
                    list2 = new ArrayList(list.size());
                    for (TransactionAuthorization transactionAuthorization : list) {
                        TransactionAuthorizationVO transactionAuthorizationVO = (TransactionAuthorizationVO)this.conversionHandler.convert(TransactionAuthorizationVO.class, (Object)transactionAuthorization);
                        if (transactionAuthorization.getLevel() != null && !transactionAuthorization.getLevel().isShowCommentsToUsers()) {
                            transactionAuthorizationVO.setComments(null);
                        }
                        list2.add(transactionAuthorizationVO);
                    }
                } else {
                    list2 = this.conversionHandler.convertList(TransactionAuthorizationVO.class, (Iterable)list);
                }
                basePaymentData.setAuthorizations(list2);
            }
            this.transactionFeedbackService.setFeedbackData(basePayment, basePaymentData);
        }
        return d;
    }

    public void fill(Transaction transaction, TransferType transferType, PaymentCreationType paymentCreationType, Account account, Account account2, BasicUser basicUser, String string, String string2, BigDecimal bigDecimal, String string3, Collection<CustomFieldValueDTO> collection) {
        OidcAuthorization oidcAuthorization;
        OidcAccessToken oidcAccessToken;
        Object object;
        BasePayment basePayment;
        PaymentTransferType paymentTransferType;
        if (account != null && account.equals((Object)account2)) {
            throw new IllegalActionException("From and to accounts can't be the same in a transaction!");
        }
        bigDecimal = BigDecimalHelper.round((BigDecimal)bigDecimal, (int)transferType.getCurrency().getPrecision());
        if (transferType instanceof PaymentTransferType && (paymentTransferType = (PaymentTransferType)transferType).isUseFixedAmount()) {
            bigDecimal = paymentTransferType.getFixedAmount();
        }
        transaction.setAmount(bigDecimal);
        transaction.setDate(DateHelper.now());
        transaction.setFrom(account);
        transaction.setTo(account2);
        transaction.setType(transferType);
        transaction.setFromName(string);
        transaction.setToName(string2);
        paymentTransferType = this.getSessionData();
        transaction.setChannel(paymentTransferType.getChannel());
        transaction.setPrincipalType(paymentTransferType.getPrincipalType());
        if (transaction.getAccessClient() == null) {
            transaction.setAccessClient(paymentTransferType.getAccessClient());
        }
        if (transaction instanceof BasePayment) {
            basePayment = (BasePayment)transaction;
            basePayment.setCreationType(paymentCreationType);
            if (transferType instanceof PaymentTransferType) {
                object = this.transactionAuthorizationService.initialAuthorization((PaymentTransferType)transferType, bigDecimal);
                if (object != null) {
                    basePayment.setAuthorizationStatus(TransactionAuthorizationStatus.PENDING_AUTHORIZATION);
                    basePayment.setAuthorizationType((TransactionAuthorizationType)object.getFirst());
                    basePayment.setNextAuthorizationLevel((AuthorizationLevel)object.getSecond());
                }
                if (basePayment.getReceivedBy() == null && basicUser instanceof Operator) {
                    basePayment.setReceivedBy((Operator)basicUser);
                }
                if ((oidcAccessToken = paymentTransferType.getAccessToken()) != null && this.oidcAuthorizationService.isSinglePayment(oidcAuthorization = oidcAccessToken.getAuthorization())) {
                    this.lockHandler.lock(LockType.OIDC_PAYMENT.key(oidcAuthorization.getId()));
                    basePayment.setOidcClient(oidcAuthorization.getClient());
                    if (oidcAuthorization.getPayment() != null) {
                        throw new IllegalActionException("The payment for this authorization was already performed: " + this.getFormatter().format((Trans)oidcAuthorization.getPayment()));
                    }
                    oidcAuthorization.setPayment(basePayment);
                }
            }
        }
        transaction.setDescription(string3);
        transaction.setBy(paymentTransferType.getLoggedBasicUser());
        transaction.setTransactionNumber(this.transactionNumberHandler.generate(transferType.getCurrency()));
        if (transferType instanceof PaymentTransferType) {
            basePayment = (PaymentTransferType)transferType;
            object = () -> this.lambda$fill$2((PaymentTransferType)basePayment, transaction, collection);
            if (paymentCreationType == PaymentCreationType.REQUEST) {
                this.invokerHandler.runAs(SessionDataFactory.system(), (Callable)new CallableRunnable((Runnable)object));
            } else if (paymentCreationType == PaymentCreationType.POS) {
                Object object2 = oidcAccessToken = basicUser == null && transaction.isToUser() ? transaction.getToUser() : basicUser;
                if (oidcAccessToken == null) {
                    object.run();
                } else {
                    oidcAuthorization = SessionDataFactory.user((BasicUser)oidcAccessToken);
                    this.invokerHandler.runAs((SessionData)oidcAuthorization, (Callable)new CallableRunnable((Runnable)object));
                }
            } else {
                object.run();
            }
        }
    }

    public Transaction findByTransactionNumber(String string) throws FrameworkException {
        QTransaction qTransaction = QTransaction.transaction1;
        Transaction transaction = (Transaction)InvocationContext.ensure().getAttribute((Object)("transaction:" + string), () -> (Transaction)((DBQuery)this.from(new EntityPath[]{qTransaction}).where((Predicate)qTransaction.transactionNumber.equalsIgnoreCase(string))).singleResult((Expression)qTransaction));
        try {
            if (transaction == null) {
                throw new EntityNotFoundException();
            }
            this.entityManagerHandler.checkAccess((IEntity)transaction);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            throw new EntityNotFoundException(Transaction.class, string);
        }
        return transaction;
    }

    public Map<String, Object> getCustomFieldValidationBindings(LocateAccountOwnerResult locateAccountOwnerResult, LocateAccountOwnerResult locateAccountOwnerResult2, PaymentTransferType paymentTransferType) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("paymentType", paymentTransferType);
        hashMap.put("fromOwner", locateAccountOwnerResult == null ? null : locateAccountOwnerResult.getAccountOwner());
        hashMap.put("fromOwnerResult", locateAccountOwnerResult);
        hashMap.put("toOwner", locateAccountOwnerResult2 == null ? null : locateAccountOwnerResult2.getAccountOwner());
        hashMap.put("toOwnerResult", locateAccountOwnerResult2);
        return hashMap;
    }

    public TransactionData getData(Transaction transaction, boolean bl) {
        switch (transaction.getNature()) {
            case PAYMENT: {
                return this.paymentService.getData((Payment)transaction, bl);
            }
            case RECURRING_PAYMENT: {
                return this.recurringPaymentService.getData((RecurringPayment)transaction);
            }
            case SCHEDULED_PAYMENT: {
                return this.scheduledPaymentService.getData((ScheduledPayment)transaction);
            }
            case EXTERNAL_PAYMENT: {
                return this.externalPaymentService.getData((ExternalPayment)transaction);
            }
            case PAYMENT_REQUEST: {
                return this.paymentRequestService.getData((PaymentRequest)transaction);
            }
            case TICKET: {
                return this.ticketService.getData((Ticket)transaction);
            }
            case IMPORT: {
                return this.newData(transaction, bl);
            }
        }
        throw new IllegalStateException("Unhandled transaction nature: " + String.valueOf(transaction.getNature()));
    }

    public TransactionData getData(TransactionVO transactionVO) throws FrameworkException {
        Transaction transaction = (Transaction)this.conversionHandler.convert(Transaction.class, (Object)transactionVO);
        return this.getData(transaction, true);
    }

    public Transaction getGeneratedBy(Transaction transaction) {
        if (!(transaction instanceof BasePayment)) {
            return null;
        }
        QTransaction qTransaction = QTransaction.transaction1;
        return (Transaction)((DBQuery)this.from(new EntityPath[]{qTransaction}).where((Predicate)qTransaction.transaction().eq((Object)transaction))).singleResult((Expression)qTransaction);
    }

    public InstallmentOverviewSearchData getInstallmentsOverviewSearchData() throws FrameworkException {
        InstallmentOverviewSearchData installmentOverviewSearchData = new InstallmentOverviewSearchData();
        this.fill((IInstallmentSearchData)installmentOverviewSearchData, null, ExportFormatContext.INSTALLMENTS_OVERVIEW, TransSearchContext.INSTALLMENTS_OVERVIEW);
        installmentOverviewSearchData.setPreselectedPeriods(this.accountService.resolvePreselectedPeriods(false));
        InstallmentOverviewQuery installmentOverviewQuery = (InstallmentOverviewQuery)this.accountService.newQuery(InstallmentOverviewQuery.class, installmentOverviewSearchData.getFieldsForSearch());
        installmentOverviewQuery.setOrderBy(TransactionOrderBy.DATE_ASC);
        installmentOverviewSearchData.setQuery((QueryParameters)installmentOverviewQuery);
        return installmentOverviewSearchData;
    }

    public InstallmentSearchData getInstallmentsSearchData(InternalAccountOwner internalAccountOwner) throws FrameworkException {
        internalAccountOwner = this.accountHandler.locateOrCurrent((AccountOwner)internalAccountOwner, true).getInternalAccountOwner();
        InstallmentSearchData installmentSearchData = new InstallmentSearchData();
        installmentSearchData.setAccountOwner(this.accountHandler.toAccountOwnerVO(internalAccountOwner));
        this.fill((IInstallmentSearchData)installmentSearchData, internalAccountOwner, ExportFormatContext.INSTALLMENTS_SEARCH, internalAccountOwner instanceof SystemAccountOwner ? TransSearchContext.SYSTEM_INSTALLMENTS : TransSearchContext.USER_INSTALLMENTS);
        InstallmentQuery installmentQuery = (InstallmentQuery)this.accountService.newQuery(InstallmentQuery.class, installmentSearchData.getFieldsForSearch());
        installmentQuery.setOrderBy(TransactionOrderBy.DATE_ASC);
        installmentQuery.setOwner(installmentSearchData.getAccountOwner());
        installmentSearchData.setQuery((QueryParameters)installmentQuery);
        return installmentSearchData;
    }

    public Page<MaturityTableItemData> getMaturityTable(MaturityTableQuery maturityTableQuery) {
        PaymentTransferType paymentTransferType;
        MaturityPolicy maturityPolicy;
        TransferType transferType = (TransferType)this.conversionHandler.convert(TransferType.class, (Object)maturityTableQuery.getTransferType());
        if (transferType != null && this.dRateHandler.isEnabled(transferType.getCurrency(), null) && transferType instanceof PaymentTransferType && (maturityPolicy = (paymentTransferType = (PaymentTransferType)transferType).getMaturityPolicy()) == MaturityPolicy.HISTORY) {
            Comparable<BigDecimal> comparable;
            BigDecimal bigDecimal;
            BigDecimal bigDecimal2;
            Comparable<Date> comparable2;
            Comparable<Date> comparable3;
            Currency currency = transferType.getCurrency();
            Account account = this.accountService.load(maturityTableQuery.getOwner(), transferType.getFrom());
            ArrayList<MaturityTableItemData> arrayList = new ArrayList<MaturityTableItemData>();
            List list = this.transferService.getRatedTransfers(account, paymentTransferType.getMaturityHistorySize().intValue());
            if (list.size() > 0) {
                comparable3 = DateHelper.now();
                comparable2 = new Date(((Transfer)list.get(0)).getDate().getTime() - 1L);
                bigDecimal2 = this.accountService.getBalance(account, new Date(((Transfer)list.get(0)).getDate().getTime()));
                Object object = this.rateHandler.getRates(account, bigDecimal2, comparable2, RateVisibility.ALL);
                for (BigDecimal bigDecimal3 : list) {
                    BigDecimal bigDecimal4;
                    bigDecimal = new MaturityTableItemData();
                    comparable = bigDecimal3.getDate();
                    bigDecimal.setDate((DateTime)this.conversionHandler.convert(DateTime.class, (Object)comparable));
                    bigDecimal.setBeforeBalance(bigDecimal2);
                    BigDecimal bigDecimal5 = this.dRateHandler.convert((Object)object.getExpirationDate(), (Date)comparable);
                    bigDecimal.setBeforeMaturity(bigDecimal5);
                    boolean bl = account.equals((Object)bigDecimal3.getFrom());
                    BigDecimal bigDecimal6 = bl ? bigDecimal3.getAmount().negate() : bigDecimal3.getAmount();
                    bigDecimal.setTransferAmount(bigDecimal6);
                    BigDecimal bigDecimal7 = this.dRateHandler.convert((Object)bigDecimal3.getExpirationDate(), (Date)comparable);
                    bigDecimal.setTransferMaturity(bigDecimal7);
                    bigDecimal.setWouldBeMaturity(this.dRateHandler.convert((Object)object.getExpirationDate(), comparable3));
                    BigDecimal bigDecimal8 = bigDecimal2.add(bigDecimal6);
                    bigDecimal.setAfterBalance(bigDecimal8);
                    BigDecimal bigDecimal9 = null;
                    if (bigDecimal3.getParent() == null && CollectionHelper.size((Collection)bigDecimal3.getChildren()) == 0) {
                        bigDecimal4 = this.rateHandler.getRates(account, bigDecimal8, (Date)comparable, RateVisibility.ALL);
                        bigDecimal9 = bigDecimal4.getDRate();
                        object = bigDecimal4;
                    } else if (bl) {
                        bigDecimal4 = object.getVirtualRatedBalance().add(bigDecimal6);
                        if (BigDecimalHelper.isNegativeOrZero((BigDecimal)bigDecimal4)) {
                            bigDecimal9 = this.dRateHandler.getCreationValue(currency, (Date)comparable);
                            object.setVirtualRatedBalance(BigDecimal.ZERO);
                        } else {
                            bigDecimal9 = this.dRateHandler.convert((Object)object.getExpirationDate(), (Date)comparable);
                            object.setVirtualRatedBalance(bigDecimal4);
                        }
                        object.setExpirationDate((Date)this.dRateHandler.convert(bigDecimal9, (Date)comparable));
                    } else {
                        this.dRateHandler.applyIncomingTransfer(object, (Transfer)bigDecimal3);
                        bigDecimal9 = this.dRateHandler.convert((Object)object.getExpirationDate(), (Date)comparable);
                    }
                    bigDecimal.setAfterMaturity(bigDecimal9);
                    bigDecimal.setDaysSince((int)Math.round(DateHelper.daysBetween((Date)comparable, comparable3)));
                    if (maturityTableQuery.getWinningTransfer() != null && maturityTableQuery.getWinningTransfer().equals(bigDecimal3.getId())) {
                        bigDecimal.setWinningTransfer(bigDecimal3.getId());
                    }
                    arrayList.add((MaturityTableItemData)bigDecimal);
                    bigDecimal2 = bigDecimal8;
                    comparable2 = comparable;
                }
            }
            Collections.reverse(arrayList);
            comparable3 = BigDecimal.ZERO;
            comparable2 = null;
            bigDecimal2 = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                BigDecimal bigDecimal3;
                MaturityTableItemData maturityTableItemData = (MaturityTableItemData)arrayList.get(i);
                bigDecimal3 = maturityTableItemData.getTransferAmount();
                if (BigDecimalHelper.isNegative((BigDecimal)bigDecimal3)) {
                    comparable3 = ((BigDecimal)comparable3).add(maturityTableItemData.getTransferAmount());
                }
                maturityTableItemData.setSumOfOuts(((BigDecimal)comparable3).negate());
                bigDecimal = maturityTableItemData.getBeforeBalance().add((BigDecimal)comparable3).max(BigDecimal.ZERO);
                maturityTableItemData.setMaxAmount(bigDecimal);
                if (!BigDecimalHelper.isZero((BigDecimal)maturityTableItemData.getWouldBeMaturity())) continue;
                comparable = maturityTableItemData.getMaxAmount();
                if (bigDecimal2 != null && comparable.compareTo(bigDecimal2) <= 0) continue;
                bigDecimal2 = comparable;
                comparable2 = i;
            }
            if (maturityTableQuery.getWinningTransfer() == null && comparable2 != null) {
                MaturityTableItemData maturityTableItemData = (MaturityTableItemData)arrayList.get((Integer)comparable2);
                maturityTableItemData.setWinningTransfer(((Transfer)list.get(list.size() - (Integer)comparable2 - 1)).getId());
            }
            return this.convertMaturityTableToPage(arrayList, maturityTableQuery);
        }
        return PageImpl.empty();
    }

    public TransactionOverviewSearchData getOverviewSearchData(boolean bl) throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        TransactionOverviewSearchData transactionOverviewSearchData = new TransactionOverviewSearchData();
        this.accountService.fillTransSearchData((ITransSearchData)transactionOverviewSearchData, null, null, ExportFormatContext.TRANSACTIONS_OVERVIEW, bl ? TransSearchContext.PENDING_MY_AUTHORIZATION : TransSearchContext.TRANSACTIONS_OVERVIEW);
        this.fill((ITransactionSearchData)transactionOverviewSearchData, null);
        transactionOverviewSearchData.setAuthorizationRoles(this.getVisibleAuthorizationRoles());
        if (bl && sessionData.isAdmin()) {
            transactionOverviewSearchData.setAuthorizablePaymentTypes(this.conversionHandler.convertList(TransferTypeVO.class, this.authorizablePaymentTypes()));
        }
        TransactionOverviewQuery transactionOverviewQuery = (TransactionOverviewQuery)this.accountService.newQuery(TransactionOverviewQuery.class, transactionOverviewSearchData.getFieldsForSearch());
        for (PeriodPreselectorOptionData periodPreselectorOptionData : transactionOverviewSearchData.getPreselectedPeriods()) {
            if (!periodPreselectorOptionData.isDefaultOption()) continue;
            transactionOverviewQuery.setPeriod(periodPreselectorOptionData.getPeriod());
            break;
        }
        transactionOverviewQuery.setPendingMyAuthorization(bl);
        transactionOverviewSearchData.setQuery((QueryParameters)transactionOverviewQuery);
        return transactionOverviewSearchData;
    }

    public PerformPaymentData getPaymentData(InternalAccountOwner internalAccountOwner, InternalAccountOwner internalAccountOwner2, TransferTypeVO transferTypeVO) {
        Collection collection;
        PaymentPrincipalsConfiguration paymentPrincipalsConfiguration;
        SessionData sessionData = this.getSessionData();
        User user = sessionData.getLoggedUser();
        PerformPaymentData performPaymentData = new PerformPaymentData();
        LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locateOrCurrent((AccountOwner)internalAccountOwner);
        LocateAccountOwnerResult locateAccountOwnerResult2 = this.locateForPayment(internalAccountOwner2);
        InternalAccountOwner internalAccountOwner3 = locateAccountOwnerResult.getInternalAccountOwner();
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)transferTypeVO);
        List<PaymentTransferType> list = this.fill((PerformPaymentToOwnerData)performPaymentData, locateAccountOwnerResult, locateAccountOwnerResult2, paymentTransferType);
        performPaymentData.setFrom(this.accountHandler.toAccountOwnerVO(internalAccountOwner3));
        if (internalAccountOwner2 == null && sessionData.isRestrictedOperator()) {
            paymentPrincipalsConfiguration = (Operator)sessionData.getLoggedBasicUser();
            collection = CollectionHelper.orEmpty((Set)paymentPrincipalsConfiguration.getGroup().getRestrictPaymentsToUsers());
            performPaymentData.setAllowedUsers(collection.stream().filter(arg_0 -> this.lambda$getPaymentData$4((Operator)paymentPrincipalsConfiguration, arg_0)).map(this.conversionHandler.convertingFunction(UserVO.class, new Object[0])).sorted(ToStringComparator.instance()).collect(Collectors.toList()));
        }
        paymentPrincipalsConfiguration = sessionData.getChannelSettingsAccessor().getPayment();
        performPaymentData.setAllowScanQrCode(paymentPrincipalsConfiguration.isScanQrCode());
        if (CollectionHelper.isEmpty((Iterable)performPaymentData.getAllowedUsers())) {
            collection = new ArrayList(paymentPrincipalsConfiguration.getPrincipalTypes());
            this.principalTypeService.sort((List)collection);
            performPaymentData.setPrincipalTypes(this.conversionHandler.convertList(PrincipalTypeInputVO.class, (Iterable)collection));
            if (user != null) {
                boolean bl = Objects.equals(sessionData.getNetwork(), user.getNetwork());
                if (bl) {
                    bl = sessionData.hasPermission(Permission.MY_CONTACTS_ENABLE);
                }
                performPaymentData.setAllowContacts(paymentPrincipalsConfiguration.isContacts() && bl);
            }
            performPaymentData.setAllowAutocomplete(paymentPrincipalsConfiguration.isAutocomplete() && this.groupsHandler.users().basic().isNotEmpty());
            performPaymentData.setDefaultIdMethod(paymentPrincipalsConfiguration.getDefaultIdMethod());
            if (performPaymentData.getDefaultIdMethod() == IdentificationMethod.PRINCIPAL_TYPE) {
                PrincipalType principalType = paymentPrincipalsConfiguration.getDefaultPrincipalType();
                performPaymentData.setDefaultPrincipalType((PrincipalTypeInputVO)this.conversionHandler.convert(PrincipalTypeInputVO.class, (Object)principalType));
            }
        }
        boolean bl = this.rateHandler.isVisible((Collection)this.accountService.listVisibleCurrencies(locateAccountOwnerResult.getInternalAccountOwner()), null);
        Set set = list.stream().map(TransferType::getFrom).collect(Collectors.toSet());
        InternalAccountOwner internalAccountOwner4 = internalAccountOwner3;
        performPaymentData.setAccounts(set.stream().sorted().map(accountType -> this.accountService.load(internalAccountOwner4, accountType)).map(object -> this.accountService.toAccountWithStatus((Account)object, null, null, bl)).collect(Collectors.toList()));
        return performPaymentData;
    }

    public PerformPaymentToOwnerData getPaymentToOwnerData(InternalAccountOwner internalAccountOwner, InternalAccountOwner internalAccountOwner2, TransferTypeVO transferTypeVO) throws FrameworkException {
        PerformPaymentToOwnerData performPaymentToOwnerData = new PerformPaymentToOwnerData();
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)transferTypeVO);
        this.fill(performPaymentToOwnerData, this.accountHandler.locateOrCurrent((AccountOwner)internalAccountOwner), this.locateForPayment(internalAccountOwner2), paymentTransferType);
        return performPaymentToOwnerData;
    }

    public PerformPaymentTypeData getPaymentTypeData(InternalAccountOwner internalAccountOwner, InternalAccountOwner internalAccountOwner2, TransferTypeVO transferTypeVO) {
        return this.getPaymentTypeData(this.accountHandler.locateOrCurrent((AccountOwner)internalAccountOwner), this.locateForPayment(internalAccountOwner2), transferTypeVO);
    }

    public ReceivePaymentData getReceivePaymentData() throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        if (!sessionData.isMember()) {
            throw new IllegalActionException();
        }
        User user = sessionData.getLoggedUser();
        ReceivePaymentData receivePaymentData = new ReceivePaymentData();
        List list = this.accountService.listVisibleTypes((InternalAccountOwner)user);
        List list2 = sessionData.getProducts().member().getReceivePosPaymentTypes().stream().filter(paymentTransferType -> list.contains(paymentTransferType.getTo())).collect(Collectors.toList());
        receivePaymentData.setPaymentTypes(this.conversionHandler.convertList(TransferTypeWithCurrencyVO.class, list2));
        Set set = list2.stream().map(TransferType::getTo).collect(Collectors.toSet());
        receivePaymentData.setAccounts(set.stream().sorted().map(accountType -> this.accountService.load((InternalAccountOwner)user, accountType)).map(this.conversionHandler.convertingFunction(AccountWithCurrencyVO.class, new Object[0])).collect(Collectors.toList()));
        PaymentPrincipalsConfiguration paymentPrincipalsConfiguration = sessionData.getChannelSettingsAccessor().getPos();
        receivePaymentData.setAllowScanQrCode(paymentPrincipalsConfiguration.isScanQrCode());
        ArrayList arrayList = new ArrayList(paymentPrincipalsConfiguration.getPrincipalTypes());
        this.principalTypeService.sort(arrayList);
        receivePaymentData.setPrincipalTypes(this.conversionHandler.convertList(PrincipalTypeInputVO.class, arrayList));
        boolean bl = sessionData.hasPermission(Permission.MY_CONTACTS_ENABLE);
        receivePaymentData.setAllowContacts(paymentPrincipalsConfiguration.isContacts() && bl);
        receivePaymentData.setAllowAutocomplete(paymentPrincipalsConfiguration.isAutocomplete());
        receivePaymentData.setDefaultIdMethod(paymentPrincipalsConfiguration.getDefaultIdMethod());
        if (receivePaymentData.getDefaultIdMethod() == IdentificationMethod.PRINCIPAL_TYPE) {
            PrincipalType principalType = paymentPrincipalsConfiguration.getDefaultPrincipalType();
            receivePaymentData.setDefaultPrincipalType((PrincipalTypeInputVO)this.conversionHandler.convert(PrincipalTypeInputVO.class, (Object)principalType));
        }
        return receivePaymentData;
    }

    public ReceivePaymentFromUserData getReceivePaymentFromUserData(UserLocatorVO userLocatorVO, TransferTypeVO transferTypeVO) throws FrameworkException {
        SessionData sessionData = this.getSessionData();
        if (!sessionData.isMember()) {
            throw new IllegalActionException();
        }
        LocateAccountOwnerResult locateAccountOwnerResult = this.locateForReceiving((InternalAccountOwner)userLocatorVO);
        User user = locateAccountOwnerResult.getUser();
        if (user.equals((Object)sessionData.getLoggedUser())) {
            throw new EntityNotFoundException(User.class);
        }
        ReceivePaymentFromUserData receivePaymentFromUserData = new ReceivePaymentFromUserData();
        if (sessionData.relatesTo((BasicUser)user)) {
            receivePaymentFromUserData.setFrom((BasicUserVO)locateAccountOwnerResult.getVO());
        }
        LocateAccountOwnerResult locateAccountOwnerResult2 = this.accountHandler.locateOrCurrent(null);
        List<PaymentTransferType> list = this.listPaymentTypes(locateAccountOwnerResult, locateAccountOwnerResult2, null, true);
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)transferTypeVO);
        if (paymentTransferType != null && !list.contains(paymentTransferType)) {
            this.throwInvalidTransferType();
        }
        List list2 = this.conversionHandler.convertList(TransferTypeWithCurrencyVO.class, list);
        receivePaymentFromUserData.setPaymentTypes(list2);
        if (paymentTransferType == null) {
            paymentTransferType = (PaymentTransferType)CollectionHelper.first(list);
        }
        if (paymentTransferType != null) {
            receivePaymentFromUserData.setPaymentTypeData(this.getReceivePaymentTypeData(locateAccountOwnerResult, new TransferTypeVO(paymentTransferType.getId())));
        }
        return receivePaymentFromUserData;
    }

    public PerformPaymentTypeData getReceivePaymentTypeData(UserLocatorVO userLocatorVO, TransferTypeVO transferTypeVO) throws FrameworkException {
        if (!this.isMember()) {
            throw new IllegalActionException();
        }
        LocateAccountOwnerResult locateAccountOwnerResult = this.locateForReceiving((InternalAccountOwner)userLocatorVO);
        return this.getReceivePaymentTypeData(locateAccountOwnerResult, transferTypeVO);
    }

    public TransactionSearchData getSearchData(InternalAccountOwner internalAccountOwner) throws FrameworkException {
        BasicUser basicUser;
        internalAccountOwner = this.accountHandler.locateOrCurrent((AccountOwner)internalAccountOwner, true).getInternalAccountOwner();
        TransactionSearchData transactionSearchData = new TransactionSearchData();
        this.accountService.fillTransSearchData((ITransSearchData)transactionSearchData, null, internalAccountOwner, ExportFormatContext.TRANSACTIONS_SEARCH, internalAccountOwner instanceof SystemAccountOwner ? TransSearchContext.SYSTEM_TRANSACTIONS : TransSearchContext.USER_TRANSACTIONS);
        this.fill((ITransactionSearchData)transactionSearchData, internalAccountOwner);
        transactionSearchData.setAccountOwner(this.accountHandler.toAccountOwnerVO(internalAccountOwner));
        if (internalAccountOwner instanceof BasicUser) {
            basicUser = (BasicUser)internalAccountOwner;
            transactionSearchData.setUserPermissions(this.userService.getProfileTransactionActionsData(basicUser.getUser()));
        }
        transactionSearchData.setAuthorizationRoles(this.getVisibleAuthorizationRoles());
        basicUser = (TransactionQuery)this.accountService.newQuery(TransactionQuery.class, transactionSearchData.getFieldsForSearch());
        basicUser.setOwner(transactionSearchData.getAccountOwner());
        transactionSearchData.setQuery((QueryParameters)basicUser);
        return transactionSearchData;
    }

    public boolean isCheckConfirmation(PaymentTransferType paymentTransferType, InternalAccountOwner internalAccountOwner, BigDecimal bigDecimal, Date date) {
        Boolean bl = null;
        PaymentLimitDescriptor paymentLimitDescriptor = this.limitsOf(paymentTransferType, this.getSessionData(), null);
        BigDecimal bigDecimal2 = paymentLimitDescriptor.maxAmountPinless();
        BigDecimal bigDecimal3 = paymentLimitDescriptor.maxAmountPerDayPinless();
        if (BigDecimalHelper.isPositive((BigDecimal)bigDecimal2)) {
            bl = BigDecimalHelper.compareTo((BigDecimal)bigDecimal, (BigDecimal)bigDecimal2) > 0;
        }
        if (date != null && (bl == null || !bl.booleanValue()) && BigDecimalHelper.isPositive((BigDecimal)bigDecimal3)) {
            Account account = this.accountService.load(internalAccountOwner, paymentTransferType.getFrom());
            BigDecimal bigDecimal4 = (BigDecimal)this.paymentsAndInstallments(account, null, (TransferType)paymentTransferType, date, TimeInterval.ONE_DAY).getFirst();
            bl = BigDecimalHelper.compareTo((BigDecimal)bigDecimal.add(bigDecimal4), (BigDecimal)bigDecimal3) > 0;
        }
        return bl == null || bl != false;
    }

    public List<PaymentTransferType> listPaymentTypes(LocateAccountOwnerResult locateAccountOwnerResult, LocateAccountOwnerResult locateAccountOwnerResult2, Currency currency, boolean bl) {
        InternalAccountOwner internalAccountOwner;
        SessionData sessionData = this.getSessionData();
        InternalAccountOwner internalAccountOwner2 = locateAccountOwnerResult == null ? null : locateAccountOwnerResult.getInternalAccountOwner();
        InternalAccountOwner internalAccountOwner3 = internalAccountOwner = locateAccountOwnerResult2 == null ? null : locateAccountOwnerResult2.getInternalAccountOwner();
        Set<UserAccount> set = internalAccountOwner2 == null ? null : (locateAccountOwnerResult.getAccount() != null ? Collections.singleton(locateAccountOwnerResult.getAccount()) : this.accountService.listVisible(internalAccountOwner2));
        Set<UserAccount> set2 = internalAccountOwner != null && locateAccountOwnerResult2.getAccount() != null ? Collections.singleton(locateAccountOwnerResult2.getAccount()) : null;
        PaymentTransferTypeQuery paymentTransferTypeQuery = new PaymentTransferTypeQuery();
        paymentTransferTypeQuery.setUnlimited();
        if (internalAccountOwner2 != null) {
            paymentTransferTypeQuery.setFromAccounts(set);
            paymentTransferTypeQuery.setFromOwner(internalAccountOwner2);
            if (sessionData.isRestrictedOperator() && internalAccountOwner2.equals((Object)sessionData.getLoggedUser())) {
                OperatorGroup operatorGroup = sessionData.getLoggedOperator().getGroup();
                paymentTransferTypeQuery.setPossibleTransferTypes((Collection)operatorGroup.getPaymentTypes().stream().filter(OperatorGroupPaymentType::isEnabled).map(OperatorGroupPaymentType::getPaymentType).collect(Collectors.toSet()));
            }
        }
        if (internalAccountOwner != null) {
            paymentTransferTypeQuery.setToAccounts(set2);
            paymentTransferTypeQuery.setToOwner((AccountOwner)internalAccountOwner);
        }
        paymentTransferTypeQuery.setCurrency(currency);
        paymentTransferTypeQuery.setReceive(bl);
        if (bl) {
            paymentTransferTypeQuery.setChannel(this.channelService.getPos());
        } else {
            paymentTransferTypeQuery.setChannel(sessionData.getChannel());
        }
        paymentTransferTypeQuery.setPrincipalType(locateAccountOwnerResult == null ? null : locateAccountOwnerResult.getPrincipalType());
        return this.transferTypeService.searchPayment(paymentTransferTypeQuery).getPageItems();
    }

    public TransactionVO load(Long l) throws FrameworkException {
        Transaction transaction = this.find(Transaction.class, l);
        return (TransactionVO)this.conversionHandler.convert(TransactionVO.class, (Object)transaction);
    }

    public TransactionVO loadByTransactionNumber(String string) throws FrameworkException {
        return (TransactionVO)this.conversionHandler.convert(TransactionVO.class, (Object)this.findByTransactionNumber(string));
    }

    public LocateAccountOwnerResult locateForPayment(InternalAccountOwner internalAccountOwner) {
        SessionData sessionData = this.getSessionData();
        Channel channel = sessionData.getChannel();
        if (channel.isPos()) {
            return this.accountHandler.locate((AccountOwner)internalAccountOwner);
        }
        PaymentPrincipalsConfiguration paymentPrincipalsConfiguration = sessionData.getChannelSettingsAccessor().getPayment();
        boolean bl = sessionData.hasPermission(Permission.USER_OPERATORS_PAY) || sessionData.hasPermission(Permission.USER_OPERATORS_VIEW);
        LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locate((AccountOwner)internalAccountOwner, true, true, bl, false, (Collection)paymentPrincipalsConfiguration.getPrincipalTypes(), paymentPrincipalsConfiguration.getDefaultPrincipalType(), false);
        this.validateStatus(locateAccountOwnerResult);
        UserAccount userAccount = locateAccountOwnerResult.getAccount();
        if (userAccount != null && userAccount.isTransient()) {
            userAccount = (UserAccount)this.accountService.require((InternalAccountOwner)userAccount.getOwner(), (AccountType)userAccount.getType());
            LocateUserResult locateUserResult = new LocateUserResult((UserPrincipal)userAccount);
            locateAccountOwnerResult = new LocateAccountOwnerResult(locateUserResult);
        }
        return locateAccountOwnerResult;
    }

    public LocateAccountOwnerResult locateForReceiving(InternalAccountOwner internalAccountOwner) {
        LocateAccountOwnerResult locateAccountOwnerResult;
        SessionData sessionData = this.getSessionData();
        PaymentPrincipalsConfiguration paymentPrincipalsConfiguration = sessionData.getChannelSettingsAccessor().getPos();
        boolean bl = sessionData.hasPermission(Permission.USER_OPERATORS_PAY);
        try {
            locateAccountOwnerResult = this.accountHandler.locate((AccountOwner)internalAccountOwner, paymentPrincipalsConfiguration.isAutocomplete(), paymentPrincipalsConfiguration.isContacts(), bl, false, (Collection)paymentPrincipalsConfiguration.getPrincipalTypes(), paymentPrincipalsConfiguration.getDefaultPrincipalType(), true);
        }
        catch (LocateUserException locateUserException) {
            if (locateUserException.getPrincipalType() != null) {
                throw new PosPayerInaccessiblePrincipalException(locateUserException.getPrincipalType());
            }
            throw locateUserException;
        }
        this.validateStatus(locateAccountOwnerResult);
        if (!locateAccountOwnerResult.isUser()) {
            throw new LocateUserException();
        }
        boolean bl2 = this.userChannelService.isChannelAccessible((BasicUser)locateAccountOwnerResult.getUser(), this.channelService.getPos());
        if (!bl2) {
            throw new PosPayerNotInChannelException();
        }
        if (this.agreementLogService.hasPendingAgreements(locateAccountOwnerResult.getUser())) {
            throw new PosPayerNotOperativeException();
        }
        return locateAccountOwnerResult;
    }

    public <D extends TransactionData> D newData(Transaction transaction, boolean bl) {
        PaymentData paymentData;
        if (transaction instanceof Payment) {
            paymentData = new PaymentData();
        } else if (transaction instanceof ScheduledPayment) {
            paymentData = new ScheduledPaymentData();
        } else if (transaction instanceof RecurringPayment) {
            paymentData = new RecurringPaymentData();
        } else if (transaction instanceof ExternalPayment) {
            paymentData = new ExternalPaymentData();
        } else if (transaction instanceof PaymentRequest) {
            paymentData = new PaymentRequestData();
        } else if (transaction instanceof Ticket) {
            paymentData = new TicketData();
        } else if (transaction instanceof ImportTransaction) {
            paymentData = new ImportedTransactionData();
        } else {
            throw new IllegalStateException("Unhandled transaction nature: " + String.valueOf(transaction.getNature()));
        }
        this.fill(paymentData, transaction, bl);
        return (D)paymentData;
    }

    public void persist(Transaction transaction) {
        Account account;
        Account account2 = transaction.getFrom();
        if (account2 != null && account2.isTransient()) {
            transaction.setFrom(this.accountService.require(account2.getOwner(), account2.getType()));
        }
        if ((account = transaction.getTo()) != null && account.isTransient()) {
            transaction.setTo(this.accountService.require(account.getOwner(), account.getType()));
        }
        this.entityManagerHandler.persist((IEntity)transaction);
        this.customFieldValueHandler.processAfterSave((EntityWithCustomValues)transaction);
        this.transactionSearchHandler.index((NetworkedEntity)transaction);
    }

    public TransactionValidationData prepareValidation(PrepareValidationParameter prepareValidationParameter) throws FrameworkException {
        PaymentTransferType paymentTransferType;
        InternalAccountOwner internalAccountOwner = prepareValidationParameter.getFrom().getInternalAccountOwner();
        AccountOwner accountOwner = prepareValidationParameter.getTo().getAccountOwner();
        SessionData sessionData = this.getSessionData();
        Validator validator = new Validator();
        if (prepareValidationParameter.isValidateNFCChallenge()) {
            validator.general(object -> {
                try {
                    this.tokenService.validateNFCChallenge(prepareValidationParameter.getNfcChallenge());
                    return null;
                }
                catch (ValidationException validationException) {
                    this.getLogger().error("Error validating NFC challenge: " + String.valueOf((Object)validationException));
                    return new ValidationError(BankingKeys.Transactions.INVALID_NFCCHALLENGE);
                }
            });
        }
        if ((paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)prepareValidationParameter.getType())) == null && (internalAccountOwner != null || !prepareValidationParameter.getCreationType().isRequirePayer()) && accountOwner != null && prepareValidationParameter.isAllowSearchingTTWhenNoneIsGiven() && (paymentTransferType = this.resolvePaymentType(prepareValidationParameter)) != null) {
            prepareValidationParameter.setTypeToDTO(new TransferTypeVO(paymentTransferType.getId()));
        }
        if (prepareValidationParameter.isFromRequired()) {
            validator.property((org.cyclos.model.Property)PerformTransactionDTO.OWNER, BankingKeys.Accounts.FROM).required();
        }
        if (prepareValidationParameter.isInternal()) {
            validator.property((org.cyclos.model.Property)PerformInternalTransactionDTO.SUBJECT, BankingKeys.Accounts.TO).required();
        }
        Property property = validator.property((org.cyclos.model.Property)PerformPaymentDTO.TYPE, BankingKeys.Transactions.TYPE);
        if (internalAccountOwner != null && accountOwner != null) {
            property.required();
        }
        Property property2 = validator.property((org.cyclos.model.Property)PerformPaymentDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION);
        if (prepareValidationParameter.isValidateDescription()) {
            property2.maxLength(4000);
        }
        if (paymentTransferType != null) {
            Object object2;
            if (!paymentTransferType.isAllowFromCustomName() && StringHelper.isNotBlank((Object)prepareValidationParameter.getFromName())) {
                validator.property((org.cyclos.model.Property)PerformPaymentDTO.FROM_NAME, BankingKeys.Transactions.FROM_NAME).invalid();
            }
            if (!paymentTransferType.isAllowToCustomName() && StringHelper.isNotBlank((Object)prepareValidationParameter.getToName())) {
                validator.property((org.cyclos.model.Property)PerformPaymentDTO.TO_NAME, BankingKeys.Transactions.TO_NAME).invalid();
            }
            if (prepareValidationParameter.isValidateDescription()) {
                if (paymentTransferType.getDescriptionAvailability() == Availability.REQUIRED) {
                    property2.required();
                } else if (paymentTransferType.getDescriptionAvailability() == Availability.DISABLED && StringHelper.isNotBlank((Object)prepareValidationParameter.getDescription())) {
                    property2.invalid(BankingKeys.Transactions.DESCRIPTION_DISABLED_ERROR);
                }
            }
            if (internalAccountOwner != null && accountOwner != null) {
                object2 = this.transferTypeService.resolveDirection(internalAccountOwner, accountOwner);
                if (paymentTransferType.getDirection() != object2) {
                    property.invalid();
                } else if (!prepareValidationParameter.isIgnoreChannelForPaymentType() && (!paymentTransferType.getChannels().contains(sessionData.getChannel()) || sessionData.getPrincipalType() != null && CollectionHelper.isNotEmpty((Iterable)paymentTransferType.getPrincipalTypes()) && !paymentTransferType.getPrincipalTypes().contains(sessionData.getPrincipalType()))) {
                    property.invalid();
                }
            }
            if (prepareValidationParameter.isValidateCustomFields()) {
                object2 = this.getCustomFieldValidationBindings(prepareValidationParameter.getFrom(), prepareValidationParameter.getTo(), paymentTransferType);
                List list = prepareValidationParameter.getReceiverSessionData() == null ? this.transactionCustomFieldService.listVisible((AccountOwner)(prepareValidationParameter.isInverse() ? accountOwner : internalAccountOwner)) : (List)this.invokerHandler.runAs(prepareValidationParameter.getReceiverSessionData(), () -> this.transactionCustomFieldService.listVisible(accountOwner));
                for (TransactionCustomField transactionCustomField : paymentTransferType.getCustomFields()) {
                    if (!list.contains(transactionCustomField)) continue;
                    CustomFieldHelper.findValueOrNew((CustomFieldDetailedVO)((CustomFieldDetailedVO)this.conversionHandler.convert(CustomFieldDetailedVO.class, (Object)transactionCustomField)), (Collection)prepareValidationParameter.getCustomValues());
                    boolean bl = prepareValidationParameter.isExcludeHideInForm() && transactionCustomField.isHideInForm();
                    if (bl) continue;
                    this.customFieldValueHandler.addValueValidation(validator, (CustomField)transactionCustomField, (EntityPathBase)QTransactionCustomFieldValue.transactionCustomFieldValue, (Map)object2);
                }
            }
            if (prepareValidationParameter.isValidateAmount()) {
                this.addStaticAmountValidations(validator, paymentTransferType, prepareValidationParameter.getFrom(), prepareValidationParameter.getAmount());
            }
        }
        if (prepareValidationParameter.isValidateConfirmationPassword()) {
            this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).addRequiredValidation(validator, (org.cyclos.model.Property)PerformPaymentDTO.CONFIRMATION_PASSWORD);
        }
        return new TransactionValidationData(validator, prepareValidationParameter.getFrom(), prepareValidationParameter.getTo(), paymentTransferType);
    }

    public TransferVO processInstallment(InstallmentActionDTO installmentActionDTO) throws FrameworkException {
        Installment installment = (Installment)this.conversionHandler.convert(Installment.class, (Object)installmentActionDTO.getInstallment());
        if (installment instanceof ScheduledPaymentInstallment) {
            return this.scheduledPaymentService.processInstallment(installmentActionDTO);
        }
        if (installment instanceof RecurringPaymentOccurrence) {
            return this.recurringPaymentService.processFailure(installmentActionDTO);
        }
        throw new IllegalActionException("Invalid installment: " + String.valueOf(installment));
    }

    public <T> T receive(InternalAccountOwner internalAccountOwner, Callable<T> callable) throws FrameworkException {
        InvocationContext.get().setAttribute((Object)"tempOwner", (Object)this.getLoggedUser());
        LocateAccountOwnerResult locateAccountOwnerResult = this.locateForReceiving(internalAccountOwner);
        return this.runAsUserToReceivePayment(locateAccountOwnerResult, callable);
    }

    public void removeDeviceConfirmationForReceive(String string, @NotNull PerformInternalTransactionDTO performInternalTransactionDTO) throws FrameworkException {
        InternalAccountOwner internalAccountOwner = performInternalTransactionDTO.getOwner();
        LocateAccountOwnerResult locateAccountOwnerResult = this.locateForReceiving(internalAccountOwner);
        this.runAsUserToReceivePayment(locateAccountOwnerResult, () -> {
            this.deviceConfirmationService.remove(string);
            return null;
        });
    }

    public void requestNewOTPForReceive(PerformInternalTransactionDTO performInternalTransactionDTO, SendMedium sendMedium) throws FrameworkException, SmsSendingException {
        InternalAccountOwner internalAccountOwner = performInternalTransactionDTO.getOwner();
        LocateAccountOwnerResult locateAccountOwnerResult = this.locateForReceiving(internalAccountOwner);
        this.runAsUserToReceivePayment(locateAccountOwnerResult, () -> {
            List list = this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).getOtpSendMediums();
            PermissionHelper.checkContains((Collection)list, (Object)sendMedium);
            this.passwordService.requestNewOTP(sendMedium, null, null);
            return null;
        });
    }

    public PaymentTransferType resolvePaymentType(InternalAccountOwner internalAccountOwner, AccountOwner accountOwner, Currency currency, Channel channel, PrincipalType principalType, PaymentCreationType paymentCreationType) throws FrameworkException {
        if (!(internalAccountOwner == null && paymentCreationType.isRequirePayer() || accountOwner == null)) {
            PaymentTransferTypeQuery paymentTransferTypeQuery = new PaymentTransferTypeQuery();
            paymentTransferTypeQuery.setFromOwner(internalAccountOwner);
            paymentTransferTypeQuery.setToOwner(accountOwner);
            paymentTransferTypeQuery.setReceive(paymentCreationType == PaymentCreationType.POS);
            paymentTransferTypeQuery.setCurrency(currency);
            paymentTransferTypeQuery.setChannel(channel);
            paymentTransferTypeQuery.setPrincipalType(principalType);
            paymentTransferTypeQuery.setPageSize(Integer.valueOf(2));
            Pair<Integer, PaymentTransferType> pair = this.countPaymentTypes(paymentCreationType, paymentTransferTypeQuery);
            if ((Integer)pair.getFirst() == 1) {
                return (PaymentTransferType)pair.getSecond();
            }
        }
        return null;
    }

    public Page<TransactionResultVO> search(TransactionQuery transactionQuery) throws FrameworkException {
        this.checkOwnedQuery((OwnedTransactionQuery)transactionQuery);
        this.accountService.applyQueryConstraints((AbstractTransQuery)transactionQuery);
        return this.transactionSearchHandler.searchTransactions(transactionQuery);
    }

    public Page<InstallmentResultVO> searchInstallments(@NotNull InstallmentQuery installmentQuery) throws FrameworkException {
        this.checkOwnedQuery((OwnedTransactionQuery)installmentQuery);
        this.accountService.applyQueryConstraints((AbstractTransQuery)installmentQuery);
        return this.installmentSearchHandler.searchInstallments(installmentQuery);
    }

    public Page<InstallmentResultVO> searchInstallmentsOverview(@NotNull InstallmentOverviewQuery installmentOverviewQuery) throws FrameworkException {
        this.accountService.applyQueryConstraints((AbstractTransQuery)installmentOverviewQuery);
        return this.installmentSearchHandler.search((QueryParameters)installmentOverviewQuery);
    }

    public Page<TransactionResultVO> searchOverview(@NotNull TransactionOverviewQuery transactionOverviewQuery) throws FrameworkException {
        this.accountService.applyQueryConstraints((AbstractTransQuery)transactionOverviewQuery);
        return this.transactionSearchHandler.search((QueryParameters)transactionOverviewQuery);
    }

    public ExtensionPointAccessor setStatusAndGetExtensionPoint(Installment installment, InstallmentStatus installmentStatus) {
        ExtensionPointAccessor extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)TransactionExtensionPointEvent.INSTALLMENT_CHANGE_STATUS, new ExtensionPointFilter(installment.getTransaction().getType())).attribute("installment", (Object)installment).attribute("oldStatus", (Object)installment.getStatus()).attribute("newStatus", (Object)installmentStatus);
        extensionPointAccessor.fireValidated();
        installment.setStatus(installmentStatus);
        if (installmentStatus.isTerminal()) {
            installment.setBy(this.getLoggedBasicUser());
        }
        this.installmentSearchHandler.index((NetworkedEntity)installment);
        return extensionPointAccessor;
    }

    public <T extends Transaction, S extends TransactionStatus> ExtensionPointAccessor setStatusAndGetExtensionPoint(T t, S s) {
        ExtensionPointAccessor extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)TransactionExtensionPointEvent.CHANGE_STATUS, new ExtensionPointFilter(t.getType())).attribute("transaction", t).attribute("oldStatus", (Object)((HasTransactionStatus)t).getStatus()).attribute("newStatus", s);
        extensionPointAccessor.fireValidated();
        ((HasTransactionStatus)t).setStatus(s);
        this.transactionSearchHandler.index(t);
        return extensionPointAccessor;
    }

    public void settleInstallment(InstallmentActionDTO installmentActionDTO) throws FrameworkException {
        Installment installment = (Installment)this.conversionHandler.convert(Installment.class, (Object)installmentActionDTO.getInstallment());
        if (installment instanceof ScheduledPaymentInstallment) {
            this.scheduledPaymentService.settleInstallment(installmentActionDTO);
        }
        throw new IllegalActionException("Invalid installment: " + String.valueOf(installment));
    }

    public void updatePreviewAndPayment(BasePaymentPreviewVO basePaymentPreviewVO, PerformTransactionDTO performTransactionDTO, LocateAccountOwnerResult locateAccountOwnerResult, LocateAccountOwnerResult locateAccountOwnerResult2, TransferType transferType, SessionData sessionData) {
        if (sessionData != null) {
            this.invokerHandler.runAs(sessionData, () -> {
                basePaymentPreviewVO.getFromAccount().setOwner((InternalAccountOwner)this.conversionHandler.convert(BasicUserVO.class, (Object)locateAccountOwnerResult.getInternalAccountOwner()));
                performTransactionDTO.setOwner(locateAccountOwnerResult.getInternalVO());
                return null;
            });
        } else {
            performTransactionDTO.setOwner(locateAccountOwnerResult.getInternalVO());
        }
        if (performTransactionDTO instanceof PerformInternalTransactionDTO) {
            ((PerformInternalTransactionDTO)performTransactionDTO).setSubject(locateAccountOwnerResult2.getInternalVO());
        }
        performTransactionDTO.setType((TransferTypeVO)this.conversionHandler.convert(TransferTypeVO.class, (Object)transferType));
        performTransactionDTO.setCustomValues(this.customFieldValueHandler.resolveValues(TransactionCustomField.class, (Collection)performTransactionDTO.getCustomValues()));
        if (basePaymentPreviewVO instanceof PaymentPreviewVO) {
            ((PaymentPreviewVO)basePaymentPreviewVO).setPayment((PerformPaymentDTO)performTransactionDTO);
        } else if (basePaymentPreviewVO instanceof RecurringPaymentPreviewVO) {
            ((RecurringPaymentPreviewVO)basePaymentPreviewVO).setRecurringPayment((PerformRecurringPaymentDTO)performTransactionDTO);
        } else if (basePaymentPreviewVO instanceof ScheduledPaymentPreviewVO) {
            ((ScheduledPaymentPreviewVO)basePaymentPreviewVO).setScheduledPayment((PerformScheduledPaymentDTO)performTransactionDTO);
        } else if (basePaymentPreviewVO instanceof ExternalPaymentPreviewVO) {
            ((ExternalPaymentPreviewVO)basePaymentPreviewVO).setPayment((PerformExternalPaymentDTO)performTransactionDTO);
        } else {
            throw new IllegalArgumentException("Unsupported preview type: " + basePaymentPreviewVO.getClass().getName());
        }
    }

    public void validateMinTimeBetweenPayments(LocateAccountOwnerResult locateAccountOwnerResult, PaymentTransferType paymentTransferType) throws FrameworkException, TransferException {
        TimeInterval timeInterval = paymentTransferType.getMinTimeBetweenTransfers();
        if (timeInterval == null || !timeInterval.isValid()) {
            return;
        }
        Account account = locateAccountOwnerResult.getAccount(paymentTransferType.getFrom());
        if (account == null || account.isTransient()) {
            return;
        }
        this.lockHandler.lock(AccountLockKey.of(account));
        Date date = DateHelper.subtract((Date)new Date(), (ITimeInterval)timeInterval);
        QBasePayment qBasePayment = QBasePayment.basePayment;
        boolean bl = ((DBQuery)this.from(new EntityPath[]{qBasePayment}).where(new Predicate[]{qBasePayment.from().eq((Object)account), qBasePayment.type().eq((Object)paymentTransferType), qBasePayment.authorizationStatus.in((Object[])new TransactionAuthorizationStatus[]{TransactionAuthorizationStatus.AUTHORIZED, TransactionAuthorizationStatus.NA, TransactionAuthorizationStatus.PENDING_AUTHORIZATION}), qBasePayment.date.after((Comparable)date)})).hasResults();
        if (bl) {
            throw new MinTimeBetweenPaymentsException();
        }
    }

    public void validatePaymentAmount(LocateAccountOwnerResult locateAccountOwnerResult, LocateAccountOwnerResult locateAccountOwnerResult2, PaymentTransferType paymentTransferType, BigDecimal bigDecimal, Date date) throws FrameworkException, TransferException {
        Comparable<BigDecimal> comparable;
        Object object;
        Comparable<Integer> comparable2;
        Object object2;
        Object object3;
        SessionData sessionData = this.getSessionData();
        if (date == null) {
            date = DateHelper.now();
        }
        BasicUser basicUser = sessionData.getLoggedBasicUser();
        Account account = this.accountService.load(locateAccountOwnerResult.getInternalAccountOwner(), paymentTransferType.getFrom());
        if (account.isTransient()) {
            return;
        }
        PaymentLimitDescriptor paymentLimitDescriptor = this.limitsOf(paymentTransferType, sessionData, account);
        BigDecimal bigDecimal2 = paymentLimitDescriptor.maxAmount();
        BigDecimal bigDecimal3 = paymentLimitDescriptor.maxAmountPerDay();
        BigDecimal bigDecimal4 = paymentLimitDescriptor.maxAmountPerWeek();
        BigDecimal bigDecimal5 = paymentLimitDescriptor.maxAmountPerMonth();
        BigDecimal bigDecimal6 = paymentLimitDescriptor.maxAmountPerYear();
        Integer n = paymentLimitDescriptor.maxTransfersPerDay();
        Integer n2 = paymentLimitDescriptor.maxTransfersPerWeek();
        Integer n3 = paymentLimitDescriptor.maxTransfersPerMonth();
        boolean bl = n != null && n > 0;
        boolean bl2 = n2 != null && n2 > 0;
        boolean bl3 = n3 != null && n3 > 0;
        boolean bl4 = BigDecimalHelper.isPositive((BigDecimal)bigDecimal2);
        boolean bl5 = BigDecimalHelper.isPositive((BigDecimal)bigDecimal5);
        boolean bl6 = BigDecimalHelper.isPositive((BigDecimal)bigDecimal6);
        boolean bl7 = BigDecimalHelper.isPositive((BigDecimal)bigDecimal4);
        boolean bl8 = BigDecimalHelper.isPositive((BigDecimal)bigDecimal3);
        if (bl4 && BigDecimalHelper.compareTo((BigDecimal)bigDecimal, (BigDecimal)bigDecimal2) > 0) {
            CurrencyAmountDTO currencyAmountDTO = new CurrencyAmountDTO();
            currencyAmountDTO.setAmount(bigDecimal2);
            currencyAmountDTO.setCurrency((CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)paymentTransferType.getCurrency()));
            throw new MaxPaymentAmountExceededException(currencyAmountDTO);
        }
        if (bl || bl2 || bl3 || bl8 || bl7 || bl5 || bl6) {
            this.lockHandler.lock(AccountLockKey.of(account));
        }
        if (bl8 || bl) {
            object3 = this.paymentsAndInstallments(account, null, (TransferType)paymentTransferType, date, TimeInterval.ONE_DAY);
            object2 = (BigDecimal)object3.getFirst();
            comparable2 = (Integer)object3.getSecond();
            if (bl8 && BigDecimalHelper.compareTo((BigDecimal)bigDecimal.add((BigDecimal)object2), (BigDecimal)bigDecimal3) > 0) {
                CurrencyAmountDTO currencyAmountDTO = new CurrencyAmountDTO();
                currencyAmountDTO.setAmount(bigDecimal3);
                currencyAmountDTO.setCurrency((CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)paymentTransferType.getCurrency()));
                throw new MaxAmountPerDayExceededException(currencyAmountDTO);
            }
            if (bl && (Integer)comparable2 >= n) {
                throw new MaxPaymentsPerDayExceededException(n);
            }
        }
        if (basicUser instanceof Operator) {
            object3 = (Pair<BigDecimal, Integer>)basicUser;
            object2 = object3.getGroup();
            comparable2 = null;
            if (object2 != null && (object = object2.getPaymentType(paymentTransferType)) != null) {
                comparable2 = object.getMaxAmountPerDay();
            }
            if (BigDecimalHelper.isPositive((BigDecimal)comparable2) && BigDecimalHelper.compareTo((BigDecimal)bigDecimal.add((BigDecimal)(comparable = (BigDecimal)(object = this.paymentsAndInstallments(account, (BasicUser)object3, (TransferType)paymentTransferType, date, TimeInterval.ONE_DAY)).getFirst())), comparable2) > 0) {
                CurrencyAmountDTO currencyAmountDTO = new CurrencyAmountDTO();
                currencyAmountDTO.setAmount(comparable2);
                currencyAmountDTO.setCurrency((CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)paymentTransferType.getCurrency()));
                throw new MaxAmountPerDayExceededException(currencyAmountDTO);
            }
        }
        if (bl7 || bl2) {
            object3 = this.paymentsAndInstallments(account, null, (TransferType)paymentTransferType, date, TimeInterval.ONE_WEEK);
            object2 = (BigDecimal)object3.getFirst();
            comparable2 = (Integer)object3.getSecond();
            if (bl7 && BigDecimalHelper.compareTo((BigDecimal)bigDecimal.add((BigDecimal)object2), (BigDecimal)bigDecimal4) > 0) {
                object = new CurrencyAmountDTO();
                object.setAmount(bigDecimal4);
                object.setCurrency((CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)paymentTransferType.getCurrency()));
                throw new MaxAmountPerWeekExceededException(object);
            }
            if (bl2 && (Integer)comparable2 >= n2) {
                throw new MaxPaymentsPerWeekExceededException(n2);
            }
        }
        if (bl5 || bl3) {
            object3 = this.paymentsAndInstallments(account, null, (TransferType)paymentTransferType, date, TimeInterval.ONE_MONTH);
            object2 = (BigDecimal)object3.getFirst();
            comparable2 = (Integer)object3.getSecond();
            if (bl5 && BigDecimalHelper.compareTo((BigDecimal)bigDecimal.add((BigDecimal)object2), (BigDecimal)bigDecimal5) > 0) {
                object = new CurrencyAmountDTO();
                object.setAmount(bigDecimal5);
                object.setCurrency((CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)paymentTransferType.getCurrency()));
                throw new MaxAmountPerMonthExceededException(object);
            }
            if (bl3 && (Integer)comparable2 >= n3) {
                throw new MaxPaymentsPerMonthExceededException(n3);
            }
        }
        if (bl6) {
            Date date2;
            Date date3;
            Pair<BigDecimal, Integer> pair;
            BigDecimal bigDecimal7;
            object3 = this.configurationHandler.getAccessor((IAccount)account).getTimeZone();
            object2 = ((TimeZone)object3).toZoneId();
            comparable2 = ZonedDateTime.ofInstant(account.getCreationDate().toInstant(), (ZoneId)object2);
            object = ZonedDateTime.now((ZoneId)object2);
            if (object.isBefore((ChronoZonedDateTime<?>)(comparable = ((ZonedDateTime)comparable2).truncatedTo(ChronoUnit.DAYS).withYear(object.getYear())))) {
                comparable = ((ZonedDateTime)comparable).minusYears(1L);
            }
            if (BigDecimalHelper.compareTo((BigDecimal)bigDecimal.add(bigDecimal7 = (BigDecimal)(pair = this.paymentsAndInstallments(account, null, (TransferType)paymentTransferType, DatePeriod.between((Date)(date3 = Date.from(comparable.toInstant())), (Date)(date2 = Date.from(((ZonedDateTime)comparable).plusYears(1L).minusSeconds(1L).toInstant()))))).getFirst()), (BigDecimal)bigDecimal6) > 0) {
                CurrencyAmountDTO currencyAmountDTO = new CurrencyAmountDTO();
                currencyAmountDTO.setAmount(bigDecimal6);
                currencyAmountDTO.setCurrency((CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)paymentTransferType.getCurrency()));
                throw new MaxAmountPerYearExceededException(currencyAmountDTO);
            }
        }
    }

    public DeviceConfirmationVO viewDeviceConfirmationForReceive(String string, @NotNull PerformInternalTransactionDTO performInternalTransactionDTO) throws FrameworkException {
        InternalAccountOwner internalAccountOwner = performInternalTransactionDTO.getOwner();
        LocateAccountOwnerResult locateAccountOwnerResult = this.locateForReceiving(internalAccountOwner);
        return this.runAsUserToReceivePayment(locateAccountOwnerResult, () -> this.deviceConfirmationService.load(string));
    }

    protected DataIterator<Installment> doExport(BaseInstallmentQuery baseInstallmentQuery) {
        if (baseInstallmentQuery instanceof InstallmentOverviewQuery) {
            return this.installmentSearchHandler.exportEntities((QueryParameters)((InstallmentOverviewQuery)baseInstallmentQuery));
        }
        return this.installmentSearchHandler.export((InstallmentQuery)baseInstallmentQuery);
    }

    protected DataIterator<Transaction> doExport(BaseTransactionQuery baseTransactionQuery) {
        if (baseTransactionQuery instanceof TransactionOverviewQuery) {
            return this.transactionSearchHandler.exportEntities((QueryParameters)((TransactionOverviewQuery)baseTransactionQuery));
        }
        return this.transactionSearchHandler.export((TransactionQuery)baseTransactionQuery);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(QTransaction.transaction1.type().from().currency().network(), true);
        networkPathRegistry.register(QInstallment.installment.transaction().type().from().currency().network(), true);
    }

    private void addStaticAmountValidations(Validator validator, PaymentTransferType paymentTransferType, LocateAccountOwnerResult locateAccountOwnerResult, BigDecimal bigDecimal) {
        Object object;
        BigDecimal bigDecimal2;
        Property property = validator.property((org.cyclos.model.Property)PerformPaymentDTO.AMOUNT, BankingKeys.Transactions.AMOUNT);
        Account account = null;
        if (paymentTransferType.isUseFixedAmount()) {
            if (bigDecimal != null && !BigDecimalHelper.areEquals((BigDecimal)bigDecimal, (BigDecimal)paymentTransferType.getFixedAmount())) {
                property.invalid();
            }
        } else {
            property.required().positiveNonZero((HasCurrency)paymentTransferType);
            bigDecimal2 = paymentTransferType.getMinAmount();
            if (bigDecimal2 != null) {
                property.greaterEquals((Comparable)new CurrencyAmount(paymentTransferType.getCurrency(), bigDecimal2));
            }
            account = locateAccountOwnerResult.getAccount(paymentTransferType.getFrom());
            object = this.limitsOf(paymentTransferType, this.getSessionData(), account).maxAmount();
            if (object != null) {
                property.lessEquals((Comparable)new CurrencyAmount(paymentTransferType.getCurrency(), (BigDecimal)object));
            } else {
                property.lessThan((Comparable)new CurrencyAmount(paymentTransferType.getCurrency(), TransactionService.MAX_TRANSACTION_AMOUNT_EXCLUSIVE));
            }
        }
        if (locateAccountOwnerResult.getInternalAccountOwner() != null && this.dRateHandler.isEnabled(paymentTransferType.getCurrency(), null) && (paymentTransferType.getMaturityPolicy() == MaturityPolicy.ZERO || paymentTransferType.getMaturityPolicy() == MaturityPolicy.HISTORY)) {
            if (account == null && (account = locateAccountOwnerResult.getAccount(paymentTransferType.getFrom())) == null) {
                return;
            }
            if (BigDecimalHelper.isNegativeOrZero((BigDecimal)this.accountService.getBalance(account, null))) {
                validator.general(GeneralValidations.invalid((MessageKey)BankingKeys.Transfers.ERROR_MATURITY_POLICY_NO_NEGATIVES, (Object[])new Object[0]));
            }
            if (BigDecimalHelper.isPositive((BigDecimal)(bigDecimal2 = this.rateHandler.getRates(account, RateVisibility.ALL).getDRate()))) {
                if (paymentTransferType.getMaturityPolicy() == MaturityPolicy.ZERO) {
                    validator.general(GeneralValidations.invalid((MessageKey)BankingKeys.Transfers.ERROR_MATURITY_POLICY_VIOLATION, (Object[])new Object[0]));
                }
                object = this.getWinnerFromMaturityTable(locateAccountOwnerResult.getInternalAccountOwner(), paymentTransferType);
                if (((MaturityTableWinnerData)object).winnerTransferId == null) {
                    validator.general(GeneralValidations.invalid((MessageKey)BankingKeys.Transfers.ERROR_MATURITY_POLICY_VIOLATION, (Object[])new Object[0]));
                } else if (((MaturityTableWinnerData)object).maxAmount != null) {
                    property.lessEquals((Comparable)new CurrencyAmount(paymentTransferType.getCurrency(), ((MaturityTableWinnerData)object).maxAmount));
                }
            }
        }
    }

    private List<PaymentTransferType> authorizablePaymentTypes() {
        SessionData sessionData = this.getSessionData();
        if (!sessionData.isAdmin()) {
            return null;
        }
        ProductsAccessor productsAccessor = sessionData.getProducts();
        List list = sessionData.getProducts().grantedAccountTypes();
        Set set = productsAccessor.admin().getAuthorizationRoles().keysSet((Path)QAdminProductAuthorizationRole.adminProductAuthorizationRole.view);
        return CollectionHelper.sort((Collection)set.stream().flatMap(authorizationRole -> authorizationRole.getLevels().stream()).map(AuthorizationLevel::getTransferType).filter(paymentTransferType -> list.contains(paymentTransferType.getFrom())).collect(Collectors.toSet()));
    }

    private void checkOwnedQuery(OwnedTransactionQuery ownedTransactionQuery) {
        InternalAccountOwner internalAccountOwner = this.accountHandler.locateOrCurrent((AccountOwner)ownedTransactionQuery.getOwner(), true).getInternalAccountOwner();
        if (internalAccountOwner == null) {
            throw new IllegalArgumentException("Account owner is required for the query");
        }
    }

    private Page<MaturityTableItemData> convertMaturityTableToPage(List<MaturityTableItemData> list, MaturityTableQuery maturityTableQuery) {
        int n = maturityTableQuery.getCurrentPage() == null || maturityTableQuery.getCurrentPage() < 0 ? 0 : maturityTableQuery.getCurrentPage();
        int n2 = maturityTableQuery.getPageSize() == null || maturityTableQuery.getPageSize() < 0 ? 40 : maturityTableQuery.getPageSize();
        return CollectionHelper.asPage(list, (int)n2, (int)n);
    }

    private void fill(IInstallmentSearchData iInstallmentSearchData, InternalAccountOwner internalAccountOwner, ExportFormatContext exportFormatContext, TransSearchContext transSearchContext) {
        SessionData sessionData = this.getSessionData();
        List list = internalAccountOwner == null ? sessionData.getProducts().grantedAccountTypes() : this.accountService.listVisibleTypes(internalAccountOwner);
        iInstallmentSearchData.setAccountTypes(this.conversionHandler.convertList(AccountTypeWithCurrencyVO.class, (Iterable)list));
        iInstallmentSearchData.setArchivingDate(this.conversionHandler.toDateTime(this.applicationHandler.getApplication().getArchivingDate()));
        if (sessionData.isAdmin() || sessionData.isSystem()) {
            iInstallmentSearchData.setManagedGroups(this.groupsHandler.accessibles().basicUsers().sorted());
        }
        Set set = this.transactionServiceSecurity.getVisibleNatures(internalAccountOwner);
        set.removeIf(transactionNature -> !transactionNature.hasInstallments());
        iInstallmentSearchData.setVisibleNatures(set);
        iInstallmentSearchData.setExportFormats(this.conversionHandler.convertList(ExportFormatVO.class, (Iterable)this.exportFormatService.listByContext(exportFormatContext)));
        List list2 = this.transactionCustomFieldService.listVisible((AccountOwner)internalAccountOwner);
        iInstallmentSearchData.setFieldsForList(this.conversionHandler.convertList(CustomFieldDetailedVO.class, (Iterable)list2.stream().filter(transactionCustomField -> transactionCustomField.getContextsToShowInList().contains(transSearchContext)).collect(Collectors.toList())));
        iInstallmentSearchData.setFieldsForSearch(this.conversionHandler.convertList(CustomFieldDetailedVO.class, (Iterable)list2.stream().filter(transactionCustomField -> transactionCustomField.getContextsToShowInSearch().contains(transSearchContext)).collect(Collectors.toList())));
    }

    private void fill(ITransactionSearchData iTransactionSearchData, InternalAccountOwner internalAccountOwner) {
        iTransactionSearchData.setVisibleNatures(this.transactionServiceSecurity.getVisibleNatures(internalAccountOwner));
    }

    private List<PaymentTransferType> fill(PerformPaymentToOwnerData performPaymentToOwnerData, LocateAccountOwnerResult locateAccountOwnerResult, LocateAccountOwnerResult locateAccountOwnerResult2, PaymentTransferType paymentTransferType) {
        performPaymentToOwnerData.setTo(locateAccountOwnerResult2.getInternalVO());
        List<PaymentTransferType> list = this.listPaymentTypes(locateAccountOwnerResult, locateAccountOwnerResult2, null, false);
        if (paymentTransferType != null && !list.contains(paymentTransferType)) {
            this.throwInvalidTransferType();
        }
        List list2 = this.conversionHandler.convertList(TransferTypeWithCurrencyVO.class, list);
        performPaymentToOwnerData.setPaymentTypes(list2);
        if (paymentTransferType == null) {
            paymentTransferType = (PaymentTransferType)CollectionHelper.first(list);
        }
        if (paymentTransferType != null) {
            performPaymentToOwnerData.setPaymentTypeData(this.getPaymentTypeData(locateAccountOwnerResult, locateAccountOwnerResult2, new TransferTypeVO(paymentTransferType.getId())));
        }
        return list;
    }

    private PerformPaymentTypeData getPaymentTypeData(LocateAccountOwnerResult locateAccountOwnerResult, LocateAccountOwnerResult locateAccountOwnerResult2, TransferTypeVO transferTypeVO) {
        RatesData ratesData;
        AccountType accountType;
        PerformPaymentTypeData performPaymentTypeData = new PerformPaymentTypeData();
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)transferTypeVO);
        PaymentTransferType paymentTransferType2 = this.fill((AbstractPaymentTypeData)performPaymentTypeData, locateAccountOwnerResult, locateAccountOwnerResult2, paymentTransferType);
        if (paymentTransferType2 == null) {
            return null;
        }
        boolean bl = this.dRateHandler.isEnabled(paymentTransferType2.getCurrency(), null);
        MaturityPolicy maturityPolicy = null;
        if (bl) {
            maturityPolicy = paymentTransferType2.getMaturityPolicy();
        }
        if ((maturityPolicy == MaturityPolicy.HISTORY || maturityPolicy == MaturityPolicy.ZERO) && (accountType = (Account)this.invokerHandler.runAs(SessionDataFactory.system(), () -> locateAccountOwnerResult.getAccount(paymentTransferType2.getFrom()))) != null) {
            ratesData = this.rateHandler.getRates((Account)accountType, RateVisibility.PARAM_NO_UNLIMITED);
            performPaymentTypeData.setARate(ratesData.getARate());
            performPaymentTypeData.setDRate(ratesData.getDRate());
        }
        if (paymentTransferType2.isRequiresAuthorization() && (accountType = paymentTransferType2.getFrom()) instanceof SystemAccountType && ((SystemAccountType)accountType).getLimitType() == AccountTypeLimitType.LIMITED) {
            performPaymentTypeData.setLimitedAwaitingAuthorization(true);
        }
        if (bl && this.dRateHandler.isVisibleToUser(paymentTransferType2.getCurrency(), null) && paymentTransferType2.getdRateCreationValue() != null) {
            performPaymentTypeData.setDRateCreationValue(paymentTransferType2.getdRateCreationValue().getCreationValue());
        }
        performPaymentTypeData.setMaturityPolicy(maturityPolicy);
        if (maturityPolicy == MaturityPolicy.HISTORY || maturityPolicy == MaturityPolicy.ZERO) {
            accountType = locateAccountOwnerResult.getAccount();
            if (accountType == null) {
                accountType = this.accountService.load(locateAccountOwnerResult.getInternalAccountOwner(), paymentTransferType2.getFrom());
            }
            if (BigDecimalHelper.isNegativeOrZero((BigDecimal)this.accountService.getBalance((Account)accountType, null))) {
                performPaymentTypeData.setNoNegativesMaturityPolicy(true);
            }
            if (maturityPolicy == MaturityPolicy.HISTORY && locateAccountOwnerResult.isUser() && this.getSessionData().manages((BasicUser)locateAccountOwnerResult.getUser()) && BigDecimalHelper.isPositive((BigDecimal)(ratesData = this.rateHandler.getRates((Account)accountType, RateVisibility.ALL)).getDRate())) {
                MaturityTableWinnerData maturityTableWinnerData = this.getWinnerFromMaturityTable(locateAccountOwnerResult.getInternalAccountOwner(), paymentTransferType2);
                performPaymentTypeData.setMaturityTableWinnerId(maturityTableWinnerData.winnerTransferId);
                CurrencyVO currencyVO = (CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)paymentTransferType2.getCurrency());
                performPaymentTypeData.setMaxAmountByMaturityPolicy(ModelHelper.currencyAmount((CurrencyVO)currencyVO, (BigDecimal)maturityTableWinnerData.maxAmount));
            }
        }
        return performPaymentTypeData;
    }

    private PerformPaymentTypeData getReceivePaymentTypeData(LocateAccountOwnerResult locateAccountOwnerResult, TransferTypeVO transferTypeVO) {
        return this.getPaymentTypeData(locateAccountOwnerResult, this.accountHandler.locateOrCurrent(null), transferTypeVO);
    }

    private List<AuthorizationRoleVO> getVisibleAuthorizationRoles() {
        return this.getSessionData().getProducts().admin().getAuthorizationRoles().keysSet((Path)QAdminProductAuthorizationRole.adminProductAuthorizationRole.view).stream().sorted().map(this.conversionHandler.convertingFunction(AuthorizationRoleVO.class, new Object[0])).collect(Collectors.toList());
    }

    private MaturityTableWinnerData getWinnerFromMaturityTable(InternalAccountOwner internalAccountOwner, PaymentTransferType paymentTransferType) {
        MaturityTableQuery maturityTableQuery = new MaturityTableQuery();
        maturityTableQuery.setOwner(internalAccountOwner);
        maturityTableQuery.setTransferType((TransferTypeVO)this.conversionHandler.convert(TransferTypeVO.class, (Object)paymentTransferType));
        maturityTableQuery.setUnlimited();
        Page<MaturityTableItemData> page = this.getMaturityTable(maturityTableQuery);
        BigDecimal bigDecimal = null;
        Long l = null;
        for (MaturityTableItemData maturityTableItemData : page) {
            if (maturityTableItemData.getWinningTransfer() == null) continue;
            bigDecimal = maturityTableItemData.getMaxAmount();
            l = maturityTableItemData.getWinningTransfer();
            break;
        }
        MaturityTableWinnerData maturityTableWinnerData = new MaturityTableWinnerData();
        if (l == null) {
            bigDecimal = BigDecimal.ZERO;
        } else {
            maturityTableWinnerData.winnerTransferId = l;
        }
        maturityTableWinnerData.maxAmount = bigDecimal;
        return maturityTableWinnerData;
    }

    private boolean isTrusted(SessionData sessionData) {
        return sessionData.isTrusted() || this.passwordHandler.wasConfirmedWithDevice();
    }

    private PaymentLimitDescriptor limitsOf(PaymentTransferType paymentTransferType, SessionData sessionData, Account account) {
        return new PaymentLimitDescriptor(paymentTransferType, this.isTrusted(sessionData), account instanceof UserAccount ? (UserAccount)account : null);
    }

    private Pair<BigDecimal, Integer> paymentsAndInstallments(Account account, BasicUser basicUser, TransferType transferType, Date date, TimeInterval timeInterval) {
        TimeZone timeZone = this.configurationHandler.getAccessor((IAccount)account).getTimeZone();
        DatePeriod datePeriod = DatePeriod.periodIncluding((ITimeInterval)timeInterval, (TimeZone)timeZone, (Date)date);
        return this.paymentsAndInstallments(account, basicUser, transferType, datePeriod);
    }

    private Pair<BigDecimal, Integer> paymentsAndInstallments(Account account, BasicUser basicUser, TransferType transferType, DatePeriod datePeriod) {
        if (account.isTransient()) {
            return Pair.create((Object)BigDecimal.ZERO, (Object)0);
        }
        QTransaction qTransaction = QTransaction.transaction1;
        QChargebackTransfer qChargebackTransfer = QChargebackTransfer.chargebackTransfer;
        DBQuery dBQuery = this.entityManagerHandler.subQuery(new EntityPath[]{qChargebackTransfer});
        dBQuery.where((Predicate)qChargebackTransfer.chargebackOf().transaction().eq((Expression)qTransaction));
        Tuple tuple = ((DBQuery)this.from(new EntityPath[]{qTransaction}).where(new Predicate[]{qTransaction.from().eq((Object)account), basicUser == null ? qTransaction.id.isNotNull() : qTransaction.by().eq((Object)basicUser), qTransaction.instanceOfAny(new Class[]{ExternalPayment.class, Payment.class}), qTransaction.type().eq((Object)transferType), qTransaction.status.isNull().or((Predicate)qTransaction.status.in((Object[])new String[]{ExternalPaymentStatus.PENDING.name(), ExternalPaymentStatus.PROCESSED.name()})), qTransaction.authorizationStatus.in((Object[])new TransactionAuthorizationStatus[]{TransactionAuthorizationStatus.AUTHORIZED, TransactionAuthorizationStatus.NA, TransactionAuthorizationStatus.PENDING_AUTHORIZATION}), qTransaction.date.period(datePeriod), dBQuery.notExists()})).singleResult(new Expression[]{qTransaction.amount.sum(), qTransaction.count()});
        BigDecimal bigDecimal = BigDecimalHelper.zeroWhenNull((BigDecimal)((BigDecimal)tuple.get((Expression)qTransaction.amount.sum())));
        Integer n = (int)(tuple.get((Expression)qTransaction.count()) == null ? 0L : (Long)tuple.get((Expression)qTransaction.count()));
        QInstallment qInstallment = QInstallment.installment;
        QInstallmentTransfer qInstallmentTransfer = QInstallmentTransfer.installmentTransfer;
        Tuple tuple2 = ((DBQuery)((DBQuery)this.from(new EntityPath[]{qInstallment}).leftJoin((CollectionExpression)qInstallment.transfers, (Path)qInstallmentTransfer)).where(new Predicate[]{qInstallment.transaction().from().eq((Object)account), qInstallment.transaction().type().eq((Object)transferType), basicUser == null ? qInstallment.id.isNotNull() : qInstallment.transaction().by().eq((Object)basicUser), qInstallment.status.in((Object[])new InstallmentStatus[]{InstallmentStatus.PROCESSED, InstallmentStatus.SCHEDULED}).or((Predicate)qInstallment.transaction().authorizationStatus.eq((Object)TransactionAuthorizationStatus.PENDING_AUTHORIZATION)), qInstallmentTransfer.id.isNull().and(qInstallment.dueDate.period(datePeriod)).or((Predicate)qInstallmentTransfer.id.isNotNull().and(qInstallmentTransfer.date.period(datePeriod)))})).singleResult(new Expression[]{qInstallment.amount.sum(), qInstallment.count()});
        bigDecimal = bigDecimal.add(BigDecimalHelper.zeroWhenNull((BigDecimal)((BigDecimal)tuple2.get((Expression)qInstallment.amount.sum()))));
        n = (int)((long)n.intValue() + (tuple2.get((Expression)qInstallment.count()) == null ? 0L : (Long)tuple2.get((Expression)qInstallment.count())));
        return new Pair((Object)bigDecimal, (Object)n);
    }

    private PaymentTransferType resolvePaymentType(PrepareValidationParameter prepareValidationParameter) {
        SessionData sessionData;
        Channel channel = null;
        PrincipalType principalType = null;
        if (prepareValidationParameter.getChannel() != null) {
            channel = prepareValidationParameter.getChannel();
        } else if (!prepareValidationParameter.isIgnoreChannelForPaymentType()) {
            sessionData = this.getSessionData();
            channel = sessionData.getChannel();
            principalType = sessionData.getPrincipalType();
        }
        sessionData = prepareValidationParameter.getFrom().getInternalAccountOwner();
        AccountOwner accountOwner = prepareValidationParameter.getTo().getAccountOwner();
        Currency currency = (Currency)this.conversionHandler.convert(Currency.class, (Object)prepareValidationParameter.getCurrency());
        return this.resolvePaymentType((InternalAccountOwner)sessionData, accountOwner, currency, channel, principalType, prepareValidationParameter.getCreationType());
    }

    private <T> T runAsUserToReceivePayment(LocateAccountOwnerResult locateAccountOwnerResult, Callable<T> callable) {
        SessionData sessionData = this.sessionAsUserToReceivePayment(locateAccountOwnerResult);
        try {
            return (T)this.invokerHandler.runAs(sessionData, callable);
        }
        catch (Exception exception) {
            ExceptionHelper.throwWithType((Throwable)exception, CyclosException.class);
            return null;
        }
    }

    private SessionData sessionAsUserToReceivePayment(LocateAccountOwnerResult locateAccountOwnerResult) {
        LocateUserResult locateUserResult = locateAccountOwnerResult.getLocateUserResult();
        return SessionDataFactory.direct((UserPrincipal)locateUserResult).channel(BuiltInChannel.POS).accessChannel(BuiltInChannel.POS).honorUrgentSituation(UrgentSituation.PENDING_AGREEMENT).build();
    }

    private void throwInvalidTransferType() {
        String string = this.message(BankingKeys.Transactions.TYPE, new Object[0]);
        String string2 = this.message(GeneralKeys.Errors.INVALID, string);
        throw new ValidationException(PerformPaymentDTO.TYPE.getName(), string2);
    }

    private void validateStatus(LocateAccountOwnerResult locateAccountOwnerResult) {
        if (!(!locateAccountOwnerResult.isOperator() || AccountServiceLocal.POSSIBLE_STATUSES_TO_OWN_ACCOUNTS.contains(locateAccountOwnerResult.getBasicUser().getStatus()) && AccountServiceLocal.POSSIBLE_STATUSES_TO_OWN_ACCOUNTS.contains(locateAccountOwnerResult.getUser().getStatus()))) {
            throw new EntityNotFoundException(User.class);
        }
        if (locateAccountOwnerResult.isUser() && !AccountServiceLocal.POSSIBLE_STATUSES_TO_OWN_ACCOUNTS.contains(locateAccountOwnerResult.getUser().getStatus())) {
            throw new EntityNotFoundException(User.class);
        }
    }

    private /* synthetic */ boolean lambda$getPaymentData$4(Operator operator, User user) {
        return this.authHandler.relatesTo((BasicUser)operator, (BasicUser)user);
    }

    private /* synthetic */ void lambda$fill$2(PaymentTransferType paymentTransferType, Transaction transaction, Collection collection) {
        Set set = paymentTransferType.getCustomFields();
        List list = this.getSessionData().getProducts().product().getVisibleTransactionFields();
        this.customFieldValueHandler.setCustomValues((SimpleEntity)transaction, (Collection)set, (Collection)list, collection);
    }

    private class PaymentLimitDescriptor {
        PaymentTransferType type;
        boolean trusted;
        UserAccount userAccount;
        MemberProductAccessor accessor;

        PaymentLimitDescriptor(PaymentTransferType paymentTransferType, boolean bl, UserAccount userAccount) {
            this.type = paymentTransferType;
            this.trusted = bl;
            this.userAccount = userAccount;
        }

        private MemberProductAccessor getAccessor() {
            if (this.accessor == null) {
                this.accessor = TransactionServiceImpl.this.productsHandler.getAccessor((BasicUser)this.userAccount.getUser()).member(this.userAccount.getType());
            }
            return this.accessor;
        }

        private BigDecimal getPaymentLimit(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3) {
            BigDecimal bigDecimal4 = this.getTransferTypeAmountLimit(bigDecimal, bigDecimal2);
            return bigDecimal4 == null ? bigDecimal3 : BigDecimalHelper.min((BigDecimal)((BigDecimal)ObjectHelper.defaultValue((Object)bigDecimal3, (Object)bigDecimal4)), (BigDecimal)bigDecimal4);
        }

        private BigDecimal getTransferTypeAmountLimit(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
            return this.trusted ? (BigDecimal)ObjectHelper.coalesce((Object[])new BigDecimal[]{bigDecimal2, bigDecimal}) : bigDecimal;
        }

        private Integer getTransferTypeCountLimit(Integer n, Integer n2) {
            return this.trusted ? (Integer)ObjectHelper.coalesce((Object[])new Integer[]{n2, n}) : n;
        }

        BigDecimal maxAmount() {
            BigDecimal bigDecimal = null;
            if (this.userAccount != null) {
                bigDecimal = (BigDecimal)ObjectHelper.coalesce((Object[])new BigDecimal[]{this.userAccount.getPaymentAmountLimit(), this.getAccessor().getDefaultPaymentAmountLimit()});
            }
            return this.getPaymentLimit(this.type.getMaxAmount(), this.type.getMaxAmountTrustedDevices(), bigDecimal);
        }

        BigDecimal maxAmountPerDay() {
            BigDecimal bigDecimal = null;
            if (this.userAccount != null) {
                bigDecimal = (BigDecimal)ObjectHelper.coalesce((Object[])new BigDecimal[]{this.userAccount.getPaymentAmountPerDayLimit(), this.getAccessor().getDefaultPaymentAmountPerDayLimit()});
            }
            return this.getPaymentLimit(this.type.getMaxAmountPerDay(), this.type.getMaxAmountPerDayTrustedDevices(), bigDecimal);
        }

        BigDecimal maxAmountPerDayPinless() {
            return this.getTransferTypeAmountLimit(this.type.getMaxAmountPerDayPinless(), this.type.getMaxAmountPerDayPinlessTrustedDevices());
        }

        BigDecimal maxAmountPerMonth() {
            BigDecimal bigDecimal = null;
            if (this.userAccount != null) {
                bigDecimal = (BigDecimal)ObjectHelper.coalesce((Object[])new BigDecimal[]{this.userAccount.getPaymentAmountPerMonthLimit(), this.getAccessor().getDefaultPaymentAmountPerMonthLimit()});
            }
            return this.getPaymentLimit(this.type.getMaxAmountPerMonth(), this.type.getMaxAmountPerMonthTrustedDevices(), bigDecimal);
        }

        BigDecimal maxAmountPerWeek() {
            BigDecimal bigDecimal = null;
            if (this.userAccount != null) {
                bigDecimal = (BigDecimal)ObjectHelper.coalesce((Object[])new BigDecimal[]{this.userAccount.getPaymentAmountPerWeekLimit(), this.getAccessor().getDefaultPaymentAmountPerWeekLimit()});
            }
            return this.getPaymentLimit(this.type.getMaxAmountPerWeek(), this.type.getMaxAmountPerWeekTrustedDevices(), bigDecimal);
        }

        BigDecimal maxAmountPerYear() {
            BigDecimal bigDecimal = null;
            if (this.userAccount != null) {
                bigDecimal = (BigDecimal)ObjectHelper.coalesce((Object[])new BigDecimal[]{this.userAccount.getPaymentAmountPerYearLimit(), this.getAccessor().getDefaultPaymentAmountPerYearLimit()});
            }
            return this.getPaymentLimit(this.type.getMaxAmountPerYear(), this.type.getMaxAmountPerYearTrustedDevices(), bigDecimal);
        }

        BigDecimal maxAmountPinless() {
            return this.getTransferTypeAmountLimit(this.type.getMaxAmountPinless(), this.type.getMaxAmountPinlessTrustedDevices());
        }

        Integer maxTransfersPerDay() {
            return this.getTransferTypeCountLimit(this.type.getMaxTransfersPerDay(), this.type.getMaxTransfersPerDayTrustedDevices());
        }

        Integer maxTransfersPerMonth() {
            return this.getTransferTypeCountLimit(this.type.getMaxTransfersPerMonth(), this.type.getMaxTransfersPerMonthTrustedDevices());
        }

        Integer maxTransfersPerWeek() {
            return this.getTransferTypeCountLimit(this.type.getMaxTransfersPerWeek(), this.type.getMaxTransfersPerWeekTrustedDevices());
        }
    }

    private class MaturityTableWinnerData {
        private BigDecimal maxAmount;
        private Long winnerTransferId;

        private MaturityTableWinnerData() {
        }
    }
}

