/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.AccountFeeTransfer;
import org.cyclos.entities.banking.ChargebackTransfer;
import org.cyclos.entities.banking.InstallmentTransfer;
import org.cyclos.entities.banking.QTransferType;
import org.cyclos.entities.banking.Trans;
import org.cyclos.entities.banking.Transaction;
import org.cyclos.entities.banking.Transfer;
import org.cyclos.entities.banking.TransferFeeTransfer;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.banking.ARateTypeHandler;
import org.cyclos.impl.banking.DRateTypeHandler;
import org.cyclos.impl.contentmanagement.DataTranslationHandler;
import org.cyclos.impl.utils.conversion.EntityVOConverter;
import org.cyclos.model.banking.transfers.AccountFeeTransferVO;
import org.cyclos.model.banking.transfers.ChargebackTransferVO;
import org.cyclos.model.banking.transfers.InstallmentTransferVO;
import org.cyclos.model.banking.transfers.TransferDetailedVO;
import org.cyclos.model.banking.transfers.TransferFeeTransferVO;
import org.cyclos.security.banking.TransferServiceSecurity;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ObjectHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TransferDetailedVOConverter
extends EntityVOConverter<TransferDetailedVO> {
    @Autowired
    private TransferServiceSecurity transferServiceSecurity;
    @Autowired
    private DRateTypeHandler dRateHandler;
    @Autowired
    private ARateTypeHandler aRateHandler;
    @Autowired
    private DataTranslationHandler dataTranslationHandler;

    public TransferDetailedVOConverter() {
        super(TransferDetailedVO.class);
        this.registerMapping(InstallmentTransfer.class, InstallmentTransferVO.class);
        this.registerMapping(ChargebackTransfer.class, ChargebackTransferVO.class);
        this.registerMapping(AccountFeeTransfer.class, AccountFeeTransferVO.class);
        this.registerMapping(TransferFeeTransfer.class, TransferFeeTransferVO.class);
    }

    @Override
    protected void fill(Object object, TransferDetailedVO transferDetailedVO, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        Set set = CollectionHelper.asSet((Object[])objectArray);
        set.add(TransferDetailedVO.PARENT);
        set.add(TransferDetailedVO.CHILDREN);
        if (!conversionContext.getSessionData().isAdmin()) {
            set.add(AccountFeeTransferVO.ACCOUNT_FEE);
            set.add(TransferFeeTransferVO.TRANSFER_FEE);
        }
        super.fill(object, transferDetailedVO, set.toArray(), conversionContext);
        if (object instanceof Transfer) {
            Object object2;
            boolean bl;
            Transfer transfer = (Transfer)object;
            transferDetailedVO.setDisplay(this.getFormatter().format((Trans)transfer));
            Date date = transfer.getDate();
            Transaction transaction = transfer.getTransaction();
            transferDetailedVO.setDescription((String)ObjectHelper.defaultValue((Object)(transaction == null ? null : transaction.getDescription()), (Object)this.dataTranslationHandler.getValue((BaseEntity)transfer.getType(), QTransferType.transferType.valueForEmptyDescription)));
            boolean bl2 = this.dRateHandler.isVisibleToUser(transfer.getCurrency(), date);
            if (bl2) {
                transferDetailedVO.setDRate(this.dRateHandler.convert((Object)transfer.getExpirationDate(), date));
            }
            if (bl = this.aRateHandler.isVisibleToUser(transfer.getCurrency(), date)) {
                transferDetailedVO.setARate(this.aRateHandler.convert((Object)transfer.getEmissionDate(), date));
            }
            if (!PropertyHelper.contains((Object)TransferDetailedVO.PARENT, (Object[])objectArray) && (object2 = transfer.getParent()) != null && this.transferServiceSecurity.isVisible((Trans)object2)) {
                transferDetailedVO.setParent((TransferDetailedVO)this.conversionHandler.convertExcluding(TransferDetailedVO.class, object2, new Object[]{TransferDetailedVO.PARENT, TransferDetailedVO.CHILDREN}));
            }
            if (!PropertyHelper.contains((Object)TransferDetailedVO.CHILDREN, (Object[])objectArray)) {
                object2 = new ArrayList(transfer.getChildren());
                object2.sort(Comparator.comparing(Transfer::getDate).thenComparing(SimpleEntity::getId));
                ArrayList<TransferDetailedVO> arrayList = new ArrayList<TransferDetailedVO>(CollectionHelper.size((Collection)object2));
                if (object2 != null) {
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        Transfer transfer2 = (Transfer)iterator.next();
                        if (!this.transferServiceSecurity.isVisible((Trans)transfer2)) continue;
                        arrayList.add((TransferDetailedVO)this.conversionHandler.convertExcluding(TransferDetailedVO.class, transfer2, new Object[]{TransferDetailedVO.PARENT, TransferDetailedVO.CHILDREN}));
                    }
                }
                transferDetailedVO.setChildren(arrayList);
            }
        }
    }
}

