/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import org.cyclos.entities.banking.TransferFee;
import org.cyclos.impl.EntityLogDescriptor;
import org.cyclos.impl.system.BaseEntityLogHandlerImpl;
import org.cyclos.impl.utils.validation.BeanPropertyAccess;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.model.NestedProperty;
import org.cyclos.model.Property;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.transferfees.TransferFeeChargeMode;
import org.cyclos.model.banking.transferfees.TransferFeeDTO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.cyclos.model.utils.DecimalRangeDTO;
import org.cyclos.utils.BigDecimalHelper;
import org.springframework.stereotype.Component;

@Component
public class TransferFeeEntityLogHandlerImpl
extends BaseEntityLogHandlerImpl<TransferFee, TransferFeeDTO> {
    public Class<TransferFee> getEntityClass() {
        return TransferFee.class;
    }

    public EntityLogType getType() {
        return EntityLogType.TRANSFER_FEE;
    }

    public EntityLogDescriptor<TransferFeeDTO> resolveLogDescriptor(TransferFee transferFee) {
        return new EntityLogDescriptor(TransferFeeDTO.class).property(TransferFeeDTO.NAME, GeneralKeys.Ui.NAME).property(TransferFeeDTO.INTERNAL_NAME, GeneralKeys.Ui.INTERNAL_NAME).property(TransferFeeDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION).property((Property)TransferFeeDTO.ENABLED, BankingKeys.TransferFees.ENABLED).property((Property)TransferFeeDTO.CONFIGURATION_MODE, BankingKeys.TransferFees.CONFIGURATION_MODE).property((Property)TransferFeeDTO.OTHER_CURRENCY, BankingKeys.TransferFees.OTHER_CURRENCY).property((Property)TransferFeeDTO.PAYER, BankingKeys.TransferFees.PAYER).property((Property)TransferFeeDTO.PAYER_USER, BankingKeys.TransferFees.PAYER_USER).property((Property)TransferFeeDTO.RECEIVER, BankingKeys.TransferFees.RECEIVER).property((Property)TransferFeeDTO.RECEIVER_USER, BankingKeys.TransferFees.RECEIVER_USER).property((Property)TransferFeeDTO.GENERATED_TRANSFER_TYPE, BankingKeys.TransferFees.GENERATED_TRANSFER_TYPE).property((Property)TransferFeeDTO.CHARGE_MODE, BankingKeys.TransferFees.CHARGE_MODE).property(this.toAmountAccess((Property<?, TransferFeeDTO>)TransferFeeDTO.AMOUNT), BankingKeys.TransferFees.AMOUNT).property((Property)TransferFeeDTO.CUSTOM_SCRIPT, BankingKeys.TransferFees.CUSTOM_SCRIPT).property((Property)TransferFeeDTO.CUSTOM_SCRIPT_PARAMETERS, BankingKeys.TransferFees.CUSTOM_SCRIPT_PARAMETERS).property((Property)TransferFeeDTO.DEDUCT_AMOUNT, BankingKeys.TransferFees.DEDUCT_AMOUNT).property((Property)NestedProperty.nested((Property)TransferFeeDTO.AMOUNT_RANGE, (Property)DecimalRangeDTO.MIN), BankingKeys.TransferFees.HIGHER_THAN_AMOUNT_VALUE).property((Property)NestedProperty.nested((Property)TransferFeeDTO.AMOUNT_RANGE, (Property)DecimalRangeDTO.MAX), BankingKeys.TransferFees.LOWER_THAN_AMOUNT_VALUE).property((Property)TransferFeeDTO.FROM_GROUPS, BankingKeys.TransferFees.FROM_GROUPS).property((Property)TransferFeeDTO.TO_GROUPS, BankingKeys.TransferFees.TO_GROUPS).ignore((Property)TransferFeeDTO.ORIGINAL_TRANSFER_TYPE).ignore((Property)TransferFeeDTO.AMOUNT_RANGE);
    }

    @Override
    protected TransferFee getEntityToViewLog(long l) {
        return this.hasPermission(Permission.ACCOUNT_CONFIGURATION_VIEW) ? this.find(TransferFee.class, l) : null;
    }

    private PropertyAccess toAmountAccess(Property<?, TransferFeeDTO> property) {
        return new BeanPropertyAccess(property){

            public Object get(Object object) {
                TransferFee transferFee = (TransferFee)object;
                if (transferFee.getAmount() == null) {
                    return null;
                }
                TransferFeeChargeMode transferFeeChargeMode = transferFee.getChargeMode();
                if (transferFeeChargeMode == TransferFeeChargeMode.PERCENTAGE) {
                    return TransferFeeEntityLogHandlerImpl.this.getFormatter().format(transferFee.getAmount(), BigDecimalHelper.MAX_SCALE);
                }
                if (transferFeeChargeMode == TransferFeeChargeMode.FIXED) {
                    return TransferFeeEntityLogHandlerImpl.this.getFormatter().format(transferFee.getAmount(), transferFee.getCurrency().getPrecision());
                }
                return super.get(object);
            }
        };
    }
}

