/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.QChargebackTransfer;
import org.cyclos.entities.banking.QTransaction;
import org.cyclos.entities.banking.QTransactionCustomFieldValue;
import org.cyclos.entities.banking.QTransfer;
import org.cyclos.entities.banking.QTransferStatus;
import org.cyclos.entities.banking.QTransferTransferStatusFlow;
import org.cyclos.entities.banking.QVoucher;
import org.cyclos.entities.banking.QVoucherPack;
import org.cyclos.entities.banking.QVoucherTransaction;
import org.cyclos.entities.banking.TransferStatus;
import org.cyclos.entities.banking.TransferStatusFlow;
import org.cyclos.entities.users.QUserImage;
import org.cyclos.impl.banking.BuildTransferQueryParams;
import org.cyclos.impl.banking.TransQueryHandlerImpl;
import org.cyclos.impl.banking.TransferQueryHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.model.banking.accounts.AccountHistoryQuery;
import org.cyclos.model.banking.accounts.BaseTransferQuery;
import org.cyclos.model.banking.accounts.TransferDirection;
import org.cyclos.model.banking.vouchers.VoucherCreationType;
import org.cyclos.utils.CollectionHelper;
import org.springframework.stereotype.Component;

@Component
public class TransferQueryHandlerImpl
extends TransQueryHandlerImpl<BaseTransferQuery, BuildTransferQueryParams>
implements TransferQueryHandler {
    private QTransfer t = QTransfer.transfer;
    private QChargebackTransfer cb = new QChargebackTransfer("cb");
    private QUserImage fui = new QUserImage("fui");
    private QUserImage tui = new QUserImage("tui");
    private QVoucherPack bvp = new QVoucherPack("bvp");
    private QVoucher sv = new QVoucher("sv");
    private QVoucherTransaction vt = new QVoucherTransaction("vt");
    private QVoucher vtv = new QVoucher("vtv");
    private QVoucherPack vtp = new QVoucherPack("vtp");

    public TransferQueryHandlerImpl() {
        this.tx = QTransaction.transaction1;
        this.id = this.t.id;
        this.transactionNumber = this.t.transactionNumber;
        this.date = this.t.date;
        this.amount = this.t.amount;
    }

    @Override
    public DBQuery<?> build(BuildTransferQueryParams buildTransferQueryParams) {
        DBQuery<?> dBQuery = super.build(buildTransferQueryParams);
        BaseTransferQuery baseTransferQuery = (BaseTransferQuery)buildTransferQueryParams.getParams();
        Set set = this.conversionHandler.convertSet(TransferStatus.class, (Iterable)baseTransferQuery.getStatuses());
        if (!set.isEmpty()) {
            QTransferTransferStatusFlow qTransferTransferStatusFlow = QTransferTransferStatusFlow.transferTransferStatusFlow;
            dBQuery.where((Predicate)((DBQuery)this.rawEntityManagerHandler.subQuery(new EntityPath[]{qTransferTransferStatusFlow}).where(new Predicate[]{qTransferTransferStatusFlow.transfer().eq((Expression)this.t), qTransferTransferStatusFlow.status().in((Collection)set)})).exists());
        }
        if (CollectionHelper.isNotEmpty((Iterable)baseTransferQuery.getNatures())) {
            dBQuery.where((Predicate)this.t.nature.in((Collection)baseTransferQuery.getNatures()));
        }
        if (baseTransferQuery.getChargedBack() != null) {
            if (baseTransferQuery.getChargedBack().booleanValue()) {
                dBQuery.where((Predicate)this.cb.id.isNotNull());
            } else {
                dBQuery.where((Predicate)this.cb.id.isNull());
            }
        }
        return dBQuery;
    }

    public QVoucherPack getBuyVoucherPackPath() {
        return this.bvp;
    }

    public QUserImage getFromUserImagePath() {
        return this.fui;
    }

    public QVoucher getSentVoucherPath() {
        return this.sv;
    }

    public QUserImage getToUserImagePath() {
        return this.tui;
    }

    public QTransfer getTransferPath() {
        return this.t;
    }

    public QVoucherPack getVoucherTransactionPackPath() {
        return this.vtp;
    }

    public QVoucherTransaction getVoucherTransactionPath() {
        return this.vt;
    }

    @Override
    protected void applyOwned(DBQuery<?> dBQuery, BuildTransferQueryParams buildTransferQueryParams) {
        BooleanExpression booleanExpression;
        AccountHistoryQuery accountHistoryQuery = (AccountHistoryQuery)buildTransferQueryParams.getParams();
        Account account = buildTransferQueryParams.getAccount();
        TransferDirection transferDirection = accountHistoryQuery.getDirection();
        BooleanExpression booleanExpression2 = account.isTransient() ? this.fa.id.isNull() : this.fa.eq((Object)account);
        BooleanExpression booleanExpression3 = booleanExpression = account.isTransient() ? this.ta.id.isNull() : this.ta.eq((Object)account);
        if (transferDirection == TransferDirection.DEBIT) {
            dBQuery.where((Predicate)booleanExpression2);
        } else if (transferDirection == TransferDirection.CREDIT) {
            dBQuery.where((Predicate)booleanExpression);
        } else {
            dBQuery.where((Predicate)booleanExpression2.or((Predicate)booleanExpression));
        }
    }

    @Override
    protected DBQuery<?> initQuery(BuildTransferQueryParams buildTransferQueryParams) {
        DBQuery dBQuery = (DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{this.t}).leftJoin((EntityPath)this.t.type(), (Path)this.tt)).leftJoin((EntityPath)this.t.from(), (Path)this.fa)).leftJoin((EntityPath)this.fa.type(), (Path)this.fat)).leftJoin((EntityPath)this.t.to(), (Path)this.ta)).leftJoin((EntityPath)this.ta.type(), (Path)this.tat)).leftJoin((EntityPath)this.t.transaction(), (Path)this.tx)).leftJoin((EntityPath)this.fat.currency(), (Path)this.c)).leftJoin((EntityPath)this.fa.user(), (Path)this.fu)).leftJoin((EntityPath)this.ta.user(), (Path)this.tu)).leftJoin((EntityPath)this.fu.group(), (Path)this.fg)).leftJoin((EntityPath)this.tu.group(), (Path)this.tg)).leftJoin((EntityPath)this.bvp)).on((Predicate)this.bvp.buy().eq((Expression)this.tx))).leftJoin((EntityPath)this.sv)).on((Predicate)this.bvp.creationType.eq((Object)VoucherCreationType.SENT).and((Predicate)this.sv.pack().eq((Expression)this.bvp)))).leftJoin((EntityPath)this.vt)).on((Predicate)this.vt.transactionId.eq((Expression)this.tx.id))).leftJoin((EntityPath)this.vtv)).on((Predicate)this.vt.voucher().eq((Expression)this.vtv))).leftJoin((EntityPath)this.vtp)).on((Predicate)this.vtv.pack().eq((Expression)this.vtp));
        if (((BaseTransferQuery)buildTransferQueryParams.getParams()).getChargedBack() != null) {
            dBQuery.leftJoin((EntityPath)this.t.chargedBackBy(), (Path)this.cb);
        }
        CollectionHelper.orEmpty((List)this.transactionCustomFieldService.listVisibleForList(buildTransferQueryParams.getParams())).forEach(transactionCustomField -> {
            QTransactionCustomFieldValue qTransactionCustomFieldValue = new QTransactionCustomFieldValue("fv_" + transactionCustomField.getId());
            ((DBQuery)dBQuery.leftJoin((EntityPath)qTransactionCustomFieldValue)).on(new Predicate[]{qTransactionCustomFieldValue.owner().eq((Expression)this.tx), qTransactionCustomFieldValue.field().eq(transactionCustomField)});
            buildTransferQueryParams.setCustomValuePath(transactionCustomField, qTransactionCustomFieldValue);
        });
        if (CollectionHelper.isNotEmpty((Iterable)buildTransferQueryParams.getStatusFlows())) {
            for (TransferStatusFlow transferStatusFlow : buildTransferQueryParams.getStatusFlows()) {
                QTransferTransferStatusFlow qTransferTransferStatusFlow = new QTransferTransferStatusFlow("tsf_" + transferStatusFlow.getId());
                QTransferStatus qTransferStatus = new QTransferStatus("s_" + transferStatusFlow.getId());
                ((DBQuery)dBQuery.leftJoin((EntityPath)qTransferTransferStatusFlow)).on(new Predicate[]{qTransferTransferStatusFlow.transfer().eq((Expression)this.t), qTransferTransferStatusFlow.flow().eq((Object)transferStatusFlow)});
                ((DBQuery)dBQuery.leftJoin((EntityPath)qTransferStatus)).on((Predicate)qTransferTransferStatusFlow.status().eq((Expression)qTransferStatus));
                buildTransferQueryParams.setStatusPath(transferStatusFlow, qTransferStatus);
            }
        }
        if (buildTransferQueryParams.isIncludeImage()) {
            ((DBQuery)dBQuery.leftJoin((EntityPath)this.fu.image(), (Path)this.fui)).leftJoin((EntityPath)this.tu.image(), (Path)this.tui);
        }
        return dBQuery;
    }
}

