/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.Expression;
import java.util.List;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.QVoucherCategory;
import org.cyclos.entities.banking.VoucherCategory;
import org.cyclos.entities.system.Image;
import org.cyclos.entities.system.TempImage;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.banking.VoucherCategoryImageServiceLocal;
import org.cyclos.impl.banking.VoucherCategoryServiceLocal;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.banking.vouchercategories.VoucherCategoryDTO;
import org.cyclos.model.banking.vouchercategories.VoucherCategoryData;
import org.cyclos.model.banking.vouchercategories.VoucherCategoryVO;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VoucherCategoryServiceImpl
extends CRUDServiceImpl<VoucherCategory, QVoucherCategory, VoucherCategoryDTO, VoucherCategoryData, Void>
implements VoucherCategoryServiceLocal {
    private static final Object[] EXCLUDED_PROPERTIES = new Object[]{VoucherCategoryDTO.IMAGE};
    @Autowired
    private StoredFileHandler storedFileHandler;
    @Autowired
    private VoucherCategoryImageServiceLocal voucherCategoryImageService;

    public VoucherCategoryServiceImpl() {
        super(VoucherCategory.class, QVoucherCategory.voucherCategory, VoucherCategoryDTO.class);
    }

    public List<VoucherCategoryVO> list() throws FrameworkException {
        return this.conversionHandler.convertList(VoucherCategoryVO.class, this.listAll());
    }

    public List<VoucherCategory> listAll() {
        return ((DBQuery)this.selectFrom(this.$).orderBy(((QVoucherCategory)this.$).order.asc())).fetch();
    }

    @Override
    public VoucherCategory newEntity(Void void_) {
        return new VoucherCategory();
    }

    @Override
    public VoucherCategory toEntity(VoucherCategoryDTO voucherCategoryDTO) {
        Image image;
        if (voucherCategoryDTO.getImage() == null && voucherCategoryDTO.isPersistent()) {
            this.voucherCategoryImageService.removeAll((BaseEntity)((VoucherCategory)this.find(voucherCategoryDTO.getId())));
        }
        VoucherCategory voucherCategory = (VoucherCategory)super.toEntity(voucherCategoryDTO);
        if (voucherCategoryDTO.getImage() != null && (image = (Image)this.conversionHandler.convert(Image.class, (Object)voucherCategoryDTO.getImage())) instanceof TempImage) {
            voucherCategory.setUploadedImage((TempImage)image);
        }
        return voucherCategory;
    }

    @Override
    protected VoucherCategoryData getData(VoucherCategory voucherCategory) {
        VoucherCategoryData voucherCategoryData = new VoucherCategoryData();
        voucherCategoryData.setDto((EntityDTO)((VoucherCategoryDTO)this.toDTO(voucherCategory)));
        return voucherCategoryData;
    }

    @Override
    protected Object[] getExcludedPropertiesToEntity(VoucherCategoryDTO voucherCategoryDTO) {
        return EXCLUDED_PROPERTIES;
    }

    @Override
    protected void onAfterSave(VoucherCategory voucherCategory, VoucherCategory voucherCategory2, Object object) {
        TempImage tempImage = voucherCategory.getUploadedImage();
        if (tempImage != null) {
            this.voucherCategoryImageService.importTempImage((BaseEntity)voucherCategory, tempImage);
        }
    }

    @Override
    protected void onBeforeRemove(VoucherCategory voucherCategory) {
        CollectionHelper.orEmpty((List)voucherCategory.getImages()).stream().map(SimpleEntity::getId).forEach(arg_0 -> ((StoredFileHandler)this.storedFileHandler).remove(arg_0));
    }

    @Override
    protected Object onBeforeSave(VoucherCategory voucherCategory, VoucherCategory voucherCategory2) {
        Integer n = (Integer)this.from().singleResult((Expression)((QVoucherCategory)this.$).order.max());
        voucherCategory.setOrder(Integer.valueOf(n != null ? n + 1 : 1));
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QVoucherCategory)this.$).network(), true);
    }

    @Override
    protected Validator resolveValidator(VoucherCategoryDTO voucherCategoryDTO) {
        return new Validator();
    }
}

