/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.banking;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;
import ognl.OgnlException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.cyclos.CyclosVersion;
import org.cyclos.entities.banking.QVoucherTemplate;
import org.cyclos.entities.banking.VoucherTemplate;
import org.cyclos.entities.banking.VoucherTemplateImage;
import org.cyclos.entities.banking.VoucherType;
import org.cyclos.entities.utils.StoredFile;
import org.cyclos.impl.ApplicationUpgradeInitializationListener;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.banking.VoucherTemplateImageServiceLocal;
import org.cyclos.impl.banking.VoucherTemplateServiceLocal;
import org.cyclos.impl.banking.VoucherTypeServiceLocal;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.system.PDFReportHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.CyclosException;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FileParsingException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.Property;
import org.cyclos.model.ValidationException;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.vouchertemplates.VoucherTemplateDTO;
import org.cyclos.model.banking.vouchertemplates.VoucherTemplateData;
import org.cyclos.model.banking.vouchertemplates.VoucherTemplateVO;
import org.cyclos.model.banking.vouchertypes.VoucherTypeVO;
import org.cyclos.model.contentmanagement.HasContentData;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.server.utils.FieldHelper;
import org.cyclos.server.utils.IOHelper;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.server.utils.ResourceHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.server.utils.ServerImageHelper;
import org.cyclos.server.utils.ZipHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ContentType;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.thymeleaf.exceptions.TemplateEngineException;

@Service
public class VoucherTemplateServiceImpl
extends CRUDServiceImpl<VoucherTemplate, QVoucherTemplate, VoucherTemplateDTO, VoucherTemplateData, VoucherTemplateVO>
implements VoucherTemplateServiceLocal,
ApplicationUpgradeInitializationListener {
    private static final String TEMPLATES_DIR = "/voucherTemplates";
    private static final String TEMPLATE = "template.html";
    private static final String STYLE = "style.css";
    private static final String METADATA = "metadata.json";
    private static final String IMAGES_DIR = "images";
    @Autowired
    private PDFReportHandler pdfReportHandler;
    @Autowired
    @Lazy
    private VoucherTypeServiceLocal voucherTypeService;
    @Autowired
    private VoucherTemplateImageServiceLocal voucherTemplateImageService;
    @Autowired
    private StoredFileHandler storedFileHandler;
    @Autowired
    private JsonConverter jsonConverter;
    @Autowired
    private CyclosProperties cyclosProperties;
    private Set<String> builtinTemplates;
    private Map<String, String> cachedTemplates = new HashMap<String, String>();

    public VoucherTemplateServiceImpl() {
        super(VoucherTemplate.class, QVoucherTemplate.voucherTemplate, VoucherTemplateDTO.class);
    }

    public FileInfo exportHTML(@NotNull VoucherTemplateDTO voucherTemplateDTO) throws FrameworkException {
        String string = this.readHTMLTemplate("voucher-template.html");
        String string2 = this.readHTMLTemplate("style.html");
        string = string.replace("/* CYCLOS_VERSION */", CyclosVersion.get());
        string = string.replace("/* GENERAL_STYLE */", string2);
        string = string.replace("/* TEMPLATE_STYLE */", voucherTemplateDTO.getStyle());
        string = string.replace("/* TEMPLATE_CONTENT */", voucherTemplateDTO.getContent());
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        FileInfo fileInfo = new FileInfo();
        fileInfo.setName((StringHelper.trim((Object)voucherTemplateDTO.getName()) + " preview.html").trim());
        fileInfo.setContentType(ContentType.HTML.getMimeType());
        fileInfo.setEncoding("UTF-8");
        fileInfo.setLength(Integer.valueOf(byArray.length));
        fileInfo.setContent(new SerializableInputStream(byArray));
        return fileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileInfo exportTemplate(@NotNull Long l) throws FrameworkException {
        ZipOutputStream zipOutputStream;
        VoucherTemplate voucherTemplate = (VoucherTemplate)this.find(l);
        File file = this.cyclosProperties.newTempFile("voucherTemplate", ".zip");
        VoucherTemplateMetadata voucherTemplateMetadata = (VoucherTemplateMetadata)this.conversionHandler.convert(VoucherTemplateMetadata.class, (Object)voucherTemplate);
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            try {
                zipOutputStream.putNextEntry(new ZipEntry(METADATA));
                this.jsonConverter.writeValue((OutputStream)zipOutputStream, (Object)voucherTemplateMetadata);
                zipOutputStream.closeEntry();
                zipOutputStream.putNextEntry(new ZipEntry(TEMPLATE));
                IOUtils.write((String)StringHelper.trim((Object)voucherTemplate.getContent()), (OutputStream)zipOutputStream, (Charset)StandardCharsets.UTF_8);
                zipOutputStream.closeEntry();
                zipOutputStream.putNextEntry(new ZipEntry(STYLE));
                IOUtils.write((String)StringHelper.trim((Object)voucherTemplate.getStyle()), (OutputStream)zipOutputStream, (Charset)StandardCharsets.UTF_8);
                zipOutputStream.closeEntry();
                for (VoucherTemplateImage voucherTemplateImage : voucherTemplate.getImages()) {
                    zipOutputStream.putNextEntry(new ZipEntry("images/" + voucherTemplateImage.getName()));
                    SerializableInputStream serializableInputStream = this.storedFileHandler.getContent((StoredFile)voucherTemplateImage);
                    try {
                        IOUtils.copy((InputStream)serializableInputStream, (OutputStream)zipOutputStream);
                    }
                    finally {
                        IOHelper.close((Closeable)serializableInputStream);
                        zipOutputStream.closeEntry();
                    }
                }
            }
            finally {
                zipOutputStream.close();
            }
        }
        catch (Exception exception) {
            file.delete();
            throw exception instanceof RuntimeException ? (RuntimeException)exception : new IllegalStateException(exception);
        }
        zipOutputStream = new FileInfo();
        zipOutputStream.setName(StringHelper.safeFilename((String)voucherTemplate.getName()) + ".cyclos.voucherTemplate");
        zipOutputStream.setContentType(ContentType.ZIP.getMimeType());
        zipOutputStream.setLength((int)file.length());
        zipOutputStream.setContent(new SerializableInputStream(file));
        return zipOutputStream;
    }

    public List<VoucherTemplate> importBuiltin() {
        ArrayList<VoucherTemplate> arrayList = new ArrayList<VoucherTemplate>();
        for (String string2 : this.builtinTemplates) {
            String string3 = "/voucherTemplates/" + StringHelper.removeStart((String)string2, (String)"/");
            VoucherTemplate voucherTemplate = (VoucherTemplate)((DBQuery)this.from().where((Predicate)((QVoucherTemplate)this.$).internalName.eq((Object)string2))).singleResult((Expression)this.$);
            List list = CollectionHelper.orEmpty((List)ResourceHelper.listResources((String)(string3 + "/images")));
            try {
                Map<String, InputStream> map = list.stream().collect(Collectors.toMap(ResourceHelper::getName, string -> {
                    try {
                        return ResourceHelper.openStream((String)string);
                    }
                    catch (IOException iOException) {
                        throw new UncheckedIOException(iOException);
                    }
                }));
                VoucherTemplate voucherTemplate2 = this.doImport(voucherTemplate, ResourceHelper.openStream((String)(string3 + "/metadata.json")), ResourceHelper.openStream((String)(string3 + "/template.html")), ResourceHelper.openStream((String)(string3 + "/style.css")), map);
                arrayList.add(voucherTemplate2);
            }
            catch (Exception exception) {
                throw new IllegalStateException("Error importing theme from " + string3, exception);
            }
        }
        return arrayList;
    }

    public Long importTemplate(SerializableInputStream serializableInputStream) throws FrameworkException, FileParsingException {
        File file = this.cyclosProperties.newTempDir();
        try {
            ZipHelper.extract((InputStream)serializableInputStream, (File)file, null);
            InputStream inputStream = this.toIn(new File(file, METADATA));
            InputStream inputStream2 = this.toIn(new File(file, TEMPLATE));
            InputStream inputStream3 = this.toIn(new File(file, STYLE));
            HashMap<String, InputStream> hashMap = new HashMap<String, InputStream>();
            File file2 = new File(file, IMAGES_DIR);
            if (file2.exists()) {
                for (File file3 : file2.listFiles()) {
                    hashMap.put(file3.getName(), this.toIn(file3));
                }
            }
            Long l = this.doImport(null, inputStream, inputStream2, inputStream3, hashMap).getId();
            return l;
        }
        catch (CyclosException cyclosException) {
            throw cyclosException;
        }
        catch (Exception exception) {
            throw new FileParsingException((Throwable)exception);
        }
        finally {
            if (file != null) {
                try {
                    FileUtils.deleteDirectory((File)file);
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException(iOException);
                }
            }
        }
    }

    @PostConstruct
    public void initialize() {
        HashSet<String> hashSet = new HashSet<String>();
        List list = ResourceHelper.listResources((String)TEMPLATES_DIR);
        if (list != null) {
            for (String string : list) {
                hashSet.add(ResourceHelper.getName((String)string));
            }
        }
        this.builtinTemplates = Collections.unmodifiableSet(hashSet);
    }

    public boolean isBuiltIn(VoucherTemplate voucherTemplate) {
        return this.builtinTemplates.contains(voucherTemplate.getInternalName());
    }

    public List<VoucherTemplateVO> list() throws FrameworkException {
        return ((DBQuery)this.from(this.$).orderBy(((QVoucherTemplate)this.$).name.asc())).list(VoucherTemplateVO.class, (Expression)this.$);
    }

    @Override
    public VoucherTemplate newEntity(VoucherTemplateVO voucherTemplateVO) {
        VoucherTemplate voucherTemplate = (VoucherTemplate)this.conversionHandler.convert(VoucherTemplate.class, (Object)voucherTemplateVO);
        if (voucherTemplate == null) {
            throw new ValidationException();
        }
        VoucherTemplate voucherTemplate2 = new VoucherTemplate();
        voucherTemplate2.setBasedOnId(voucherTemplate.getId());
        voucherTemplate2.setContent(voucherTemplate.getContent());
        voucherTemplate2.setStyle(voucherTemplate.getStyle());
        return voucherTemplate2;
    }

    public void onApplicationUpgradeInitialization() {
        this.importBuiltin();
    }

    public SerializableInputStream preview(@NotNull VoucherTypeVO voucherTypeVO, @NotNull VoucherTemplateDTO voucherTemplateDTO) {
        VoucherType voucherType = (VoucherType)this.conversionHandler.convert(VoucherType.class, (Object)voucherTypeVO);
        return this.pdfReportHandler.previewVoucher(voucherType, voucherTemplateDTO);
    }

    @Override
    protected void addParametersToHasContentData(VoucherTemplate voucherTemplate, HasContentData hasContentData) {
    }

    @Override
    protected VoucherTemplateData getData(VoucherTemplate voucherTemplate) {
        VoucherTemplateData voucherTemplateData = new VoucherTemplateData();
        voucherTemplateData.setTypes(this.voucherTypeService.list());
        voucherTemplateData.setDto((EntityDTO)((VoucherTemplateDTO)this.toDTO(voucherTemplate)));
        if (voucherTemplate.isPersistent()) {
            voucherTemplateData.setImages(this.voucherTemplateImageService.list(((VoucherTemplateDTO)voucherTemplateData.getDto()).getId()));
        }
        return voucherTemplateData;
    }

    @Override
    protected void onAfterSave(VoucherTemplate voucherTemplate, VoucherTemplate voucherTemplate2, Object object) {
        Long l = voucherTemplate.getBasedOnId();
        if (voucherTemplate2 == null && l != null) {
            VoucherTemplate voucherTemplate3 = (VoucherTemplate)this.find(l);
            for (VoucherTemplateImage voucherTemplateImage : voucherTemplate3.getImages()) {
                try {
                    SerializableInputStream serializableInputStream = this.storedFileHandler.getContent((StoredFile)voucherTemplateImage);
                    try {
                        this.voucherTemplateImageService.saveImage(voucherTemplate, voucherTemplateImage.getName(), (InputStream)serializableInputStream, voucherTemplateImage.getContentType());
                    }
                    finally {
                        if (serializableInputStream == null) continue;
                        serializableInputStream.close();
                    }
                }
                catch (Exception exception) {
                    throw new IllegalStateException(exception);
                }
            }
        }
    }

    @Override
    protected void onBeforeRemove(VoucherTemplate voucherTemplate) {
        voucherTemplate.getImages().forEach(voucherTemplateImage -> this.storedFileHandler.remove(voucherTemplateImage.getId().longValue()));
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QVoucherTemplate)this.$).network(), true);
    }

    @Override
    protected Validator resolveValidator(VoucherTemplateDTO voucherTemplateDTO) {
        Validator validator = new Validator();
        if (voucherTemplateDTO.isTransient()) {
            validator.property((Property)VoucherTemplateDTO.BASED_ON_ID, BankingKeys.VoucherTemplates.NEW).required();
        }
        validator.property((Property)VoucherTemplateDTO.CONTENT, BankingKeys.VoucherTemplates.CONTENT).required().add((object, object2, object3) -> {
            VoucherType voucherType = this.voucherTypeService.findAny();
            if (voucherType != null) {
                try {
                    this.pdfReportHandler.previewVoucher(voucherType, voucherTemplateDTO);
                }
                catch (TemplateEngineException templateEngineException) {
                    return new ValidationError(BankingKeys.VoucherTemplates.ERROR_INVALID_TEMPLATE, new Object[]{this.extractErrorMessage(templateEngineException)});
                }
            }
            return null;
        });
        return validator;
    }

    private VoucherTemplate doImport(VoucherTemplate voucherTemplate, InputStream inputStream2, InputStream inputStream3, InputStream inputStream4, Map<String, InputStream> map) {
        try {
            VoucherTemplateMetadata voucherTemplateMetadata = inputStream2 == null ? new VoucherTemplateMetadata() : (VoucherTemplateMetadata)this.jsonConverter.readValue(inputStream2, VoucherTemplateMetadata.class);
            String string2 = inputStream3 == null ? "" : IOUtils.toString((InputStream)inputStream3, (Charset)StandardCharsets.UTF_8);
            String string3 = inputStream4 == null ? "" : IOUtils.toString((InputStream)inputStream4, (Charset)StandardCharsets.UTF_8);
            VoucherTemplate voucherTemplate2 = (VoucherTemplate)ObjectHelper.defaultValue((Object)voucherTemplate, (Object)new VoucherTemplate());
            this.conversionHandler.fill((Object)voucherTemplateMetadata, (Object)voucherTemplate2);
            voucherTemplate2.setName(this.uniqueName(voucherTemplate, (String)ObjectHelper.defaultValue((Object)voucherTemplate2.getName(), (Object)"Template")));
            if (StringHelper.isNotBlank((Object)voucherTemplate2.getInternalName())) {
                voucherTemplate2.setInternalName(this.uniqueInternalName(voucherTemplate, voucherTemplate2.getInternalName()));
            }
            voucherTemplate2.setContent(string2);
            voucherTemplate2.setStyle(string3);
            if (voucherTemplate2.isTransient()) {
                this.persist((IEntity)voucherTemplate2);
            }
            CollectionHelper.orEmpty(map).forEach((string, inputStream) -> {
                File file = null;
                try {
                    VoucherTemplateImage voucherTemplateImage2;
                    byte[] byArray;
                    file = this.cyclosProperties.newTempFile("voucherTemplate", string);
                    IOUtils.copy((InputStream)inputStream, (OutputStream)new FileOutputStream(file));
                    try (FileInputStream fileInputStream = new FileInputStream(file);){
                        byArray = DigestUtils.md5((InputStream)fileInputStream);
                    }
                    fileInputStream = ServerImageHelper.ImageType.getByContent((File)file);
                    boolean bl = true;
                    if (voucherTemplate != null && (voucherTemplateImage2 = (VoucherTemplateImage)voucherTemplate.getImages().stream().filter(voucherTemplateImage -> voucherTemplateImage.getName().equals(string)).findAny().orElse(null)) != null) {
                        byte[] byArray2;
                        try (SerializableInputStream serializableInputStream = this.storedFileHandler.getContent((StoredFile)voucherTemplateImage2);){
                            byArray2 = DigestUtils.md5((InputStream)serializableInputStream);
                        }
                        catch (Exception exception) {
                            byArray2 = null;
                        }
                        boolean bl2 = bl = byArray2 == null || !Arrays.equals(byArray2, byArray);
                        if (bl) {
                            this.storedFileHandler.remove(voucherTemplateImage2.getId().longValue());
                        }
                    }
                    if (bl) {
                        this.voucherTemplateImageService.saveImage(voucherTemplate2, string, (InputStream)new FileInputStream(file), fileInputStream.getContentType());
                    }
                }
                catch (CyclosException cyclosException) {
                    throw cyclosException;
                }
                catch (Exception exception) {
                    throw new FileParsingException((Throwable)exception);
                }
                finally {
                    if (file != null) {
                        file.delete();
                    }
                }
            });
            return voucherTemplate2;
        }
        catch (CyclosException cyclosException) {
            throw cyclosException;
        }
        catch (Exception exception) {
            throw new FileParsingException((Throwable)exception);
        }
    }

    private String extractErrorMessage(TemplateEngineException templateEngineException) {
        Serializable serializable;
        String string = null;
        Throwable[] throwableArray = ExceptionUtils.getThrowables((Throwable)templateEngineException);
        int n = ExceptionUtils.indexOfType((Throwable)templateEngineException, OgnlException.class);
        if (throwableArray.length > 0 && n != -1) {
            serializable = throwableArray[n];
            string = serializable.getClass().getName() + " " + ((Throwable)serializable).getMessage();
        }
        serializable = new StringBuilder((String)FieldHelper.get((Object)((Object)templateEngineException), (String)"detailMessage"));
        if (StringHelper.isNotBlank(string)) {
            ((StringBuilder)serializable).append(" | " + string);
        }
        return ((StringBuilder)serializable).toString();
    }

    private boolean internalNameExists(VoucherTemplate voucherTemplate, String string) {
        return ((DBQuery)this.from(this.$).where(new Predicate[]{((QVoucherTemplate)this.$).internalName.eq((Object)string), voucherTemplate == null ? ((QVoucherTemplate)this.$).id.isNotNull() : ((QVoucherTemplate)this.$).id.ne((Object)voucherTemplate.getId())})).hasResults();
    }

    private boolean nameExists(VoucherTemplate voucherTemplate, String string) {
        return ((DBQuery)this.from(this.$).where(new Predicate[]{((QVoucherTemplate)this.$).name.eq((Object)string), voucherTemplate == null ? ((QVoucherTemplate)this.$).id.isNotNull() : ((QVoucherTemplate)this.$).id.ne((Object)voucherTemplate.getId())})).hasResults();
    }

    private String readHTMLTemplate(String string2) {
        Supplier<String> supplier = () -> {
            try {
                return ResourceHelper.readContent((String)("/pdf-templates/" + string2));
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        };
        if (this.cyclosProperties.isDevelopment()) {
            return supplier.get();
        }
        return this.cachedTemplates.computeIfAbsent(string2, string -> (String)supplier.get());
    }

    private InputStream toIn(File file) throws FileNotFoundException {
        return file == null || !file.exists() ? null : new FileInputStream(file);
    }

    private String uniqueInternalName(VoucherTemplate voucherTemplate, String string) {
        String string2;
        if (string == null || !this.internalNameExists(voucherTemplate, string)) {
            return string;
        }
        int n = 1;
        while (this.internalNameExists(voucherTemplate, string2 = string + n++)) {
        }
        return string2;
    }

    private String uniqueName(VoucherTemplate voucherTemplate, String string) {
        String string2;
        if (!this.nameExists(voucherTemplate, string)) {
            return string;
        }
        int n = 1;
        while (this.nameExists(voucherTemplate, string2 = string + n++)) {
        }
        return string2;
    }

    public static class VoucherTemplateMetadata {
        private String name;
        private String internalName;
        private String description;

        public String getDescription() {
            return this.description;
        }

        public String getInternalName() {
            return this.internalName;
        }

        public String getName() {
            return this.name;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public void setInternalName(String string) {
            this.internalName = string;
        }

        public void setName(String string) {
            this.name = string;
        }
    }
}

