/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.contentmanagement;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.StringPath;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.NamedEntity;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.contentmanagement.DataTranslationHandler;
import org.cyclos.impl.contentmanagement.DataTranslationPropertyMapping;
import org.cyclos.impl.contentmanagement.TranslationHandler;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.model.EntityModel;
import org.cyclos.model.contentmanagement.translations.DataTranslationPropertyType;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.server.utils.FieldHelper;
import org.cyclos.server.utils.PropertyHelper;
import org.cyclos.utils.MessageKey;

public class DataTranslationEntityMapping {
    private final DataTranslationType type;
    private final EntityPath<?> path;
    private final NumberPath<Long> idPath;
    private final boolean alsoInGlobalMode;
    private final Map<String, DataTranslationPropertyMapping> properties = new LinkedHashMap<String, DataTranslationPropertyMapping>();
    private final Map<Class<? extends BaseEntity>, List<DescriptionResolver<?>>> descriptionResolvers = new LinkedHashMap();
    private OrderSpecifier<?>[] orderBy;
    private Map<String, DataTranslationPropertyType> propertyTypes = new LinkedHashMap<String, DataTranslationPropertyType>();

    public DataTranslationEntityMapping(DataTranslationType dataTranslationType, EntityPath<?> entityPath, boolean bl) {
        this.type = dataTranslationType;
        this.path = entityPath;
        this.alsoInGlobalMode = bl;
        this.idPath = (NumberPath)FieldHelper.get(entityPath, (String)EntityModel.ID.getName());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DataTranslationEntityMapping dataTranslationEntityMapping = (DataTranslationEntityMapping)object;
        return this.type == dataTranslationEntityMapping.type;
    }

    public String getDescription(BaseEntity baseEntity, TranslationHandler translationHandler, DataTranslationHandler dataTranslationHandler) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<Class<BaseEntity>, List<DescriptionResolver<?>>> entry : this.descriptionResolvers.entrySet()) {
            if (!(Modifier.isAbstract(entry.getKey().getModifiers()) ? entry.getKey().isInstance(baseEntity) : entry.getKey().equals(baseEntity.getClass()))) continue;
            List<DescriptionResolver<?>> list = entry.getValue();
            for (DescriptionResolver<?> descriptionResolver : list) {
                String string;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" - ");
                }
                if ((string = descriptionResolver.getDescription(baseEntity, translationHandler, dataTranslationHandler)) == null) continue;
                stringBuilder.append(string);
            }
        }
        return stringBuilder.length() == 0 ? null : stringBuilder.toString();
    }

    public NumberPath<Long> getIdPath() {
        return this.idPath;
    }

    public OrderSpecifier<?>[] getOrderBy() {
        if (this.orderBy == null) {
            return new OrderSpecifier[]{QueryHelper.orderSpecifier(this.path)};
        }
        return this.orderBy;
    }

    public EntityPath<?> getPath() {
        return this.path;
    }

    public List<DataTranslationPropertyMapping> getProperties() {
        return new ArrayList<DataTranslationPropertyMapping>(this.properties.values());
    }

    public DataTranslationPropertyMapping getProperty(String string) {
        return this.properties.get(string);
    }

    public DataTranslationPropertyType getPropertyType(String string) {
        return this.propertyTypes.get(string);
    }

    public Map<String, DataTranslationPropertyType> getPropertyTypes() {
        return new HashMap<String, DataTranslationPropertyType>(this.propertyTypes);
    }

    public DataTranslationType getType() {
        return this.type;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.type == null ? 0 : this.type.hashCode());
        return n;
    }

    public boolean isAlsoInGlobalMode() {
        return this.alsoInGlobalMode;
    }

    public String toString() {
        return this.type.name() + " " + String.valueOf(this.properties.keySet());
    }

    <E extends BaseEntity> DataTranslationEntityMapping description(Class<E> clazz, DescriptionResolver<E> descriptionResolver) {
        List<DescriptionResolver<?>> list = this.descriptionResolvers.get(clazz);
        if (list == null) {
            list = new ArrayList();
            this.descriptionResolvers.put(clazz, list);
        }
        list.add(descriptionResolver);
        return this;
    }

    <E extends BaseEntity> DataTranslationEntityMapping description(Class<E> clazz, EntityPath<? extends NamedEntity> entityPath) {
        this.description(clazz, (E baseEntity, TranslationHandler translationHandler, DataTranslationHandler dataTranslationHandler) -> {
            String string = PropertyHelper.getPropertyName((Path)entityPath);
            Object object = InvocationContext.wrap((Object)baseEntity).getPropertyValue(string);
            return object == null ? null : dataTranslationHandler.getName((NamedEntity)object);
        });
        return this;
    }

    <E extends BaseEntity> DataTranslationEntityMapping description(Class<E> clazz, MessageKey messageKey) {
        this.description(clazz, (E baseEntity, TranslationHandler translationHandler, DataTranslationHandler dataTranslationHandler) -> translationHandler.message(messageKey, new Object[0]));
        return this;
    }

    <E extends BaseEntity> DataTranslationEntityMapping descriptionAndOrderBy(Class<E> clazz, EntityPath<? extends NamedEntity> entityPath) {
        this.description(clazz, entityPath);
        this.orderBy(QueryHelper.orderSpecifier(entityPath), QueryHelper.orderSpecifier(this.path));
        return this;
    }

    DataTranslationEntityMapping orderBy(EntityPath<?> ... entityPathArray) {
        this.orderBy = new OrderSpecifier[entityPathArray.length];
        for (int i = 0; i < entityPathArray.length; ++i) {
            this.orderBy[i] = QueryHelper.orderSpecifier(entityPathArray[i]);
        }
        return this;
    }

    DataTranslationEntityMapping orderBy(OrderSpecifier<?> ... orderSpecifierArray) {
        this.orderBy = orderSpecifierArray;
        return this;
    }

    DataTranslationEntityMapping property(StringPath stringPath, DataTranslationPropertyType dataTranslationPropertyType, MessageKey messageKey) {
        return this.property(stringPath, dataTranslationPropertyType, messageKey, false);
    }

    DataTranslationEntityMapping property(StringPath stringPath, DataTranslationPropertyType dataTranslationPropertyType, MessageKey messageKey, boolean bl) {
        String string = PropertyHelper.getPropertyName((Path)stringPath);
        this.properties.put(string, new DataTranslationPropertyMapping(stringPath, dataTranslationPropertyType, messageKey, bl));
        this.propertyTypes.put(string, dataTranslationPropertyType);
        return this;
    }

    public static interface DescriptionResolver<E extends BaseEntity> {
        public String getDescription(E var1, TranslationHandler var2, DataTranslationHandler var3);
    }
}

