/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.contentmanagement;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.contentmanagement.BaseStaticContent;
import org.cyclos.entities.contentmanagement.DataTranslation;
import org.cyclos.entities.contentmanagement.QDataTranslation;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.Language;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.system.QNetwork;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.contentmanagement.DataTranslationEntityMapping;
import org.cyclos.impl.contentmanagement.DataTranslationHandler;
import org.cyclos.impl.contentmanagement.DataTranslationHandlerImplementor;
import org.cyclos.impl.contentmanagement.DataTranslationMapping;
import org.cyclos.impl.contentmanagement.DataTranslationPropertyMapping;
import org.cyclos.impl.contentmanagement.DataTranslationServiceLocal;
import org.cyclos.impl.marketplace.AdCategoryServiceLocal;
import org.cyclos.impl.utils.RichTextHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.ValidationException;
import org.cyclos.model.contentmanagement.translations.DataTranslationDTO;
import org.cyclos.model.contentmanagement.translations.DataTranslationData;
import org.cyclos.model.contentmanagement.translations.DataTranslationPropertyData;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.model.contentmanagement.translations.DataTranslationTypeData;
import org.cyclos.model.contentmanagement.translations.DataTranslationTypeGroup;
import org.cyclos.model.contentmanagement.translations.DataTranslationValueDTO;
import org.cyclos.model.contentmanagement.translations.HierarchicalDataTranslationType;
import org.cyclos.model.system.languages.LanguageVO;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataTranslationServiceImpl
extends BaseServiceImpl
implements DataTranslationServiceLocal {
    private static final QDataTranslation $ = QDataTranslation.dataTranslation;
    @Autowired
    private NetworkPathRegistry networkPathRegistry;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private RichTextHandler richTextHandler;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private AdCategoryServiceLocal adCategoryService;
    @Autowired
    private DataTranslationHandlerImplementor dataTranslationHandlerImplementor;

    public long deleteOrphans() {
        long l = 0L;
        for (DataTranslationType dataTranslationType : DataTranslationType.values()) {
            l += this.deleteOrphan(DataTranslationMapping.get(dataTranslationType));
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataTranslationData getData(LanguageVO languageVO, DataTranslationType dataTranslationType) throws FrameworkException {
        DataTranslationPropertyMapping dataTranslationPropertyMapping2;
        DataTranslationEntityMapping dataTranslationEntityMapping = DataTranslationMapping.get(dataTranslationType);
        DataTranslationData dataTranslationData = new DataTranslationData();
        Language language = (Language)this.conversionHandler.convert(Language.class, (Object)languageVO);
        ArrayList<DataTranslationDTO> arrayList = new ArrayList<DataTranslationDTO>();
        dataTranslationData.setLanguageVO((LanguageVO)this.conversionHandler.convert(LanguageVO.class, (Object)language));
        dataTranslationData.setTranslations(arrayList);
        dataTranslationData.setType(dataTranslationType);
        dataTranslationData.setAllowThymeleaf(this.richTextHandler.skipSanitization());
        ArrayList<DataTranslationPropertyData> arrayList2 = new ArrayList<DataTranslationPropertyData>();
        for (DataTranslationPropertyMapping dataTranslationPropertyMapping2 : dataTranslationEntityMapping.getProperties()) {
            DataTranslationPropertyData dataTranslationPropertyData = (DataTranslationPropertyData)this.conversionHandler.convert(DataTranslationPropertyData.class, (Object)dataTranslationPropertyMapping2);
            dataTranslationPropertyData.setLabel(this.message(dataTranslationPropertyMapping2.getKey(), new Object[0]));
            arrayList2.add(dataTranslationPropertyData);
        }
        dataTranslationData.setProperties(arrayList2);
        Network network = this.getSessionData().getNetwork();
        dataTranslationPropertyMapping2 = ((DBQuery)this.queryWithNetworkFilter(network, dataTranslationEntityMapping).orderBy(dataTranslationEntityMapping.getOrderBy())).iterate(dataTranslationEntityMapping.getPath());
        try {
            for (BaseEntity baseEntity : CollectionHelper.iterable((Iterator)dataTranslationPropertyMapping2)) {
                Object object2;
                BaseStaticContent baseStaticContent;
                if (baseEntity instanceof BaseStaticContent && !(baseStaticContent = (BaseStaticContent)baseEntity).isCustomized()) continue;
                baseStaticContent = InvocationContext.wrap((Object)baseEntity);
                ArrayList<DataTranslationValueDTO> arrayList3 = new ArrayList<DataTranslationValueDTO>();
                for (Object object2 : dataTranslationEntityMapping.getProperties()) {
                    String string;
                    String string2;
                    String string3 = this.dataTranslationHandlerImplementor.getValue(language, baseEntity, object2.getName(), false, false);
                    String string4 = string2 = language.getParent() == null ? null : this.dataTranslationHandler.getValue(language.getParent(), baseEntity, object2.getName());
                    if (dataTranslationType == DataTranslationType.CONFIGURATION && (this.configurationHandler.getConfigurableProperties().contains(object2.getName()) && !((Configuration)baseEntity).getDefinedProperties().contains(object2.getName()) || string2 == null)) continue;
                    DataTranslationValueDTO dataTranslationValueDTO = new DataTranslationValueDTO();
                    dataTranslationValueDTO.setProperty(object2.getName());
                    if (StringHelper.isBlank((Object)string2)) {
                        try {
                            string2 = (String)baseStaticContent.getPropertyValue(object2.getName());
                        }
                        catch (NotReadablePropertyException notReadablePropertyException) {
                            continue;
                        }
                    }
                    if ((string = this.richTextHandler.applyPropertyMapping(object2, string2, false)) == null) continue;
                    dataTranslationValueDTO.setValue(this.richTextHandler.applyPropertyMapping(object2, string3, false));
                    dataTranslationValueDTO.setOriginalValue(string);
                    arrayList3.add(dataTranslationValueDTO);
                }
                if (arrayList3.isEmpty()) continue;
                DataTranslationDTO dataTranslationDTO = new DataTranslationDTO();
                dataTranslationDTO.setType(dataTranslationType);
                dataTranslationDTO.setEntityId(baseEntity.getId());
                object2 = dataTranslationEntityMapping.getDescription(baseEntity, this.translationHandler, this.dataTranslationHandler);
                dataTranslationDTO.setDescription((String)object2);
                dataTranslationDTO.setValues(arrayList3);
                arrayList.add(dataTranslationDTO);
            }
        }
        finally {
            dataTranslationPropertyMapping2.close();
        }
        return dataTranslationData;
    }

    public DataTranslationTypeData getTypeData(LanguageVO languageVO) throws FrameworkException {
        Language language = (Language)this.conversionHandler.convert(Language.class, (Object)languageVO);
        boolean bl = this.getSessionData().getNetwork() == null;
        ArrayList<HierarchicalDataTranslationType> arrayList = new ArrayList<HierarchicalDataTranslationType>();
        for (DataTranslationTypeGroup dataTranslationTypeGroup : DataTranslationTypeGroup.values()) {
            HierarchicalDataTranslationType hierarchicalDataTranslationType = new HierarchicalDataTranslationType();
            hierarchicalDataTranslationType.setName(this.message(dataTranslationTypeGroup.getMessageKey(), new Object[0]));
            hierarchicalDataTranslationType.setGroup(dataTranslationTypeGroup);
            boolean bl2 = false;
            for (DataTranslationType dataTranslationType : DataTranslationType.getByGroup((DataTranslationTypeGroup)dataTranslationTypeGroup)) {
                DataTranslationEntityMapping dataTranslationEntityMapping = DataTranslationMapping.get(dataTranslationType);
                if (bl && !dataTranslationEntityMapping.isAlsoInGlobalMode()) continue;
                if (!bl2) {
                    arrayList.add(hierarchicalDataTranslationType);
                    bl2 = true;
                }
                HierarchicalDataTranslationType hierarchicalDataTranslationType2 = new HierarchicalDataTranslationType();
                hierarchicalDataTranslationType2.setName(this.message(dataTranslationType.getMessageKey(), new Object[0]));
                hierarchicalDataTranslationType2.setType(dataTranslationType);
                hierarchicalDataTranslationType2.setParent(hierarchicalDataTranslationType);
                arrayList.add(hierarchicalDataTranslationType2);
            }
        }
        DataTranslationTypeData dataTranslationTypeData = new DataTranslationTypeData();
        dataTranslationTypeData.setLanguageVO((LanguageVO)this.conversionHandler.convert(LanguageVO.class, (Object)language));
        dataTranslationTypeData.setTypes(arrayList);
        return dataTranslationTypeData;
    }

    public void save(Language language, BaseEntity baseEntity, Map<String, String> map) throws FrameworkException {
        DataTranslationType dataTranslationType = baseEntity.getDataTranslationType();
        DataTranslationEntityMapping dataTranslationEntityMapping = DataTranslationMapping.get(dataTranslationType);
        if (language == null) {
            language = this.getConfiguration().getLanguage();
        }
        this.doSave(language, dataTranslationEntityMapping, baseEntity.getId(), map);
        this.clearCaches(baseEntity.getDataTranslationType() == DataTranslationType.AD_CATEGORIES, language.getId());
    }

    public void translate(LanguageVO languageVO, List<DataTranslationDTO> list) throws FrameworkException {
        if (CollectionHelper.isEmpty(list)) {
            throw new ValidationException();
        }
        Language language = (Language)this.conversionHandler.convert(Language.class, (Object)languageVO);
        Network network = this.getSessionData().getNetwork();
        HashSet<DataTranslationEntityMapping> hashSet = new HashSet<DataTranslationEntityMapping>();
        for (DataTranslationDTO dataTranslationDTO : list) {
            DataTranslationType dataTranslationType = dataTranslationDTO.getType();
            if (dataTranslationType == null) {
                throw new ValidationException();
            }
            DataTranslationEntityMapping dataTranslationEntityMapping = DataTranslationMapping.get(dataTranslationType);
            hashSet.add(dataTranslationEntityMapping);
            Long l = dataTranslationDTO.getEntityId();
            if (!this.entityExists(network, dataTranslationEntityMapping, l)) continue;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (DataTranslationValueDTO dataTranslationValueDTO : dataTranslationDTO.getValues()) {
                hashMap.put(dataTranslationValueDTO.getProperty(), dataTranslationValueDTO.getValue());
            }
            this.doSave(language, dataTranslationEntityMapping, l, hashMap);
        }
        this.clearCaches(list.get(0).getType() == DataTranslationType.AD_CATEGORIES, language.getId());
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register($.language().network(), true);
    }

    private void clearCaches(boolean bl, Long l) {
        if (bl) {
            this.adCategoryService.clearAdCategoriesCache(l);
        }
    }

    private long deleteOrphan(DataTranslationEntityMapping dataTranslationEntityMapping) {
        HashSet<Long> hashSet = new HashSet<Long>();
        JPAQuery jPAQuery = (JPAQuery)((JPAQuery)new JPAQuery().from(dataTranslationEntityMapping.getPath())).where((Predicate)dataTranslationEntityMapping.getIdPath().eq((Expression)DataTranslationServiceImpl.$.entityId));
        try (CloseableIterator closeableIterator = ((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{$}).where(new Predicate[]{DataTranslationServiceImpl.$.type.eq((Object)dataTranslationEntityMapping.getType()), jPAQuery.notExists()})).iterate((Expression)$);){
            while (closeableIterator.hasNext()) {
                DataTranslation dataTranslation = (DataTranslation)closeableIterator.next();
                hashSet.add(dataTranslation.getId());
                this.dataTranslationHandler.removeFromStorage(dataTranslation);
            }
        }
        return this.rawEntityManagerHandler.delete((EntityPath)$).where(new Predicate[]{DataTranslationServiceImpl.$.id.in(hashSet)}).execute();
    }

    private void doSave(Language language, DataTranslationEntityMapping dataTranslationEntityMapping, Long l, Map<String, String> map) {
        DataTranslationType dataTranslationType = dataTranslationEntityMapping.getType();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            DataTranslationPropertyMapping dataTranslationPropertyMapping = dataTranslationEntityMapping.getProperty(string);
            if (dataTranslationPropertyMapping == null) {
                throw new ValidationException();
            }
            DataTranslation dataTranslation = this.getExisting(dataTranslationType, language, l, string);
            String string2 = this.richTextHandler.applyPropertyMapping(dataTranslationPropertyMapping, entry.getValue(), true);
            if (dataTranslation == null && StringHelper.isNotBlank((Object)string2)) {
                dataTranslation = new DataTranslation();
                dataTranslation.setType(dataTranslationType);
                dataTranslation.setLanguage(language);
                dataTranslation.setEntityId(l);
                dataTranslation.setPropertyName(string);
            } else {
                if (dataTranslation != null && StringHelper.isBlank((Object)string2)) {
                    this.rawEntityManagerHandler.remove((IEntity)dataTranslation);
                    this.addCommitListener(dataTranslation, arg_0 -> ((DataTranslationHandler)this.dataTranslationHandler).removeFromStorage(arg_0));
                    continue;
                }
                if (dataTranslation == null && StringHelper.isBlank((Object)string2)) continue;
            }
            dataTranslation.setValue(string2);
            if (dataTranslation.isTransient()) {
                this.rawEntityManagerHandler.persist((IEntity)dataTranslation);
            }
            this.addCommitListener(dataTranslation, arg_0 -> ((DataTranslationHandler)this.dataTranslationHandler).addToStorage(arg_0));
        }
    }

    private boolean entityExists(Network network, DataTranslationEntityMapping dataTranslationEntityMapping, Long l) {
        if (l == null) {
            return false;
        }
        return ((DBQuery)this.queryWithNetworkFilter(network, dataTranslationEntityMapping).where((Predicate)dataTranslationEntityMapping.getIdPath().eq((Object)l))).hasResults();
    }

    private DataTranslation getExisting(DataTranslationType dataTranslationType, Language language, Long l, String string) {
        DataTranslation dataTranslation = (DataTranslation)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{$}).where(new Predicate[]{DataTranslationServiceImpl.$.type.eq((Object)dataTranslationType), $.language().eq((Object)language), DataTranslationServiceImpl.$.entityId.eq((Object)l), DataTranslationServiceImpl.$.propertyName.eq((Object)string)})).singleResult((Expression)$);
        return dataTranslation;
    }

    private DBQuery<?> queryWithNetworkFilter(Network network, DataTranslationEntityMapping dataTranslationEntityMapping) {
        EntityPath<?> entityPath = dataTranslationEntityMapping.getPath();
        QNetwork qNetwork = this.networkPathRegistry.resolve(entityPath);
        boolean bl = this.networkPathRegistry.showGlobals(entityPath.getType());
        return (DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{entityPath}).where((Predicate)(qNetwork == null ? dataTranslationEntityMapping.getIdPath().isNotNull() : (network == null ? qNetwork.isNull() : (bl ? qNetwork.isNull().or((Predicate)qNetwork.eq((Object)network)) : qNetwork.eq((Object)network)))));
    }

    void addCommitListener(DataTranslation dataTranslation, Consumer<DataTranslation> consumer) {
        if (this.cyclosProperties.isTestingEnv()) {
            consumer.accept(dataTranslation);
        } else {
            InvocationContext.ensure().addCommitListener(false, () -> consumer.accept(dataTranslation));
        }
    }
}

