/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.contentmanagement;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.NamedEntity;
import org.cyclos.entities.contentmanagement.Document;
import org.cyclos.entities.contentmanagement.DocumentCategory;
import org.cyclos.entities.contentmanagement.DocumentCustomField;
import org.cyclos.entities.contentmanagement.DocumentFile;
import org.cyclos.entities.contentmanagement.DynamicDocument;
import org.cyclos.entities.contentmanagement.HasContentScript;
import org.cyclos.entities.contentmanagement.QDocument;
import org.cyclos.entities.contentmanagement.QDynamicDocument;
import org.cyclos.entities.contentmanagement.QSharedDocument;
import org.cyclos.entities.contentmanagement.QUserDocument;
import org.cyclos.entities.contentmanagement.SharedDocument;
import org.cyclos.entities.contentmanagement.StaticDocument;
import org.cyclos.entities.contentmanagement.UserDocument;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.StoredFile;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.contentmanagement.DocumentCategoryServiceLocal;
import org.cyclos.impl.contentmanagement.DocumentCustomFieldServiceLocal;
import org.cyclos.impl.contentmanagement.DocumentServiceLocal;
import org.cyclos.impl.storage.StoredFileHandler;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.system.ScriptHelper;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.RichTextHandler;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.EntityVO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.StoredFileException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.contentmanagement.HasContentData;
import org.cyclos.model.contentmanagement.documentcategories.DocumentCategoryVO;
import org.cyclos.model.contentmanagement.documents.DocumentDTO;
import org.cyclos.model.contentmanagement.documents.DocumentData;
import org.cyclos.model.contentmanagement.documents.DocumentDataParams;
import org.cyclos.model.contentmanagement.documents.DocumentNature;
import org.cyclos.model.contentmanagement.documents.DocumentQuery;
import org.cyclos.model.contentmanagement.documents.DocumentRange;
import org.cyclos.model.contentmanagement.documents.DocumentSearchData;
import org.cyclos.model.contentmanagement.documents.DocumentVO;
import org.cyclos.model.contentmanagement.documents.DynamicDocumentDTO;
import org.cyclos.model.contentmanagement.documents.DynamicDocumentData;
import org.cyclos.model.contentmanagement.documents.DynamicDocumentVO;
import org.cyclos.model.contentmanagement.documents.ProcessDynamicDocumentDTO;
import org.cyclos.model.contentmanagement.documents.ProcessDynamicDocumentData;
import org.cyclos.model.contentmanagement.documents.SharedDocumentDTO;
import org.cyclos.model.contentmanagement.documents.SharedDocumentData;
import org.cyclos.model.contentmanagement.documents.StaticDocumentDTO;
import org.cyclos.model.contentmanagement.documents.StaticDocumentData;
import org.cyclos.model.contentmanagement.documents.StaticDocumentVO;
import org.cyclos.model.contentmanagement.documents.UserDocumentDTO;
import org.cyclos.model.contentmanagement.documents.UserDocumentData;
import org.cyclos.model.contentmanagement.documents.UserDocumentVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.system.fields.CustomFieldType;
import org.cyclos.model.system.scripts.LoadValuesScriptFunction;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ParameterVO;
import org.cyclos.model.utils.RawFileVO;
import org.cyclos.security.contentmanagement.DocumentServiceSecurity;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DocumentServiceImpl
extends CRUDServiceImpl<Document, QDocument, DocumentDTO, DocumentData, DocumentDataParams>
implements DocumentServiceLocal {
    private static final BidiMap<Class<? extends Document>, Class<? extends DocumentDTO>> SUBCLASS_MAPPINGS = new DualHashBidiMap();
    private static final Map<Class<?>, Class<?>> VO_MAPPINGS = new LinkedHashMap();
    @Autowired
    private CustomFieldValueHandler customFieldValueService;
    @Autowired
    private DocumentCustomFieldServiceLocal documentCustomFieldService;
    @Autowired
    private DocumentCategoryServiceLocal documentCategoryService;
    @Autowired
    private DocumentServiceSecurity documentServiceSecurity;
    @Autowired
    private RichTextHandler richTextHandler;
    @Autowired
    private CustomFieldValueHandler customFieldValueHandler;
    @Autowired
    private StoredFileHandler storedFileHandler;
    @Autowired
    private ScriptHelper scriptHelper;

    public DocumentServiceImpl() {
        super(Document.class, QDocument.document, DocumentDTO.class);
    }

    public DocumentVO getDocument(DocumentVO documentVO) {
        Document document = (Document)this.conversionHandler.convert(Document.class, (Object)documentVO);
        return (DocumentVO)this.conversionHandler.convert(DocumentVO.class, (Object)document);
    }

    public int getDocumentCount(User user) {
        DocumentQuery documentQuery = new DocumentQuery();
        documentQuery.setCountOnly();
        documentQuery.setEnabled(Boolean.valueOf(true));
        if (user != null) {
            documentQuery.setUser(new UserVO(user.getId()));
        }
        this.documentServiceSecurity.applyRestrictions(documentQuery);
        return this.search(documentQuery).getTotalCount();
    }

    public RawFileVO getDocumentFile(DocumentVO documentVO) {
        Document document = (Document)this.conversionHandler.convert(Document.class, (Object)documentVO);
        return (RawFileVO)this.conversionHandler.convert(RawFileVO.class, (Object)this.getFile(document));
    }

    public DocumentSearchData getDocumentSearchData(UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = (User)this.conversionHandler.convert(User.class, (Object)userLocatorVO);
        DocumentSearchData documentSearchData = new DocumentSearchData();
        documentSearchData.setViewCategories(this.conversionHandler.convertList(DocumentCategoryVO.class, (Iterable)this.documentCategoryService.getDocumentCategoriesView()));
        documentSearchData.setManageCategories(this.conversionHandler.convertList(DocumentCategoryVO.class, (Iterable)this.documentCategoryService.getDocumentCategoriesManage()));
        documentSearchData.setCanManageIndividual(user == null ? this.hasPermission(Permission.USER_DOCUMENTS_MANAGE) : !user.isRemoved() && this.permission((BasicUser)user).user(new Permission[]{Permission.USER_DOCUMENTS_MANAGE}).granted());
        documentSearchData.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        DocumentQuery documentQuery = (DocumentQuery)QueryHelper.newQuery(DocumentQuery.class);
        documentQuery.setUser(user == null ? null : new UserVO(user.getId()));
        if (user != null) {
            documentQuery.setEnabled(Boolean.valueOf(true));
        }
        documentSearchData.setQuery((QueryParameters)documentQuery);
        return documentSearchData;
    }

    public ProcessDynamicDocumentData getProcessDynamicDocumentData(DocumentVO documentVO, UserLocatorVO userLocatorVO) {
        DynamicDocument dynamicDocument = (DynamicDocument)this.conversionHandler.convert(DynamicDocument.class, (Object)documentVO);
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        List list = this.conversionHandler.convertList(CustomFieldDetailedVO.class, (Iterable)dynamicDocument.getFormFields());
        ProcessDynamicDocumentData processDynamicDocumentData = new ProcessDynamicDocumentData();
        processDynamicDocumentData.setDocument((DocumentVO)this.conversionHandler.convert(DocumentVO.class, (Object)dynamicDocument));
        processDynamicDocumentData.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        processDynamicDocumentData.setFormFields(list);
        HashMap<String, DynamicDocument> hashMap = new HashMap<String, DynamicDocument>();
        hashMap.put("document", dynamicDocument);
        this.customFieldValueHandler.fillValuesFromScript(DocumentCustomField.class, LoadValuesScriptFunction.ENTITY, hashMap, (Collection)list);
        return processDynamicDocumentData;
    }

    public boolean hasDocuments(User user) {
        return this.hasSharedDocuments(user) || this.hasIndividualDocuments(user);
    }

    public boolean hasIndividualDocuments(User user) throws FrameworkException {
        if (user.isPurged()) {
            return false;
        }
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor((BasicUser)user);
        if (!productsAccessor.product().hasPermission(Permission.MY_INDIVIDUAL_DOCUMENTS_VIEW)) {
            return false;
        }
        QUserDocument qUserDocument = QUserDocument.userDocument;
        return ((DBQuery)this.from(new EntityPath[]{qUserDocument}).where(new Predicate[]{qUserDocument.enable.isTrue(), qUserDocument.user().eq((Object)user)})).hasResults();
    }

    public boolean hasSharedDocuments(User user) throws FrameworkException {
        if (user.isPurged()) {
            return false;
        }
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor((BasicUser)user);
        if (!productsAccessor.product().hasPermission(Permission.MY_SHARED_DOCUMENTS_VIEW)) {
            return false;
        }
        List list = productsAccessor.product().getDocumentCategoryView();
        if (CollectionHelper.isNotEmpty((Iterable)list)) {
            QSharedDocument qSharedDocument = QSharedDocument.sharedDocument;
            return ((DBQuery)this.from(new EntityPath[]{qSharedDocument}).where(new Predicate[]{qSharedDocument.enable.isTrue(), qSharedDocument.category().in((Collection)list)})).hasResults();
        }
        return false;
    }

    public List<DocumentVO> listUserDocuments(UserLocatorVO userLocatorVO) throws FrameworkException {
        SessionData sessionData;
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        if (user == null) {
            return Collections.emptyList();
        }
        boolean bl = user.equals((Object)(sessionData = this.getSessionData()).getLoggedUser());
        boolean bl2 = sessionData.hasPermission(bl ? Permission.MY_SHARED_DOCUMENTS_VIEW : Permission.DOCUMENTS_VIEW);
        boolean bl3 = this.permission((BasicUser)user).my(new Permission[]{Permission.MY_INDIVIDUAL_DOCUMENTS_VIEW}).user(new Permission[]{Permission.USER_DOCUMENTS_VIEW}).granted();
        DocumentQuery documentQuery = new DocumentQuery();
        documentQuery.setUnlimited();
        documentQuery.setEnabled(Boolean.valueOf(true));
        documentQuery.setCategories(this.conversionHandler.convertSet(DocumentCategoryVO.class, (Iterable)sessionData.getProducts().product().getDocumentCategoryView()));
        documentQuery.setUser(new UserVO(user.getId()));
        return this.doSearch(documentQuery, bl2, bl3, true, false).getPageItems();
    }

    @Override
    public Document newEntity(DocumentDataParams documentDataParams) {
        User user;
        DocumentNature documentNature = documentDataParams.getNature();
        DynamicDocument dynamicDocument = null;
        switch (documentNature) {
            case DYNAMIC: {
                dynamicDocument = new DynamicDocument();
                break;
            }
            case STATIC: {
                dynamicDocument = new StaticDocument();
                break;
            }
            case USER: {
                dynamicDocument = new UserDocument();
                user = (User)this.conversionHandler.convert(User.class, (Object)documentDataParams.getUser());
                ((UserDocument)dynamicDocument).setUser(user);
            }
        }
        if (dynamicDocument == null) {
            throw new IllegalActionException();
        }
        if (dynamicDocument instanceof SharedDocument) {
            user = (DocumentCategory)this.conversionHandler.convert(DocumentCategory.class, (Object)documentDataParams.getCategory());
            if (user == null) {
                user = (DocumentCategory)CollectionHelper.first((Iterable)this.documentCategoryService.getDocumentCategoriesManage());
            }
            ((SharedDocument)dynamicDocument).setCategory((DocumentCategory)user);
        }
        return dynamicDocument;
    }

    public String processDynamicDocument(ProcessDynamicDocumentDTO processDynamicDocumentDTO) throws ValidationException {
        Object object2;
        DynamicDocument dynamicDocument = (DynamicDocument)this.conversionHandler.convert(DynamicDocument.class, (Object)processDynamicDocumentDTO.getDocument());
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)processDynamicDocumentDTO.getUser());
        if (dynamicDocument == null || user == null) {
            throw new IllegalActionException();
        }
        Validator validator = new Validator();
        for (Object object2 : dynamicDocument.getFormFields()) {
            this.customFieldValueService.addValueValidation(validator, (CustomField)object2, null, Collections.singletonMap("document", dynamicDocument), ProcessDynamicDocumentDTO.FORM_FIELDS.getName());
        }
        this.validate(validator, processDynamicDocumentDTO, "processDynamicDocument");
        FormatterImpl formatterImpl = this.getFormatter();
        object2 = this.customFieldValueHandler.toValuesMap((Collection)dynamicDocument.getFormFields(), (Collection)processDynamicDocumentDTO.getFormFields(), true).entrySet().stream().collect(Collectors.toMap(entry -> ((DocumentCustomField)entry.getKey()).getInternalName(), entry -> ((DocumentCustomField)entry.getKey()).getType() == CustomFieldType.TEXT ? StringHelper.convertNewLineToBr((String)StringHelper.trim(entry.getValue())) : entry.getValue()));
        Function<String, Object> function = arg_0 -> DocumentServiceImpl.lambda$processDynamicDocument$2((Map)object2, formatterImpl, arg_0);
        return this.richTextHandler.newContentAccessor((HasContentScript)dynamicDocument).setUser((BasicUser)user).setVariablesFunction(function).addThymeleafBinding("owner", (Object)this.scriptHelper.wrap((Object)user)).addThymeleafBinding("customValues", object2).process(this.getTranslatedValue((BaseEntity)dynamicDocument, QDynamicDocument.dynamicDocument.content));
    }

    public SerializableInputStream readContent(DocumentVO documentVO) {
        Document document = (Document)this.conversionHandler.convert(Document.class, (Object)documentVO);
        DocumentFile documentFile = this.getFile(document);
        if (documentFile == null || documentFile.isTransient()) {
            throw new EntityNotFoundException(DocumentFile.class);
        }
        return this.storedFileHandler.getContent((StoredFile)documentFile);
    }

    public void removeAll(User user) {
        QUserDocument qUserDocument = QUserDocument.userDocument;
        CloseableIterator closeableIterator = ((DBQuery)this.from(new EntityPath[]{qUserDocument}).where(new Predicate[]{qUserDocument.enable.isTrue(), qUserDocument.user().eq((Object)user)})).iterate((Expression)qUserDocument);
        this.processBatch(closeableIterator, this::remove);
    }

    public void saveFile(DocumentVO documentVO, String string, String string2, SerializableInputStream serializableInputStream) {
        try {
            if (serializableInputStream != null && serializableInputStream.file().length() > 0L) {
                Document document = (Document)this.conversionHandler.convert(Document.class, (Object)documentVO);
                DocumentFile documentFile = this.getFile(document);
                if (documentFile == null) {
                    documentFile = new DocumentFile();
                    documentFile.setDocument(document);
                    this.setFile(documentFile, document);
                }
                documentFile.setLength(Integer.valueOf((int)serializableInputStream.file().length()));
                documentFile.setContentType(string);
                documentFile.setLastModified(new Date());
                documentFile.setName(string2);
                this.storedFileHandler.save((StoredFile)documentFile, serializableInputStream);
            }
        }
        catch (IOException iOException) {
            throw new StoredFileException((Throwable)iOException);
        }
    }

    public Long saveWithFile(DocumentDTO documentDTO, String string, String string2, SerializableInputStream serializableInputStream) {
        documentDTO.setAttribute("requireFile", (Object)(serializableInputStream == null ? 1 : 0));
        Long l = this.save(documentDTO);
        this.saveFile(new DocumentVO(l), string, string2, serializableInputStream);
        return l;
    }

    public Page<DocumentVO> search(DocumentQuery documentQuery) {
        boolean bl = this.hasPermission(Permission.DOCUMENTS_VIEW);
        boolean bl2 = this.hasPermission(Permission.USER_DOCUMENTS_VIEW);
        return this.doSearch(documentQuery, bl, bl2, false, this.isBroker());
    }

    @Override
    protected void addParametersToHasContentData(Document document, HasContentData hasContentData) {
        super.addParametersToHasContentData(document, hasContentData);
        if (document instanceof DynamicDocument) {
            DynamicDocument dynamicDocument = (DynamicDocument)document;
            List list = dynamicDocument.getFormFields().stream().map(documentCustomField -> new ParameterVO(documentCustomField.getInternalName(), this.getTranslatedName((NamedEntity)documentCustomField))).collect(Collectors.toList());
            list.addAll(hasContentData.getParameters());
            hasContentData.setParameters(list);
        }
    }

    @Override
    protected DocumentData getData(Document document) {
        DynamicDocumentData dynamicDocumentData;
        if (document instanceof DynamicDocument) {
            DynamicDocumentData dynamicDocumentData2 = new DynamicDocumentData();
            if (document.isPersistent()) {
                dynamicDocumentData2.setFormFields(this.documentCustomFieldService.list(new DocumentVO(document.getId())));
            }
            dynamicDocumentData = dynamicDocumentData2;
        } else if (document instanceof UserDocument) {
            UserDocument userDocument = (UserDocument)document;
            UserDocumentData userDocumentData = new UserDocumentData();
            userDocumentData.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)userDocument.getUser()));
            userDocumentData.setFile((RawFileVO)this.conversionHandler.convert(RawFileVO.class, (Object)userDocument.getFile()));
            dynamicDocumentData = userDocumentData;
        } else {
            StaticDocument staticDocument = (StaticDocument)document;
            StaticDocumentData staticDocumentData = new StaticDocumentData();
            staticDocumentData.setFile((RawFileVO)this.conversionHandler.convert(RawFileVO.class, (Object)staticDocument.getFile()));
            if (document.isPersistent()) {
                SessionData sessionData = this.getSessionData();
                RequestData requestData = sessionData.getRequestData();
                String string = requestData.getBaseUrl();
                if (StringHelper.isBlank((Object)string)) {
                    string = this.getSessionData().getConfiguration().getFullUrl();
                }
                string = StringHelper.removeEnd((String)string, (String)"/");
                staticDocumentData.setClassicUrlTemplate(string + "/content/document/{key}");
                staticDocumentData.setNewUrlTemplate(string + "/api/documents/{key}/file");
            }
            dynamicDocumentData = staticDocumentData;
        }
        dynamicDocumentData.setDto((EntityDTO)((DocumentDTO)this.toDTO(document)));
        if (dynamicDocumentData instanceof SharedDocumentData) {
            ((SharedDocumentData)dynamicDocumentData).setCategories(this.conversionHandler.convertList(DocumentCategoryVO.class, (Iterable)this.documentCategoryService.getDocumentCategoriesManage()));
        }
        return dynamicDocumentData;
    }

    @Override
    protected CRUDServiceImpl.EntityMetadata getMetadataForInternalNameValidations(DocumentDTO documentDTO) {
        if (documentDTO instanceof SharedDocumentDTO) {
            return this.ensureEntityMetadata(SharedDocument.class);
        }
        return null;
    }

    @Override
    protected Pair<DBQuery<?>, String> getUniqueNameQuery(DocumentDTO documentDTO) {
        if (documentDTO instanceof UserDocumentDTO && EntityVO.id((EntityVO)((UserDocumentDTO)documentDTO).getUser()) != null) {
            UserVO userVO = ((UserDocumentDTO)documentDTO).getUser();
            QUserDocument qUserDocument = QUserDocument.userDocument;
            QDocument qDocument = QDocument.document;
            DBQuery<?> dBQuery = this.from(new EntityPath[]{qDocument});
            dBQuery.where((Predicate)qDocument.name.equalsIgnoreCase(documentDTO.getName()));
            DBQuery dBQuery2 = (DBQuery)this.subQuery(new EntityPath[]{qUserDocument}).where(new Predicate[]{qUserDocument.id.eq((Expression)qDocument.id), qUserDocument.user().id.eq((Object)userVO.getId())});
            dBQuery.where((Predicate)qDocument.nature.ne((Object)DocumentNature.USER).or((Predicate)dBQuery2.exists()));
            if (documentDTO.isPersistent()) {
                dBQuery.where((Predicate)qDocument.id.ne((Object)documentDTO.getId()));
            }
            return Pair.create(dBQuery, null);
        }
        return super.getUniqueNameQuery(documentDTO);
    }

    @Override
    protected void onBeforeRemove(Document document) {
        DocumentFile documentFile;
        if (document.getNature().supportFile() && (documentFile = this.getFile(document)) != null) {
            this.setFile(null, document);
            this.storedFileHandler.remove(documentFile.getId().longValue());
        }
    }

    @Override
    protected Object onBeforeSave(Document document, Document document2) {
        UserDocument userDocument;
        if (document instanceof UserDocument && !(userDocument = (UserDocument)document).isBrokerVisible()) {
            userDocument.setBrokerManageable(false);
        }
        return super.onBeforeSave(document, document2);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QDocument)this.$).network());
    }

    @Override
    protected Validator resolveValidator(DocumentDTO documentDTO) {
        Validator validator = new Validator();
        Boolean bl = (Boolean)documentDTO.getAttribute("requireFile");
        if (Boolean.TRUE.equals(bl)) {
            validator.general(object -> new ValidationError(GeneralKeys.Errors.REQUIRED, new Object[]{GeneralKeys.Ui.UPLOAD_FILE}));
        }
        if (documentDTO instanceof DynamicDocumentDTO) {
            validator.property((Property)DynamicDocumentDTO.CONTENT, ContentManagementKeys.Documents.CONTENT).required();
        } else if (documentDTO instanceof UserDocumentDTO && documentDTO.isTransient()) {
            validator.property((Property)UserDocumentDTO.USER, ContentManagementKeys.Documents.USER).required();
        }
        if (documentDTO instanceof SharedDocumentDTO) {
            validator.property((Property)SharedDocumentDTO.CATEGORY, ContentManagementKeys.Documents.CATEGORY).required();
        }
        return validator;
    }

    @Override
    protected BidiMap<Class<? extends Document>, Class<? extends DocumentDTO>> subClassMappings() {
        return SUBCLASS_MAPPINGS;
    }

    private void checkDocumentFileSupport(Document document) {
        if (!document.getNature().supportFile()) {
            throw new IllegalArgumentException(String.format("The document with nature %s doesn't support files", new Object[0]));
        }
    }

    private Page<DocumentVO> doSearch(DocumentQuery documentQuery, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        DBQuery dBQuery;
        QUser qUser;
        Object object;
        DocumentRange documentRange;
        SessionData sessionData = this.getSessionData();
        DBQuery<?> dBQuery2 = this.from();
        if (bl2 && sessionData.isAdmin() && this.groupsHandler.accessibles().users().isEmpty()) {
            bl2 = false;
        }
        if ((documentRange = documentQuery.getDocumentRange()) == null) {
            if (!bl && bl2) {
                documentRange = DocumentRange.INDIVIDUAL;
            } else if (bl && !bl2) {
                documentRange = DocumentRange.SHARED;
            } else if (!bl && !bl2) {
                return QueryHelper.emptyPage((SessionData)sessionData, (QueryParameters)documentQuery);
            }
        }
        if (documentRange != null) {
            switch (documentRange) {
                case SHARED: {
                    dBQuery2.where((Predicate)((QDocument)this.$).discriminator.in((Object[])new DocumentNature[]{DocumentNature.STATIC, DocumentNature.DYNAMIC}));
                    break;
                }
                case INDIVIDUAL: {
                    dBQuery2.where((Predicate)((QDocument)this.$).discriminator.eq((Object)DocumentNature.USER));
                }
            }
        }
        if (QueryHelper.useParameter((Object)documentQuery.getKeywords())) {
            dBQuery2.where((Predicate)((QDocument)this.$).name.containsIgnoreCase(documentQuery.getKeywords()).or((Predicate)((QDocument)this.$).description.containsIgnoreCase(documentQuery.getKeywords())));
        }
        if (QueryHelper.useParameter((Object)documentQuery.getEnabled())) {
            dBQuery2.where((Predicate)((QDocument)this.$).enable.eq(documentQuery.getEnabled()));
        }
        if (bl && !(object = this.conversionHandler.convertSet(DocumentCategory.class, (Iterable)documentQuery.getCategories())).isEmpty()) {
            qUser = QSharedDocument.sharedDocument;
            dBQuery = (DBQuery)this.subQuery(new EntityPath[]{qUser}).where(new Predicate[]{qUser.id.eq((Expression)((QDocument)this.$).id), qUser.category().in((Collection)object)});
            dBQuery2.where((Predicate)dBQuery.exists().or((Predicate)((QDocument)this.$).discriminator.eq((Object)DocumentNature.USER)));
        }
        if (bl2) {
            Set set;
            User user;
            object = QUserDocument.userDocument;
            qUser = QUser.user;
            dBQuery = (DBQuery)((DBQuery)this.subQuery(new EntityPath[]{object}).innerJoin((EntityPath)object.user(), (Path)qUser)).where((Predicate)object.eq((Expression)this.$));
            if (bl3) {
                dBQuery.where((Predicate)((QUserDocument)object).memberVisible.isTrue());
            }
            if (bl4) {
                dBQuery.where((Predicate)((QUserDocument)object).brokerVisible.isTrue());
            }
            if ((user = (User)this.conversionHandler.convert(User.class, (Object)documentQuery.getUser())) != null) {
                dBQuery.where((Predicate)qUser.eq((Object)user));
            }
            if (!(set = this.groupsHandler.flattenVOs((Collection)documentQuery.getGroups())).isEmpty()) {
                dBQuery.where((Predicate)qUser.group().in((Collection)set));
            }
            this.visibility(dBQuery, qUser).onlySelf();
            Set set2 = this.conversionHandler.convertSet(User.class, (Iterable)documentQuery.getBrokers());
            if (!set2.isEmpty()) {
                dBQuery.where((Predicate)((QUser)qUser.brokers.any()).in((Collection)set2));
            }
            dBQuery2.where((Predicate)dBQuery.exists().or((Predicate)((QDocument)this.$).discriminator.ne((Object)DocumentNature.USER)));
        }
        dBQuery2.orderBy(((QDocument)this.$).name.asc());
        object = dBQuery2.page(Document.class, (QueryParameters)documentQuery, (Expression)this.$);
        return this.conversionHandler.convertPage(VO_MAPPINGS, (Iterable)object);
    }

    private DocumentFile getFile(Document document) {
        if (document == null) {
            return null;
        }
        this.checkDocumentFileSupport(document);
        if (document instanceof StaticDocument) {
            return ((StaticDocument)document).getFile();
        }
        return ((UserDocument)document).getFile();
    }

    private void setFile(DocumentFile documentFile, Document document) {
        if (document == null) {
            throw new NullPointerException("Can't set the file. Document is null");
        }
        this.checkDocumentFileSupport(document);
        if (document instanceof StaticDocument) {
            ((StaticDocument)document).setFile(documentFile);
        } else if (document instanceof UserDocument) {
            ((UserDocument)document).setFile(documentFile);
        }
    }

    private static /* synthetic */ Object lambda$processDynamicDocument$2(Map map, FormatterImpl formatterImpl, String string) {
        return map.containsKey(string) ? formatterImpl.format(map.get(string)) : null;
    }

    static {
        SUBCLASS_MAPPINGS.put(StaticDocument.class, StaticDocumentDTO.class);
        SUBCLASS_MAPPINGS.put(DynamicDocument.class, DynamicDocumentDTO.class);
        SUBCLASS_MAPPINGS.put(UserDocument.class, UserDocumentDTO.class);
        SUBCLASS_MAPPINGS.put(SharedDocument.class, SharedDocumentDTO.class);
        VO_MAPPINGS.put(UserDocument.class, UserDocumentVO.class);
        VO_MAPPINGS.put(DynamicDocument.class, DynamicDocumentVO.class);
        VO_MAPPINGS.put(StaticDocument.class, StaticDocumentVO.class);
    }
}

