/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.contentmanagement;

import com.google.common.hash.Hashing;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Supplier;
import org.cyclos.entities.contentmanagement.BaseHelpContent;
import org.cyclos.entities.contentmanagement.BaseStaticContent;
import org.cyclos.entities.contentmanagement.DataTranslation;
import org.cyclos.entities.contentmanagement.HeaderContent;
import org.cyclos.entities.contentmanagement.QDataTranslation;
import org.cyclos.entities.contentmanagement.Theme;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.access.InitializationServiceLocal;
import org.cyclos.impl.access.InternalAuthServiceLocal;
import org.cyclos.impl.access.LoginServiceLocal;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.TrustedDeviceServiceLocal;
import org.cyclos.impl.contentmanagement.InternalUiServiceLocal;
import org.cyclos.impl.contentmanagement.StaticContentServiceLocal;
import org.cyclos.impl.contentmanagement.ThemeServiceLocal;
import org.cyclos.impl.marketplace.OrderServiceLocal;
import org.cyclos.impl.mobile.InternalMobileServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.users.UserRegionalSettingsServiceLocal;
import org.cyclos.impl.users.UserServiceLocal;
import org.cyclos.impl.utils.RichTextHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.TranslatableUIElementResultVO;
import org.cyclos.model.TranslatableVersionedVO;
import org.cyclos.model.VersionedVO;
import org.cyclos.model.access.pins.PinLocatorVO;
import org.cyclos.model.contentmanagement.BaseGetVersionedDataParams;
import org.cyclos.model.contentmanagement.GetVersionedDataParams;
import org.cyclos.model.contentmanagement.ThemeResultVO;
import org.cyclos.model.contentmanagement.UIElementResultVO;
import org.cyclos.model.contentmanagement.staticcontents.ContentVO;
import org.cyclos.model.contentmanagement.staticcontents.HelpContentDefinitionType;
import org.cyclos.model.contentmanagement.themes.ThemeType;
import org.cyclos.model.system.wizards.CustomWizardVO;
import org.cyclos.server.model.contentmanagement.UiData;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.MutableObject;
import org.cyclos.utils.Pair;
import org.eclipse.persistence.internal.helper.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InternalUiServiceImpl
extends BaseServiceImpl
implements InternalUiServiceLocal {
    @Autowired
    private InternalMobileServiceLocal internalMobileService;
    @Autowired
    private InitializationServiceLocal initializationServiceLocal;
    @Autowired
    private TrustedDeviceServiceLocal trustedDeviceService;
    @Autowired
    private ThemeServiceLocal themeService;
    @Autowired
    private StaticContentServiceLocal staticContentService;
    @Autowired
    private UserServiceLocal userService;
    @Autowired
    private LoginServiceLocal loginService;
    @Autowired
    private InternalAuthServiceLocal internalAuthService;
    @Autowired
    private OrderServiceLocal orderService;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private UserRegionalSettingsServiceLocal userRegionalSettingsService;
    @Autowired
    private RichTextHandler richTextHandler;

    public UiData getData(ThemeType themeType, boolean bl, Long l, PinLocatorVO pinLocatorVO, GetVersionedDataParams getVersionedDataParams) {
        SessionData sessionData = this.getSessionData();
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        Theme theme = null;
        HeaderContent headerContent = null;
        HeaderContent headerContent2 = null;
        UiData uiData = new UiData();
        uiData.setBasicInitializationData(this.initializationServiceLocal.getBasicInitializationData());
        uiData.setHideUserSearchInMenu(this.initializationServiceLocal.isHideUserSearchInMenu());
        uiData.setLocalesData(this.userRegionalSettingsService.getLocalesData());
        if (sessionData.isGuest()) {
            uiData.setLoginData(this.loginService.getLoginData(sessionData.getChannel(), l, pinLocatorVO));
            uiData.setPublicRegistrationGroups(this.userService.getPublicRegistrationGroups());
            uiData.setLargeScreenRegistrationWizard((CustomWizardVO)this.conversionHandler.convert(CustomWizardVO.class, (Object)configurationAccessor.getLargeScreenRegistrationWizard()));
            uiData.setMediumScreenRegistrationWizard((CustomWizardVO)this.conversionHandler.convert(CustomWizardVO.class, (Object)configurationAccessor.getMediumScreenRegistrationWizard()));
            uiData.setSmallScreenRegistrationWizard((CustomWizardVO)this.conversionHandler.convert(CustomWizardVO.class, (Object)configurationAccessor.getSmallScreenRegistrationWizard()));
        } else {
            uiData.setDeviceActivationMode(this.trustedDeviceService.getDeviceActivationMode());
            uiData.setShoppingCartWebShopCount(Integer.valueOf(this.orderService.countCartItems()));
        }
        uiData.setAuth(this.internalAuthService.getCurrentAuth());
        if (themeType != null) {
            switch (themeType) {
                case MAIN_WEB: {
                    headerContent2 = configurationAccessor.getHeaderContent();
                    headerContent = configurationAccessor.getFooterContent();
                    theme = this.isGuest() ? configurationAccessor.getGuestsTheme() : configurationAccessor.getUsersTheme();
                    break;
                }
                case PAY: {
                    headerContent2 = configurationAccessor.getPayHeaderContent();
                    headerContent = configurationAccessor.getPayFooterContent();
                    theme = configurationAccessor.getPayTheme();
                    break;
                }
                case APP: {
                    theme = configurationAccessor.getAppTheme();
                    break;
                }
                case MOBILE: {
                    this.internalMobileService.getContentHandler((BaseGetVersionedDataParams)getVersionedDataParams).setHeader(arg_0 -> ((UiData)uiData).setHeader(arg_0)).setFooter(arg_0 -> ((UiData)uiData).setFooter(arg_0)).setTheme(arg_0 -> ((UiData)uiData).setTheme(arg_0), true);
                    return uiData;
                }
            }
            uiData.setHeader(this.toTranslatableUIElementResultVO((BaseStaticContent)headerContent2, getVersionedDataParams.getHeader()));
            uiData.setFooter(this.toTranslatableUIElementResultVO((BaseStaticContent)headerContent, getVersionedDataParams.getFooter()));
            uiData.setTheme(this.toThemeResultVO(theme, bl, getVersionedDataParams.getTheme(), getVersionedDataParams.getCyclosVersion()));
        }
        if (themeType != ThemeType.MOBILE) {
            uiData.setAppleStoreUrlMobile(configurationAccessor.getAppleStoreUrlMobile());
            uiData.setPlayStoreUrlMobile(configurationAccessor.getPlayStoreUrlMobile());
        }
        return uiData;
    }

    public ThemeResultVO toThemeResultVO(Theme theme, boolean bl, VersionedVO versionedVO, String string) {
        if (!InternalUiServiceLocal.changed(() -> theme, (VersionedVO)versionedVO, (String)string)) {
            return null;
        }
        if (bl) {
            ThemeResultVO themeResultVO = this.toUIElementResultVO(ThemeResultVO.class, theme.getId(), theme.getVersion(), null);
            themeResultVO.setDefinitions(this.themeService.getDefinitionsAsString(theme));
            themeResultVO.setAdvancedDefinitions(theme.getAdvancedDefinitions());
            themeResultVO.setCustomStyle(theme.getCustomStyle());
            return themeResultVO;
        }
        return this.toUIElementResultVO(ThemeResultVO.class, theme.getId(), theme.getVersion(), this.themeService.getCSS(theme));
    }

    public TranslatableUIElementResultVO toTranslatableUIElementResultVO(BaseHelpContent baseHelpContent, TranslatableVersionedVO translatableVersionedVO) {
        if (baseHelpContent.getDefinitionType() == HelpContentDefinitionType.ORIGINAL) {
            return this.toTranslatableUIElementResultVO((BaseStaticContent)baseHelpContent, translatableVersionedVO, () -> Pair.create((Object)false, null), () -> this.richTextHandler.replaceTagsByUrls(this.staticContentService.getHelpOrOriginalContent(baseHelpContent), this.getSessionData().getConfiguration()));
        }
        return this.toTranslatableUIElementResultVO((BaseStaticContent)baseHelpContent, translatableVersionedVO);
    }

    public TranslatableUIElementResultVO toTranslatableUIElementResultVO(BaseStaticContent baseStaticContent, TranslatableVersionedVO translatableVersionedVO) {
        return this.toTranslatableUIElementResultVO(baseStaticContent, translatableVersionedVO, () -> this.changed(baseStaticContent, translatableVersionedVO), () -> ((ContentVO)this.conversionHandler.convert(ContentVO.class, (Object)baseStaticContent)).getContent());
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
    }

    private String calcContentHash(String string) {
        return StringHelper.isBlank((String)string) ? null : Hashing.sha256().hashString((CharSequence)string, StandardCharsets.UTF_8).toString();
    }

    private Pair<Boolean, DataTranslation> changed(BaseStaticContent baseStaticContent, TranslatableVersionedVO translatableVersionedVO) {
        DataTranslation dataTranslation = null;
        boolean bl = false;
        if (translatableVersionedVO == null || Boolean.TRUE.equals(translatableVersionedVO.getForce()) || translatableVersionedVO.getDataTranslationId() == null || translatableVersionedVO.getDataTranslationVersion() == null) {
            dataTranslation = this.findDataTranslation(baseStaticContent, null);
            bl = dataTranslation != null;
        } else {
            dataTranslation = this.findDataTranslation(baseStaticContent, translatableVersionedVO.getDataTranslationId());
            if (dataTranslation != null) {
                bl = !Objects.equals(dataTranslation.getVersion(), translatableVersionedVO.getDataTranslationVersion());
            } else {
                bl = true;
                dataTranslation = this.findDataTranslation(baseStaticContent, null);
            }
        }
        return Pair.create((Object)bl, (Object)dataTranslation);
    }

    private DataTranslation findDataTranslation(BaseStaticContent baseStaticContent, Long l) {
        QDataTranslation qDataTranslation = QDataTranslation.dataTranslation;
        DBQuery dBQuery = (DBQuery)this.rawEntityManagerHandler.selectFrom((EntityPath)qDataTranslation).where(new Predicate[]{qDataTranslation.language().eq((Object)this.getConfiguration().getLanguage()), qDataTranslation.entityId.eq((Object)baseStaticContent.getId()), qDataTranslation.propertyName.eq((Object)ContentVO.CONTENT.getName())});
        if (l != null) {
            dBQuery.where((Predicate)qDataTranslation.id.eq((Object)l));
        }
        return (DataTranslation)dBQuery.fetchFirst();
    }

    private TranslatableUIElementResultVO toTranslatableUIElementResultVO(BaseStaticContent baseStaticContent, TranslatableVersionedVO translatableVersionedVO, Supplier<Pair<Boolean, DataTranslation>> supplier, Supplier<String> supplier2) {
        if (baseStaticContent == null || translatableVersionedVO != null && Boolean.FALSE.equals(translatableVersionedVO.getForce())) {
            return null;
        }
        Pair<Boolean, DataTranslation> pair = supplier.get();
        MutableObject mutableObject = new MutableObject();
        Supplier<String> supplier3 = () -> {
            if (mutableObject.get() == null) {
                mutableObject.set((Object)this.calcContentHash((String)supplier2.get()));
            }
            return (String)mutableObject.get();
        };
        if (translatableVersionedVO == null || Boolean.TRUE.equals(translatableVersionedVO.getForce()) || ((Boolean)pair.getFirst()).booleanValue() || InternalUiServiceLocal.changed(() -> this.staticContentService.ensureLastModifiedDate(baseStaticContent), (String)supplier3.get(), (TranslatableVersionedVO)translatableVersionedVO)) {
            return this.toTranslatableUIElementResultVO(baseStaticContent.getId(), baseStaticContent.getVersion(), supplier2.get(), supplier3.get(), (DataTranslation)pair.getSecond());
        }
        return null;
    }

    private TranslatableUIElementResultVO toTranslatableUIElementResultVO(Long l, Integer n, String string, String string2, DataTranslation dataTranslation) {
        TranslatableUIElementResultVO translatableUIElementResultVO = new TranslatableUIElementResultVO();
        translatableUIElementResultVO.setId(l);
        translatableUIElementResultVO.setContent(string);
        translatableUIElementResultVO.setVersion(n);
        translatableUIElementResultVO.setContentHash(string2);
        if (dataTranslation != null) {
            translatableUIElementResultVO.setDataTranslationId(dataTranslation.getId());
            translatableUIElementResultVO.setDataTranslationVersion(dataTranslation.getVersion());
        }
        return translatableUIElementResultVO;
    }

    private <T extends UIElementResultVO> T toUIElementResultVO(Class<T> clazz, Long l, Integer n, String string) {
        UIElementResultVO uIElementResultVO = (UIElementResultVO)ClassHelper.instantiate(clazz);
        uIElementResultVO.setId(l);
        uIElementResultVO.setContent(string);
        uIElementResultVO.setVersion(n);
        return (T)uIElementResultVO;
    }
}

