/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.contentmanagement;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.cyclos.entities.contentmanagement.FloatingPage;
import org.cyclos.entities.contentmanagement.MenuEntry;
import org.cyclos.entities.contentmanagement.MenuGroup;
import org.cyclos.entities.contentmanagement.MenuItem;
import org.cyclos.entities.contentmanagement.QMenuEntry;
import org.cyclos.entities.contentmanagement.QMenuGroup;
import org.cyclos.entities.contentmanagement.QMenuItem;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.system.CustomOperation;
import org.cyclos.entities.system.MenuItemWizard;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.contentmanagement.BaseContentItemServiceImpl;
import org.cyclos.impl.contentmanagement.MenuEntryServiceLocal;
import org.cyclos.impl.system.CustomOperationServiceLocal;
import org.cyclos.impl.system.CustomWizardServiceLocal;
import org.cyclos.impl.utils.persistence.CustomProjection;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.contentmanagement.contentitems.ContentItemVisibility;
import org.cyclos.model.contentmanagement.contentitems.FloatingPageDTO;
import org.cyclos.model.contentmanagement.contentitems.FloatingPageVO;
import org.cyclos.model.contentmanagement.contentitems.FrontendContentLayout;
import org.cyclos.model.contentmanagement.contentitems.MenuEntriesListData;
import org.cyclos.model.contentmanagement.contentitems.MenuEntryDTO;
import org.cyclos.model.contentmanagement.contentitems.MenuEntryData;
import org.cyclos.model.contentmanagement.contentitems.MenuEntryDataParams;
import org.cyclos.model.contentmanagement.contentitems.MenuEntryNature;
import org.cyclos.model.contentmanagement.contentitems.MenuEntryVO;
import org.cyclos.model.contentmanagement.contentitems.MenuGroupDTO;
import org.cyclos.model.contentmanagement.contentitems.MenuGroupDetailedVO;
import org.cyclos.model.contentmanagement.contentitems.MenuItemDTO;
import org.cyclos.model.contentmanagement.contentitems.MenuItemDetailedVO;
import org.cyclos.model.contentmanagement.contentitems.MenuItemType;
import org.cyclos.model.contentmanagement.contentitems.MenuItemVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.system.configurations.Frontend;
import org.cyclos.model.system.operations.CustomOperationScope;
import org.cyclos.model.system.operations.CustomOperationVO;
import org.cyclos.model.system.wizards.CustomWizardVO;
import org.cyclos.model.utils.FrontendMenu;
import org.cyclos.server.model.contentmanagement.contentitems.SitemapItemType;
import org.cyclos.server.model.contentmanagement.contentitems.SitemapItemVO;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MenuEntryServiceImpl
extends BaseContentItemServiceImpl<MenuEntry, QMenuEntry, MenuEntryDTO, MenuEntryData, MenuEntryDataParams>
implements MenuEntryServiceLocal {
    private static final BidiMap<Class<? extends MenuEntry>, Class<? extends MenuEntryDTO>> SUBCLASS_MAPPINGS = new DualHashBidiMap();
    private static final Map<Class<?>, Class<?>> ENTITY_TO_VO_MAPPINGS = new HashMap();
    @Autowired
    private CustomOperationServiceLocal customOperationService;
    @Autowired
    private CustomWizardServiceLocal customWizardService;

    public MenuEntryServiceImpl() {
        super(MenuEntry.class, QMenuEntry.menuEntry, MenuEntryDTO.class);
    }

    public MenuEntriesListData getListData(ConfigurationVO configurationVO) throws FrameworkException {
        MenuEntriesListData menuEntriesListData = new MenuEntriesListData();
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        menuEntriesListData.setConfiguration((ConfigurationVO)this.conversionHandler.convert(ConfigurationVO.class, (Object)configuration));
        menuEntriesListData.setMenuEntries(this.list(configurationVO));
        return menuEntriesListData;
    }

    public List<MenuEntryVO> getMenu(Frontend frontend) {
        Configuration configuration = this.getConfiguration().getConfiguration();
        EnumSet<ContentItemVisibility> enumSet = EnumSet.of(ContentItemVisibility.ALL, this.isGuest() ? ContentItemVisibility.GUESTS : ContentItemVisibility.USERS);
        boolean bl = frontend == Frontend.CLASSIC;
        List<MenuEntry> list = this.list(frontend, configuration, bl, enumSet, false);
        List list2 = this.customOperationService.getRunnableOperationsForMenu();
        List list3 = this.customWizardService.getRunnableWizardsForMenu();
        Predicate<MenuEntry> predicate = menuEntry -> {
            if (!enumSet.contains(menuEntry.getVisibility())) {
                return false;
            }
            if (menuEntry instanceof MenuItem) {
                MenuItem menuItem = (MenuItem)menuEntry;
                switch (menuItem.getType()) {
                    case CUSTOM_OPERATION: {
                        return list2.contains(menuItem.getCustomOperation());
                    }
                    case WIZARD: {
                        return list3.contains(menuItem.getWizard());
                    }
                }
                return true;
            }
            return true;
        };
        ArrayList<MenuEntryVO> arrayList = new ArrayList<MenuEntryVO>(list.size());
        for (MenuEntry menuEntry2 : list) {
            MenuEntryVO menuEntryVO = null;
            if (menuEntry2 instanceof MenuGroup) {
                MenuGroup menuGroup = (MenuGroup)menuEntry2;
                MenuGroupDetailedVO menuGroupDetailedVO = (MenuGroupDetailedVO)this.conversionHandler.convertExcluding(MenuGroupDetailedVO.class, (Object)menuGroup, new Object[]{"entries"});
                ArrayList<MenuEntryVO> arrayList2 = new ArrayList<MenuEntryVO>(menuGroup.getEntries().size());
                for (MenuEntry menuEntry3 : menuGroup.getEntries()) {
                    if (!predicate.test(menuEntry3)) continue;
                    arrayList2.add((MenuEntryVO)this.conversionHandler.convert(MenuItemVO.class, (Object)menuEntry3));
                }
                menuGroupDetailedVO.setEntries(arrayList2);
                menuEntryVO = menuGroupDetailedVO;
            } else if (predicate.test(menuEntry2)) {
                menuEntryVO = (MenuEntryVO)this.conversionHandler.convert(MenuItemVO.class, (Object)menuEntry2);
            }
            if (menuEntryVO == null) continue;
            arrayList.add(menuEntryVO);
        }
        return arrayList;
    }

    public MenuItemDetailedVO getMenuItemDetails(MenuItemVO menuItemVO) throws FrameworkException {
        MenuItem menuItem = (MenuItem)this.conversionHandler.convert(MenuItem.class, (Object)menuItemVO);
        MenuItemDetailedVO menuItemDetailedVO = (MenuItemDetailedVO)this.conversionHandler.convert(MenuItemDetailedVO.class, (Object)menuItem);
        return menuItemDetailedVO;
    }

    public List<MenuEntryVO> list(ConfigurationVO configurationVO) throws FrameworkException {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        List<MenuEntry> list = this.list(null, configuration, false, Arrays.asList(ContentItemVisibility.values()), true);
        return this.conversionHandler.convertList(ENTITY_TO_VO_MAPPINGS, list);
    }

    public List<MenuEntry> list(Frontend frontend, Configuration configuration, boolean bl, Collection<ContentItemVisibility> collection, boolean bl2) {
        List list = this.configurationHandler.getAncestors(configuration);
        QMenuGroup qMenuGroup = QMenuGroup.menuGroup;
        DBQuery dBQuery = (DBQuery)((DBQuery)this.fromCacheable(this.$).leftJoin((EntityPath)((QMenuEntry)this.$).group(), (Path)qMenuGroup)).where(new com.querydsl.core.types.Predicate[]{((QMenuEntry)this.$).configuration().in((Collection)list), ((QMenuEntry)this.$).visibility.in(collection)});
        if (bl) {
            dBQuery.where((com.querydsl.core.types.Predicate)qMenuGroup.id.isNull());
        }
        dBQuery.where((com.querydsl.core.types.Predicate)((QMenuEntry)this.$).nature.ne((Object)MenuEntryNature.FLOATING_PAGE));
        if (frontend == Frontend.CLASSIC) {
            dBQuery.where((com.querydsl.core.types.Predicate)((QMenuEntry)this.$).showInClassicFrontend.isTrue().or((com.querydsl.core.types.Predicate)((QMenuEntry)this.$).nature.eq((Object)MenuEntryNature.GROUP)));
        } else if (frontend == Frontend.NEW) {
            dBQuery.where((com.querydsl.core.types.Predicate)((QMenuEntry)this.$).showInNewFrontend.isTrue());
        }
        List list2 = ((DBQuery)dBQuery.orderBy(new OrderSpecifier[]{((QMenuEntry)this.$).configuration().nameHierarchy().asc(), ((QMenuEntry)this.$).orderHierarchy().asc()})).list((Expression)this.$);
        if (bl2) {
            dBQuery = (DBQuery)this.from().where(new com.querydsl.core.types.Predicate[]{((QMenuEntry)this.$).configuration().in((Collection)list), ((QMenuEntry)this.$).visibility.in(collection), ((QMenuEntry)this.$).nature.eq((Object)MenuEntryNature.FLOATING_PAGE)});
            list2.addAll(dBQuery.list((Expression)this.$));
        }
        return list2;
    }

    public List<MenuItem> listByWizard(MenuItemWizard menuItemWizard) {
        QMenuItem qMenuItem = QMenuItem.menuItem;
        return ((DBQuery)((DBQuery)this.selectFromCacheable(qMenuItem).where((com.querydsl.core.types.Predicate)qMenuItem.wizard().eq((Object)menuItemWizard))).orderBy(qMenuItem.order.asc())).fetch();
    }

    public List<SitemapItemVO> listForSitemap() {
        CustomProjection<SitemapItemVO> customProjection = new CustomProjection<SitemapItemVO>(SitemapItemVO.class){
            private static final long serialVersionUID = 1L;
            {
                this.add(new Expression[]{((QMenuEntry)((MenuEntryServiceImpl)MenuEntryServiceImpl.this).$).id, ((QMenuEntry)((MenuEntryServiceImpl)MenuEntryServiceImpl.this).$).lastModified});
            }

            protected SitemapItemVO instantiate() {
                SitemapItemVO sitemapItemVO = new SitemapItemVO();
                sitemapItemVO.setType(SitemapItemType.MENU_ITEM);
                sitemapItemVO.setId((Long)this.get((Expression)((QMenuEntry)((MenuEntryServiceImpl)MenuEntryServiceImpl.this).$).id));
                Date date = (Date)this.get((Expression)((QMenuEntry)((MenuEntryServiceImpl)MenuEntryServiceImpl.this).$).lastModified);
                if (date != null) {
                    sitemapItemVO.setLastModifiedMillis(String.valueOf(date.getTime()));
                }
                return sitemapItemVO;
            }
        };
        QMenuItem qMenuItem = QMenuItem.menuItem;
        return ((DBQuery)((DBQuery)((DBQuery)this.fromCacheable(this.$).leftJoin((EntityPath)qMenuItem)).on((com.querydsl.core.types.Predicate)((QMenuEntry)this.$).id.eq((Expression)qMenuItem.id))).where(new com.querydsl.core.types.Predicate[]{((QMenuEntry)this.$).nature.in((Object[])new MenuEntryNature[]{MenuEntryNature.FLOATING_PAGE, MenuEntryNature.ITEM}), ((QMenuEntry)this.$).visibility.in((Object[])new ContentItemVisibility[]{ContentItemVisibility.GUESTS, ContentItemVisibility.ALL}), ((QMenuEntry)this.$).nature.ne((Object)MenuEntryNature.ITEM).or((com.querydsl.core.types.Predicate)qMenuItem.type.eq((Object)MenuItemType.CONTENT))})).list((Expression)customProjection);
    }

    public void move(Long l, boolean bl) throws EntityNotFoundException {
        boolean bl2;
        MenuEntry menuEntry = (MenuEntry)this.find(l);
        if (menuEntry instanceof FloatingPage) {
            throw new IllegalArgumentException();
        }
        MenuGroup menuGroup = menuEntry.getGroup();
        List list = ((DBQuery)((DBQuery)this.from().where(new com.querydsl.core.types.Predicate[]{((QMenuEntry)this.$).configuration().eq((Object)menuEntry.getConfiguration()), ((QMenuEntry)this.$).nature.ne((Object)MenuEntryNature.FLOATING_PAGE), menuGroup == null ? ((QMenuEntry)this.$).group().isNull() : ((QMenuEntry)this.$).group().eq((Object)menuGroup)})).orderBy(((QMenuEntry)this.$).order.asc())).list((Expression)this.$);
        int n = list.indexOf(menuEntry);
        boolean bl3 = bl2 = bl && n < 1 || !bl && n >= list.size() - 1;
        if (!bl2) {
            MenuEntry menuEntry2 = (MenuEntry)list.get(bl ? n - 1 : n + 1);
            int n2 = menuEntry.getOrder();
            menuEntry.setOrder(menuEntry2.getOrder());
            menuEntry2.setOrder(Integer.valueOf(n2));
        }
    }

    @Override
    public MenuEntry newEntity(MenuEntryDataParams menuEntryDataParams) {
        MenuGroup menuGroup;
        switch (menuEntryDataParams.getNature()) {
            case GROUP: {
                menuGroup = new MenuGroup();
                break;
            }
            case ITEM: {
                MenuItem menuItem = new MenuItem();
                menuItem.setShowInClassicFrontend(true);
                menuItem.setShowInNewFrontend(true);
                menuItem.setFrontendMenu(FrontendMenu.CONTENT);
                menuItem.setFrontendLayout(FrontendContentLayout.CARD);
                menuGroup = menuItem;
                break;
            }
            case FLOATING_PAGE: {
                menuGroup = new FloatingPage();
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled menu entry nature: " + String.valueOf(menuEntryDataParams.getNature()));
            }
        }
        menuGroup.setConfiguration((Configuration)this.conversionHandler.convert(Configuration.class, (Object)menuEntryDataParams.getConfiguration()));
        return menuGroup;
    }

    @Override
    protected MenuEntryData getData(MenuEntry menuEntry) {
        MenuEntryData menuEntryData = new MenuEntryData();
        menuEntryData.setDto((EntityDTO)((MenuEntryDTO)this.toDTO(menuEntry)));
        if (menuEntry instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)menuEntry;
            QMenuGroup qMenuGroup = QMenuGroup.menuGroup;
            List list = ((DBQuery)((DBQuery)this.from(new EntityPath[]{qMenuGroup}).where((com.querydsl.core.types.Predicate)qMenuGroup.configuration().eq((Object)menuItem.getConfiguration()))).orderBy(qMenuGroup.order.asc())).list(MenuEntryVO.class, (Expression)qMenuGroup);
            menuEntryData.setGroups(list);
            menuEntryData.setCustomOperations(this.conversionHandler.convertList(CustomOperationVO.class, (Iterable)this.customOperationService.listByScope(new CustomOperationScope[]{CustomOperationScope.MENU})));
            menuEntryData.setWizards(this.conversionHandler.convertList(CustomWizardVO.class, (Iterable)this.customWizardService.listMenuWizards()));
            if (menuItem.isPersistent()) {
                String string;
                Configuration configuration;
                SessionData sessionData = this.getSessionData();
                Configuration configuration2 = this.find(Configuration.class, sessionData.getRequestData().getConfigurationId());
                if (!configuration2.equals((Object)(configuration = menuItem.getConfiguration())) && this.configurationHandler.getAncestors(configuration).contains(configuration2)) {
                    string = this.configurationHandler.getAccessor(configuration).getFullUrl();
                } else {
                    RequestData requestData = sessionData.getRequestData();
                    string = requestData.getBaseUrl();
                    if (StringHelper.isBlank((Object)string)) {
                        string = this.getSessionData().getConfiguration().getFullUrl();
                    }
                }
                string = StringHelper.removeEnd((String)string, (String)"/");
                menuEntryData.setClassicUrlTemplate(string + "/#page-content!page={key}");
                menuEntryData.setNewUrlTemplate(string + "/ui/page/{key}");
            }
        }
        return menuEntryData;
    }

    @Override
    protected Pair<DBQuery<?>, String> getUniqueNameQuery(MenuEntryDTO menuEntryDTO) {
        Pair<DBQuery<?>, String> pair = super.getUniqueNameQuery(menuEntryDTO);
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)menuEntryDTO.getConfiguration());
        ((DBQuery)pair.getFirst()).where((com.querydsl.core.types.Predicate)((QMenuEntry)this.$).configuration().eq((Object)configuration));
        return pair;
    }

    @Override
    protected void onAfterRemove(MenuEntry menuEntry) {
        this.configurationService.updateSitemapLastModified(menuEntry.getConfiguration());
    }

    @Override
    protected void onAfterSave(MenuEntry menuEntry, MenuEntry menuEntry2, Object object) {
        this.configurationService.updateSitemapLastModified(menuEntry.getConfiguration());
    }

    @Override
    protected Object onBeforeSave(MenuEntry menuEntry, MenuEntry menuEntry2) {
        menuEntry.setLastModified(new Date());
        if (menuEntry.getNature() != MenuEntryNature.FLOATING_PAGE && (menuEntry.isTransient() || !Objects.equals(menuEntry.getGroup(), menuEntry2.getGroup()))) {
            MenuGroup menuGroup = menuEntry.getGroup();
            Integer n = (Integer)((DBQuery)this.from().where(new com.querydsl.core.types.Predicate[]{((QMenuEntry)this.$).configuration().eq((Object)menuEntry.getConfiguration()), ((QMenuEntry)this.$).nature.ne((Object)MenuEntryNature.FLOATING_PAGE), menuGroup == null ? ((QMenuEntry)this.$).group().isNull() : ((QMenuEntry)this.$).group().eq((Object)menuGroup)})).singleResult((Expression)((QMenuEntry)this.$).order.max());
            menuEntry.setOrder(Integer.valueOf(n == null ? 0 : n + 1));
        }
        this.fixEntry(menuEntry);
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QMenuEntry)this.$).configuration().network(), true);
    }

    @Override
    protected Validator resolveValidator(MenuEntryDTO menuEntryDTO) {
        Validator validator = super.resolveValidator(menuEntryDTO);
        validator.property((Property)MenuEntryDTO.SVG_ICON, GeneralKeys.Ui.SVG_ICON).maxLength(200);
        if (menuEntryDTO instanceof MenuGroupDTO) {
            validator.property((Property)MenuGroupDTO.POSITION, ContentManagementKeys.ContentItems.MENU_POSITION).required();
        } else if (menuEntryDTO instanceof MenuItemDTO) {
            MenuItemDTO menuItemDTO = (MenuItemDTO)menuEntryDTO;
            validator.property((Property)MenuItemDTO.TYPE, ContentManagementKeys.ContentItems.MENU_TYPE).required();
            if (menuItemDTO.getType() != null) {
                switch (menuItemDTO.getType()) {
                    case CONTENT: {
                        validator.property((Property)MenuItemDTO.TITLE, ContentManagementKeys.ContentItems.MENU_TITLE).maxLength(100);
                        validator.property((Property)MenuItemDTO.CONTENT, ContentManagementKeys.ContentItems.MENU_CONTENT).required().maxLength(0x100000);
                        break;
                    }
                    case URL: {
                        validator.property((Property)MenuItemDTO.URL, ContentManagementKeys.ContentItems.MENU_URL).required().url().maxLength(255);
                        break;
                    }
                    case IFRAME: {
                        validator.property((Property)MenuItemDTO.TITLE, ContentManagementKeys.ContentItems.MENU_TITLE).maxLength(100);
                        validator.property((Property)MenuItemDTO.URL, ContentManagementKeys.ContentItems.MENU_URL).required().url().maxLength(255);
                        break;
                    }
                    case CUSTOM_OPERATION: {
                        validator.property((Property)MenuItemDTO.CUSTOM_OPERATION, ContentManagementKeys.ContentItems.MENU_CUSTOM_OPERATION).required().entity(CustomOperation.class, (EntityValidation)new BaseEntityValidation<CustomOperation>(){

                            protected boolean isValid(Object object, Object object2, CustomOperation customOperation) {
                                return customOperation.getScope() == CustomOperationScope.MENU;
                            }
                        });
                        break;
                    }
                    case WIZARD: {
                        validator.property((Property)MenuItemDTO.WIZARD, ContentManagementKeys.ContentItems.MENU_WIZARD).required().mustBeInstanceOf(MenuItemWizard.class);
                    }
                }
            }
        }
        return validator;
    }

    @Override
    protected BidiMap<Class<? extends MenuEntry>, Class<? extends MenuEntryDTO>> subClassMappings() {
        return SUBCLASS_MAPPINGS;
    }

    private void fixEntry(MenuEntry menuEntry) {
        if (menuEntry instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)menuEntry;
            if (menuItem.getType() != MenuItemType.CUSTOM_OPERATION) {
                menuItem.setCustomOperation(null);
            }
            if (menuItem.getType() != MenuItemType.WIZARD) {
                menuItem.setWizard(null);
            }
            if (menuItem.getType() != MenuItemType.CONTENT) {
                menuItem.setContent(null);
            }
            if (menuItem.getType() != MenuItemType.IFRAME && menuItem.getType() != MenuItemType.CONTENT || menuItem.getType() == MenuItemType.CONTENT && !menuItem.isShowInNewFrontend() && menuItem.getNature() != MenuEntryNature.FLOATING_PAGE) {
                menuItem.setFrontendLayout(null);
            }
            if (!menuItem.isShowInClassicFrontend()) {
                menuItem.setGroup(null);
            }
            if (!menuItem.isShowInNewFrontend()) {
                menuItem.setFrontendMenu(null);
            }
            if (menuItem.getType() != MenuItemType.URL && menuItem.getType() != MenuItemType.IFRAME) {
                menuItem.setUrl(null);
            }
        }
    }

    static {
        SUBCLASS_MAPPINGS.put(MenuGroup.class, MenuGroupDTO.class);
        SUBCLASS_MAPPINGS.put(MenuItem.class, MenuItemDTO.class);
        SUBCLASS_MAPPINGS.put(FloatingPage.class, FloatingPageDTO.class);
        ENTITY_TO_VO_MAPPINGS.put(MenuGroup.class, MenuGroupDetailedVO.class);
        ENTITY_TO_VO_MAPPINGS.put(MenuItem.class, MenuItemVO.class);
        ENTITY_TO_VO_MAPPINGS.put(FloatingPage.class, FloatingPageVO.class);
    }
}

