/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.contentmanagement;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.contentmanagement.AdminHelpContent;
import org.cyclos.entities.contentmanagement.BaseHelpContent;
import org.cyclos.entities.contentmanagement.BaseHomeContent;
import org.cyclos.entities.contentmanagement.BaseSectionContent;
import org.cyclos.entities.contentmanagement.BaseStaticContent;
import org.cyclos.entities.contentmanagement.EmailTemplate;
import org.cyclos.entities.contentmanagement.FooterContent;
import org.cyclos.entities.contentmanagement.FrontendDashboardContent;
import org.cyclos.entities.contentmanagement.FrontendFooterContent;
import org.cyclos.entities.contentmanagement.FrontendHelpContent;
import org.cyclos.entities.contentmanagement.FrontendHomeContent;
import org.cyclos.entities.contentmanagement.GuestHomeContent;
import org.cyclos.entities.contentmanagement.HasContentScript;
import org.cyclos.entities.contentmanagement.HeaderContent;
import org.cyclos.entities.contentmanagement.HomeContent;
import org.cyclos.entities.contentmanagement.LoggedUserHomeContent;
import org.cyclos.entities.contentmanagement.LoginFooterContent;
import org.cyclos.entities.contentmanagement.LoginHeaderContent;
import org.cyclos.entities.contentmanagement.MobileHelpContent;
import org.cyclos.entities.contentmanagement.MobilePosHelpContent;
import org.cyclos.entities.contentmanagement.PayFooterContent;
import org.cyclos.entities.contentmanagement.PayHeaderContent;
import org.cyclos.entities.contentmanagement.QBaseHelpContent;
import org.cyclos.entities.contentmanagement.QBaseStaticContent;
import org.cyclos.entities.contentmanagement.Theme;
import org.cyclos.entities.contentmanagement.UserHelpContent;
import org.cyclos.entities.contentmanagement.WelcomeContent;
import org.cyclos.entities.system.Configuration;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.contentmanagement.StaticContentServiceLocal;
import org.cyclos.impl.contentmanagement.ThemeImageServiceLocal;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ConfigurationServiceLocal;
import org.cyclos.impl.utils.LinkGeneratorHandler;
import org.cyclos.impl.utils.SerializablePredicate;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.notifications.ApplyMailTemplateParams;
import org.cyclos.impl.utils.notifications.MailHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.Bean;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.access.Permission;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.access.Role;
import org.cyclos.model.access.channels.BuiltInChannel;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.contentmanagement.HasContentData;
import org.cyclos.model.contentmanagement.staticcontents.AdminHelpContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.BaseFrontendContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.BaseHomeContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.BaseStaticContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.EmailTemplateDTO;
import org.cyclos.model.contentmanagement.staticcontents.FooterContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.FrontendDashboardContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.FrontendFooterContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.FrontendHelpContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.FrontendHomeContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.GuestHomeContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.HeaderContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.HelpContentDefinitionType;
import org.cyclos.model.contentmanagement.staticcontents.HelpStaticContentData;
import org.cyclos.model.contentmanagement.staticcontents.HomeContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.LoggedUserHomeContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.LoginFooterContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.LoginHeaderContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.MobileHelpContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.MobilePosHelpContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.PayFooterContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.PayHeaderContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.PreviewParams;
import org.cyclos.model.contentmanagement.staticcontents.StaticContentData;
import org.cyclos.model.contentmanagement.staticcontents.StaticContentDataParams;
import org.cyclos.model.contentmanagement.staticcontents.StaticContentListData;
import org.cyclos.model.contentmanagement.staticcontents.StaticContentNature;
import org.cyclos.model.contentmanagement.staticcontents.StaticContentThemeData;
import org.cyclos.model.contentmanagement.staticcontents.StaticContentType;
import org.cyclos.model.contentmanagement.staticcontents.StaticContentVO;
import org.cyclos.model.contentmanagement.staticcontents.UserHelpContentDTO;
import org.cyclos.model.contentmanagement.staticcontents.WelcomeContentDTO;
import org.cyclos.model.contentmanagement.themes.MobileThemeImage;
import org.cyclos.model.contentmanagement.themes.ThemeDefinition;
import org.cyclos.model.contentmanagement.themes.ThemeImageType;
import org.cyclos.model.contentmanagement.themes.ThemeImageVO;
import org.cyclos.model.messaging.notificationsettings.EmailUnsubscribeType;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.system.configurations.DefaultConfigurationType;
import org.cyclos.model.system.languages.BuiltinLanguage;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.ResourceHelper;
import org.cyclos.utils.ObjectHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StaticContentServiceImpl
extends CRUDServiceImpl<BaseStaticContent, QBaseStaticContent, BaseStaticContentDTO, StaticContentData, StaticContentDataParams>
implements StaticContentServiceLocal {
    private static final int MAX_CONTENT_SIZE = 512000;
    private static final int MAX_HOME_PAGE_TITLE_SIZE = 200;
    private static final BidiMap<Class<? extends BaseStaticContent>, Class<? extends BaseStaticContentDTO>> SUBCLASS_MAPPINGS = new DualHashBidiMap();
    @Autowired
    private ConfigurationServiceLocal configurationService;
    @Autowired
    private ThemeImageServiceLocal themeImageService;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private MailHandler mailHandler;
    @Autowired
    private LinkGeneratorHandler linkGeneratorHandler;

    public StaticContentServiceImpl() {
        super(BaseStaticContent.class, QBaseStaticContent.baseStaticContent, BaseStaticContentDTO.class);
    }

    public BaseStaticContent ensureLastModifiedDate(BaseStaticContent baseStaticContent) {
        Date date = this.getSessionData().getConfiguration().getConfiguration().getImagesLastModified();
        if (baseStaticContent.getLastModified().before(date)) {
            return (BaseStaticContent)this.invokerHandler.runAsInCurrentOrNewTransaction(this.getSessionData(), TransactionLevel.READ_WRITE, transactionStatus -> {
                baseStaticContent.setLastModified(date);
                this.entityManagerHandler.flush();
                return baseStaticContent;
            });
        }
        return baseStaticContent;
    }

    @Override
    public StaticContentData getData(BaseStaticContent baseStaticContent) throws FrameworkException {
        HelpStaticContentData helpStaticContentData;
        Configuration configuration = baseStaticContent.getConfiguration().getParent();
        BaseStaticContent baseStaticContent2 = null;
        StaticContentNature staticContentNature = baseStaticContent.getNature();
        if (configuration != null) {
            baseStaticContent2 = this.getInheritedStaticContent(staticContentNature, configuration);
        }
        if (staticContentNature.isHelpContent()) {
            helpStaticContentData = new HelpStaticContentData();
            String string = this.readOriginalHelp(staticContentNature);
            helpStaticContentData.setOriginalStaticContent(string);
        } else {
            helpStaticContentData = new StaticContentData();
        }
        helpStaticContentData.setDto((EntityDTO)this.toDTO(baseStaticContent));
        helpStaticContentData.setGlobalDefaultConfig(baseStaticContent.getConfiguration().getDefaultType() == DefaultConfigurationType.GLOBAL);
        if (baseStaticContent2 != null) {
            helpStaticContentData.setInheritedStaticContent(this.toDTO(baseStaticContent2));
            helpStaticContentData.setInheritedThemeData(this.getThemeData((StaticContentData)helpStaticContentData, baseStaticContent2));
            ConfigurationServiceLocal.setConfiguration((Bean)helpStaticContentData.getInheritedStaticContent(), (Configuration)baseStaticContent.getConfiguration());
        }
        helpStaticContentData.setMobileScheme(this.linkGeneratorHandler.mobileScheme());
        helpStaticContentData.setThemeData(this.getThemeData((StaticContentData)helpStaticContentData, baseStaticContent));
        return helpStaticContentData;
    }

    public String getHelpContent(Role role) {
        Object object = Role.ADMIN == role ? this.getSessionData().getConfiguration().getAdminHelpContent() : this.getSessionData().getConfiguration().getUserHelpContent();
        String string = object == null || HelpContentDefinitionType.ORIGINAL == object.getDefinitionType() ? this.readOriginalHelp(Role.ADMIN == role ? StaticContentNature.ADMIN_HELP : StaticContentNature.USER_HELP) : this.getTranslatedValue((BaseEntity)object, QBaseHelpContent.baseHelpContent.content);
        return this.richTextHandler.newContentAccessor((HasContentScript)object).process(string);
    }

    public String getHelpOrOriginalContent(BaseHelpContent baseHelpContent) {
        if (HelpContentDefinitionType.ORIGINAL == baseHelpContent.getDefinitionType()) {
            if (baseHelpContent.getOriginalContent() != null) {
                return baseHelpContent.getOriginalContent();
            }
            String string = this.readOriginalHelp(baseHelpContent.getNature());
            baseHelpContent.setOriginalContent(string);
            return string;
        }
        return this.getTranslatedValue((BaseEntity)baseHelpContent, QBaseHelpContent.baseHelpContent.content);
    }

    public StaticContentListData getListData(ConfigurationVO configurationVO) throws FrameworkException {
        StaticContentListData staticContentListData = new StaticContentListData();
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        staticContentListData.setConfiguration((ConfigurationVO)this.conversionHandler.convert(ConfigurationVO.class, (Object)configuration));
        staticContentListData.setStaticContents(this.list(configurationVO));
        return staticContentListData;
    }

    public List<StaticContentVO> list(ConfigurationVO configurationVO) throws FrameworkException {
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)configurationVO);
        ArrayList<StaticContentVO> arrayList = new ArrayList<StaticContentVO>();
        boolean bl = this.hasPermission(Permission.SYSTEM_CONFIGURATION_MANAGE) || this.permission(Permission.SPECIFIC_CONFIGURATION_MANAGE_CONTENT).value((Object)configuration).granted();
        Map<StaticContentNature, BaseStaticContent> map = this.listByConfiguration(configuration);
        Configuration configuration2 = configuration.getParent() == null ? configuration : configuration.getParent();
        for (StaticContentNature staticContentNature : StaticContentNature.values()) {
            StaticContentVO staticContentVO = new StaticContentVO();
            staticContentVO.setNature(staticContentNature);
            BaseStaticContent baseStaticContent = map.get(staticContentNature);
            if (baseStaticContent == null && !bl) {
                baseStaticContent = this.getInheritedStaticContent(staticContentNature, configuration2);
            }
            if (baseStaticContent != null) {
                staticContentVO.setId(baseStaticContent.getId());
            }
            arrayList.add(staticContentVO);
        }
        return arrayList;
    }

    @Override
    public BaseStaticContent newEntity(StaticContentDataParams staticContentDataParams) {
        StaticContentNature staticContentNature = staticContentDataParams.getNature();
        if (staticContentNature == null) {
            throw new IllegalActionException("Static content nature is null!");
        }
        Configuration configuration = (Configuration)this.conversionHandler.convert(Configuration.class, (Object)staticContentDataParams.getConfiguration());
        BaseStaticContent baseStaticContent = configuration.getStaticContent(staticContentNature);
        if (baseStaticContent == null) {
            switch (staticContentNature) {
                case ADMIN_HELP: {
                    baseStaticContent = new AdminHelpContent();
                    break;
                }
                case FOOTER: {
                    baseStaticContent = new FooterContent();
                    break;
                }
                case GUEST_HOME: {
                    baseStaticContent = new GuestHomeContent();
                    break;
                }
                case HEADER: {
                    baseStaticContent = new HeaderContent();
                    break;
                }
                case LOGGED_USER_HOME: {
                    baseStaticContent = new LoggedUserHomeContent();
                    break;
                }
                case FRONTEND_HELP: {
                    baseStaticContent = new FrontendHelpContent();
                    break;
                }
                case FRONTEND_HOME: {
                    baseStaticContent = new FrontendHomeContent();
                    break;
                }
                case FRONTEND_DASHBOARD: {
                    baseStaticContent = new FrontendDashboardContent();
                    break;
                }
                case FRONTEND_FOOTER: {
                    baseStaticContent = new FrontendFooterContent();
                    break;
                }
                case LOGIN_FOOTER: {
                    baseStaticContent = new LoginFooterContent();
                    break;
                }
                case LOGIN_HEADER: {
                    baseStaticContent = new LoginHeaderContent();
                    break;
                }
                case MOBILE_HELP: {
                    baseStaticContent = new MobileHelpContent();
                    break;
                }
                case MOBILE_POS_HELP: {
                    baseStaticContent = new MobilePosHelpContent();
                    break;
                }
                case USER_HELP: {
                    baseStaticContent = new UserHelpContent();
                    break;
                }
                case PAY_FOOTER: {
                    baseStaticContent = new PayFooterContent();
                    break;
                }
                case PAY_HEADER: {
                    baseStaticContent = new PayHeaderContent();
                    break;
                }
                case EMAIL_TEMPLATE: {
                    baseStaticContent = new EmailTemplate();
                    break;
                }
                case WELCOME: {
                    baseStaticContent = new WelcomeContent();
                    break;
                }
                case HOME: {
                    baseStaticContent = new HomeContent();
                }
            }
            if (baseStaticContent == null) {
                throw new IllegalActionException("Unknown static content nature: " + String.valueOf(staticContentDataParams.getNature()));
            }
            baseStaticContent.setConfiguration(configuration);
        }
        return baseStaticContent;
    }

    public String preview(@NotNull PreviewParams previewParams) throws FrameworkException {
        User user = (User)this.conversionHandler.convert(User.class, (Object)previewParams.getUser());
        Configuration configuration = user != null ? this.configurationHandler.getAccessor((BasicUser)user).getConfiguration() : (Configuration)this.conversionHandler.convert(Configuration.class, (Object)previewParams.getConfiguration());
        StaticContentNature staticContentNature = previewParams.getType();
        StaticContentType staticContentType = staticContentNature.type();
        BuiltInChannel builtInChannel = staticContentType == StaticContentType.MOBILE ? BuiltInChannel.MOBILE : BuiltInChannel.MAIN;
        SessionData sessionData = user == null ? SessionDataFactory.system((RequestData)this.getSessionData().getRequestData(), (String)builtInChannel.getInternalName()) : SessionDataFactory.direct((BasicUser)user).channel(builtInChannel).accessChannel(builtInChannel).build();
        BiFunction<String, HasContentScript, String> biFunction = (string, hasContentScript) -> (String)this.invokerHandler.runAs(sessionData, () -> this.richTextHandler.newContentAccessor(hasContentScript).setUser((BasicUser)user).process(string));
        switch (staticContentNature) {
            case HOME: {
                if (user == null) break;
                return biFunction.apply("<div class=\"mainContainer mainContainer-homePage mainContainer-customHome\" style=\"overflow-y: scroll\">     <div class=\"mainPanel\">         <div class=\"homePage\">             <div class=\"customHome\">                 <div class=\"appContent\" style=\"margin-bottom: 10px\">" + previewParams.getContent() + "</div></div></div></div></div>", (HasContentScript)configuration.getHomeContent());
            }
            case WELCOME: {
                return biFunction.apply("<div class=\"mainContainer mainContainer-welcomePage\" style=\"overflow-y: scroll\">     <div class=\"mainPanel\">             <div class=\"welcomePage\">                 <div class=\"customHeader\">" + previewParams.getContent() + "</div></div></div></div>", (HasContentScript)configuration.getWelcomeContent());
            }
            case EMAIL_TEMPLATE: {
                return (String)this.invokerHandler.runAs(sessionData, () -> {
                    ApplyMailTemplateParams applyMailTemplateParams = new ApplyMailTemplateParams();
                    applyMailTemplateParams.setConfiguration(this.configurationHandler.getAccessor(configuration));
                    applyMailTemplateParams.setTemplate(previewParams.getContent());
                    applyMailTemplateParams.setTo((BasicUser)user);
                    applyMailTemplateParams.setSubject(this.message(ContentManagementKeys.Emails.PREVIEW_SUBJECT, new Object[0]));
                    applyMailTemplateParams.setMessage(this.message(ContentManagementKeys.Emails.PREVIEW_MESSAGE, new Object[0]));
                    applyMailTemplateParams.setUnsubscribeType(EmailUnsubscribeType.NOTIFICATION);
                    applyMailTemplateParams.setEmail("preview@example.com");
                    return this.mailHandler.applyTemplate(applyMailTemplateParams);
                });
            }
        }
        return null;
    }

    public String readOriginalHelp(StaticContentNature staticContentNature) {
        String string;
        switch (staticContentNature) {
            case ADMIN_HELP: {
                string = "admin";
                break;
            }
            case USER_HELP: {
                string = "user";
                break;
            }
            case MOBILE_HELP: {
                string = "mobile";
                break;
            }
            case MOBILE_POS_HELP: {
                string = "mobilePos";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid nature for help content: " + String.valueOf(staticContentNature));
            }
        }
        BuiltinLanguage builtinLanguage = this.getSessionData().getConfiguration().getLanguage().getTemplate();
        String string2 = null;
        if (builtinLanguage.getIsoCountry() != null) {
            string2 = this.readOriginalHelp(string, builtinLanguage.getIsoLanguage(), builtinLanguage.getIsoCountry());
        }
        if (string2 == null && builtinLanguage.getIsoLanguage() != null) {
            string2 = this.readOriginalHelp(string, builtinLanguage.getIsoLanguage(), null);
        }
        if (string2 == null) {
            string2 = this.readOriginalHelp(string, null, null);
        }
        return string2;
    }

    @Override
    public BaseStaticContentDTO toDTO(BaseStaticContent baseStaticContent) {
        BaseStaticContentDTO baseStaticContentDTO = (BaseStaticContentDTO)super.toDTO(baseStaticContent);
        if (baseStaticContent instanceof BaseHelpContent) {
            baseStaticContentDTO.setContent(this.getHelpOrOriginalContent((BaseHelpContent)baseStaticContent));
        }
        ConfigurationServiceLocal.setConfiguration((Bean)baseStaticContentDTO, (Configuration)baseStaticContent.getConfiguration());
        return baseStaticContentDTO;
    }

    @Override
    protected void addParametersToHasContentData(BaseStaticContent baseStaticContent, HasContentData hasContentData) {
        StaticContentNature staticContentNature = baseStaticContent.getNature();
        if (!staticContentNature.allowVariables()) {
            return;
        }
        super.addParametersToHasContentData(baseStaticContent, hasContentData);
        if (staticContentNature == StaticContentNature.EMAIL_TEMPLATE) {
            List list = this.mailHandler.getMailTemplateVariables();
            list.addAll(hasContentData.getParameters());
            hasContentData.setParameters(list);
        }
    }

    @Override
    protected void onAfterRemove(BaseStaticContent baseStaticContent) {
        if (baseStaticContent instanceof GuestHomeContent) {
            this.configurationService.updateSitemapLastModified(baseStaticContent.getConfiguration());
        }
    }

    @Override
    protected void onAfterSave(BaseStaticContent baseStaticContent, BaseStaticContent baseStaticContent2, Object object) {
        Long l = SimpleEntity.id((SimpleEntity)baseStaticContent.getConfiguration());
        String string = "get" + baseStaticContent.getClass().getSimpleName();
        this.cacheHandler.schedulePartialEvict(CacheType.CONFIGURATION_ACCESSOR, (SerializablePredicate & Serializable)configurationAccessorCacheKey -> configurationAccessorCacheKey.matchesConfigurationAndMethod(l, string));
        if (baseStaticContent instanceof GuestHomeContent) {
            this.configurationService.updateSitemapLastModified(baseStaticContent.getConfiguration());
        }
    }

    @Override
    protected Object onBeforeSave(BaseStaticContent baseStaticContent, BaseStaticContent baseStaticContent2) {
        boolean bl;
        baseStaticContent.setLastModified(new Date());
        Configuration configuration = baseStaticContent.getConfiguration();
        boolean bl2 = bl = configuration.getDefaultType() == DefaultConfigurationType.GLOBAL;
        if (bl) {
            this.markAsCustomized(baseStaticContent);
        } else if (!baseStaticContent.isCustomized()) {
            switch (baseStaticContent.getNature()) {
                case FOOTER: {
                    ((FooterContent)baseStaticContent).setThemed(null);
                    break;
                }
                case GUEST_HOME: 
                case LOGGED_USER_HOME: {
                    ((BaseHomeContent)baseStaticContent).setTitle(null);
                    break;
                }
            }
            baseStaticContent.setContent(null);
        }
        if (baseStaticContent2 == null) {
            configuration.addStaticContent(baseStaticContent);
        }
        if (!baseStaticContent.isCustomized()) {
            baseStaticContent.setContentScript(null);
            baseStaticContent.setContentScriptParameters(null);
        }
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QBaseStaticContent)this.$).configuration().network(), true);
    }

    @Override
    protected Validator resolveValidator(BaseStaticContentDTO baseStaticContentDTO) {
        Validator validator = new Validator();
        if (baseStaticContentDTO.isTransient()) {
            validator.property((Property)BaseStaticContentDTO.CONFIGURATION, ContentManagementKeys.ContentItems.CONFIGURATION).required();
        }
        validator.property((Property)BaseStaticContentDTO.CONTENT, ContentManagementKeys.StaticContents.CONTENT).maxLength(512000);
        if (StaticContentNature.GUEST_HOME == baseStaticContentDTO.getNature() || StaticContentNature.LOGGED_USER_HOME == baseStaticContentDTO.getNature()) {
            validator.property((Property)BaseHomeContentDTO.TITLE, ContentManagementKeys.StaticContents.HOME_TITLE).maxLength(200);
        }
        if (StaticContentNature.FRONTEND_DASHBOARD == baseStaticContentDTO.getNature() || StaticContentNature.FRONTEND_HELP == baseStaticContentDTO.getNature() || StaticContentNature.FRONTEND_HOME == baseStaticContentDTO.getNature()) {
            validator.property((Property)BaseFrontendContentDTO.TITLE, ContentManagementKeys.StaticContents.HOME_TITLE).maxLength(200);
        }
        return validator;
    }

    @Override
    protected BidiMap<Class<? extends BaseStaticContent>, Class<? extends BaseStaticContentDTO>> subClassMappings() {
        return SUBCLASS_MAPPINGS;
    }

    private BaseStaticContent getInheritedStaticContent(StaticContentNature staticContentNature, Configuration configuration) {
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(configuration);
        AdminHelpContent adminHelpContent = null;
        switch (staticContentNature) {
            case ADMIN_HELP: {
                adminHelpContent = configurationAccessor.getAdminHelpContent();
                break;
            }
            case USER_HELP: {
                adminHelpContent = configurationAccessor.getUserHelpContent();
                break;
            }
            case MOBILE_HELP: {
                adminHelpContent = configurationAccessor.getMobileHelpContent();
                break;
            }
            case MOBILE_POS_HELP: {
                adminHelpContent = configurationAccessor.getMobilePosHelpContent();
                break;
            }
            case FOOTER: {
                adminHelpContent = configurationAccessor.getFooterContent();
                break;
            }
            case GUEST_HOME: {
                adminHelpContent = configurationAccessor.getGuestHomeContent();
                break;
            }
            case HEADER: {
                adminHelpContent = configurationAccessor.getHeaderContent();
                break;
            }
            case LOGGED_USER_HOME: {
                adminHelpContent = configurationAccessor.getLoggedUserHomeContent();
                break;
            }
            case FRONTEND_HELP: {
                adminHelpContent = configurationAccessor.getFrontendHelpContent();
                break;
            }
            case FRONTEND_HOME: {
                adminHelpContent = configurationAccessor.getFrontendHomeContent();
                break;
            }
            case FRONTEND_DASHBOARD: {
                adminHelpContent = configurationAccessor.getFrontendDashboardContent();
                break;
            }
            case FRONTEND_FOOTER: {
                adminHelpContent = (BaseStaticContent)ObjectHelper.defaultValue((Object)configurationAccessor.getFrontendFooterContent(), (Object)new FrontendFooterContent());
                break;
            }
            case LOGIN_FOOTER: {
                adminHelpContent = configurationAccessor.getLoginFooterContent();
                break;
            }
            case LOGIN_HEADER: {
                adminHelpContent = configurationAccessor.getLoginHeaderContent();
                break;
            }
            case PAY_FOOTER: {
                adminHelpContent = configurationAccessor.getPayFooterContent();
                break;
            }
            case PAY_HEADER: {
                adminHelpContent = configurationAccessor.getPayHeaderContent();
                break;
            }
            case EMAIL_TEMPLATE: {
                adminHelpContent = configurationAccessor.getEmailTemplate();
                break;
            }
            case WELCOME: {
                adminHelpContent = configurationAccessor.getWelcomeContent();
                break;
            }
            case HOME: {
                adminHelpContent = configurationAccessor.getHomeContent();
            }
        }
        if (adminHelpContent == null) {
            throw new IllegalArgumentException("Unknown static content:" + String.valueOf(staticContentNature));
        }
        return adminHelpContent;
    }

    private StaticContentThemeData getThemeData(StaticContentData staticContentData, BaseStaticContent baseStaticContent) {
        StaticContentThemeData staticContentThemeData = null;
        if (baseStaticContent.getNature().type() == StaticContentType.MOBILE) {
            staticContentThemeData = new StaticContentThemeData();
            ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(baseStaticContent.getConfiguration());
            Theme theme = baseStaticContent.getConfiguration().getMobileTheme();
            if (theme == null) {
                theme = configurationAccessor.getMobileTheme();
            }
            staticContentThemeData.setThemeId(theme.getId());
            boolean bl = theme.getDefinitions().isEmpty();
            switch (baseStaticContent.getNature()) {
                case LOGIN_FOOTER: 
                case LOGIN_HEADER: {
                    staticContentThemeData.setBackgroundColor(bl ? ThemeDefinition.LOGIN_BACKGROUND_COLOR.defaultValue() : (String)theme.getDefinitions().get(ThemeDefinition.LOGIN_BACKGROUND_COLOR));
                    staticContentThemeData.setBackgroundPosition(bl ? ThemeDefinition.LOGIN_IMAGE_ALIGN.defaultValue() : (String)theme.getDefinitions().get(ThemeDefinition.LOGIN_IMAGE_ALIGN));
                    if (bl || Boolean.TRUE.toString().equals(theme.getDefinitions().get(ThemeDefinition.SHOW_LOGIN_IMAGE))) {
                        ThemeImageVO themeImageVO = this.themeImageService.getImageVO(this.configurationHandler.getAccessor(baseStaticContent.getConfiguration()).getMobileTheme().getId(), ThemeImageType.MOBILE, MobileThemeImage.LOGIN_BACKGROUND.name());
                        staticContentThemeData.setBackgroundImage(themeImageVO);
                    }
                    staticContentThemeData.setTextColor(bl ? ThemeDefinition.LOGIN_CONTENT_COLOR.defaultValue() : (String)theme.getDefinitions().get(ThemeDefinition.LOGIN_CONTENT_COLOR));
                    break;
                }
                default: {
                    staticContentThemeData.setTextColor(bl ? ThemeDefinition.BASE_TEXT_COLOR.defaultValue() : (String)theme.getDefinitions().get(ThemeDefinition.BASE_TEXT_COLOR));
                }
            }
        }
        return staticContentThemeData;
    }

    private Map<StaticContentNature, BaseStaticContent> listByConfiguration(Configuration configuration) throws FrameworkException {
        HashMap<StaticContentNature, BaseStaticContent> hashMap = new HashMap<StaticContentNature, BaseStaticContent>();
        List list = ((DBQuery)((DBQuery)this.from(this.$).where((Predicate)((QBaseStaticContent)this.$).configuration().eq((Object)configuration))).orderBy(((QBaseStaticContent)this.$).nature.asc())).list((Expression)this.$);
        for (BaseStaticContent baseStaticContent : list) {
            hashMap.put(baseStaticContent.getNature(), baseStaticContent);
        }
        return hashMap;
    }

    private void markAsCustomized(BaseStaticContent baseStaticContent) {
        BaseHelpContent baseHelpContent;
        if (baseStaticContent instanceof BaseSectionContent) {
            ((BaseSectionContent)baseStaticContent).setCustomized(true);
        } else if (baseStaticContent instanceof BaseHelpContent && (baseHelpContent = (BaseHelpContent)baseStaticContent).getDefinitionType() == HelpContentDefinitionType.INHERIT) {
            baseHelpContent.setDefinitionType(HelpContentDefinitionType.CUSTOM);
        }
    }

    private String readOriginalHelp(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder("/helps/help-");
        stringBuilder.append(string);
        if (string2 != null) {
            stringBuilder.append("_").append(string2);
            if (string3 != null) {
                stringBuilder.append("_").append(string3);
            }
        }
        stringBuilder.append(".html");
        try {
            return ResourceHelper.readContent((String)stringBuilder.toString());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Error reading help file from " + String.valueOf(stringBuilder), iOException);
        }
    }

    static {
        SUBCLASS_MAPPINGS.put(LoggedUserHomeContent.class, LoggedUserHomeContentDTO.class);
        SUBCLASS_MAPPINGS.put(GuestHomeContent.class, GuestHomeContentDTO.class);
        SUBCLASS_MAPPINGS.put(HeaderContent.class, HeaderContentDTO.class);
        SUBCLASS_MAPPINGS.put(FooterContent.class, FooterContentDTO.class);
        SUBCLASS_MAPPINGS.put(AdminHelpContent.class, AdminHelpContentDTO.class);
        SUBCLASS_MAPPINGS.put(UserHelpContent.class, UserHelpContentDTO.class);
        SUBCLASS_MAPPINGS.put(FrontendHelpContent.class, FrontendHelpContentDTO.class);
        SUBCLASS_MAPPINGS.put(FrontendHomeContent.class, FrontendHomeContentDTO.class);
        SUBCLASS_MAPPINGS.put(FrontendDashboardContent.class, FrontendDashboardContentDTO.class);
        SUBCLASS_MAPPINGS.put(FrontendFooterContent.class, FrontendFooterContentDTO.class);
        SUBCLASS_MAPPINGS.put(WelcomeContent.class, WelcomeContentDTO.class);
        SUBCLASS_MAPPINGS.put(HomeContent.class, HomeContentDTO.class);
        SUBCLASS_MAPPINGS.put(LoginHeaderContent.class, LoginHeaderContentDTO.class);
        SUBCLASS_MAPPINGS.put(LoginFooterContent.class, LoginFooterContentDTO.class);
        SUBCLASS_MAPPINGS.put(MobileHelpContent.class, MobileHelpContentDTO.class);
        SUBCLASS_MAPPINGS.put(MobilePosHelpContent.class, MobilePosHelpContentDTO.class);
        SUBCLASS_MAPPINGS.put(PayHeaderContent.class, PayHeaderContentDTO.class);
        SUBCLASS_MAPPINGS.put(PayFooterContent.class, PayFooterContentDTO.class);
        SUBCLASS_MAPPINGS.put(EmailTemplate.class, EmailTemplateDTO.class);
    }
}

