/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.contentmanagement;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.contentmanagement.QTranslationMessage;
import org.cyclos.entities.contentmanagement.TranslationMessage;
import org.cyclos.entities.system.Language;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.contentmanagement.CyclosResourceBundle;
import org.cyclos.impl.contentmanagement.InternalTranslationMessageServiceLocal;
import org.cyclos.impl.contentmanagement.TranslationHandler;
import org.cyclos.impl.contentmanagement.TranslationMessageServiceLocal;
import org.cyclos.impl.system.LanguageServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.utils.cache.CacheHandler;
import org.cyclos.impl.utils.cache.CacheType;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.Property;
import org.cyclos.model.Submodules;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.app.AppSubmodule;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.contentmanagement.translations.ApplicationTranslationData;
import org.cyclos.model.contentmanagement.translations.BasicTranslationKeyDTO;
import org.cyclos.model.contentmanagement.translations.CustomizedTranslation;
import org.cyclos.model.contentmanagement.translations.SetCustomizedTranslationsDTO;
import org.cyclos.model.contentmanagement.translations.TranslationCategoryVO;
import org.cyclos.model.contentmanagement.translations.TranslationKeyDTO;
import org.cyclos.model.contentmanagement.translations.TranslationKeyData;
import org.cyclos.model.contentmanagement.translations.TranslationKeyVO;
import org.cyclos.model.contentmanagement.translations.TranslationQuery;
import org.cyclos.model.contentmanagement.translations.TranslationsData;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.languages.LanguageDetailedVO;
import org.cyclos.model.system.languages.LanguageVO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.EnumMessageKeyResolver;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.Module;
import org.cyclos.utils.ModuleMessageKeys;
import org.cyclos.utils.Page;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.Submodule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TranslationMessageServiceImpl
extends BaseServiceImpl
implements TranslationMessageServiceLocal,
InternalTranslationMessageServiceLocal {
    private static final String APP_TRANSLATIONS_PREFIX = "APP.TRANSLATIONS.";
    @Autowired
    private TranslationHandler translationHandler;
    @Autowired
    private LanguageServiceLocal languageService;
    @Autowired
    private CacheHandler cacheHandler;

    public TranslationsData getAppI18n() throws FrameworkException {
        CyclosResourceBundle cyclosResourceBundle = this.translationHandler.getResourceBundle();
        Map map = cyclosResourceBundle.getI18n();
        TranslationsData translationsData = this.toTranslationsData(cyclosResourceBundle, map);
        translationsData.setSubmodules(Collections.singleton(AppSubmodule.TRANSLATIONS));
        return translationsData;
    }

    public ApplicationTranslationData getApplicationTranslationData(LanguageVO languageVO) {
        ApplicationTranslationData applicationTranslationData = new ApplicationTranslationData();
        applicationTranslationData.setLanguageVO((LanguageVO)this.languageService.get(languageVO));
        applicationTranslationData.setCategories(this.listTranslationCategories());
        return applicationTranslationData;
    }

    public TranslationsData getBySubmodules(Set<Submodule> set) {
        CyclosResourceBundle cyclosResourceBundle = this.translationHandler.getResourceBundle();
        Map map = cyclosResourceBundle.getBySubmodule(set);
        TranslationsData translationsData = this.toTranslationsData(cyclosResourceBundle, map);
        translationsData.setSubmodules(set);
        return translationsData;
    }

    public List<String> getCustomizedKeys(Long l) {
        QTranslationMessage qTranslationMessage = QTranslationMessage.translationMessage;
        return ((DBQuery)this.from(new EntityPath[]{qTranslationMessage}).where((com.querydsl.core.types.Predicate)qTranslationMessage.language().id.eq((Object)l))).list((Expression)qTranslationMessage.key);
    }

    public Properties getCustomizedKeysPerLanguage(LanguageVO languageVO) {
        Language language = (Language)this.conversionHandler.convert(Language.class, (Object)languageVO);
        CyclosResourceBundle cyclosResourceBundle = this.translationHandler.getResourceBundle(language);
        Map map = cyclosResourceBundle.getCustomizedKeys();
        return map.entrySet().stream().filter(entry -> !((CustomizedTranslation)entry.getValue()).isInvalid()).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((CustomizedTranslation)entry.getValue()).getValue(), (object, object2) -> object, Properties::new));
    }

    public TranslationKeyData getTranslationKeyData(BasicTranslationKeyDTO basicTranslationKeyDTO) throws FrameworkException {
        this.validate(basicTranslationKeyDTO);
        Language language = (Language)this.conversionHandler.convert(Language.class, (Object)basicTranslationKeyDTO.getLanguage());
        TranslationKeyData translationKeyData = new TranslationKeyData();
        translationKeyData.setTranslationKeyVO(this.loadKey(language.getId(), basicTranslationKeyDTO.getKey()));
        translationKeyData.setLanguageVO((LanguageVO)this.conversionHandler.convert(LanguageVO.class, (Object)language));
        translationKeyData.setEditable(this.permission(Permission.APPLICATION_TRANSLATION_ENABLE).value((Object)language).granted());
        return translationKeyData;
    }

    public List<LanguageDetailedVO> listTranslatableLanguages() throws FrameworkException {
        List list = this.languageService.list();
        SessionData sessionData = this.getSessionData();
        if (sessionData.isGlobalAdmin() || sessionData.isSystem()) {
            return list;
        }
        ProductsAccessor productsAccessor = sessionData.getProducts();
        Set set = SimpleEntity.uniqueIds((Collection)productsAccessor.admin().getApplicationTranslation());
        list.removeIf(languageDetailedVO -> !set.contains(languageDetailedVO.getId()));
        return list;
    }

    public TranslationKeyVO loadKey(Long l, String string) {
        Language language = this.find(Language.class, (long)l);
        CyclosResourceBundle cyclosResourceBundle = this.translationHandler.getResourceBundle(language);
        CustomizedTranslation customizedTranslation = cyclosResourceBundle.getCustomizedTranslation(string);
        boolean bl = customizedTranslation != null && customizedTranslation.isInvalid();
        TranslationKeyVO translationKeyVO = new TranslationKeyVO();
        translationKeyVO.setKey(string);
        translationKeyVO.setCustomized(customizedTranslation != null);
        translationKeyVO.setInvalid(bl);
        translationKeyVO.setCurrentTranslation(cyclosResourceBundle.getEvenIfInvalid(string));
        translationKeyVO.setOriginalTranslation(cyclosResourceBundle.getOriginalValue(string));
        translationKeyVO.setPreviousEnglishTranslation(bl ? customizedTranslation.getSourceValue() : null);
        translationKeyVO.setEnglishTranslation(this.translationHandler.getOriginalEnglishResourceBundle().getString(string));
        return translationKeyVO;
    }

    @Override
    public String message(MessageFormat messageFormat, MessageKey messageKey, Object ... objectArray) {
        return super.message(messageFormat, messageKey, objectArray);
    }

    @Override
    public String message(MessageKey messageKey, Object ... objectArray) {
        return super.message(messageKey, objectArray);
    }

    public void restoreOriginalTranslation(BasicTranslationKeyDTO basicTranslationKeyDTO) throws FrameworkException {
        this.validate(basicTranslationKeyDTO);
        Language language = (Language)this.conversionHandler.convert(Language.class, (Object)basicTranslationKeyDTO.getLanguage());
        QTranslationMessage qTranslationMessage = QTranslationMessage.translationMessage;
        TranslationMessage translationMessage = (TranslationMessage)((DBQuery)this.from(new EntityPath[]{qTranslationMessage}).where(new com.querydsl.core.types.Predicate[]{qTranslationMessage.key.eq((Object)basicTranslationKeyDTO.getKey()), qTranslationMessage.language().id.eq((Object)language.getId())})).singleResult(TranslationMessage.class, (Expression)qTranslationMessage);
        if (translationMessage != null) {
            this.remove((IEntity)translationMessage);
            this.languageService.updateLastModified(language);
            this.evictCustomizedKeysCache(language);
        }
    }

    public void saveKey(TranslationKeyDTO translationKeyDTO) throws FrameworkException {
        this.validate((BasicTranslationKeyDTO)translationKeyDTO);
        Language language = (Language)this.conversionHandler.convert(Language.class, (Object)translationKeyDTO.getLanguage());
        String string = translationKeyDTO.getValue();
        string = string.replaceAll("\\n", "<br>");
        this.save(language, translationKeyDTO.getKey(), string);
        this.languageService.updateLastModified(language);
        this.evictCustomizedKeysCache(language);
    }

    public Page<TranslationKeyVO> searchKeys(TranslationQuery translationQuery) {
        Language language = this.find(Language.class, translationQuery.getLanguageId());
        CyclosResourceBundle cyclosResourceBundle = this.translationHandler.getResourceBundle(language);
        return cyclosResourceBundle.search(translationQuery);
    }

    public void setCustomizedKeysPerLanguage(SetCustomizedTranslationsDTO setCustomizedTranslationsDTO) throws FrameworkException {
        Language language = (Language)this.conversionHandler.convert(Language.class, (Object)setCustomizedTranslationsDTO.getLanguage());
        if (language == null) {
            throw new ValidationException("language", this.message(GeneralKeys.Errors.REQUIRED, ContentManagementKeys.Translations.DATA_LANGUAGE));
        }
        CyclosResourceBundle cyclosResourceBundle = this.translationHandler.getOriginalEnglishResourceBundle();
        Map map = cyclosResourceBundle.getI18n();
        Predicate<String> predicate = string -> {
            if (string.startsWith(APP_TRANSLATIONS_PREFIX)) {
                return map.containsKey(StringHelper.removeStart((String)string, (String)APP_TRANSLATIONS_PREFIX));
            }
            return cyclosResourceBundle.containsKey(string);
        };
        Map map2 = CollectionHelper.orEmpty((Map)setCustomizedTranslationsDTO.getTranslations());
        map2.keySet().stream().filter(predicate).forEach(string -> this.save(language, (String)string, StringHelper.trim(map2.get(string))));
        this.languageService.updateLastModified(language);
        this.evictCustomizedKeysCache(language);
    }

    protected void evictCustomizedKeysCache(Language language) {
        this.cacheHandler.scheduleEvict(CacheType.CUSTOMIZED_TRANSLATIONS, (Serializable)language.getId());
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        QTranslationMessage qTranslationMessage = QTranslationMessage.translationMessage;
        networkPathRegistry.register(qTranslationMessage.language().network(), true);
    }

    private List<TranslationCategoryVO> listTranslationCategories() {
        ArrayList<TranslationCategoryVO> arrayList = new ArrayList<TranslationCategoryVO>();
        Comparator comparator = (submodule, submodule2) -> submodule.name().compareTo(submodule2.name());
        Object[] objectArray = Module.values();
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            MessageKey messageKey = ModuleMessageKeys.get().resolveKey((Module)object);
            TranslationCategoryVO translationCategoryVO = new TranslationCategoryVO();
            translationCategoryVO.setName(this.message(messageKey, new Object[0]));
            translationCategoryVO.setModule((Module)object);
            arrayList.add(translationCategoryVO);
            List list = Submodules.getSubmodulesFromModule((Module)object);
            Collections.sort(list, comparator);
            EnumMessageKeyResolver enumMessageKeyResolver = ModuleMessageKeys.resolverForSubmodule((Module)object);
            for (Submodule submodule3 : list) {
                MessageKey messageKey2 = enumMessageKeyResolver.resolveKey((Enum)submodule3);
                TranslationCategoryVO translationCategoryVO2 = new TranslationCategoryVO();
                translationCategoryVO2.setName(this.message(messageKey2, new Object[0]));
                translationCategoryVO2.setSubmodule(submodule3);
                translationCategoryVO2.setParent(translationCategoryVO);
                arrayList.add(translationCategoryVO2);
            }
        }
        return arrayList;
    }

    private void save(Language language, String string, String string2) {
        QTranslationMessage qTranslationMessage = QTranslationMessage.translationMessage;
        DBQuery<?> dBQuery = this.from(new EntityPath[]{qTranslationMessage});
        dBQuery.where((com.querydsl.core.types.Predicate)qTranslationMessage.key.eq((Object)string));
        dBQuery.where((com.querydsl.core.types.Predicate)qTranslationMessage.language().id.eq((Object)language.getId()));
        TranslationMessage translationMessage = (TranslationMessage)dBQuery.singleResult(TranslationMessage.class, (Expression)qTranslationMessage);
        if (translationMessage == null) {
            translationMessage = new TranslationMessage();
        }
        translationMessage.setKey(string);
        translationMessage.setInvalid(false);
        translationMessage.setLanguage(language);
        translationMessage.setValue(string2);
        translationMessage.setSourceValue(this.translationHandler.getOriginalEnglishResourceBundle().getOriginalValue(string));
        this.persist((IEntity)translationMessage);
    }

    private TranslationsData toTranslationsData(CyclosResourceBundle cyclosResourceBundle, Map<String, String> map) {
        TranslationsData translationsData = new TranslationsData();
        translationsData.setLanguageId(Long.valueOf(cyclosResourceBundle.getLanguageId()));
        translationsData.setLanguageVersion(((Language)this.languageService.find(Long.valueOf(cyclosResourceBundle.getLanguageId()))).getVersion().intValue());
        translationsData.setTemplate(cyclosResourceBundle.getTemplate());
        translationsData.setTranslations(map);
        return translationsData;
    }

    private void validate(BasicTranslationKeyDTO basicTranslationKeyDTO) {
        Validator validator = new Validator();
        validator.property((Property)BasicTranslationKeyDTO.LANGUAGE, ContentManagementKeys.Translations.LANGUAGE).required();
        validator.property((Property)BasicTranslationKeyDTO.KEY, ContentManagementKeys.Translations.TRANSLATION_KEY).required();
        if (basicTranslationKeyDTO instanceof TranslationKeyDTO) {
            validator.property((Property)TranslationKeyDTO.VALUE, ContentManagementKeys.Translations.CURRENT_TRANSLATION).required();
        }
        this.validate(validator, basicTranslationKeyDTO, "basicTranslationKeyDTO");
    }
}

