/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.marketplace;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.QCurrency;
import org.cyclos.entities.marketplace.AdDeliveryMethod;
import org.cyclos.entities.marketplace.QAdDeliveryMethod;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.banking.CurrencyServiceLocal;
import org.cyclos.impl.marketplace.AdDeliveryMethodServiceLocal;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.UserAddressServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.marketplace.MarketplaceKeys;
import org.cyclos.model.marketplace.webshopdeliverymethods.AdDeliveryMethodChargeType;
import org.cyclos.model.marketplace.webshopdeliverymethods.AdDeliveryMethodDTO;
import org.cyclos.model.marketplace.webshopdeliverymethods.AdDeliveryMethodData;
import org.cyclos.model.marketplace.webshopdeliverymethods.AdDeliveryMethodType;
import org.cyclos.model.marketplace.webshopdeliverymethods.AdDeliveryMethodVO;
import org.cyclos.model.marketplace.webshopdeliverymethods.UserAdDeliveryMethodsListData;
import org.cyclos.model.users.UsersKeys;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.CurrencyAmountDTO;
import org.cyclos.model.utils.TimeField;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.services.banking.TransactionService;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdDeliveryMethodServiceImpl
extends CRUDServiceImpl<AdDeliveryMethod, QAdDeliveryMethod, AdDeliveryMethodDTO, AdDeliveryMethodData, UserLocatorVO>
implements AdDeliveryMethodServiceLocal {
    @Autowired
    private CurrencyServiceLocal currencyService;
    @Autowired
    private UserAddressServiceLocal addressService;

    public AdDeliveryMethodServiceImpl() {
        super(AdDeliveryMethod.class, QAdDeliveryMethod.adDeliveryMethod, AdDeliveryMethodDTO.class);
    }

    public int disableNotInCurrencies(User user, Collection<Currency> collection) {
        BooleanExpression booleanExpression = ((QAdDeliveryMethod)this.$).currency().isNotNull();
        if (CollectionHelper.isNotEmpty(collection)) {
            booleanExpression = booleanExpression.and((Predicate)((QAdDeliveryMethod)this.$).currency().notIn(collection));
        }
        List list = ((DBQuery)this.from().where(new Predicate[]{((QAdDeliveryMethod)this.$).owner().eq((Object)user), booleanExpression})).list(AdDeliveryMethod.class, (Expression)this.$);
        list.forEach(adDeliveryMethod -> {
            adDeliveryMethod.setEnabled(false);
            adDeliveryMethod.setRemovedFromOwner(true);
        });
        return list.size();
    }

    public UserAdDeliveryMethodsListData getListData(@NotNull UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        if (user == null) {
            throw new IllegalActionException();
        }
        UserAdDeliveryMethodsListData userAdDeliveryMethodsListData = new UserAdDeliveryMethodsListData();
        userAdDeliveryMethodsListData.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        userAdDeliveryMethodsListData.setAdDeliveryMethods(this.list(userLocatorVO));
        return userAdDeliveryMethodsListData;
    }

    public List<AdDeliveryMethodVO> list(UserLocatorVO userLocatorVO) {
        List<AdDeliveryMethod> list = this.list((User)this.conversionHandler.convert(User.class, (Object)userLocatorVO));
        return this.conversionHandler.convertList(AdDeliveryMethodVO.class, list);
    }

    public List<AdDeliveryMethod> listAllowed(User user) {
        if (user == null) {
            user = this.getLoggedUser();
        }
        return ((DBQuery)((DBQuery)this.from().where((Predicate)((QAdDeliveryMethod)this.$).owner().eq((Object)user).and((Predicate)((QAdDeliveryMethod)this.$).enabled.isTrue()).and((Predicate)((QAdDeliveryMethod)this.$).removedFromOwner.eq(Boolean.valueOf(false))))).orderBy(((QAdDeliveryMethod)this.$).name.asc())).list((Expression)this.$);
    }

    public List<AdDeliveryMethodVO> listMineByCurrency(Currency currency) {
        User user = this.getLoggedUser();
        if (user == null) {
            return Collections.emptyList();
        }
        QCurrency qCurrency = QCurrency.currency;
        DBQuery dBQuery = (DBQuery)((DBQuery)((DBQuery)this.from().leftJoin((EntityPath)qCurrency)).on((Predicate)((QAdDeliveryMethod)this.$).currency().eq((Expression)qCurrency))).where(new Predicate[]{((QAdDeliveryMethod)this.$).enabled.isTrue(), ((QAdDeliveryMethod)this.$).owner().eq((Object)user), ((QAdDeliveryMethod)this.$).removedFromOwner.eq(Boolean.valueOf(false))});
        if (currency != null) {
            dBQuery.where((Predicate)qCurrency.eq((Object)currency).or((Predicate)((QAdDeliveryMethod)this.$).chargeType.eq((Object)AdDeliveryMethodChargeType.NEGOTIATED)));
        }
        dBQuery.orderBy(((QAdDeliveryMethod)this.$).name.asc());
        return dBQuery.list(AdDeliveryMethodVO.class, (Expression)this.$);
    }

    @Override
    public AdDeliveryMethod newEntity(UserLocatorVO userLocatorVO) {
        AdDeliveryMethod adDeliveryMethod = new AdDeliveryMethod();
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        adDeliveryMethod.setOwner(user);
        return adDeliveryMethod;
    }

    public void removeAll(User user) {
        this.delete(this.$).where(new Predicate[]{((QAdDeliveryMethod)this.$).owner().eq((Object)user)}).execute();
    }

    @Override
    protected AdDeliveryMethodData getData(AdDeliveryMethod adDeliveryMethod) {
        AdDeliveryMethodData adDeliveryMethodData = new AdDeliveryMethodData();
        adDeliveryMethodData.setCurrencies(this.conversionHandler.convertList(CurrencyVO.class, (Iterable)this.currencyService.listForAds(adDeliveryMethod.getOwner(), false)));
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor((BasicUser)adDeliveryMethod.getOwner());
        if (productsAccessor.product().getMaxAddresses() > 0) {
            adDeliveryMethodData.setAddresses(this.addressService.getAddresses(adDeliveryMethod.getOwner(), true, false));
        }
        adDeliveryMethodData.setDto((EntityDTO)((AdDeliveryMethodDTO)this.toDTO(adDeliveryMethod)));
        return adDeliveryMethodData;
    }

    @Override
    protected Object onBeforeSave(AdDeliveryMethod adDeliveryMethod, AdDeliveryMethod adDeliveryMethod2) {
        if (adDeliveryMethod.isRemovedFromOwner()) {
            throw new IllegalActionException();
        }
        if (adDeliveryMethod.getOwner() == null) {
            adDeliveryMethod.setOwner(this.getLoggedUser());
        }
        if (adDeliveryMethod.isTransient()) {
            adDeliveryMethod.setCreationDate(DateHelper.now());
        }
        if (adDeliveryMethod2 != null) {
            adDeliveryMethod.setChargeType(adDeliveryMethod2.getChargeType());
            if (adDeliveryMethod.getPrice() != null && adDeliveryMethod2.getPrice() != null) {
                adDeliveryMethod.getPrice().setCurrency(adDeliveryMethod2.getPrice().getCurrency());
            }
            if (adDeliveryMethod.getChargeType() != null && adDeliveryMethod2.getChargeType() != null) {
                adDeliveryMethod.setChargeType(adDeliveryMethod2.getChargeType());
            }
        }
        if (adDeliveryMethod.getChargeType() == AdDeliveryMethodChargeType.NEGOTIATED) {
            adDeliveryMethod.setPrice(null);
        }
        if (adDeliveryMethod.getDeliveryType() == AdDeliveryMethodType.DELIVER) {
            adDeliveryMethod.setAddress(null);
        }
        adDeliveryMethod.setRemovedFromOwner(false);
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QAdDeliveryMethod)this.$).owner().network());
    }

    @Override
    protected Validator resolveValidator(AdDeliveryMethodDTO adDeliveryMethodDTO) {
        Validator validator = new Validator();
        if (adDeliveryMethodDTO.isTransient()) {
            validator.property((Property)AdDeliveryMethodDTO.OWNER, UsersKeys.Users.USER).required();
        }
        validator.property((Property)AdDeliveryMethodDTO.CHARGE_TYPE, MarketplaceKeys.WebshopDeliveryMethods.CHARGE_TYPE).required();
        validator.property((Property)AdDeliveryMethodDTO.DELIVERY_TYPE, MarketplaceKeys.WebshopDeliveryMethods.DELIVERY_TYPE).required();
        validator.property((Property)AdDeliveryMethodDTO.DETAILS, MarketplaceKeys.WebshopDeliveryMethods.DETAILS).required().maxLength(300);
        if (adDeliveryMethodDTO.getChargeType() == AdDeliveryMethodChargeType.FIXED) {
            Currency currency;
            org.cyclos.impl.utils.validation.Property property = validator.property((Property)AdDeliveryMethodDTO.PRICE, MarketplaceKeys.WebshopDeliveryMethods.PRICE).required().positiveOrZero();
            CurrencyAmountDTO currencyAmountDTO = adDeliveryMethodDTO.getPrice();
            if (currencyAmountDTO != null && (currency = (Currency)this.conversionHandler.convert(Currency.class, (Object)currencyAmountDTO.getCurrency())) != null) {
                property.lessThan((Comparable)TransactionService.MAX_TRANSACTION_AMOUNT_EXCLUSIVE);
            }
        }
        validator.property((Property)AdDeliveryMethodDTO.MIN_DELIVERY_TIME, MarketplaceKeys.WebshopDeliveryMethods.MIN_DELIVERY_TIME).minInterval(0, TimeField.DAYS).maxInterval(1, TimeField.YEARS);
        validator.property((Property)AdDeliveryMethodDTO.MAX_DELIVERY_TIME, MarketplaceKeys.WebshopDeliveryMethods.MAX_DELIVERY_TIME).required().minInterval(0, TimeField.DAYS).maxInterval(1, TimeField.YEARS).greaterThan((Comparable)adDeliveryMethodDTO.getMinDeliveryTime());
        if (adDeliveryMethodDTO.getDeliveryType() == AdDeliveryMethodType.PICKUP) {
            validator.property((Property)AdDeliveryMethodDTO.ADDRESS, MarketplaceKeys.WebshopDeliveryMethods.ADDRESS).required();
        }
        return validator;
    }

    private List<AdDeliveryMethod> list(User user) {
        if (user == null) {
            user = this.getLoggedUser();
        }
        return ((DBQuery)((DBQuery)this.from().where((Predicate)((QAdDeliveryMethod)this.$).owner().eq((Object)user))).orderBy(((QAdDeliveryMethod)this.$).name.asc())).list((Expression)this.$);
    }
}

