/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.marketplace;

import com.querydsl.core.types.Predicate;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.marketplace.AdWebShop;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.system.EntityLog;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.EntityLogDescriptor;
import org.cyclos.impl.marketplace.AdCustomFieldServiceLocal;
import org.cyclos.impl.system.BaseEntityLogHandlerImpl;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.system.EntityLogHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.validation.BeanPropertyAccess;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.Property;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.marketplace.MarketplaceKeys;
import org.cyclos.model.marketplace.advertisements.AdType;
import org.cyclos.model.marketplace.advertisements.AdWebShopDTO;
import org.cyclos.model.marketplace.advertisements.AdvertisementDTO;
import org.cyclos.model.marketplace.advertisements.BasicAdDTO;
import org.cyclos.model.system.entitylogs.EntityLogType;
import org.cyclos.model.system.entitylogs.EntityPropertyLogQuery;
import org.cyclos.security.marketplace.AdServiceSecurity;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class AdEntityLogHandlerImpl
extends BaseEntityLogHandlerImpl<BasicAd, BasicAdDTO> {
    @Autowired
    @Lazy
    private CustomFieldValueHandler customFieldValueHandler;
    @Autowired
    @Lazy
    private AdServiceSecurity adServiceSecurity;
    @Autowired
    @Lazy
    protected AdCustomFieldServiceLocal adCustomFieldService;

    @Override
    public Pair<Boolean, Set<EntityLogType>> doApplyLogFilters(DBQuery<?> dBQuery, long l, EntityPropertyLogQuery entityPropertyLogQuery) {
        BasicAd basicAd = this.find(BasicAd.class, l);
        List list = this.adCustomFieldService.listVisible(basicAd.getOwner(), true);
        if (CollectionHelper.isEmpty((Iterable)list)) {
            dBQuery.where((Predicate)AdEntityLogHandlerImpl.$.customFieldId.isNull());
        } else {
            dBQuery.where((Predicate)AdEntityLogHandlerImpl.$.customFieldId.isNull().or((Predicate)AdEntityLogHandlerImpl.$.customFieldId.in((Collection)SimpleEntity.uniqueIds((Collection)list))));
        }
        return null;
    }

    public Class<BasicAd> getEntityClass() {
        return BasicAd.class;
    }

    @Override
    public BasicUser getRelatedUser(BasicAd basicAd) {
        return basicAd.getOwner();
    }

    public EntityLogType getType() {
        return EntityLogType.AD;
    }

    @Override
    public boolean isAsManager(BasicAd basicAd) {
        return !basicAd.getOwner().equals((Object)this.getLoggedUser());
    }

    public EntityLogDescriptor<? extends BasicAdDTO> resolveLogDescriptor(BasicAd basicAd) {
        EntityLogDescriptor entityLogDescriptor = new EntityLogDescriptor(this.resolveDTOType(basicAd)).property(BasicAdDTO.NAME, MarketplaceKeys.Advertisements.NAME).property((Property)BasicAdDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION).property((Property)BasicAdDTO.STATUS, MarketplaceKeys.Advertisements.STATUS).property((Property)BasicAdDTO.CATEGORIES, MarketplaceKeys.Advertisements.CATEGORY).property((Property)BasicAdDTO.PUBLICATION_PERIOD, MarketplaceKeys.Advertisements.PUBLICATION_PERIOD).property((Property)BasicAdDTO.PRICE, MarketplaceKeys.Advertisements.PRICE).property((Property)BasicAdDTO.PROMOTIONAL_PERIOD, MarketplaceKeys.Advertisements.PROMOTIONAL_PERIOD).property(this.toPromotionalPriceAccess((Property<?, BasicAdDTO>)BasicAdDTO.PROMOTIONAL_PRICE), MarketplaceKeys.Advertisements.PROMOTIONAL_PRICE).property((Property)BasicAdDTO.AUTHORIZATION_NOTES, MarketplaceKeys.Advertisements.AUTHORIZATION_NOTES).property((Property)BasicAdDTO.ADDRESSES, MarketplaceKeys.Advertisements.SHOW_ADDRESS_ON_MAP).property((Property)BasicAdDTO.CREATION_DATE, MarketplaceKeys.Advertisements.CREATION_DATE).ignore((Property)BasicAdDTO.OWNER).ignore((Property)BasicAdDTO.UPLOADED_IMAGES).ignore((Property)BasicAdDTO.PROMOTIONAL_PERIOD_ACTIVE).ignore((Property)BasicAdDTO.CUSTOM_VALUES).customFields((Iterable)this.adCustomFieldService.listEnabled(basicAd.getOwner()), this.customFieldValueHandler);
        if (basicAd instanceof AdWebShop) {
            entityLogDescriptor.cast().property((Property)AdWebShopDTO.PRODUCT_NUMBER, MarketplaceKeys.Advertisements.PRODUCT_NUMBER).property((Property)AdWebShopDTO.ALLOW_DECIMAL, MarketplaceKeys.Advertisements.ALLOW_DECIMAL).property((Property)AdWebShopDTO.MIN_ALLOWED_IN_CART, MarketplaceKeys.Advertisements.MIN_ALLOWED_IN_CART).property((Property)AdWebShopDTO.MAX_ALLOWED_IN_CART, MarketplaceKeys.Advertisements.MAX_ALLOWED_IN_CART).property((Property)AdWebShopDTO.STOCK_TYPE, MarketplaceKeys.Advertisements.STOCK_TYPE).property((Property)AdWebShopDTO.STOCK_QUANTITY, MarketplaceKeys.Advertisements.STOCK_QUANTITY).property((Property)AdWebShopDTO.MINIMUM_STOCK_LIMIT, MarketplaceKeys.Advertisements.MINIMUM_STOCK_LIMIT).property((Property)AdWebShopDTO.DELIVERY_METHODS, MarketplaceKeys.Advertisements.DELIVERY_METHODS);
        }
        return entityLogDescriptor;
    }

    @Override
    protected BasicAd getEntityToViewLog(long l) {
        BasicAd basicAd = this.find(BasicAd.class, l);
        if (this.adServiceSecurity.canPerformOperation(basicAd, CRUDOperation.READ)) {
            return basicAd;
        }
        return null;
    }

    @Override
    protected <BE extends BaseEntity, EDTO extends EntityDTO> EntityLogHandler<BE, EDTO> resolveOwnerEntityLogHandler(EntityLog entityLog) {
        return this.entityLogRegistry.getHandler(User.class);
    }

    private Class<? extends BasicAdDTO> resolveDTOType(BasicAd basicAd) {
        return basicAd.getType() == AdType.ADVERTISEMENT ? AdvertisementDTO.class : AdWebShopDTO.class;
    }

    private PropertyAccess toPromotionalPriceAccess(Property<?, BasicAdDTO> property) {
        return new BeanPropertyAccess(property){

            public Object get(Object object) {
                if (super.get(object) == null) {
                    return null;
                }
                BasicAd basicAd = (BasicAd)object;
                BigDecimal bigDecimal = (BigDecimal)super.get(object);
                return AdEntityLogHandlerImpl.this.getFormatter().format(bigDecimal, basicAd.getCurrency().getPrecision());
            }
        };
    }
}

