/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.marketplace;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.Collection;
import java.util.Date;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.marketplace.QBasicAd;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.tasks.EntityBatchRecurringTask;
import org.cyclos.model.marketplace.advertisements.AdStatus;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.utils.RecurringTaskRecurrence;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.MessageKey;
import org.springframework.stereotype.Component;

@Component
public class AdExpiredNotificationRecurringTask
extends EntityBatchRecurringTask<BasicAd> {
    public AdExpiredNotificationRecurringTask() {
        super(BasicAd.class);
    }

    public MessageKey getMessageKey() {
        return SystemKeys.RecurringTasks.AD_EXPIRED_NOTIFICATION;
    }

    @Override
    public RecurringTaskRecurrence getRecurrence() {
        return RecurringTaskRecurrence.EVERY_DAY;
    }

    @Override
    protected void finish(BasicAd basicAd, Throwable throwable) throws Throwable {
        basicAd.setExpirationNotified(true);
    }

    @Override
    protected Collection<Long> nextIds() throws Throwable {
        Date date = DateHelper.now();
        QBasicAd qBasicAd = QBasicAd.basicAd;
        return ((DBQuery)((DBQuery)this.from(new EntityPath[]{qBasicAd}).where(new Predicate[]{qBasicAd.expirationNotified.isFalse(), qBasicAd.publicationPeriod().end.lt((Comparable)date), qBasicAd.status.eq((Object)AdStatus.ACTIVE)})).limit(200L)).list((Expression)qBasicAd.id);
    }

    @Override
    protected void process(BasicAd basicAd) throws Throwable {
        this.notificationHandler.user((BasicUser)basicAd.getOwner()).marketplaceSeller().adExpired(basicAd, basicAd.getName());
    }
}

