/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.marketplace;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.marketplace.AdInterest;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.marketplace.NotifiedAdInterest;
import org.cyclos.entities.marketplace.QAdInterest;
import org.cyclos.entities.marketplace.QBasicAd;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.CurrencyAmountRange;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.CurrencyServiceLocal;
import org.cyclos.impl.marketplace.AdCategoryServiceLocal;
import org.cyclos.impl.marketplace.AdInterestServiceLocal;
import org.cyclos.impl.users.ProductServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.GeneralValidation;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.RangeOptionalType;
import org.cyclos.impl.utils.validation.validations.ValidationErrors;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.marketplace.MarketplaceKeys;
import org.cyclos.model.marketplace.advertisements.AdType;
import org.cyclos.model.marketplace.interests.AdInterestDTO;
import org.cyclos.model.marketplace.interests.AdInterestData;
import org.cyclos.model.marketplace.interests.AdInterestVO;
import org.cyclos.model.marketplace.interests.UserAdInterestsListData;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.CurrencyAmountRangeDTO;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdInterestServiceImpl
extends CRUDServiceImpl<AdInterest, QAdInterest, AdInterestDTO, AdInterestData, UserLocatorVO>
implements AdInterestServiceLocal {
    @Autowired
    private CurrencyServiceLocal currencyService;
    @Autowired
    private AdCategoryServiceLocal adCategoryService;
    @Autowired
    protected ProductServiceLocal productService;
    @Autowired
    protected AccountServiceLocal accountService;

    public AdInterestServiceImpl() {
        super(AdInterest.class, QAdInterest.adInterest, AdInterestDTO.class);
    }

    public boolean generateNotification(BasicAd basicAd) {
        if (basicAd.isAdInterestNotified()) {
            return false;
        }
        CloseableIterator<User> closeableIterator = this.resolveMembersToNotify(basicAd);
        this.processBatch(closeableIterator, (T user) -> {
            if (this.groupsHandler.getAccessibleUserGroups(user).contains(basicAd.getOwner().getGroup())) {
                this.notificationHandler.user((BasicUser)user).marketplaceBuyer().adInterestNotification(basicAd, basicAd.getName());
            }
        });
        NotifiedAdInterest notifiedAdInterest = new NotifiedAdInterest(basicAd);
        this.entityManagerHandler.persist((IEntity)notifiedAdInterest);
        return true;
    }

    public UserAdInterestsListData getListData(UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        if (user == null) {
            throw new IllegalActionException();
        }
        UserAdInterestsListData userAdInterestsListData = new UserAdInterestsListData();
        userAdInterestsListData.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        userAdInterestsListData.setAdInterests(((DBQuery)((DBQuery)this.from().where((Predicate)((QAdInterest)this.$).owner().eq((Object)user))).orderBy(((QAdInterest)this.$).name.asc())).list(AdInterestVO.class, (Expression)this.$));
        return userAdInterestsListData;
    }

    @Override
    public AdInterest newEntity(UserLocatorVO userLocatorVO) {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        AdInterest adInterest = new AdInterest();
        adInterest.setOwner(user);
        if (this.hasPermission(Permission.USER_ADS_VIEW) && !this.hasPermission(Permission.USER_WEB_SHOP_VIEW)) {
            adInterest.setAdType(AdType.ADVERTISEMENT);
        } else if (!this.hasPermission(Permission.USER_ADS_VIEW) && this.hasPermission(Permission.USER_WEB_SHOP_VIEW)) {
            adInterest.setAdType(AdType.WEB_SHOP);
        }
        return adInterest;
    }

    public void removeAll(User user) {
        this.delete(this.$).where(new Predicate[]{((QAdInterest)this.$).user().eq((Object)user).or((Predicate)((QAdInterest)this.$).owner().eq((Object)user))}).execute();
    }

    @Override
    public AdInterest toEntity(AdInterestDTO adInterestDTO) {
        AdInterest adInterest = (AdInterest)super.toEntity(adInterestDTO);
        SessionData sessionData = this.getSessionData();
        if (adInterest.isTransient() && adInterest.getOwner() == null && sessionData.isMember()) {
            adInterest.setOwner(sessionData.getLoggedUser());
        }
        return adInterest;
    }

    @Override
    protected AdInterestData getData(AdInterest adInterest) {
        AdInterestData adInterestData = new AdInterestData();
        adInterestData.setDto((EntityDTO)((AdInterestDTO)this.toDTO(adInterest)));
        List list = this.currencyService.listForAds(adInterest.getOwner(), false);
        if (this.isAdmin()) {
            HashSet hashSet = new HashSet(this.accountService.listVisibleCurrencies((InternalAccountOwner)adInterest.getOwner()));
            hashSet.addAll(this.productsHandler.getAccessor((BasicUser)adInterest.getOwner()).member().getViewAdsInOtherCurrencies());
            list.retainAll(hashSet);
        }
        adInterestData.setCurrencies(this.conversionHandler.convertList(CurrencyVO.class, (Iterable)list));
        adInterestData.setCategories(this.adCategoryService.listVisible(adInterest.getOwner()));
        adInterestData.setSelectAdType(this.hasPermission(Permission.USER_ADS_VIEW) && this.hasPermission(Permission.USER_WEB_SHOP_VIEW));
        return adInterestData;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QAdInterest)this.$).owner().network());
    }

    @Override
    protected Validator resolveValidator(AdInterestDTO adInterestDTO) {
        CurrencyAmountRangeDTO currencyAmountRangeDTO;
        Validator validator = new Validator();
        if (adInterestDTO.isTransient()) {
            validator.property((Property)AdInterestDTO.OWNER, MarketplaceKeys.Advertisements.OWNER).required();
        }
        if (CollectionHelper.orEmpty((Set)adInterestDTO.getKeywords()).stream().anyMatch(string -> string.length() > 50)) {
            validator.property((Property)AdInterestDTO.KEYWORDS, MarketplaceKeys.Interests.KEYWORDS).invalid(ValidationErrors.maxLength((int)50));
        }
        if ((currencyAmountRangeDTO = adInterestDTO.getPriceRange()) != null) {
            CurrencyAmountRange currencyAmountRange = (CurrencyAmountRange)this.conversionHandler.convert(CurrencyAmountRange.class, (Object)currencyAmountRangeDTO);
            org.cyclos.impl.utils.validation.Property property = validator.property((Property)AdInterestDTO.PRICE_RANGE, MarketplaceKeys.Interests.PRICE_RANGE);
            property.range(RangeOptionalType.BOTH_OPTIONAL);
            property.nested((Property)CurrencyAmountRangeDTO.MIN, GeneralKeys.Ui.RANGE_MIN).positiveNonZero((HasCurrency)currencyAmountRange);
            property.nested((Property)CurrencyAmountRangeDTO.MAX, GeneralKeys.Ui.RANGE_MAX).positiveNonZero((HasCurrency)currencyAmountRange);
        }
        validator.general((GeneralValidation)new AdInterestValidation());
        return validator;
    }

    private CloseableIterator<User> resolveMembersToNotify(BasicAd basicAd) {
        QUser qUser = QUser.user;
        QBasicAd qBasicAd = QBasicAd.basicAd;
        QAdInterest qAdInterest = QAdInterest.adInterest;
        DBQuery dBQuery = (DBQuery)this.subQuery(new EntityPath[]{qAdInterest}).where((Predicate)qAdInterest.eq((Expression)this.$).and((Predicate)qAdInterest.category().isNotNull().and((Predicate)qAdInterest.category().in((CollectionExpression)qBasicAd.categories))));
        DBQuery dBQuery2 = (DBQuery)this.subQuery(this.$).where(new Predicate[]{((QAdInterest)this.$).owner().eq((Expression)qUser), ((QAdInterest)this.$).category().isNull().or((Predicate)dBQuery.exists()), ((QAdInterest)this.$).user().isNull().or((Predicate)((QAdInterest)this.$).user().eq((Expression)qBasicAd.owner())), ((QAdInterest)this.$).adType.isNull().or((Predicate)qBasicAd.discriminator.eq((Expression)((QAdInterest)this.$).adType)), ((QAdInterest)this.$).priceRange().min.isNull().or((Predicate)qBasicAd.priceAmount.isNull()).or((Predicate)((QAdInterest)this.$).priceRange().min.loe((Expression)qBasicAd.priceAmount)), ((QAdInterest)this.$).priceRange().max.isNull().or((Predicate)qBasicAd.priceAmount.isNull()).or((Predicate)((QAdInterest)this.$).priceRange().max.goe((Expression)qBasicAd.priceAmount)), basicAd.getPrice() == null ? ((QAdInterest)this.$).priceRange().currency().isNull() : ((QAdInterest)this.$).priceRange().currency().isNull().or((Predicate)((QAdInterest)this.$).priceRange().currency().eq((Expression)qBasicAd.priceCurrency())), ((QAdInterest)this.$).keyword0.isNull().or((Predicate)((QAdInterest)this.$).keyword0.isNotNull().and((Predicate)qBasicAd.name.containsIgnoreCase((Expression)((QAdInterest)this.$).keyword0).or((Predicate)qBasicAd.description.containsIgnoreCase((Expression)((QAdInterest)this.$).keyword0)))).or((Predicate)((QAdInterest)this.$).keyword1.isNotNull().and((Predicate)qBasicAd.name.containsIgnoreCase((Expression)((QAdInterest)this.$).keyword1).or((Predicate)qBasicAd.description.containsIgnoreCase((Expression)((QAdInterest)this.$).keyword1)))).or((Predicate)((QAdInterest)this.$).keyword2.isNotNull().and((Predicate)qBasicAd.name.containsIgnoreCase((Expression)((QAdInterest)this.$).keyword2).or((Predicate)qBasicAd.description.containsIgnoreCase((Expression)((QAdInterest)this.$).keyword2)))).or((Predicate)((QAdInterest)this.$).keyword3.isNotNull().and((Predicate)qBasicAd.name.containsIgnoreCase((Expression)((QAdInterest)this.$).keyword3).or((Predicate)qBasicAd.description.containsIgnoreCase((Expression)((QAdInterest)this.$).keyword3)))).or((Predicate)((QAdInterest)this.$).keyword4.isNotNull().and((Predicate)qBasicAd.name.containsIgnoreCase((Expression)((QAdInterest)this.$).keyword4).or((Predicate)qBasicAd.description.containsIgnoreCase((Expression)((QAdInterest)this.$).keyword4))))});
        return ((DBQuery)this.from(new EntityPath[]{qBasicAd, qUser}).where(new Predicate[]{qBasicAd.eq((Object)basicAd), qBasicAd.owner().ne((Expression)qUser), dBQuery2.exists()})).iterate((Expression)qUser);
    }

    private final class AdInterestValidation
    implements GeneralValidation {
        private AdInterestValidation() {
        }

        public ValidationError validate(Object object) {
            AdInterestDTO adInterestDTO = (AdInterestDTO)object;
            if (adInterestDTO.getCategory() == null && adInterestDTO.getUser() == null && CollectionHelper.isEmpty((Iterable)adInterestDTO.getKeywords())) {
                return new ValidationError(MarketplaceKeys.Interests.ERROR_MISSING_DATA);
            }
            return null;
        }
    }
}

