/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.marketplace;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.marketplace.AdQuestion;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.marketplace.QAdQuestion;
import org.cyclos.entities.marketplace.QBasicAd;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.marketplace.AdQuestionServiceLocal;
import org.cyclos.impl.users.MemberProductAccessor;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.Permission;
import org.cyclos.model.marketplace.MarketplaceKeys;
import org.cyclos.model.marketplace.advertisements.AdQuestionQuery;
import org.cyclos.model.marketplace.advertisements.AdQuestionVO;
import org.cyclos.model.marketplace.advertisements.AdType;
import org.cyclos.model.marketplace.advertisements.BasicAdVO;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.StringHelper;
import org.springframework.stereotype.Service;

@Service
public class AdQuestionServiceImpl
extends BaseServiceImpl
implements AdQuestionServiceLocal {
    public void answer(Long l, String string) throws FrameworkException, IllegalActionException {
        if (StringUtils.isEmpty((CharSequence)string) || string.length() > 600) {
            throw new ValidationException(this.message(MarketplaceKeys.Advertisements.INVALID_ANSWER, 600));
        }
        AdQuestion adQuestion = this.find(AdQuestion.class, l);
        if (adQuestion.getAnswerDate() != null) {
            throw new IllegalActionException();
        }
        adQuestion.setAnswer(string);
        adQuestion.setAnswerDate(DateHelper.now());
        this.notificationHandler.user((BasicUser)adQuestion.getOwner()).marketplaceBuyer().adQuestionAnswered(adQuestion.getAd(), adQuestion.getAd().getName(), adQuestion.getOwner());
    }

    public Long ask(BasicAdVO basicAdVO, String string) throws FrameworkException {
        if (StringUtils.isEmpty((CharSequence)string) || string.length() > 400) {
            throw new ValidationException(this.message(MarketplaceKeys.Advertisements.INVALID_QUESTION, 400));
        }
        User user = this.getLoggedUser();
        if (user == null) {
            throw new IllegalActionException();
        }
        BasicAd basicAd = (BasicAd)this.conversionHandler.convert(BasicAd.class, (Object)basicAdVO);
        AdQuestion adQuestion = new AdQuestion();
        adQuestion.setAd(basicAd);
        adQuestion.setOwner(user);
        adQuestion.setQuestion(string);
        adQuestion.setQuestionDate(DateHelper.now());
        this.persist((IEntity)adQuestion);
        this.notificationHandler.user((BasicUser)basicAd.getOwner()).marketplaceSeller().adQuestionCreated(adQuestion, basicAd.getName(), user);
        return adQuestion.getId();
    }

    public boolean isQuestionsEnabled(AdType adType, User user) {
        MemberProductAccessor memberProductAccessor = this.productsHandler.getAccessor((BasicUser)user).member();
        if (adType == AdType.ADVERTISEMENT) {
            return memberProductAccessor.hasPermission(Permission.MY_AD_QUESTIONS_ENABLE);
        }
        if (adType == AdType.WEB_SHOP) {
            return memberProductAccessor.hasPermission(Permission.MY_WEB_SHOP_QUESTIONS_ENABLE);
        }
        throw new IllegalArgumentException("Unknown ad type: " + String.valueOf(adType));
    }

    public List<AdQuestionVO> list(BasicAdVO basicAdVO) {
        Long l = basicAdVO.getId() != null ? basicAdVO.getId() : ((BasicAd)this.conversionHandler.convert(BasicAd.class, (Object)basicAdVO)).getId();
        QAdQuestion qAdQuestion = QAdQuestion.adQuestion;
        return ((DBQuery)((DBQuery)this.from(new EntityPath[]{qAdQuestion}).where((Predicate)qAdQuestion.ad().id.eq((Object)l))).orderBy(qAdQuestion.questionDate.desc())).list(AdQuestionVO.class, (Expression)qAdQuestion);
    }

    public AdQuestionVO load(Long l) throws FrameworkException {
        return (AdQuestionVO)this.conversionHandler.convert(AdQuestionVO.class, (Object)this.find(AdQuestion.class, l));
    }

    public void remove(Long l) throws FrameworkException {
        AdQuestion adQuestion = this.find(AdQuestion.class, l);
        if (!this.isAdmin() && !StringHelper.isBlank((Object)adQuestion.getAnswer())) {
            throw new IllegalActionException();
        }
        this.remove((IEntity)adQuestion);
    }

    public Page<AdQuestionVO> search(AdQuestionQuery adQuestionQuery) {
        if (!QueryHelper.useParameter((Object)adQuestionQuery.getSeller()) || !QueryHelper.useParameter((Object)adQuestionQuery.getType())) {
            throw new ValidationException();
        }
        QAdQuestion qAdQuestion = QAdQuestion.adQuestion;
        QBasicAd qBasicAd = QBasicAd.basicAd;
        User user = (User)this.conversionHandler.convert(User.class, (Object)adQuestionQuery.getSeller());
        return ((DBQuery)((DBQuery)((DBQuery)((DBQuery)this.from(new EntityPath[]{qAdQuestion}).innerJoin((EntityPath)qBasicAd)).on((Predicate)qAdQuestion.ad().eq((Expression)qBasicAd))).where(new Predicate[]{qBasicAd.deletedDate.isNull(), qAdQuestion.answerDate.isNull(), qAdQuestion.ad().owner().eq((Object)user), qAdQuestion.ad().discriminator.eq((Object)adQuestionQuery.getType())})).orderBy(qAdQuestion.questionDate.desc())).page(AdQuestionVO.class, (QueryParameters)adQuestionQuery, (Expression)qAdQuestion);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(QAdQuestion.adQuestion.ad().owner().network());
    }
}

