/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.marketplace;

import com.google.common.collect.Sets;
import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.AbstractJPAQuery;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.BaseEntity;
import org.cyclos.entities.NetworkedEntity;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.HasCurrency;
import org.cyclos.entities.marketplace.AdCategory;
import org.cyclos.entities.marketplace.AdCustomField;
import org.cyclos.entities.marketplace.AdCustomFieldValue;
import org.cyclos.entities.marketplace.AdDeliveryMethod;
import org.cyclos.entities.marketplace.AdHistoryLog;
import org.cyclos.entities.marketplace.AdWebShop;
import org.cyclos.entities.marketplace.AdWebShopSetting;
import org.cyclos.entities.marketplace.Advertisement;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.marketplace.QAdCustomFieldValue;
import org.cyclos.entities.marketplace.QAdHistoryLog;
import org.cyclos.entities.marketplace.QAdImage;
import org.cyclos.entities.marketplace.QAdWebShop;
import org.cyclos.entities.marketplace.QBasicAd;
import org.cyclos.entities.marketplace.QNotifiedAdInterest;
import org.cyclos.entities.system.CustomField;
import org.cyclos.entities.system.EntityWithCustomValues;
import org.cyclos.entities.system.ExportFormat;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.QBasicUser;
import org.cyclos.entities.users.QUserAddress;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.entities.utils.TimeInterval;
import org.cyclos.impl.BeanHandler;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.banking.CurrencyServiceLocal;
import org.cyclos.impl.marketplace.AdAddressServiceLocal;
import org.cyclos.impl.marketplace.AdCategoryServiceLocal;
import org.cyclos.impl.marketplace.AdCustomFieldServiceLocal;
import org.cyclos.impl.marketplace.AdDeliveryMethodServiceLocal;
import org.cyclos.impl.marketplace.AdImageServiceLocal;
import org.cyclos.impl.marketplace.AdInterestNotificationBackgroundTask;
import org.cyclos.impl.marketplace.AdQuestionServiceLocal;
import org.cyclos.impl.marketplace.AdServiceLocal;
import org.cyclos.impl.marketplace.AdWebShopSettingServiceLocal;
import org.cyclos.impl.messaging.MessageCategoryServiceLocal;
import org.cyclos.impl.search.AdSearchHandler;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ConfigurationServiceLocal;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.system.CustomOperationServiceLocal;
import org.cyclos.impl.system.EntityLogServiceLocal;
import org.cyclos.impl.system.ExportFormatServiceLocal;
import org.cyclos.impl.system.ExtensionPointAccessor;
import org.cyclos.impl.system.ExtensionPointFilter;
import org.cyclos.impl.system.ImageVOConverter;
import org.cyclos.impl.system.ImportHandler;
import org.cyclos.impl.users.GroupListView;
import org.cyclos.impl.users.MemberProductAccessor;
import org.cyclos.impl.users.ProductsAccessor;
import org.cyclos.impl.users.ProfileFieldHandler;
import org.cyclos.impl.users.ProfileFieldSearchContext;
import org.cyclos.impl.users.UserAddressServiceLocal;
import org.cyclos.impl.utils.PermissionHelper;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.persistence.CustomProjection;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.impl.utils.tasks.BackgroundTaskHandler;
import org.cyclos.impl.utils.validation.GeneralValidation;
import org.cyclos.impl.utils.validation.Property;
import org.cyclos.impl.utils.validation.PropertyValidation;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BasePropertyValidation;
import org.cyclos.impl.utils.validation.validations.RequiredValidation;
import org.cyclos.model.Bean;
import org.cyclos.model.CRUDOperation;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityModel;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.MaxItemsException;
import org.cyclos.model.NestedProperty;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.access.Permission;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.marketplace.MarketplaceKeys;
import org.cyclos.model.marketplace.advertisements.AdDataParams;
import org.cyclos.model.marketplace.advertisements.AdDetailsData;
import org.cyclos.model.marketplace.advertisements.AdQuestionVO;
import org.cyclos.model.marketplace.advertisements.AdSearchData;
import org.cyclos.model.marketplace.advertisements.AdStatus;
import org.cyclos.model.marketplace.advertisements.AdType;
import org.cyclos.model.marketplace.advertisements.AdViewData;
import org.cyclos.model.marketplace.advertisements.AdWebShopDTO;
import org.cyclos.model.marketplace.advertisements.AdWebShopStockType;
import org.cyclos.model.marketplace.advertisements.AdWebShopVO;
import org.cyclos.model.marketplace.advertisements.AdvertisementDTO;
import org.cyclos.model.marketplace.advertisements.AdvertisementVO;
import org.cyclos.model.marketplace.advertisements.BasicAdDTO;
import org.cyclos.model.marketplace.advertisements.BasicAdQuery;
import org.cyclos.model.marketplace.advertisements.BasicAdVO;
import org.cyclos.model.marketplace.advertisements.UserAdsSearchData;
import org.cyclos.model.marketplace.advertisements.UserFavoriteAdsListData;
import org.cyclos.model.marketplace.advertisements.WebShopAdDetailsData;
import org.cyclos.model.marketplace.categories.AdCategoryDetailedVO;
import org.cyclos.model.marketplace.categories.AdCategoryVO;
import org.cyclos.model.marketplace.fields.AdCustomFieldActions;
import org.cyclos.model.marketplace.fields.AdCustomFieldSearchVisibility;
import org.cyclos.model.marketplace.webshopdeliverymethods.AdDeliveryMethodVO;
import org.cyclos.model.marketplace.webshopsettings.AdWebShopSettingVO;
import org.cyclos.model.messaging.messagecategories.MessageCategoryVO;
import org.cyclos.model.system.exportformats.ExportFormatContext;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.system.extensionpoints.AdExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.ExtensionPointEvent;
import org.cyclos.model.system.fields.CustomFieldDetailedVO;
import org.cyclos.model.system.fields.ModelWithCustomValues;
import org.cyclos.model.system.scripts.LoadValuesScriptFunction;
import org.cyclos.model.users.addresses.AdAddressResult;
import org.cyclos.model.users.users.BasicProfileField;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.DataWithBasicProfileFields;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserStatus;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.CurrencyAmountDTO;
import org.cyclos.model.utils.DatePeriodDTO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.ITimeInterval;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.security.marketplace.AdServiceSecurity;
import org.cyclos.security.messaging.MessageServiceSecurity;
import org.cyclos.server.model.contentmanagement.contentitems.SitemapItemType;
import org.cyclos.server.model.contentmanagement.contentitems.SitemapItemVO;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.services.banking.TransactionService;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.DateTime;
import org.cyclos.utils.HasMessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.Pair;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdServiceImpl
extends CRUDServiceImpl<BasicAd, QBasicAd, BasicAdDTO, AdDetailsData, AdDataParams>
implements AdServiceLocal {
    private static final BidiMap<Class<? extends BasicAd>, Class<? extends BasicAdDTO>> SUBCLASS_MAPPINGS = new DualHashBidiMap();
    private static final Map<Class<?>, Class<?>> VO_MAPPINGS = new HashMap();
    private static final int MIN_PRODUCT_NUMBER_LENGTH = 5;
    private static final int DEFAULT_MAX_AD_DESCRIPTION_SIZE = 1000;
    @Autowired
    private BackgroundTaskHandler backgroundTaskHandler;
    @Autowired
    private CustomFieldValueHandler customFieldValueService;
    @Autowired
    private ConfigurationServiceLocal configurationService;
    @Autowired
    private CustomOperationServiceLocal customOperationService;
    @Autowired
    private MessageServiceSecurity messageServiceSecurity;
    @Autowired
    private MessageCategoryServiceLocal messageCategoryService;
    @Autowired
    private CurrencyServiceLocal currencyService;
    @Autowired
    private AdImageServiceLocal adImageService;
    @Autowired
    private AdAddressServiceLocal adAddressService;
    @Autowired
    private AdQuestionServiceLocal adQuestionService;
    @Autowired
    private AdCustomFieldServiceLocal adCustomFieldService;
    @Autowired
    private ExportFormatServiceLocal exportFormatService;
    @Autowired
    private AdCategoryServiceLocal adCategoryService;
    @Autowired
    private AdDeliveryMethodServiceLocal adDeliveryMethodService;
    @Autowired
    private AdWebShopSettingServiceLocal adWebShopSettingService;
    @Autowired
    private UserAddressServiceLocal addressService;
    @Autowired
    private EntityLogServiceLocal entityLogService;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private AdSearchHandler adSearchHandler;
    @Autowired
    private BeanHandler beanHandler;
    @Autowired
    private ProfileFieldHandler profileFieldHandler;
    @Autowired
    private AdServiceSecurity adServiceSecurity;

    public AdServiceImpl() {
        super(BasicAd.class, QBasicAd.basicAd, BasicAdDTO.class);
    }

    public boolean adRequiresAuthorization(AdType adType, User user) {
        MemberProductAccessor memberProductAccessor = this.productsHandler.getAccessor((BasicUser)user).member();
        return adType == null || adType == AdType.ADVERTISEMENT ? memberProductAccessor.isAdsRequireAuthorization() : memberProductAccessor.isWebShopAdsRequireAuthorization();
    }

    public boolean adRequiresAuthorization(BasicAd basicAd) {
        return this.adRequiresAuthorization(basicAd.getType(), basicAd.getOwner());
    }

    public void approve(@NotNull BasicAdVO basicAdVO) throws FrameworkException {
        BasicAd basicAd = (BasicAd)this.conversionHandler.convert(BasicAd.class, (Object)basicAdVO);
        if (basicAd.getStatus() != AdStatus.PENDING) {
            throw new IllegalActionException("Attempting to approve an ad in status " + String.valueOf(basicAd.getStatus()));
        }
        basicAd.setStatus(AdStatus.ACTIVE);
        this.adSearchHandler.index((NetworkedEntity)basicAd);
        FormatterImpl formatterImpl = this.getFormatter();
        this.entityLogService.log((SimpleEntity)basicAd, this.message(MarketplaceKeys.Advertisements.STATUS, new Object[0]), BasicAdDTO.STATUS.getName(), formatterImpl.format((HasMessageKey)AdStatus.PENDING), formatterImpl.format((HasMessageKey)AdStatus.ACTIVE), null);
        this.notificationHandler.user((BasicUser)basicAd.getOwner()).marketplaceSeller().adAuthorized(basicAd, basicAd.getName());
        if (this.shouldNotifyInterested(basicAd)) {
            this.backgroundTaskHandler.schedule(AdInterestNotificationBackgroundTask.scheduling(basicAd));
        }
    }

    public void checkStatus(boolean bl, boolean bl2, BasicAdQuery basicAdQuery, User user) {
        HashSet hashSet;
        boolean bl3;
        SessionData sessionData = this.getSessionData();
        Set set = this.conversionHandler.convertSet(User.class, (Iterable)basicAdQuery.getBrokers());
        boolean bl4 = sessionData.isBrokerOf((BasicUser)user) || set.size() == 1 && sessionData.isBroker() && sessionData.getLoggedUser().equals(CollectionHelper.first((Iterable)set));
        boolean bl5 = bl3 = this.isMember() && !bl2 && !bl4;
        if (bl || bl3) {
            hashSet = Sets.newHashSet((Object[])new AdStatus[]{AdStatus.ACTIVE});
        } else {
            hashSet = Sets.newHashSet((Object[])new AdStatus[]{AdStatus.ACTIVE, AdStatus.HIDDEN, AdStatus.EXPIRED, AdStatus.SCHEDULED});
            if (this.isMember() && bl2) {
                hashSet.add(AdStatus.DRAFT);
                hashSet.add(AdStatus.PENDING);
            } else if (bl4 || this.isAdmin()) {
                if (this.hasPendingViewPermission()) {
                    hashSet.add(AdStatus.PENDING);
                }
                hashSet.add(AdStatus.DISABLED);
            }
        }
        basicAdQuery.setStatuses((Set)PermissionHelper.checkSelection((Collection)hashSet, (Collection)basicAdQuery.getStatuses()));
    }

    public int disableNotInCurrencies(User user, Collection<Currency> collection) {
        BooleanExpression booleanExpression = ((QBasicAd)this.$).priceCurrency().isNotNull();
        if (CollectionHelper.isNotEmpty(collection)) {
            booleanExpression = booleanExpression.and((Predicate)((QBasicAd)this.$).priceCurrency().notIn(collection));
        }
        CloseableIterator closeableIterator = ((DBQuery)this.from(this.$).where(new Predicate[]{((QBasicAd)this.$).owner().eq((Object)user), booleanExpression, ((QBasicAd)this.$).deletedDate.isNull()})).iterate((Expression)this.$);
        return (int)this.processBatch(closeableIterator, (T basicAd) -> {
            basicAd.setRemovedFromOwner(true);
            this.adSearchHandler.remove(basicAd.getId());
            this.updateAdHistoryLog((BasicAd)basicAd, null);
        });
    }

    public FileInfo exportAd(ExportFormatVO exportFormatVO, BasicAdVO basicAdVO) throws FrameworkException {
        ExportFormat exportFormat = (ExportFormat)this.conversionHandler.convert(ExportFormat.class, (Object)exportFormatVO);
        BasicAd basicAd = (BasicAd)this.conversionHandler.convert(BasicAd.class, (Object)basicAdVO);
        return this.exportFormatService.exportSingle(exportFormat, ExportFormatContext.ADVERTISEMENT_DETAILS, (Object)basicAd);
    }

    public AdWebShop findByOwnerAndNumber(User user, String string) {
        QAdWebShop qAdWebShop = QAdWebShop.adWebShop;
        AdWebShop adWebShop = (AdWebShop)InvocationContext.ensure().getAttribute((Object)("adWebShop:" + string + "@" + user.getId()), () -> (AdWebShop)((DBQuery)this.from(new EntityPath[]{qAdWebShop}).where((Predicate)qAdWebShop.productNumber.equalsIgnoreCase(string).and((Predicate)qAdWebShop.owner().eq((Object)user)))).singleResult((Expression)qAdWebShop));
        try {
            if (adWebShop == null) {
                throw new EntityNotFoundException();
            }
            this.entityManagerHandler.checkAccess((IEntity)adWebShop);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            throw new EntityNotFoundException(AdWebShop.class, string);
        }
        return adWebShop;
    }

    public AdSearchData getAdSearchData(AdType adType, boolean bl) {
        AdSearchData adSearchData = new AdSearchData();
        this.fill(adSearchData, adType, null, bl);
        SessionData sessionData = this.getSessionData();
        BasicAdQuery basicAdQuery = (BasicAdQuery)QueryHelper.newQuery(BasicAdQuery.class);
        basicAdQuery.setOrderBy(sessionData.getConfiguration().getAdsSortOrder());
        if (bl && sessionData.isBroker()) {
            basicAdQuery.setBrokers(CollectionHelper.asSet((Object[])new UserVO[]{new UserVO(sessionData.getLoggedUser().getId())}));
        }
        basicAdQuery.setGroups(adSearchData.getDefaultGroupFilter());
        if (adSearchData.isAllowViewUserAd() && !adSearchData.isAllowViewUserWebShop()) {
            basicAdQuery.setType(AdType.ADVERTISEMENT);
        } else if (adSearchData.isAllowViewUserWebShop() && !adSearchData.isAllowViewUserAd()) {
            basicAdQuery.setType(AdType.WEB_SHOP);
        }
        HashSet hashSet = new HashSet();
        adSearchData.getSimpleViewAdCustomFields().forEach(customFieldDetailedVO -> {
            if (customFieldDetailedVO instanceof CustomFieldDetailedVO) {
                hashSet.add(customFieldDetailedVO);
            }
        });
        adSearchData.getAdvancedViewAdCustomFields().forEach(customFieldDetailedVO -> {
            if (customFieldDetailedVO instanceof CustomFieldDetailedVO) {
                hashSet.add(customFieldDetailedVO);
            }
        });
        basicAdQuery.setAdCustomValues(this.customFieldValueHandler.resolveDefaultSearchValues(hashSet));
        adSearchData.setQuery((QueryParameters)basicAdQuery);
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        adSearchData.setHideOwner(sessionData.isGuest() && configurationAccessor.isHideAdOwnerToGuests());
        adSearchData.setHidePrice(sessionData.isGuest() && configurationAccessor.isHideAdPriceToGuests());
        adSearchData.setAdInitialSearchType(configurationAccessor.getAdInitialSearchType());
        return adSearchData;
    }

    public Integer getAdvertisementsCount(User user, AdType adType) {
        BasicAdQuery basicAdQuery = new BasicAdQuery();
        basicAdQuery.setCountOnly();
        basicAdQuery.setOwner(new UserVO(user.getId()));
        basicAdQuery.setType(adType);
        this.checkStatus(this.isGuest(), user.equals((Object)this.getLoggedUser()), basicAdQuery, user);
        return this.search(basicAdQuery).getTotalCount();
    }

    public Set<AdCategoryVO> getCategories(Long l) {
        return new HashSet<AdCategoryVO>(((DBQuery)this.from(this.$).where((Predicate)((QBasicAd)this.$).id.eq((Object)l))).list(AdCategoryVO.class, (Expression)((QBasicAd)this.$).categories));
    }

    public UserFavoriteAdsListData getFavoritesListData(UserLocatorVO userLocatorVO) throws FrameworkException {
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)userLocatorVO);
        if (user == null) {
            throw new IllegalActionException();
        }
        UserFavoriteAdsListData userFavoriteAdsListData = new UserFavoriteAdsListData();
        userFavoriteAdsListData.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        userFavoriteAdsListData.setCurrencies(this.conversionHandler.convertList(CurrencyVO.class, (Iterable)this.currencyService.listForAds(user)));
        return userFavoriteAdsListData;
    }

    public UserAdsSearchData getUserAdsSearchData(UserLocatorVO userLocatorVO, AdType adType) {
        User user = userLocatorVO == null ? this.getLoggedUser() : this.userLocatorHandler.locate(userLocatorVO).getUser();
        UserAdsSearchData userAdsSearchData = new UserAdsSearchData();
        userAdsSearchData.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        this.fill((AdSearchData)userAdsSearchData, adType, user, false);
        MemberProductAccessor memberProductAccessor = this.productsHandler.getAccessor((BasicUser)user).member();
        int n = memberProductAccessor.getMaxAds();
        userAdsSearchData.setMaxAds(n);
        int n2 = this.getUserAdsCount(user);
        boolean bl = n2 < n;
        userAdsSearchData.setCanCreateNew(bl && (adType == AdType.ADVERTISEMENT || CollectionHelper.isNotEmpty((Iterable)userAdsSearchData.getCurrencies())));
        userAdsSearchData.setRequiresAuthorization(this.adRequiresAuthorization(adType, user));
        BasicAdQuery basicAdQuery = (BasicAdQuery)QueryHelper.newQuery(BasicAdQuery.class);
        basicAdQuery.setType(adType);
        basicAdQuery.setOwner(new UserVO(user.getId()));
        basicAdQuery.setReturnEditable(true);
        HashSet hashSet = new HashSet();
        userAdsSearchData.getSimpleViewAdCustomFields().forEach(customFieldDetailedVO -> {
            if (customFieldDetailedVO instanceof CustomFieldDetailedVO) {
                hashSet.add(customFieldDetailedVO);
            }
        });
        userAdsSearchData.getAdvancedViewAdCustomFields().forEach(customFieldDetailedVO -> {
            if (customFieldDetailedVO instanceof CustomFieldDetailedVO) {
                hashSet.add(customFieldDetailedVO);
            }
        });
        basicAdQuery.setAdCustomValues(this.customFieldValueHandler.resolveDefaultSearchValues(hashSet));
        userAdsSearchData.setQuery((QueryParameters)basicAdQuery);
        return userAdsSearchData;
    }

    public AdViewData getViewData(BasicAdVO basicAdVO) throws EntityNotFoundException {
        QBasicUser qBasicUser;
        Set set;
        BasicAdDTO basicAdDTO;
        SessionData sessionData = this.getSessionData();
        BasicAd basicAd = (BasicAd)this.conversionHandler.convert(BasicAd.class, (Object)basicAdVO);
        AdViewData adViewData = new AdViewData();
        adViewData.setEditable(true);
        adViewData.setRemovable(true);
        int n = 0;
        User user = null;
        try {
            user = (User)this.rawEntityManagerHandler.find(User.class, basicAd.getOwner().getId());
            n = this.productsHandler.getAccessor((BasicUser)user).member().getMaxAdImages();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        adViewData.setMaxImages(n);
        boolean bl = basicAd.getOwner().equals((Object)sessionData.getLoggedUser());
        if (basicAd instanceof AdWebShop) {
            List list = this.currencyService.listForAds(basicAd.getOwner(), false);
            adViewData.setCanBuy(basicAd.isInStock() && !bl && list.contains(basicAd.getPrice().getCurrency()));
            basicAdDTO = (BasicAdDTO)this.conversionHandler.convertExcluding(AdWebShopDTO.class, (Object)basicAd, new Object[]{AdWebShopDTO.DELIVERY_METHODS});
            set = this.conversionHandler.convertSet(AdDeliveryMethodVO.class, (Iterable)((AdWebShop)basicAd).getDeliveryMethods().stream().filter(AdDeliveryMethod::isEnabled).collect(Collectors.toSet()));
            ((AdWebShopDTO)basicAdDTO).setDeliveryMethods(set);
        } else {
            basicAdDTO = (BasicAdDTO)this.conversionHandler.convert(AdvertisementDTO.class, (Object)basicAd);
        }
        adViewData.setDto((EntityDTO)basicAdDTO);
        adViewData.setCanManageUser(sessionData.manages((BasicUser)basicAd.getOwner()));
        adViewData.setCanManagePendingAds(this.adServiceSecurity.canManagePendingAds(basicAd.getOwner(), basicAd.getType()));
        boolean bl2 = this.adRequiresAuthorization(basicAd);
        adViewData.setCanSetAsDraft(this.adServiceSecurity.canSetAsDraft(bl2, basicAd));
        adViewData.setAdRequiresAuthorization(bl2);
        adViewData.setCanViewAuthorizationNotes(this.adServiceSecurity.canViewAuthorizationNotes(basicAd));
        adViewData.setCanSetHidden(this.adServiceSecurity.canHideOrUnhideAd(bl2, basicAd));
        adViewData.setCanSubmitForAuthorization(this.adServiceSecurity.canSubmitForAuthorization(basicAd));
        adViewData.setExportFormats(this.conversionHandler.convertList(ExportFormatVO.class, (Iterable)this.exportFormatService.listByContext(ExportFormatContext.ADVERTISEMENT_DETAILS)));
        set = this.configurationHandler.getAccessor((BasicUser)basicAd.getOwner());
        adViewData.setAddressListData(this.adAddressService.getAddressListData(basicAd));
        adViewData.setAddressConfiguration(this.configurationService.toAddressConfiguration((ConfigurationAccessor)set));
        Set set2 = basicAd.getCategories();
        if (set2.isEmpty()) {
            adViewData.setCategories(Collections.emptyList());
        } else if (set2.size() == 1) {
            adViewData.setCategories(Collections.singletonList((AdCategoryDetailedVO)this.conversionHandler.convert(AdCategoryDetailedVO.class, CollectionHelper.first((Iterable)set2))));
        } else {
            List list = this.conversionHandler.convertList(AdCategoryDetailedVO.class, (Iterable)set2);
            qBasicUser = list.stream().collect(Collectors.toMap(adCategoryDetailedVO -> adCategoryDetailedVO, adCategoryDetailedVO -> StringHelper.join((Collection)ModelHelper.getHierarchyPath((Bean)adCategoryDetailedVO, (org.cyclos.model.Property)AdCategoryDetailedVO.PARENT), (String)"\n")));
            Collections.sort(list, (adCategoryDetailedVO, adCategoryDetailedVO2) -> ((String)qBasicUser.get(adCategoryDetailedVO)).compareTo((String)qBasicUser.get(adCategoryDetailedVO2)));
            adViewData.setCategories(list);
        }
        adViewData.setImages(this.adImageService.list((IEntity)new BasicAdVO(basicAd.getId())));
        adViewData.setCurrencies(basicAd.getPrice() == null ? Collections.emptyList() : Arrays.asList((CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)basicAd.getPrice().getCurrency())));
        adViewData.setPromotionalPeriodActive(basicAd.isPromotionalPeriodActive());
        adViewData.setQuestions(this.getAdQuestions(basicAd));
        adViewData.setQuestionsEnabled(true);
        adViewData.setCanAskQuestion(!bl);
        adViewData.setCanSendMessage(this.messageServiceSecurity.canSendMessageToUser(basicAd.getOwner()) && !bl);
        if (this.isAdmin()) {
            adViewData.setMessageCategories(this.conversionHandler.convertList(MessageCategoryVO.class, (Iterable)this.messageCategoryService.getAccessible()));
        }
        boolean bl3 = sessionData.isMember();
        adViewData.setCanSetAsFavorite(!bl && bl3);
        if (bl3) {
            qBasicUser = QBasicUser.basicUser;
            boolean bl4 = ((DBQuery)this.from(new EntityPath[]{qBasicUser}).where((Predicate)qBasicUser.favoriteAds.contains((Object)basicAd).and((Predicate)qBasicUser.eq((Object)sessionData.getLoggedUser())))).hasResults();
            adViewData.setFavorite(bl4);
        }
        adViewData.setCustomOperations(this.customOperationService.getRunnableOperationsForAd(new BasicAdVO(basicAd.getId())));
        adViewData.setHideOwner(sessionData.isGuest() && sessionData.getConfiguration().isHideAdOwnerToGuests());
        adViewData.setHidePrice(sessionData.isGuest() && sessionData.getConfiguration().isHideAdPriceToGuests());
        return adViewData;
    }

    @PostConstruct
    public void initialize() {
        this.restBeanPropertyMapping.register((org.cyclos.model.Property)NestedProperty.nested((org.cyclos.model.Property)BasicAdDTO.PRICE, (org.cyclos.model.Property)CurrencyAmountDTO.AMOUNT), "price");
        this.restBeanPropertyMapping.register((org.cyclos.model.Property)NestedProperty.nested((org.cyclos.model.Property)BasicAdDTO.PRICE, (org.cyclos.model.Property)CurrencyAmountDTO.CURRENCY), "currency");
    }

    public List<SitemapItemVO> listForSitemap() {
        Set set = this.groupsHandler.flatten((Collection)this.getConfiguration().getVisibleAdGroups());
        if (set.isEmpty()) {
            return Collections.emptyList();
        }
        final QAdImage qAdImage = QAdImage.adImage;
        QAdImage qAdImage2 = new QAdImage("i2");
        CustomProjection<SitemapItemVO> customProjection = new CustomProjection<SitemapItemVO>(SitemapItemVO.class){
            private static final long serialVersionUID = 1L;
            {
                super(clazz);
                this.add(new Expression[]{((QBasicAd)((AdServiceImpl)AdServiceImpl.this).$).id, ((QBasicAd)((AdServiceImpl)AdServiceImpl.this).$).creationDate, ((QBasicAd)((AdServiceImpl)AdServiceImpl.this).$).lastModified, qAdImage.id, qAdImage.key, qAdImage.width, qAdImage.height, qAdImage.contentType});
            }

            protected SitemapItemVO instantiate() {
                SitemapItemVO sitemapItemVO = new SitemapItemVO();
                sitemapItemVO.setType(SitemapItemType.AD);
                sitemapItemVO.setId((Long)this.get((Expression)((QBasicAd)((AdServiceImpl)AdServiceImpl.this).$).id));
                Date date = (Date)ObjectHelper.defaultValue((Object)((Date)this.get((Expression)((QBasicAd)((AdServiceImpl)AdServiceImpl.this).$).lastModified)), (Object)((Date)this.get((Expression)((QBasicAd)((AdServiceImpl)AdServiceImpl.this).$).creationDate)));
                if (date != null) {
                    sitemapItemVO.setLastModifiedMillis(String.valueOf(date.getTime()));
                }
                if (this.get((Expression)qAdImage.id) != null) {
                    sitemapItemVO.setImageKey(ImageVOConverter.getKey((String)this.get((Expression)qAdImage.key), (Integer)this.get((Expression)qAdImage.width), (Integer)this.get((Expression)qAdImage.height), (String)this.get((Expression)qAdImage.contentType)));
                }
                return sitemapItemVO;
            }
        };
        return ((DBQuery)((DBQuery)((DBQuery)this.from().leftJoin((CollectionExpression)((QBasicAd)this.$).images, (Path)qAdImage)).on((Predicate)qAdImage.order.eq((Expression)((DBQuery)this.rawEntityManagerHandler.subQuery(new EntityPath[]{qAdImage2}).where((Predicate)qAdImage2.ad().eq((Expression)this.$))).select((Expression)qAdImage2.order.min())))).where(new Predicate[]{((QBasicAd)this.$).status.eq((Object)AdStatus.ACTIVE), Expressions.currentDate().between((Expression)((QBasicAd)this.$).publicationPeriod().begin, (Expression)((QBasicAd)this.$).publicationPeriod().end), ((QBasicAd)this.$).owner().group().in((Collection)set), ((QBasicAd)this.$).owner().status.in((Object[])new UserStatus[]{UserStatus.ACTIVE, UserStatus.BLOCKED})})).list((Expression)customProjection);
    }

    public BasicAdVO loadVO(BasicAdVO basicAdVO) throws FrameworkException {
        BasicAd basicAd = (BasicAd)this.conversionHandler.convert(BasicAd.class, (Object)basicAdVO);
        AdType adType = basicAd.getType();
        switch (adType) {
            case ADVERTISEMENT: {
                return (BasicAdVO)this.conversionHandler.convert(AdvertisementVO.class, (Object)basicAd);
            }
            case WEB_SHOP: {
                return (BasicAdVO)this.conversionHandler.convert(AdWebShopVO.class, (Object)basicAd);
            }
        }
        throw new IllegalArgumentException();
    }

    public void markAsFavorite(@NotNull BasicAdVO basicAdVO, boolean bl) {
        Set set = this.getSessionData().getLoggedBasicUser().getFavoriteAds();
        BasicAd basicAd = (BasicAd)this.conversionHandler.convert(BasicAd.class, (Object)basicAdVO);
        CollectionHelper.addOrRemove((Collection)set, (Object)basicAd, (boolean)bl);
    }

    @Override
    public BasicAd newEntity(AdDataParams adDataParams) {
        boolean bl = adDataParams.getType() == AdType.WEB_SHOP;
        AdWebShop adWebShop = bl ? new AdWebShop() : new Advertisement();
        User user = (User)this.conversionHandler.convert(User.class, (Object)adDataParams.getUser());
        if (user == null) {
            user = this.getLoggedUser();
        }
        adWebShop.setOwner(user);
        User user2 = adWebShop.getOwner();
        Validator validator = new Validator();
        validator.property((org.cyclos.model.Property)BasicAdDTO.OWNER, MarketplaceKeys.Advertisements.OWNER).required();
        this.validate(validator, adWebShop, "newEntity");
        if (adDataParams.getBasedOnId() != null) {
            BasicAd basicAd = (BasicAd)this.find(adDataParams.getBasedOnId());
            adWebShop.setPublicationPeriod(basicAd.getPublicationPeriod());
        } else {
            TimeInterval timeInterval = this.productsHandler.getAccessor((BasicUser)user2).member().getDefaultAdPublicationTime();
            if (timeInterval != null && timeInterval.isValid()) {
                TimeZone timeZone = this.getSessionData().getConfiguration().getTimeZone();
                Date date = DateHelper.shiftToBegin((Date)DateHelper.now(), (TimeZone)timeZone);
                Date date2 = DateHelper.add((Date)DateHelper.shiftToEnd((Date)date, (TimeZone)timeZone), (ITimeInterval)timeInterval);
                adWebShop.setPublicationPeriod(new DatePeriod(date, date2));
            }
        }
        return adWebShop;
    }

    public void reject(@NotNull BasicAdVO basicAdVO, String string) throws FrameworkException {
        BasicAd basicAd = (BasicAd)this.conversionHandler.convert(BasicAd.class, (Object)basicAdVO);
        if (basicAd.getStatus() != AdStatus.PENDING) {
            throw new IllegalActionException("Attempting to reject an ad in status " + String.valueOf(basicAd.getStatus()));
        }
        basicAd.setStatus(AdStatus.DRAFT);
        basicAd.setAuthorizationNotes(string);
        this.adSearchHandler.index((NetworkedEntity)basicAd);
        FormatterImpl formatterImpl = this.getFormatter();
        this.entityLogService.log((SimpleEntity)basicAd, this.message(MarketplaceKeys.Advertisements.STATUS, new Object[0]), BasicAdDTO.STATUS.getName(), formatterImpl.format((HasMessageKey)AdStatus.PENDING), formatterImpl.format((HasMessageKey)AdStatus.DRAFT), null);
        this.notificationHandler.user((BasicUser)basicAd.getOwner()).marketplaceSeller().adRejected(basicAd, basicAd.getName());
    }

    public void removeAll(User user, boolean bl) {
        CloseableIterator closeableIterator = ((DBQuery)this.from(this.$).where(new Predicate[]{((QBasicAd)this.$).owner().eq((Object)user), ((QBasicAd)this.$).deletedDate.isNull()})).iterate((Expression)this.$);
        this.processBatch(closeableIterator, (T basicAd) -> {
            this.doRemove((BasicAd)basicAd, false);
            if (bl) {
                basicAd.setName("");
                basicAd.setDescription(null);
            }
        });
    }

    public void removeAllFavorites(User user) {
        user.getFavoriteAds().clear();
    }

    public Page<BasicAdVO> search(BasicAdQuery basicAdQuery) {
        if (basicAdQuery.getAddressResult() == AdAddressResult.ALL_LOCATED_ADDRESSES) {
            QueryHelper.applyMaxResultsOnMap((QueryParameters)basicAdQuery);
        }
        return this.adSearchHandler.search((QueryParameters)basicAdQuery);
    }

    public void setAsDraft(BasicAdVO basicAdVO, String string) {
        BasicAd basicAd = (BasicAd)this.conversionHandler.convert(BasicAd.class, (Object)basicAdVO);
        AdStatus adStatus = basicAd.getStatus();
        if (!this.adServiceSecurity.canSetAsDraft(this.adRequiresAuthorization(basicAd), basicAd)) {
            throw new IllegalActionException();
        }
        if (!basicAd.getOwner().equals((Object)this.getLoggedUser())) {
            basicAd.setAuthorizationNotes(string);
        }
        basicAd.setStatus(AdStatus.DRAFT);
        this.adSearchHandler.index((NetworkedEntity)basicAd);
        FormatterImpl formatterImpl = this.getFormatter();
        this.entityLogService.log((SimpleEntity)basicAd, this.message(MarketplaceKeys.Advertisements.STATUS, new Object[0]), BasicAdDTO.STATUS.getName(), formatterImpl.format((HasMessageKey)adStatus), formatterImpl.format((HasMessageKey)AdStatus.DRAFT), null);
    }

    public void setHidden(BasicAdVO basicAdVO, boolean bl) {
        BasicAd basicAd = (BasicAd)this.conversionHandler.convert(BasicAd.class, (Object)basicAdVO);
        AdStatus adStatus = basicAd.getStatus();
        boolean bl2 = this.adRequiresAuthorization(basicAd);
        if (!this.adServiceSecurity.canHideOrUnhideAd(bl2, adStatus, basicAd.getPersistedStatus(), basicAd.getOwner())) {
            throw new IllegalActionException();
        }
        basicAd.setStatus(bl ? AdStatus.HIDDEN : AdStatus.ACTIVE);
        this.adSearchHandler.index((NetworkedEntity)basicAd);
        FormatterImpl formatterImpl = this.getFormatter();
        this.entityLogService.log((SimpleEntity)basicAd, this.message(MarketplaceKeys.Advertisements.STATUS, new Object[0]), BasicAdDTO.STATUS.getName(), formatterImpl.format((HasMessageKey)adStatus), formatterImpl.format((HasMessageKey)basicAd.getStatus()), null);
    }

    public void submitForAuthorization(@NotNull BasicAdVO basicAdVO) {
        BasicAd basicAd = (BasicAd)this.conversionHandler.convert(BasicAd.class, (Object)basicAdVO);
        if (!this.adServiceSecurity.canSubmitForAuthorization(basicAd)) {
            throw new IllegalActionException();
        }
        BasicAdDTO basicAdDTO = this.toDTO(basicAd);
        basicAdDTO.setStatus(AdStatus.PENDING);
        this.save(basicAdDTO);
    }

    @Override
    public BasicAdDTO toDTO(BasicAd basicAd) {
        if (basicAd.getDeletedDate() != null) {
            throw new EntityNotFoundException(BasicAd.class, basicAd.getId());
        }
        return (BasicAdDTO)super.toDTO(basicAd);
    }

    @Override
    protected void addCustomNameValidations(Property property, BasicAdDTO basicAdDTO) {
        property.maxWordSize(50);
    }

    @Override
    protected void doRemove(BasicAd basicAd, boolean bl) {
        Date date = DateHelper.now();
        basicAd.setDeletedDate(date);
        AdHistoryLog adHistoryLog = this.getLastAdHistoryLogEntry(basicAd);
        if (adHistoryLog != null) {
            adHistoryLog.setEndDate(date);
        }
        this.adImageService.removeAll((BaseEntity)basicAd);
        this.customFieldValueHandler.removeAll((EntityWithCustomValues)basicAd);
        basicAd.getAddresses().clear();
        basicAd.getCategories().clear();
        if (basicAd instanceof AdWebShop) {
            ((AdWebShop)basicAd).getDeliveryMethods().clear();
        }
        this.adSearchHandler.remove(basicAd.getId());
        if (bl) {
            this.flush();
        }
    }

    @Override
    protected AdDetailsData getData(BasicAd basicAd) {
        Object object;
        Object object2;
        WebShopAdDetailsData webShopAdDetailsData;
        ProductsAccessor productsAccessor = this.productsHandler.getAccessor((BasicUser)basicAd.getOwner());
        MemberProductAccessor memberProductAccessor = productsAccessor.member();
        SessionData sessionData = this.getSessionData();
        boolean bl = basicAd instanceof AdWebShop;
        WebShopAdDetailsData webShopAdDetailsData2 = bl ? new WebShopAdDetailsData() : new AdDetailsData();
        webShopAdDetailsData2.setDto((EntityDTO)this.toDTO(basicAd));
        webShopAdDetailsData2.setMaxImages(memberProductAccessor.getMaxAdImages());
        int n = memberProductAccessor.getMaxAdDescriptionSize();
        if (n == 0) {
            n = 1000;
        }
        webShopAdDetailsData2.setDescriptionMaxLength(Integer.valueOf(n));
        webShopAdDetailsData2.setMaxCategoriesPerAd(Integer.valueOf(memberProductAccessor.getMaxCategoriesPerAd()));
        webShopAdDetailsData2.setMaxAddressesPerAd(Integer.valueOf(memberProductAccessor.getMaxAddressesPerAd()));
        ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)basicAd.getOwner());
        webShopAdDetailsData2.setAddressListData(this.adAddressService.getAddressListData(basicAd));
        webShopAdDetailsData2.setAddressConfiguration(this.configurationService.toAddressConfiguration(configurationAccessor));
        List list = this.adCustomFieldService.listVisibleActionsEnabledToOwner(basicAd.getOwner());
        webShopAdDetailsData2.setCustomFieldActions(list);
        List list2 = list.stream().map(AdCustomFieldActions::getCustomField).collect(Collectors.toList());
        HashMap<String, BasicAd> hashMap = new HashMap<String, BasicAd>();
        hashMap.put("ad", basicAd);
        this.customFieldValueHandler.fillValuesFromScript(AdCustomField.class, LoadValuesScriptFunction.ENTITY, hashMap, list2);
        this.customFieldValueHandler.setDefaultValues(list2, (ModelWithCustomValues)webShopAdDetailsData2.getDto());
        List list3 = this.currencyService.listForAds(basicAd.getOwner(), false);
        if (basicAd.isTransient() || basicAd.getPrice() == null || !list3.contains(basicAd.getCurrency())) {
            webShopAdDetailsData2.setCurrencies(this.conversionHandler.convertList(CurrencyVO.class, (Iterable)list3));
        } else {
            webShopAdDetailsData2.setCurrencies(Arrays.asList((CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)basicAd.getPrice().getCurrency())));
        }
        if (basicAd.getCurrency() != null) {
            webShopAdDetailsData2.setCurrencyNotAvailable(!list3.contains(basicAd.getCurrency()));
        }
        int n2 = memberProductAccessor.getMaxAds();
        int n3 = this.getUserAdsCount(basicAd.getOwner()) + (basicAd.isTransient() ? 1 : 0);
        boolean bl2 = n3 < n2;
        webShopAdDetailsData2.setCanCreateNew(bl2 && (basicAd.getType() == AdType.ADVERTISEMENT || CollectionHelper.isNotEmpty((Iterable)webShopAdDetailsData2.getCurrencies())));
        webShopAdDetailsData2.setCanCreateNew(bl2);
        ConfigurationAccessor configurationAccessor2 = this.configurationHandler.getAccessor((BasicUser)basicAd.getOwner());
        if (productsAccessor.product().getMaxAddresses() > 0 && configurationAccessor2.isUseMap()) {
            webShopAdDetailsData2.setCanSetAddress(true);
            webShopAdDetailsData2.setAddresses(this.addressService.getAddresses(basicAd.getOwner(), true, true));
        }
        boolean bl3 = this.adRequiresAuthorization(basicAd);
        webShopAdDetailsData2.setAdsRequireAuthorization(bl3);
        webShopAdDetailsData2.setCanHide(this.adServiceSecurity.canHideOrUnhideAd(bl3, basicAd));
        webShopAdDetailsData2.setCanSubmitForAuthorization(this.adServiceSecurity.canSubmitForAuthorization(basicAd));
        webShopAdDetailsData2.setCanSaveAsDraft(this.adServiceSecurity.canSaveAsDraft(bl3, basicAd));
        webShopAdDetailsData2.setCategories(this.adCategoryService.listVisible(basicAd.getOwner()));
        if (bl) {
            webShopAdDetailsData = webShopAdDetailsData2;
            webShopAdDetailsData.setWebShopAdsRequireAuthorization(memberProductAccessor.isWebShopAdsRequireAuthorization());
            object2 = this.adWebShopSettingService.getAdWebShopSetting(basicAd.getOwner());
            webShopAdDetailsData.setSetting((AdWebShopSettingVO)this.conversionHandler.convert(AdWebShopSettingVO.class, object2));
            object = this.adDeliveryMethodService.listAllowed(basicAd.getOwner());
            webShopAdDetailsData.setDeliveryMethods(this.conversionHandler.convertList(AdDeliveryMethodVO.class, (Iterable)object));
        }
        if (basicAd.isPersistent()) {
            webShopAdDetailsData2.setImages(this.adImageService.list((IEntity)new BasicAdVO(basicAd.getId())));
            webShopAdDetailsData2.setQuestions(this.getAdQuestions(basicAd));
            webShopAdDetailsData = memberProductAccessor.getDefaultAdPublicationTime();
            object2 = sessionData.getConfiguration().getTimeZone();
            object = DateHelper.shiftToBegin((Date)DateHelper.now(), (TimeZone)object2);
            Date date = DateHelper.add((Date)DateHelper.shiftToEnd((Date)object, (TimeZone)object2), (ITimeInterval)webShopAdDetailsData);
            if (basicAd.getStatus() == AdStatus.EXPIRED || ObjectHelper.isOneOf((Object)basicAd.getStatus(), (Object[])new Object[]{AdStatus.DRAFT, AdStatus.PENDING}) && !this.adRequiresAuthorization(basicAd)) {
                ((BasicAdDTO)webShopAdDetailsData2.getDto()).getPublicationPeriod().setBegin(this.toDateTime((Date)object));
                ((BasicAdDTO)webShopAdDetailsData2.getDto()).getPublicationPeriod().setEnd(this.toDateTime(date));
                ((BasicAdDTO)webShopAdDetailsData2.getDto()).setPromotionalPeriod(null);
            }
        }
        webShopAdDetailsData2.setHideOwner(sessionData.isGuest() && sessionData.getConfiguration().isHideAdOwnerToGuests());
        webShopAdDetailsData2.setHidePrice(sessionData.isGuest() && sessionData.getConfiguration().isHideAdPriceToGuests());
        return webShopAdDetailsData2;
    }

    @Override
    protected String getNameLabel(BasicAdDTO basicAdDTO) {
        return this.message(MarketplaceKeys.Advertisements.NAME, new Object[0]);
    }

    @Override
    protected Pair<DBQuery<?>, String> getUniqueNameQuery(BasicAdDTO basicAdDTO) {
        return null;
    }

    @Override
    protected void onAfterSave(BasicAd basicAd, BasicAd basicAd2, Object object) {
        AdWebShop adWebShop;
        AdWebShopSetting adWebShopSetting;
        this.customFieldValueHandler.processAfterSave((EntityWithCustomValues)basicAd);
        if ((basicAd2 == null || basicAd2.getStatus() == AdStatus.DRAFT) && basicAd.getStatus() == AdStatus.PENDING) {
            this.notificationHandler.admin().adPendingAuthorization(basicAd);
            basicAd.getOwner().getBrokers().stream().forEach(user -> this.notificationHandler.user((BasicUser)user).brokering().adPendingAuthorization(basicAd, basicAd, basicAd.getOwner()));
        }
        this.updateAdHistoryLog(basicAd, basicAd2);
        if (this.shouldNotifyInterested(basicAd)) {
            this.backgroundTaskHandler.schedule(AdInterestNotificationBackgroundTask.scheduling(basicAd));
        }
        if (basicAd instanceof AdWebShop && (adWebShopSetting = this.adWebShopSettingService.getAdWebShopSetting((adWebShop = (AdWebShop)basicAd).getOwner())) != null && adWebShopSetting.isProductNumberGenerated()) {
            String string = adWebShop.getId().toString();
            if (string.length() < 5) {
                string = StringUtils.leftPad((String)string, (int)5, (char)'0');
            }
            adWebShop.setProductNumber(string);
        }
        this.adImageService.importTempImages((BaseEntity)basicAd, basicAd.getUploadedImages());
        this.adSearchHandler.index((NetworkedEntity)basicAd);
    }

    @Override
    protected Object onBeforeSave(BasicAd basicAd, BasicAd basicAd2) {
        List list;
        Currency currency;
        User user;
        if (basicAd.isTransient()) {
            user = basicAd.getOwner();
            int n = this.productsHandler.getAccessor((BasicUser)user).member().getMaxAds();
            int n2 = this.getUserAdsCount(user);
            if (n2 >= n) {
                throw new MaxItemsException(n);
            }
            if (basicAd.getCreationDate() == null) {
                basicAd.setCreationDate(DateHelper.now());
            }
        }
        if (basicAd.getPromotionalPrice() == null) {
            basicAd.setPromotionalPeriod(null);
        }
        if (basicAd.getPromotionalPeriod() != null && basicAd.getPromotionalPeriod().getEnd().after(DateHelper.now())) {
            basicAd.setDoProcess(true);
        }
        if (basicAd2 != null) {
            basicAd.setLastModified(new Date());
            if (basicAd.getPublicationPeriod().getEnd().after(basicAd2.getPublicationPeriod().getEnd())) {
                basicAd.setExpirationNotified(false);
            }
            if (!this.adServiceSecurity.canViewAddresses(basicAd2.getOwner()) && CollectionHelper.isNotEmpty((Iterable)basicAd2.getAddresses())) {
                basicAd.setAddresses(basicAd2.getAddresses());
            }
        }
        basicAd.getPublicationPeriod().setBegin(DateHelper.shiftToBegin((Date)basicAd.getPublicationPeriod().getBegin(), (TimeZone)this.getConfiguration().getTimeZone(), (boolean)true));
        basicAd.getPublicationPeriod().setEnd(DateHelper.shiftToEnd((Date)basicAd.getPublicationPeriod().getEnd(), (TimeZone)this.getConfiguration().getTimeZone(), (boolean)true));
        if (basicAd.getPromotionalPeriod() != null) {
            basicAd.getPromotionalPeriod().setBegin(DateHelper.shiftToBegin((Date)basicAd.getPromotionalPeriod().getBegin(), (TimeZone)this.getConfiguration().getTimeZone(), (boolean)true));
            basicAd.getPromotionalPeriod().setEnd(DateHelper.shiftToEnd((Date)basicAd.getPromotionalPeriod().getEnd(), (TimeZone)this.getConfiguration().getTimeZone(), (boolean)true));
        }
        if ((user = basicAd.getPrice()) != null && user.getAmount() != null && user.getCurrency() == null && (currency = (Currency)CollectionHelper.first((Iterable)(list = this.currencyService.listForAds(basicAd.getOwner(), false)))) != null) {
            user.setCurrency(currency);
            user.setAmount(BigDecimalHelper.round((BigDecimal)user.getAmount(), (int)currency.getPrecision()));
            basicAd.setPrice((CurrencyAmount)user);
        }
        if (basicAd instanceof AdWebShop) {
            AdWebShop adWebShop = (AdWebShop)basicAd;
            if (adWebShop.getStockType() == AdWebShopStockType.NOT_AVAILABLE) {
                adWebShop.setStockQuantity(null);
                adWebShop.setMaxAllowedInCart(null);
                adWebShop.setMinAllowedInCart(null);
                adWebShop.setMinimumStockLimit(null);
            }
            if (basicAd2 != null) {
                AdWebShop adWebShop2 = (AdWebShop)basicAd2;
                if (adWebShop.getStockType() == AdWebShopStockType.QUANTITY) {
                    BigDecimal bigDecimal = BigDecimalHelper.zeroWhenNull((BigDecimal)adWebShop2.getMinimumStockLimit());
                    BigDecimal bigDecimal2 = BigDecimalHelper.zeroWhenNull((BigDecimal)adWebShop2.getStockQuantity());
                    BigDecimal bigDecimal3 = BigDecimalHelper.zeroWhenNull((BigDecimal)adWebShop.getMinimumStockLimit());
                    BigDecimal bigDecimal4 = BigDecimalHelper.zeroWhenNull((BigDecimal)adWebShop.getStockQuantity());
                    if (!(BigDecimalHelper.compareTo((BigDecimal)bigDecimal4, (BigDecimal)bigDecimal3) <= 0 || BigDecimalHelper.areEquals((BigDecimal)bigDecimal, (BigDecimal)bigDecimal3) && BigDecimalHelper.areEquals((BigDecimal)bigDecimal2, (BigDecimal)bigDecimal4))) {
                        adWebShop.setLowStockNotified(Boolean.valueOf(false));
                    }
                }
            }
        }
        if (ObjectHelper.isOneOf((Object)basicAd.getStatus(), (Object[])new Object[]{AdStatus.EXPIRED, AdStatus.SCHEDULED, AdStatus.DISABLED})) {
            basicAd.setStatus(AdStatus.ACTIVE);
        }
        basicAd.setRemovedFromOwner(false);
        return null;
    }

    @Override
    protected void preProcessCurrentCopy(BasicAdDTO basicAdDTO, BasicAd basicAd) {
        basicAd.getCustomValues().size();
        if (CollectionHelper.isNotEmpty((Iterable)basicAd.getCustomValues())) {
            for (AdCustomFieldValue adCustomFieldValue : basicAd.getCustomValues()) {
                adCustomFieldValue.getEnumeratedValues().size();
                adCustomFieldValue.getFileValues().size();
                adCustomFieldValue.getImageValues().size();
            }
        }
        basicAd.getAddresses().size();
        basicAd.getCategories().size();
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QBasicAd)this.$).owner().network());
    }

    @Override
    protected ExtensionPointAccessor resolveExtensionPointAccessor(CRUDOperation cRUDOperation, BasicAd basicAd) {
        AdExtensionPointEvent adExtensionPointEvent;
        try {
            adExtensionPointEvent = AdExtensionPointEvent.valueOf((String)cRUDOperation.name());
        }
        catch (Exception exception) {
            return null;
        }
        return this.extensionPointService.newAccessor((ExtensionPointEvent)adExtensionPointEvent, new ExtensionPointFilter(basicAd.getOwner().getGroup())).attribute("ad", (Object)basicAd);
    }

    @Override
    protected Validator resolveValidator(final BasicAdDTO basicAdDTO) {
        Validator validator = this.resolveCommonValidator(basicAdDTO);
        if (basicAdDTO instanceof AdvertisementDTO) {
            this.addAdvertisementValidations(basicAdDTO, validator);
        } else {
            this.addWebshopValidations(basicAdDTO, validator);
        }
        validator.property((org.cyclos.model.Property)BasicAdDTO.CATEGORIES, MarketplaceKeys.Advertisements.CATEGORY).add((PropertyValidation)new BasePropertyValidation(){

            protected boolean isValid(Object object, Object object2, Object object3) {
                Set set = (Set)object3;
                Set set2 = this.getConversionHandler().convertSet(AdCategory.class, (Iterable)set);
                if (set2 == null) {
                    return true;
                }
                if (set2.stream().filter(adCategory -> !adCategory.isLeaf()).count() == 0L) {
                    return true;
                }
                User user = AdServiceImpl.this.userLocatorHandler.toUserOrCurrent((BasicUserVO)basicAdDTO.getOwner());
                List list = AdServiceImpl.this.adCategoryService.listVisible(user);
                for (AdCategoryVO adCategoryVO : set) {
                    if (list.contains(adCategoryVO)) continue;
                    return false;
                }
                return false;
            }
        });
        return validator;
    }

    @Override
    protected BidiMap<Class<? extends BasicAd>, Class<? extends BasicAdDTO>> subClassMappings() {
        return SUBCLASS_MAPPINGS;
    }

    private void addAdvertisementValidations(BasicAdDTO basicAdDTO, Validator validator) {
        CurrencyAmountDTO currencyAmountDTO = basicAdDTO.getPrice();
        if (currencyAmountDTO != null && currencyAmountDTO.getAmount() != null) {
            this.validatePrice(validator, basicAdDTO);
        } else if (currencyAmountDTO == null && basicAdDTO.getPromotionalPrice() != null) {
            validator.property((org.cyclos.model.Property)BasicAdDTO.PROMOTIONAL_PRICE, MarketplaceKeys.Advertisements.PROMOTIONAL_PRICE).invalid();
        }
    }

    private void addPublicationPeriodValidations(BasicAdDTO basicAdDTO, Validator validator, User user) {
        Property property = validator.property((org.cyclos.model.Property)BasicAdDTO.PUBLICATION_PERIOD, MarketplaceKeys.Advertisements.PUBLICATION_PERIOD);
        property.required().period();
        TimeInterval timeInterval = this.productsHandler.getAccessor((BasicUser)user).member().getMaxAdPublicationTime();
        if (timeInterval != null && RequiredValidation.isValid((Object)basicAdDTO.getPublicationPeriod())) {
            TimeZone timeZone = this.getSessionData().getConfiguration().getTimeZone();
            Date date = DateHelper.add((Date)DateHelper.shiftToEnd((Date)this.toDate(basicAdDTO.getPublicationPeriod().getBegin()), (TimeZone)timeZone), (ITimeInterval)timeInterval);
            property.nested((org.cyclos.model.Property)DatePeriodDTO.END, GeneralKeys.Ui.PERIOD_END).add((object, object2, object3) -> {
                Date date2 = this.toDate((DateTime)object3);
                if (date2 != null && date2.after(date)) {
                    TimeInterval timeInterval = this.productsHandler.getAccessor((BasicUser)user).member().getMaxAdPublicationTime();
                    return new ValidationError(MarketplaceKeys.Advertisements.ERROR_MAX_PUBLICATION_PERIOD_EXCEEDED, new Object[]{this.getFormatter().format((ITimeInterval)timeInterval).toLowerCase()});
                }
                return null;
            });
        }
    }

    private void addStatusValidations(BasicAdDTO basicAdDTO, Validator validator, User user) {
        boolean bl;
        block22: {
            boolean bl2;
            boolean bl3;
            AdStatus adStatus;
            AdStatus adStatus2;
            boolean bl4;
            boolean bl5;
            block21: {
                AdType adType = basicAdDTO instanceof AdWebShopDTO ? AdType.WEB_SHOP : AdType.ADVERTISEMENT;
                bl5 = this.adRequiresAuthorization(adType, user);
                bl4 = ImportHandler.isImported((EntityDTO)basicAdDTO);
                adStatus2 = null;
                adStatus = null;
                if (basicAdDTO.isPersistent()) {
                    BasicAd basicAd = (BasicAd)this.find(basicAdDTO.getId());
                    adStatus2 = basicAd.getStatus();
                    adStatus = basicAd.getPersistedStatus();
                }
                bl3 = basicAdDTO.isTransient();
                if (basicAdDTO.getStatus() == null) {
                    if (bl4) {
                        basicAdDTO.setStatus(AdStatus.ACTIVE);
                    } else if (bl3) {
                        basicAdDTO.setStatus(bl5 ? AdStatus.DRAFT : AdStatus.ACTIVE);
                    } else {
                        basicAdDTO.setStatus(!bl5 && ObjectHelper.isOneOf((Object)adStatus, (Object[])new Object[]{AdStatus.DRAFT, AdStatus.PENDING}) ? AdStatus.ACTIVE : adStatus);
                    }
                }
                bl2 = basicAdDTO instanceof AdvertisementDTO && this.hasPermission(Permission.USER_PENDING_ADS_MANAGE) || basicAdDTO instanceof AdWebShopDTO && this.hasPermission(Permission.USER_PENDING_WEB_SHOP_MANAGE);
                bl = false;
                if (!user.equals((Object)this.getLoggedUser())) break block21;
                switch (basicAdDTO.getStatus()) {
                    case HIDDEN: {
                        bl = !bl5;
                        break block22;
                    }
                    case ACTIVE: 
                    case EXPIRED: 
                    case SCHEDULED: {
                        bl = this.adServiceSecurity.canActivateMyAd(bl3, bl5, adStatus);
                        break block22;
                    }
                    case DISABLED: {
                        bl = false;
                        break block22;
                    }
                    case DRAFT: {
                        bl = bl5 && (bl3 || adStatus == AdStatus.DRAFT);
                        break block22;
                    }
                    case PENDING: {
                        bl = bl5 && (bl3 || adStatus == AdStatus.DRAFT);
                        break block22;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            switch (basicAdDTO.getStatus()) {
                case ACTIVE: 
                case EXPIRED: 
                case SCHEDULED: {
                    bl = bl4 || this.adServiceSecurity.canActivateUserAd(bl3, bl5, adStatus, bl2);
                    break;
                }
                case DISABLED: {
                    bl = false;
                    break;
                }
                case DRAFT: {
                    bl = bl5 && (bl4 || adStatus == AdStatus.PENDING && bl2);
                    break;
                }
                case HIDDEN: {
                    bl = bl4 || this.adServiceSecurity.canHideOrUnhideAd(bl5, adStatus2, adStatus, user);
                    break;
                }
                case PENDING: {
                    bl = bl5 && (bl4 || bl3 && !bl2) || adStatus == AdStatus.PENDING && bl2;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (!bl) {
            validator.property((org.cyclos.model.Property)BasicAdDTO.STATUS, MarketplaceKeys.Advertisements.STATUS).invalid();
        }
    }

    private void addWebshopValidations(BasicAdDTO basicAdDTO, Validator validator) {
        Property property;
        final AdWebShopDTO adWebShopDTO = (AdWebShopDTO)basicAdDTO;
        this.validatePrice(validator, basicAdDTO);
        User user = this.userLocatorHandler.toUserOrCurrent((BasicUserVO)adWebShopDTO.getOwner());
        AdWebShopSetting adWebShopSetting = this.adWebShopSettingService.getAdWebShopSetting(user);
        if (adWebShopSetting != null && !adWebShopSetting.isProductNumberGenerated()) {
            property = validator.property((org.cyclos.model.Property)AdWebShopDTO.PRODUCT_NUMBER, MarketplaceKeys.Advertisements.PRODUCT_NUMBER);
            property.required().maskValue(adWebShopSetting.getProductNumberMask()).add((PropertyValidation)new BasePropertyValidation(){

                protected boolean isValid(Object object, Object object2, Object object3) {
                    return !((String)object3).contains("@");
                }
            });
            if (adWebShopDTO.getProductNumber() != null) {
                QAdWebShop qAdWebShop = QAdWebShop.adWebShop;
                DBQuery dBQuery = (DBQuery)this.from(new EntityPath[]{qAdWebShop}).where(new Predicate[]{qAdWebShop.owner().eq((Object)user), qAdWebShop.productNumber.eq((Object)adWebShopDTO.getProductNumber())});
                if (basicAdDTO.isPersistent()) {
                    dBQuery.where((Predicate)qAdWebShop.id.ne((Object)basicAdDTO.getId()));
                }
                property.unique("adWebShop_" + user.getId() + "_" + adWebShopDTO.getProductNumber(), (AbstractJPAQuery)dBQuery);
            }
        }
        if (adWebShopDTO.getMaxAllowedInCart() != null && adWebShopDTO.getMinAllowedInCart() != null) {
            validator.property((org.cyclos.model.Property)AdWebShopDTO.MIN_ALLOWED_IN_CART, MarketplaceKeys.Advertisements.MIN_ALLOWED_IN_CART).lessThan((Comparable)((Object)(adWebShopDTO.isAllowDecimal() ? adWebShopDTO.getMaxAllowedInCart() : Integer.valueOf(adWebShopDTO.getMaxAllowedInCart().intValue()))));
        }
        if (adWebShopDTO.getStockType() == AdWebShopStockType.QUANTITY) {
            validator.property((org.cyclos.model.Property)AdWebShopDTO.STOCK_QUANTITY, MarketplaceKeys.Advertisements.STOCK_QUANTITY).required().positiveNonZero();
            property = validator.property((org.cyclos.model.Property)AdWebShopDTO.MINIMUM_STOCK_LIMIT, MarketplaceKeys.Advertisements.MINIMUM_STOCK_LIMIT);
            property.positiveNonZero(2);
            if (adWebShopDTO.getMinimumStockLimit() != null) {
                property.add((PropertyValidation)new BasePropertyValidation(new ValidationError(MarketplaceKeys.Advertisements.ERROR_STOCK_LIMIT_GREATER_THAN_STOCK)){

                    protected boolean isValid(Object object, Object object2, Object object3) {
                        if (adWebShopDTO.getMinimumStockLimit() != null && adWebShopDTO.getStockQuantity() != null) {
                            if (adWebShopDTO.isAllowDecimal()) {
                                return BigDecimalHelper.compareTo((BigDecimal)adWebShopDTO.getMinimumStockLimit(), (BigDecimal)adWebShopDTO.getStockQuantity()) <= 0;
                            }
                            return adWebShopDTO.getMinimumStockLimit().intValue() <= adWebShopDTO.getStockQuantity().intValue();
                        }
                        return true;
                    }
                });
            }
        }
        validator.property((org.cyclos.model.Property)AdWebShopDTO.DELIVERY_METHODS, MarketplaceKeys.Advertisements.DELIVERY_METHODS).add((object, object2, object3) -> {
            AdWebShopDTO adWebShopDTO = (AdWebShopDTO)object;
            if (CollectionHelper.isNotEmpty((Iterable)adWebShopDTO.getDeliveryMethods())) {
                for (AdDeliveryMethodVO adDeliveryMethodVO : adWebShopDTO.getDeliveryMethods()) {
                    AdDeliveryMethod adDeliveryMethod = (AdDeliveryMethod)this.conversionHandler.convert(AdDeliveryMethod.class, (Object)adDeliveryMethodVO);
                    if (adDeliveryMethod.isEnabled() && !adDeliveryMethod.isRemovedFromOwner()) continue;
                    return new ValidationError(MarketplaceKeys.Advertisements.ERROR_INVALID_DELIVERY_METHODS);
                }
            }
            return null;
        });
    }

    private boolean adHistoryLogUpdateNeeded(BasicAd basicAd, BasicAd basicAd2) {
        if (basicAd2 == null) {
            return true;
        }
        DatePeriod datePeriod = basicAd2.getPublicationPeriod();
        DatePeriod datePeriod2 = basicAd.getPublicationPeriod();
        return !datePeriod2.getBegin().equals(datePeriod.getBegin()) || !datePeriod2.getEnd().equals(datePeriod.getEnd()) || basicAd.isHidden() != basicAd2.isHidden() || basicAd.isRemovedFromOwner() != basicAd2.isRemovedFromOwner();
    }

    private void fill(AdSearchData adSearchData, AdType adType, User user, boolean bl) {
        SessionData sessionData = this.getSessionData();
        ConfigurationAccessor configurationAccessor = sessionData.getConfiguration();
        this.profileFieldHandler.fill((DataWithBasicProfileFields)adSearchData);
        adSearchData.setResultType(configurationAccessor.getAdsResultType());
        adSearchData.setCategories(this.adCategoryService.listVisible(user));
        adSearchData.setAdCategoriesResultType(configurationAccessor.getAdCategoriesResultType());
        adSearchData.setAdSubCategoriesResults(Integer.valueOf(configurationAccessor.getAdSubCategoriesResults()));
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("user", user);
        hashMap.put("adType", adType);
        List list = this.adCustomFieldService.listVisible(user, sessionData.isAdmin() || bl);
        List list2 = list.stream().filter(adCustomField -> adCustomField.getSearchVisibility() == AdCustomFieldSearchVisibility.SIMPLE_MODE).map(this.conversionHandler.convertingFunction(CustomFieldDetailedVO.class, new Object[0])).collect(Collectors.toList());
        List list3 = list.stream().filter(adCustomField -> adCustomField.getSearchVisibility() == AdCustomFieldSearchVisibility.ADVANCED_MODE).map(this.conversionHandler.convertingFunction(CustomFieldDetailedVO.class, new Object[0])).collect(Collectors.toList());
        this.customFieldValueHandler.fillValuesFromScript(AdCustomField.class, LoadValuesScriptFunction.FILTER, hashMap, list2);
        this.customFieldValueHandler.fillValuesFromScript(AdCustomField.class, LoadValuesScriptFunction.FILTER, hashMap, list3);
        adSearchData.setSimpleViewAdCustomFields(list2);
        adSearchData.setAdvancedViewAdCustomFields(list3);
        adSearchData.setCurrencies(this.conversionHandler.convertList(CurrencyVO.class, (Iterable)this.currencyService.listForAds(user)));
        List list4 = this.profileFieldHandler.getSearchFilters(ProfileFieldSearchContext.AD_FILTER, bl, hashMap);
        adSearchData.setProfileFields(list4);
        if (list4.contains(BasicProfileField.ADDRESS)) {
            adSearchData.setAddressFields(this.profileFieldHandler.getAddressQueryFields());
        }
        GroupListView groupListView = this.groupsHandler.visibles().ads().basicUsers();
        adSearchData.setGroups(groupListView.sorted());
        adSearchData.setDefaultGroupFilter(groupListView.defaultFilter());
        adSearchData.setSearchByDistanceData(this.addressService.getSearchByDistanceData());
        if (sessionData.isGuest()) {
            adSearchData.setAllowViewUserAd(configurationAccessor.isAllowViewUserAd());
            adSearchData.setAllowViewUserWebShop(configurationAccessor.isAllowViewUserWebShop());
        } else {
            adSearchData.setAllowViewUserAd(sessionData.hasPermission(Permission.USER_ADS_VIEW));
            adSearchData.setAllowViewUserWebShop(sessionData.hasPermission(Permission.USER_WEB_SHOP_VIEW));
        }
    }

    private List<AdHistoryLog> getAdHistoryLog(Long l) {
        QAdHistoryLog qAdHistoryLog = QAdHistoryLog.adHistoryLog;
        List list = ((DBQuery)((DBQuery)this.from(new EntityPath[]{qAdHistoryLog}).where((Predicate)qAdHistoryLog.ad().id.eq((Object)l))).orderBy(qAdHistoryLog.startDate.asc())).list((Expression)qAdHistoryLog);
        return list;
    }

    private List<AdQuestionVO> getAdQuestions(BasicAd basicAd) {
        return this.adQuestionService.isQuestionsEnabled(basicAd.getType(), basicAd.getOwner()) ? this.adQuestionService.list(new BasicAdVO(basicAd.getId())) : Collections.emptyList();
    }

    private AdHistoryLog getLastAdHistoryLogEntry(BasicAd basicAd) {
        if (basicAd.isTransient()) {
            return null;
        }
        List<AdHistoryLog> list = this.getAdHistoryLog(basicAd.getId());
        return list.isEmpty() ? null : list.get(list.size() - 1);
    }

    private int getUserAdsCount(User user) {
        return ((DBQuery)this.from(this.$).where(new Predicate[]{((QBasicAd)this.$).owner().id.eq((Object)user.getId()), ((QBasicAd)this.$).deletedDate.isNull().and((Predicate)((QBasicAd)this.$).removedFromOwner.eq(Boolean.valueOf(false)))})).count(((QBasicAd)this.$).id);
    }

    private boolean hasPendingViewPermission() {
        return this.hasPermission(Permission.USER_PENDING_ADS_VIEW, Permission.USER_PENDING_WEB_SHOP_VIEW);
    }

    private Validator resolveCommonValidator(BasicAdDTO basicAdDTO) {
        DatePeriodDTO datePeriodDTO;
        Object object;
        boolean bl;
        BasicAd basicAd;
        Class clazz;
        User user;
        SessionData sessionData = this.getSessionData();
        if (basicAdDTO.isTransient()) {
            user = (User)this.conversionHandler.convert(User.class, (Object)basicAdDTO.getOwner());
            if (user == null && sessionData.isMember()) {
                user = sessionData.getLoggedUser();
            }
            clazz = (Class)this.subClassMappings().getKey(basicAdDTO.getClass());
            basicAd = (BasicAd)this.beanHandler.instantiate(clazz);
            basicAd.setOwner(user);
        } else {
            basicAd = this.find(BasicAd.class, basicAdDTO.getId());
            user = basicAd.getOwner();
            basicAdDTO.setOwner(new UserVO(user.getId()));
        }
        clazz = new Validator();
        if (user == null) {
            clazz.property((org.cyclos.model.Property)BasicAdDTO.OWNER, MarketplaceKeys.Advertisements.OWNER).required();
            return clazz;
        }
        this.addStatusValidations(basicAdDTO, (Validator)clazz, user);
        int n = this.productsHandler.getAccessor((BasicUser)user).member().getMaxCategoriesPerAd();
        clazz.property((org.cyclos.model.Property)BasicAdDTO.CATEGORIES, n == 1 ? MarketplaceKeys.Advertisements.CATEGORY : MarketplaceKeys.Advertisements.CATEGORIES).required().maxElements(n);
        clazz.property((org.cyclos.model.Property)BasicAdDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION).required().add((PropertyValidation)new DescriptionSizeValidator()).maxWordSize(100);
        if (CollectionHelper.isNotEmpty((Iterable)basicAdDTO.getAddresses()) && (bl = ((DBQuery)this.from(new EntityPath[]{object = QUserAddress.userAddress}).where(new Predicate[]{((QUserAddress)object).id.in((Collection)basicAdDTO.getAddresses().stream().map(EntityModel::getId).collect(Collectors.toList())), ((QUserAddress)object).hidden.isTrue()})).hasResults())) {
            clazz.property((org.cyclos.model.Property)BasicAdDTO.ADDRESSES, MarketplaceKeys.Advertisements.SHOW_ADDRESS_ON_MAP).invalid(MarketplaceKeys.Advertisements.ERROR_INVALID_ADDRESSES);
        }
        this.addPublicationPeriodValidations(basicAdDTO, (Validator)clazz, user);
        if (basicAdDTO.getPromotionalPrice() != null) {
            DateTime dateTime;
            object = basicAdDTO.getPromotionalPeriod();
            Property property = clazz.property((org.cyclos.model.Property)BasicAdDTO.PROMOTIONAL_PERIOD, MarketplaceKeys.Advertisements.PROMOTIONAL_PERIOD).required().period();
            datePeriodDTO = basicAdDTO.getPublicationPeriod();
            DateTime dateTime2 = object == null ? null : object.getBegin();
            DateTime dateTime3 = object == null ? null : object.getEnd();
            DateTime dateTime4 = datePeriodDTO == null ? null : datePeriodDTO.getBegin();
            DateTime dateTime5 = dateTime = datePeriodDTO == null || datePeriodDTO.getEnd() == null ? null : datePeriodDTO.getEnd().clone().add(1L);
            if (dateTime2 != null && dateTime3 != null && dateTime4 != null && dateTime != null) {
                property.nested((org.cyclos.model.Property)DatePeriodDTO.BEGIN, GeneralKeys.Ui.PERIOD_BEGIN).between((Comparable)dateTime4, (Comparable)dateTime);
                property.nested((org.cyclos.model.Property)DatePeriodDTO.END, GeneralKeys.Ui.PERIOD_END).between((Comparable)dateTime4, (Comparable)dateTime);
            }
        }
        object = this.adCustomFieldService.listManagedFieldEnabledToOwner(user);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            datePeriodDTO = (AdCustomField)iterator.next();
            this.customFieldValueService.addValueValidation((Validator)clazz, (CustomField)datePeriodDTO, (EntityPathBase)QAdCustomFieldValue.adCustomFieldValue, Collections.singletonMap("ad", basicAd));
        }
        clazz.general(new MaxImagesValidator());
        return clazz;
    }

    private boolean shouldNotifyInterested(BasicAd basicAd) {
        QNotifiedAdInterest qNotifiedAdInterest = QNotifiedAdInterest.notifiedAdInterest;
        boolean bl = ((DBQuery)this.from(new EntityPath[]{qNotifiedAdInterest}).where((Predicate)qNotifiedAdInterest.ad().id.eq((Object)basicAd.getId()))).hasResults();
        return !bl && basicAd.getStatus() == AdStatus.ACTIVE && !basicAd.isRemovedFromOwner() && basicAd.getPublicationPeriod().includes(DateHelper.now()) && basicAd.isInStock();
    }

    private void updateAdHistoryLog(BasicAd basicAd, BasicAd basicAd2) {
        Date date = basicAd.isTransient() ? basicAd.getCreationDate() : DateHelper.now();
        AdHistoryLog adHistoryLog = this.getLastAdHistoryLogEntry(basicAd);
        if (adHistoryLog != null) {
            if (!this.adHistoryLogUpdateNeeded(basicAd, basicAd2)) {
                return;
            }
            adHistoryLog.setEndDate(date);
        }
        AdHistoryLog adHistoryLog2 = new AdHistoryLog();
        adHistoryLog2.setAd(basicAd);
        adHistoryLog2.setStartDate(date);
        adHistoryLog2.setHidden(basicAd.isHidden());
        adHistoryLog2.setRemovedFromOwner(basicAd.isRemovedFromOwner());
        adHistoryLog2.setPublicationPeriod(basicAd.getPublicationPeriod());
        this.persist((IEntity)adHistoryLog2);
    }

    private void validatePrice(Validator validator, BasicAdDTO basicAdDTO) {
        User user = (User)this.conversionHandler.convert(User.class, (Object)basicAdDTO.getOwner());
        List list = this.currencyService.listForAds(user, false);
        Property property = validator.property((org.cyclos.model.Property)NestedProperty.nested((org.cyclos.model.Property)BasicAdDTO.PRICE, (org.cyclos.model.Property)CurrencyAmountDTO.AMOUNT), MarketplaceKeys.Advertisements.PRICE);
        if (CollectionHelper.isEmpty((Iterable)list)) {
            property.invalid(new ValidationError(MarketplaceKeys.Advertisements.ERROR_NO_AVAILABLE_ACCOUNTS));
        } else {
            CurrencyAmountDTO currencyAmountDTO;
            property.required().positiveOrZero();
            Property property2 = validator.property((org.cyclos.model.Property)NestedProperty.nested((org.cyclos.model.Property)BasicAdDTO.PRICE, (org.cyclos.model.Property)CurrencyAmountDTO.CURRENCY), BankingKeys.Accounts.CURRENCY);
            property2.anyOf((Collection)list);
            if (list.size() > 1) {
                property2.required();
            }
            if ((currencyAmountDTO = basicAdDTO.getPrice()) != null) {
                CurrencyAmount currencyAmount = (CurrencyAmount)this.conversionHandler.convert(CurrencyAmount.class, (Object)currencyAmountDTO);
                if (currencyAmount != null && currencyAmount.getCurrency() != null) {
                    property.lessThan((Comparable)TransactionService.MAX_TRANSACTION_AMOUNT_EXCLUSIVE);
                }
                if (basicAdDTO.getPromotionalPrice() != null) {
                    Property property3 = validator.property((org.cyclos.model.Property)BasicAdDTO.PROMOTIONAL_PRICE, MarketplaceKeys.Advertisements.PROMOTIONAL_PRICE);
                    property3.required().positiveNonZero((HasCurrency)currencyAmount).lessEquals((Comparable)basicAdDTO.getPrice().getAmount());
                }
            }
        }
    }

    static {
        SUBCLASS_MAPPINGS.put(Advertisement.class, AdvertisementDTO.class);
        SUBCLASS_MAPPINGS.put(AdWebShop.class, AdWebShopDTO.class);
        VO_MAPPINGS.put(Advertisement.class, AdvertisementVO.class);
        VO_MAPPINGS.put(AdWebShop.class, AdWebShopVO.class);
    }

    private final class DescriptionSizeValidator
    implements PropertyValidation {
        private DescriptionSizeValidator() {
        }

        public ValidationError validate(Object object, Object object2, Object object3) {
            BasicAdDTO basicAdDTO = (BasicAdDTO)object;
            String string = (String)object3;
            if (string != null) {
                String string2 = StringHelper.removeMarkupTags((String)string);
                int n = string2.length();
                User user = (User)AdServiceImpl.this.conversionHandler.convert(User.class, (Object)basicAdDTO.getOwner());
                int n2 = AdServiceImpl.this.productsHandler.getAccessor((BasicUser)user).member().getMaxAdDescriptionSize();
                if (n2 == 0) {
                    n2 = 1000;
                }
                if (n > n2) {
                    return new ValidationError(MarketplaceKeys.Advertisements.ERROR_INVALID_DESCRIPTION_SIZE, new Object[]{n2});
                }
            }
            return null;
        }
    }

    private final class MaxImagesValidator
    implements GeneralValidation {
        private MaxImagesValidator() {
        }

        public ValidationError validate(Object object) {
            BasicAdDTO basicAdDTO = (BasicAdDTO)object;
            if (CollectionHelper.isNotEmpty((Iterable)basicAdDTO.getUploadedImages())) {
                User user = (User)AdServiceImpl.this.conversionHandler.convert(User.class, (Object)basicAdDTO.getOwner());
                int n = AdServiceImpl.this.productsHandler.getAccessor((BasicUser)user).member().getMaxAdImages();
                if (basicAdDTO.getUploadedImages().size() > n) {
                    return new ValidationError(GeneralKeys.Errors.MAX_NUMBER_OF_IMAGES, new Object[]{n});
                }
            }
            return null;
        }
    }
}

