/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.marketplace;

import org.apache.commons.lang3.ArrayUtils;
import org.cyclos.entities.marketplace.BasicAd;
import org.cyclos.entities.users.User;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.marketplace.AdCustomFieldServiceLocal;
import org.cyclos.impl.system.CustomFieldValueHandler;
import org.cyclos.impl.utils.conversion.ObjectConverter;
import org.cyclos.model.marketplace.advertisements.BasicAdDTO;
import org.cyclos.security.marketplace.AdServiceSecurity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BasicAdDTOConverter
extends ObjectConverter<BasicAdDTO> {
    @Autowired
    private AdServiceSecurity adServiceSecurity;
    @Autowired
    private CustomFieldValueHandler customFieldValueHandler;
    @Autowired
    private AdCustomFieldServiceLocal adCustomFieldService;

    public BasicAdDTOConverter() {
        super(BasicAdDTO.class);
    }

    @Override
    protected void fill(Object object, BasicAdDTO basicAdDTO, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        SessionData sessionData = this.getSessionData();
        if (sessionData.isGuest()) {
            if (sessionData.getConfiguration().isHideAdOwnerToGuests()) {
                objectArray = ArrayUtils.add((Object[])objectArray, (Object)BasicAdDTO.OWNER);
            }
            if (sessionData.getConfiguration().isHideAdPriceToGuests()) {
                objectArray = ArrayUtils.add((Object[])objectArray, (Object)BasicAdDTO.PRICE);
                objectArray = ArrayUtils.add((Object[])objectArray, (Object)BasicAdDTO.PROMOTIONAL_PRICE);
            }
        }
        super.fill(object, basicAdDTO, objectArray, conversionContext);
        if (object instanceof BasicAd) {
            BasicAd basicAd = (BasicAd)object;
            if (!this.adServiceSecurity.canViewAuthorizationNotes(basicAd)) {
                basicAdDTO.setAuthorizationNotes(null);
            }
            User user = basicAd.getOwner();
            this.customFieldValueHandler.sortAndRemoveMissing(basicAdDTO.getCustomValues(), this.adCustomFieldService.listVisibleFieldEnabledToOwner(user));
            if (!this.adServiceSecurity.canViewAddresses(user)) {
                basicAdDTO.setAddresses(null);
            }
        }
    }
}

