/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.marketplace;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.CaseBuilder;
import com.querydsl.core.types.dsl.NumberExpression;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.Payment;
import org.cyclos.entities.banking.PaymentTransferType;
import org.cyclos.entities.banking.QOrderAmountReservation;
import org.cyclos.entities.banking.TransactionAuthorization;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.marketplace.AdDeliveryMethod;
import org.cyclos.entities.marketplace.AdImage;
import org.cyclos.entities.marketplace.AdWebShop;
import org.cyclos.entities.marketplace.AdWebShopSetting;
import org.cyclos.entities.marketplace.Order;
import org.cyclos.entities.marketplace.OrderAddress;
import org.cyclos.entities.marketplace.OrderLog;
import org.cyclos.entities.marketplace.OrderProduct;
import org.cyclos.entities.marketplace.QOrder;
import org.cyclos.entities.marketplace.QOrderLog;
import org.cyclos.entities.marketplace.QOrderProduct;
import org.cyclos.entities.system.ExportFormat;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.Group;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.entities.utils.NumberGeneration;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.PasswordHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.banking.AccountServiceLocal;
import org.cyclos.impl.banking.CurrencyServiceLocal;
import org.cyclos.impl.banking.LocateAccountOwnerResult;
import org.cyclos.impl.banking.PaymentServiceLocal;
import org.cyclos.impl.banking.TransactionAuthorizationServiceLocal;
import org.cyclos.impl.banking.TransactionServiceLocal;
import org.cyclos.impl.locks.LockHandler;
import org.cyclos.impl.locks.LockType;
import org.cyclos.impl.marketplace.AdDeliveryMethodServiceLocal;
import org.cyclos.impl.marketplace.AdWebShopSettingServiceLocal;
import org.cyclos.impl.marketplace.OrderServiceLocal;
import org.cyclos.impl.system.ConfigurationServiceLocal;
import org.cyclos.impl.system.ExportFormatServiceLocal;
import org.cyclos.impl.system.ExtensionPointAccessor;
import org.cyclos.impl.system.ExtensionPointFilter;
import org.cyclos.impl.system.ExtensionPointServiceLocal;
import org.cyclos.impl.users.UserAddressServiceLocal;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.notifications.MarketplaceBuyerNotificationsHandler;
import org.cyclos.impl.utils.notifications.MarketplaceSellerNotificationsHandler;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.BeanPropertyAccess;
import org.cyclos.impl.utils.validation.EntityValidation;
import org.cyclos.impl.utils.validation.PropertyAccess;
import org.cyclos.impl.utils.validation.PropertyValidation;
import org.cyclos.impl.utils.validation.ValidationError;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.impl.utils.validation.validations.BaseEntityValidation;
import org.cyclos.impl.utils.validation.validations.GeneralValidations;
import org.cyclos.model.DataAccessException;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityModel;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.IllegalActionException;
import org.cyclos.model.Property;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.CredentialUsage;
import org.cyclos.model.access.PasswordException;
import org.cyclos.model.access.passwords.ICredentialInputDTO;
import org.cyclos.model.banking.TransferException;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.authorizations.AuthorizationAction;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.marketplace.CannotBuyException;
import org.cyclos.model.marketplace.MarketplaceKeys;
import org.cyclos.model.marketplace.OutOfStockException;
import org.cyclos.model.marketplace.advertisements.AdStatus;
import org.cyclos.model.marketplace.advertisements.AdWebShopStockType;
import org.cyclos.model.marketplace.advertisements.AdWebShopVO;
import org.cyclos.model.marketplace.advertisements.BasicAdVO;
import org.cyclos.model.marketplace.webshopdeliverymethods.AdDeliveryMethodChargeType;
import org.cyclos.model.marketplace.webshopdeliverymethods.AdDeliveryMethodType;
import org.cyclos.model.marketplace.webshopdeliverymethods.AdDeliveryMethodVO;
import org.cyclos.model.marketplace.webshoporders.AcceptOrderConfirmationField;
import org.cyclos.model.marketplace.webshoporders.AcceptOrderParams;
import org.cyclos.model.marketplace.webshoporders.OrderActionParams;
import org.cyclos.model.marketplace.webshoporders.OrderAddressDTO;
import org.cyclos.model.marketplace.webshoporders.OrderCreationType;
import org.cyclos.model.marketplace.webshoporders.OrderDTO;
import org.cyclos.model.marketplace.webshoporders.OrderData;
import org.cyclos.model.marketplace.webshoporders.OrderDataParams;
import org.cyclos.model.marketplace.webshoporders.OrderLogVO;
import org.cyclos.model.marketplace.webshoporders.OrderProductDTO;
import org.cyclos.model.marketplace.webshoporders.OrderQuery;
import org.cyclos.model.marketplace.webshoporders.OrderSearchData;
import org.cyclos.model.marketplace.webshoporders.OrderStatus;
import org.cyclos.model.marketplace.webshoporders.OrderVO;
import org.cyclos.model.marketplace.webshoporders.QuantityAdjustment;
import org.cyclos.model.marketplace.webshoporders.RejectOrderParams;
import org.cyclos.model.marketplace.webshoporders.SetDeliveryMethodParams;
import org.cyclos.model.marketplace.webshoporders.ShoppingCartCheckoutConfirmationField;
import org.cyclos.model.marketplace.webshoporders.ShoppingCartCheckoutParams;
import org.cyclos.model.marketplace.webshoporders.ShoppingCartCheckoutResult;
import org.cyclos.model.marketplace.webshoporders.ShoppingCartDTO;
import org.cyclos.model.system.exportformats.ExportFormatContext;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.system.extensionpoints.ExtensionPointEvent;
import org.cyclos.model.system.extensionpoints.OrderExtensionPointEvent;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.users.addresses.AddressDTO;
import org.cyclos.model.users.addresses.GeoLocatedAddressVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.TimeField;
import org.cyclos.security.marketplace.OrderServiceSecurity;
import org.cyclos.server.utils.CloseableIteratorHelper;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.services.banking.TransactionService;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderServiceImpl
extends CRUDServiceImpl<Order, QOrder, OrderDTO, OrderData, OrderDataParams>
implements OrderServiceLocal {
    private static final Object[] EXCLUDED_PROPERTIES = new Object[]{OrderDTO.DELIVERY_ADDRESS};
    @Autowired
    private AccountServiceLocal accountService;
    @Autowired
    private CurrencyServiceLocal currencyService;
    @Autowired
    private PaymentServiceLocal paymentService;
    @Autowired
    private UserAddressServiceLocal addressService;
    @Autowired
    private AdWebShopSettingServiceLocal adWebShopSettingService;
    @Autowired
    private PasswordHandler passwordHandler;
    @Autowired
    private LockHandler lockHandler;
    @Autowired
    private ConfigurationServiceLocal configurationService;
    @Autowired
    private AdDeliveryMethodServiceLocal adDeliveryMethodService;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private TransactionServiceLocal transactionService;
    @Autowired
    private ExportFormatServiceLocal exportFormatService;
    @Autowired
    private TransactionAuthorizationServiceLocal transactionAuthorizationService;
    @Autowired
    private ExtensionPointServiceLocal extensionPointService;
    @Autowired
    private OrderServiceSecurity orderServiceSecurity;

    public OrderServiceImpl() {
        super(Order.class, QOrder.order, OrderDTO.class);
    }

    public OrderStatus accept(AcceptOrderParams acceptOrderParams) throws FrameworkException, TransferException, PasswordException {
        OrderStatus orderStatus;
        boolean bl;
        this.validate(acceptOrderParams);
        Order order = this.getOrder((OrderActionParams)acceptOrderParams);
        boolean bl2 = order.getStatus() == OrderStatus.PENDING_BUYER;
        boolean bl3 = bl = order.getStatus() == OrderStatus.PENDING_SELLER;
        if (!bl2 && !bl || !order.isPendingByAdmin() && order.getDeliveryPrice() == null) {
            throw new IllegalActionException();
        }
        order.setRemarks(acceptOrderParams.getRemarks());
        if (order.isPendingByAdmin()) {
            this.approveByManager(order);
            orderStatus = order.getStatus();
        } else {
            PaymentTransferType paymentTransferType;
            if (order.getPaymentType() == null) {
                paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)acceptOrderParams.getPaymentType());
                this.validatePaymentType(order, paymentTransferType);
                order.setPaymentType(paymentTransferType);
            }
            if (this.accountService.getAmountReservation(order) == null) {
                this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(acceptOrderParams.getConfirmationPassword(), AcceptOrderConfirmationField.confirmation((OrderVO)new OrderVO(order.getId())));
            } else {
                this.returnReservedAmount(order);
            }
            paymentTransferType = this.paymentService.confirmOrder(order);
            orderStatus = paymentTransferType.isPendingAuthorization() ? OrderStatus.PAYMENT_PENDING : OrderStatus.COMPLETED;
            this.setStatusAndNotifyExtensionPoints(order, orderStatus, false);
            this.notifyAcceptedOrder(order, bl2, paymentTransferType.isPendingAuthorization());
        }
        return orderStatus;
    }

    public int addToCart(BasicAdVO basicAdVO, BigDecimal bigDecimal) throws FrameworkException, OutOfStockException, CannotBuyException {
        BigDecimal bigDecimal2;
        boolean bl;
        User user = this.getLoggedUser();
        AdWebShop adWebShop = (AdWebShop)this.conversionHandler.convert(AdWebShop.class, (Object)basicAdVO);
        User user2 = adWebShop.getOwner();
        boolean bl2 = bl = adWebShop.getStockType() == AdWebShopStockType.QUANTITY;
        if (adWebShop.getOwner().equals((Object)this.getLoggedUser())) {
            throw new IllegalActionException();
        }
        if (!this.groupsHandler.getAccessibleUserGroups(adWebShop.getOwner()).contains(this.getSessionData().getGroup())) {
            this.throwCannotBuyException(user2);
        } else {
            boolean bl3;
            bigDecimal2 = adWebShop.getMinAllowedInCart() == null ? BigDecimal.ZERO : adWebShop.getMinAllowedInCart();
            boolean bl4 = bl3 = bl && (BigDecimalHelper.isZero((BigDecimal)adWebShop.getStockQuantity()) || BigDecimalHelper.compareTo((BigDecimal)bigDecimal2, (BigDecimal)adWebShop.getStockQuantity()) > 0);
            if (bl3 || adWebShop.getStockType() == AdWebShopStockType.NOT_AVAILABLE) {
                this.throwOutOfStockException(adWebShop);
            }
        }
        bigDecimal2 = this.getForShoppingCart(user, user2, adWebShop.getPrice().getCurrency(), true);
        OrderProduct orderProduct = this.getOrderProduct((Order)bigDecimal2, adWebShop);
        if (bigDecimal == null) {
            BigDecimal bigDecimal3 = adWebShop.getMinAllowedInCart();
            bigDecimal = bigDecimal3 == null || orderProduct != null ? new BigDecimal(1) : bigDecimal3;
        }
        bigDecimal = this.roundQuantity(adWebShop, bigDecimal);
        if (orderProduct == null) {
            orderProduct = new OrderProduct();
            orderProduct.setProduct(adWebShop);
            orderProduct.setQuantity(bigDecimal);
            orderProduct.setPrice(adWebShop.getCurrentPrice());
            bigDecimal2.addProduct(orderProduct);
            this.persist((IEntity)orderProduct);
        } else {
            bigDecimal = orderProduct.getQuantity().add(bigDecimal);
            orderProduct.setQuantity(bigDecimal);
            if (bl && BigDecimalHelper.compareTo((BigDecimal)bigDecimal, (BigDecimal)adWebShop.getStockQuantity()) > 0) {
                this.throwOutOfStockException(adWebShop);
            }
        }
        this.adjustQuantity(orderProduct);
        this.updateStock((Order)bigDecimal2, true, true);
        this.updateTotal((Order)bigDecimal2);
        return this.countCartItems(user);
    }

    public ShoppingCartDTO adjustAndGetMyCart() throws FrameworkException {
        return this.maybeAdjustAndGetMyCart(true);
    }

    public OrderData adjustShoppingCartAndGetData(OrderVO orderVO) throws FrameworkException {
        Order order = (Order)this.conversionHandler.convert(Order.class, (Object)orderVO);
        if (order.getStatus() != OrderStatus.SHOPPING_CART) {
            throw new IllegalActionException();
        }
        order.getProducts().forEach(this::adjustQuantity);
        return this.getData(order);
    }

    public int cancelOrdersNotInCurrencies(User user, Collection<Currency> collection) {
        CloseableIterator closeableIterator = ((DBQuery)this.from().where(new Predicate[]{((QOrder)this.$).buyer().eq((Object)user).or((Predicate)((QOrder)this.$).seller().eq((Object)user)), CollectionHelper.isEmpty(collection) ? ((QOrder)this.$).currency().isNotNull() : ((QOrder)this.$).currency().notIn(collection), ((QOrder)this.$).status.in(this.getCancelableStatuses())})).iterate((Expression)this.$);
        return (int)this.processBatch(closeableIterator, this::cancel);
    }

    public int cancelWithReservedAmount(UserAccount userAccount) {
        CloseableIterator<Order> closeableIterator = this.resolveOrdersToCancel(userAccount);
        return (int)this.processBatch(closeableIterator, this::cancel);
    }

    public void checkCartStock(UserLocatorVO userLocatorVO, CurrencyVO currencyVO) throws FrameworkException, OutOfStockException {
        User user = this.userLocatorHandler.locate(userLocatorVO).getUser();
        Currency currency = (Currency)this.conversionHandler.convert(Currency.class, (Object)currencyVO);
        Order order = this.getForShoppingCart(this.getLoggedUser(), user, currency, false);
        if (order == null) {
            throw new IllegalActionException();
        }
        this.updateStock(order, true, true);
    }

    public ShoppingCartCheckoutResult checkout(ShoppingCartCheckoutParams shoppingCartCheckoutParams) {
        OrderAddress orderAddress;
        this.validate(shoppingCartCheckoutParams);
        Order order = this.getOrder((OrderActionParams)shoppingCartCheckoutParams);
        if (order.getStatus() != OrderStatus.SHOPPING_CART) {
            throw new IllegalActionException();
        }
        SessionData sessionData = this.getSessionData();
        if (!this.groupsHandler.getAccessibleUserGroups(order.getSeller()).contains(sessionData.getGroup())) {
            this.throwCannotBuyException(order.getSeller());
        }
        PaymentTransferType paymentTransferType = (PaymentTransferType)this.conversionHandler.convert(PaymentTransferType.class, (Object)shoppingCartCheckoutParams.getPaymentType());
        this.validatePaymentType(order, paymentTransferType);
        boolean bl = false;
        AdDeliveryMethod adDeliveryMethod = null;
        BigDecimal bigDecimal = null;
        if (shoppingCartCheckoutParams.getDeliveryMethod() != null) {
            adDeliveryMethod = (AdDeliveryMethod)this.conversionHandler.convert(AdDeliveryMethod.class, (Object)shoppingCartCheckoutParams.getDeliveryMethod());
            bigDecimal = adDeliveryMethod.getPrice() == null ? null : adDeliveryMethod.getPrice().getAmount();
            bl = adDeliveryMethod.getChargeType() == AdDeliveryMethodChargeType.FIXED && BigDecimalHelper.isPositiveOrZero((BigDecimal)bigDecimal);
        }
        BigDecimal bigDecimal2 = this.calculateTotal(order, bigDecimal);
        if (bl) {
            this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).check(shoppingCartCheckoutParams.getConfirmationPassword(), ShoppingCartCheckoutConfirmationField.confirmation((UserVO)new UserLocatorVO(order.getSeller().getId()), (BigDecimal)bigDecimal2, (TransferTypeVO)shoppingCartCheckoutParams.getPaymentType()));
        }
        if ((orderAddress = (OrderAddress)this.conversionHandler.convertExcluding(OrderAddress.class, (Object)shoppingCartCheckoutParams.getDeliveryAddress(), new Object[]{EntityModel.ID})) != null) {
            orderAddress.setOrder(order);
            this.persist((IEntity)orderAddress);
        }
        Date date = DateHelper.now();
        order.setDeliveryAddress(orderAddress);
        order.setPaymentType(paymentTransferType);
        order.setCreationDate(date);
        order.setCreatedBy(sessionData.getLoggedUser());
        order.setUpdatedDate(date);
        order.setFinishDate(date);
        order.setRemarks(shoppingCartCheckoutParams.getRemarks());
        if (adDeliveryMethod != null) {
            order.setDeliveryMethodName(adDeliveryMethod.getName());
            order.setMinDeliveryTime(adDeliveryMethod.getMinDeliveryTime());
            order.setMaxDeliveryTime(adDeliveryMethod.getMaxDeliveryTime());
            order.setDeliveryType(adDeliveryMethod.getDeliveryType());
            order.setDeliveryPrice(bigDecimal);
        }
        order.setTotal(bigDecimal2);
        this.updateStock(order, true, false);
        this.assignNumber(order);
        if (bl) {
            this.accountService.reserveAmount(order);
        }
        this.setStatusAndNotifyExtensionPoints(order, OrderStatus.PENDING_SELLER, false);
        this.checkoutNotifications(order);
        ShoppingCartCheckoutResult shoppingCartCheckoutResult = new ShoppingCartCheckoutResult();
        shoppingCartCheckoutResult.setOrder((OrderVO)this.conversionHandler.convert(OrderVO.class, (Object)order));
        shoppingCartCheckoutResult.setTotalAdsCount(this.countCartItems(sessionData.getLoggedUser()));
        return shoppingCartCheckoutResult;
    }

    public int countCartItems() throws FrameworkException {
        return this.countCartItems(this.getLoggedUser());
    }

    public Integer countPending(User user, boolean bl, OrderStatus orderStatus, Date date) {
        QOrderLog qOrderLog = QOrderLog.orderLog;
        QOrderLog qOrderLog2 = new QOrderLog("l2");
        return ((DBQuery)((DBQuery)this.from(this.$).innerJoin((CollectionExpression)((QOrder)this.$).logs, (Path)qOrderLog)).where(new Predicate[]{(bl ? ((QOrder)this.$).seller() : ((QOrder)this.$).buyer()).eq((Object)user), qOrderLog.status.eq((Object)orderStatus), qOrderLog.id.eq((Expression)this.subQuery(new EntityPath[]{qOrderLog2}).select((Expression)qOrderLog2.id.max()).where((Predicate)qOrderLog2.order().eq((Expression)this.$)))})).count(((QOrder)this.$).id);
    }

    public FileInfo exportOrder(ExportFormatVO exportFormatVO, OrderVO orderVO) throws FrameworkException {
        ExportFormat exportFormat = (ExportFormat)this.conversionHandler.convert(ExportFormat.class, (Object)exportFormatVO);
        Order order = (Order)this.conversionHandler.convert(Order.class, (Object)orderVO);
        return this.exportFormatService.exportSingle(exportFormat, ExportFormatContext.ORDER_DETAILS, (Object)order);
    }

    public Order findByOrderNumber(String string) {
        QOrder qOrder = QOrder.order;
        Order order = (Order)InvocationContext.ensure().getAttribute((Object)("order:" + string), () -> (Order)((DBQuery)this.from(new EntityPath[]{qOrder}).where((Predicate)qOrder.number.equalsIgnoreCase(string))).singleResult((Expression)qOrder));
        try {
            if (order == null) {
                throw new EntityNotFoundException();
            }
            this.entityManagerHandler.checkAccess((IEntity)order);
        }
        catch (EntityNotFoundException entityNotFoundException) {
            throw new EntityNotFoundException(Order.class, string);
        }
        return order;
    }

    public OrderData getCheckoutData(UserLocatorVO userLocatorVO, CurrencyVO currencyVO) {
        Currency currency;
        User user = this.getLoggedUser();
        if (user == null) {
            return null;
        }
        User user2 = this.userLocatorHandler.locate(userLocatorVO).getUser();
        Order order = this.getForShoppingCart(user, user2, currency = (Currency)this.conversionHandler.convert(Currency.class, (Object)currencyVO), false);
        if (order == null) {
            throw new EntityNotFoundException();
        }
        return this.getData(order);
    }

    public ShoppingCartDTO getMyCart() {
        return this.maybeAdjustAndGetMyCart(false);
    }

    public OrderData getOrderData(OrderVO orderVO) throws FrameworkException {
        Order order = null;
        if (orderVO.getId() != null) {
            order = (Order)this.find(orderVO.getId());
        } else if (orderVO.getNumber() != null) {
            order = this.findByOrderNumber(orderVO.getNumber());
        }
        if (order == null) {
            throw new EntityNotFoundException(Order.class);
        }
        return this.getData(order);
    }

    public long getOrderId(OrderVO orderVO) throws FrameworkException {
        if (orderVO.getId() != null) {
            return orderVO.getId();
        }
        return ((Order)this.conversionHandler.convert(Order.class, (Object)orderVO)).getId();
    }

    public OrderSearchData getSearchData(@NotNull UserLocatorVO userLocatorVO, boolean bl) throws FrameworkException {
        User user = this.userLocatorHandler.locate(userLocatorVO).getUser();
        OrderSearchData orderSearchData = new OrderSearchData();
        orderSearchData.setUser((UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
        OrderQuery orderQuery = (OrderQuery)QueryHelper.newQuery(OrderQuery.class);
        orderSearchData.setQuery((QueryParameters)orderQuery);
        orderQuery.setSales(bl);
        if (bl) {
            orderSearchData.setProductNumberMask(this.adWebShopSettingService.getAdWebShopSetting(user).getProductNumberMask());
            orderSearchData.setCurrencies(this.conversionHandler.convertList(CurrencyVO.class, (Iterable)this.currencyService.listForAds(user, false)));
            orderSearchData.setCanCreateNew(this.getLoggedUser().equals((Object)user));
            orderQuery.setSeller(orderSearchData.getUser());
        } else {
            orderQuery.setBuyer(orderSearchData.getUser());
        }
        return orderSearchData;
    }

    public boolean hasPurchases(User user) {
        return this.hasOrders(user, true);
    }

    public boolean hasSales(User user) {
        return this.hasOrders(user, false);
    }

    @PostConstruct
    public void initialize() {
        EnumSet.allOf(AuthorizationAction.class).forEach(this::registerTransactionAuthorizationHandler);
    }

    public int modifyQuantityOnCart(BasicAdVO basicAdVO, BigDecimal bigDecimal) throws FrameworkException, IllegalActionException, OutOfStockException {
        User user = this.getLoggedUser();
        AdWebShop adWebShop = (AdWebShop)this.conversionHandler.convert(AdWebShop.class, (Object)basicAdVO);
        Currency currency = adWebShop.getPrice().getCurrency();
        User user2 = adWebShop.getOwner();
        Order order = this.getForShoppingCart(user, user2, currency, false);
        if (order == null) {
            throw new IllegalActionException();
        }
        OrderProduct orderProduct = this.getOrderProduct(order, adWebShop);
        if (orderProduct == null) {
            throw new IllegalActionException();
        }
        if (BigDecimalHelper.isZero((BigDecimal)(bigDecimal = this.roundQuantity(adWebShop, BigDecimalHelper.zeroWhenNull((BigDecimal)bigDecimal))))) {
            this.removeItem(orderProduct);
        } else {
            orderProduct.setQuantity(bigDecimal);
            this.adjustQuantity(orderProduct);
            this.updateStock(order, true, true);
            this.updateTotal(order);
        }
        return this.countCartItems(user);
    }

    @Override
    public Order newEntity(OrderDataParams orderDataParams) {
        User user = (User)this.conversionHandler.convert(User.class, (Object)orderDataParams.getBuyer());
        User user2 = (User)this.conversionHandler.convert(User.class, (Object)orderDataParams.getSeller());
        Currency currency = (Currency)this.conversionHandler.convert(Currency.class, (Object)orderDataParams.getCurrency());
        Order order = new Order();
        order.setStatus(OrderStatus.DRAFT);
        order.setBuyer(user);
        order.setSeller(user2);
        order.setCurrency(currency);
        order.setSale(true);
        List list = this.currencyService.listForAds(order.getBuyer(), false);
        List list2 = this.currencyService.listForAds(order.getSeller(), false);
        Collection collection = CollectionUtils.intersection((Iterable)list, (Iterable)list2);
        if (currency != null && !collection.contains(currency) || collection.isEmpty()) {
            throw new ValidationException(this.message(MarketplaceKeys.WebshopOrders.ERROR_NO_CURRENCY, new Object[0]));
        }
        if (currency == null && collection.size() == 1) {
            order.setCurrency((Currency)CollectionHelper.first((Iterable)collection));
        }
        return order;
    }

    public void reject(RejectOrderParams rejectOrderParams) throws FrameworkException {
        boolean bl;
        this.validate(rejectOrderParams);
        Order order = this.getOrder((OrderActionParams)rejectOrderParams);
        OrderStatus orderStatus = order.getStatus();
        boolean bl2 = orderStatus == OrderStatus.PENDING_BUYER;
        boolean bl3 = orderStatus == OrderStatus.PENDING_SELLER;
        boolean bl4 = bl = orderStatus == OrderStatus.PAYMENT_PENDING;
        if (!(bl2 || bl3 || bl)) {
            throw new IllegalActionException();
        }
        order.setRemarks(rejectOrderParams.getRemarks());
        if (order.isPendingByAdmin()) {
            this.cancel(order);
        } else {
            this.returnStock(order);
            this.returnReservedAmount(order);
            OrderStatus orderStatus2 = this.getNewRejectedStatus(order);
            this.setStatusAndNotifyExtensionPoints(order, orderStatus2, false);
            this.notifyRejectedOrder(order);
        }
    }

    public int removeCart(UserLocatorVO userLocatorVO, CurrencyVO currencyVO) {
        Currency currency;
        User user;
        User user2 = this.getLoggedUser();
        Order order = this.getForShoppingCart(user2, user = this.userLocatorHandler.locate(userLocatorVO).getUser(), currency = (Currency)this.conversionHandler.convert(Currency.class, (Object)currencyVO), false);
        if (order != null) {
            this.remove(order);
        }
        return this.countCartItems(user2);
    }

    public int removeCartById(Long l) throws EntityNotFoundException, DataAccessException, ValidationException {
        this.remove(l);
        return this.countCartItems(this.getLoggedUser());
    }

    public int removeCartItem(BasicAdVO basicAdVO) throws FrameworkException {
        User user = this.getLoggedUser();
        AdWebShop adWebShop = (AdWebShop)this.invokerHandler.runAs(SessionDataFactory.system(), () -> (AdWebShop)this.conversionHandler.convert(AdWebShop.class, (Object)basicAdVO));
        Currency currency = adWebShop.getPrice().getCurrency();
        User user2 = adWebShop.getOwner();
        Order order = this.getForShoppingCart(user, user2, currency, false);
        if (order == null) {
            throw new IllegalActionException();
        }
        OrderProduct orderProduct = this.getOrderProduct(order, adWebShop);
        if (orderProduct == null) {
            throw new IllegalActionException();
        }
        this.removeItem(orderProduct);
        this.updateTotal(order);
        return this.countCartItems(user);
    }

    public Page<OrderVO> search(OrderQuery orderQuery) {
        QOrderProduct qOrderProduct;
        User user = (User)this.conversionHandler.convert(User.class, (Object)orderQuery.getBuyer());
        User user2 = (User)this.conversionHandler.convert(User.class, (Object)orderQuery.getSeller());
        User user3 = this.getLoggedUser();
        boolean bl = false;
        boolean bl2 = orderQuery.isSales();
        if (bl2) {
            boolean bl3 = bl = user3 != null && user3.equals((Object)user2);
            if (!(user2 != null || user3 != null && user3.isUserManager())) {
                throw new ValidationException();
            }
        } else {
            boolean bl4 = bl = user3 != null && user3.equals((Object)user);
            if (!(user != null || user3 != null && user3.isUserManager())) {
                throw new ValidationException();
            }
        }
        DBQuery<?> dBQuery = this.from(this.$);
        if (orderQuery.getNumber() != null) {
            dBQuery.where((Predicate)((QOrder)this.$).number.eq((Object)orderQuery.getNumber()));
        }
        if (orderQuery.getProductNumber() != null) {
            qOrderProduct = QOrderProduct.orderProduct;
            ((DBQuery)dBQuery.innerJoin((EntityPath)qOrderProduct)).on((Predicate)((QOrder)this.$).products.contains((Expression)qOrderProduct));
            dBQuery.where((Predicate)qOrderProduct.product().productNumber.eq((Object)orderQuery.getProductNumber()));
        }
        if (user != null) {
            dBQuery.where((Predicate)((QOrder)this.$).buyer().eq((Object)user));
        }
        if (user2 != null) {
            dBQuery.where((Predicate)((QOrder)this.$).seller().eq((Object)user2));
        }
        if (orderQuery.getPeriod() != null) {
            dBQuery.where(((QOrder)this.$).creationDate.period((DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)orderQuery.getPeriod())));
        }
        if (orderQuery.getStatus() != null) {
            dBQuery.where((Predicate)((QOrder)this.$).status.eq((Object)orderQuery.getStatus()));
        }
        if (orderQuery.isIncludePendingByAdmin()) {
            if (orderQuery.getPendingByAdmin() != null) {
                dBQuery.where((Predicate)(orderQuery.getPendingByAdmin() != false ? ((QOrder)this.$).pendingByAdmin.isTrue() : ((QOrder)this.$).pendingByAdmin.isFalse().or((Predicate)((QOrder)this.$).pendingByAdmin.isNull())));
            }
        } else {
            dBQuery.where((Predicate)((QOrder)this.$).pendingByAdmin.isFalse().or((Predicate)((QOrder)this.$).pendingByAdmin.isNull()));
        }
        if (orderQuery.getCreationType() != null) {
            dBQuery.where((Predicate)(orderQuery.getCreationType() == OrderCreationType.SALE ? ((QOrder)this.$).sale.isTrue() : ((QOrder)this.$).sale.isFalse()));
        }
        dBQuery.where((Predicate)((QOrder)this.$).status.ne((Object)OrderStatus.SHOPPING_CART));
        if (!bl2 || !bl) {
            dBQuery.where((Predicate)((QOrder)this.$).status.ne((Object)OrderStatus.DRAFT));
        }
        if (orderQuery.isSales() || orderQuery.isIncludePendingByAdmin()) {
            dBQuery.orderBy(new OrderSpecifier[]{((QOrder)this.$).updatedDate.desc(), ((QOrder)this.$).id.desc()});
        } else {
            dBQuery.orderBy(new OrderSpecifier[]{((NumberExpression)new CaseBuilder().when((Predicate)((QOrder)this.$).status.eq((Object)OrderStatus.PENDING_BUYER)).then((Number)1).when((Predicate)((QOrder)this.$).status.eq((Object)OrderStatus.PENDING_SELLER)).then((Object)2).when((Predicate)((QOrder)this.$).status.eq((Object)OrderStatus.PAYMENT_PENDING)).then((Object)3).when((Predicate)((QOrder)this.$).status.eq((Object)OrderStatus.COMPLETED)).then((Object)4).when((Predicate)((QOrder)this.$).status.eq((Object)OrderStatus.REJECTED_BY_BUYER)).then((Object)5).when((Predicate)((QOrder)this.$).status.eq((Object)OrderStatus.REJECTED_BY_SELLER)).then((Object)6).when((Predicate)((QOrder)this.$).status.eq((Object)OrderStatus.PAYMENT_CANCELED)).then((Object)7).when((Predicate)((QOrder)this.$).status.eq((Object)OrderStatus.PAYMENT_DENIED)).then((Object)8).when((Predicate)((QOrder)this.$).status.eq((Object)OrderStatus.PAYMENT_EXPIRED)).then((Object)9).when((Predicate)((QOrder)this.$).status.eq((Object)OrderStatus.DISPOSED)).then((Object)10).otherwise((Object)11)).asc(), ((QOrder)this.$).updatedDate.desc()});
        }
        qOrderProduct = dBQuery.page(OrderVO.class, (QueryParameters)orderQuery, (Expression)this.$);
        qOrderProduct.getPageItems().forEach(orderVO -> orderVO.setImage(this.getOrderImage(orderVO.getId())));
        return qOrderProduct;
    }

    public void setDeliveryMethod(SetDeliveryMethodParams setDeliveryMethodParams) throws FrameworkException {
        Order order = this.getOrder((OrderActionParams)setDeliveryMethodParams);
        if (order.getStatus() != OrderStatus.PENDING_SELLER || order.getDeliveryPrice() != null) {
            throw new IllegalActionException();
        }
        this.validate(order, setDeliveryMethodParams);
        Currency currency = order.getCurrency();
        BigDecimal bigDecimal = BigDecimalHelper.round((BigDecimal)setDeliveryMethodParams.getDeliveryPrice(), (int)currency.getPrecision());
        setDeliveryMethodParams.setDeliveryPrice(bigDecimal);
        this.conversionHandler.fill((Object)setDeliveryMethodParams, (Object)order);
        this.updateTotal(order);
        this.setStatusAndNotifyExtensionPoints(order, OrderStatus.PENDING_BUYER, false);
        this.notificationHandler.user((BasicUser)order.getBuyer()).marketplaceBuyer().orderPendingBuyer(order, order.getNumber(), order.getSeller(), new CurrencyAmount(currency, bigDecimal));
    }

    public Long submitToBuyer(OrderDTO orderDTO) throws FrameworkException {
        Validator validator = this.createValidator(orderDTO, true);
        this.validate(validator, orderDTO, "submitToBuyer");
        Long l = this.save(orderDTO);
        Order order = (Order)this.find(l);
        order.setCreationDate(DateHelper.now());
        this.updateStock(order, true, false);
        this.setStatusAndNotifyExtensionPoints(order, OrderStatus.PENDING_BUYER, false);
        this.saleNotifications(order);
        return order.getId();
    }

    @Override
    public OrderDTO toDTO(Order order) {
        OrderDTO orderDTO = (OrderDTO)super.toDTO(order);
        orderDTO.setImage(this.getOrderImage(orderDTO.getId()));
        return orderDTO;
    }

    @Override
    public Order toEntity(OrderDTO orderDTO) {
        Order order;
        if (orderDTO.isPersistent()) {
            order = (Order)this.find(orderDTO.getId());
            this.fixOrderProductsDTO(orderDTO, order);
        }
        if ((order = (Order)super.toEntity(orderDTO)).getDeliveryAddress() == null) {
            order.setDeliveryAddress(new OrderAddress());
        }
        if (orderDTO.getDeliveryAddress() == null) {
            orderDTO.setDeliveryAddress(new OrderAddressDTO());
        }
        this.conversionHandler.fill((Object)orderDTO.getDeliveryAddress(), (Object)order.getDeliveryAddress());
        return order;
    }

    @Override
    protected OrderData getData(Order order) {
        OrderData orderData = new OrderData();
        User user = order.getBuyer();
        User user2 = order.getSeller();
        Currency currency = order.getCurrency();
        List<AdDeliveryMethodVO> list = this.listDeliveryMethods(order);
        OrderStatus orderStatus = order.getStatus();
        boolean bl = orderStatus == OrderStatus.SHOPPING_CART;
        orderData.setDto((EntityDTO)this.toDTO(order));
        orderData.setLogs(this.conversionHandler.convertList(OrderLogVO.class, (Iterable)order.getLogs()));
        orderData.setDeliveryMethods(list);
        orderData.setCheckout(bl);
        orderData.setHasItemsOutOfStock(bl && this.hasItemsOutOfStock(order));
        this.setOrderActions(orderData, order);
        orderData.setBuyerAddressConfiguration(this.configurationService.toAddressConfiguration(this.getConfiguration()));
        orderData.setSellerAddressConfiguration(this.configurationService.toAddressConfiguration(this.configurationHandler.getAccessor((BasicUser)order.getSeller())));
        if (orderStatus != OrderStatus.COMPLETED && !order.isPendingByAdmin()) {
            List<PaymentTransferType> list2;
            if (orderStatus == OrderStatus.SHOPPING_CART) {
                orderData.setInsufficientBalance(Boolean.valueOf(this.getCurrencyIfNotEnoughBalance(order, new Date(), null) != null));
            }
            if (currency == null) {
                list2 = this.currencyService.listForAds(order.getBuyer(), false);
                Object object = this.currencyService.listForAds(order.getSeller(), false);
                Collection collection = CollectionUtils.intersection(list2, (Iterable)object);
                orderData.setCurrencies(this.conversionHandler.convertList(CurrencyVO.class, (Iterable)collection));
            } else {
                if (order.getPaymentType() == null) {
                    list2 = this.listPaymentTypes(user, user2, currency);
                    orderData.setPaymentTypes(this.conversionHandler.convertList(TransferTypeVO.class, list2));
                }
                if (this.accountService.getAmountReservation(order) == null) {
                    orderData.setConfirmationPasswordInput((ICredentialInputDTO)this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).getCredentialInput());
                }
            }
            if (orderData.isCanSetDeliveryAddress()) {
                orderData.setBuyerAddresses(this.addressService.getAddressListData(new UserLocatorVO(user.getId())).getAddresses());
                if (orderStatus == OrderStatus.DRAFT) {
                    orderData.setSellerAddresses(this.conversionHandler.convertList(GeoLocatedAddressVO.class, (Iterable)this.addressService.getAddresses(user2, true, false)));
                }
            }
        }
        for (Object object : order.getProducts()) {
            if (object.getProduct().getStatus() == AdStatus.ACTIVE) continue;
            orderData.setHasItemsExpired(true);
            break;
        }
        if (order.isPersistent()) {
            orderData.setExportFormats(this.conversionHandler.convertList(ExportFormatVO.class, (Iterable)this.exportFormatService.listByContext(ExportFormatContext.ORDER_DETAILS)));
        }
        return orderData;
    }

    @Override
    protected Object[] getExcludedPropertiesToEntity(OrderDTO orderDTO) {
        return EXCLUDED_PROPERTIES;
    }

    @Override
    protected void onAfterSave(Order order, Order order2, Object object) {
        this.assignNumber(order);
        OrderAddress orderAddress = order.getDeliveryAddress();
        if (orderAddress != null) {
            orderAddress.setOrder(order);
        }
    }

    @Override
    protected Object onBeforeSave(Order order, Order order2) {
        if (order.isTransient()) {
            order.setCreatedBy(this.getLoggedUser());
            order.setCreationDate(DateHelper.now());
            order.setStatus(OrderStatus.DRAFT);
            order.setSale(true);
        }
        order.setUpdatedDate(DateHelper.now());
        this.updateTotal(order);
        return null;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QOrder)this.$).network());
    }

    @Override
    protected Validator resolveValidator(OrderDTO orderDTO) {
        return this.createValidator(orderDTO, false);
    }

    private void adjustQuantity(OrderProduct orderProduct) throws OutOfStockException {
        AdWebShop adWebShop = orderProduct.getProduct();
        BigDecimal bigDecimal = orderProduct.getQuantity();
        QuantityAdjustment quantityAdjustment = null;
        if (adWebShop.getMinAllowedInCart() != null && BigDecimalHelper.compareTo((BigDecimal)bigDecimal, (BigDecimal)adWebShop.getMinAllowedInCart()) < 0) {
            bigDecimal = adWebShop.getMinAllowedInCart();
            orderProduct.setQuantity(bigDecimal);
            quantityAdjustment = QuantityAdjustment.MIN;
        } else if (adWebShop.getMaxAllowedInCart() != null && BigDecimalHelper.compareTo((BigDecimal)bigDecimal, (BigDecimal)adWebShop.getMaxAllowedInCart()) > 0) {
            bigDecimal = adWebShop.getMaxAllowedInCart();
            orderProduct.setQuantity(bigDecimal);
            quantityAdjustment = QuantityAdjustment.MAX;
        }
        if (adWebShop.getStockType() == AdWebShopStockType.QUANTITY && BigDecimalHelper.compareTo((BigDecimal)bigDecimal, (BigDecimal)adWebShop.getStockQuantity()) > 0) {
            orderProduct.setQuantity(adWebShop.getStockQuantity());
            quantityAdjustment = QuantityAdjustment.STOCK;
        }
        orderProduct.setQuantityAdjustment(quantityAdjustment);
    }

    private void appendValidationsForSubmittingToBuyer(OrderDTO orderDTO, Validator validator) {
        User user;
        PropertyValidation propertyValidation = (object, object2, object3) -> {
            OrderProductDTO orderProductDTO = (OrderProductDTO)object;
            BigDecimal bigDecimal = (BigDecimal)object3;
            if (bigDecimal == null || BigDecimalHelper.isNegativeOrZero((BigDecimal)bigDecimal)) {
                return new ValidationError(MarketplaceKeys.WebshopOrders.ERROR_QUANTITY_POSITIVE, new Object[]{orderProductDTO.getProduct().getName()});
            }
            return null;
        };
        PropertyValidation propertyValidation2 = (object, object2, object3) -> {
            OrderProductDTO orderProductDTO = (OrderProductDTO)object;
            AdWebShop adWebShop = (AdWebShop)this.conversionHandler.convert(AdWebShop.class, (Object)orderProductDTO.getProduct());
            if (adWebShop == null) {
                return null;
            }
            BigDecimal bigDecimal = (BigDecimal)object3;
            if (bigDecimal == null) {
                return null;
            }
            BigDecimal bigDecimal2 = adWebShop.getMaxAllowedInCart();
            if (bigDecimal2 != null && BigDecimalHelper.compareTo((BigDecimal)bigDecimal, (BigDecimal)bigDecimal2) > 0) {
                return new ValidationError(MarketplaceKeys.WebshopOrders.ERROR_PROPERTY_MAX_EXCEEDED, new Object[]{adWebShop.getName(), bigDecimal2});
            }
            BigDecimal bigDecimal3 = adWebShop.getMinAllowedInCart();
            if (bigDecimal3 != null && BigDecimalHelper.compareTo((BigDecimal)bigDecimal, (BigDecimal)bigDecimal3) < 0) {
                return new ValidationError(MarketplaceKeys.WebshopOrders.ERROR_PROPERTY_MIN_EXCEEDED, new Object[]{adWebShop.getName(), bigDecimal3});
            }
            return null;
        };
        PropertyValidation propertyValidation3 = (object, object2, object3) -> {
            BigDecimal bigDecimal;
            OrderProductDTO orderProductDTO = (OrderProductDTO)object;
            AdWebShop adWebShop = (AdWebShop)this.conversionHandler.convert(AdWebShop.class, (Object)orderProductDTO.getProduct());
            if (adWebShop == null) {
                return null;
            }
            BigDecimal bigDecimal2 = (BigDecimal)object3;
            if (!adWebShop.getStatus().isActive()) {
                return new ValidationError(MarketplaceKeys.WebshopOrders.ERROR_ITEMS_NO_LONGER_AVAILABLE, new Object[]{orderProductDTO.getProduct().getName()});
            }
            if (!adWebShop.isInStock()) {
                return new ValidationError(MarketplaceKeys.WebshopOrders.ERROR_ITEMS_OUT_OF_STOCK, new Object[]{orderProductDTO.getProduct().getName()});
            }
            if (bigDecimal2 != null && adWebShop.getStockType() == AdWebShopStockType.QUANTITY && BigDecimalHelper.compareTo((BigDecimal)bigDecimal2, (BigDecimal)(bigDecimal = BigDecimalHelper.zeroWhenNull((BigDecimal)adWebShop.getStockQuantity()))) > 0) {
                return new ValidationError(MarketplaceKeys.WebshopOrders.ERROR_STOCK_LIMIT_EXCEEDED, new Object[]{orderProductDTO.getProduct().getName(), adWebShop.getStockQuantity()});
            }
            return null;
        };
        validator.property((Property)OrderDTO.PRODUCTS, MarketplaceKeys.WebshopOrders.PRODUCTS).required();
        Validator validator2 = new Validator();
        validator2.property((Property)OrderProductDTO.QUANTITY, MarketplaceKeys.WebshopOrders.QUANTITY).add(propertyValidation2).add(propertyValidation3).add(propertyValidation);
        validator.nested((Property)OrderDTO.PRODUCTS, validator2);
        org.cyclos.impl.utils.validation.Property property = validator.property((Property)OrderDTO.DELIVERY_ADDRESS, MarketplaceKeys.WebshopOrders.DELIVERY_ADDRESS);
        property.required();
        OrderAddressDTO orderAddressDTO = orderDTO.getDeliveryAddress();
        if (orderAddressDTO != null && (user = (User)this.conversionHandler.convert(User.class, (Object)(orderDTO.getDeliveryType() == AdDeliveryMethodType.PICKUP ? orderDTO.getSeller() : orderDTO.getBuyer()))) != null) {
            Validator validator3 = this.addressService.getValidator((AddressDTO)orderAddressDTO, user.getGroup(), false);
            validator.nested((PropertyAccess)new BeanPropertyAccess((Property)OrderDTO.DELIVERY_ADDRESS), validator3);
        }
        validator.property((Property)OrderDTO.DELIVERY_METHOD_NAME, MarketplaceKeys.WebshopOrders.DELIVERY_METHOD_NAME).required();
        validator.property((Property)OrderDTO.DELIVERY_PRICE, MarketplaceKeys.WebshopOrders.DELIVERY_PRICE).required().positiveOrZero();
        validator.property((Property)OrderDTO.MIN_DELIVERY_TIME, MarketplaceKeys.WebshopOrders.MIN_DELIVERY_TIME).minInterval(0, TimeField.DAYS).maxInterval(1, TimeField.YEARS);
        validator.property((Property)OrderDTO.MAX_DELIVERY_TIME, MarketplaceKeys.WebshopOrders.MAX_DELIVERY_TIME).required().minInterval(0, TimeField.DAYS).maxInterval(1, TimeField.YEARS).greaterThan((Comparable)orderDTO.getMinDeliveryTime());
    }

    private void approveByManager(Order order) {
        if (order.isPendingByAdmin()) {
            order.setPendingByAdmin(false);
            if (order.isSale()) {
                this.saleNotifications(order);
            } else {
                this.checkoutNotifications(order);
            }
        }
        this.setStatusAndNotifyExtensionPoints(order, order.getStatus(), true);
    }

    private void assignNumber(Order order) {
        if (order.getNumber() == null) {
            AdWebShopSetting adWebShopSetting = this.adWebShopSettingService.getAdWebShopSetting(order.getSeller());
            if (adWebShopSetting.isEnableOrderNumber()) {
                NumberGeneration numberGeneration = adWebShopSetting.getOrderNumber();
                order.setNumber(numberGeneration.generate(order.getId()));
            } else {
                String string = order.getId().toString();
                if (string.length() < 5) {
                    string = StringUtils.leftPad((String)string, (int)5, (char)'0');
                }
                order.setNumber(string);
            }
        }
    }

    private BigDecimal calculateTotal(Order order, BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = BigDecimal.ZERO;
        for (OrderProduct orderProduct : order.getProducts()) {
            bigDecimal2 = bigDecimal2.add(orderProduct.getProductTotal());
        }
        bigDecimal2 = bigDecimal2.add(BigDecimalHelper.zeroWhenNull((BigDecimal)bigDecimal));
        return BigDecimalHelper.round((BigDecimal)bigDecimal2, (int)order.getCurrency().getPrecision());
    }

    private void cancel(Order order) {
        if (order.getStatus() == OrderStatus.SHOPPING_CART) {
            this.remove(order);
        } else {
            this.returnReservedAmount(order);
            this.returnStock(order);
            boolean bl = order.isPendingByAdmin();
            if (bl) {
                order.setPendingByAdmin(false);
            }
            this.setStatusAndNotifyExtensionPoints(order, OrderStatus.DISPOSED, bl);
            this.notifyCanceledOrder(order);
        }
    }

    private void checkoutNotifications(Order order) {
        if (order.getDeliveryPrice() != null) {
            this.notificationHandler.user((BasicUser)order.getSeller()).marketplaceSeller().orderCreated(order, order.getBuyer());
        } else {
            this.notificationHandler.user((BasicUser)order.getSeller()).marketplaceSeller().orderPendingDeliveryDataSeller(order, order.getNumber());
            this.notificationHandler.user((BasicUser)order.getBuyer()).marketplaceBuyer().orderPendingDeliveryDataBuyer(order, order.getNumber());
        }
    }

    private int countCartItems(User user) throws FrameworkException {
        QOrderProduct qOrderProduct = QOrderProduct.orderProduct;
        return ((DBQuery)this.from(new EntityPath[]{qOrderProduct}).where(new Predicate[]{qOrderProduct.order().status.eq((Object)OrderStatus.SHOPPING_CART), qOrderProduct.order().buyer().eq((Object)user)})).count(qOrderProduct.id);
    }

    private Validator createActionValidator() {
        Validator validator = new Validator();
        validator.property((Property)OrderActionParams.ORDER, MarketplaceKeys.WebshopOrders.ORDER).required();
        validator.property((Property)OrderActionParams.REMARKS, MarketplaceKeys.WebshopOrders.REMARKS).maxLength(4000);
        return validator;
    }

    private Validator createValidator(OrderDTO orderDTO, boolean bl) {
        Validator validator = new Validator();
        if (orderDTO.isPersistent()) {
            Order order = (Order)this.find(orderDTO.getId());
            if (order.getStatus() != OrderStatus.DRAFT || !order.isSale()) {
                validator.general(GeneralValidations.invalid((ValidationError)new ValidationError(MarketplaceKeys.WebshopOrders.ERROR_NOT_DRAFT)));
                return validator;
            }
        } else {
            org.cyclos.impl.utils.validation.Property property = validator.property((Property)OrderDTO.SELLER, MarketplaceKeys.WebshopOrders.SELLER);
            if (orderDTO.getSeller() != null && !((User)this.conversionHandler.convert(User.class, (Object)orderDTO.getSeller())).equals((Object)this.getLoggedUser())) {
                property.invalid();
            }
            property.required();
            validator.property((Property)OrderDTO.BUYER, MarketplaceKeys.WebshopOrders.BUYER).required();
            validator.property((Property)OrderDTO.CURRENCY, MarketplaceKeys.WebshopOrders.CURRENCY).required();
        }
        validator.property((Property)OrderDTO.REMARKS, MarketplaceKeys.WebshopOrders.REMARKS).maxLength(4000);
        if (bl) {
            this.appendValidationsForSubmittingToBuyer(orderDTO, validator);
        }
        return validator;
    }

    private void fixOrderProductsDTO(OrderDTO orderDTO, Order order) {
        List list = order.getProducts().stream().map(OrderProduct::getProduct).collect(Collectors.toList());
        CollectionHelper.orEmpty((List)orderDTO.getProducts()).stream().filter(orderProductDTO -> orderProductDTO.getId() == null).forEach(orderProductDTO -> {
            AdWebShop adWebShop = (AdWebShop)this.conversionHandler.convert(AdWebShop.class, (Object)orderProductDTO.getProduct());
            int n = list.indexOf(adWebShop);
            if (n >= 0) {
                OrderProduct orderProduct = (OrderProduct)order.getProducts().get(n);
                orderProductDTO.setId(orderProduct.getId());
                orderProductDTO.setVersion(orderProduct.getVersion());
            }
            orderProductDTO.setOrder(new OrderVO(order.getId()));
            if (orderProductDTO.getPrice() == null) {
                orderProductDTO.setPrice(adWebShop.getPrice().getAmount());
            }
            if (orderProductDTO.getQuantity() == null) {
                orderProductDTO.setQuantity(adWebShop.getMinAllowedInCart() != null ? adWebShop.getMinAllowedInCart() : BigDecimal.ONE);
            }
        });
    }

    private Set<OrderStatus> getCancelableStatuses() {
        EnumSet<OrderStatus> enumSet = EnumSet.of(OrderStatus.DRAFT, OrderStatus.SHOPPING_CART, OrderStatus.PENDING_BUYER, OrderStatus.PENDING_SELLER);
        return enumSet;
    }

    private Currency getCurrencyIfNotEnoughBalance(Order order, Date date, Map<Currency, List<Account>> map) {
        List<Object> list;
        List<Account> list2 = list = map == null ? null : map.get(order.getCurrency());
        if (list == null) {
            list = this.accountService.listVisible((InternalAccountOwner)this.getLoggedBasicUser()).stream().filter(account -> account.getCurrency().equals((Object)order.getCurrency())).collect(Collectors.toList());
            if (map != null) {
                map.put(order.getCurrency(), list != null ? list : Collections.emptyList());
            }
        }
        for (Account account2 : list) {
            BigDecimal bigDecimal = this.accountService.getAvailableBalance(account2, date);
            if (BigDecimalHelper.compareTo((BigDecimal)bigDecimal, (BigDecimal)order.getTotal()) < 0) continue;
            return null;
        }
        return order.getCurrency();
    }

    private Order getForShoppingCart(User user, User user2, Currency currency, boolean bl) throws FrameworkException {
        Order order = (Order)((DBQuery)this.from().where(new Predicate[]{((QOrder)this.$).status.eq((Object)OrderStatus.SHOPPING_CART), ((QOrder)this.$).buyer().eq((Object)user), ((QOrder)this.$).seller().eq((Object)user2), ((QOrder)this.$).currency().eq((Object)currency)})).singleResult((Expression)this.$);
        if (order == null && bl) {
            Date date = DateHelper.now();
            order = new Order();
            order.setStatus(OrderStatus.SHOPPING_CART);
            order.setBuyer(user);
            order.setSeller(user2);
            order.setCurrency(currency);
            order.setCreatedBy(user);
            order.setCreationDate(date);
            order.setUpdatedDate(date);
            this.persist((IEntity)order);
        }
        return order;
    }

    private List<CurrencyVO> getLowBalanceCurrencies(List<Order> list) {
        ArrayList<CurrencyVO> arrayList = new ArrayList<CurrencyVO>();
        Date date = DateHelper.now();
        HashMap<Currency, List<Account>> hashMap = new HashMap<Currency, List<Account>>();
        for (Order order : list) {
            Currency currency = this.getCurrencyIfNotEnoughBalance(order, date, hashMap);
            if (currency == null) continue;
            arrayList.add((CurrencyVO)this.conversionHandler.convert(CurrencyVO.class, (Object)currency));
        }
        return arrayList;
    }

    private OrderStatus getNewRejectedStatus(Order order) {
        OrderStatus orderStatus = null;
        if (order.getSeller().equals((Object)this.getLoggedUser())) {
            orderStatus = OrderStatus.REJECTED_BY_SELLER;
        } else if (order.getBuyer().equals((Object)this.getLoggedUser())) {
            orderStatus = OrderStatus.REJECTED_BY_BUYER;
        } else {
            boolean bl = this.orderServiceSecurity.hasBuyerPermission(order, true);
            boolean bl2 = this.orderServiceSecurity.hasSellerPermission(order, true);
            if (bl && bl2) {
                orderStatus = order.getStatus() == OrderStatus.PENDING_BUYER ? OrderStatus.REJECTED_BY_BUYER : OrderStatus.REJECTED_BY_SELLER;
            } else if (bl) {
                orderStatus = OrderStatus.REJECTED_BY_BUYER;
            } else if (bl2) {
                orderStatus = OrderStatus.REJECTED_BY_SELLER;
            } else {
                throw new IllegalActionException("No permission to reject the order");
            }
        }
        return orderStatus;
    }

    private Order getOrder(OrderActionParams orderActionParams) {
        Order order = (Order)this.conversionHandler.convert(Order.class, (Object)orderActionParams.getOrder());
        if (order == null) {
            throw new ValidationException();
        }
        return order;
    }

    private ImageVO getOrderImage(Long l) {
        if (l == null) {
            return null;
        }
        QOrderProduct qOrderProduct = QOrderProduct.orderProduct;
        AdImage adImage = (AdImage)((DBQuery)((DBQuery)((DBQuery)this.from(new EntityPath[]{qOrderProduct}).leftJoin((EntityPath)qOrderProduct.order(), (Path)this.$)).select((Expression)qOrderProduct.product().image()).where((Predicate)((QOrder)this.$).id.eq((Object)l).and((Predicate)qOrderProduct.product().image().isNotNull()))).orderBy(qOrderProduct.productIndex.asc())).fetchFirst();
        return (ImageVO)this.conversionHandler.convert(ImageVO.class, (Object)adImage);
    }

    private OrderProduct getOrderProduct(Order order, AdWebShop adWebShop) {
        QOrderProduct qOrderProduct = QOrderProduct.orderProduct;
        return (OrderProduct)((DBQuery)this.from(new EntityPath[]{qOrderProduct}).where(new Predicate[]{qOrderProduct.order().eq((Object)order), qOrderProduct.product().eq((Object)adWebShop)})).singleResult((Expression)qOrderProduct);
    }

    private boolean hasItemsOutOfStock(Order order) {
        for (OrderProduct orderProduct : order.getProducts()) {
            AdWebShop adWebShop = orderProduct.getProduct();
            AdWebShopStockType adWebShopStockType = adWebShop.getStockType();
            if (adWebShopStockType != AdWebShopStockType.NOT_AVAILABLE && (adWebShopStockType != AdWebShopStockType.QUANTITY || !BigDecimalHelper.isZero((BigDecimal)adWebShop.getStockQuantity()))) continue;
            return true;
        }
        return false;
    }

    private boolean hasOrders(User user, boolean bl) {
        QUser qUser = bl ? ((QOrder)this.$).buyer() : ((QOrder)this.$).seller();
        return ((DBQuery)this.from(this.$).where(new Predicate[]{((QOrder)this.$).status.in((Object[])new OrderStatus[]{OrderStatus.COMPLETED, OrderStatus.REJECTED_BY_BUYER, OrderStatus.REJECTED_BY_SELLER}), qUser.eq((Object)user)})).hasResults();
    }

    private List<AdDeliveryMethodVO> listDeliveryMethods(Order order) throws FrameworkException {
        if (order.getStatus() == OrderStatus.DRAFT) {
            return this.adDeliveryMethodService.listMineByCurrency(order.getCurrency());
        }
        ArrayList arrayList = null;
        for (OrderProduct orderProduct : order.getProducts()) {
            Set set = orderProduct.getProduct().getDeliveryMethods().stream().filter(AdDeliveryMethod::isEnabled).collect(Collectors.toSet());
            if (arrayList == null) {
                arrayList = new ArrayList(set);
                continue;
            }
            arrayList.retainAll(set);
        }
        List list = arrayList == null ? Collections.emptyList() : arrayList;
        return CollectionHelper.sort((Collection)this.conversionHandler.convertList(AdDeliveryMethodVO.class, (Iterable)list));
    }

    private List<PaymentTransferType> listPaymentTypes(User user, User user2, Currency currency) {
        LocateAccountOwnerResult locateAccountOwnerResult = this.accountHandler.locate((AccountOwner)user);
        LocateAccountOwnerResult locateAccountOwnerResult2 = this.accountHandler.locate((AccountOwner)user2);
        return this.transactionService.listPaymentTypes(locateAccountOwnerResult, locateAccountOwnerResult2, currency, false);
    }

    private ShoppingCartDTO maybeAdjustAndGetMyCart(boolean bl) {
        List list = ((DBQuery)((DBQuery)this.from().where(new Predicate[]{((QOrder)this.$).status.eq((Object)OrderStatus.SHOPPING_CART), ((QOrder)this.$).buyer().eq((Object)this.getLoggedUser())})).orderBy(((QOrder)this.$).id.desc())).list((Expression)this.$);
        if (bl) {
            list.stream().flatMap(order -> order.getProducts().stream()).forEach(this::adjustQuantity);
        }
        ShoppingCartDTO shoppingCartDTO = new ShoppingCartDTO();
        shoppingCartDTO.setOrders(this.conversionHandler.convertList(OrderDTO.class, (Iterable)list));
        shoppingCartDTO.setLowBalanceCurrencies(this.getLowBalanceCurrencies(list));
        return shoppingCartDTO;
    }

    private void notifyAcceptedOrder(Order order, boolean bl, boolean bl2) {
        if (bl) {
            MarketplaceSellerNotificationsHandler marketplaceSellerNotificationsHandler = this.notificationHandler.user((BasicUser)order.getSeller()).marketplaceSeller();
            if (bl2) {
                marketplaceSellerNotificationsHandler.orderPendingAuthorizationSeller(order, order.getNumber(), order.getBuyer());
            } else {
                marketplaceSellerNotificationsHandler.saleRealizedBuyer(order, order.getNumber(), order.getBuyer());
            }
        } else {
            MarketplaceBuyerNotificationsHandler marketplaceBuyerNotificationsHandler = this.notificationHandler.user((BasicUser)order.getBuyer()).marketplaceBuyer();
            if (bl2) {
                marketplaceBuyerNotificationsHandler.orderPendingAuthorizationBuyer(order, order.getNumber(), order.getSeller());
            } else {
                marketplaceBuyerNotificationsHandler.orderRealizedSeller(order, order.getNumber(), order.getSeller());
            }
        }
    }

    private void notifyCanceledOrder(Order order) {
        this.notificationHandler.user((BasicUser)order.getSeller()).marketplaceSeller().orderCanceledSeller(order, order.getNumber(), order.getBuyer());
        this.notificationHandler.user((BasicUser)order.getBuyer()).marketplaceBuyer().orderCanceledBuyer(order, order.getNumber(), order.getSeller());
    }

    private void notifyRejectedOrder(Order order) {
        SessionData sessionData = this.getSessionData();
        if (order.getStatus() == OrderStatus.REJECTED_BY_SELLER) {
            MarketplaceBuyerNotificationsHandler marketplaceBuyerNotificationsHandler = this.notificationHandler.user((BasicUser)order.getBuyer()).marketplaceBuyer();
            if (order.isSale()) {
                marketplaceBuyerNotificationsHandler.saleRejectedSeller(order, order.getNumber(), order.getSeller());
            } else {
                marketplaceBuyerNotificationsHandler.orderRejectedBySeller(order, order.getNumber(), order.getSeller());
            }
            if (!sessionData.isSelf((BasicUser)order.getSeller())) {
                this.notificationHandler.user((BasicUser)order.getSeller()).marketplaceSeller().orderCanceledSeller(order, order.getNumber(), order.getBuyer());
            }
        }
        if (order.getStatus() == OrderStatus.REJECTED_BY_BUYER) {
            this.notificationHandler.user((BasicUser)order.getSeller()).marketplaceSeller().orderRejectedByBuyer(order, order.getNumber(), order.getBuyer());
            if (!sessionData.isSelf((BasicUser)order.getBuyer())) {
                this.notificationHandler.user((BasicUser)order.getBuyer()).marketplaceBuyer().orderCanceledBuyer(order, order.getNumber(), order.getSeller());
            }
        }
    }

    private void notifyRejectedPayment(Order order) {
        Payment payment = order.getPayment();
        TransactionAuthorization transactionAuthorization = (TransactionAuthorization)payment.getAuthorizations().get(payment.getAuthorizations().size() - 1);
        BasicUser basicUser = transactionAuthorization.getBy();
        boolean bl = basicUser != null && basicUser.getUser().equals((Object)order.getSeller());
        boolean bl2 = basicUser != null && basicUser.getUser().equals((Object)order.getBuyer());
        switch (order.getStatus()) {
            case PAYMENT_DENIED: {
                if (!bl2) {
                    this.notificationHandler.user((BasicUser)order.getBuyer()).marketplaceBuyer().orderPaymentDeniedBuyer(order, order.getNumber(), order.getSeller());
                }
                if (bl) break;
                this.notificationHandler.user((BasicUser)order.getSeller()).marketplaceSeller().orderPaymentDeniedSeller(order, order.getNumber(), order.getBuyer());
                break;
            }
            case PAYMENT_CANCELED: {
                if (!bl2) {
                    this.notificationHandler.user((BasicUser)order.getBuyer()).marketplaceBuyer().orderPaymentCanceledBuyer(order, order.getNumber(), order.getSeller());
                }
                if (bl) break;
                this.notificationHandler.user((BasicUser)order.getSeller()).marketplaceSeller().orderPaymentCanceledSeller(order, order.getNumber(), order.getBuyer());
                break;
            }
            case PAYMENT_EXPIRED: {
                this.notificationHandler.user((BasicUser)order.getBuyer()).marketplaceBuyer().orderPaymentExpiredBuyer(order, order.getNumber(), order.getSeller());
                this.notificationHandler.user((BasicUser)order.getSeller()).marketplaceSeller().orderPaymentExpiredSeller(order, order.getNumber(), order.getBuyer());
                break;
            }
        }
    }

    private void onTransactionAuthorization(Order order) {
        Payment payment;
        Payment payment2 = payment = order == null ? null : order.getPayment();
        if (payment == null) {
            return;
        }
        OrderStatus orderStatus = null;
        switch (payment.getAuthorizationStatus()) {
            case AUTHORIZATION_CANCELED: {
                orderStatus = OrderStatus.PAYMENT_CANCELED;
                break;
            }
            case AUTHORIZATION_DENIED: {
                orderStatus = OrderStatus.PAYMENT_DENIED;
                break;
            }
            case AUTHORIZATION_EXPIRED: {
                orderStatus = OrderStatus.PAYMENT_EXPIRED;
                break;
            }
            case AUTHORIZED: {
                orderStatus = OrderStatus.COMPLETED;
                break;
            }
            case NA: 
            case PENDING_AUTHORIZATION: {
                return;
            }
        }
        QOrderLog qOrderLog = QOrderLog.orderLog;
        OrderLog orderLog = (OrderLog)((DBQuery)((DBQuery)((DBQuery)this.from(new EntityPath[]{qOrderLog}).where(new Predicate[]{qOrderLog.order().eq((Object)order), qOrderLog.status.in((Object[])new OrderStatus[]{OrderStatus.PENDING_SELLER, OrderStatus.PENDING_BUYER})})).orderBy(qOrderLog.date.desc())).limit(1L)).singleResult((Expression)qOrderLog);
        boolean bl = orderLog.getStatus() == OrderStatus.PENDING_BUYER;
        this.setStatusAndNotifyExtensionPoints(order, orderStatus, false);
        if (orderStatus == OrderStatus.COMPLETED) {
            this.notifyAcceptedOrder(order, bl, false);
        } else {
            this.returnStock(order);
            this.notifyRejectedPayment(order);
        }
    }

    private void registerTransactionAuthorizationHandler(AuthorizationAction authorizationAction) {
        this.transactionAuthorizationService.registerHandler(authorizationAction, Payment.class, payment -> ((DBQuery)this.from(this.$).where((Predicate)((QOrder)this.$).payment().eq(payment))).list((Expression)this.$).forEach(this::onTransactionAuthorization));
    }

    private void removeItem(OrderProduct orderProduct) {
        Order order = orderProduct.getOrder();
        order.getProducts().remove(orderProduct);
        this.remove(orderProduct);
        if (order.getProducts().isEmpty()) {
            this.remove(order);
        }
    }

    private CloseableIterator<Order> resolveOrdersToCancel(UserAccount userAccount) {
        if (userAccount.isTransient()) {
            return CloseableIteratorHelper.empty();
        }
        QOrderAmountReservation qOrderAmountReservation = new QOrderAmountReservation("r");
        QOrderAmountReservation qOrderAmountReservation2 = new QOrderAmountReservation("d");
        return ((DBQuery)((DBQuery)((DBQuery)((DBQuery)((DBQuery)this.from(this.$).innerJoin((EntityPath)qOrderAmountReservation)).on((Predicate)qOrderAmountReservation.order().eq((Expression)this.$).and((Predicate)qOrderAmountReservation.amount.gt((Number)0)))).leftJoin((EntityPath)qOrderAmountReservation2)).on((Predicate)qOrderAmountReservation2.order().eq((Expression)this.$).and((Predicate)qOrderAmountReservation2.amount.lt((Number)0)))).where(new Predicate[]{qOrderAmountReservation.account().eq((Object)userAccount), qOrderAmountReservation2.id.isNull(), ((QOrder)this.$).status.in(this.getCancelableStatuses())})).iterate((Expression)this.$);
    }

    private void returnReservedAmount(Order order) {
        if (this.accountService.getAmountReservation(order) != null) {
            this.accountService.dereserveAmount(order);
        }
    }

    private void returnStock(Order order) {
        if (order.isStockUpdated()) {
            this.updateStock(order, false, false);
        }
    }

    private BigDecimal roundQuantity(AdWebShop adWebShop, BigDecimal bigDecimal) {
        bigDecimal = BigDecimalHelper.round((BigDecimal)bigDecimal, (int)(adWebShop.isAllowDecimal() ? 2 : 0));
        return bigDecimal;
    }

    private void saleNotifications(Order order) {
        this.notificationHandler.user((BasicUser)order.getBuyer()).marketplaceBuyer().salePendingBuyer(order, order.getNumber(), order.getSeller());
    }

    private void setOrderActions(OrderData orderData, Order order) {
        SessionData sessionData = this.getSessionData();
        boolean bl = sessionData.isSelf((BasicUser)order.getSeller()) || sessionData.isManagerOf((BasicUser)order.getSeller());
        boolean bl2 = sessionData.isSelf((BasicUser)order.getBuyer()) || sessionData.isManagerOf((BasicUser)order.getBuyer());
        boolean bl3 = CollectionHelper.isNotEmpty((Iterable)orderData.getDeliveryMethods());
        boolean bl4 = StringHelper.isNotBlank((Object)order.getDeliveryMethodName());
        boolean bl5 = order.getDeliveryPrice() != null;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        if (order.isPendingByAdmin()) {
            bl7 = bl6 = this.getSessionData().isAdmin();
        } else {
            switch (order.getStatus()) {
                case DRAFT: {
                    bl6 = bl;
                    bl8 = bl;
                    bl9 = bl;
                    bl10 = bl;
                    break;
                }
                case SHOPPING_CART: {
                    bl8 = bl2 && bl3;
                    bl10 = bl2;
                    break;
                }
                case PENDING_BUYER: {
                    bl6 = bl2;
                    bl7 = bl2 || bl;
                    break;
                }
                case PENDING_SELLER: {
                    bl6 = bl && bl4 && bl5;
                    bl7 = bl;
                    bl8 = bl && !bl4;
                    bl9 = bl && (!bl4 || !bl5);
                    break;
                }
            }
        }
        orderData.setCanAccept(bl6);
        orderData.setCanReject(bl7);
        orderData.setCanSetDeliveryMethod(bl8);
        orderData.setCanSetDeliveryPrice(bl9);
        orderData.setCanSetDeliveryAddress(bl10);
    }

    private void setStatusAndNotifyExtensionPoints(Order order, OrderStatus orderStatus, boolean bl) {
        Group group = order.isSale() ? order.getSeller().getGroup() : order.getBuyer().getGroup();
        ExtensionPointAccessor extensionPointAccessor = this.extensionPointService.newAccessor((ExtensionPointEvent)OrderExtensionPointEvent.CHANGE_STATUS, new ExtensionPointFilter(group)).attribute("order", (Object)order).attribute("oldStatus", (Object)order.getStatus()).attribute("newStatus", (Object)orderStatus).attribute("wasPendingByAdmin", (Object)bl);
        extensionPointAccessor.fireValidated();
        order.setStatus(orderStatus);
        extensionPointAccessor.fireSaved();
        OrderLog orderLog = new OrderLog();
        orderLog.setBy(this.getLoggedBasicUser());
        orderLog.setDate(DateHelper.now());
        orderLog.setOrder(order);
        orderLog.setStatus(order.getStatus());
        orderLog.setPendingByAdmin(order.isPendingByAdmin());
        orderLog.setRemarks(order.getRemarks());
        this.persist((IEntity)orderLog);
    }

    private void throwCannotBuyException(User user) throws CannotBuyException {
        throw new CannotBuyException(null, (UserVO)this.conversionHandler.convert(UserVO.class, (Object)user));
    }

    private void throwOutOfStockException(AdWebShop adWebShop) throws OutOfStockException {
        throw new OutOfStockException((AdWebShopVO)this.conversionHandler.convert(AdWebShopVO.class, (Object)adWebShop));
    }

    private void updateStock(Order order, boolean bl, boolean bl2) {
        AdWebShop adWebShop;
        if (!bl2 && (bl && order.isStockUpdated() || !bl && !order.isStockUpdated())) {
            throw new IllegalActionException();
        }
        ArrayList<OrderProduct> arrayList = new ArrayList<OrderProduct>();
        for (OrderProduct orderProduct : order.getProducts()) {
            adWebShop = orderProduct.getProduct();
            if (adWebShop.getStockType() == AdWebShopStockType.NOT_AVAILABLE) {
                this.throwOutOfStockException(adWebShop);
                continue;
            }
            if (adWebShop.getStockType() != AdWebShopStockType.QUANTITY) continue;
            arrayList.add(orderProduct);
            if (bl2) continue;
            this.lockHandler.lock(LockType.WEBSHOP_PRODUCT.key(adWebShop.getId()));
        }
        for (OrderProduct orderProduct : arrayList) {
            boolean bl3;
            BigDecimal bigDecimal;
            adWebShop = orderProduct.getProduct();
            BigDecimal bigDecimal2 = orderProduct.getQuantity();
            BigDecimal bigDecimal3 = bigDecimal = bl ? adWebShop.getStockQuantity().subtract(bigDecimal2) : adWebShop.getStockQuantity().add(bigDecimal2);
            if (bl && BigDecimalHelper.isNegative((BigDecimal)bigDecimal)) {
                this.throwOutOfStockException(adWebShop);
            }
            if (bl2) continue;
            adWebShop.setStockQuantity(bigDecimal);
            User user = adWebShop.getOwner();
            MarketplaceSellerNotificationsHandler marketplaceSellerNotificationsHandler = this.notificationHandler.user((BasicUser)user).marketplaceSeller();
            if (BigDecimalHelper.isZero((BigDecimal)adWebShop.getStockQuantity())) {
                marketplaceSellerNotificationsHandler.articleOutOfStock(adWebShop, adWebShop.getName());
                continue;
            }
            BigDecimal bigDecimal4 = BigDecimalHelper.zeroWhenNull((BigDecimal)adWebShop.getMinimumStockLimit());
            boolean bl4 = bl3 = BigDecimalHelper.compareTo((BigDecimal)bigDecimal, (BigDecimal)bigDecimal4) > 0;
            if (bl3) {
                adWebShop.setLowStockNotified(Boolean.valueOf(false));
            }
            if (!bl || Boolean.TRUE.equals(adWebShop.getLowStockNotified()) || bl3 || !BigDecimalHelper.isPositive((BigDecimal)bigDecimal4)) continue;
            marketplaceSellerNotificationsHandler.lowStockQuantity(adWebShop, adWebShop.getName(), bigDecimal4, bigDecimal);
            adWebShop.setLowStockNotified(Boolean.valueOf(true));
        }
        if (!bl2) {
            order.setStockUpdated(bl);
        }
    }

    private void updateTotal(Order order) {
        order.setTotal(this.calculateTotal(order, order.getDeliveryPrice()));
    }

    @Override
    private void validate(AcceptOrderParams acceptOrderParams) {
        Order order = this.getOrder((OrderActionParams)acceptOrderParams);
        Validator validator = this.createActionValidator();
        if (!order.isPendingByAdmin()) {
            if (order.getPaymentType() == null) {
                validator.property((Property)AcceptOrderParams.PAYMENT_TYPE, MarketplaceKeys.WebshopOrders.PAYMENT_TYPE).required();
            }
            if (this.accountService.getAmountReservation(order) == null) {
                this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).addRequiredValidation(validator, (Property)AcceptOrderParams.CONFIRMATION_PASSWORD);
            }
        }
        this.validate(validator, acceptOrderParams, "acceptOrderParams");
    }

    private void validate(Order order, SetDeliveryMethodParams setDeliveryMethodParams) {
        Validator validator = this.createActionValidator();
        validator.property((Property)SetDeliveryMethodParams.DELIVERY_METHOD_NAME, MarketplaceKeys.WebshopOrders.DELIVERY_METHOD_NAME).required();
        validator.property((Property)SetDeliveryMethodParams.DELIVERY_PRICE, MarketplaceKeys.WebshopOrders.DELIVERY_PRICE).required().positiveOrZero().lessThan((Comparable)TransactionService.MAX_TRANSACTION_AMOUNT_EXCLUSIVE);
        validator.property((Property)SetDeliveryMethodParams.MIN_DELIVERY_TIME, MarketplaceKeys.WebshopOrders.MIN_DELIVERY_TIME).minInterval(0, TimeField.DAYS).maxInterval(1, TimeField.YEARS);
        validator.property((Property)SetDeliveryMethodParams.MAX_DELIVERY_TIME, MarketplaceKeys.WebshopOrders.MAX_DELIVERY_TIME).required().minInterval(0, TimeField.DAYS).maxInterval(1, TimeField.YEARS).greaterThan((Comparable)setDeliveryMethodParams.getMinDeliveryTime());
        this.validate(validator, setDeliveryMethodParams, "setDeliveryMethodParams");
    }

    @Override
    private void validate(RejectOrderParams rejectOrderParams) {
        this.validate(this.createActionValidator(), rejectOrderParams, "rejectOrderParams");
    }

    @Override
    private void validate(ShoppingCartCheckoutParams shoppingCartCheckoutParams) {
        final Order order = this.getOrder((OrderActionParams)shoppingCartCheckoutParams);
        Validator validator = new Validator();
        validator.property((Property)ShoppingCartCheckoutParams.PAYMENT_TYPE, MarketplaceKeys.WebshopOrders.PAYMENT_TYPE).required();
        AdDeliveryMethod adDeliveryMethod = (AdDeliveryMethod)this.conversionHandler.convert(AdDeliveryMethod.class, (Object)shoppingCartCheckoutParams.getDeliveryMethod());
        validator.property((Property)ShoppingCartCheckoutParams.DELIVERY_METHOD, MarketplaceKeys.WebshopOrders.DELIVERY_METHOD).entity(AdDeliveryMethod.class, (EntityValidation)new BaseEntityValidation<AdDeliveryMethod>(){

            protected boolean isValid(Object object, Object object2, AdDeliveryMethod adDeliveryMethod) {
                return adDeliveryMethod.isEnabled() && adDeliveryMethod.getOwner().equals((Object)order.getSeller()) && (adDeliveryMethod.getChargeType() == AdDeliveryMethodChargeType.NEGOTIATED || order.getCurrency().equals((Object)adDeliveryMethod.getCurrency()));
            }
        });
        if (adDeliveryMethod != null && adDeliveryMethod.getChargeType() == AdDeliveryMethodChargeType.FIXED) {
            this.passwordHandler.accessor(CredentialUsage.CONFIRMATION).addRequiredValidation(validator, (Property)ShoppingCartCheckoutParams.CONFIRMATION_PASSWORD);
        }
        org.cyclos.impl.utils.validation.Property property = validator.property((Property)ShoppingCartCheckoutParams.DELIVERY_ADDRESS, MarketplaceKeys.WebshopOrders.DELIVERY_ADDRESS);
        property.required();
        AddressDTO addressDTO = shoppingCartCheckoutParams.getDeliveryAddress();
        if (addressDTO != null) {
            User user = adDeliveryMethod != null && adDeliveryMethod.getDeliveryType() == AdDeliveryMethodType.PICKUP ? order.getSeller() : order.getBuyer();
            Validator validator2 = this.addressService.getValidator(addressDTO, user.getGroup(), false);
            validator.nested((Property)ShoppingCartCheckoutParams.DELIVERY_ADDRESS, validator2);
        }
        if (order.getStatus() == OrderStatus.SHOPPING_CART) {
            validator.general(object -> {
                for (OrderProduct orderProduct : order.getProducts()) {
                    if (orderProduct.getProduct().getStatus() == AdStatus.ACTIVE) continue;
                    return new ValidationError(MarketplaceKeys.WebshopOrders.ERROR_ITEMS_NO_LONGER_AVAILABLE);
                }
                return null;
            });
        }
        this.validate(validator, shoppingCartCheckoutParams, "shoppingCartCheckoutParams");
    }

    private void validatePaymentType(Order order, PaymentTransferType paymentTransferType) {
        List<PaymentTransferType> list = this.listPaymentTypes(order.getBuyer(), order.getSeller(), order.getCurrency());
        boolean bl = false;
        if (!list.contains(paymentTransferType) || paymentTransferType.getFixedAmount() != null && (order.getDeliveryPrice() == null || !BigDecimalHelper.areEquals((BigDecimal)paymentTransferType.getFixedAmount(), (BigDecimal)order.getTotalAmount().getAmount()))) {
            bl = true;
        }
        if (bl) {
            throw new ValidationException(this.message(GeneralKeys.Errors.INVALID, MarketplaceKeys.WebshopOrders.PAYMENT_TYPE));
        }
    }
}

