/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.messaging;

import com.fasterxml.jackson.core.type.TypeReference;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.banking.Account;
import org.cyclos.entities.banking.Currency;
import org.cyclos.entities.banking.QAccount;
import org.cyclos.entities.banking.UserAccount;
import org.cyclos.entities.messaging.Alert;
import org.cyclos.entities.messaging.QSystemAlert;
import org.cyclos.entities.messaging.QUserAlert;
import org.cyclos.entities.messaging.SystemAlert;
import org.cyclos.entities.messaging.UserAlert;
import org.cyclos.entities.system.Network;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.QUser;
import org.cyclos.entities.users.User;
import org.cyclos.entities.utils.CurrencyAmount;
import org.cyclos.entities.utils.DatePeriod;
import org.cyclos.impl.BaseServiceImpl;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.messaging.AlertServiceLocal;
import org.cyclos.impl.sql.InconsistentBalance;
import org.cyclos.impl.system.NetworkServiceLocal;
import org.cyclos.impl.users.GroupListView;
import org.cyclos.impl.utils.QueryHelper;
import org.cyclos.impl.utils.formatting.FormatterImpl;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.persistence.RawEntityManagerHandler;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.IEntity;
import org.cyclos.model.INamedEntity;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.messaging.MessagingKeys;
import org.cyclos.model.messaging.alerts.SystemAlertQuery;
import org.cyclos.model.messaging.alerts.SystemAlertSearchData;
import org.cyclos.model.messaging.alerts.SystemAlertType;
import org.cyclos.model.messaging.alerts.SystemAlertVO;
import org.cyclos.model.messaging.alerts.UserAlertQuery;
import org.cyclos.model.messaging.alerts.UserAlertSearchData;
import org.cyclos.model.messaging.alerts.UserAlertType;
import org.cyclos.model.messaging.alerts.UserAlertVO;
import org.cyclos.model.utils.TimeField;
import org.cyclos.server.utils.DateHelper;
import org.cyclos.server.utils.jackson.JacksonConfiguration;
import org.cyclos.utils.BigDecimalHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Page;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlertServiceImpl
extends BaseServiceImpl
implements AlertServiceLocal {
    private static final int MAX_ARGS = 5;
    @Autowired
    private RawEntityManagerHandler rawEntityManagerHandler;
    @Autowired
    private NetworkServiceLocal networkService;
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private JacksonConfiguration jacksonConfiguration;

    public int countSystemAlerts(Date date) {
        QSystemAlert qSystemAlert = QSystemAlert.systemAlert;
        DBQuery<?> dBQuery = this.from(new EntityPath[]{qSystemAlert});
        if (date != null) {
            dBQuery.where((Predicate)qSystemAlert.date.after((Comparable)date));
        }
        return ((DBQuery)dBQuery.where((Predicate)qSystemAlert.removed.isFalse())).count(qSystemAlert.id);
    }

    public int countUserAlerts(Date date) {
        GroupListView groupListView = this.groupsHandler.accessibles().users();
        if (groupListView.isEmpty()) {
            return 0;
        }
        QUserAlert qUserAlert = QUserAlert.userAlert;
        DBQuery<?> dBQuery = this.from(new EntityPath[]{qUserAlert});
        dBQuery.where((Predicate)qUserAlert.user().group().in((Collection)groupListView.items()));
        if (date != null) {
            dBQuery.where((Predicate)qUserAlert.date.after((Comparable)date));
        }
        return ((DBQuery)dBQuery.where((Predicate)qUserAlert.removed.isFalse())).count(qUserAlert.id);
    }

    public SystemAlert create(Network network, SystemAlertType systemAlertType, Object ... objectArray) throws FrameworkException {
        SystemAlert systemAlert = new SystemAlert();
        systemAlert.setNetwork(network);
        systemAlert.setType(systemAlertType);
        this.setArguments(SessionDataFactory.system((Network)network), (Alert)systemAlert, objectArray);
        this.rawEntityManagerHandler.persist((IEntity)systemAlert);
        this.notificationHandler.admin().systemAlert(systemAlert);
        return systemAlert;
    }

    public SystemAlert create(SystemAlertType systemAlertType, Object ... objectArray) {
        SessionData sessionData = this.getSessionData();
        Network network = sessionData.getNetwork();
        if (systemAlertType.getMinMinutes() != null) {
            QSystemAlert qSystemAlert = QSystemAlert.systemAlert;
            Date date = (Date)((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qSystemAlert}).where(new Predicate[]{network == null ? qSystemAlert.network().isNull() : qSystemAlert.network().eq((Object)network), qSystemAlert.type.eq((Object)systemAlertType), qSystemAlert.date.after((Comparable)DateHelper.subtract((Date)new Date(), (TimeField)TimeField.MINUTES, (int)systemAlertType.getMinMinutes()))})).singleResult((Expression)qSystemAlert.date.max());
            if (date != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(String.format("Not creating system alert %s for network %s because there was one at %s", systemAlertType, network == null ? "global" : network.getInternalName(), this.getFormatter().format(date)));
                }
                return null;
            }
        }
        return this.create(network, systemAlertType, objectArray);
    }

    public UserAlert create(User user, UserAlertType userAlertType, Object ... objectArray) {
        UserAlert userAlert = new UserAlert();
        this.setArguments(SessionDataFactory.user((BasicUser)user), (Alert)userAlert, objectArray);
        userAlert.setUser(user);
        userAlert.setType(userAlertType);
        this.persist((IEntity)userAlert);
        this.notificationHandler.admin().userAlert(userAlert);
        return userAlert;
    }

    public SystemAlert custom(String string) {
        return this.create(SystemAlertType.CUSTOM, string);
    }

    public UserAlert custom(User user, String string) {
        return this.create(user, UserAlertType.CUSTOM, string);
    }

    public SystemAlertSearchData getSystemSearchData() throws FrameworkException {
        SystemAlertSearchData systemAlertSearchData = new SystemAlertSearchData();
        systemAlertSearchData.setNetworks(this.networkService.getManagedNetworks());
        SystemAlertQuery systemAlertQuery = (SystemAlertQuery)QueryHelper.newQuery(SystemAlertQuery.class);
        systemAlertSearchData.setQuery((QueryParameters)systemAlertQuery);
        return systemAlertSearchData;
    }

    public UserAlertSearchData getUserSearchData() throws FrameworkException {
        UserAlertSearchData userAlertSearchData = new UserAlertSearchData();
        userAlertSearchData.setGroups(this.groupsHandler.visibles().accessibles().basic().sorted());
        UserAlertQuery userAlertQuery = (UserAlertQuery)QueryHelper.newQuery(UserAlertQuery.class);
        userAlertSearchData.setQuery((QueryParameters)userAlertQuery);
        return userAlertSearchData;
    }

    public Object[] resolveArguments(Alert alert) {
        Object[] objectArray = new Object[]{StringHelper.convertNewLineToBr((String)alert.getArg0()), StringHelper.convertNewLineToBr((String)alert.getArg1()), StringHelper.convertNewLineToBr((String)alert.getArg2()), StringHelper.convertNewLineToBr((String)alert.getArg3()), StringHelper.convertNewLineToBr((String)alert.getArg4())};
        if (alert.getType() == SystemAlertType.ACCOUNT_BALANCE_FIXED) {
            this.fixArgumentsForInconsistentAccounts(objectArray);
        }
        return objectArray;
    }

    public Page<SystemAlertVO> searchSystem(SystemAlertQuery systemAlertQuery) {
        DBQuery dBQuery;
        QSystemAlert qSystemAlert = QSystemAlert.systemAlert;
        SessionData sessionData = this.getSessionData();
        if (sessionData.getNetwork() != null) {
            dBQuery = this.from(new EntityPath[]{qSystemAlert});
        } else {
            dBQuery = this.rawEntityManagerHandler.from(new EntityPath[]{qSystemAlert});
            if (sessionData.isMultiNetworkAdminInGlobalMode()) {
                dBQuery.where((Predicate)qSystemAlert.network().in((Collection)((AdminGroup)this.getLoggedUser().getGroup()).getManagedNetworks()));
            }
            if (QueryHelper.useParameter((Object)systemAlertQuery.getNetwork())) {
                dBQuery.where((Predicate)qSystemAlert.network().eq((Object)((Network)this.conversionHandler.convert(Network.class, (Object)systemAlertQuery.getNetwork()))));
            }
            if (Boolean.TRUE.equals(systemAlertQuery.getOnlyGlobal()) && sessionData.isGlobalAdmin()) {
                dBQuery.where((Predicate)qSystemAlert.network().isNull());
            }
        }
        if (CollectionHelper.isNotEmpty((Iterable)systemAlertQuery.getTypes())) {
            dBQuery.where((Predicate)qSystemAlert.type.in((Collection)systemAlertQuery.getTypes()));
        }
        if (systemAlertQuery.getRemoved() != null) {
            dBQuery.where((Predicate)qSystemAlert.removed.eq(systemAlertQuery.getRemoved()));
        }
        if (QueryHelper.useParameter((Object)systemAlertQuery.getDatePeriod())) {
            dBQuery.where(qSystemAlert.date.period((DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)systemAlertQuery.getDatePeriod())));
        }
        dBQuery.orderBy(qSystemAlert.date.desc());
        return dBQuery.page(SystemAlertVO.class, (QueryParameters)systemAlertQuery, (Expression)qSystemAlert);
    }

    public Page<UserAlertVO> searchUser(UserAlertQuery userAlertQuery) {
        Set set;
        QUserAlert qUserAlert = QUserAlert.userAlert;
        DBQuery<?> dBQuery = this.from(new EntityPath[]{qUserAlert});
        User user = (User)this.conversionHandler.convert(User.class, (Object)userAlertQuery.getUser());
        if (user != null) {
            dBQuery.where((Predicate)qUserAlert.user().eq((Object)user));
        }
        if (!(set = this.groupsHandler.flattenVOs((Collection)userAlertQuery.getGroups())).isEmpty()) {
            dBQuery.where((Predicate)qUserAlert.user().group().in((Collection)set));
        }
        this.visibility(dBQuery, qUserAlert.user()).onlySelf();
        Set set2 = this.conversionHandler.convertSet(User.class, (Iterable)userAlertQuery.getBrokers());
        if (!set2.isEmpty()) {
            dBQuery.where((Predicate)((QUser)qUserAlert.user().brokers.any()).in((Collection)set2));
        }
        if (CollectionHelper.isNotEmpty((Iterable)userAlertQuery.getTypes())) {
            dBQuery.where((Predicate)qUserAlert.type.in((Collection)userAlertQuery.getTypes()));
        }
        if (userAlertQuery.getRemoved() != null) {
            dBQuery.where((Predicate)qUserAlert.removed.eq(userAlertQuery.getRemoved()));
        }
        if (QueryHelper.useParameter((Object)userAlertQuery.getDatePeriod())) {
            dBQuery.where(qUserAlert.date.period((DatePeriod)this.conversionHandler.convert(DatePeriod.class, (Object)userAlertQuery.getDatePeriod())));
        }
        dBQuery.orderBy(qUserAlert.date.desc());
        return dBQuery.page(UserAlertVO.class, (QueryParameters)userAlertQuery, (Expression)qUserAlert);
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(QUserAlert.userAlert.user().network());
        networkPathRegistry.register(QSystemAlert.systemAlert.network());
    }

    private void fixArgumentsForInconsistentAccounts(Object[] objectArray) {
        Object object = objectArray[0];
        objectArray[0] = formatterImpl -> {
            try {
                List list = (List)this.jacksonConfiguration.getObjectMapper().readValue(object.toString(), (TypeReference)new TypeReference<List<InconsistentBalance>>(){});
                if (!list.isEmpty()) {
                    Set set = list.stream().map(InconsistentBalance::getAccountId).collect(Collectors.toSet());
                    QAccount qAccount = QAccount.account;
                    Map<Long, Account> map = ((DBQuery)this.rawEntityManagerHandler.from(new EntityPath[]{qAccount}).leftFetchHint(new Path[]{qAccount, qAccount.user()}).where((Predicate)qAccount.id.in(set))).list((Expression)qAccount).stream().collect(Collectors.toMap(SimpleEntity::getId, account -> account));
                    StringBuilder stringBuilder = new StringBuilder();
                    list.forEach(inconsistentBalance -> {
                        Account account = (Account)map.get(inconsistentBalance.getAccountId());
                        if (account != null) {
                            stringBuilder.append("\n \u2022 ");
                            Currency currency = account.getCurrency();
                            if (account instanceof UserAccount) {
                                stringBuilder.append(formatterImpl.format((AccountOwner)account.getOwner())).append(" (").append(formatterImpl.format((INamedEntity)account.getType())).append(")");
                            } else {
                                stringBuilder.append(formatterImpl.format((INamedEntity)account.getType()));
                            }
                            stringBuilder.append(':');
                            if (!BigDecimalHelper.areEquals((BigDecimal)inconsistentBalance.getActualBalance(), (BigDecimal)inconsistentBalance.getExpectedBalance())) {
                                stringBuilder.append(' ').append(this.translationHandler.message(MessagingKeys.Alerts.SYSTEM_ACCOUNT_BALANCE_FIXED_BALANCE, new Object[]{new CurrencyAmount(currency, inconsistentBalance.getActualBalance()), new CurrencyAmount(currency, inconsistentBalance.getExpectedBalance())}));
                            }
                            if (!BigDecimalHelper.areEquals((BigDecimal)inconsistentBalance.getActualReserved(), (BigDecimal)inconsistentBalance.getExpectedReserved())) {
                                stringBuilder.append(' ').append(this.translationHandler.message(MessagingKeys.Alerts.SYSTEM_ACCOUNT_BALANCE_FIXED_RESERVED, new Object[]{new CurrencyAmount(currency, inconsistentBalance.getActualReserved()), new CurrencyAmount(currency, inconsistentBalance.getExpectedReserved())}));
                            }
                        }
                    });
                    return stringBuilder.toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return object.toString();
        };
    }

    private void setArguments(SessionData sessionData, Alert alert, Object ... objectArray) {
        if (CollectionHelper.isNotEmpty((Object[])objectArray)) {
            this.invokerHandler.runAs(sessionData, () -> {
                FormatterImpl formatterImpl = this.getFormatter();
                block7: for (int i = 0; i < objectArray.length && i < 5; ++i) {
                    Object object = objectArray[i];
                    String string = formatterImpl.format(object);
                    switch (i) {
                        case 0: {
                            alert.setArg0(string);
                            continue block7;
                        }
                        case 1: {
                            alert.setArg1(string);
                            continue block7;
                        }
                        case 2: {
                            alert.setArg2(string);
                            continue block7;
                        }
                        case 3: {
                            alert.setArg3(string);
                            continue block7;
                        }
                        case 4: {
                            alert.setArg4(string);
                        }
                    }
                }
                return null;
            });
        }
        alert.setDate(DateHelper.now());
    }
}

