/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.messaging;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.utils.notifications.CustomNotification;
import org.cyclos.impl.utils.notifications.NotificationHandlerImplementor;
import org.cyclos.impl.utils.tasks.AbstractBackgroundTask;
import org.cyclos.impl.utils.tasks.BackgroundTaskScheduling;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.server.utils.jackson.JacksonConfiguration;
import org.cyclos.utils.MessageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomNotificationSendingBackgroundTask
extends AbstractBackgroundTask {
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private NotificationHandlerImplementor notificationHandler;
    @Autowired
    private JacksonConfiguration jacksonConfiguration;

    public static BackgroundTaskScheduling scheduling(CustomNotification customNotification) {
        String string;
        try {
            string = ((JsonConverter)InvocationContext.bean(JsonConverter.class)).writeValueAsString((Object)customNotification);
        }
        catch (JsonGenerationException | JsonMappingException throwable) {
            throw new IllegalStateException(throwable);
        }
        return new BackgroundTaskScheduling(CustomNotificationSendingBackgroundTask.class, (Object)string, "Send custom notification");
    }

    public MessageKey getMessageKey() {
        return SystemKeys.BackgroundTasks.SEND_CUSTOM_NOTIFICATION;
    }

    @Override
    protected long doExecute(String string, ProfilingEntry profilingEntry) {
        return (Long)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            CustomNotification customNotification;
            try {
                customNotification = (CustomNotification)this.jacksonConfiguration.getObjectMapper().readValue(string, CustomNotification.class);
            }
            catch (JsonProcessingException jsonProcessingException) {
                throw new IllegalStateException(jsonProcessingException);
            }
            this.notificationHandler.notifyCustom(customNotification, true);
            return 1L;
        });
    }
}

