/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.messaging;

import org.cyclos.entities.messaging.ErrorLog;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.system.SystemMonitorServiceLocal;
import org.cyclos.impl.utils.conversion.EntityVOConverter;
import org.cyclos.model.messaging.errorlogs.ErrorLogVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ErrorLogVOConverter
extends EntityVOConverter<ErrorLogVO> {
    @Autowired
    private SystemMonitorServiceLocal systemMonitorService;

    public ErrorLogVOConverter() {
        super(ErrorLogVO.class);
    }

    @Override
    protected void fill(Object object, ErrorLogVO errorLogVO, Object[] objectArray, InvocationContext.ConversionContext conversionContext) {
        super.fill(object, errorLogVO, objectArray, conversionContext);
        if (object instanceof ErrorLog) {
            if (conversionContext.getSessionData().getNetwork() != null) {
                errorLogVO.setNetwork(null);
            }
            ErrorLog errorLog = (ErrorLog)object;
            errorLogVO.setMethod(this.systemMonitorService.formatTask(errorLog.getType(), errorLog.getMethod()));
        }
    }
}

