/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.messaging;

import com.querydsl.core.types.Expression;
import java.util.List;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.messaging.MessageCategory;
import org.cyclos.entities.messaging.QMessageCategory;
import org.cyclos.entities.users.AdminGroup;
import org.cyclos.entities.users.AdminProduct;
import org.cyclos.entities.users.Product;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.messaging.MessageCategoryServiceLocal;
import org.cyclos.impl.users.ProductServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.messaging.messagecategories.MessageCategoryDTO;
import org.cyclos.model.messaging.messagecategories.MessageCategoryData;
import org.cyclos.model.messaging.messagecategories.MessageCategoryVO;
import org.cyclos.model.users.products.AdminProductDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageCategoryServiceImpl
extends CRUDServiceImpl<MessageCategory, QMessageCategory, MessageCategoryDTO, MessageCategoryData, Void>
implements MessageCategoryServiceLocal {
    @Autowired
    private ProductServiceLocal productService;

    public MessageCategoryServiceImpl() {
        super(MessageCategory.class, QMessageCategory.messageCategory, MessageCategoryDTO.class);
    }

    public List<MessageCategory> getAccessible() throws FrameworkException {
        if (this.isAdmin()) {
            return this.getSessionData().getProducts().admin().getSendMessagesFromSysWithCat();
        }
        return this.getSessionData().getProducts().member().getSendMessagesToAdmin();
    }

    public List<MessageCategoryVO> list() {
        return ((DBQuery)this.from().orderBy(((QMessageCategory)this.$).order.asc())).list(MessageCategoryVO.class, (Expression)this.$);
    }

    @Override
    public MessageCategory newEntity(Void void_) {
        return new MessageCategory();
    }

    @Override
    protected void doRemove(MessageCategory messageCategory, boolean bl) {
        this.productService.removeAllRelationships((Property)AdminProductDTO.VIEW_MESSAGES_SENT_TO_SYS_WITH_CAT, (SimpleEntity)messageCategory);
        this.productService.removeAllRelationships((Property)AdminProductDTO.MANAGE_MESSAGES_SENT_TO_SYS_WITH_CAT, (SimpleEntity)messageCategory);
        this.productService.removeAllRelationships((Property)AdminProductDTO.SEND_MESSAGES_FROM_SYS_WITH_CAT, (SimpleEntity)messageCategory);
        super.doRemove(messageCategory, bl);
    }

    @Override
    protected MessageCategoryData getData(MessageCategory messageCategory) {
        MessageCategoryData messageCategoryData = new MessageCategoryData();
        messageCategoryData.setDto((EntityDTO)((MessageCategoryDTO)this.toDTO(messageCategory)));
        return messageCategoryData;
    }

    @Override
    protected void onAfterSave(MessageCategory messageCategory, MessageCategory messageCategory2, Object object) {
        if (messageCategory2 == null && this.isAdmin()) {
            AdminGroup adminGroup = (AdminGroup)this.getSessionData().getGroup();
            AdminProduct adminProduct = adminGroup.getAdminProduct();
            this.productService.createRelationship((Product)adminProduct, (Property)AdminProductDTO.VIEW_MESSAGES_SENT_TO_SYS_WITH_CAT, (SimpleEntity)messageCategory);
            this.productService.createRelationship((Product)adminProduct, (Property)AdminProductDTO.MANAGE_MESSAGES_SENT_TO_SYS_WITH_CAT, (SimpleEntity)messageCategory);
            this.productService.createRelationship((Product)adminProduct, (Property)AdminProductDTO.SEND_MESSAGES_FROM_SYS_WITH_CAT, (SimpleEntity)messageCategory);
        }
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QMessageCategory)this.$).network());
    }

    @Override
    protected Validator resolveValidator(MessageCategoryDTO messageCategoryDTO) {
        Validator validator = new Validator();
        validator.property(MessageCategoryDTO.DESCRIPTION, GeneralKeys.Ui.DESCRIPTION).maxLength(1000);
        return validator;
    }
}

