/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.messaging;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import org.cyclos.entities.SimpleEntity;
import org.cyclos.entities.messaging.MailContext;
import org.cyclos.entities.messaging.Notification;
import org.cyclos.entities.system.Image;
import org.cyclos.entities.system.Language;
import org.cyclos.entities.users.BasicUser;
import org.cyclos.entities.users.User;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.system.ConfigurationAccessor;
import org.cyclos.impl.system.ImageVOConverter;
import org.cyclos.impl.system.ProfilingEntry;
import org.cyclos.impl.utils.LinkGeneratorHandler;
import org.cyclos.impl.utils.appnotifications.AppNotificationHandler;
import org.cyclos.impl.utils.appnotifications.AppNotificationMessage;
import org.cyclos.impl.utils.notifications.FcmNotificationScriptResult;
import org.cyclos.impl.utils.notifications.MailContent;
import org.cyclos.impl.utils.notifications.MailHandler;
import org.cyclos.impl.utils.sms.OutboundSmsHandler;
import org.cyclos.impl.utils.tasks.AbstractBackgroundTask;
import org.cyclos.impl.utils.tasks.BackgroundTaskScheduling;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.contentmanagement.ContentManagementKeys;
import org.cyclos.model.messaging.notifications.INotificationType;
import org.cyclos.model.messaging.notifications.NotificationEntityType;
import org.cyclos.model.messaging.notifications.PersonalNotificationType;
import org.cyclos.model.messaging.sms.OutboundSmsType;
import org.cyclos.model.system.SystemKeys;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.Location;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.jackson.JacksonConfiguration;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.TranslationMessageSpecification;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationSendingBackgroundTask
extends AbstractBackgroundTask {
    public static final String EMAIL = "email";
    public static final String SMS = "sms";
    public static final String APP = "app";
    @Autowired
    private InvokerHandler invokerHandler;
    @Autowired
    private LinkGeneratorHandler linkGenerator;
    @Autowired
    private MailHandler mailHandler;
    @Autowired
    private OutboundSmsHandler outboundSmsHandler;
    @Autowired
    private ApplicationHandler applicationHandler;
    @Autowired
    private AppNotificationHandler appNotificationHandler;
    @Autowired
    private JacksonConfiguration jacksonConfiguration;

    public static BackgroundTaskScheduling scheduling(BasicUser basicUser, Notification notification, List<String> list) {
        String string = notification.getId() + "|" + StringHelper.join(list, (String)",");
        return new BackgroundTaskScheduling(NotificationSendingBackgroundTask.class, (Object)string, "Send notification with id " + notification.getId() + " to " + basicUser.getUsername() + " via " + StringHelper.join(list, (String)", "));
    }

    public MessageKey getMessageKey() {
        return SystemKeys.BackgroundTasks.SEND_NOTIFICATION;
    }

    @Override
    protected long doExecute(String string, ProfilingEntry profilingEntry) {
        List list = StringHelper.splitTrimming((String)string, (String)"|");
        Long l = Long.valueOf((String)list.get(0));
        List list2 = StringHelper.splitTrimming((String)((String)list.get(1)), (String)",");
        return (Long)this.invokerHandler.runAsInTransaction(SessionDataFactory.system(), TransactionLevel.READ_WRITE, transactionStatus -> {
            try {
                Notification notification = this.find(Notification.class, l);
                this.runInEntityNetwork((SimpleEntity)notification, () -> {
                    this.process(notification, list2);
                    return null;
                });
                return 1L;
            }
            catch (EntityNotFoundException entityNotFoundException) {
                return 0L;
            }
        });
    }

    protected void process(Notification notification, List<String> list) {
        if (list.contains(EMAIL)) {
            try {
                this.notifyByEmail(notification);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (list.contains(SMS)) {
            try {
                this.notifyBySms(notification);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (list.contains(APP)) {
            try {
                this.notifyByAppNotification(notification);
            }
            catch (Exception exception) {
                this.getLogger().error("Error sending app notification", (Throwable)exception);
            }
        }
    }

    private AppNotificationMessage.Builder applyAndroidConfig(AppNotificationMessage.Builder builder, FcmNotificationScriptResult fcmNotificationScriptResult) {
        if (StringHelper.isNotBlank((Object)fcmNotificationScriptResult.getAndroidIconColor())) {
            builder.setAndroidIconColor(fcmNotificationScriptResult.getAndroidIconColor());
        }
        return builder;
    }

    private AppNotificationMessage.Builder applyApnsConfig(AppNotificationMessage.Builder builder, FcmNotificationScriptResult fcmNotificationScriptResult) {
        boolean bl = (Boolean)ObjectHelper.defaultValue((Object)fcmNotificationScriptResult.getIosBadge(), (Object)true);
        builder.setIosUseBadge(bl);
        return builder;
    }

    private String getImageUrl(Notification notification) {
        if (notification.getRelatedUser() instanceof User) {
            User user = (User)notification.getRelatedUser();
            ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor((BasicUser)user);
            return user.getImage() == null ? null : StringHelper.removeEnd((String)configurationAccessor.getApiUrl(), (String)"/") + "/images/content/" + ImageVOConverter.getKey((Image)user.getImage());
        }
        return null;
    }

    private String getMobileLinkPart(Notification notification) {
        NotificationEntityType notificationEntityType = notification.getType().getNotificationEntityType();
        Long l = notification.getEntityId();
        String string = String.valueOf(this.applicationHandler.getIdMask().apply(l));
        String string2 = String.valueOf(this.applicationHandler.getIdMask().apply(notification.getId()));
        return notificationEntityType == null ? "/notifications" : String.format("/notifications?notificationId=%s&entityType=%s&entityId=%s", string2, notificationEntityType, string);
    }

    private boolean hasLink(Notification notification) {
        INotificationType iNotificationType = notification.getType();
        return !(iNotificationType instanceof PersonalNotificationType);
    }

    private void notifyByAppNotification(Notification notification) {
        AppNotificationMessage appNotificationMessage = this.toAppNotificationMessage(notification);
        this.appNotificationHandler.notify(appNotificationMessage);
    }

    private void notifyByEmail(Notification notification) {
        BasicUser basicUser = notification.getUser();
        this.mailHandler.send(null, basicUser, MailContext.NOTIFICATION, () -> {
            Object object;
            ConfigurationAccessor configurationAccessor = this.configurationHandler.getAccessor(basicUser);
            Language language = configurationAccessor.getLanguage();
            TranslationMessageSpecification translationMessageSpecification = null;
            if (this.hasLink(notification)) {
                object = (Location)ObjectHelper.defaultValue((Object)notification.getLocation(), (Object)Location.NOTIFICATIONS);
                Long l = notification.getEntityId();
                translationMessageSpecification = new TranslationMessageSpecification(MessageFormat.HTML, ContentManagementKeys.Emails.NOTIFICATION_BODY_LINK, new Object[]{this.linkGenerator.location(object, l, basicUser), this.linkGenerator.mobileRedirect(this.getMobileLinkPart(notification), basicUser)});
            }
            object = this.message(MessageFormat.HTML, language, ContentManagementKeys.Emails.NOTIFICATION_BODY_TEMPLATE, notification.getHtmlText(), translationMessageSpecification);
            return new MailContent(notification.getMailSubject(), (String)object);
        }, new FileInfo[0]);
    }

    private void notifyBySms(Notification notification) {
        BasicUser basicUser = notification.getUser();
        if (PersonalNotificationType.MAX_SMS_PER_MONTH_REACHED.equals((Object)notification.getType())) {
            this.outboundSmsHandler.sendUnrestricted(basicUser, notification.getSms(), OutboundSmsType.MAX_USER_MESSAGES_REACHED);
        } else {
            this.outboundSmsHandler.send(basicUser, notification.getSms(), OutboundSmsType.NOTIFICATION);
        }
    }

    private AppNotificationMessage toAppNotificationMessage(Notification notification) {
        FcmNotificationScriptResult fcmNotificationScriptResult;
        if (StringHelper.isBlank((Object)notification.getFcmConfiguration())) {
            fcmNotificationScriptResult = FcmNotificationScriptResult.empty();
        } else {
            try {
                fcmNotificationScriptResult = (FcmNotificationScriptResult)this.jacksonConfiguration.getObjectMapper().readValue(notification.getFcmConfiguration(), FcmNotificationScriptResult.class);
            }
            catch (JsonProcessingException jsonProcessingException) {
                throw new IllegalStateException(jsonProcessingException);
            }
        }
        AppNotificationMessage.Builder builder = AppNotificationMessage.builder().setTitle(StringHelper.coalesce((String[])new String[]{fcmNotificationScriptResult.getTitle(), notification.getMailSubject()})).setBody(StringHelper.coalesce((String[])new String[]{fcmNotificationScriptResult.getBody(), StringHelper.removeMarkupTags((String)notification.getHtmlText())})).setUser(notification.getUser()).setCustomUrl(this.linkGenerator.mobile(this.getMobileLinkPart(notification))).setImageUrl(StringHelper.coalesce((String[])new String[]{fcmNotificationScriptResult.getImageUrl(), this.getImageUrl(notification)})).setVariables(fcmNotificationScriptResult.getData());
        this.applyAndroidConfig(builder, fcmNotificationScriptResult);
        this.applyApnsConfig(builder, fcmNotificationScriptResult);
        return builder.build();
    }
}

